/**
 * ol-ext - A set of cool extensions for OpenLayers (ol) in node modules structure
 * @description ol3,openlayers,popup,menu,symbol,renderer,filter,canvas,interaction,split,statistic,charts,pie,LayerSwitcher,toolbar,animation
 * @version v4.0.32
 * @author Jean-Marc Viglino
 * @see https://github.com/Viglino/ol-ext#,
 * @license BSD-3-Clause
 */
window.ol&&(ol.ext||(ol.ext={}),ol.legend||(ol.legend={}),ol.particule||(ol.particule={}),ol.ext.imageLoader||(ol.ext.imageLoader={}),ol.ext.input||(ol.ext.input={}),ol.util?ol.util.VERSION||(ol.util.VERSION=ol.VERSION||"6.1.0"):ol.util={VERSION:ol.VERSION||"5.3.0"}),ol.ext.inherits=function(e,t){e.prototype=Object.create(t.prototype),e.prototype.constructor=e},window.ol&&(ol.inherits||(ol.inherits=ol.ext.inherits)),window.NodeList&&!NodeList.prototype.forEach&&(NodeList.prototype.forEach=Array.prototype.forEach),window.Element&&!Element.prototype.remove&&(Element.prototype.remove=function(){this.parentNode&&this.parentNode.removeChild(this)}),ol.ext.Ajax=class extends ol.Object{constructor(e){e=e||{},super(),this._auth=e.auth,this.set("dataType",e.dataType||"JSON")}static get(e){var t=new ol.ext.Ajax(e);e.success&&t.on("success",function(t){e.success(t.response,t)}),e.error&&t.on("error",function(t){e.error(t)}),t.send(e.url,e.data,e.options)}static getCORS(e,t){var i=new XMLHttpRequest;i.open("GET",e,!0),i.send(),i.onreadystatechange=function(){this.readyState==this.HEADERS_RECEIVED&&t(i.getResponseHeader("Access-Control-Allow-Origin"))}}send(e,t,i){var s=this,o=!1!==(i=i||{}).encode;o&&(e=encodeURI(e));var r="";for(var a in t)t.hasOwnProperty(a)&&void 0!==t[a]&&(r+=(r?"&":"?")+a+"="+(o?encodeURIComponent(t[a]):t[a]));this._request&&!1!==i.abort&&this._request.abort();var n=this._request=new XMLHttpRequest;n.open("GET",e+r,!0),i.timeout&&(n.timeout=i.timeout),this._auth&&n.setRequestHeader("Authorization","Basic "+this._auth),this.dispatchEvent({type:"loadstart"}),n.onload=function(){if(s._request=null,s.dispatchEvent({type:"loadend"}),this.status>=200&&this.status<400){var e;try{switch(s.get("dataType")){case"JSON":e=JSON.parse(this.response);break;default:e=this.response}}catch(e){return void s.dispatchEvent({type:"error",status:0,statusText:"parsererror",error:e,options:i,jqXHR:this})}s.dispatchEvent({type:"success",response:e,status:this.status,statusText:this.statusText,options:i,jqXHR:this})}else s.dispatchEvent({type:"error",status:this.status,statusText:this.statusText,options:i,jqXHR:this})},n.ontimeout=function(){s._request=null,s.dispatchEvent({type:"loadend"}),s.dispatchEvent({type:"error",status:this.status,statusText:"Timeout",options:i,jqXHR:this})},n.onerror=function(){s._request=null,s.dispatchEvent({type:"loadend"}),s.dispatchEvent({type:"error",status:this.status,statusText:this.statusText,options:i,jqXHR:this})},n.send()}},ol.ext.SVGFilter=class extends ol.Object{constructor(e){e=e||{},super(),ol.ext.SVGFilter.prototype.svg||(ol.ext.SVGFilter.prototype.svg=document.createElementNS(this.NS,"svg"),ol.ext.SVGFilter.prototype.svg.setAttribute("version","1.1"),ol.ext.SVGFilter.prototype.svg.setAttribute("width",0),ol.ext.SVGFilter.prototype.svg.setAttribute("height",0),ol.ext.SVGFilter.prototype.svg.style.position="absolute",document.body.appendChild(ol.ext.SVGFilter.prototype.svg)),this.element=document.createElementNS(this.NS,"filter"),this._id=e.id||"_ol_SVGFilter_"+ol.ext.SVGFilter.prototype._id++,this.element.setAttribute("id",this._id),e.color&&this.element.setAttribute("color-interpolation-filters",e.color),e.operation&&this.addOperation(e.operation),ol.ext.SVGFilter.prototype.svg.appendChild(this.element)}getId(){return this._id}remove(){this.element.remove()}addOperation(e){e instanceof Array?e.forEach(function(e){this.addOperation(e)}.bind(this)):(e instanceof ol.ext.SVGOperation||(e=new ol.ext.SVGOperation(e)),this.element.appendChild(e.geElement()))}grayscale(e){this.addOperation({feoperation:"feColorMatrix",type:"saturate",values:e||0})}luminanceToAlpha(e){e=e||{},this.addOperation({feoperation:"feColorMatrix",type:"luminanceToAlpha"}),e.gamma&&this.addOperation({feoperation:"feComponentTransfer",operations:[{feoperation:"feFuncA",type:"gamma",amplitude:e.gamma,exponent:1,offset:0}]})}applyTo(e){var t=document.createElement("CANVAS");return t.width=e.naturalWidth||e.width,t.height=e.naturalHeight||e.height,t.getContext("2d").filter="url(#"+this.getId()+")",t.getContext("2d").drawImage(e,0,0),t}},ol.ext.SVGFilter.prototype.NS="http://www.w3.org/2000/svg",ol.ext.SVGFilter.prototype.svg=null,ol.ext.SVGFilter.prototype._id=0,ol.ext.SVGOperation=class extends ol.Object{constructor(e){"string"==typeof e&&(e={feoperation:e}),super(),e&&e.feoperation?(this._name=e.feoperation,this.element=document.createElementNS(ol.ext.SVGOperation.NS||"http://www.w3.org/2000/svg",this._name),this.setProperties(e),e.operations instanceof Array&&this.appendChild(e.operations)):console.error("[SVGOperation]: no operation defined.")}getName(){return this._name}set(e,t){/^feoperation$|^operations$/.test(e)||(super.set(e,t),this.element.setAttribute(e,t))}setProperties(e){for(var t in e=e||{})this.set(t,e[t])}geElement(){return this.element}appendChild(e){e instanceof Array?e.forEach(function(e){this.appendChild(e)}.bind(this)):(e instanceof ol.ext.SVGOperation||(e=new ol.ext.SVGOperation(e)),this.element.appendChild(e.geElement()))}},ol.ext.TextStreamReader=function(e){e=e||{},this.setChunkSize(e.chunkSize),this.setFile(e.file),this.reader_=new FileReader},ol.ext.TextStreamReader.prototype.setFile=function(e){this.file_=e,this.fileSize_=this.file_.size-1,this.rewind()},ol.ext.TextStreamReader.prototype.rewind=function(){this.chunk_=0,this.residue_=""},ol.ext.TextStreamReader.prototype.setChunkSize=function(e){this.chunkSize_=e||1e6},ol.ext.TextStreamReader.prototype.getProgress=function(){return this.chunk_/this.fileSize_},ol.ext.TextStreamReader.prototype.readLines=function(e,t){this.rewind(),this.readChunk(function(i){for(var s=0;s<i.length;s++)if(!1===e(i[s]))return void(t&&t(this.chunk_/this.fileSize_,!0));t&&t(this.chunk_/this.fileSize_,!1),!this.nexChunk_()&&t&&t(1,!0)}.bind(this),t)},ol.ext.TextStreamReader.prototype.readChunk=function(e){this.reader_.onload=function(t){var i=t.target.result.replace(/\r/g,"").split("\n");i[0]=this.residue_+i[0]||"",this.chunk_+=this.chunkSize_,this.chunk_<this.fileSize_?this.residue_=i.pop():this.residue_="",e(i)}.bind(this),this.nexChunk_()},ol.ext.TextStreamReader.prototype.nexChunk_=function(){if(this.chunk_<this.fileSize_){var e=this.file_.slice(this.chunk_,this.chunk_+this.chunkSize_);return this.reader_.readAsText(e),!0}return!1},ol.View.prototype.flyTo&&console.warn("[OL-EXT] ol/View~View.flyTo redefinition"),ol.View.prototype.flyTo=function(e,t){e=e||{},this.cancelAnimations();var i="function"==typeof t?t:function(){},s=e.duration||2e3,o=e.zoomAt||Math.min(e.zoom||100,this.getZoom())-2,r=e.zoom||this.getZoom(),a=e.center||this.getCenter();this.animate({center:a,duration:s,easing:e.easing,anchor:e.anchor,rotation:e.rotation}),this.animate({zoom:o,duration:s/2,easing:e.easing,anchor:e.anchor},{zoom:r,duration:s/2,easing:e.easing,anchor:e.anchor},i)},ol.View.prototype.takeTour=function(e,t){t=t||{};var i=-1,s=function(o){if(o){var r=e[++i];if("function"==typeof t.step&&t.step(i,e),r){r instanceof Array&&(r={center:[r[0],r[1]],zoom:r[2],type:r[3]});var a=0===i?0:t.delay||750;r.easing||(r.easing=t.easing),r.type||(r.type=t.type),setTimeout(function(){switch(r.type){case"moveTo":this.animate(r,s);break;case"flightTo":default:this.flyTo(r,s)}}.bind(this),a)}else"function"==typeof t.done&&t.done(!0)}else"function"==typeof t.done&&t.done(!1)}.bind(this);s(!0)},ol.ext.Worker=class{constructor(e,t){var i=e.toString().replace(/^.*\(/,"function("),s="";for(var o in t.lib)s+="\nvar "+o+" = "+t.lib[o].toString().replace(/^.*\(/,"function(")+";";var r=["var mainFn = "+i+s+'\n    self.addEventListener("message", function(event) {\n      var result = mainFn(event);\n      self.postMessage(result);\n    });'];this.code_=URL.createObjectURL(new Blob(r,{type:"text/javascript"})),this.onMessage_=t.onMessage,this.start()}start(){this.worker&&this.worker.terminate(),this.worker=new Worker(this.code_),this.worker.addEventListener("message",function(e){this.onMessage_(e.data)}.bind(this))}terminate(){this.worker.terminate()}postMessage(e,t){t&&this.start(),this.worker.postMessage(e)}onMessage(e){this.onMessage_=e}},ol.color.toHSL=function(e,t){void 0===t&&(t=100),Array.isArray(e)||(e=ol.color.asArray(e));var i,s,o=e[0]/255,r=e[1]/255,a=e[2]/255,n=Math.max(o,r,a),l=Math.min(o,r,a),h=(n+l)/2;if(n===l)i=s=0;else{var c=n-l;switch(s=h>.5?c/(2-n-l):c/(n+l),n){case o:i=(r-a)/c+(r<a?6:0);break;case r:i=(a-o)/c+2;break;case a:i=(o-r)/c+4}}var u=[Math.round(60*i*t)/t,Math.round(100*s*t)/t,Math.round(100*h*t)/t];return e.length>3&&(u[3]=e[3]),u},ol.color.fromHSL=function(e,t){void 0===t&&(t=1e3);var i,s,o,r=e[0]/360,a=e[1]/100,n=e[2]/100;if(0==a)i=s=o=n;else{var l=function(e,t,i){return i<0&&(i+=1),i>1&&(i-=1),i<1/6?e+6*(t-e)*i:i<.5?t:i<2/3?e+(t-e)*(2/3-i)*6:e},h=n<.5?n*(1+a):n+a-n*a,c=2*n-h;i=l(c,h,r+1/3),s=l(c,h,r),o=l(c,h,r-1/3)}var u=[Math.round(255*i*t)/t,Math.round(255*s*t)/t,Math.round(255*o*t)/t];return e.length>3&&(u[3]=e[3]),u},ol.color.toHSV=function(e,t){void 0===t&&(t=100),Array.isArray(e)||(e=ol.color.asArray(e));var i,s,o=e[0]/255,r=e[1]/255,a=e[2]/255,n=Math.max(o,r,a),l=Math.min(o,r,a),h=n,c=n-l;if(s=0==n?0:c/n,n==l)i=0;else switch(n){case o:i=(r-a)/c+(r<a?6:0);break;case r:i=(a-o)/c+2;break;case a:i=(o-r)/c+4}var u=[Math.round(60*i*t)/t,Math.round(100*s*t)/t,Math.round(100*h*t)/t];return e.length>3&&(u[3]=e[3]),u},ol.color.fromHSV=function(e,t){void 0===t&&(t=1e3);var i,s,o,r=e[0]/360,a=e[1]/100,n=e[2]/100,l=Math.floor(6*r),h=6*r-l,c=n*(1-a),u=n*(1-h*a),d=n*(1-(1-h)*a);switch(l%6){case 0:i=n,s=d,o=c;break;case 1:i=u,s=n,o=c;break;case 2:i=c,s=n,o=d;break;case 3:i=c,s=u,o=n;break;case 4:i=d,s=c,o=n;break;case 5:i=n,s=c,o=u}var p=[Math.round(255*i*t)/t,Math.round(255*s*t)/t,Math.round(255*o*t)/t];return e.length>3&&(p[3]=e[3]),p},ol.color.toHexa=function(e){return"#"+((1<<24)+(e[0]<<16)+(e[1]<<8)+e[2]).toString(16).slice(1)},ol.ext.element={},ol.ext.element.create=function(e,t){var i;if(t=t||{},"TEXT"===e)i=document.createTextNode(t.html||""),t.parent&&t.parent.appendChild(i);else for(var s in i=document.createElement(e),/button/i.test(e)&&i.setAttribute("type","button"),t)switch(s){case"className":t.className&&t.className.trim&&i.setAttribute("class",t.className.trim());break;case"text":i.innerText=t.text;break;case"html":t.html instanceof Element?i.appendChild(t.html):void 0!==t.html&&(i.innerHTML=t.html);break;case"parent":t.parent&&t.parent.appendChild(i);break;case"options":if(/select/i.test(e))for(var o in t.options)ol.ext.element.create("OPTION",{html:o,value:t.options[o],parent:i});break;case"style":ol.ext.element.setStyle(i,t.style);break;case"change":case"click":ol.ext.element.addListener(i,s,t[s]);break;case"on":for(var r in t.on)ol.ext.element.addListener(i,r,t.on[r]);break;case"checked":i.checked=!!t.checked;break;default:i.setAttribute(s,t[s])}return i},ol.ext.element.createSwitch=function(e){var t=ol.ext.element.create("INPUT",{type:"checkbox",on:e.on,click:e.click,change:e.change,parent:e.parent}),i=Object.assign({input:t},e||{});return new ol.ext.input.Switch(i),t},ol.ext.element.createCheck=function(e){var t=ol.ext.element.create("INPUT",{name:e.name,type:"radio"===e.type?"radio":"checkbox",on:e.on,parent:e.parent}),i=Object.assign({input:t},e||{});return"radio"===e.type?new ol.ext.input.Radio(i):new ol.ext.input.Checkbox(i),t},ol.ext.element.setHTML=function(e,t){t instanceof Element?e.appendChild(t):void 0!==t&&(e.innerHTML=t)},ol.ext.element.appendText=function(e,t){e.appendChild(document.createTextNode(t||""))},ol.ext.element.addListener=function(e,t,i,s){"string"==typeof t&&(t=t.split(" ")),t.forEach(function(t){e.addEventListener(t,i,s)})},ol.ext.element.removeListener=function(e,t,i){"string"==typeof t&&(t=t.split(" ")),t.forEach(function(t){e.removeEventListener(t,i)})},ol.ext.element.show=function(e){e.style.display=""},ol.ext.element.hide=function(e){e.style.display="none"},ol.ext.element.hidden=function(e){return"none"===ol.ext.element.getStyle(e,"display")},ol.ext.element.toggle=function(e){e.style.display="none"===e.style.display?"":"none"},ol.ext.element.setStyle=function(e,t){for(var i in t)switch(i){case"top":case"left":case"bottom":case"right":case"minWidth":case"maxWidth":case"width":case"height":"number"==typeof t[i]?e.style[i]=t[i]+"px":e.style[i]=t[i];break;default:e.style[i]=t[i]}},ol.ext.element.getStyle=function(e,t){var i,s=(e.ownerDocument||document).defaultView;if(s&&s.getComputedStyle)t=t.replace(/([A-Z])/g,"-$1").toLowerCase(),i=s.getComputedStyle(e,null).getPropertyValue(t);else if(e.currentStyle&&(t=t.replace(/-(\w)/g,function(e,t){return t.toUpperCase()}),i=e.currentStyle[t],/^\d+(em|pt|%|ex)?$/i.test(i)))return function(t){var i=e.style.left,s=e.runtimeStyle.left;return e.runtimeStyle.left=e.currentStyle.left,e.style.left=t||0,t=e.style.pixelLeft+"px",e.style.left=i,e.runtimeStyle.left=s,t}(i);return/px$/.test(i)?parseInt(i):i},ol.ext.element.outerHeight=function(e){return e.offsetHeight+ol.ext.element.getStyle(e,"marginBottom")},ol.ext.element.outerWidth=function(e){return e.offsetWidth+ol.ext.element.getStyle(e,"marginLeft")},ol.ext.element.offsetRect=function(e){var t=e.getBoundingClientRect();return{top:t.top+(window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop||0),left:t.left+(window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft||0),height:t.height||t.bottom-t.top,width:t.width||t.right-t.left}},ol.ext.element.getFixedOffset=function(e){var t={left:0,top:0},i=function(e){if(!e)return t;if("absolute"===ol.ext.element.getStyle(e,"position")&&"none"!==ol.ext.element.getStyle(e,"transform")){var s=e.getBoundingClientRect();return t.left+=s.left,t.top+=s.top,t}return i(e.offsetParent)};return i(e.offsetParent)},ol.ext.element.positionRect=function(e,t){var i=0,s=0,o=function(r){if(r)return i+=r.offsetLeft,s+=r.offsetTop,o(r.offsetParent);var a={top:e.offsetTop+s,left:e.offsetLeft+i};return t&&(a.top-=window.pageYOffset||document.documentElement.scrollTop||document.body.scrollTop||0,a.left-=window.pageXOffset||document.documentElement.scrollLeft||document.body.scrollLeft||0),a.bottom=a.top+e.offsetHeight,a.right=a.top+e.offsetWidth,a};return o(e.offsetParent)},ol.ext.element.scrollDiv=function(e,t){var i,s,o,r,a,n=!1,l=0,h=0,c="function"==typeof(t=t||{}).onmove?t.onmove:function(){},u=t.vertical?"screenY":"screenX",d=t.vertical?"scrollTop":"scrollLeft",p=!1,g=0,m=function(){a&&(g++,setTimeout(f))},f=function(){if(a){if(--g)return;var t=e.clientHeight,i=e.scrollHeight;s=t/i,a.style.height=100*s+"%",a.style.top=e.scrollTop/i*100+"%",r.style.height=t+"px",t>i-.5?r.classList.add("ol-100pc"):r.classList.remove("ol-100pc")}},v=function(t){t.target.classList.contains("ol-noscroll")||(p=!1,n=t[u],h=new Date,e.classList.add("ol-move"),t.preventDefault(),window.addEventListener("pointermove",y),ol.ext.element.addListener(window,["pointerup","pointercancel"],b))},y=function(t){if(!1!==n){var r=(o?-1/s:1)*(n-t[u]);p=p||Math.round(r),e[d]+=r,(i=new Date)-h&&(l=(l+r/(i-h))/2),n=t[u],h=i,r&&c(!0)}else p=!0},_=function(t){var i=t>0?Math.min(100,t/2):Math.max(-100,t/2);t-=i,e[d]+=i,-1<t&&t<1?(p?setTimeout(function(){e.classList.remove("ol-move")}):e.classList.remove("ol-move"),p=!1,c(!1)):setTimeout(function(){_(t)},40)};if(t.vertical&&t.minibar){var x=function(i){e.removeEventListener("pointermove",x),e.parentNode.classList.add("ol-miniscroll"),a=ol.ext.element.create("DIV"),r=ol.ext.element.create("DIV",{className:"ol-scroll",html:a}),e.parentNode.insertBefore(r,e),a.addEventListener("pointerdown",function(e){o=!0,v(e)}),t.mousewheel&&(ol.ext.element.addListener(r,["mousewheel","DOMMouseScroll","onmousewheel"],function(e){w(e)}),ol.ext.element.addListener(a,["mousewheel","DOMMouseScroll","onmousewheel"],function(e){w(e)})),e.parentNode.addEventListener("pointerenter",m),window.addEventListener("resize",m),!1!==i&&m()};e.parentNode?x(!1):e.addEventListener("pointermove",x),e.addEventListener("scroll",function(){m()})}e.style["touch-action"]="none",e.style.overflow="hidden",e.classList.add("ol-scrolldiv"),ol.ext.element.addListener(e,["pointerdown"],function(e){o=!1,v(e)}),e.addEventListener("click",function(t){e.classList.contains("ol-move")&&(t.preventDefault(),t.stopPropagation())},!0);var b=function(i){(h=new Date-h)>100||o?l=0:h>0&&(l=((l||0)+(n-i[u])/h)/2),_(!1===t.animate?0:200*l),n=!1,l=0,h=0,e.classList.contains("ol-move")?e.classList.remove("ol-hasClick"):(e.classList.add("ol-hasClick"),setTimeout(function(){e.classList.remove("ol-hasClick")},500)),o=!1,window.removeEventListener("pointermove",y),ol.ext.element.removeListener(window,["pointerup","pointercancel"],b)},w=function(t){var i=Math.max(-1,Math.min(1,t.wheelDelta||-t.detail));return e.classList.add("ol-move"),e[d]-=30*i,e.classList.remove("ol-move"),!1};return t.mousewheel&&ol.ext.element.addListener(e,["mousewheel","DOMMouseScroll","onmousewheel"],w),{refresh:m}},ol.ext.element.dispatchEvent=function(e,t){var i;try{i=new CustomEvent(e)}catch(t){(i=document.createEvent("CustomEvent")).initCustomEvent(e,!0,!0,{})}t.dispatchEvent(i)},ol.ext.element.setCursor=function(e,t){e instanceof ol.Map&&(e=e.getTargetElement()),!("ontouchstart"in window)&&e instanceof Element&&(e.style.cursor=t)},ol.ext.getMapCanvas=function(e){if(!e)return null;var t=e.getViewport().getElementsByClassName("ol-fixedoverlay")[0];return t||(e.getViewport().querySelector(".ol-layers")?((t=document.createElement("canvas")).className="ol-fixedoverlay",e.getViewport().querySelector(".ol-layers").after(t),e.on("precompose",function(i){t.width=e.getSize()[0]*i.frameState.pixelRatio,t.height=e.getSize()[1]*i.frameState.pixelRatio})):t=e.getViewport().querySelector("canvas")),t},ol.ext.olVersion=ol.util.VERSION.split("."),ol.ext.olVersion=100*parseInt(ol.ext.olVersion[0])+parseInt(ol.ext.olVersion[1]),ol.ext.getVectorContextStyle=function(e,t){var i=e.frameState.pixelRatio;if(ol.ext.olVersion>605&&ol.ext.olVersion<700&&1!==i&&t.getImage()instanceof ol.style.Icon){var s=(t=t.clone()).getImage();s.setScale(s.getScale()*i);var o=s.getAnchor();if(o&&s.setDisplacement){var r=s.getDisplacement();r&&(r[0]-=o[0]/i,r[1]+=o[1]/i,s.setAnchor([0,0]))}else o&&(o[0]/=i,o[1]/=i)}return t},ol.ext.imageLoader.loadBILImage=function(e,t,i){var s=[parseInt(e.replace(/.*WIDTH=(\d*).*/i,"$1")),parseInt(e.replace(/.*HEIGHT=(\d*).*/i,"$1"))],o=new XMLHttpRequest;o.responseType="blob",o.addEventListener("loadend",function(){var e=this.response;if(void 0!==e){var o=new FileReader;o.addEventListener("loadend",e=>{var i=new Float32Array(e.target.result);t(i,s)}),o.readAsArrayBuffer(e)}else i()}),o.addEventListener("error",function(){i()}),o.open("GET",e),o.send()},ol.ext.imageLoader.loadImage=function(e,t,i){var s=new XMLHttpRequest;s.responseType="blob",s.addEventListener("loadend",function(){var e=this.response;if(void 0!==e){var s=new Image;s.onload=function(){t(s,[s.naturalWidth,s.naturalHeight])},s.src=URL.createObjectURL(e)}else i()}),s.addEventListener("error",function(){i()}),s.open("GET",e),s.send()},ol.ext.imageLoader.pixelTransform=function(e){return function(t,i){ol.ext.imageLoader.loadImage(i,function(i,s){var o=document.createElement("canvas");o.width=s[0],o.height=s[1];var r=o.getContext("2d");r.drawImage(i,0,0);for(var a=r.getImageData(0,0,s[0],s[1]),n=a.data,l=0;l<n.length;l+=4)e(n,l,s);r.putImageData(a,0,0),t.setImage(o)},function(){t.setState(3)})}},ol.ext.imageLoader.grayscale=function(){return ol.ext.imageLoader.pixelTransform(function(e,t){e[t]=e[t+1]=e[t+2]=parseInt(3*e[t]+4*e[t+1]+e[t+2]>>>3)})},ol.ext.imageLoader.transparent=function(e){var t,i;e instanceof Array&&(t=e[0],i=e[1]);var s=t=ol.color.asArray(t);return i?(i=ol.color.asArray(i),s=[Math.min(t[0],i[0]),Math.min(t[1],i[1]),Math.min(t[2],i[2])],i=[Math.max(t[0],i[0]),Math.max(t[1],i[1]),Math.max(t[2],i[2])],ol.ext.imageLoader.pixelTransform(function(e,o){e[o]>=t[0]&&e[o]<=i[0]&&e[o+1]>=s[1]&&e[o+1]<=i[1]&&e[o+2]>=s[2]&&e[o+2]<=i[2]&&(e[o+3]=0)})):ol.ext.imageLoader.pixelTransform(function(e,t){e[t]===s[0]&&e[t+1]===s[1]&&e[t+2]===s[2]&&(e[t+3]=0)})},ol.ext.imageLoader.seaLevelMap=function(e,t){t=t||{};var i=Math.max(e+.01,.01),s=t.color?ol.color.asArray(t.color):[135,203,249],o="number"==typeof t.minValue?t.minValue:-1/0,r=!1!==t.opacity;return ol.ext.imageLoader.elevationMap(function(e){return e<i&&e>o?[s[0],s[1],s[2],r?255*(i-e)/i:255]:[0,0,0,0]})},ol.ext.imageLoader.shadedRelief=function(){var e=Math.PI/4,t=2*Math.PI-Math.PI/4;return function(i,s){ol.ext.imageLoader.loadBILImage(s,function(s,o){var r=document.createElement("canvas"),a=r.getContext("2d"),n=r.width=o[0],l=r.height=o[1],h=a.getImageData(0,0,n,l),c=h.data;function u(e,t){return e+t*n}for(var d=0;d<n;d++)for(var p=0;p<l;p++){var g=u(d,Math.max(0,p-1)),m=u(Math.max(0,d-1),p),f=u(Math.min(n-1,d+1),p),v=u(d,Math.min(l,p+1)),y=s[g],_=s[m],x=(s[f]-_)/3,b=(s[v]-y)/3,w=Math.sqrt(x*x+b*b),S=Math.acos(x/w);0==w&&(S=0);var M=0;x>0?b>0?M=S+1.5*Math.PI:b<0?M=1.5*Math.PI-S:S=1.5*Math.PI:x<0?M=b<0?S+.5*Math.PI:b>0?.5*Math.PI-S:.5*Math.PI:b<0?M=Math.PI:b>0&&(M=0);var C=Math.cos(M-t)*Math.cos(.5*Math.PI-Math.atan(w))*Math.cos(e)+Math.sin(.5*Math.PI-Math.atan(w))*Math.sin(e);C<0&&(C=0),C=Math.sqrt(.8*C+.5);var E=4*u(d,p);c[E]=c[E+1]=c[E+2]=0,c[E+3]=255-255*C}a.putImageData(h,0,0),i.setImage(r)},function(){i.setState(3)})}},ol.ext.imageLoader.elevationMap=function(e){return"function"!=typeof e&&(e=ol.ext.getPixelFromElevation),function(t,i){ol.ext.imageLoader.loadBILImage(i,function(i,s){var o=document.createElement("canvas"),r=o.getContext("2d");o.width=s[0],o.height=s[1];for(var a=r.getImageData(0,0,s[0],s[1]),n=a.data,l=0;l<i.length;l++){var h=e(i[l]);n[4*l]=h[0],n[4*l+1]=h[1],n[4*l+2]=h[2],n[4*l+3]=h[3]}r.putImageData(a,0,0),t.setImage(o)},function(){t.setState(3)})}},ol.ext.getPixelFromElevation=function(e){var t=Math.round(100*e+12e5);return[t>>16,t%65536>>8,t%256,255]},ol.ext.getElevationFromPixel=function(e){return e?.01*((e[0]<<16)+(e[1]<<8)+e[2])-12e3:-12e3},ol.matrix3D={},ol.matrix3D.getTransform=function(e){var t,i,s=window.getComputedStyle(e,null),o=(s.getPropertyValue("-webkit-transform")||s.getPropertyValue("-moz-transform")||s.getPropertyValue("-ms-transform")||s.getPropertyValue("-o-transform")||s.getPropertyValue("transform")).split("(")[1].split(")")[0].split(","),r=[[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]];if(16===o.length)for(t=0;t<4;++t)for(i=0;i<4;++i)r[i][t]=+o[4*t+i];else for(t=0;t<3;++t)for(i=0;i<2;++i)r[i][t]=+o[2*t+i];return r},ol.matrix3D.getTransformOrigin=function(e){for(var t=window.getComputedStyle(e,null),i=(t.getPropertyValue("-webkit-transform-origin")||t.getPropertyValue("-moz-transform-origin")||t.getPropertyValue("-ms-transform-origin")||t.getPropertyValue("-o-transform-origin")||t.getPropertyValue("transform-origin")).split(" "),s=[0,0,0,1],o=0;o<i.length;++o)s[o]=parseInt(i[o]);return s},ol.matrix3D.translateMatrix=function(e,t,i){return[[1,0,0,e],[0,1,0,t],[0,0,1,i],[0,0,0,1]]},ol.matrix3D.identity=function(){return[[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]},ol.matrix3D.roundTo=function(e,t){t||(t=1e-10);for(var i=[[],[],[],[]],s=0;s<4;s++)for(var o=0;o<4;o++)i[s][o]=Math.round(e[s][o]/t)*t;return i},ol.matrix3D.multiply=function(e,t){for(var i=[[],[],[],[]],s=0;s<4;++s)for(var o=0;o<4;++o){for(var r=0,a=0;a<4;++a)r+=e[a][s]*t[o][a];i[o][s]=r}return i},ol.matrix3D.computeTransformMatrix=function(e,t){var i=ol.matrix3D.translateMatrix(-t[0],-t[1],-t[2]),s=ol.matrix3D.translateMatrix(t[0],t[1],t[2]),o=ol.matrix3D.multiply(i,e);return ol.matrix3D.multiply(o,s)},ol.matrix3D.transformVertex=function(e,t){for(var i=[t[0],t[1],0,1],s=[],o=0;o<4;++o){s[o]=0;for(var r=0;r<4;++r)s[o]+=+e[o][r]*i[r]}return s},ol.matrix3D.projectVertex=function(e){for(var t=[],i=0;i<4;++i)t[i]=e[i]/e[3];return t},ol.matrix3D.inverse=function(e){var t=e[0][0]*e[1][1]-e[1][0]*e[0][1],i=e[0][0]*e[1][2]-e[1][0]*e[0][2],s=e[0][0]*e[1][3]-e[1][0]*e[0][3],o=e[0][1]*e[1][2]-e[1][1]*e[0][2],r=e[0][1]*e[1][3]-e[1][1]*e[0][3],a=e[0][2]*e[1][3]-e[1][2]*e[0][3],n=e[2][2]*e[3][3]-e[3][2]*e[2][3],l=e[2][1]*e[3][3]-e[3][1]*e[2][3],h=e[2][1]*e[3][2]-e[3][1]*e[2][2],c=e[2][0]*e[3][3]-e[3][0]*e[2][3],u=e[2][0]*e[3][2]-e[3][0]*e[2][2],d=e[2][0]*e[3][1]-e[3][0]*e[2][1],p=1/(t*n-i*l+s*h+o*c-r*u+a*d);if(isNaN(p)||p===1/0)throw new Error("Inverse determinant attempted to divide by zero.");return[[(e[1][1]*n-e[1][2]*l+e[1][3]*h)*p,(-e[0][1]*n+e[0][2]*l-e[0][3]*h)*p,(e[3][1]*a-e[3][2]*r+e[3][3]*o)*p,(-e[2][1]*a+e[2][2]*r-e[2][3]*o)*p],[(-e[1][0]*n+e[1][2]*c-e[1][3]*u)*p,(e[0][0]*n-e[0][2]*c+e[0][3]*u)*p,(-e[3][0]*a+e[3][2]*s-e[3][3]*i)*p,(e[2][0]*a-e[2][2]*s+e[2][3]*i)*p],[(e[1][0]*l-e[1][1]*c+e[1][3]*d)*p,(-e[0][0]*l+e[0][1]*c-e[0][3]*d)*p,(e[3][0]*r-e[3][1]*s+e[3][3]*t)*p,(-e[2][0]*r+e[2][1]*s-e[2][3]*t)*p],[(-e[1][0]*h+e[1][1]*u-e[1][2]*d)*p,(e[0][0]*h-e[0][1]*u+e[0][2]*d)*p,(-e[3][0]*o+e[3][1]*i-e[3][2]*t)*p,(e[2][0]*o-e[2][1]*i+e[2][2]*t)*p]]},window.ol&&!ol.sphere&&(ol.sphere={},ol.sphere.getDistance=function(e,t,i){return new ol.Sphere(i||6371008.8).haversineDistance(e,t)},ol.sphere.getArea=ol.Sphere.getArea,ol.sphere.getLength=ol.Sphere.getLength),ol.ext.SVGFilter.Laplacian=class extends ol.ext.SVGFilter{constructor(e){super({id:(e=e||{}).id});var t={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,result:"C1"};4===e.neighbours?t.kernelMatrix=[0,-1,0,-1,4,-1,0,-1,0]:t.kernelMatrix=[-1,-1,-1,-1,8,-1,-1,-1,-1],this.addOperation(t),e.grayscale?this.grayscale():e.alpha&&this.luminanceToAlpha({gamma:e.gamma})}},ol.ext.SVGFilter.Paper=class extends ol.ext.SVGFilter{constructor(e){super({id:(e=e||{}).id}),this.addOperation({feoperation:"feTurbulence",numOctaves:4,seed:0,type:"fractalNoise",baseFrequency:.2/(e.scale||1)}),this.addOperation({feoperation:"feDiffuseLighting","lighting-color":"rgb(255,255,255)",surfaceScale:1.5,kernelUnitLength:.01,diffuseConstant:1.1,result:"paper",operations:[{feoperation:"feDistantLight",elevation:e.light||50,azimuth:75}]}),this.addOperation({feoperation:"feBlend",in:"SourceGraphic",in2:"paper",mode:"multiply"})}setLight(e){this.element.querySelector("feDistantLight").setAttribute("elevation",e)}},ol.ext.SVGFilter.Prewitt=class extends ol.ext.SVGFilter{constructor(e){super({id:(e=e||{}).id,color:"sRGB"});var t={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,order:3,kernelMatrix:[-1,-1,-1,0,0,0,1,1,1],result:"V1"};this.addOperation(t),t.kernelMatrix=[1,1,1,0,0,0,-1,-1,-1],t.result="V2",this.addOperation(t),t.kernelMatrix=[-1,0,1,-1,0,1,-1,0,1],t.result="H1",this.addOperation(t),t.kernelMatrix=[1,-0,-1,1,0,-1,1,0,-1],t.result="H2",this.addOperation(t),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"V1",in2:"V2",k2:1,k3:1,result:"V"}),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"H1",in2:"H2",k2:1,k3:1,result:"H"}),this.addOperation({feoperation:"feBlend",mode:"lighten",in:"H",in2:"V"}),e.grayscale?this.grayscale():e.alpha&&this.luminanceToAlpha()}},ol.ext.SVGFilter.Roberts=class extends ol.ext.SVGFilter{constructor(e){super({id:(e=e||{}).id,color:"sRGB"});var t={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,order:3,kernelMatrix:[-1,0,0,0,0,0,0,0,1],result:"V1"};this.addOperation(t),t.kernelMatrix=[1,0,0,0,0,0,0,0,-1],t.result="V2",this.addOperation(t),t.kernelMatrix=[0,0,1,0,0,0,-1,0,0],t.result="H1",this.addOperation(t),t.kernelMatrix=[0,-0,-1,0,0,0,1,0,0],t.result="H2",this.addOperation(t),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"V1",in2:"V2",k2:1,k3:1,result:"V"}),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"H1",in2:"H2",k2:1,k3:1,result:"H"}),this.addOperation({feoperation:"feBlend",mode:"lighten",in:"H",in2:"V"}),e.grayscale?this.grayscale():e.alpha&&this.luminanceToAlpha()}},ol.ext.SVGFilter.Sobel=class extends ol.ext.SVGFilter{constructor(e){super({id:(e=e||{}).id,color:"sRGB"});var t={feoperation:"feConvolveMatrix",in:"SourceGraphic",preserveAlpha:!0,order:3,kernelMatrix:[-1,-2,-1,0,0,0,1,2,1],result:"V1"};this.addOperation(t),t.kernelMatrix=[1,2,1,0,0,0,-1,-2,-1],t.result="V2",this.addOperation(t),t.kernelMatrix=[-1,0,1,-2,0,2,-1,0,1],t.result="H1",this.addOperation(t),t.kernelMatrix=[1,-0,-1,2,0,-2,1,0,-1],t.result="H2",this.addOperation(t),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"V1",in2:"V2",k2:1,k3:1,result:"V"}),this.addOperation({feoperation:"feComposite",operator:"arithmetic",in:"H1",in2:"H2",k2:1,k3:1,result:"H"}),this.addOperation({feoperation:"feBlend",mode:"lighten",in:"H",in2:"V"}),e.grayscale?this.grayscale():e.alpha&&this.luminanceToAlpha({gamma:e.gamma})}},ol.ext.input.Base=class extends ol.Object{constructor(e){e=e||{},super();var t,i=this.input=e.input;i||(i=this.input=document.createElement("INPUT"),e.type&&i.setAttribute("type",e.type),void 0!==e.min&&i.setAttribute("min",e.min),void 0!==e.max&&i.setAttribute("max",e.max),void 0!==e.step&&i.setAttribute("step",e.step),e.parent&&e.parent.appendChild(i)),e.disabled&&(i.disabled=!0),void 0!==e.checked&&(i.checked=!!e.checked),void 0!==e.val&&(i.value=e.val),e.hidden&&i.classList.add("ol-input-hidden"),i.addEventListener("focus",function(){this.element&&this.element.classList.add("ol-focus")}.bind(this)),i.addEventListener("focusout",function(){this.element&&(t&&clearTimeout(t),t=setTimeout(function(){this.element.classList.remove("ol-focus")}.bind(this),0))}.bind(this))}_listenDrag(e,t){var i=function(i){this.moving=!0,this.element.classList.add("ol-moving");var s=function(i){"pointerup"===i.type&&(document.removeEventListener("pointermove",s),document.removeEventListener("pointerup",s),document.removeEventListener("pointercancel",s),setTimeout(function(){this.moving=!1,this.element.classList.remove("ol-moving")}.bind(this))),i.target===e&&t(i),i.stopPropagation(),i.preventDefault()}.bind(this);document.addEventListener("pointermove",s,!1),document.addEventListener("pointerup",s,!1),document.addEventListener("pointercancel",s,!1),i.stopPropagation(),i.preventDefault()}.bind(this);e.addEventListener("mousedown",i,!1),e.addEventListener("touchstart",i,!1)}setValue(e){void 0!==e&&(this.input.value=e),this.input.dispatchEvent(new Event("change"))}getValue(){return this.input.value}getInputElement(){return this.input}},ol.ext.input.Slider=class extends ol.ext.input.Base{constructor(e){super(e=e||{}),this.set("overflow",!!e.overflow),this.element=ol.ext.element.create("DIV",{className:"ol-input-slider"+(!1!==e.hover?" ol-hover":"")+(e.type?" ol-"+e.type:"")+(e.className?" "+e.className:"")}),e.fixed&&this.element.classList.add("ol-fixed");var t=this.input;t.parentNode&&t.parentNode.insertBefore(this.element,t),this.element.appendChild(t),"right"===e.align&&this.element.classList.add("ol-right");var i=ol.ext.element.create("DIV",{className:"ol-popup",parent:this.element});e.before&&ol.ext.element.create("DIV",{className:"ol-before",html:e.before,parent:i});var s=this.slider=ol.ext.element.create("DIV",{className:"ol-slider",parent:i});ol.ext.element.create("DIV",{className:"ol-back",parent:this.slider});var o=ol.ext.element.create("DIV",{className:"ol-cursor",parent:s});e.after&&ol.ext.element.create("DIV",{className:"ol-after",html:e.after,parent:i});var r=void 0!==e.min?e.min:parseFloat(t.min)||0,a=void 0!==e.max?e.max:parseFloat(t.max)||1,n=1/(void 0!==e.step?e.step:parseFloat(t.step)||1);this._listenDrag(s,function(e){var i=Math.max(0,Math.min(e.offsetX/s.clientWidth,1));o.style.left=Math.max(0,Math.min(100,Math.round(100*i)))+"%";var l=t.value=Math.round((i*(a-r)+r)*n)/n;t.focus(),this.dispatchEvent({type:"change:value",value:l})}.bind(this));var l=function(){var e=parseFloat(t.value)||0;this.get("overflow")||(e=Math.max(r,Math.min(a,e))),e!=t.value&&(t.value=e);var i=(e-r)/(a-r);o.style.left=Math.max(0,Math.min(100,Math.round(100*i)))+"%",this.dispatchEvent({type:"change:value",value:e})}.bind(this);t.addEventListener("change",l),l()}},ol.ext.input.PopupBase=class extends ol.ext.input.Base{constructor(e){switch((e=e||{}).hidden=!1!==e.hidden,super(e),this.set("autoClose",!1!==e.autoClose),this.element=ol.ext.element.create("DIV",{className:("ol-ext-popup-input "+(e.className||"")).trim(),tabindex:0,on:{keydown:function(e){this._handleKey(e)}.bind(this)}}),e.position){case"inline":break;case"static":case"fixed":this.element.classList.add("ol-popup"),this.element.classList.add("ol-popup-fixed"),this._fixed="fixed"===e.position;break;default:this.element.classList.add("ol-popup")}var t=this.input;t.parentNode&&t.parentNode.insertBefore(this.element,t),this.element.addEventListener("click",function(){this.isCollapsed()&&setTimeout(function(){this.collapse(!1)}.bind(this))}.bind(this)),this._elt={},this._elt.popup=ol.ext.element.create("DIV",{className:"ol-popup",parent:this.element}),this._elt.popup.addEventListener("click",function(e){e.stopPropagation()});var i=!1;this._elt.popup.addEventListener("pointerdown",function(){i=!0}),this._elt.popup.addEventListener("click",function(){i=!1}),document.addEventListener("click",function(){this.moving||i||this.collapse(!0),i=!1}.bind(this)),window.addEventListener("resize",function(){this.collapse(!0)}.bind(this))}_handleKey(e){switch(e.key){case"Enter":case" ":case"Space":e.stopPropagation(),e.preventDefault(),this.toggle();break;case"Escape":e.stopPropagation(),e.preventDefault(),this.collapse(!0)}}collapse(e){if(e!=this.isCollapsed()&&this.dispatchEvent({type:"change:visible",visible:!this.isCollapsed()}),this.dispatchEvent({type:"collapse",visible:!e}),e)this._elt.popup.classList.remove("ol-visible");else if(this._elt.popup.classList.add("ol-visible"),this._fixed){var t=this.element.getBoundingClientRect(),i=ol.ext.element.getFixedOffset(this.element);(t={bottom:t.bottom-i.top,left:t.left-i.left}).bottom+this._elt.popup.offsetHeight+i.top>document.documentElement.clientHeight?this._elt.popup.style.top=Math.max(document.documentElement.clientHeight-this._elt.popup.offsetHeight-i.top,0)+"px":this._elt.popup.style.top=t.bottom+"px",t.left+this._elt.popup.offsetWidth+i.left>document.documentElement.clientWidth?this._elt.popup.style.left=Math.max(document.documentElement.clientWidth-this._elt.popup.offsetWidth-i.left,0)+"px":this._elt.popup.style.left=t.left+"px"}}isCollapsed(){return!this._elt.popup.classList.contains("ol-visible")}toggle(){this.collapse(!this.isCollapsed())}},ol.ext.input.Checkbox=class extends ol.ext.input.Base{constructor(e){super(e=e||{});var t=this.element=document.createElement("LABEL");e.html instanceof Element?t.appendChild(e.html):void 0!==e.html&&(t.innerHTML=e.html),t.className=("ol-ext-check ol-ext-checkbox "+(e.className||"")).trim(),this.input.parentNode&&this.input.parentNode.insertBefore(t,this.input),t.appendChild(this.input),t.appendChild(document.createElement("SPAN")),e.after&&t.appendChild(document.createTextNode(e.after)),this.input.addEventListener("change",function(){this.dispatchEvent({type:"check",checked:this.input.checked,value:this.input.value})}.bind(this))}isChecked(){return this.input.checked}},ol.ext.input.Collection=class extends ol.Object{constructor(e){super(),this.element=ol.ext.element.create("UL",{className:("ol-collection-list "+(e.className||"")).trim(),parent:e.target}),this._title="function"==typeof e.getTitle?e.getTitle:function(e){return e.title},this.setCollection(e.collection)}removeCollection(){this.collection&&(this.collection.un("change:length",this._update),this.collection=null)}setCollection(e){this.removeCollection(),this.collection=e,this.refresh(),this.collection&&(this._update=function(){if(!this._reorder){this.refresh();var e=this.getSelectPosition();e<0?this.dispatchEvent({type:"item:select",position:-1,item:null}):this.dispatchEvent({type:"item:order",position:e,item:this._currentItem})}}.bind(this),this.collection.on("change:length",this._update))}select(e){if(e!==this._currentItem){var t=-1;this._listElt.forEach(function(i,s){i.item!==e?i.li.classList.remove("ol-select"):(i.li.classList.add("ol-select"),t=s)}),this._currentItem=t>=0?e:null,this.dispatchEvent({type:"item:select",position:t,item:this._currentItem})}}selectAt(e){this.select(this.collection.item(e))}getSelect(){return this._currentItem}getSelectPosition(){return this.collection?this.collection.getArray().indexOf(this._currentItem):-1}refresh(e){this.element.innerHTML="",this._listElt=[],this.collection&&this.collection.forEach((t,i)=>{var s=ol.ext.element.create("LI",{html:this._title(t),className:this._currentItem===t?"ol-select":"","data-position":i,on:{click:function(){this.select(t)}.bind(this),dblclick:function(){this.dispatchEvent({type:"item:dblclick",position:i,item:t})}.bind(this)},parent:this.element}),o=ol.ext.element.create("INPUT",{"aria-label":this._title(t),type:"checkbox",className:"ol-input-focus",on:{keydown:function(e){switch(e.key){case"ArrowUp":case"ArrowDown":if(e.ctrlKey){e.preventDefault(),e.stopPropagation(),this.select(t);var s="ArrowUp"===e.key?i-1:i+1;s>=0&&s<this.collection.getLength()&&(this._reorder=!0,this.collection.removeAt(i),this.collection.insertAt(s,t),this._reorder=!1,this.dispatchEvent({type:"item:order",position:s,oldPosition:i,item:t}),this.refresh(t))}break;case" ":case"Space":e.preventDefault(),e.stopPropagation(),this.select(t);break;case"Tab":break;default:this.dispatchEvent({type:"item:keydown",key:e.key,originalEvent:e,position:i,item:t})}}.bind(this)},parent:s});e===t&&o.focus(),this._listElt.push({li:s,item:t});var r=ol.ext.element.create("DIV",{className:"ol-noscroll ol-order",parent:s}),a=i,n=function(e){for(var t="touch"===e.pointerType?document.elementFromPoint(e.clientX,e.clientY):e.target;t&&t.parentNode!==this.element;)t=t.parentNode;if(t&&t!==s){var i=parseInt(t.getAttribute("data-position"));t.getAttribute("data-position")<a?(t.insertAdjacentElement("beforebegin",s),a=i):(t.insertAdjacentElement("afterend",s),a=i+1)}}.bind(this),l=function(){document.removeEventListener("pointermove",n),document.removeEventListener("pointerup",l),document.removeEventListener("pointercancel",l),a!==i&&(this._reorder=!0,this.collection.removeAt(i),this.collection.insertAt(a>i?a-1:a,t),this._reorder=!1,this.dispatchEvent({type:"item:order",position:a>i?a-1:a,oldPosition:i,item:t}),this.refresh())}.bind(this);r.addEventListener("pointerdown",function(){this.select(t),document.addEventListener("pointermove",n),document.addEventListener("pointerup",l),document.addEventListener("pointercancel",l)}.bind(this))})}},ol.ext.input.Color=class extends ol.ext.input.PopupBase{constructor(e){(e=e||{}).hidden=!1!==e.hidden,e.className=("ol-ext-colorpicker "+(e.hastab?"ol-tab ":"")+(e.className||"")).trim(),super(e),this.input.disabled=!0,!1===e.opacity&&this.element.classList.add("ol-nopacity"),this.element.addEventListener("keydown",function(e){e.target===this.element&&this._handleColorByKey(e.key)&&(this.element.classList.remove("ol-picker-tab"),e.preventDefault(),e.stopPropagation())}.bind(this)),this._cursor={};var t=this._hsv={};this._elt.vignet=ol.ext.element.create("DIV",{className:"ol-vignet",parent:this.element});var i=ol.ext.element.create("DIV",{className:"ol-tabbar",parent:this._elt.popup});ol.ext.element.create("DIV",{className:"ol-tab",html:e.paletteLabel||"palette",tabindex:0,on:{keydown:function(e){this._handlePickerKey(e,"palette")}.bind(this),focus:function(){this.element.classList.remove("ol-picker-tab")}.bind(this)},parent:i}),ol.ext.element.create("DIV",{className:"ol-tab",html:e.pickerLabel||"picker",tabindex:0,on:{keydown:function(e){this._handlePickerKey(e,"picker")}.bind(this),focus:function(){this.element.classList.add("ol-picker-tab")}.bind(this)},parent:i});var s=ol.ext.element.create("DIV",{className:"ol-container",parent:this._elt.popup}),o=this._elt.picker=ol.ext.element.create("DIV",{className:"ol-picker",parent:s}),r=this._cursor.picker=ol.ext.element.create("DIV",{className:"ol-cursor",parent:o});this._listenDrag(o,function(e){var i=Math.max(0,Math.min(e.offsetX/o.clientWidth,1)),s=Math.max(0,Math.min(e.offsetY/o.clientHeight,1));r.style.left=Math.round(100*i)+"%",r.style.top=Math.round(100*s)+"%",t.s=100*i,t.v=100-100*s,this.setColor()}.bind(this));var a=ol.ext.element.create("DIV",{className:"ol-slider",parent:s});this._elt.slider=ol.ext.element.create("DIV",{parent:a});var n=this._cursor.slide=ol.ext.element.create("DIV",{className:"ol-cursor",parent:a});this._listenDrag(a,function(e){var i=Math.max(0,Math.min(e.offsetX/a.clientWidth,1));t.a=100*i,n.style.left=Math.round(100*i)+"%",this.setColor()}.bind(this));var l=ol.ext.element.create("DIV",{className:"ol-tint",parent:s}),h=this._cursor.tint=ol.ext.element.create("DIV",{className:"ol-cursor",parent:l});this._listenDrag(l,function(e){var i=Math.max(0,Math.min(e.offsetY/l.clientHeight,1));t.h=360*i,h.style.top=Math.round(100*i)+"%",this.setColor()}.bind(this)),ol.ext.element.create("DIV",{className:"ol-clear",click:function(){this.setColor([0,0,0,0])}.bind(this),parent:s});var c,u=ol.ext.element.create("DIV",{className:"ol-rgb",parent:s}),d=function(){var e=Math.max(0,Math.min(255,parseInt(this._elt.r.value))),t=Math.max(0,Math.min(255,parseInt(this._elt.g.value))),i=Math.max(0,Math.min(255,parseInt(this._elt.b.value))),s=Math.max(0,Math.min(1,parseFloat(this._elt.a.value)));this.setColor([e,t,i,s])}.bind(this);for(this._elt.r=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:d,min:0,max:255,parent:u}),this._elt.g=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:d,min:0,max:255,parent:u}),this._elt.b=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:d,min:0,max:255,parent:u}),this._elt.a=ol.ext.element.create("INPUT",{type:"number",lang:"en-GB",change:d,min:0,max:1,step:.1,parent:u}),this._elt.txtColor=ol.ext.element.create("INPUT",{type:"text",className:"ol-txt-color",change:function(){var e;this._elt.txtColor.classList.remove("ol-error");try{e=ol.color.asArray(this._elt.txtColor.value)}catch(e){this._elt.txtColor.classList.add("ol-error")}e&&this.setColor(e)}.bind(this),parent:s}),ol.ext.element.create("BUTTON",{html:"OK",click:function(){this._addCustomColor(this.getColor()),this.collapse(!0)}.bind(this),on:{keydown:function(e){"Tab"===e.key&&this.collapse(!0)}.bind(this)},parent:s}),this._paletteColor={},this._elt.palette=ol.ext.element.create("DIV",{className:"ol-palette",parent:this._elt.popup}),c=0;c<8;c++){var p=Math.round(255-255*c/7);this.addPaletteColor([p,p,p],p)}var g=["#f00","#f90","#ff0","#0f0","#0ff","#48e","#00f","#f0f"];for(g.forEach(function(e){this.addPaletteColor(e,ol.color.toHexa(ol.color.asArray(e)))}.bind(this)),c=0;c<5;c++)g.forEach(function(e){e=[(e=ol.color.toHSV(ol.color.asArray(e)))[0],c/4*80+20,100-c/4*60],e=ol.color.fromHSV(e,1),this.addPaletteColor(e,ol.color.toHexa(e))}.bind(this));(ol.ext.element.create("HR",{parent:this._elt.palette}),ol.ext.input.Color.customColorList)||(ol.ext.input.Color.customColorList=new ol.Collection,JSON.parse(localStorage.getItem("ol-ext@colorpicker")||"[]").forEach(function(e){ol.ext.input.Color.customColorList.push(e)}),ol.ext.input.Color.customColorList.on(["add","remove"],function(){localStorage.setItem("ol-ext@colorpicker",JSON.stringify(ol.ext.input.Color.customColorList.getArray()))}));ol.ext.input.Color.customColorList.on("add",function(e){this.addPaletteColor(this.getColorFromID(e.element))}.bind(this)),ol.ext.input.Color.customColorList.on("remove",function(e){this._paletteColor[e.element]&&this._paletteColor[e.element].element.remove(),delete this._paletteColor[e.element]}.bind(this)),ol.ext.input.Color.customColorList.forEach(function(e){this._addCustomColor(this.getColorFromID(e))}.bind(this)),this.setColor(e.color||[0,0,0,0]),this._currentColor=this.getColorID(this.getColor()),this.on("color",function(){this._addCustomColor(this.getColor()),this._currentColor=this.getColorID(this.getColor()),this.setColor()}.bind(this)),this.on("collapse",function(e){if(e.visible)this._currentColor=this.getColorID(this.getColor());else{var t=this.getColor();this._currentColor!==this.getColorID(t)&&this.dispatchEvent({type:"color",color:t})}}.bind(this))}_handleColorByKey(e){if("0"===e&&!this.element.classList.contains("ol-nopacity"))return this.setColor([0,0,0,0]),!0;if(!/^Arrow/.test(e))return!1;var t=0,i=[];switch(Object.keys(this._paletteColor).forEach(function(e){var s=this._paletteColor[e];s.element.classList.contains("ol-select")&&(t=i.length),this.element.classList.contains("ol-nopacity")&&s.element.classList.contains("ol-alpha")||i.push(s)}.bind(this)),e){case"ArrowRight":t+=1;break;case"ArrowLeft":t-=1;break;case"ArrowUp":t-=8;break;case"ArrowDown":t+=8}return i[t]&&(this._selectPalette(i[t].color),this.setColor(i[t].color)),!0}_handlePickerKey(e,t){if("Tab"!==e.key)switch(e.stopPropagation(),e.preventDefault(),e.key){case"Enter":case" ":case"Space":"palette"===t?this.element.classList.remove("ol-picker-tab"):this.element.classList.add("ol-picker-tab");break;case"ArrowRight":case"ArrowLeft":case"ArrowUp":case"ArrowDown":"palette"===t&&this._handleColorByKey(e.key);break;case"Escape":this.collapse(!0)}}addPaletteColor(e,t,i){try{e=ol.color.asArray(e)}catch(e){return}var s=this.getColorID(e);!this._paletteColor[s]&&e[3]&&(this._paletteColor[s]={color:e,element:ol.ext.element.create("DIV",{title:t||"",className:e[3]<1?"ol-alpha":"",style:{color:"rgb("+e.join(",")+")"},click:function(){this.setColor(e),this.get("autoClose")&&this.collapse(!0)}.bind(this),parent:this._elt.palette})}),i&&this._selectPalette(e)}showTab(e){"palette"===e?this.element.classList.remove("ol-picker-tab"):this.element.classList.add("ol-picker-tab")}getTab(){return this.element.classList.contains("ol-picker-tab")?"picker":"palette"}_selectPalette(e){var t=this.getColorID(e);Object.keys(this._paletteColor).forEach(function(e){this._paletteColor[e].element.classList.remove("ol-select")}.bind(this)),this._paletteColor[t]&&this._paletteColor[t].element.classList.add("ol-select")}setColor(e){var t=this._hsv;if(e){e=ol.color.asArray(e);var i=ol.color.toHSV(e);t.h=i[0],t.s=i[1],t.v=i[2],i.length>3?t.a=100*i[3]:t.a=100,this._cursor.picker.style.left=t.s+"%",this._cursor.picker.style.top=100-t.v+"%",this._cursor.tint.style.top=t.h/360*100+"%",this._cursor.slide.style.left=t.a+"%",this.isCollapsed()&&this.dispatchEvent({type:"color",color:e})}else t.a=Math.round(t.a),e=this.getColor();var s="rgba("+e.join(", ")+")";this._elt.picker.style.color="hsl("+t.h+", 100%, 50%)",this._elt.slider.style.backgroundImage="linear-gradient(45deg, transparent, rgba("+this.getColor(!1).join(",")+"))",this._elt.vignet.style.color=s,this._elt.r.value=e[0],this._elt.g.value=e[1],this._elt.b.value=e[2],this._elt.a.value=e[3],this._elt.txtColor.classList.remove("ol-error"),1===e[3]?this._elt.txtColor.value=ol.color.toHexa(e):this._elt.txtColor.value=s,this._selectPalette(e),this.input.value!==s&&(this.input.value=s,this.input.dispatchEvent(new Event("change")))}getColor(e){return ol.color.fromHSV([this._hsv.h,this._hsv.s,this._hsv.v,!1!==e?this._hsv.a/100:1],1)}_addCustomColor(e){var t=this.getColorID(e);this._paletteColor[t]||e[3]&&(ol.ext.input.Color.customColorList.getArray().indexOf(t)<0&&(ol.ext.input.Color.customColorList.push(t),ol.ext.input.Color.customColorList.getLength()>24&&ol.ext.input.Color.customColorList.removeAt(0)),this.addPaletteColor(e))}clearCustomColor(){ol.ext.input.Color.customColorList.clear()}getColorID(e){return void 0===(e=ol.color.asArray(e))[3]&&(e[3]=1),e.join("-")}getColorFromID(e){var t=e.split("-");return[parseFloat(t[0]),parseFloat(t[1]),parseFloat(t[2]),parseFloat(t[3])]}},ol.ext.input.Color.customColorList=null,ol.ext.input.List=class extends ol.ext.input.Base{constructor(e){switch(super(e=e||{}),this._content=ol.ext.element.create("DIV"),(e.hidden||e.disabled)&&(e.hover=!0),this.element=ol.ext.element.create("DIV",{html:this._content,className:"ol-input-popup"+(e.hover?" ol-hover":"")}),this.set("hideOnClick",!1!==e.hideOnClick),e.className&&this.element.classList.add(e.className),e.fixed&&(this.element.classList.add("ol-fixed"),this.set("hideOnClick",!1)),e.align){case"middle":this.set("hideOnClick",!1);case"rigth":this.element.classList.add("ol-"+e.align)}var t=this.input;t.parentNode&&t.parentNode.insertBefore(this.element,t),this.element.appendChild(t);var i=this.popup=ol.ext.element.create("UL",{className:"ol-popup",parent:this.element}),s=[];e.options.forEach(e=>{s.push({value:e.value,element:ol.ext.element.create("LI",{html:e.html,title:e.title||e.value,className:"ol-option",on:{pointerdown:function(){this.setValue(e.value),this.get("hideOnClick")&&(i.style.display="none",setTimeout(function(){i.style.display=""},200))}.bind(this)},parent:this.popup})})}),this.input.addEventListener("change",function(){var e,t=this.input.value;s.forEach(function(i){i.value==t?(i.element.classList.add("ol-selected"),e=i.element):i.element.classList.remove("ol-selected")}),this.dispatchEvent({type:"change:value",value:this.getValue()}),this._content.innerHTML=e?e.innerHTML:""}.bind(this));var o=new Event("change");setTimeout(function(){this.input.dispatchEvent(o)}.bind(this))}},ol.ext.input.Radio=class extends ol.ext.input.Checkbox{constructor(e){super(e=e||{}),this.element.className=("ol-ext-check ol-ext-radio "+(e.className||"")).trim()}},ol.ext.input.Range=class extends ol.ext.input.Base{constructor(e){super(e=e||{}),this.set("overflow",!!e.overflow),this.element=ol.ext.element.create("DIV",{className:"ol-input-slider ol-input-range"+(e.className?" "+e.className:"")});var t=this.input;t.parentNode&&t.parentNode.insertBefore(this.element,t),this.element.appendChild(t);var i=this.slider=ol.ext.element.create("DIV",{className:"ol-slider",parent:this.element}),s=ol.ext.element.create("DIV",{className:"ol-back",parent:this.slider}),o=this.input2=e.input2;o&&this.element.appendChild(o);var r=ol.ext.element.create("DIV",{className:"ol-cursor",parent:i}),a=ol.ext.element.create("DIV",{className:"ol-cursor",parent:o?i:void 0}),n=r;function l(e){n=e.target}r.addEventListener("mousedown",l,!1),r.addEventListener("touchstart",l,!1),a.addEventListener("mousedown",l,!1),a.addEventListener("touchstart",l,!1);var h=void 0!==e.min?e.min:parseFloat(t.min)||0,c=void 0!==e.max?e.max:parseFloat(t.max)||1,u=1/(void 0!==e.step?e.step:parseFloat(t.step)||1);function d(){if(o){var e=parseFloat(r.style.left)||0,t=parseFloat(a.style.left)||0;s.style.left=Math.min(e,t)+"%",s.style.right=100-Math.max(e,t)+"%"}else s.style.left=0,s.style.right=(100-parseFloat(r.style.left)||0)+"%"}function p(){if(o&&parseFloat(t.value)>parseFloat(o.value)){var e=t.value;t.value=o.value,o.value=e,g({target:t}),o&&g({target:o})}}this._listenDrag(i,function(e){var s=n===r?t:o,a=Math.max(0,Math.min(e.offsetX/i.clientWidth,1));n.style.left=Math.max(0,Math.min(100,Math.round(100*a)))+"%";var l=s.value=Math.round((a*(c-h)+h)*u)/u;d(),this.dispatchEvent({type:"change:value",value:l}),"pointerup"===e.type&&p()}.bind(this));var g=function(e){var i=e.target,s=i===t?r:a,o=parseFloat(i.value)||0;this.get("overflow")||(o=Math.max(h,Math.min(c,o))),o!=i.value&&(i.value=o);var n=(o-h)/(c-h);s.style.left=Math.max(0,Math.min(100,Math.round(100*n)))+"%",d(),this.dispatchEvent({type:"change:value",value:o}),p()}.bind(this);t.addEventListener("change",g),o&&o.addEventListener("change",g),g({target:t}),o&&g({target:o})}setValue2(e){this.input2&&(void 0!==e&&(this.input2.value=e),this.input2.dispatchEvent(new Event("change")))}getValue2(){return this.input2?this.input2.value:null}getMin(){return Math.min(parseFloat(this.getValue()),parseFloat(this.getValue2()))}getMax(){return Math.max(parseFloat(this.getValue()),parseFloat(this.getValue2()))}},ol.ext.input.Size=class extends ol.ext.input.List{constructor(e){(e=e||{}).options=[],(e.size||[0,2,3,5,8,13,21,34,55]).forEach(function(t){e.options.push({value:t,html:ol.ext.element.create("DIV",{className:"ol-option-"+t,style:{fontSize:t?t+"px":void 0}})})}),super(e),this._content.remove(),this.element.classList.add("ol-size")}getValue(){return parseFloat(super.getValue())}},ol.ext.input.Switch=class extends ol.ext.input.Checkbox{constructor(e){super(e=e||{}),this.element.className=("ol-ext-toggle-switch "+(e.className||"")).trim()}},ol.ext.input.Width=class extends ol.ext.input.List{constructor(e){(e=e||{}).options=[],(e.size||[0,1,2,3,5,10,15,20]).forEach(function(t){e.options.push({value:t,html:ol.ext.element.create("DIV",{className:"ol-option-"+t,style:{height:t||void 0}})})}),super(e),this._content.remove(),this.element.classList.add("ol-width")}getValue(){return parseFloat(super.getValue())}},ol.legend.Legend=class extends ol.Object{constructor(e){super(),e=e||{},this._items=new ol.Collection;var t,i=[];this._items.on("add",function(e){i.push({item:e.element,on:e.element.on("change",function(){this.refresh()}.bind(this))}),t&&(clearTimeout(t),t=null),t=setTimeout(function(){this.refresh()}.bind(this),0)}.bind(this)),this._items.on("remove",function(e){for(var s=0;s<i;s++)if(e.element===i[s].item){ol.Observable.unByKey(i[s].on),i.splice(s,1);break}t&&(clearTimeout(t),t=null),t=setTimeout(function(){this.refresh()}.bind(this),0)}.bind(this)),this._listElement=ol.ext.element.create("UL",{className:"ol-legend"}),this._canvas=document.createElement("canvas"),this.setLayer(e.layer),this.set("maxWidth",e.maxWidth,!0),this.set("size",e.size||[40,25],!0),this.set("margin",0===e.margin?0:e.margin||10,!0),this._textStyle=e.textStyle||new ol.style.Text({font:"16px sans-serif",fill:new ol.style.Fill({color:"#333"}),backgroundFill:new ol.style.Fill({color:"rgba(255,255,255,.8)"})}),this._title=new ol.legend.Item({title:e.title||"",className:"ol-title"}),e.titleStyle?this._titleStyle=e.titleStyle:(this._titleStyle=this._textStyle.clone(),this._titleStyle.setFont("bold "+this._titleStyle.getFont())),this.setStyle(e.style),e.items instanceof Array&&e.items.forEach(function(e){this.addItem(e)}.bind(this)),this.refresh()}static getLegendImage(e,t,i){void 0===(e=e||{}).margin&&(e.margin=10);var s=e.size||[40,25];e.width&&(s[0]=e.width),e.heigth&&(s[1]=e.heigth),e.onload=e.onload||function(){setTimeout(function(){ol.legend.Legend.getLegendImage(e,t,i)},100)};var o=s[0]+2*e.margin,r=e.lineHeight||s[1]+2*e.margin,a=e.pixelratio||ol.has.DEVICE_PIXEL_RATIO;t||(i=0,(t=document.createElement("canvas")).width=o*a,t.height=r*a);var n=t.getContext("2d");n.save();var l,h=ol.render.toContext(n,{pixelRatio:a}),c=e.typeGeom,u=e.feature;!u&&c&&(u=/Point/.test(c)?new ol.Feature(new ol.geom.Point([0,0])):/LineString/.test(c)?new ol.Feature(new ol.geom.LineString([0,0])):new ol.Feature(new ol.geom.Polygon([[0,0]])),e.properties&&u.setProperties(e.properties)),u?("function"==typeof(l=u.getStyle())&&(l=l(u)),l||(l="function"==typeof e.style?e.style(u):e.style||[]),c=u.getGeometry().getType()):l=[],l instanceof Array||(l=[l]);var d,p,g=o/2,m=r/2,f=s[0]/2,v=s[1]/2;if("Point"===c){var y=null;for(d=0;p=l[d];d++){var _=p.getImage();if(_){var x=_.getPhoto?_.getPhoto():_.getImage();if(x&&x instanceof HTMLImageElement&&!x.naturalWidth&&("function"==typeof e.onload&&x.addEventListener("load",function(){setTimeout(function(){e.onload()},100)}),_.load()),_.getAnchor){var b=_.getAnchor();if(b){var w=_.getSize(),S=b[0]-w[0],M=b[1]-w[1];y?ol.extent.extend(y,[S,M,S+w[0],M+w[1]]):y=[S,M,S+w[0],M+w[1]]}}}}y&&(g+=(y[2]+y[0])/2,m+=(y[3]+y[1])/2)}for(m+=i||0,d=0;p=l[d];d++){var C;switch(h.setStyle(p),n.save(),c){case ol.geom.Point:case"Point":case"MultiPoint":C=new ol.geom.Point([g,m]);break;case ol.geom.LineString:case"LineString":case"MultiLineString":n.rect(e.margin*a,0,s[0]*a,t.height),n.clip(),C=new ol.geom.LineString([[g-f,m],[g+f,m]]);break;case ol.geom.Polygon:case"Polygon":case"MultiPolygon":C=new ol.geom.Polygon([[[g-f,m-v],[g+f,m-v],[g+f,m+v],[g-f,m+v],[g-f,m-v]]])}p.getGeometryFunction()&&(C=p.getGeometryFunction()(new ol.Feature(C))),h.drawGeometry(C),n.restore()}return n.restore(),t}setTitle(e){this._title.setTitle(e),this.refresh()}getTitle(){return this._title.get("title")}setLayer(e){this._layerListener&&ol.Observable.unByKey(this._layerListener),this._layer=e,this._layerListener=e?e.on("change:visible",function(){this.refresh()}.bind(this)):null}getTextStyle(){return this._textStyle}set(e,t,i){super.set(e,t,i),i||this.refresh()}getListElement(){return this._listElement}getCanvas(){return this._canvas}setStyle(e){this._style=e,this.refresh()}addItem(e){e instanceof ol.legend.Legend?(this._items.push(e),e.on("refresh",function(){this.refresh(!0)}.bind(this))):e instanceof ol.legend.Item||e instanceof ol.legend.Image?this._items.push(e):this._items.push(new ol.legend.Item(e))}removeItem(e){this._items.remove(e)}removeItemAt(e){this._items.removeAt(e)}getItems(){return this._items}_drawText(e,t,i,s){e.save(),e.scale(ol.has.DEVICE_PIXEL_RATIO,ol.has.DEVICE_PIXEL_RATIO);var o=(t=t||"").split("\n");1===o.length?e.fillText(t,i,s):(e.textBaseline="bottom",e.fillText(o[0],i,s),e.textBaseline="top",e.fillText(o[1],i,s)),e.restore()}_measureText(e,t){var i=(t||"").split("\n");if(1===i.length)return e.measureText(t);var s=e.measureText(i[0]),o=e.measureText(i[1]);return{width:Math.max(s.width,o.width),height:s.height+o.height}}refresh(e){var t=this._listElement;if(t){t.innerHTML="";var i=this.get("margin"),s=this.get("size")[0]+2*i,o=this.get("lineHeight")||this.get("size")[1]+2*i,r=this.getCanvas(),a=r.getContext("2d");a.textAlign="left",a.textBaseline="middle";var n=ol.has.DEVICE_PIXEL_RATIO,l=Math.min(this.getWidth(),this.get("maxWidth")||1/0),h=this.getHeight();r.width=l*n,r.height=h*n,r.style.height=h+"px",a.textBaseline="middle",a.fillStyle=ol.color.asString(this._textStyle.getFill().getColor()),this.getTitle()&&(t.appendChild(this._title.getElement([s,o],function(e){this.dispatchEvent({type:"select",index:-1,symbol:e,item:this._title})}.bind(this))),a.font=this._titleStyle.getFont(),a.textAlign="center",this._drawText(a,this.getTitle(),r.width/n/2,o/2));var c=0;this.getTitle()&&(c=o);var u=0;this._items.forEach(function(e,l){if(e instanceof ol.legend.Legend){if((!e._layer||e._layer.getVisible())&&e.getCanvas().height){a.drawImage(e.getCanvas(),0,c*n);for(var h=e._listElement.querySelectorAll("li"),d=0;d<h.length;d++){var p=h[d].cloneNode();p.innerHTML=h[d].innerHTML,t.appendChild(p),u++}c+=e.getHeight()}}else{if(e instanceof ol.legend.Image){e.get("title")&&(t.appendChild(this._title.getElement([s,o],function(e){this.dispatchEvent({type:"select",index:-1,symbol:e,item:this._title})}.bind(this))),a.font=e.get("textStyle")?e.get("textStyle").getFont():this._titleStyle.getFont(),/\bcenter\b/.test(e.get("className"))?(a.textAlign="center",this._drawText(a,e.get("title"),r.width/n/2,c+o/2)):this._drawText(a,e.get("title"),i,c+o/2),c+=o);var g=e.getImage();try{a.drawImage(g,0,0,g.naturalWidth,g.naturalHeight,0,c*n,e.getWidth()*n,e.getHeight()*n)}catch(e){}c+=e.getHeight()}else{var m=e.getProperties(),f=m.height||o;a.textAlign="left",m.feature||m.typeGeom?(r=this.getLegendImage(m,r,c),a.font=e.get("textStyle")?e.get("textStyle").getFont():this._textStyle.getFont(),this._drawText(a,e.get("title"),s+i,c+f/2)):(a.font=e.get("textStyle")?e.get("textStyle").getFont():this._titleStyle.getFont(),/\bcenter\b/.test(m.className)?(a.textAlign="center",this._drawText(a,e.get("title"),r.width/n/2,c+f/2)):this._drawText(a,e.get("title"),i,c+f/2)),c+=f}t.appendChild(e.getElement([s,o],function(t){this.dispatchEvent({type:"select",index:l,symbol:t,item:e})}.bind(this))),u++}}.bind(this)),this.set("items",u,!0),this.dispatchEvent({type:"items",nb:u}),e||this.dispatchEvent({type:"refresh",width:s,height:(this._items.length+1)*o})}}getHeight(){var e=this.get("margin"),t=this.get("lineHeight")||this.get("size")[1]+2*e,i=this.getTitle()?t:0;return this._items.forEach(function(s){s instanceof ol.legend.Legend?s._layer&&!s._layer.getVisible()||(i+=s.getHeight()):s instanceof ol.legend.Image?(s.get("title")&&(i+=t),i+=s.getHeight()):s.get("height")?i+=s.get("height")+2*e:i+=t}),i}getWidth(){var e=this.getCanvas().getContext("2d"),t=this.get("margin"),i=this.get("size")[0]+2*t;e.font=this._titleStyle.getFont();var s=this._measureText(e,this.getTitle("title")).width;return this._items.forEach(function(t){t instanceof ol.legend.Legend?t._layer&&!t._layer.getVisible()||(s=Math.max(s,t.getWidth())):t instanceof ol.legend.Image?(s=Math.max(s,t.getWidth()),t.get("title")&&(e.font=t.get("textStyle")?t.get("textStyle").getFont():this._titleStyle.getFont(),s=Math.max(s,this._measureText(e,t.get("title")).width))):t.get("feature")||t.get("typeGeom")?(e.font=t.get("textStyle")?t.get("textStyle").getFont():this._textStyle.getFont(),s=Math.max(s,this._measureText(e,t.get("title")).width+i)):(e.font=t.get("textStyle")?t.get("textStyle").getFont():this._titleStyle.getFont(),s=Math.max(s,this._measureText(e,t.get("title")).width))}.bind(this)),s+2*t}getLegendImage(e,t,i){e=e||{};var s=this.get("size");return ol.legend.Legend.getLegendImage({className:e.className,feature:e.feature,typeGeom:e.typeGeom,style:e.style||this._style,properties:e.properties,margin:e.margin||this.get("margin"),size:[e.width||s[0],e.height||s[1]],lineHeight:e.lineHeight||this.get("lineHeight"),onload:function(){this.refresh()}.bind(this)},t,i)}},ol.legend.Image=class extends ol.Object{constructor(e){super(e=e||{}),this.set("width",e.width),this._img=e.img||new Image,this._img.onload=function(){this.changed()}.bind(this),e.img||(this._img.src=e.src)}setTitle(e){this.set("title",e||""),this.changed()}setWidth(e){this.set("width",e||null),this.changed()}getWidth(){return this._img.naturalWidth?this.get("width")||this._img.naturalWidth:0}getHeight(){return this._img.naturalWidth?this.get("width")?this.get("width")*this._img.naturalHeight/this._img.naturalWidth:this._img.naturalHeight||0:0}getImage(){return this._img}getElement(e,t){this.get("width")&&(e[0]=this.get("width")),this.get("height")&&(e[1]=this.get("height"));var i=ol.ext.element.create("LI",{className:this.get("className"),click:function(e){t(!1),e.stopPropagation()},style:{height:this.getHeight()+"px"},"aria-label":this.get("title")});return ol.ext.element.create("DIV",{click:function(e){t(!0),e.stopPropagation()},style:{width:this.getWidth()+"px",height:this.getHeight()+"px"},parent:i}),i}},ol.legend.Item=class extends ol.Object{constructor(e){super(e=e||{}),e.feature&&this.set("feature",e.feature.clone()),this.setWidth(e.width),this.setHeight(e.height)}setTitle(e){this.set("title",e||""),this.changed()}setWidth(e){this.set("width",e||null),this.changed()}setHeight(e){this.set("heigth",e||null),this.changed()}getElement(e,t){this.get("width")&&(e[0]=this.get("width")),this.get("height")&&(e[1]=this.get("height"));var i=ol.ext.element.create("LI",{className:this.get("className"),click:function(e){t(!1),e.stopPropagation()},style:{height:e[1]+"px"},"aria-label":this.get("title")});return ol.ext.element.create("DIV",{click:function(e){t(!0),e.stopPropagation()},style:{width:e[0]+"px",height:e[1]+"px"},parent:i}),i}},ol.control.CanvasBase=class extends ol.control.Control{constructor(e){super(e=e||{}),this.setStyle(e.style)}setMap(e){this.getCanvas(e);var t=this.getMap();if(this._listener&&(ol.Observable.unByKey(this._listener),this._listener=null),super.setMap(e),t)try{t.renderSync()}catch(e){}e&&(this._listener=e.on("postcompose",this._draw.bind(this)))}getCanvas(e){return ol.ext.getMapCanvas(e)}getContext(e){var t=e.context;if(!t&&this.getMap()){var i=this.getMap().getViewport().getElementsByClassName("ol-fixedoverlay")[0];t=i?i.getContext("2d"):null}return t}setStyle(e){this._style=e||new ol.style.Style({})}getStyle(){return this._style}getStroke(){return this._style.getStroke()||this._style.setStroke(new ol.style.Stroke({color:"#000",width:1.25})),this._style.getStroke()}getFill(){return this._style.getFill()||this._style.setFill(new ol.style.Fill({color:"#fff"})),this._style.getFill()}getTextStroke(){var e=this._style.getText();return e||(e=new ol.style.Text({})),e.getStroke()||e.setStroke(new ol.style.Stroke({color:"#fff",width:3})),e.getStroke()}getTextFill(){var e=this._style.getText();return e||(e=new ol.style.Text({})),e.getFill()||e.setFill(new ol.style.Fill({color:"#fff"})),e.getFill()}getTextFont(){var e=this._style.getText();return e||(e=new ol.style.Text({})),e.getFont()||e.setFont("12px sans-serif"),e.getFont()}_draw(){console.warn("[CanvasBase] draw function not implemented.")}},ol.control.SelectBase=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");super({element:t,target:e.target}),this._features=this.setFeatures(e.features),e.target||(t.className="ol-select ol-unselectable ol-control ol-collapsed",ol.ext.element.create("BUTTON",{type:"button",on:{"click touchstart":function(e){t.classList.toggle("ol-collapsed"),e.preventDefault()}},parent:t})),e.className&&t.classList.add(e.className);var i=e.content||ol.ext.element.create("DIV");t.appendChild(i),ol.ext.element.create("BUTTON",{html:e.btInfo||"OK",className:"ol-ok",on:{click:this.doSelect.bind(this)},parent:i}),this.setSources(e.source)}setSources(e){e?this.set("source",e instanceof Array?e:[e]):this.unset("source")}setFeatures(e){e instanceof ol.Collection?this._features=e:this._features=null}getFeatures(){return this._features}_escape(e){return String(e||"").replace(/[.*+?^${}()|[\]\\]/g,"\\$&")}_checkCondition(e,t,i){if(!t.attr)return!0;var s=e.get(t.attr),o=Number(s)==s&&Number(t.val)==t.val;switch(o&&(s=Number(s)),t.op){case"=":return o?s==t.val:new RegExp("^"+this._escape(t.val)+"$",i?"":"i").test(s);case"!=":return o?s!=t.val:!new RegExp("^"+this._escape(t.val)+"$",i?"":"i").test(s);case"<":return s<t.val;case"<=":return s<=t.val;case">":return s>t.val;case">=":return s>=t.val;case"contain":return new RegExp(this._escape(t.val),i?"":"i").test(s);case"!contain":return!new RegExp(this._escape(t.val),i?"":"i").test(s);case"regexp":return new RegExp(t.val,i?"":"i").test(s);case"!regexp":return!new RegExp(t.val,i?"":"i").test(s);default:return!1}}_selectFeatures(e,t,i,s,o){var r;i=i||[];for(var a=t.length-1;r=t[a];a--){for(var n,l=s,h=0;n=i[h];h++)n.attr&&(l=s?l&&this._checkCondition(r,n,o):l||this._checkCondition(r,n,o));l?e.push(r):this._features&&this._features.removeAt(a)}return e}getSources(){if(this.get("source"))return this.get("source");var e=[];return this.getMap()&&function t(i){i.forEach(function(i){i.getLayers?t(i.getLayers()):i.getSource&&i.getSource()instanceof ol.source.Vector&&e.push(i.getSource())})}(this.getMap().getLayers()),e}doSelect(e){var t=[];if((e=e||{}).features)this._selectFeatures(t,e.features,e.conditions,e.matchAll,e.useCase);else if(this._features)this._selectFeatures(t,this._features.getArray(),e.conditions,e.matchAll,e.useCase);else{(e.sources||this.getSources()).forEach(function(i){this._selectFeatures(t,i.getFeatures(),e.conditions,e.matchAll,e.useCase)}.bind(this))}return this.dispatchEvent({type:"select",features:t}),t}},ol.control.SelectBase.prototype.operationsList={"=":"=","!=":"≠","<":"<","<=":"≤",">=":"≥",">":">",contain:"⊂","!contain":"⊄",regexp:"≃","!regexp":"≄"},ol.control.Button=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");t.className=(e.className||"")+" ol-button ol-unselectable ol-control",super({element:t,target:e.target});var i=this,s=this.button_=document.createElement(/ol-text-button/.test(e.className)?"div":"button");s.type="button",e.title&&(s.title=e.title),e.name&&(s.name=e.name),e.html instanceof Element?s.appendChild(e.html):s.innerHTML=e.html||"";s.addEventListener("click",function(t){t&&t.preventDefault&&(t.preventDefault(),t.stopPropagation()),e.handleClick&&e.handleClick.call(i,t)}),t.appendChild(s),!e.title&&s.firstElementChild&&(s.title=s.firstElementChild.title),e.title&&this.set("title",e.title),e.title&&this.set("title",e.title),e.name&&this.set("name",e.name)}setVisible(e){e?ol.ext.element.show(this.element):ol.ext.element.hide(this.element)}getDisable(){var e=this.element.querySelector("button");return e&&e.disabled}setDisable(e){this.getDisable()!=e&&(this.element.querySelector("button").disabled=e)}setTitle(e){this.button_.setAttribute("title",e)}setHtml(e){ol.ext.element.setHTML(this.button_,e)}getButtonElement(){return this.button_}},ol.control.Toggle=class extends ol.control.Button{constructor(e){(e=e||{}).toggleFn&&(e.onToggle=e.toggleFn),e.handleClick=function(){t.toggle(),e.onToggle&&e.onToggle.call(t,t.getActive())},e.className=(e.className||"")+" ol-toggle",super(e);var t=this;this.interaction_=e.interaction,this.interaction_&&(this.interaction_.setActive(e.active),this.interaction_.on("change:active",function(){t.setActive(t.interaction_.getActive())})),this.set("title",e.title),this.set("autoActivate",e.autoActivate),e.bar&&this.setSubBar(e.bar),this.setActive(e.active),this.setDisable(e.disable)}setMap(e){!e&&this.getMap()&&(this.interaction_&&this.getMap().removeInteraction(this.interaction_),this.subbar_&&this.getMap().removeControl(this.subbar_)),super.setMap(e),e&&(this.interaction_&&e.addInteraction(this.interaction_),this.subbar_&&e.addControl(this.subbar_))}getSubBar(){return this.subbar_}setSubBar(e){var t=this.getMap();t&&this.subbar_&&t.removeControl(this.subbar_),this.subbar_=e,e&&(this.subbar_.setTarget(this.element),this.subbar_.element.classList.add("ol-option-bar"),t&&t.addControl(this.subbar_))}getDisable(){var e=this.element.querySelector("button");return e&&e.disabled}setDisable(e){this.getDisable()!=e&&(this.element.querySelector("button").disabled=e,e&&this.getActive()&&this.setActive(!1),this.dispatchEvent({type:"change:disable",key:"disable",oldValue:!e,disable:e}))}getActive(){return this.element.classList.contains("ol-active")}toggle(){this.getActive()?this.setActive(!1):this.setActive(!0)}setActive(e){this.interaction_&&this.interaction_.setActive(e),this.subbar_&&this.subbar_.setActive(e),this.getActive()!==e&&(e?this.element.classList.add("ol-active"):this.element.classList.remove("ol-active"),this.dispatchEvent({type:"change:active",key:"active",oldValue:!e,active:e}))}setInteraction(e){this.interaction_=e}getInteraction(){return this.interaction_}},ol.control.Search=class extends ol.control.Control{constructor(e){var t=((e=e||{}).className||"")+" ol-search"+(e.target?"":" ol-unselectable ol-control"),i=ol.ext.element.create("DIV",{className:t});super({element:i,target:e.target});var s=this;if(null==e.typing&&(e.typing=300),this._classname=e.className||"search",!1!==e.collapsed&&i.classList.add("ol-collapsed"),e.target||(this.button=document.createElement("BUTTON"),this.button.setAttribute("type","button"),this.button.setAttribute("title",e.title||e.label||"Search"),this.button.addEventListener("click",function(){if(i.classList.toggle("ol-collapsed"),!i.classList.contains("ol-collapsed")){i.querySelector("input.search").focus();for(var e=i.querySelectorAll("li"),t=0;t<e.length;t++)e[t].classList.remove("select");n.value||s.drawList_()}}),i.appendChild(this.button)),e.inputLabel){var o=document.createElement("LABEL");o.innerText=e.inputLabel,i.appendChild(o)}var r,a="",n=this._input=document.createElement("INPUT");n.setAttribute("type","search"),n.setAttribute("class","search"),n.setAttribute("autocomplete","off"),n.setAttribute("placeholder",e.placeholder||"Search..."),n.addEventListener("change",function(e){s.dispatchEvent({type:"change:input",input:e,value:n.value})});var l=function(t){var o=i.querySelector("ul.autocomplete li.select"),l=n.value;if("ArrowDown"==t.key||"ArrowUp"==t.key||"Down"==t.key||"Up"==t.key)if(o){var h=/Down/.test(t.key)?o.nextElementSibling:o.previousElementSibling;h&&!h.classList.contains("copy")&&(o.classList.remove("select"),h.classList.add("select"),n.value=h.innerText)}else(o=i.querySelector("ul.autocomplete li")).classList.add("select"),n.value=o.innerText;else if("input"==t.type)l||setTimeout(function(){s.drawList_()},200),o&&(n.value=l="",o.classList.remove("select"));else if(!o||"search"!==t.type&&"Enter"!==t.key)if("search"===t.type||"Enter"===t.key||a!=l&&e.typing>=0)if(a=l){r&&clearTimeout(r);var c=s.get("minLength");r=setTimeout(function(){if(a.length>=c){var e=s.autocomplete(a,function(e){s.drawList_(e)});e&&s.drawList_(e)}else s.drawList_()},e.typing)}else s.drawList_();else(o=i.querySelector("ul.autocomplete li"))&&o.classList.remove("select");else i.classList.contains("ol-control")&&n.blur(),o.classList.remove("select"),a=l,s._handleSelect(s._list[o.getAttribute("data-search")])};if(n.addEventListener("keyup",l),n.addEventListener("search",l),n.addEventListener("cut",l),n.addEventListener("paste",l),n.addEventListener("input",l),e.noCollapse||(n.addEventListener("blur",function(){setTimeout(function(){n!==document.activeElement&&(i.classList.add("ol-collapsed"),this.set("reverse",!1),i.classList.remove("ol-revers"))}.bind(this),200)}.bind(this)),n.addEventListener("focus",function(){this.get("reverse")||(i.classList.remove("ol-collapsed"),i.classList.remove("ol-revers"))}.bind(this)),n.addEventListener("keydown",function(){this.set("reverse",!1),i.classList.remove("ol-collapsed"),i.classList.remove("ol-revers")}.bind(this))),i.appendChild(n),e.reverse){var h=ol.ext.element.create("BUTTON",{type:"button",class:"ol-revers",title:e.reverseTitle||"click on the map",on:{focus:function(){this.get("reverse")?this.set("reverse",!1):(this.set("reverse",!this.get("reverse")),n.focus(),i.classList.add("ol-revers"))}.bind(this)}});i.appendChild(h)}var c=document.createElement("UL");c.classList.add("autocomplete"),i.appendChild(c),"function"==typeof e.getTitle&&(this.getTitle=e.getTitle),"function"==typeof e.autocomplete&&(this.autocomplete=e.autocomplete),this.set("copy",e.copy),this.set("minLength",e.minLength||1),this.set("maxItems",e.maxItems||10),this.set("maxHistory",e.maxHistory||e.maxItems||10),e.onselect&&this.on("select",e.onselect),e.centerOnSelect&&this.on("select",function(e){var t=this.getMap();t&&t.getView().setCenter(e.coordinate)}.bind(this)),e.zoomOnSelect&&this.on("select",function(t){var i=this.getMap();i&&(i.getView().setCenter(t.coordinate),i.getView().getZoom()<e.zoomOnSelect&&i.getView().setZoom(e.zoomOnSelect))}.bind(this)),this.restoreHistory(),this.drawList_()}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),e&&(this._listener=e.on("click",this._handleClick.bind(this)))}collapse(e){!1===e?this.element.classList.remove("ol-collapsed"):this.element.classList.add("ol-collapsed")}getInputField(){return this._input}getTitle(e){return e.name||"No title"}_getTitleTxt(e){return ol.ext.element.create("DIV",{html:this.getTitle(e)}).innerText}search(){var e=this.element.querySelector("input.search");this._triggerCustomEvent("search",e)}_handleClick(e){this.get("reverse")&&(document.activeElement.blur(),this.reverseGeocode(e.coordinate))}reverseGeocode(){}_triggerCustomEvent(e,t){ol.ext.element.dispatchEvent(e,t)}setInput(e,t){var i=this.element.querySelector("input.search");i.value=e,t&&this._triggerCustomEvent("keyup",i)}select(e,t,i,s){var o={type:"select",search:e,reverse:!!t,coordinate:i};if(s)for(var r in s)o[r]=s[r];this.dispatchEvent(o)}_handleSelect(e,t,i){if(e){var s,o=this.get("history");try{var r=JSON.stringify(e);for(s=o.length-1;s>=0;s--)o[s]&&JSON.stringify(o[s])!==r||o.splice(s,1)}catch(t){for(s=o.length-1;s>=0;s--)o[s]===e&&o.splice(s,1)}o.unshift(e);for(var a=Math.max(0,this.get("maxHistory")||10)||0;o.length>a;)o.pop();this.saveHistory(),this.select(e,t,null,i),t&&(this.setInput(this._getTitleTxt(e)),this.drawList_(),setTimeout(function(){this.collapse(!1)}.bind(this),300))}}saveHistory(){try{this.get("maxHistory")>=0?localStorage["ol@search-"+this._classname]=JSON.stringify(this.get("history")):localStorage.removeItem("ol@search-"+this._classname)}catch(e){console.warn("Failed to access localStorage...")}}restoreHistory(){if(this._history[this._classname])this.set("history",this._history[this._classname]);else try{this._history[this._classname]=JSON.parse(localStorage["ol@search-"+this._classname]),this.set("history",this._history[this._classname])}catch(e){this.set("history",[])}}clearHistory(){this.set("history",[]),this.saveHistory(),this.drawList_()}getHistory(){return this.get("history")}autocomplete(e,t){return t([]),!1}drawList_(e){var t=this,i=this.element.querySelector("ul.autocomplete");if(i.innerHTML="",this._list=[],e)i.setAttribute("class","autocomplete");else{if(this.element.querySelector("input.search").value)return;e=this.get("history"),i.setAttribute("class","autocomplete history")}for(var s,o=Math.min(t.get("maxItems"),e.length),r=0;r<o;r++)if(e[r]&&(!r||!t.equalFeatures(e[r],e[r-1]))){(s=document.createElement("LI")).setAttribute("data-search",this._list.length),this._list.push(e[r]),s.addEventListener("click",function(e){t._handleSelect(t._list[e.currentTarget.getAttribute("data-search")])});var a=t.getTitle(e[r]);a instanceof Element?s.appendChild(a):s.innerHTML=a,i.appendChild(s)}o&&this.get("copy")&&((s=document.createElement("LI")).classList.add("copy"),s.innerHTML=this.get("copy"),i.appendChild(s))}equalFeatures(){return!1}},ol.control.Search.prototype._history={},ol.control.SearchJSON=class extends ol.control.Search{constructor(e){(e=e||{}).className=e.className||"JSON",delete e.autocomplete,e.minLength=e.minLength||3,e.typing=e.typing||800,super(e);var t=e.url||"";if("https:"===window.location.protocol){var i=document.createElement("a");i.href=t,i.protocol=window.location.protocol,t=i.href}this.set("url",t),this._ajax=new ol.ext.Ajax({dataType:"JSON",auth:e.authentication}),this._ajax.on("success",function(e){e.status>=200&&e.status<400?"function"==typeof this._callback&&this._callback(e.response):("function"==typeof this._callback&&this._callback(!1,"error"),console.log("AJAX ERROR",arguments))}.bind(this)),this._ajax.on("error",function(){"function"==typeof this._callback&&this._callback(!1,"error"),console.log("AJAX ERROR",arguments)}.bind(this)),this._ajax.on("loadstart",function(){this.element.classList.add("searching")}.bind(this)),this._ajax.on("loadend",function(){this.element.classList.remove("searching")}.bind(this)),"function"==typeof e.handleResponse&&(this.handleResponse=e.handleResponse)}ajax(e,t,i,s){s=s||{},this._callback=i,this._ajax.set("dataType",s.dataType||"JSON"),this._ajax.send(e,t,s)}autocomplete(e,t){var i=this.requestData(e),s=encodeURI(this.get("url"));this.ajax(s,i,function(e){"function"==typeof t&&t(this.handleResponse(e))})}requestData(e){return{q:e}}handleResponse(e){return e}},ol.control.SearchPhoton=class extends ol.control.SearchJSON{constructor(e){(e=e||{}).className=e.className||"photon",e.url=e.url||"https://photon.komoot.io/api/",e.copy=e.copy||'<a href="http://www.openstreetmap.org/copyright" target="new">&copy; OpenStreetMap contributors</a>',super(e),this.set("lang",e.lang),this.set("position",e.position)}getTitle(e){var t=e.properties;return(t.housenumber||"")+" "+(t.street||t.name||"")+"<i> "+(t.postcode||"")+" "+(t.city||"")+" ("+t.country+")</i>"}requestData(e){var t={q:e,lang:this.get("lang"),limit:this.get("maxItems")};if(this.get("position")){var i=this.getMap().getView(),s=new ol.geom.Point(i.getCenter());s=s.transform(i.getProjection(),"EPSG:4326").getCoordinates(),t.lon=s[0],t.lat=s[1]}return t}handleResponse(e){return e.features}equalFeatures(e,t){return this.getTitle(e)===this.getTitle(t)&&e.geometry.coordinates[0]===t.geometry.coordinates[0]&&e.geometry.coordinates[1]===t.geometry.coordinates[1]}select(e){var t=e.geometry.coordinates;try{t=ol.proj.transform(e.geometry.coordinates,"EPSG:4326",this.getMap().getView().getProjection())}catch(e){}this.dispatchEvent({type:"select",search:e,coordinate:t})}reverseData(e){var t=ol.proj.transform(e,this.getMap().getView().getProjection(),"EPSG:4326");return{lon:t[0],lat:t[1]}}reverseGeocode(e,t){this.ajax(this.get("url").replace("/api/","/reverse/").replace("/search/","/reverse/"),this.reverseData(e),function(e){e.features&&(e=e.features),e instanceof Array||(e=[e]),t?t.call(this,e):this._handleSelect(e[0],!0)}.bind(this))}},ol.control.SearchGeoportail=class extends ol.control.SearchJSON{constructor(e){(e=e||{}).className=e.className||"IGNF",e.typing=e.typing||500,1==e.version?(e.url="https://wxs.ign.fr/"+(e.apiKey||"essentiels")+"/ols/apis/completion",e.copy='<a href="https://www.geoportail.gouv.fr/" target="new">&copy; IGN-Géoportail</a>'):2==e.version?(e.url="https://wxs.ign.fr/"+(e.apiKey||"essentiels")+"/geoportail/geocodage/rest/0.1/completion",e.copy='<a href="https://www.geoportail.gouv.fr/" target="new">&copy; IGN-Géoportail</a>'):(e.url="https://data.geopf.fr/geocodage/completion",e.copy='<a href="https://geoservices.ign.fr/" target="new">&copy; IGN-Géoplateforme</a>'),super(e),this.set("position",e.position),this.set("useExtent",e.useExtent),this.set("bbox",e.bbox),this.set("type",e.type||"StreetAddress,PositionOfInterest"),this.set("terr",e.terr),this.set("timeout",e.timeout||2e3)}reverseGeocode(e,t){var i=ol.proj.transform(e,this.getMap().getView().getProjection(),"EPSG:4326");this._handleSelect({x:i[0],y:i[1],fulltext:i[0].toFixed(6)+","+i[1].toFixed(6)},!0,t);var s="Commune"===this.get("type")?"PositionOfInterest":this.get("type")||"StreetAddress";/,/.test(s)&&(s="StreetAddress");var o=this.get("url").replace("ols/apis/completion","geoportail/ols").replace("completion","reverse");if(/ols/.test(o)){var r='<?xml version="1.0" encoding="UTF-8"?><XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.opengis.net/xls" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.2" xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"> <Request requestID="1" version="1.2" methodName="ReverseGeocodeRequest" maximumResponses="1" >  <ReverseGeocodeRequest>   <ReverseGeocodePreference>'+s+"</ReverseGeocodePreference>   <Position>    <gml:Point><gml:pos>"+i[1]+" "+i[0]+"</gml:pos></gml:Point>   </Position>  </ReverseGeocodeRequest> </Request></XLS>";this.ajax(o,{xls:r},function(e){var s={};if(e){var o=(e=e.replace(/\n|\r/g,"")).replace(/.*<gml:pos>(.*)<\/gml:pos>.*/,"$1").split(" ");if(Number(o[1])||Number(o[0]))if(s.x=i[0],s.y=i[1],s.city=e.replace(/.*<Place type="Municipality">([^<]*)<\/Place>.*/,"$1"),s.insee=e.replace(/.*<Place type="INSEE">([^<]*)<\/Place>.*/,"$1"),s.zipcode=e.replace(/.*<PostalCode>([^<]*)<\/PostalCode>.*/,"$1"),/<Street>/.test(e)){s.kind="",s.country="StreetAddress",s.street=e.replace(/.*<Street>([^<]*)<\/Street>.*/,"$1");var r=e.replace(/.*<Building number="([^"]*).*/,"$1");s.fulltext=r+" "+s.street+", "+s.zipcode+" "+s.city}else s.kind=e.replace(/.*<Place type="Nature">([^<]*)<\/Place>.*/,"$1"),s.country="PositionOfInterest",s.street="",s.fulltext=s.zipcode+" "+s.city;else s={x:i[0],y:i[1],fulltext:i[0].toFixed(6)+","+i[1].toFixed(6)}}else s={x:i[0],y:i[1],fulltext:i[0].toFixed(6)+","+i[1].toFixed(6)};"function"==typeof t?t.call(this,[s]):(this.getHistory().shift(),this._handleSelect(s,!0,t))}.bind(this),{timeout:this.get("timeout"),dataType:"XML"})}else this.ajax(o+"?lon="+i[0]+"&lat="+i[1],{},function(e){var s;try{(s=(e=JSON.parse(e).features[0]).properties).x=e.geometry.coordinates[0],s.y=e.geometry.coordinates[1],s.click=i,s.name?s.fulltext=s.name+", "+s.postcode+" "+s.city:s.fulltext=s.postcode+" "+s.city}catch(e){s={x:i[0],y:i[1],lonlat:i,fulltext:i[0].toFixed(6)+","+i[1].toFixed(6)}}"function"==typeof t?t.call(this,[s]):(this.getHistory().shift(),this._handleSelect(s,!0,t))}.bind(this),{timeout:this.get("timeout"),dataType:"XML"})}getTitle(e){return e.fulltext}requestData(e){var t={text:e,type:"Commune"===this.get("type")?"PositionOfInterest":this.get("type")||"StreetAddress,PositionOfInterest",terr:this.get("terr")||void 0,maximumResponses:this.get("maxItems")};if("Commune"===this.get("type")&&(t.poiType="commune"),this.get("position")){var i=this.getMap().getView().getCenter();t.lonlat=ol.proj.transform(i,this.getMap().getView().getProjection(),"EPSG:4326").join(",")}if(this.get("bbox"))t.bbox=ol.proj.transformExtent(this.get("bbox"),this.getMap().getView().getProjection(),"EPSG:4326").join(",");else if(this.get("useExtent")){var s=this.getMap().getView().calculateExtent();t.bbox=ol.proj.transformExtent(s,this.getMap().getView().getProjection(),"EPSG:4326").join(",")}return t}handleResponse(e){return e.results}select(e,t,i,s){if(e.x||e.y){var o=[Number(e.x),Number(e.y)];try{o=ol.proj.transform(o,"EPSG:4326",this.getMap().getView().getProjection())}catch(e){}"Commune"===this.get("type")?this.searchCommune(e,function(){ol.control.Search.prototype.select.call(this,e,t,o,s)}.bind(this)):super.select(e,t,o,s)}else this.searchCommune(e)}searchCommune(e,t){var i=this.get("url").replace("ols/apis/completion","geoportail/ols").replace("completion","reverse");if(/ols/.test(i)){var s='<?xml version="1.0" encoding="UTF-8"?><XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.opengis.net/xls" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.2" xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"><RequestHeader/><Request requestID="1" version="1.2" methodName="LocationUtilityService"><GeocodeRequest returnFreeForm="false"><Address countryCode="PositionOfInterest"><freeFormAddress>'+e.zipcode+" "+e.city+"+</freeFormAddress></Address></GeocodeRequest></Request></XLS>";this.ajax(this.get("url").replace("ols/apis/completion","geoportail/ols"),{xls:s},function(i){if(i){var s=(new DOMParser).parseFromString(i,"text/xml").getElementsByTagName("GeocodedAddress")[0],o=s.getElementsByTagName("gml:Point")[0].textContent.trim().split(" ");e.x=Number(o[1]),e.y=Number(o[0]);for(var r=s.getElementsByTagName("Place"),a=0;a<r.length;a++)switch(r[a].attributes.type.value){case"Nature":e.kind=r[a].textContent;break;case"INSEE":e.insee=r[a].textContent}(e.x||e.y)&&(t?t.call(this,[e]):this._handleSelect(e))}}.bind(this),{dataType:"XML"})}else this.ajax(i+"?lon="+e.x+"&lat="+e.y+"&index=parcel&limit=1",{},function(i){try{var s=JSON.parse(i).features[0];e.insee=s.properties.departmentcode+s.properties.municipalitycode,e.districtcode=s.properties.districtcode,t?t.call(this,[e]):this._handleSelect(e)}catch(e){}}.bind(this),{timeout:this.get("timeout"),dataType:"XML"})}},ol.control.LayerSwitcher=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:e.switcherClass||"ol-layerswitcher"});super({element:t,target:e.target});var i=this;this.dcount=0,this.show_progress=e.show_progress,this.oninfo="function"==typeof e.oninfo?e.oninfo:null,this.onextent="function"==typeof e.onextent?e.onextent:null,this.hasextent=e.extent||e.onextent,this.hastrash=e.trash,this.reordering=!1!==e.reordering,this._layers=[],this._layerGroup=e.layerGroup&&e.layerGroup.getLayers?e.layerGroup:null,this.onchangeCheck="function"==typeof e.onchangeCheck?e.onchangeCheck:null,"function"==typeof e.displayInLayerSwitcher&&(this.displayInLayerSwitcher=e.displayInLayerSwitcher),e.target||(t.classList.add("ol-unselectable"),t.classList.add("ol-control"),t.classList.add(!1!==e.collapsed?"ol-collapsed":"ol-forceopen"),this.button=ol.ext.element.create("BUTTON",{type:"button",parent:t}),this.button.addEventListener("touchstart",function(e){t.classList.toggle("ol-forceopen"),t.classList.add("ol-collapsed"),i.dispatchEvent({type:"toggle",collapsed:t.classList.contains("ol-collapsed")}),e.preventDefault(),i.overflow()}),this.button.addEventListener("click",function(){t.classList.toggle("ol-forceopen"),t.classList.add("ol-collapsed"),i.dispatchEvent({type:"toggle",collapsed:!t.classList.contains("ol-forceopen")}),i.overflow()}),e.mouseover&&(t.addEventListener("mouseleave",function(){t.classList.add("ol-collapsed"),i.dispatchEvent({type:"toggle",collapsed:!0})}),t.addEventListener("mouseover",function(){t.classList.remove("ol-collapsed"),i.dispatchEvent({type:"toggle",collapsed:!1})})),e.minibar&&(e.noScroll=!0),e.noScroll||(this.topv=ol.ext.element.create("DIV",{className:"ol-switchertopdiv",parent:t,click:function(){i.overflow("+50%")}}),this.botv=ol.ext.element.create("DIV",{className:"ol-switcherbottomdiv",parent:t,click:function(){i.overflow("-50%")}})),this._noScroll=e.noScroll),this.panel_=ol.ext.element.create("UL",{className:"panel"}),this.panelContainer_=ol.ext.element.create("DIV",{className:"panel-container",html:this.panel_,parent:t}),e.target||e.noScroll||ol.ext.element.addListener(this.panel_,"mousewheel DOMMouseScroll onmousewheel",function(e){i.overflow(Math.max(-1,Math.min(1,e.wheelDelta||-e.detail)))&&(e.stopPropagation(),e.preventDefault())}),this.header_=ol.ext.element.create("LI",{className:"ol-header",parent:this.panel_}),this.set("drawDelay",e.drawDelay||0),this.set("selection",e.selection),e.minibar&&setTimeout(function(){var e=ol.ext.element.scrollDiv(this.panelContainer_,{mousewheel:!0,vertical:!0,minibar:!0});this.on(["drawlist","toggle"],function(){e.refresh()})}.bind(this))}displayInLayerSwitcher(e){return!1!==e.get("displayInLayerSwitcher")}setMap(e){if(super.setMap(e),this.drawPanel(),this._listener)for(var t in this._listener)ol.Observable.unByKey(this._listener[t]);this._listener=null,e&&(this._listener={moveend:e.on("moveend",this.viewChange.bind(this)),size:e.on("change:size",this.overflow.bind(this))},this._layerGroup?this._listener.change=this._layerGroup.getLayers().on("change:length",this.drawPanel.bind(this)):this._listener.change=e.getLayerGroup().getLayers().on("change:length",this.drawPanel.bind(this)))}show(){this.element.classList.add("ol-forceopen"),this.overflow(),this.dispatchEvent({type:"toggle",collapsed:!1})}hide(){this.element.classList.remove("ol-forceopen"),this.overflow(),this.dispatchEvent({type:"toggle",collapsed:!0})}toggle(){this.element.classList.toggle("ol-forceopen"),this.overflow(),this.dispatchEvent({type:"toggle",collapsed:!this.isOpen()})}isOpen(){return this.element.classList.contains("ol-forceopen")}setHeader(e){ol.ext.element.setHTML(this.header_,e)}overflow(e){if(this.button&&!this._noScroll){if(ol.ext.element.hidden(this.panel_))return void ol.ext.element.setStyle(this.element,{height:"auto"});var t=ol.ext.element.outerHeight(this.element),i=ol.ext.element.outerHeight(this.panel_),s=this.button.offsetTop+ol.ext.element.outerHeight(this.button),o=this.panel_.offsetTop-s;if(i>t-s){ol.ext.element.setStyle(this.element,{height:"100%"});var r=this.panel_.querySelectorAll("li.ol-visible .li-content")[0],a=r?2*ol.ext.element.getStyle(r,"height"):0;switch(e){case 1:o+=a;break;case-1:o-=a;break;case"+50%":o+=Math.round(t/2);break;case"-50%":o-=Math.round(t/2)}return o+i<=t-3*s/2?(o=t-3*s/2-i,ol.ext.element.hide(this.botv)):ol.ext.element.show(this.botv),o>=0?(o=0,ol.ext.element.hide(this.topv)):ol.ext.element.show(this.topv),ol.ext.element.setStyle(this.panel_,{top:o+"px"}),!0}return ol.ext.element.setStyle(this.element,{height:"auto"}),ol.ext.element.setStyle(this.panel_,{top:0}),ol.ext.element.hide(this.botv),ol.ext.element.hide(this.topv),!1}return!1}_setLayerForLI(e,t){var i=[];t.getLayers&&i.push(t.getLayers().on("change:length",this.drawPanel.bind(this))),e&&(i.push(t.on("change:opacity",function(){this.setLayerOpacity(t,e)}.bind(this))),i.push(t.on("change:visible",function(){this.setLayerVisibility(t,e)}.bind(this)))),i.push(t.on("propertychange",function(e){"displayInLayerSwitcher"!==e.key&&"openInLayerSwitcher"!==e.key&&"title"!==e.key&&"name"!==e.key||this.drawPanel(e)}.bind(this))),this._layers.push({li:e,layer:t,listeners:i})}setLayerOpacity(e,t){var i=t.querySelector(".layerswitcher-opacity-cursor");i&&(i.style.left=100*e.getOpacity()+"%"),this.dispatchEvent({type:"layer:opacity",layer:e})}setLayerVisibility(e,t){var i=t.querySelector(".ol-visibility");i&&(i.checked=e.getVisible()),e.getVisible()?t.classList.add("ol-visible"):t.classList.remove("ol-visible"),this.dispatchEvent({type:"layer:visible",layer:e})}_clearLayerForLI(){this._layers.forEach(function(e){e.listeners.forEach(function(e){ol.Observable.unByKey(e)})}),this._layers=[]}_getLayerForLI(e){for(var t,i=0;t=this._layers[i];i++)if(t.li===e)return t.layer;return null}viewChange(){this.panel_.querySelectorAll("li").forEach(function(e){var t=this._getLayerForLI(e);t&&(this.testLayerVisibility(t)?e.classList.remove("ol-layer-hidden"):e.classList.add("ol-layer-hidden"))}.bind(this))}getPanel(){return this.panelContainer_}drawPanel(){if(this.getMap()){var e=this;this.dcount++,setTimeout(function(){e.drawPanel_()},this.get("drawDelay")||0)}}drawPanel_(){if(!--this.dcount&&!this.dragging_){var e=this.panelContainer_.scrollTop;this._clearLayerForLI(),this.panel_.querySelectorAll("li").forEach(function(e){e.classList.contains("ol-header")||e.remove()}.bind(this)),this._layerGroup?this.drawList(this.panel_,this._layerGroup.getLayers()):this.getMap()&&this.drawList(this.panel_,this.getMap().getLayers()),this.panelContainer_.scrollTop=e}}switchLayerVisibility(e,t){e.get("baseLayer")?(e.getVisible()||e.setVisible(!0),t.forEach(function(t){e!==t&&t.get("baseLayer")&&t.getVisible()&&t.setVisible(!1)})):e.setVisible(!e.getVisible())}testLayerVisibility(e){if(!this.getMap())return!0;var t=this.getMap().getView().getResolution(),i=this.getMap().getView().getZoom();if(e.getMaxResolution()<=t||e.getMinResolution()>=t)return!1;if(e.getMinZoom&&(e.getMinZoom()>=i||e.getMaxZoom()<i))return!1;var s=e.getExtent();if(s){var o=this.getMap().getView().calculateExtent(this.getMap().getSize());return ol.extent.intersects(o,s)}return!0}dragOrdering_(e){e.stopPropagation(),e.preventDefault();var t,i,s,o,r,a=this,n=e.currentTarget.parentNode.parentNode,l=!0,h=this.panel_,c=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY;function u(e){if(t=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY,l&&Math.abs(c-t)>2&&(l=!1,n.classList.add("drag"),o=a._getLayerForLI(n),i=!1,r=a._getLayerForLI(n.parentNode.parentNode),s=ol.ext.element.create("LI",{className:"ol-dragover",html:n.innerHTML,style:{position:"absolute","z-index":1e4,left:n.offsetLeft,opacity:.5,width:ol.ext.element.outerWidth(n),height:ol.ext.element.getStyle(n,"height")},parent:h}),a.element.classList.add("drag"),a.dispatchEvent({type:"reorder-start",layer:o,group:r})),!l){var u;if(e.preventDefault(),e.stopPropagation(),ol.ext.element.setStyle(s,{top:t-ol.ext.element.offsetRect(h).top+h.scrollTop+5}),e.touches)for(u=document.elementFromPoint(e.touches[0].clientX,e.touches[0].clientY);u.shadowRoot;)u=u.shadowRoot.elementFromPoint(e.touches[0].clientX,e.touches[0].clientY);else u=e.target,e.target.shadowRoot&&(u=e.composedPath()[0]);for(u.classList.contains("ol-switcherbottomdiv")?a.overflow(-1):u.classList.contains("ol-switchertopdiv")&&a.overflow(1);u&&"LI"!==u.tagName;)u=u.parentNode;u&&u.classList.contains("dropover")||n.parentNode.querySelectorAll("li").forEach(function(e){e.classList.remove("dropover"),e.classList.remove("dropover-after"),e.classList.remove("dropover-before")}),u&&u.parentNode.classList.contains("drag")&&u!==n?((i=a._getLayerForLI(u))&&!i.get("allwaysOnTop")==!o.get("allwaysOnTop")?(u.classList.add("dropover"),u.classList.add(n.offsetTop<u.offsetTop?"dropover-after":"dropover-before")):i=!1,ol.ext.element.show(s)):(i=!1,u===n?ol.ext.element.hide(s):ol.ext.element.show(s)),i?s.classList.remove("forbidden"):s.classList.add("forbidden")}}n.parentNode.classList.add("drag"),ol.ext.element.addListener(document,"mousemove touchmove",u),ol.ext.element.addListener(document,"mouseup touchend touchcancel",function e(){if(i){var t=o,l=a.getSelection()===t;if(t&&i){for(var h,c=(h=r?r.getLayers():a._layerGroup?a._layerGroup.getLayers():a.getMap().getLayers()).getArray(),d=0;d<c.length;d++)if(c[d]==t){h.removeAt(d);break}for(var p=0;p<c.length;p++)if(c[p]===i){d>p?h.insertAt(p,t):h.insertAt(p+1,t);break}}l&&a.selectLayer(t),a.dispatchEvent({type:"reorder-end",layer:t,group:r})}n.parentNode.querySelectorAll("li").forEach(function(e){e.classList.remove("dropover"),e.classList.remove("dropover-after"),e.classList.remove("dropover-before")}),n.classList.remove("drag"),n.parentNode.classList.remove("drag"),a.element.classList.remove("drag"),s&&s.remove(),ol.ext.element.removeListener(document,"mousemove touchmove",u),ol.ext.element.removeListener(document,"mouseup touchend touchcancel",e)})}dragOpacity_(e){e.stopPropagation(),e.preventDefault();var t=this,i=e.target,s=this._getLayerForLI(i.parentNode.parentNode.parentNode);if(s){var o=e.pageX||e.touches&&e.touches.length&&e.touches[0].pageX||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageX,r=ol.ext.element.getStyle(i,"left")-o;t.dragging_=!0,ol.ext.element.addListener(document,"mouseup touchend touchcancel",function e(){ol.ext.element.removeListener(document,"mouseup touchend touchcancel",e),ol.ext.element.removeListener(document,"mousemove touchmove",a),t.dragging_=!1}),ol.ext.element.addListener(document,"mousemove touchmove",a)}function a(e){var t=e.pageX||e.touches&&e.touches.length&&e.touches[0].pageX||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageX,o=(r+t)/ol.ext.element.getStyle(i.parentNode,"width"),a=Math.max(0,Math.min(1,o));ol.ext.element.setStyle(i,{left:100*a+"%"}),i.parentNode.nextElementSibling.innerHTML=Math.round(100*a),s.setOpacity(a)}}drawList(e,t){var i=this,s=t.getArray(),o=function(e){e.stopPropagation(),e.preventDefault();var s=i._getLayerForLI(this.parentNode.parentNode);i.switchLayerVisibility(s,t),i.get("selection")&&s.getVisible()&&i.selectLayer(s),i.onchangeCheck&&i.onchangeCheck(s)};function r(e){e.stopPropagation(),e.preventDefault();var t=i._getLayerForLI(this.parentNode.parentNode);i.oninfo(t),i.dispatchEvent({type:"info",layer:t})}function a(e){e.stopPropagation(),e.preventDefault();var t=i._getLayerForLI(this.parentNode.parentNode);i.onextent?i.onextent(t):i.getMap().getView().fit(t.getExtent(),i.getMap().getSize()),i.dispatchEvent({type:"extent",layer:t})}function n(e){e.stopPropagation(),e.preventDefault();var t,s=this.parentNode.parentNode.parentNode.parentNode,o=i._getLayerForLI(s);o?(t=i._getLayerForLI(this.parentNode.parentNode),o.getLayers().remove(t),0!=o.getLayers().getLength()||o.get("noSwitcherDelete")||n.call(s.querySelectorAll(".layerTrash")[0],e)):(s=this.parentNode.parentNode,i.getMap().removeLayer(i._getLayerForLI(s)))}function l(l){if(this.displayInLayerSwitcher(l)){var c=ol.ext.element.create("LI",{className:(l.getVisible()?"ol-visible ":" ")+(l.get("baseLayer")?"baselayer":""),parent:e});this._setLayerForLI(c,l),this._selectedLayer===l&&c.classList.add("ol-layer-select");var u=ol.ext.element.create("DIV",{className:"ol-layerswitcher-buttons",parent:c}),d=ol.ext.element.create("DIV",{className:"li-content",parent:c}),p=ol.ext.element.create("INPUT",{type:l.get("baseLayer")?"radio":"checkbox",className:"ol-visibility",checked:l.getVisible(),click:function(e){o.bind(this)(e),setTimeout(function(){e.target.checked=l.getVisible()})},on:{keydown:function(s){switch(s.key){case"ArrowLeft":case"ArrowRight":s.preventDefault(),s.stopPropagation();var o="ArrowLeft"===s.key?-.1:.1,r=Math.min(1,Math.max(0,l.getOpacity()+o));l.setOpacity(r);break;case"Enter":i.get("selection")&&(s.preventDefault(),s.stopPropagation(),i.selectLayer(l));break;case"-":case"+":l.getLayers&&(this._focus=l,l.set("openInLayerSwitcher",!l.get("openInLayerSwitcher")));case"ArrowUp":case"ArrowDown":if(s.ctrlKey&&this.reordering){s.preventDefault(),s.stopPropagation();var a=t.getArray().indexOf(l);a>-1&&("ArrowDown"===s.key?a>0&&(t.remove(l),t.insertAt(a-1,l),i._focus=l,i.dispatchEvent({type:"reorder-end",layer:l})):a<t.getLength()-1&&(t.remove(l),t.insertAt(a+1,l),i._focus=l,i.dispatchEvent({type:"reorder-end",layer:l})))}break;default:var n=this._getLayerForLI(e.parentNode);this.dispatchEvent({type:"layer:keydown",key:s.key,group:n,li:c,layer:l,originalEvent:s})}}.bind(this)},parent:d});l===i._focus&&(p.focus(),i.overflow());var g=ol.ext.element.create("LABEL",{title:l.get("title")||l.get("name"),click:o,style:{userSelect:"none"},parent:d});if(g.addEventListener("selectstart",function(){return!1}),ol.ext.element.create("SPAN",{html:l.get("title")||l.get("name"),click:function(e){this.get("selection")&&(e.stopPropagation(),this.selectLayer(l))}.bind(this),parent:g}),this.reordering&&(h<s.length-1&&(l.get("allwaysOnTop")||!s[h+1].get("allwaysOnTop"))||h>0&&(!l.get("allwaysOnTop")||s[h-1].get("allwaysOnTop")))&&ol.ext.element.create("DIV",{className:"layerup ol-noscroll",title:this.tip.up,on:{"mousedown touchstart":function(e){i.dragOrdering_(e)}},parent:u}),l.getLayers){var m=0;l.getLayers().forEach(function(e){i.displayInLayerSwitcher(e)&&m++}),m&&ol.ext.element.create("DIV",{className:l.get("openInLayerSwitcher")?"collapse-layers":"expend-layers",title:this.tip.plus,click:function(){var e=i._getLayerForLI(this.parentNode.parentNode);e.set("openInLayerSwitcher",!e.get("openInLayerSwitcher"))},parent:u})}if(this.oninfo&&ol.ext.element.create("DIV",{className:"layerInfo",title:this.tip.info,click:r,parent:u}),this.hastrash&&!l.get("noSwitcherDelete")&&ol.ext.element.create("DIV",{className:"layerTrash",title:this.tip.trash,click:n,parent:u}),this.hasextent&&s[h].getExtent()){var f=s[h].getExtent();4==f.length&&f[0]<f[2]&&f[1]<f[3]&&ol.ext.element.create("DIV",{className:"layerExtent",title:this.tip.extent,click:a,parent:u})}if(this.show_progress&&l instanceof ol.layer.Tile){var v=ol.ext.element.create("DIV",{className:"layerswitcher-progress",parent:d});this.setprogress_(l),l.layerswitcher_progress=ol.ext.element.create("DIV",{parent:v})}var y=ol.ext.element.create("DIV",{className:"layerswitcher-opacity",click:function(e){if(e.target===this){e.stopPropagation(),e.preventDefault();var t=Math.max(0,Math.min(1,e.offsetX/ol.ext.element.getStyle(this,"width")));i._getLayerForLI(this.parentNode.parentNode).setOpacity(t),this.parentNode.querySelectorAll(".layerswitcher-opacity-label")[0].innerHTML=Math.round(100*t)}},parent:d});if(ol.ext.element.create("DIV",{className:"layerswitcher-opacity-cursor ol-noscroll",style:{left:100*l.getOpacity()+"%"},on:{"mousedown touchstart":function(e){i.dragOpacity_(e)}},parent:y}),ol.ext.element.create("DIV",{className:"layerswitcher-opacity-label",html:Math.round(100*l.getOpacity()),parent:d}),l.getLayers&&(c.classList.add("ol-layer-group"),!0===l.get("openInLayerSwitcher"))){var _=ol.ext.element.create("UL",{parent:c});this.drawList(_,l.getLayers())}c.classList.add(this.getLayerClass(l)),this.dispatchEvent({type:"drawlist",layer:l,li:c})}else this._setLayerForLI(null,l)}for(var h=s.length-1;h>=0;h--)l.call(this,s[h]);this.viewChange(),e===this.panel_&&(this.overflow(""),this._focus=null)}getLayerClass(e){return e?e.getLayers?"ol-layer-group":e instanceof ol.layer.Vector?"ol-layer-vector":e instanceof ol.layer.VectorTile?"ol-layer-vectortile":e instanceof ol.layer.Tile?"ol-layer-tile":e instanceof ol.layer.Image?"ol-layer-image":e instanceof ol.layer.Heatmap?"ol-layer-heatmap":e.getFeatures?"ol-layer-vectorimage":"unknown":"none"}selectLayer(e,t){if(!e){if(!this.getMap())return;e=this.getMap().getLayers().item(this.getMap().getLayers().getLength()-1)}this._selectedLayer=e,this.element.querySelector("input.ol-visibility:focus")&&(this._focus=e),this.drawPanel(),t||this.dispatchEvent({type:"select",layer:e})}getSelection(){return this._selectedLayer}setprogress_(e){if(!e.layerswitcher_progress){var t=0,i=0,s=function(){i===t?(i=t=0,ol.ext.element.setStyle(e.layerswitcher_progress,{width:0})):ol.ext.element.setStyle(e.layerswitcher_progress,{width:(t/i*100).toFixed(1)+"%"})};e.getSource().on("tileloadstart",function(){i++,s()}),e.getSource().on("tileloadend",function(){t++,s()}),e.getSource().on("tileloaderror",function(){t++,s()})}}},ol.control.LayerSwitcher.prototype.tip={up:"up/down",down:"down",info:"informations...",extent:"zoom to extent",trash:"remove layer",plus:"expand/shrink"},ol.control.Bar=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("DIV");if(t.classList.add("ol-unselectable","ol-control","ol-bar"),e.className){var i=e.className.split(" ").filter(function(e){return e.length>0});t.classList.add.apply(t.classList,i)}if(e.group&&t.classList.add("ol-group"),super({element:t,target:e.target}),this.set("toggleOne",e.toggleOne),this.set("autoDeactivate",e.autoDeactivate),this.controls_=[],e.controls instanceof Array)for(var s=0;s<e.controls.length;s++)this.addControl(e.controls[s])}setVisible(e){this.element.style.display=e?"":"none"}getVisible(){return"none"!=this.element.style.display}setMap(e){super.setMap(e);for(var t=0;t<this.controls_.length;t++){this.controls_[t].setMap(e)}}getControls(){return this.controls_}setPosition(e){this.element.classList.remove("ol-left","ol-top","ol-bottom","ol-right"),e=e.split("-");for(var t=0;t<e.length;t++)switch(e[t]){case"top":case"left":case"bottom":case"right":this.element.classList.add("ol-"+e[t])}}addControl(e){this.controls_.push(e),e.setTarget(this.element),this.getMap()&&this.getMap().addControl(e),e._activateBar&&e.un("change:active",e._activateBar),e._activateBar=function(t){this.onActivateControl_(t,e)}.bind(this),e.on("change:active",e._activateBar),e.getActive&&this.onActivateControl_({target:e,active:e.getActive()},e)}removeControl(e){var t=this.controls_.indexOf(e);t>-1&&(this.controls_.splice(t,1),this.getMap()&&this.getMap().removeControl(e),e._activateBar&&e.un("change:active",e._activateBar),delete e._activateBar)}deactivateControls(e){for(var t=0;t<this.controls_.length;t++)this.controls_[t]!==e&&this.controls_[t].setActive&&this.controls_[t].setActive(!1)}getActiveControls(){for(var e,t=[],i=0;e=this.controls_[i];i++)e.getActive&&e.getActive()&&t.push(e);return t}setActive(e){if(!e&&this.get("autoDeactivate")&&this.deactivateControls(),e)for(var t,i=this.getControls(),s=0;t=i[s];s++)t.get("autoActivate")&&t.setActive(!0)}onActivateControl_(e,t){if(this.get("toggleOne"))if(e.active){var i;for(i=0;i<this.controls_.length&&this.controls_[i]!==t;i++);if(i==this.controls_.length)return;this.deactivateControls(this.controls_[i])}else if(!this.getActiveControls().length)for(var s,o=0;s=this.controls_[o];o++)if(s.get("autoActivate")){s.setActive(!0);break}e.type?this.dispatchEvent({type:"control:active",control:t,active:e.active}):this.dispatchEvent({type:"control:add",control:t,active:e.active})}getControlsByName(e){return this.getControls().filter(function(t){return t.get("name")===e})}},ol.control.CanvasAttribution=class extends ol.control.Attribution{constructor(e){super(e=e||{}),this.element.classList.add("ol-canvas-control"),this.setCanvas(!!e.canvas),e||(e={}),e.style||(e.style=new ol.style.Style),this.setStyle(e.style)}setCanvas(e){if(this.isCanvas_=e,e&&this.setCollapsed(!1),this.element.style.visibility=e?"hidden":"visible",this.getMap())try{this.getMap().renderSync()}catch(e){}}setStyle(e){var t=e.getText();this.font_=t?t.getFont():"10px sans-serif";var i=t?t.getStroke():null,s=t?t.getFill():null;this.fontStrokeStyle_=i?ol.color.asString(i.getColor()):"#fff",this.fontFillStyle_=s?ol.color.asString(s.getColor()):"#000",this.fontStrokeWidth_=i?i.getWidth():3,this.getMap()&&this.getMap().render()}setMap(e){ol.control.CanvasBase.prototype.getCanvas.call(this,e);var t=this.getMap();if(this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),t)try{t.renderSync()}catch(e){}e&&(this._listener=e.on("postcompose",this.drawAttribution_.bind(this))),this.setCanvas(this.isCanvas_)}drawAttribution_(e){if(this.isCanvas_){var t=this.getContext(e);if(t){var i="";Array.prototype.slice.call(this.element.querySelectorAll("li")).filter(function(e){return"none"!==e.style.display}).map(function(e){i+=(i?" - ":"")+e.textContent});var s=e.frameState.pixelRatio;t.save(),t.scale(s,s);var o=this.element.getBoundingClientRect(),r=this.getMap().getViewport().getBoundingClientRect(),a=this.getMap().getSize()[0]/r.width;t.translate((o.left-r.left)*a,(o.top-r.top)*a);var n,l=this.element.clientHeight,h=this.element.clientWidth,c=ol.ext.element.getStyle(this.element,"textAlign")||"center";switch(c){case"left":n=0;break;case"right":n=h;break;default:n=h/2}t.beginPath(),t.strokeStyle=this.fontStrokeStyle_,t.fillStyle=this.fontFillStyle_,t.lineWidth=this.fontStrokeWidth_,t.textAlign=c,t.textBaseline="middle",t.font=this.font_,t.lineJoin="round",t.strokeText(i,n,l/2),t.fillText(i,n,l/2),t.closePath(),t.restore()}}}getContext(e){return ol.control.CanvasBase.prototype.getContext.call(this,e)}},ol.control.CanvasScaleLine=class extends ol.control.ScaleLine{constructor(e){(e=e||{}).bar=!1,super(e),this.element.classList.add("ol-canvas-control"),this.scaleHeight_=6,e||(e={}),e.style||(e.style=new ol.style.Style),this.setStyle(e.style)}setMap(e){ol.control.CanvasBase.prototype.getCanvas.call(this,e);var t=this.getMap();if(this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),t)try{t.renderSync()}catch(e){}e&&(this._listener=e.on("postcompose",this.drawScale_.bind(this))),this.element.style.visibility="hidden",this.olscale=this.element.querySelector(".ol-scale-line-inner")}setStyle(e){var t=e.getStroke();this.strokeStyle_=t?ol.color.asString(t.getColor()):"#000",this.strokeWidth_=t?t.getWidth():2;var i=e.getFill();this.fillStyle_=i?ol.color.asString(i.getColor()):"#fff";var s=e.getText();this.font_=s?s.getFont():"10px Arial",t=s?s.getStroke():null,i=s?s.getFill():null,this.fontStrokeStyle_=t?ol.color.asString(t.getColor()):this.fillStyle_,this.fontStrokeWidth_=t?t.getWidth():3,this.fontFillStyle_=i?ol.color.asString(i.getColor()):this.strokeStyle_,this.getMap()&&this.getMap().render()}drawScale_(e){if("hidden"===this.element.style.visibility&&"none"!==ol.ext.element.getStyle(this.element,"display")){var t=this.getContext(e);if(t){var i=parseInt(this.olscale.style.width);if(i){var s=this.olscale.textContent,o={left:this.element.offsetLeft,top:this.element.offsetTop},r=e.frameState.pixelRatio;t.save(),t.scale(r,r),o.top+=this.element.clientHeight-this.scaleHeight_,t.beginPath(),t.strokeStyle=this.fontStrokeStyle_,t.fillStyle=this.fontFillStyle_,t.lineWidth=this.fontStrokeWidth_,t.textAlign="center",t.textBaseline="bottom",t.font=this.font_,t.lineJoin="round",t.strokeText(s,o.left+i/2,o.top),t.fillText(s,o.left+i/2,o.top),t.closePath(),o.top+=2,t.lineWidth=this.strokeWidth_,t.strokeStyle=this.strokeStyle_;for(var a=4,n=parseInt(s);n%10==0;)n/=10;n%5==0&&(a=5);for(var l=0;l<a;l++)t.beginPath(),t.fillStyle=l%2?this.fillStyle_:this.strokeStyle_,t.rect(o.left+l*i/a,o.top,i/a,this.scaleHeight_),t.stroke(),t.fill(),t.closePath();t.restore()}}}}getContext(e){return ol.control.CanvasBase.prototype.getContext.call(this,e)}},ol.control.CanvasTitle=class extends ol.control.CanvasBase{constructor(e){e=e||{},super({element:ol.ext.element.create("DIV",{className:(e.className||"")+" ol-control-title ol-unselectable",style:{display:"block",visibility:"hidden"}}),style:e.style}),this.setTitle(e.title||""),this.setVisible(!1!==e.visible),this.element.style.font=this.getTextFont()}setStyle(e){super.setStyle(e),this.element&&(this.element.style.font=this.getTextFont()),this.getMap()&&this.getMap().render()}setTitle(e){if(this.element.textContent=e,this.set("title",e),this.getMap())try{this.getMap().renderSync()}catch(e){}}getTitle(){return this.get("title")}setVisible(e){if(this.element.style.display=e?"block":"none",this.getMap())try{this.getMap().renderSync()}catch(e){}}getVisible(){return"none"!==this.element.style.display}_draw(e){if(this.getVisible()){var t=this.getContext(e);if(t){var i=e.frameState.pixelRatio;t.save(),t.scale(i,i);var s=this.element.getBoundingClientRect(),o=this.getMap().getViewport().getBoundingClientRect(),r=this.getMap().getSize()[0]/o.width;t.translate(Math.round((s.left-o.left)*r),Math.round((s.top-o.top)*r));var a=this.element.clientHeight,n=this.element.clientWidth,l=n/2;t.beginPath(),t.fillStyle=ol.color.asString(this.getFill().getColor()),t.rect(0,0,n,a),t.fill(),t.closePath(),t.beginPath(),t.fillStyle=ol.color.asString(this.getTextFill().getColor()),t.strokeStyle=ol.color.asString(this.getTextStroke().getColor()),t.lineWidth=this.getTextStroke().getWidth(),t.textAlign="center",t.textBaseline="middle",t.font=this.getTextFont(),t.lineJoin="round",t.lineWidth&&t.strokeText(this.getTitle(),l,a/2),t.fillText(this.getTitle(),l,a/2),t.closePath(),t.restore()}}}},ol.control.CenterPosition=class extends ol.control.CanvasBase{constructor(e){e=e||{},super({element:ol.ext.element.create("DIV",{className:(e.className||"")+" ol-center-position ol-unselectable",style:{display:"block",visibility:"hidden"}}),style:e.style}),this.element.style.font=this.getTextFont(),this.set("projection",e.projection),this.setCanvas(e.canvas),this._format="function"==typeof e.coordinateFormat?e.coordinateFormat:ol.coordinate.toStringXY}setStyle(e){super.setStyle(e),this.element&&(this.element.style.font=this.getTextFont()),this.getMap()&&this.getMap().render()}setCanvas(e){if(this.set("canvas",e),this.element.style.visibility=e?"hidden":"visible",this.getMap())try{this.getMap().renderSync()}catch(e){}}setVisible(e){if(this.element.style.display=e?"":"none",this.getMap())try{this.getMap().renderSync()}catch(e){}}getVisible(){return"none"!==this.element.style.display}_draw(e){if(this.getVisible()&&this.getMap()){var t=this.getMap().getView().getCenter();if(this.get("projection")&&(t=ol.proj.transform(t,this.getMap().getView().getProjection(),this.get("projection"))),t=this._format(t),this.element.textContent=t,this.get("canvas")){var i=this.getContext(e);if(i){var s=e.frameState.pixelRatio;i.save(),i.scale(s,s);var o=this.element.getBoundingClientRect(),r=this.getMap().getViewport().getBoundingClientRect(),a=this.getMap().getSize()[0]/r.width;i.translate((o.left-r.left)*a,(o.top-r.top)*a);var n=this.element.clientHeight,l=this.element.clientWidth;i.beginPath(),i.fillStyle=ol.color.asString(this.getTextFill().getColor()),i.strokeStyle=ol.color.asString(this.getTextStroke().getColor()),i.lineWidth=this.getTextStroke().getWidth(),i.textAlign="center",i.textBaseline="middle",i.font=this.getTextFont(),i.lineJoin="round",i.lineWidth&&i.strokeText(t,l/2,n/2),i.fillText(t,l/2,n/2),i.closePath(),i.restore()}}}}},ol.control.Compass=class extends ol.control.CanvasBase{constructor(e){e=e||{};var t=document.createElement("div");t.className="ol-control ol-compassctrl ol-unselectable ol-hidden"+(e.className?" "+e.className:""),t.style.position="absolute",t.style.visibility="hidden";var i=e.style instanceof ol.style.Stroke?new ol.style.Style({stroke:e.style}):e.style;e.style||(i=new ol.style.Style({stroke:new ol.style.Stroke({width:0})})),super({element:t,style:i}),this.set("rotateVithView",!1!==e.rotateWithView),this.setVisible(!1!==e.visible),this.setImage(e.image||e.src)}setImage(e){if(e instanceof Image)this.img_=e,this.img_.onload=function(){if(this.getMap())try{this.getMap().renderSync()}catch(e){}}.bind(this);else if("string"==typeof e)switch(e){case"compact":this.img_=this.compactCompass_(this.element.clientWidth,this.getStroke().getColor());break;case"default":this.img_=this.defaultCompass_(this.element.clientWidth,this.getStroke().getColor());break;default:this.img_=new Image,this.img_.onload=function(){if(this.getMap())try{this.getMap().renderSync()}catch(e){}}.bind(this),this.img_.src=e}else this.img_=this.defaultCompass_(this.element.clientWidth,this.getStroke().getColor())}compactCompass_(e,t){var i=document.createElement("canvas"),s=i.getContext("2d"),o=(e=i.width=i.height=e||150)/2;return s.translate(o,o),s.fillStyle=t||"#963",s.lineWidth=5,s.lineJoin=s.lineCap="round",s.font="bold "+.4*o+"px sans-serif",s.textBaseline="bottom",s.textAlign="center",s.strokeStyle="#fff",s.globalAlpha=.75,s.strokeText("N",0,-o/2),s.globalAlpha=1,s.fillText("N",0,-o/2),s.beginPath(),s.moveTo(0,o/4),s.lineTo(o/3,o/2),s.lineTo(0,-o/2),s.lineTo(-o/3,o/2),s.lineTo(0,o/4),s.lineWidth=12,s.fillStyle="#fff",s.globalAlpha=.75,s.fill(),s.stroke(),s.globalAlpha=1,s.fillStyle=s.strokeStyle=t||"#963",s.lineWidth=5,s.beginPath(),s.moveTo(0,o/4),s.lineTo(0,-o/2),s.lineTo(o/3,o/2),s.lineTo(0,o/4),s.fill(),s.stroke(),s.beginPath(),s.moveTo(0,o/4),s.lineTo(0,-o/2),s.lineTo(-o/3,o/2),s.lineTo(0,o/4),s.stroke(),i}defaultCompass_(e,t){var i=document.createElement("canvas"),s=i.getContext("2d"),o=(e=i.width=i.height=e||150)/2,r=.22*o;function a(e,i){s.fillStyle=t||"#963",s.beginPath(),s.moveTo(0,0),s.lineTo(e,0),s.lineTo(i,i),s.moveTo(0,0),s.lineTo(-e,0),s.lineTo(-i,-i),s.moveTo(0,0),s.lineTo(0,e),s.lineTo(-i,i),s.moveTo(0,0),s.lineTo(0,-e),s.lineTo(i,-i),s.moveTo(0,0),s.fill(),s.stroke()}function n(e,t){s.globalCompositeOperation="destination-out",s.fillStyle="#fff",s.beginPath(),s.moveTo(0,0),s.lineTo(e,0),s.lineTo(t,-t),s.moveTo(0,0),s.lineTo(-e,0),s.lineTo(-t,t),s.moveTo(0,0),s.lineTo(0,e),s.lineTo(t,t),s.moveTo(0,0),s.lineTo(0,-e),s.lineTo(-t,-t),s.moveTo(0,0),s.fill(),s.globalCompositeOperation="source-over",s.beginPath(),s.moveTo(0,0),s.lineTo(e,0),s.lineTo(t,-t),s.moveTo(0,0),s.lineTo(-e,0),s.lineTo(-t,t),s.moveTo(0,0),s.lineTo(0,e),s.lineTo(t,t),s.moveTo(0,0),s.lineTo(0,-e),s.lineTo(-t,-t),s.moveTo(0,0),s.stroke()}return s.translate(o,o),s.strokeStyle=t||"#963",s.lineWidth=1.5,s.beginPath(),s.arc(0,0,.41*e,0,2*Math.PI),s.arc(0,0,.44*e,0,2*Math.PI),s.stroke(),s.rotate(Math.PI/4),a(.9*o,.8*r),n(.9*o,.8*r),s.rotate(-Math.PI/4),a(o,r),n(o,r),i}getVisible(){return"block"===ol.ext.element.getStyle(this.element,"display")}setVisible(e){e?this.element.classList.add("ol-visible"):this.element.classList.remove("ol-visible"),this.getMap()&&this.getMap().render()}_draw(e){var t=this.getContext(e);if(t&&this.getVisible()){var i,s=t.canvas,o=[];for(i=0;i<8;i++)o[i]=[Math.cos(Math.PI*i/8),Math.sin(Math.PI*i/8)];var r=e.frameState.pixelRatio;t.save(),t.scale(r,r);var a=this.element.clientWidth,n=this.element.clientHeight,l=this.element.offsetLeft,h=this.element.offsetTop,c=this.img_,u=e.frameState.viewState.rotation;if(t.beginPath(),t.translate(l+a/2,h+n/2),this.get("rotateVithView")&&t.rotate(u),this.getStroke().getWidth()){t.beginPath(),t.strokeStyle=this.getStroke().getColor(),t.lineWidth=this.getStroke().getWidth();var d=Math.max(s.width,s.height);for(i=0;i<8;i++)t.moveTo(-o[i][0]*d,-o[i][1]*d),t.lineTo(o[i][0]*d,o[i][1]*d);t.stroke()}c.width&&t.drawImage(c,-a/2,-n/2,a,n),t.closePath(),t.restore()}}},ol.control.Dialog=class extends ol.control.Control{constructor(e){(e=e||{}).fullscreen&&(e.target=document.body);var t=e.target===document.body,i=ol.ext.element.create(t?"DIALOG":"DIV",{className:((e.className||"")+(e.zoom?" ol-zoom":"")+" ol-ext-dialog").trim()});super({element:i,target:e.target}),t&&(i.addEventListener("close",function(){this.hide()}.bind(this)),document.addEventListener("keydown",function(e){"Escape"===e.key&&!this.get("closeBox")&&this.isOpen()&&e.preventDefault()}.bind(this)),i.addEventListener("cancel",function(){setTimeout(function(){this.dispatchEvent("cancel")}.bind(this))}.bind(this))),i.addEventListener("click",function(e){this.get("hideOnBack")&&e.target===i&&this.close(),this.get("hideOnClick")&&this.close()}.bind(this));var s=ol.ext.element.create("FORM",{on:{submit:this._onButton("submit")},parent:i});ol.ext.element.create("H2",{parent:s}),ol.ext.element.create("DIV",{className:"ol-closebox",click:this._onButton("cancel"),parent:s}),ol.ext.element.create("DIV",{className:"ol-content",parent:s}),this._progress=ol.ext.element.create("DIV",{style:{display:"none"},parent:s});var o=ol.ext.element.create("DIV",{className:"ol-progress-bar",parent:this._progress});this._progressbar=ol.ext.element.create("DIV",{parent:o}),this._progressMessage=ol.ext.element.create("DIV",{className:"ol-progress-message",parent:this._progress}),ol.ext.element.create("DIV",{className:"ol-buttons",parent:s}),this.set("closeBox",!1!==e.closeBox),this.set("zoom",!!e.zoom),this.set("hideOnClick",!!e.hideOnClick),this.set("hideOnBack",!!e.hideOnBack),this.set("className",i.className),this.set("closeOnSubmit",e.closeOnSubmit),this.set("buttons",e.buttons),this.setContent(e)}show(e){e&&((e instanceof Element||"string"==typeof e)&&(e={content:e}),this.setContent(e)),this.element.showModal&&this.element.showModal(),this.element.classList.add("ol-visible"),this.element.setAttribute("aria-hidden",!1);var t=this.element.querySelector('input[type="text"],input[type="search"],input[type="number"]');if(t&&setTimeout(function(){t.focus()}),this.dispatchEvent({type:"show"}),e){if(e.autoclose){var i=setTimeout(function(){this.hide()}.bind(this),e.autoclose);this.once("hide",function(){clearTimeout(i)})}if(e.hideOnBack){var s=this.get("hideOnBack");this.set("hideOnBack",!0),this.once("hide",function(){this.set("hideOnBack",s)}.bind(this))}}}open(){this.show()}setContentMessage(e){if(void 0!==e){var t=this.getContentElement();e instanceof Element&&ol.ext.element.setHTML(t,""),ol.ext.element.setHTML(t,e||"")}}setTitle(e){var t=this.element.querySelector("form");t.querySelector("h2").innerText=e||"",e?t.classList.add("ol-title"):t.classList.remove("ol-title")}setContent(e){if(e){this.element.className=this.get("className"),"string"==typeof e&&(e={content:e}),e=e||{},this.setProgress(!1),e.max&&this.setProgress(0,e.max),void 0!==e.progress&&this.setProgress(e.progress),this.get("zoom")?this.element.classList.add("ol-zoom"):this.element.classList.remove("ol-zoom"),e.className&&e.className.split(" ").forEach(function(e){this.element.classList.add(e)}.bind(this));var t=this.element.querySelector("form");void 0!==e.content&&(e.content instanceof Element&&ol.ext.element.setHTML(t.querySelector(".ol-content"),""),ol.ext.element.setHTML(t.querySelector(".ol-content"),e.content||"")),this.setTitle(e.title),e.closeBox||this.get("closeBox")&&!1!==e.closeBox?t.classList.add("ol-closebox"):t.classList.remove("ol-closebox");var i=this.element.querySelector(".ol-buttons");i.innerHTML="";var s=e.buttons||this.get("buttons");if(s)for(var o in t.classList.add("ol-button"),s)ol.ext.element.create("INPUT",{type:"submit"===o?"submit":"button",value:s[o],click:this._onButton(o,e.onButton),parent:i});else t.classList.remove("ol-button")}}getContentElement(){return this.element.querySelector("form .ol-content")}setProgress(e,t,i){if(!1!==e){if(t>0?this.set("max",Number(t)):t=this.get("max"),t){var s=Math.round(e/t*100);ol.ext.element.setStyle(this._progress,{display:""}),this._progressbar.className=s?"":"notransition",ol.ext.element.setStyle(this._progressbar,{width:s+"%"})}else ol.ext.element.setStyle(this._progress,{display:"none"});this._progressMessage.innerHTML="",ol.ext.element.setHTML(this._progressMessage,i||"")}else ol.ext.element.setStyle(this._progress,{display:"none"})}_onButton(e,t){return function(i){i.preventDefault(),"submit"===e&&!1===this.get("closeOnSubmit")||this.hide();var s=this.getInputs();setTimeout(function(){this.dispatchEvent({type:"button",button:e,inputs:s}),"function"==typeof t&&t(e,s)}.bind(this))}.bind(this)}getInputs(){var e={};return["input","textarea","select"].forEach(function(t){this.element.querySelectorAll("form "+t).forEach(function(t){t.className&&t.className.split(" ").forEach(function(i){e[i]=t})})}.bind(this)),e}hide(){document.activeElement&&document.activeElement!==document.body&&document.activeElement.blur(),this.element.close&&this.element.close(),this.isOpen()&&(this.element.classList.remove("ol-visible"),this.element.setAttribute("aria-hidden",!0),setTimeout(function(){this.dispatchEvent({type:"hide"})}.bind(this)))}close(){this.hide()}isOpen(){return this.element.classList.contains("ol-visible")}},ol.control.Disable=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");t.className=(e.className||" ol-disable ol-unselectable ol-control").trim();var i={top:"0px",left:"0px",right:"0px",bottom:"0px",zIndex:1e4,background:"none",display:"none"};Object.keys(i).forEach(function(e){t.style[e]=i[e]}),super({element:t})}isOn(){return this.element.classList.contains("ol-disable")}disableMap(e){e?(this.element.classList.add("ol-enable"),this.element.style.display="block"):(this.element.classList.remove("ol-enable"),this.element.style.display="none")}},ol.control.EditBar=class extends ol.control.Bar{constructor(e){(e=e||{}).interactions=e.interactions||{},super({className:(e.className?e.className+" ":"")+"ol-editbar",toggleOne:!0,target:e.target}),this._source=e.source,this._interactions={},this._setSelectInteraction(e),!1!==e.edition&&this._setEditInteraction(e),this._setModifyInteraction(e)}setMap(e){this.getMap()&&(this._interactions.Delete&&this.getMap().removeInteraction(this._interactions.Delete),this._interactions.ModifySelect&&this.getMap().removeInteraction(this._interactions.ModifySelect)),super.setMap(e),this.getMap()&&(this._interactions.Delete&&this.getMap().addInteraction(this._interactions.Delete),this._interactions.ModifySelect&&this.getMap().addInteraction(this._interactions.ModifySelect))}getInteraction(e){return this._interactions[e]}_getTitle(e){if(e)return e.get?e.get("title"):"string"==typeof e?e:e.title}_setSelectInteraction(e){var t,i=this,s=new ol.control.Bar;if(!1!==e.interactions.Delete){e.interactions.Delete instanceof ol.interaction.Delete?this._interactions.Delete=e.interactions.Delete:this._interactions.Delete=new ol.interaction.Delete;var o=this._interactions.Delete;o.setActive(!1),this.getMap()&&this.getMap().addInteraction(o),s.addControl(new ol.control.Button({className:"ol-delete",title:this._getTitle(e.interactions.Delete)||"Delete",name:"Delete",handleClick:function(e){o.delete(t.getInteraction().getFeatures());var i={type:"select",selected:[],deselected:t.getInteraction().getFeatures().getArray().slice(),mapBrowserEvent:e.mapBrowserEvent};t.getInteraction().getFeatures().clear(),t.getInteraction().dispatchEvent(i)}}))}if(!1!==e.interactions.Info&&s.addControl(new ol.control.Button({className:"ol-info",name:"Info",title:this._getTitle(e.interactions.Info)||"Show informations",handleClick:function(){i.dispatchEvent({type:"info",features:t.getInteraction().getFeatures()})}})),!1!==e.interactions.Select){e.interactions.Select instanceof ol.interaction.Select?this._interactions.Select=e.interactions.Select:this._interactions.Select=new ol.interaction.Select({condition:ol.events.condition.click});var r=this._interactions.Select;t=new ol.control.Toggle({className:"ol-selection",name:"Select",title:this._getTitle(e.interactions.Select)||"Select",interaction:r,bar:s.getControls().length?s:void 0,autoActivate:!0,active:!0}),this.addControl(t),r.on("change:active",function(){r.getActive()||r.getFeatures().clear()})}}_setEditInteraction(e){if(!1!==e.interactions.DrawPoint){e.interactions.DrawPoint instanceof ol.interaction.Draw?this._interactions.DrawPoint=e.interactions.DrawPoint:this._interactions.DrawPoint=new ol.interaction.Draw({type:"Point",source:this._source});var t=new ol.control.Toggle({className:"ol-drawpoint",name:"DrawPoint",title:this._getTitle(e.interactions.DrawPoint)||"Point",interaction:this._interactions.DrawPoint});this.addControl(t)}if(!1!==e.interactions.DrawLine){e.interactions.DrawLine instanceof ol.interaction.Draw?this._interactions.DrawLine=e.interactions.DrawLine:this._interactions.DrawLine=new ol.interaction.Draw({type:"LineString",source:this._source,geometryFunction:function(e,t){return t?t.setCoordinates(e):t=new ol.geom.LineString(e),this.nbpts=t.getCoordinates().length,t}});var i=new ol.control.Toggle({className:"ol-drawline",title:this._getTitle(e.interactions.DrawLine)||"LineString",name:"DrawLine",interaction:this._interactions.DrawLine,bar:new ol.control.Bar({controls:[new ol.control.TextButton({html:this._getTitle(e.interactions.UndoDraw)||"undo",title:this._getTitle(e.interactions.UndoDraw)||"delete last point",handleClick:function(){i.getInteraction().nbpts>1&&i.getInteraction().removeLastPoint()}}),new ol.control.TextButton({html:this._getTitle(e.interactions.FinishDraw)||"finish",title:this._getTitle(e.interactions.FinishDraw)||"finish",handleClick:function(){i.getInteraction().nbpts>2&&i.getInteraction().finishDrawing()}})]})});this.addControl(i)}if(!1!==e.interactions.DrawPolygon&&(e.interactions.DrawPolygon instanceof ol.interaction.Draw?this._interactions.DrawPolygon=e.interactions.DrawPolygon:this._interactions.DrawPolygon=new ol.interaction.Draw({type:"Polygon",source:this._source,geometryFunction:function(e,t){return this.nbpts=e[0].length,t?t.setCoordinates([e[0].concat([e[0][0]])]):t=new ol.geom.Polygon(e),t}}),this._setDrawPolygon("ol-drawpolygon",this._interactions.DrawPolygon,this._getTitle(e.interactions.DrawPolygon)||"Polygon","DrawPolygon",e)),!1!==e.interactions.DrawHole&&(e.interactions.DrawHole instanceof ol.interaction.DrawHole?this._interactions.DrawHole=e.interactions.DrawHole:this._interactions.DrawHole=new ol.interaction.DrawHole,this._setDrawPolygon("ol-drawhole",this._interactions.DrawHole,this._getTitle(e.interactions.DrawHole)||"Hole","DrawHole",e)),!1!==e.interactions.DrawRegular){var s={pts:"pts",circle:"circle"};e.interactions.DrawRegular instanceof ol.interaction.DrawRegular?(this._interactions.DrawRegular=e.interactions.DrawRegular,s.pts=this._interactions.DrawRegular.get("ptsLabel")||s.pts,s.circle=this._interactions.DrawRegular.get("circleLabel")||s.circle):(this._interactions.DrawRegular=new ol.interaction.DrawRegular({source:this._source,sides:4}),e.interactions.DrawRegular&&(s.pts=e.interactions.DrawRegular.ptsLabel||s.pts,s.circle=e.interactions.DrawRegular.circleLabel||s.circle));var o=this._interactions.DrawRegular,r=document.createElement("DIV"),a=ol.ext.element.create("DIV",{parent:r});ol.ext.element.addListener(a,["click","touchstart"],function(){var e=o.getSides()-1;e<2&&(e=2),o.setSides(e),n.textContent=e>2?e+" "+s.pts:s.circle}.bind(this));var n=ol.ext.element.create("TEXT",{html:"4 "+s.pts,parent:r}),l=ol.ext.element.create("DIV",{parent:r});ol.ext.element.addListener(l,["click","touchstart"],function(){var e=o.getSides()+1;e<3&&(e=3),o.setSides(e),n.textContent=e+" "+s.pts}.bind(this));var h=new ol.control.Toggle({className:"ol-drawregular",title:this._getTitle(e.interactions.DrawRegular)||"Regular",name:"DrawRegular",interaction:this._interactions.DrawRegular,bar:new ol.control.Bar({controls:[new ol.control.TextButton({html:r})]})});this.addControl(h)}}_setDrawPolygon(e,t,i,s,o){var r=new ol.control.Toggle({className:e,name:s,title:i,interaction:t,bar:new ol.control.Bar({controls:[new ol.control.TextButton({html:this._getTitle(o.interactions.UndoDraw)||"undo",title:this._getTitle(o.interactions.UndoDraw)||"undo last point",handleClick:function(){r.getInteraction().nbpts>1&&r.getInteraction().removeLastPoint()}}),new ol.control.TextButton({html:this._getTitle(o.interactions.FinishDraw)||"finish",title:this._getTitle(o.interactions.FinishDraw)||"finish",handleClick:function(){r.getInteraction().nbpts>3&&r.getInteraction().finishDrawing()}})]})});return this.addControl(r),r}_setModifyInteraction(e){if(!1!==e.interactions.ModifySelect&&!1!==e.interactions.Select&&(e.interactions.ModifySelect instanceof ol.interaction.ModifyFeature?this._interactions.ModifySelect=e.interactions.ModifySelect:this._interactions.ModifySelect=new ol.interaction.ModifyFeature({features:this.getInteraction("Select").getFeatures()}),this.getMap()&&this.getMap().addInteraction(this._interactions.ModifySelect),this._interactions.ModifySelect.setActive(this._interactions.Select.getActive()),this._interactions.Select.on("change:active",function(){this._interactions.ModifySelect.setActive(this._interactions.Select.getActive())}.bind(this))),!1!==e.interactions.Transform){e.interactions.Transform instanceof ol.interaction.Transform?this._interactions.Transform=e.interactions.Transform:this._interactions.Transform=new ol.interaction.Transform({addCondition:ol.events.condition.shiftKeyOnly});var t=new ol.control.Toggle({html:"<i></i>",className:"ol-transform",title:this._getTitle(e.interactions.Transform)||"Transform",name:"Transform",interaction:this._interactions.Transform});this.addControl(t)}if(!1!==e.interactions.Split){e.interactions.Split instanceof ol.interaction.Split?this._interactions.Split=e.interactions.Split:this._interactions.Split=new ol.interaction.Split({sources:this._source});var i=new ol.control.Toggle({className:"ol-split",title:this._getTitle(e.interactions.Split)||"Split",name:"Split",interaction:this._interactions.Split});this.addControl(i)}if(!1!==e.interactions.Offset){e.interactions.Offset instanceof ol.interaction.Offset?this._interactions.Offset=e.interactions.Offset:this._interactions.Offset=new ol.interaction.Offset({source:this._source});var s=new ol.control.Toggle({html:"<i></i>",className:"ol-offset",title:this._getTitle(e.interactions.Offset)||"Offset",name:"Offset",interaction:this._interactions.Offset});this.addControl(s)}}},ol.control.FeatureList=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:((e.className||"")+" ol-feature-list").trim()});e.target||(t.classList.add("ol-unselectable"),t.classList.add("ol-control"),t.dataset.control=1),super({element:t,target:e.target}),this._listFeatures=[],this._columns=[],this._bottomScroll=t.classList.contains("ol-bottom"),this.set("pageLength",e.pageLength||100),this._canSort=[],this._sort={},e.target||ol.ext.element.create("BUTTON",{type:"button",click:function(){this.collapse()}.bind(this),parent:t});var i=ol.ext.element.create("DIV",{className:"ol-content",parent:t});this._menu=ol.ext.element.create("DIV",{className:"ol-header",html:'<div class="ol-buttons"></div>',parent:i}),ol.ext.element.create("P",{text:e.title||"",parent:this._menu}),this.addButton({className:"ol-closebox",type:"button",click:function(){this.collapse()}.bind(this),parent:this._menu});var s=ol.ext.element.create("DIV",{className:"ol-sizer",parent:i});s.addEventListener("mousedown",this._dragSizer.bind(this)),s.addEventListener("touchstart",this._dragSizer.bind(this));var o=this._list=ol.ext.element.create("TABLE",{className:"ol-list",parent:ol.ext.element.create("DIV",{className:"ol-scroll-container",tabindex:-1,parent:i})});o.parentNode.addEventListener("scroll",this._drawPage.bind(this)),this._head=ol.ext.element.create("THEAD",{parent:o}),this._listbody=ol.ext.element.create("TBODY",{parent:o}),this.collapse(!1!==e.collapsed),this.setFeatures(e.features)}setMap(e){super.setMap(e),e.addEventListener("change:size",this.resize.bind(this)),this.resize()}},ol.control.FeatureList.prototype.setBottomScroll=function(e){this._bottomScroll=!!e,this._bottomScroll?this.element.classList.add("ol-bottom"):this.element.classList.remove("ol-bottom")},ol.control.FeatureList.prototype.scrollTo=function(e){if("select"===e)return!!this._curSelection&&this.scrollTo(this._curSelection.feature);var t=this._findFeatureIndex(e);if(t>=0){var i=this._list.parentNode;i.scrollTo(i.scrollLeft,(t+1.5)*this.getRowHeight()-i.getBoundingClientRect().height/2);var s=this._findInPage(e);return{feature:e,tr:s?s.tr:ol.ext.element.create("TR")}}return!1},ol.control.FeatureList.prototype._findFeatureIndex=function(e){var t=this._listFeatures;if(t)for(var i=0;i<t.length;i++)if(t[i]===e)return i;return-1},ol.control.FeatureList.prototype._findInPage=function(e){var t=this._page;if(t)for(var i=0;i<t.length;i++)if(t[i].feature===e)return t[i];return!1},ol.control.FeatureList.prototype.collapse=function(e){void 0===e&&(e=!this._collapsed),e!==this._collapsed&&(this._collapsed=e,this._collapsed?this.element.classList.add("ol-collapsed"):this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"collapse",collapsed:this._collapsed}),this._collapsed||this.refresh())},ol.control.FeatureList.prototype.isCollapsed=function(){return this._collapsed},ol.control.FeatureList.prototype.setFeatures=function(e){this._drawbind||(this._drawbind=this._drawList.bind(this)),this._source&&this._source.un&&this._source.un(["loadend","addfeature","removefeature","add","remove"],this._drawbind),this._source=e||[],this._drawList(),this._source.on&&this._source.on(["loadend","addfeature","removefeature","add","remove"],this._drawbind)},ol.control.FeatureList.prototype.sortBy=function(e,t){t?this._sort[e]="down"!==t:delete this._sort[e],this.sort(!0),this.dispatchEvent({type:"sort",property:e,sort:t})},ol.control.FeatureList.prototype.getSort=function(){return this._sort},ol.control.FeatureList.prototype.resetSort=function(){this._sort={},this.sort()},ol.control.FeatureList.prototype.enableSort=function(){this._canSort=[...arguments],Object.keys(this._sort).forEach(function(e){this._canSort.indexOf(e)<0&&delete this._sort[e]}.bind(this)),this.sort()},ol.control.FeatureList.prototype._drawList=function(e){if(e)return clearTimeout(this._drawout),void(this._drawout=setTimeout(this._drawList.bind(this),100));var t=this._source.getFeatures?this._source.getFeatures():this._source;this._columns=this.getColumns(t),this._drawHead(),this._listFeatures=[],t.forEach(function(e){this._listFeatures.push(e)}.bind(this)),this.sort()},ol.control.FeatureList.prototype.updateFeature=function(e){var t=this._findInPage(e);return!!t&&(this._updateFeature(t.feature,t.tr),!0)},ol.control.FeatureList.prototype._updateFeature=function(e,t){t.innerHTML="",this._columns.forEach(function(i){var s=this.formatProperty(e,i);ol.ext.element.create("TD",{text:s.val,html:s.html,className:s.type,"data-prop":i,parent:t})}.bind(this)),this._curSelection&&this._curSelection.feature===e&&(this._curSelection.tr=t,t.classList.add("ol-selected"))},ol.control.FeatureList.prototype._getLi=function(e){var t=ol.ext.element.create("TR",{on:{click:function(t){var i=t.target.closest("TD");this.dispatchEvent({type:"select",property:i.dataset.prop,feature:e,row:t.target.closest("TR"),col:i,originalEvent:t}),this.select(e,!0)}.bind(this),dblclick:function(t){var i=t.target.closest("TD");this.dispatchEvent({type:"dblclick",property:i.dataset.prop,feature:e,row:t.target.closest("TR"),col:i,originalEvent:t})}.bind(this)}});return this._updateFeature(e,t),t},ol.control.FeatureList.prototype._drawHead=function(){var e=this._columns;this._head.innerHTML="";var t=ol.ext.element.create("TR",{parent:this._head});e.forEach(function(e){var i=ol.ext.element.create("TD",{html:ol.ext.element.create("P",{text:e}),parent:t});if(this._canSort.length&&this._canSort.indexOf(e)>=0){i.classList.add("sort");var s=ol.ext.element.create("BUTTON",{className:"sort"+(!0===this._sort[e]?" sortup":!1===this._sort[e]?" sortdown":""),click:function(){var t;s.classList.contains("sortup")?t="down":s.classList.contains("sortdown")||(t="up"),this.sortBy(e,t)}.bind(this),parent:i})}}.bind(this))},ol.control.FeatureList.prototype.sort=function(e){var t=Object.keys(this._sort);t.length&&this._listFeatures.sort(function(e,i){for(var s=0;s<t.length;s++){var o=t[s],r=this.sortFn(e,i,o);if(r)return this._sort[o]?r:-r}return 0}.bind(this)),this.refresh(!0),e||this.dispatchEvent({type:"sort"})},ol.control.FeatureList.prototype.refresh=function(e){e&&(this._curPage=-1),this._drawHead(),this._drawPage(),this.resize()},ol.control.FeatureList.prototype.update=function(){this._drawList(),this._curSelection&&this._curSelection.feature&&this.select(this._curSelection.feature,!0)},ol.control.FeatureList.prototype.getRowHeight=function(){return this._head.getBoundingClientRect().height},ol.control.FeatureList.prototype._drawPage=function(){var e=Math.round(this.get("pageLength")/2),t=Math.round(e/2),i=this._list.parentNode.scrollTop,s=this.getRowHeight(),o=Math.round((i/s-t)/e);if(o*e>this._listFeatures.length&&(o=0),o!==this._curPage){this._curPage=o,this._listbody.innerHTML="",this._listbody.appendChild(ol.ext.element.create("TR",{style:{height:Math.max(0,(o*e-t)*s)+"px"}}));var r=Math.min(this._listFeatures.length,(o+1)*e+t);this._page=[];for(var a=Math.max(0,o*e-t);a<r;a++){var n=this._getLi(this._listFeatures[a]);this._page.push({feature:this._listFeatures[a],tr:n}),this._curSelection&&this._listFeatures[a]===this._curSelection.feature&&(this._curSelection.tr=n,n.classList.add("ol-selected")),this._listbody.appendChild(n)}this._listbody.appendChild(ol.ext.element.create("TR",{style:{height:Math.max(0,(this._listFeatures.length-r)*s)+"px"}})),!1!==this.get("focus")&&this._listbody.focus()}},ol.control.FeatureList.prototype.sortFn=function(e,t,i){var s=e.get(i)||"",o=t.get(i)||"";return s<o?-1:s>o?1:0},ol.control.FeatureList.prototype.formatProperty=function(e,t){var i=e.get(t);return{val:void 0===i?"-":i,type:typeof i}},ol.control.FeatureList.prototype.getColumns=function(e){var t=this.columns||[];if(!t.length&&e){var i={};e.forEach(function(e){Object.keys(e.getProperties()).forEach(function(t){e.get(t)instanceof ol.geom.Geometry||(i[t]=!0)})}),t=Object.keys(i)}return t},ol.control.FeatureList.prototype.setColumns=function(e){this.columns=e||[],this._drawList(),this._curSelection&&this._curSelection.feature&&this.select(this._curSelection.feature,!0)},ol.control.FeatureList.prototype._dragSizer=function(e){var t=this;switch(this._movefn||(this._movefn=this._dragSizer.bind(this)),e.stopPropagation(),e.preventDefault(),e.type){case"touchcancel":case"touchend":case"mouseup":t._pageY=!1,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(e){document.removeEventListener(e,t._movefn)});break;case"mousedown":case"touchstart":t._contentHeight=t._list.parentNode.getBoundingClientRect().height,t._pageY=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(e){document.addEventListener(e,t._movefn)});case"mousemove":case"touchmove":if(!1!==t.pageY){var i=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY;this._bottomScroll?t.resize(t._contentHeight+i-t._pageY):t.resize(t._contentHeight-i+t._pageY)}}},ol.control.FeatureList.prototype.resize=function(e){if(this.getMap()){var t=this._list.parentNode.getBoundingClientRect().height;if(void 0!==e&&(this._list.parentNode.style.height=e+"px"),this.element.dataset.control){var i=this.getMap().getTargetElement().getBoundingClientRect().height-this._head.getBoundingClientRect().height;this._list.parentNode.style.maxHeight=Math.min(i,this._list.getBoundingClientRect().height)+"px"}t!==this._list.parentNode.getBoundingClientRect().height&&this.dispatchEvent({type:"resize",height:this._list.parentNode.getBoundingClientRect().height})}},ol.control.FeatureList.prototype.getSelection=function(){return this._curSelection&&this._curSelection.feature||null},ol.control.FeatureList.prototype.select=function(e,t){if(this._curSelection&&this._curSelection.tr.classList.remove("ol-selected"),this._curSelection=null,e)if(t){var i=this._findInPage(e);this._curSelection={feature:e,tr:i?i.tr:ol.ext.element.create("TR")}}else this._curSelection=this.scrollTo(e);this._curSelection&&this._curSelection.tr.classList.add("ol-selected")},ol.control.FeatureList.prototype.addButton=function(e){return ol.ext.element.create("BUTTON",{className:e.className,title:e.title||"",html:e.html||"",click:e.click,parent:this._menu.querySelector(".ol-buttons")})},ol.control.Gauge=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:((e.className||"")+" ol-gauge ol-unselectable ol-control").trim()});super({element:t,target:e.target}),this.title_=ol.ext.element.create("SPAN",{parent:t});var i=ol.ext.element.create("DIV",{parent:t});this.gauge_=ol.ext.element.create("BUTTON",{type:"button",style:{width:"0px"},parent:i}),this.setTitle(e.title),this.set("max",e.max||100),this.val(e.val)}setTitle(e){this.title_.innerHTML=e||"",this.title_.display=e?"":"none"}val(e){return void 0!==e&&(this.val_=e,this.gauge_.style.width=e/this.get("max")*100+"%"),this.val_}},ol.control.GeoBookmark=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");super({element:t,target:e.target}),e.target?t.className=e.className||"ol-bookmark":(t.className=(e.className||"ol-bookmark")+" ol-unselectable ol-control ol-collapsed",t.addEventListener("mouseleave",function(){o!==document.activeElement&&this.element.classList.add("ol-collapsed")}.bind(this)),this.button=ol.ext.element.create("BUTTON",{type:"button",title:e.title||"Geobookmarks",click:function(){var e=!this.element.classList.contains("ol-collapsed");this.element.classList.toggle("ol-collapsed"),e&&this.setBookmarks()}.bind(this)}),t.appendChild(this.button));var i=document.createElement("div");t.appendChild(i);var s=document.createElement("ul");i.appendChild(s);var o=document.createElement("input");o.setAttribute("placeholder",e.placeholder||"Add a new geomark..."),o.addEventListener("keydown",function(e){if(e.stopPropagation(),13===e.keyCode){e.preventDefault();var t=o.value;t&&(this.addBookmark(t),o.value="",this.dispatchEvent({type:"add",name:t})),this.element.classList.add("ol-collapsed")}}.bind(this)),o.addEventListener("blur",function(){this.element.classList.add("ol-collapsed")}.bind(this)),i.appendChild(o),this.on("propertychange",function(e){"editable"===e.key&&(t.className=t.className.replace(" ol-editable",""),this.get("editable")&&(t.className+=" ol-editable"))}.bind(this)),this.set("namespace",e.namespace||"ol"),this.set("editable",!1!==e.editable),this.set("deleteTitle",e.deleteTitle||"Suppr.");var r={};try{localStorage[this.get("namespace")+"@bookmark"]&&(r=JSON.parse(localStorage[this.get("namespace")+"@bookmark"]))}catch(e){console.warn("Failed to access localStorage...")}if(e.marks)for(var a in e.marks)r[a]=e.marks[a];this.setBookmarks(r)}setBookmarks(e){if(!e){e={};try{e=JSON.parse(localStorage[this.get("namespace")+"@bookmark"]||"{}")}catch(e){console.warn("Failed to access localStorage...")}}var t=this.get("editable"),i=this.element.querySelector("ul"),s=this;for(var o in i.innerHTML="",e){var r=document.createElement("li");if(r.textContent=o,r.setAttribute("data-bookmark",JSON.stringify(e[o])),r.setAttribute("data-name",o),r.addEventListener("click",function(e){var t=JSON.parse(e.target.getAttribute("data-bookmark"));this.getMap().getView().setCenter(t.pos),this.getMap().getView().setZoom(t.zoom),this.getMap().getView().setRotation(t.rot||0),this.element.classList.add("ol-collapsed"),this.dispatchEvent({type:"select",name:e.target.getAttribute("data-name"),bookmark:t})}.bind(this)),i.appendChild(r),t&&!e[o].permanent){var a=document.createElement("button");a.setAttribute("data-name",o),a.setAttribute("type","button"),a.setAttribute("title",this.get("deleteTitle")||"Suppr."),a.addEventListener("click",function(e){s.removeBookmark(this.getAttribute("data-name")),s.dispatchEvent({type:"remove",name:this.getAttribute("data-name")}),e.stopPropagation()}),r.appendChild(a)}}try{localStorage[this.get("namespace")+"@bookmark"]=JSON.stringify(e)}catch(e){console.warn("Failed to access localStorage...")}}getBookmarks(){var e={};try{e=JSON.parse(localStorage[this.get("namespace")+"@bookmark"]||"{}")}catch(e){console.warn("Failed to access localStorage...")}return e}removeBookmark(e){if(e){var t=this.getBookmarks();delete t[e],this.setBookmarks(t)}}addBookmark(e,t,i,s){if(e){var o,r=t;r&&r.position?(i=r.zoom,s=r.permanent,o=r.rotation,t=r.position):o=this.getMap().getView().getRotation();var a=this.getBookmarks();a[e]&&a[e].permanent||(a[e]={pos:t||this.getMap().getView().getCenter(),zoom:i||this.getMap().getView().getZoom(),permanent:!!s},o&&(a[e].rot=o),this.setBookmarks(a))}}},ol.control.GeolocationBar=class extends ol.control.Bar{constructor(e){(e=e||{}).className=e.className||"ol-geobar",super(e),this.setPosition(e.position||"bottom-right");var t=this.element,i=new ol.interaction.GeolocationDraw({source:e.source,zoom:e.zoom,minZoom:e.minZoom,tolerance:e.tolerance,followTrack:e.followTrack,minAccuracy:e.minAccuracy||1e4});this._geolocBt=new ol.control.Toggle({className:"geolocBt",interaction:i,onToggle:function(){i.pause(!0),i.setFollowTrack(e.followTrack),t.classList.remove("pauseTrack")}}),this.addControl(this._geolocBt),this._geolocBt.setActive(!1);var s=new ol.control.Bar;this.addControl(s);var o=new ol.control.TextButton({className:"centerBt",html:e.centerLabel||"center",handleClick:function(){i.setFollowTrack("auto")}});s.addControl(o);var r=new ol.control.Button({className:"startBt",handleClick:function(){i.pause(!1),i.setFollowTrack("auto"),t.classList.add("pauseTrack")}});s.addControl(r);var a=new ol.control.Button({className:"pauseBt",handleClick:function(){i.pause(!0),i.setFollowTrack("auto"),t.classList.remove("pauseTrack")}});s.addControl(a),i.on("follow",function(e){e.following?t.classList.remove("centerTrack"):t.classList.add("centerTrack")}),this._geolocBt.on("change:active",function(e){e.active?t.classList.add("ol-active"):t.classList.remove("ol-active")})}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),e&&(this._listener=e.on("moveend",function(){var t=this.getInteraction();t.getActive()&&"auto"===t.get("followTrack")&&t.path_.length&&t.path_[t.path_.length-1][0]!==e.getView().getCenter()[0]&&this.element.classList.add("centerTrack")}.bind(this)))}getInteraction(){return this._geolocBt.getInteraction()}},ol.control.GeolocationButton=class extends ol.control.Toggle{constructor(e){(e=e||{}).followTrack=e.followTrack||"auto",e.zoom=e.zoom||16;var t,i=new ol.interaction.GeolocationDraw(e);super({className:e.className=((e.className||"")+" ol-geobt").trim(),interaction:i,title:e.title||"Geolocation",onToggle:function(){i.pause(!0),i.setFollowTrack(e.followTrack||"auto")}}),this.setActive(!1),i.on("tracking",function(e){this.dispatchEvent({type:"position",coordinate:e.geolocation.getPosition()})}.bind(this)),i.on("change:active",function(){this.dispatchEvent({type:"position"}),t&&(clearTimeout(t),t=null),i.getActive()&&(t=setTimeout(function(){i.setActive(!1),t=null}.bind(this),e.delay||3e3))}.bind(this))}},ol.control.Globe=class extends ol.control.Control{constructor(e){var t=e||{},i=document.createElement("div");super({element:i,target:t.target});var s=this;t.target?this.panel_=t.target:(i.classList.add("ol-globe","ol-unselectable","ol-control"),/top/.test(t.align)&&i.classList.add("ol-control-top"),/right/.test(t.align)&&i.classList.add("ol-control-right"),this.panel_=document.createElement("div"),this.panel_.classList.add("panel"),i.appendChild(this.panel_),this.pointer_=document.createElement("div"),this.pointer_.classList.add("ol-pointer"),i.appendChild(this.pointer_)),this.ovmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:this.panel_,view:new ol.View({zoom:0,center:[0,0]}),layers:t.layers}),setTimeout(function(){s.ovmap_.updateSize()},0),this.set("follow",t.follow||!1),this.extentLayer=new ol.layer.Vector({name:"Cache extent",source:new ol.source.Vector,style:t.style||[new ol.style.Style({image:new ol.style.Circle({fill:new ol.style.Fill({color:"rgba(255,0,0, 1)"}),stroke:new ol.style.Stroke({width:7,color:"rgba(255,0,0, 0.8)"}),radius:5})})]}),this.ovmap_.addLayer(this.extentLayer)}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,ol.control.Control.prototype.setMap.call(this,e),e&&(this._listener=e.getView().on("propertychange",this.setView.bind(this)),this.setView())}setView(){this.getMap()&&this.get("follow")&&this.setCenter(this.getMap().getView().getCenter())}getGlobe(){return this.ovmap_}show(e){!1!==e?this.element.classList.remove("ol-collapsed"):this.element.classList.add("ol-collapsed"),this.ovmap_.updateSize()}setPosition(e){/top/.test(e)?this.element.classList.add("ol-control-top"):this.element.classList.remove("ol-control-top"),/right/.test(e)?this.element.classList.add("ol-control-right"):this.element.classList.remove("ol-control-right")}setCenter(e,t){var i=this;if(this.pointer_.classList.add("hidden"),e){var s=this.ovmap_,o=s.getPixelFromCoordinate(e);if(o){if(!1!==t){var r=this.element.clientHeight;setTimeout(function(){i.pointer_.style.top=String(Math.min(Math.max(o[1],0),r))+"px",i.pointer_.style.left="50%",i.pointer_.classList.remove("hidden")},800)}s.getView().animate({center:[e[0],0]})}}}},ol.control.Graticule=class extends ol.control.CanvasBase{constructor(e){e=e||{};var t=document.createElement("div");t.className="ol-graticule ol-unselectable ol-hidden",super({element:t}),this.set("projection",e.projection||"EPSG:4326");var i=new ol.proj.Projection({code:this.get("projection")}).getMetersPerUnit();for(this.fac=1;i/this.fac>10;)this.fac*=10;this.fac=1e4/this.fac,this.set("maxResolution",e.maxResolution||1/0),this.set("step",e.step||.1),this.set("stepCoord",e.stepCoord||1),this.set("spacing",e.spacing||40),this.set("intervals",e.intervals),this.set("precision",e.precision),this.set("margin",e.margin||0),this.set("borderWidth",e.borderWidth||5),this.set("stroke",!1!==e.stroke),this.formatCoord=e.formatCoord||function(e){return e},e.style instanceof ol.style.Style?this.setStyle(e.style):this.setStyle(new ol.style.Style({stroke:new ol.style.Stroke({color:"#000",width:1}),fill:new ol.style.Fill({color:"#fff"}),text:new ol.style.Text({stroke:new ol.style.Stroke({color:"#fff",width:2}),fill:new ol.style.Fill({color:"#000"})})}))}setStyle(e){this._style=e}_draw(e){if(!(this.get("maxResolution")<e.frameState.viewState.resolution)){for(var t,i=this.getContext(e),s=i.canvas,o=e.frameState.pixelRatio,r=s.width/o,a=s.height/o,n=this.get("projection"),l=this.getMap(),h=[l.getCoordinateFromPixel([0,0]),l.getCoordinateFromPixel([r,0]),l.getCoordinateFromPixel([r,a]),l.getCoordinateFromPixel([0,a])],c=-1/0,u=1/0,d=-1/0,p=1/0,g=0;t=h[g];g++)h[g]=ol.proj.transform(t,l.getView().getProjection(),n),c=Math.max(c,h[g][0]),u=Math.min(u,h[g][0]),d=Math.max(d,h[g][1]),p=Math.min(p,h[g][1]);var m=this.get("spacing"),f=this.get("step"),v=this.get("stepCoord"),y=this.get("borderWidth"),_=this.get("margin");if((c-u)/f*m>r)(f*=Math.round((c-u)/r*m/f))>this.fac&&(f=Math.round(f/this.fac)*this.fac);var x=this.get("intervals");if(Array.isArray(x)){for(var b=x[0],w=(g=0,x.length);g<w&&!(f>=x[g]);++g)b=x[g];f=b}var S=this.get("precision"),M=f;S>0&&f>S&&(M=f/Math.ceil(f/S)),u=Math.floor(u/f)*f-f,p=Math.floor(p/f)*f-f,c=Math.floor(c/f)*f+2*f,d=Math.floor(d/f)*f+2*f;var C=ol.proj.get(n).getExtent();C&&(u<C[0]&&(u=C[0]),p<C[1]&&(p=C[1]),c>C[2]&&(c=C[2]+f),d>C[3]&&(d=C[3]+f));var E=this.getStyle().getStroke()&&this.get("stroke"),L=this.getStyle().getText(),T=this.getStyle().getFill();i.save(),i.scale(o,o),i.beginPath(),i.rect(_,_,r-2*_,a-2*_),i.clip(),i.beginPath();var P,k,A,F,I,N={top:[],left:[],bottom:[],right:[]};for(P=u;P<c;P+=f)for(F=ol.proj.transform([P,p],n,l.getView().getProjection()),F=l.getPixelFromCoordinate(F),E&&i.moveTo(F[0],F[1]),A=F,k=p+M;k<=d;k+=M)I=ol.proj.transform([P,k],n,l.getView().getProjection()),I=l.getPixelFromCoordinate(I),E&&i.lineTo(I[0],I[1]),A[1]>0&&I[1]<0&&N.top.push([P,A]),A[1]>a&&I[1]<a&&N.bottom.push([P,A]),A=I;for(k=p;k<d;k+=f)for(F=ol.proj.transform([u,k],n,l.getView().getProjection()),F=l.getPixelFromCoordinate(F),E&&i.moveTo(F[0],F[1]),A=F,P=u+M;P<=c;P+=M)I=ol.proj.transform([P,k],n,l.getView().getProjection()),I=l.getPixelFromCoordinate(I),E&&i.lineTo(I[0],I[1]),A[0]<0&&I[0]>0&&N.left.push([k,A]),A[0]<r&&I[0]>r&&N.right.push([k,A]),A=I;if(E&&(i.strokeStyle=this.getStyle().getStroke().getColor(),i.lineWidth=this.getStyle().getStroke().getWidth(),i.stroke()),L){var D,O;i.fillStyle=this.getStyle().getText().getFill().getColor(),i.strokeStyle=this.getStyle().getText().getStroke().getColor(),i.lineWidth=this.getStyle().getText().getStroke().getWidth(),i.font=this.getStyle().getText().getFont(),i.textAlign="center",i.textBaseline="hanging";var R=(T?y:0)+_+2;for(g=0;D=N.top[g];g++)Math.round(D[0]/this.get("step"))%v||(O=this.formatCoord(D[0],"top"),i.strokeText(O,D[1][0],R),i.fillText(O,D[1][0],R));for(i.textBaseline="alphabetic",g=0;D=N.bottom[g];g++)Math.round(D[0]/this.get("step"))%v||(O=this.formatCoord(D[0],"bottom"),i.strokeText(O,D[1][0],a-R),i.fillText(O,D[1][0],a-R));for(i.textBaseline="middle",i.textAlign="left",g=0;D=N.left[g];g++)Math.round(D[0]/this.get("step"))%v||(O=this.formatCoord(D[0],"left"),i.strokeText(O,R,D[1][1]),i.fillText(O,R,D[1][1]));for(i.textAlign="right",g=0;D=N.right[g];g++)Math.round(D[0]/this.get("step"))%v||(O=this.formatCoord(D[0],"right"),i.strokeText(O,r-R,D[1][1]),i.fillText(O,r-R,D[1][1]))}if(T){var G,V,B=this.getStyle().getFill().getColor();for((V=this.getStyle().getStroke())?G=this.getStyle().getStroke().getColor():(G=B,B="#fff"),i.strokeStyle=G,i.lineWidth=V?V.getWidth():1,g=1;g<N.top.length;g++)i.beginPath(),i.rect(N.top[g-1][1][0],_,N.top[g][1][0]-N.top[g-1][1][0],y),i.fillStyle=Math.round(N.top[g][0]/f)%2?G:B,i.fill(),i.stroke();for(g=1;g<N.bottom.length;g++)i.beginPath(),i.rect(N.bottom[g-1][1][0],a-y-_,N.bottom[g][1][0]-N.bottom[g-1][1][0],y),i.fillStyle=Math.round(N.bottom[g][0]/f)%2?G:B,i.fill(),i.stroke();for(g=1;g<N.left.length;g++)i.beginPath(),i.rect(_,N.left[g-1][1][1],y,N.left[g][1][1]-N.left[g-1][1][1]),i.fillStyle=Math.round(N.left[g][0]/f)%2?G:B,i.fill(),i.stroke();for(g=1;g<N.right.length;g++)i.beginPath(),i.rect(r-y-_,N.right[g-1][1][1],y,N.right[g][1][1]-N.right[g-1][1][1]),i.fillStyle=Math.round(N.right[g][0]/f)%2?G:B,i.fill(),i.stroke();i.beginPath(),i.fillStyle=G,i.rect(_,_,y,y),i.rect(_,a-y-_,y,y),i.rect(r-y-_,_,y,y),i.rect(r-y-_,a-y-_,y,y),i.fill()}i.restore()}}},ol.control.GridReference=class extends ol.control.CanvasBase{constructor(e){e=e||{};var t=document.createElement("div");t.className=(e.target?"":"ol-control ")+"ol-gridreference ol-unselectable "+(e.className||""),e.style=e.style||new ol.style.Style({stroke:new ol.style.Stroke({color:"#000",width:1}),text:new ol.style.Text({font:"bold 14px Arial",stroke:new ol.style.Stroke({color:"#fff",width:2}),fill:new ol.style.Fill({color:"#000"})})}),super({element:t,target:e.target,style:e.style}),"function"==typeof e.property&&(this.getFeatureName=e.property),"function"==typeof e.sortFeatures&&(this.sortFeatures=e.sortFeatures),"function"==typeof e.indexTitle&&(this.indexTitle=e.indexTitle),this.source_=e.source,e.source&&(this.setIndex(e.source.getFeatures(),e),e.source.once("change",function(){"ready"===e.source.getState()&&this.setIndex(e.source.getFeatures(),e)}.bind(this))),this.set("maxResolution",e.maxResolution||1/0),this.set("extent",e.extent),this.set("size",e.size),this.set("margin",e.margin||0),this.set("property",e.property||"name"),this.set("filterLabel",e.filterLabel||"filter")}setMap(e){super.setMap(e),this.setIndex(this.source_.getFeatures())}getFeatureName(e){return e.get(this.get("property")||"name")}sortFeatures(e,t){return this.getFeatureName(e)==this.getFeatureName(t)?0:this.getFeatureName(e)<this.getFeatureName(t)?-1:1}indexTitle(e){return this.getFeatureName(e).charAt(0)}setIndex(e){if(this.getMap()){var t=this;e.getArray&&(e=e.getArray()),e.sort(function(e,i){return t.sortFeatures(e,i)}),this.element.innerHTML="";var i=this.element,s=document.createElement("input");s.setAttribute("type","search"),s.setAttribute("placeholder",this.get("filterLabel")||"filter");var o=function(){var e=this.value.replace(/^\*/,""),t=new RegExp(e,"i"),i=n.querySelectorAll("li");Array.prototype.forEach.call(i,function(e){e.classList.contains("ol-title")?e.style.display="":t.test(e.querySelector(".ol-name").textContent)?e.style.display="":e.style.display="none"}),Array.prototype.forEach.call(n.querySelectorAll("li.ol-title"),function(e){for(var t,s=!1,o=0;o<i.length;o++){if(s){if(i[o].classList.contains("ol-title"))break;if(!i[o].style.display){t=i[o];break}}i[o]===e&&(s=!0)}e.style.display=t?"":"none"})};s.addEventListener("search",o),s.addEventListener("keyup",o),i.appendChild(s);var r,a,n=document.createElement("ul");i.appendChild(n),e.forEach(function(e){if(r=this.getReference(e.getGeometry().getFirstCoordinate())){var t=this.getFeatureName(e),i=this.indexTitle(e);if(i!=a){var s=document.createElement("li");s.classList.add("ol-title"),s.textContent=i,n.appendChild(s)}a=i;var o=document.createElement("li"),l=document.createElement("span");l.classList.add("ol-name"),l.textContent=t,o.appendChild(l);var h=document.createElement("span");h.classList.add("ol-ref"),h.textContent=r,o.appendChild(h);var c=e;o.addEventListener("click",function(){this.dispatchEvent({type:"select",feature:c})}.bind(this)),n.appendChild(o)}}.bind(this))}}getReference(e){if(this.getMap()){var t=this.get("extent"),i=this.get("size"),s=Math.floor((e[0]-t[0])/(t[2]-t[0])*i[0]);if(s<0||s>=i[0])return"";var o=Math.floor((t[3]-e[1])/(t[3]-t[1])*i[1]);return o<0||o>=i[1]?"":this.getHIndex(s)+this.getVIndex(o)}}getVIndex(e){return e}getHIndex(e){return String.fromCharCode(65+e)}_draw(e){if(!(this.get("maxResolution")<e.frameState.viewState.resolution)){var t=this.getContext(e),i=t.canvas,s=e.frameState.pixelRatio,o=i.width/s,r=i.height/s,a=this.get("extent"),n=this.get("size"),l=this.getMap(),h=ol.extent.boundingExtent([l.getPixelFromCoordinate([a[0],a[1]]),l.getPixelFromCoordinate([a[2],a[3]])]),c=[h[0],h[1]],u=[h[2],h[3]],d=(u[0]-c[0])/n[0],p=(u[1]-c[1])/n[1];t.save();var g,m=this.get("margin");for(t.scale(s,s),t.strokeStyle=this.getStroke().getColor(),t.lineWidth=this.getStroke().getWidth(),t.beginPath(),g=0;g<=n[0];g++)t.moveTo(c[0]+g*d,c[1]),t.lineTo(c[0]+g*d,u[1]);for(g=0;g<=n[1];g++)t.moveTo(c[0],c[1]+g*p),t.lineTo(u[0],c[1]+g*p);t.stroke(),t.font=this.getTextFont(),t.fillStyle=this.getTextFill().getColor(),t.strokeStyle=this.getTextStroke().getColor();var f,v,y,_=m+(t.lineWidth=this.getTextStroke().getWidth());for(t.textAlign="center",g=0;g<n[0];g++)f=this.getHIndex(g),v=c[0]+g*d+d/2,(y=c[1]-_)<0?(y=_,t.textBaseline="hanging"):t.textBaseline="alphabetic",t.strokeText(f,v,y),t.fillText(f,v,y),(y=u[1]+_)>r?(y=r-_,t.textBaseline="alphabetic"):t.textBaseline="hanging",t.strokeText(f,v,y),t.fillText(f,v,y);for(t.textBaseline="middle",g=0;g<n[1];g++)f=this.getVIndex(g),y=c[1]+g*p+p/2,t.textAlign="right",(v=c[0]-_)<0?(v=_,t.textAlign="left"):t.textAlign="right",t.strokeText(f,v,y),t.fillText(f,v,y),(v=u[0]+_)>o?(v=o-_,t.textAlign="right"):t.textAlign="left",t.strokeText(f,v,y),t.fillText(f,v,y);t.restore()}}},ol.control.Imageline=class extends ol.control.Control{constructor(e){var t=ol.ext.element.create("DIV",{className:(e.className||"")+" ol-imageline"+(e.target?"":" ol-unselectable ol-control")+(e.collapsed&&e.collapsible?"ol-collapsed":"")});super({element:t,target:e.target}),!e.target&&e.collapsible&&ol.ext.element.create("BUTTON",{type:"button",click:function(){this.toggle()}.bind(this),parent:t}),e.source&&(this._sources=e.source.forEach?e.source:[e.source]),e.layers&&this.setLayers(e.layers),this._setScrolling(),this._scrolldiv.addEventListener("scroll",function(){this.getMap()&&this.getMap().render()}.bind(this)),"function"==typeof e.getImage&&(this._getImage=e.getImage),"function"==typeof e.getTitle&&(this._getTitle=e.getTitle),this.set("maxFeatures",e.maxFeatures||100),this.set("linkColor",e.linkColor||!1),this.set("hover",e.hover||!1),this.set("useExtent",e.useExtent||!1),this.refresh()}setMap(e){this._listener&&this._listener.forEach(function(e){ol.Observable.unByKey(e)}.bind(this)),this._listener=null,super.setMap(e),e&&(this._listener=[e.on("postcompose",this._drawLink.bind(this)),e.on("moveend",function(){this.get("useExtent")&&this.refresh()}.bind(this))],this.refresh())}setLayers(e){this._sources=this._getSources(e)}_getSources(e){var t=[];return e.forEach(function(e){e.getVisible()&&(e.getSource()&&e.getSource().getFeatures?t.push(e.getSource()):e.getLayers&&this._getSources(e.getLayers()))}.bind(this)),t}useExtent(e){this.set("useExtent",e),this.refresh()}isCollapsed(){return this.element.classList.contains("ol-collapsed")}collapse(e){e?this.element.classList.add("ol-collapsed"):this.element.classList.remove("ol-collapsed"),this.getMap()&&setTimeout(function(){this.getMap().render()}.bind(this),this.isCollapsed()?0:250),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})}toggle(){this.element.classList.toggle("ol-collapsed"),this.getMap()&&setTimeout(function(){this.getMap().render()}.bind(this),this.isCollapsed()?0:250),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})}_getImage(e){return e.get("img")}_getTitle(){return""}getFeatures(){var e=this.getMap();if(!e)return[];var t=[];return(this._sources||this._getSources(e.getLayers())).forEach(function(i){if(t.length<this.get("maxFeatures"))if(this.get("useExtent")&&e){var s=e.getView().calculateExtent(e.getSize());t.push(i.getFeaturesInExtent(s))}else t.push(i.getFeatures())}.bind(this)),t}_setScrolling(){var e=this._scrolldiv=ol.ext.element.create("DIV",{parent:this.element});ol.ext.element.scrollDiv(e,{onmove:function(e){this._moving=e}.bind(this)}),e.addEventListener("scroll",this._updateScrollBounds.bind(this)),this._updateScrollBounds()}_updateScrollBounds(){var e=this._scrolldiv;e.scrollLeft<5?this.element.classList.add("ol-scroll0"):this.element.classList.remove("ol-scroll0"),e.scrollWidth-e.scrollLeft-e.offsetWidth<5?this.element.classList.add("ol-scroll1"):this.element.classList.remove("ol-scroll1")}refresh(){this._scrolldiv.innerHTML="";var e=this.getFeatures(),t=this._select?this._select.feature:null;this._select&&(this._select.elt=null),this._iline=[],this.getMap()&&this.getMap().render();var i=function(e){if(this._getImage(e)){var i=ol.ext.element.create("DIV",{className:"ol-image",parent:this._scrolldiv});ol.ext.element.create("IMG",{src:this._getImage(e),parent:i}).addEventListener("load",function(){this.classList.add("ol-loaded")}),ol.ext.element.create("SPAN",{html:this._getTitle(e),parent:i});var s={elt:i,feature:e};i.addEventListener("click",function(){this._moving||(this._scrolldiv.scrollLeft=i.offsetLeft+ol.ext.element.getStyle(i,"width")/2-ol.ext.element.getStyle(this.element,"width")/2,this._select&&this._select.elt.classList.remove("select"),this._select=s,this._select&&this._select.elt.classList.add("select"),this.dispatchEvent({type:"select",feature:e}))}.bind(this)),i.addEventListener("mouseover",function(e){this.get("hover")&&(this._select&&this._select.elt.classList.remove("select"),this._select=s,this._select.elt.classList.add("select"),this.getMap().render(),e.stopPropagation())}.bind(this)),i.addEventListener("mouseout",function(e){this.get("hover")&&(this._select&&this._select.elt.classList.remove("select"),this._select=!1,this.getMap().render(),e.stopPropagation())}.bind(this)),i.ondragstart=function(){return!1},this._iline.push(s),t===e&&(this._select=s,s.elt.classList.add("select"))}}.bind(this),s=this.get("maxFeatures");e.forEach(function(e){for(var t,o=0;(t=e[o])&&!(s--<0);o++)i(t)}.bind(this)),this._select&&this._select.feature&&!this._select.elt&&i(this._select.feature),this._updateScrollBounds()}select(e,t){this._select=!1,this._iline.forEach(function(i){i.feature===e?(i.elt.classList.add("select"),this._select=i,!1!==t&&(this._scrolldiv.scrollLeft=i.elt.offsetLeft+ol.ext.element.getStyle(i.elt,"width")/2-ol.ext.element.getStyle(this.element,"width")/2)):i.elt.classList.remove("select")}.bind(this))}_drawLink(e){if(!(!this.get("linkColor")|this.isCollapsed())&&(this.getMap()&&this._select&&this._select.elt)){var t=e.context||ol.ext.getMapCanvas(this.getMap()).getContext("2d"),i=e.frameState.pixelRatio,s=[this._select.elt.offsetLeft-this._scrolldiv.scrollLeft+ol.ext.element.getStyle(this._select.elt,"width")/2,parseFloat(ol.ext.element.getStyle(this.element,"top"))||this.getMap().getSize()[1]],o=this._select.feature.getGeometry().getFirstCoordinate();o=this.getMap().getPixelFromCoordinate(o),t.save(),t.fillStyle=this.get("linkColor"),t.beginPath(),o[0]>s[0]?(t.moveTo((s[0]-5)*i,s[1]*i),t.lineTo((s[0]+5)*i,(s[1]+5)*i)):(t.moveTo((s[0]-5)*i,(s[1]+5)*i),t.lineTo((s[0]+5)*i,s[1]*i)),t.lineTo(o[0]*i,o[1]*i),t.fill(),t.restore()}}},ol.control.IsochroneGeoportail=class extends ol.control.Control{constructor(e){e||(e={}),null==e.typing&&(e.typing=300);var t=(e.className?e.className:"")+" ol-isochrone ol-routing";e.target||(t+=" ol-unselectable ol-control");var i=ol.ext.element.create("DIV",{className:t});e.target||ol.ext.element.create("BUTTON",{parent:i}).addEventListener("click",function(){i.classList.toggle("ol-collapsed")});super({element:i,target:e.target});var s=this;this.set("iter",1);var o=ol.ext.element.create("DIV",{className:"content",parent:i});this._addSearchCtrl(o,e),ol.ext.element.create("BUTTON",{className:"ol-button ol-method-time selected",title:"isochrone",parent:o}).addEventListener("click",function(){this.setMethod("time")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-method-distance",title:"isodistance",parent:o}).addEventListener("click",function(){this.setMethod("distance")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-car selected",title:"by car",parent:o}).addEventListener("click",function(){this.setMode("car")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-pedestrian",title:"by foot",parent:o}).addEventListener("click",function(){this.setMode("pedestrian")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-direction-direct selected",title:"direct",parent:o}).addEventListener("click",function(){this.setDirection("direct")}.bind(this)),ol.ext.element.create("I",{className:"ol-button ol-direction-reverse",title:"reverse",parent:o}).addEventListener("click",function(){this.setDirection("reverse")}.bind(this));var r=ol.ext.element.create("DIV",{className:"ol-time",parent:o});ol.ext.element.create("DIV",{html:"isochrone:",parent:r}),ol.ext.element.create("INPUT",{type:"number",parent:r,min:0}).addEventListener("change",function(){s.set("hour",Number(this.value))}),ol.ext.element.create("TEXT",{parent:r,html:"h"}),ol.ext.element.create("INPUT",{type:"number",parent:r,min:0}).addEventListener("change",function(){s.set("minute",Number(this.value))}),ol.ext.element.create("TEXT",{parent:r,html:"mn"}),r=ol.ext.element.create("DIV",{className:"ol-distance",parent:o}),ol.ext.element.create("DIV",{html:"isodistance:",parent:r}),ol.ext.element.create("INPUT",{type:"number",step:"any",parent:r,min:0}).addEventListener("change",function(){s.set("distance",Number(this.value))}),ol.ext.element.create("TEXT",{parent:r,html:"km"}),r=ol.ext.element.create("DIV",{className:"ol-iter",parent:o}),ol.ext.element.create("DIV",{html:"Iteration:",parent:r}),ol.ext.element.create("INPUT",{type:"number",parent:r,value:1,min:1}).addEventListener("change",function(){s.set("iter",Number(this.value))}),ol.ext.element.create("I",{className:"ol-ok",html:"ok",parent:o}).addEventListener("click",function(){var e=0;switch(this.get("method")){case"distance":e=1e3*this.get("distance");break;default:e=3600*(this.get("hour")||0)+60*(this.get("minute")||0)}e&&this.get("coordinate")&&this.search(this.get("coordinate"),e)}.bind(this)),this.set("url","https://data.geopf.fr/navigation/isochrone"),this._ajax=new ol.ext.Ajax({dataType:"JSON",auth:e.auth}),this._ajax.on("success",this._success.bind(this)),this._ajax.on("error",this._error.bind(this)),this._ajax.on("loadstart",function(){this.element.classList.add("ol-searching")}.bind(this)),this._ajax.on("loadend",function(){this.element.classList.remove("ol-searching")}.bind(this)),this.setMethod(e.method)}setMap(e){super.setMap(e),this._search.setMap(e)}_addSearchCtrl(e,t){var i=ol.ext.element.create("DIV",{parent:e}),s=this._search=new ol.control.SearchGeoportail({className:"IGNF ol-collapsed",apiKey:t.apiKey,target:i});s.on("select",function(e){s.setInput(e.search.fulltext),this.set("coordinate",e.coordinate)}.bind(this)),s.on("change:input",function(){this.set("coordinate",!1)}.bind(this))}setMethod(e){e=/distance/.test(e)?"distance":"time",this.element.querySelector(".ol-method-time").classList.remove("selected"),this.element.querySelector(".ol-method-distance").classList.remove("selected"),this.element.querySelector(".ol-method-"+e).classList.add("selected"),this.element.querySelector("div.ol-time").classList.remove("selected"),this.element.querySelector("div.ol-distance").classList.remove("selected"),this.element.querySelector("div.ol-"+e).classList.add("selected"),this.set("method",e)}setMode(e){this.set("mode",e),this.element.querySelector(".ol-car").classList.remove("selected"),this.element.querySelector(".ol-pedestrian").classList.remove("selected"),this.element.querySelector(".ol-"+e).classList.add("selected")}setDirection(e){this.set("direction",e),this.element.querySelector(".ol-direction-direct").classList.remove("selected"),this.element.querySelector(".ol-direction-reverse").classList.remove("selected"),this.element.querySelector(".ol-direction-"+e).classList.add("selected")}search(e,t,i,s){var o=this.getMap()?this.getMap().getView().getProjection():"EPSG:3857",r=/distance/.test(this.get("method"))?"distance":"time";if("string"==typeof t){var a=t.replace(/([0-9|.]*)([a-z]*)$/,"$2");switch(r="time",t=parseFloat(t),a){case"mn":t*=60;break;case"h":t*=3600;break;case"m":r="distance";break;case"km":r="distance",t*=1e3}}var n=Math.round(t*(this.get("iter")-(i||0))/this.get("iter"));if("number"==typeof t){var l={resource:"bdtopo-valhalla",point:ol.proj.toLonLat(e,o),profile:"pedestrian"===this.get("mode")?"pedestrian":"car",costType:r,costValue:n,geometryFormat:"geojson",direction:"reverse"===this.get("direction")?"arrival":"departure"};this._ajax.send(this.get("url"),l,{coord:e,option:t,data:l,iteration:(i||0)+1,once:s})}}_success(e){var t,i=this.getMap()?this.getMap().getView().getProjection():"EPSG:3857",s=e.response;s.wktGeometry?(t=new ol.format.WKT,s.feature=t.readFeature(s.wktGeometry,{dataProjection:"EPSG:4326",featureProjection:i}),delete s.wktGeometry):(t=new ol.format.GeoJSON,s.feature=t.readFeature(s.geometry,{dataProjection:"EPSG:4326",featureProjection:i}),delete s.geometry),s.feature.set("iteration",e.options.iteration),s.feature.set("method",e.options.data.method),s.feature.set(e.options.data.method,e.options.data[e.options.data.method]),s.type="isochrone",s.iteration=e.options.iteration-1,this.dispatchEvent(s),!e.options.once&&e.options.iteration<this.get("iter")&&this.search(e.options.coord,e.options.option,e.options.iteration)}_error(){this.dispatchEvent({type:"error"})}},ol.control.LayerPopup=class extends ol.control.LayerSwitcher{constructor(e){(e=e||{}).switcherClass="ol-layerswitcher-popup"+(e.switcherClass?" "+e.switcherClass:""),!1!==e.mouseover&&(e.mouseover=!0),super(e)}overflow(){}drawList(e,t){var i=this,s=function(e){e.preventDefault();var s=i._getLayerForLI(this);i.switchLayerVisibility(s,t),"touchstart"===e.type&&i.element.classList.add("ol-collapsed")};t.forEach(function(t){if(i.displayInLayerSwitcher(t)){var o=ol.ext.element.create("LI",{html:t.get("title")||t.get("name"),on:{"click touchstart":s},parent:e});i._setLayerForLI(o,t),i.testLayerVisibility(t)&&o.classList.add("ol-layer-hidden"),t.getVisible()&&o.classList.add("ol-visible")}})}},ol.control.LayerShop=class extends ol.control.LayerSwitcher{constructor(e){(e=e||{}).selection=!0,e.noScroll=!0,super(e),this.element.classList.add("ol-layer-shop");var t=this.element.insertBefore(ol.ext.element.create("DIV",{className:"ol-title-bar"}),this.getPanel());this.on("select",function(e){t.innerText=e.layer?e.layer.get("title"):"",this.element.setAttribute("data-layerClass",this.getLayerClass(e.layer))}.bind(this)),this._topbar=this.element.insertBefore(ol.ext.element.create("DIV",{className:"ol-bar ol-top-bar"}),this.getPanel()),this._bottombar=ol.ext.element.create("DIV",{className:"ol-bar ol-bottom-bar",parent:this.element}),this._controls=[]}setMap(e){this.getMap()&&this._controls.forEach(function(e){this.getMap().removeControl(e)}.bind(this)),super.setMap(e),e&&(this.selectLayer(),this._listener.removeLayer=e.getLayers().on("remove",function(e){e.element===this.getSelection()&&this.selectLayer()}.bind(this)),this._controls.forEach(function(e){this.getMap().addControl(e)}.bind(this)))}getBarElement(e){return"bottom"===e?this._bottombar:this._topbar}addControl(e,t){this._controls.push(e),e.setTarget("bottom"===t?this._bottombar:this._topbar),this.getMap()&&this.getMap().addControl(e)}},ol.control.LayerSwitcherImage=class extends ol.control.LayerSwitcher{constructor(e){(e=e||{}).switcherClass=((e.switcherClass||"")+" ol-layerswitcher-image").trim(),e.mouseover=!1!==e.mouseover,super(e)}drawList(e,t){var i=this,s=function(e){e.preventDefault();var s=i._getLayerForLI(this);i.switchLayerVisibility(s,t),"touchstart"==e.type&&i.element.classList.add("ol-collapsed")};ol.ext.element.setStyle(e,{height:"auto"}),t.forEach(function(t){if(i.displayInLayerSwitcher(t)){var o=t.getPreview?t.getPreview():["none"],r=ol.ext.element.create("LI",{className:"ol-imgcontainer"+(t.getVisible()?" ol-visible":""),on:{"touchstart click":s},parent:e});i._setLayerForLI(r,t),o.forEach(function(e){ol.ext.element.create("IMG",{src:e,parent:r})}),ol.ext.element.create("p",{html:t.get("title")||t.get("name"),parent:r}),i.testLayerVisibility(t)&&r.classList.add("ol-layer-hidden")}})}overflow(){}},ol.control.Legend=class extends ol.control.CanvasBase{constructor(e){e=e||{};var t=document.createElement("div");if(super({element:t,target:e.target}),e.target)t.className=e.className||"ol-legend";else{t.className=(e.className||"ol-legend")+" ol-unselectable ol-control"+(!1===e.collapsible?" ol-uncollapsible":" ol-collapsed");var i=document.createElement("button");i.setAttribute("type","button"),i.addEventListener("click",function(){this.toggle()}.bind(this)),t.appendChild(i),(i=document.createElement("button")).setAttribute("type","button"),i.className="ol-closebox",i.addEventListener("click",function(){this.toggle()}.bind(this)),t.appendChild(i)}this._legend=e.legend,this._legend.getCanvas().className="ol-legendImg",t.appendChild(this._legend.getCanvas()),t.appendChild(this._legend.getListElement()),!1!==e.collapsible&&!1===e.collapsed&&this.show(),this._legend.on("select",function(e){this.dispatchEvent(e)}.bind(this)),this._legend.on("refresh",function(){if(this._onCanvas&&this.getMap())try{this.getMap().renderSync()}catch(e){}}.bind(this)),this._legend.on("items",function(t){t.nb?(this.element.classList.remove("ol-empty"),this.element.title=e.title||"legend"):(this.element.classList.add("ol-empty"),this.element.title=e.emptyTitle||"no legend"),this.dispatchEvent(t)}.bind(this))}getLegend(){return this._legend}setCanvas(e){if(this._onCanvas=e,this.element.style.visibility=e?"hidden":"visible",this.getMap())try{this.getMap().renderSync()}catch(e){}}onCanvas(){return!!this._onCanvas}_draw(e){if(this._onCanvas&&!this.element.classList.contains("ol-collapsed")){var t=this._legend.getCanvas(),i=this.getContext(e),s=i.canvas.height-t.height;i.save(),i.rect(0,s,t.width,t.height);var o="#fff";this._legend.getTextStyle().getBackgroundFill()&&(o=ol.color.asString(this._legend.getTextStyle().getBackgroundFill().getColor())),i.fillStyle=i.strokeStyle=o,i.lineWidth=10,i.lineJoin="round",i.stroke(),i.clearRect(0,s,t.width,t.height),i.fill(),i.drawImage(t,0,s),i.restore()}}show(){if(this.element.classList.contains("ol-collapsed")&&(this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"change:collapse",collapsed:!1}),this.getMap()))try{this.getMap().renderSync()}catch(e){}}hide(){if(!this.element.classList.contains("ol-collapsed")&&(this.element.classList.add("ol-collapsed"),this.dispatchEvent({type:"change:collapse",collapsed:!0}),this.getMap()))try{this.getMap().renderSync()}catch(e){}}collapse(e){!1===e?this.show():this.hide()}isCollapsed(){return this.element.classList.contains("ol-collapsed")}toggle(){if(this.element.classList.toggle("ol-collapsed"),this.dispatchEvent({type:"change:collapse",collapsed:this.element.classList.contains("ol-collapsed")}),this.getMap())try{this.getMap().renderSync()}catch(e){}}},ol.control.MapZone=class extends ol.control.Control{constructor(e){e=e||{};var t=t=ol.ext.element.create("DIV",{className:e.className||"ol-mapzone"});if(super({element:t,target:e.target}),!e.target){["ol-unselectable","ol-control","ol-collapsed"].forEach(function(e){t.classList.add(e)});var i=ol.ext.element.create("BUTTON",{type:"button",on:{click:function(){this.setVisible(this.getCollapsed())}.bind(this)},parent:t});ol.ext.element.create("I",{parent:i})}this.set("centerOnClick",e.centerOnClick);var s=this._maps=[];this._projection=e.projection,this._layer=e.layer,e.zones.forEach(this.addZone.bind(this)),setTimeout(function(){s.forEach(function(e){e.updateSize()})})}setCollapsed(e){e?this.element.classList.add("ol-collapsed"):(this.element.classList.remove("ol-collapsed"),this.getMaps().forEach(function(e){setTimeout(()=>e.getView().fit(e.get("extent")))}))}setVisible(e){this.setCollapsed(!e)}getCollapsed(){return this.element.classList.contains("ol-collapsed")}getMaps(){return this._maps}getLength(){return this._maps.length}addZone(e){var t,i=new ol.View({zoom:6,center:[0,0],projection:this._projection});t=e.map?ol.proj.transformExtent(e.map.getView().calculateExtent(),e.map.getView().getProjection(),i.getProjection()):ol.proj.transformExtent(e.extent,"EPSG:4326",i.getProjection());var s,o=ol.ext.element.create("DIV",{className:"ol-mapzonezone",tabindex:"0",parent:this.element,on:{keydown:function(e){" "===e.key&&e.target.click()}},click:function(){var i=-1;this._maps.forEach(function(t,s){t.get("zone")===e&&(i=s)}),this.dispatchEvent({type:"select",zone:e,index:i,coordinate:ol.extent.getCenter(t),extent:t}),!1!==this.get("centerOnClick")&&this.getMap().getView().fit(t)}.bind(this)});s=e.layer?e.layer:"function"==typeof this._layer?this._layer(e):new this._layer.constructor({source:this._layer.getSource()});var r=new ol.Map({target:o,view:i,controls:[],interactions:[],layers:[s]});r.set("zone",e),r.set("extent",t),this._maps.push(r),i.fit(t),ol.ext.element.create("P",{html:e.title,parent:o})}removeZone(e){var t=this.element.querySelectorAll(".ol-mapzonezone")[e];t&&(t.remove(),this._maps.splice(e,1))}},ol.control.MapZone.zones={},ol.control.MapZone.zones.DOM=[{title:"Guadeloupe",extent:[-61.898594315312444,15.75623038647845,-60.957887532935324,16.575317670979473]},{title:"Guyane",extent:[-54.72525931072715,2.1603763430019,-51.528236062921344,5.7984307809552575]},{title:"Martinique",extent:[-61.257556528564756,14.387506317407514,-60.76934912110432,14.895067461729951]},{title:"Mayotte",extent:[44.959844536967815,-13.01674138212816,45.35328866510648,-12.65521942207829]},{title:"La réunion",extent:[55.17059012967656,-21.407680069231688,55.88195702001797,-20.85560221637526]}],ol.control.MapZone.zones.TOM=[{title:"Polynésie Française",extent:[206.23664226630862,-22.189040615809787,221.85920743981987,-10.835039595040698]},{title:"Nouvelle Calédonie",extent:[163.76420580160925,-22.581641092751838,167.66984709498706,-19.816411635668445]},{title:"St-Pierre et Miquelon",extent:[-56.453698765748676,46.74449858188555,-56.0980198121544,47.14669874229787]},{title:"Wallis et Futuna",extent:[181.7588623143665,-14.7341169873267,183.95612353301715,-13.134720799175085]},{title:"St-Martin St-Barthélemy",extent:[-63.1726389501678,17.806097291313506,-62.7606535945649,18.13267688837938]}],ol.control.MapZone.zones.DOMTOM=[{title:"Métropole",extent:[-5.318421740712579,41.16082274292913,9.73284186155716,51.21957336557702]}].concat(ol.control.MapZone.zones.DOM,ol.control.MapZone.zones.TOM),ol.control.Notification=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("DIV");super({element:t,target:e.target}),this.contentElement=ol.ext.element.create("DIV",{click:function(){this.get("hideOnClick")&&this.hide()}.bind(this),parent:t});var i=(e.className||"")+" ol-notification";e.target||(i+=" ol-unselectable ol-control ol-collapsed"),t.setAttribute("class",i),this.set("closeBox",e.closeBox),this.set("hideOnClick",e.hideOnClick)}show(e,t){var i=this,s=this.element;e&&(e instanceof Node?(this.contentElement.innerHTML="",this.contentElement.appendChild(e)):this.contentElement.innerHTML=e,this.get("closeBox")?(this.contentElement.classList.add("ol-close"),ol.ext.element.create("SPAN",{className:"closeBox",click:function(){this.hide()}.bind(this),parent:this.contentElement})):this.contentElement.classList.remove("ol-close")),this._listener&&(clearTimeout(this._listener),this._listener=null),s.classList.add("ol-collapsed"),this._listener=setTimeout(function(){s.classList.remove("ol-collapsed"),i._listener=!t||t>=0?setTimeout(function(){s.classList.add("ol-collapsed"),i._listener=null},t||3e3):null},100)}hide(){this._listener&&(clearTimeout(this._listener),this._listener=null),this.element.classList.add("ol-collapsed")}toggle(e){this.element.classList.contains("ol-collapsed")?this.show(null,e):this.hide()}},ol.control.Overlay=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:"ol-unselectable ol-overlay "+(e.className||""),html:e.content});super({element:t,target:e.target});var i=this;e.hideOnClick&&t.addEventListener("click",function(){i.hide()}),this.set("closeBox",e.closeBox),this._timeout=!1,this.setContent(e.content)}setContent(e){var t=this;if(e){var i=this.element;if(e instanceof Element?(i.innerHTML="",i.appendChild(e)):void 0!==e&&(i.innerHTML=e),this.get("closeBox")){var s=document.createElement("div");s.classList.add("ol-closebox"),s.addEventListener("click",function(){t.hide()}),i.insertBefore(s,i.firstChild)}}}show(e,t){var i=this,s=this.element;s.style.display="block",t?(this.center_=this.getMap().getPixelFromCoordinate(t),s.style.top=this.center_[1]+"px",s.style.left=this.center_[0]+"px"):(this.center_=!1,s.style.top="",s.style.left=""),e&&this.setContent(e),this._timeout&&clearTimeout(this._timeout),this._timeout=setTimeout(function(){s.classList.add("ol-visible"),s.style.top="",s.style.left="",i.dispatchEvent({type:"change:visible",visible:!0,element:i.element})},10)}showImage(e,t){t=t||{};var i=ol.ext.element.create("DIV",{className:"ol-fullscreen-image"});ol.ext.element.create("IMG",{src:e,parent:i}),t.title&&(i.classList.add("ol-has-title"),ol.ext.element.create("P",{html:t.title,parent:i})),this.show(i,t.coordinate)}hide(){var e=this.element;this.element.classList.remove("ol-visible"),this.center_&&(e.style.top=this.center_[1]+"px",e.style.left=this.center_[0]+"px",this.center_=!1),this._timeout&&clearTimeout(this._timeout),this._timeout=setTimeout(function(){e.style.display="none"},500),this.dispatchEvent({type:"change:visible",visible:!1,element:this.element})}toggle(){this.getVisible()?this.hide():this.show()}getVisible(){return"none"!==ol.ext.element.getStyle(this.element,"display")}setClass(e){var t=this.element.classList.contains("ol-visible");this.element.className=("ol-unselectable ol-overlay "+(t?"ol-visible ":"")+e).trim()}},ol.control.Overview=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");super({element:t,target:e.target});var i=this;if(this.minZoom=e.minZoom||0,this.maxZoom=e.maxZoom||18,this.rotation=e.rotation,e.target)this.panel_=e.target;else{t.classList.add("ol-overview","ol-unselectable","ol-control","ol-collapsed"),/top/.test(e.align)&&t.classList.add("ol-control-top"),/right/.test(e.align)&&t.classList.add("ol-control-right");var s=document.createElement("button");s.setAttribute("type","button"),s.addEventListener("touchstart",function(e){i.toggleMap(),e.preventDefault()}),s.addEventListener("click",function(){i.toggleMap()}),t.appendChild(s),this.panel_=document.createElement("div"),this.panel_.classList.add("panel"),t.appendChild(this.panel_)}this.ovmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:this.panel_,view:new ol.View({zoom:2,center:[0,0],projection:e.projection}),layers:e.layers}),this.oview_=this.ovmap_.getView(),this.extentLayer=new ol.layer.Vector({name:"Cache extent",source:new ol.source.Vector,style:e.style||[new ol.style.Style({image:new ol.style.Circle({fill:new ol.style.Fill({color:"rgba(255,0,0, 1)"}),stroke:new ol.style.Stroke({width:7,color:"rgba(255,0,0, 0.8)"}),radius:5}),stroke:new ol.style.Stroke({width:5,color:"rgba(255,0,0,0.8)"})})]}),this.ovmap_.addLayer(this.extentLayer);this.ovmap_.addInteraction(new ol.interaction.Pointer({handleDownEvent:function(t){var s,o,r,a,n;return!1!==e.panAnimation?"elastic"==e.panAnimation||e.elasticPan?i.getMap().getView().animate({center:t.coordinate,easing:(s=2,o=.3,r=3*s*Math.PI/2,a=o>0?-1/o:-100,n=Math.cos(r)*Math.pow(2,a),function(e){return e=1-Math.cos(e*Math.PI/2),1-Math.cos(r*e)*Math.pow(2,a*e)+n*e}),duration:1e3}):i.getMap().getView().animate({center:t.coordinate,duration:300}):i.getMap().getView().setCenter(t.coordinate),!1}}))}getOverviewMap(){return this.ovmap_}toggleMap(){this.element.classList.toggle("ol-collapsed"),this.ovmap_.updateSize(),this.setView()}setPosition(e){/top/.test(e)?this.element.classList.add("ol-control-top"):this.element.classList.remove("ol-control-top"),/right/.test(e)?this.element.classList.add("ol-control-right"):this.element.classList.remove("ol-control-right")}setMap(e){if(this._listener)for(var t in this._listener)ol.Observable.unByKey(this._listener[t]);this._listener={},super.setMap(e),e&&(this._listener.map=e.on("change:view",function(){this._listener.view&&ol.Observable.unByKey(this._listener.view),e.getView()&&(this._listener.view=e.getView().on("propertychange",this.setView.bind(this)),this.setView())}.bind(this)),this._listener.view=e.getView().on("propertychange",this.setView.bind(this)),this.setView())}calcExtent_(e){var t=this.getMap();if(t){var i=this.extentLayer.getSource();i.clear();var s=new ol.Feature,o=t.getSize(),r=t.getView().getResolution(),a=t.getView().getRotation(),n=t.getView().getCenter();if(r){var l=r*o[0]/2,h=r*o[1]/2,c=this.oview_.getResolution();if(l/c>5||h/c>5){var u,d,p,g=Math.cos(a),m=Math.sin(a);for(e=[[-l,-h],[-l,h],[l,h],[l,-h]],u=0;u<4;++u)d=e[u][0],p=e[u][1],e[u][0]=n[0]+d*g-p*m,e[u][1]=n[1]+d*m+p*g;s.setGeometry(new ol.geom.Polygon([e]))}else s.setGeometry(new ol.geom.Point(n));i.addFeature(s)}}}setView(e){if(!e)return this.setView({key:"rotation"}),this.setView({key:"resolution"}),void this.setView({key:"center"});switch(e.key){case"rotation":this.rotation?this.oview_.setRotation(this.getMap().getView().getRotation()):this.oview_.getRotation()&&this.oview_.setRotation(0);break;case"center":var t=this.getMap().getView().calculateExtent(this.getMap().getSize()),i=this.oview_.calculateExtent(this.ovmap_.getSize());(t[0]<i[0]||t[1]<i[1]||t[2]>i[2]||t[3]>i[3])&&this.oview_.setCenter(this.getMap().getView().getCenter());break;case"resolution":var s=2*Math.round(this.oview_.getZoomForResolution(this.getMap().getView().getResolution())/2)-4;s=Math.min(this.maxZoom,Math.max(this.minZoom,s)),this.oview_.setZoom(s)}this.calcExtent_()}},ol.control.Permalink=class extends ol.control.Control{constructor(e){var t=e||{},i=document.createElement("div");super({element:i,target:t.target});var s=this,o=document.createElement("button");if(ol.ext.element.create("I",{parent:o}),this.replaceState_=!1!==t.urlReplace,this.fixed_=t.fixed||6,this.hash_=t.anchor?"#":"?",this._localStorage=t.localStorage,!this._localStorage)try{localStorage.removeItem("ol@permalink")}catch(e){console.warn("Failed to access localStorage...")}function r(){"function"==typeof t.onclick?t.onclick(s.getLink()):s.setUrlReplace(!s.replaceState_)}o.addEventListener("click",r,!1),o.addEventListener("touchstart",r,!1),i.className=(t.className||"ol-permalink")+" ol-unselectable ol-control",i.appendChild(o),(t.hidden||!1===t.visible)&&ol.ext.element.hide(i),this.set("geohash",t.geohash),this.set("initial",!1),this.on("change",this.viewChange_.bind(this)),this.search_={};var a={},n=document.location.hash||document.location.search||"";if(this.replaceState_&&!n&&this._localStorage)try{n=localStorage["ol@permalink"]}catch(e){console.warn("Failed to access localStorage...")}if(n){n=n.replace(/(^#|^\?)/,"").split("&");for(var l=0;l<n.length;l++){var h=n[l].split("=");switch(h[0]){case"lon":case"lat":case"z":case"r":a[h[0]]=h[1];break;case"gh":var c=h[1].split("-"),u=ol.geohash.toLonLat(c[0]);a.lon=u[0],a.lat=u[1],a.z=c[1];break;case"l":break;default:this.search_[h[0]]=h[1]}}}a.hasOwnProperty("lon")&&this.set("initial",a),this.set("refreshDelay",t.refreshDelay||500),this.replaceState_&&this.setPosition()}getInitialPosition(){return this.get("initial")}setMap(e){this._listener&&(ol.Observable.unByKey(this._listener.change),ol.Observable.unByKey(this._listener.moveend)),this._listener=null,super.setMap.call(this,e),e&&(this._listener={change:e.getLayerGroup().on("change",this.layerChange_.bind(this)),moveend:e.on("moveend",this.viewChange_.bind(this))},this.setPosition())}getLayerByLink(e,t){!t&&this.getMap()&&(t=this.getMap().getLayers().getArray());for(var i=0;i<t.length;i++){if(t[i].get("permalink")==e)return t[i];if(t[i].getLayers){var s=this.getLayerByLink(e,t[i].getLayers().getArray());if(s)return s}}return!1}setGeohash(e){this.set("geohash",e),this.setUrlParam()}setPosition(e){var t=this.getMap();if(t){var i=this.replaceState_||e?document.location.hash||document.location.search:"";if(!i&&this._localStorage)try{i=localStorage["ol@permalink"]}catch(e){console.warn("Failed to access localStorage...")}if(i){var s,o,r={};for(i=i.replace(/(^#|^\?)/,"").split("&"),s=0;s<i.length;s++)r[(o=i[s].split("="))[0]]=o[1];if(r.gh){var a=r.gh.split("-"),n=ol.geohash.toLonLat(a[0]);r.lon=n[0],r.lat=n[1],r.z=a[1]}var l=ol.proj.transform([Number(r.lon),Number(r.lat)],"EPSG:4326",t.getView().getProjection());if(l[0]&&l[1]&&t.getView().setCenter(l),r.z&&t.getView().setZoom(Number(r.z)),r.r&&t.getView().setRotation(Number(r.r)),r.l){!function e(i){i||(i=t.getLayers().getArray());for(var s=0;s<i.length;s++)i[s].get("permalink")&&i[s].setVisible(!1),i[s].getLayers&&e(i[s].getLayers().getArray())}();var h=r.l.split("|");for(s=0;s<h.length;s++){o=h[s].split(":");var c=this.getLayerByLink(o[0]),u=Number(o[1]);c&&(c.setOpacity(u),c.setVisible(!0))}}}}}getUrlParams(){return this.search_}setUrlParam(e,t){e&&(void 0===t||""===t?delete this.search_[encodeURIComponent(e)]:this.search_[encodeURIComponent(e)]=encodeURIComponent(t)),this.viewChange_()}getUrlParam(e){return decodeURIComponent(this.search_[encodeURIComponent(e)]||"")}hasUrlParam(e){return this.search_.hasOwnProperty(encodeURIComponent(e))}getLink(e){var t=this.getMap(),i=ol.proj.transform(t.getView().getCenter(),t.getView().getProjection(),"EPSG:4326"),s=Math.round(10*t.getView().getZoom())/10,o=t.getView().getRotation(),r=this.layerStr_,a=(o?"&r="+Math.round(1e4*o)/1e4:"")+(r?"&l="+r:"");this.get("geohash")?a="gh="+ol.geohash.fromLonLat(i,8)+"-"+s+a:a="lon="+i[0].toFixed(this.fixed_)+"&lat="+i[1].toFixed(this.fixed_)+"&z="+s+a;if("position"===e)return a;for(var n in this.search_)a+="&"+n+(void 0!==this.search_[n]?"="+this.search_[n]:"");return e?a:document.location.protocol+"//"+document.location.host+document.location.pathname+this.hash_+a}getUrlReplace(){return this.replaceState_}setUrlReplace(e){try{if(this.replaceState_=e,e)this.replaceUrl_(this.getLink(),!0);else{var t="";for(var i in this.search_)t+=(""==t?"?":"&")+i+(void 0!==this.search_[i]?"="+this.search_[i]:"");this.replaceUrl_(document.location.origin+document.location.pathname+t,!0)}}catch(e){}}replaceUrl_(e,t){clearTimeout(this.refreshTout_),t?window.history.replaceState(null,null,e):this.refreshTout_=setTimeout(function(){window.history.replaceState(null,null,e)},this.get("refreshDelay"))}viewChange_(){try{this.replaceState_&&this.replaceUrl_(this.getLink())}catch(e){}if(this._localStorage)try{localStorage["ol@permalink"]=this.getLink(this._localStorage)}catch(e){console.warn("Failed to access localStorage...")}}layerChange_(){this._tout&&(clearTimeout(this._tout),this._tout=null),this._tout=setTimeout(function(){this._tout=null;var e="";!function t(i){for(var s=0;s<i.length;s++)i[s].getVisible()&&i[s].get("permalink")&&(e&&(e+="|"),e+=i[s].get("permalink")+":"+i[s].get("opacity")),i[s].getLayers&&t(i[s].getLayers().getArray())}(this.getMap().getLayers().getArray()),this.layerStr_=e,this.viewChange_()}.bind(this),200)}},ol.control.Print=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:e.className||"ol-print"});super({element:t,target:e.target}),e.target||(t.classList.add("ol-unselectable","ol-control"),ol.ext.element.create("BUTTON",{type:"button",title:e.title||"Print",click:function(){this.print()}.bind(this),parent:t})),this.set("immediate",e.immediate),this.set("imageType",e.imageType||"image/jpeg"),this.set("quality",e.quality||.8),this.set("orientation",e.orientation)}toClipboard(e,t){try{e.canvas.toBlob(function(e){try{navigator.clipboard.write([new window.ClipboardItem(Object.defineProperty({},e.type,{value:e,enumerable:!0}))]),"function"==typeof t&&t(!0)}catch(e){"function"==typeof t&&t(!1)}})}catch(e){"function"==typeof t&&t(!1)}}copyMap(e,t){this.once("print",function(e){this.toClipboard(e,t)}.bind(this)),this.print(e)}_getCanvas(e,t,i){var s;if(e.context)i=e.context.canvas;else{if(i)s=i.getContext("2d");else{i=document.createElement("canvas");var o=this.getMap().getSize();i.width=o[0],i.height=o[1],s=i.getContext("2d"),/jp.*g$/.test(t)&&(s.fillStyle=this.get("bgColor")||"white",s.fillRect(0,0,i.width,i.height))}this.getMap().getViewport().querySelectorAll(".ol-layers canvas, canvas.ol-fixedoverlay").forEach(function(e){if(e.width){if(s.save(),"0"===e.parentNode.style.opacity)return;s.globalAlpha=parseFloat(e.parentNode.style.opacity)||1,s.globalCompositeOperation=ol.ext.element.getStyle(e.parentNode,"mix-blend-mode"),s.filter=ol.ext.element.getStyle(e.parentNode,"filter");var t=ol.ext.element.getStyle(e,"transform")||ol.ext.element.getStyle(e,"-webkit-transform");/^matrix/.test(t)?((t=t.replace(/^matrix\(|\)$/g,"").split(",")).forEach(function(e,i){t[i]=parseFloat(e)}),s.transform(t[0],t[1],t[2],t[3],t[4],t[5]),s.drawImage(e,0,0)):s.drawImage(e,0,0,ol.ext.element.getStyle(e,"width"),ol.ext.element.getStyle(e,"height")),s.restore()}}.bind(this))}return i}fastPrint(e,t){e=e||{},this._ol6?requestAnimationFrame(function(){t(this._getCanvas({},e.imageType,e.canvas))}.bind(this)):(this.getMap().once("postcompose",function(i){i.context||(this._ol6=!0),t(this._getCanvas(i,e.imageType,e.canvas))}.bind(this)),this.getMap().render())}print(e){var t=(e=e||{}).imageType||this.get("imageType"),i=e.quality||this.get("quality");if(this.getMap()){if("silent"!==e.immediate&&this.dispatchEvent(Object.assign({type:"printing"},e)),!e.immediate)return void setTimeout(function(){(e=Object.assign({},e)).immediate="silent",this.print(e)}.bind(this),200);this.getMap().once(this.get("immediate")?"postcompose":"rendercomplete",function(s){var o,r,a,n,l=this._getCanvas(s,t),h=e.size||[210,297],c=e.format||"a4",u=e.orient||this.get("orientation"),d="number"==typeof e.margin?e.margin:10;if(l){"landscape"!==u&&"portrait"!==u&&(u=l.width>l.height?"landscape":"portrait"),"landscape"===u&&(h=[h[1],h[0]]);var p=Math.min((h[0]-2*d)/l.width,(h[1]-2*d)/l.height);o=p*l.width,r=p*l.height,a=[(h[0]-o)/2,(h[1]-r)/2]}try{n=l?l.toDataURL(t,i):null}catch(g){return void this.dispatchEvent({type:"error",canvas:l})}var g=Object.assign({type:"print",print:{format:c,orientation:u,unit:"mm",size:h,position:a,imageWidth:o,imageHeight:r},image:n,imageType:t,quality:i,canvas:l},e);this.dispatchEvent(g)}.bind(this)),this.getMap().render()}}},ol.control.PrintDialog=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:(e.className||"ol-print")+" ol-unselectable ol-control"});super({element:t}),this._lang=e.lang||"en",e.target||ol.ext.element.create("BUTTON",{type:"button",title:e.title||"Print",click:function(){this.print()}.bind(this),parent:t}),e.openWindow&&this.on("print",function(e){e.canvas&&window.open().document.write('<img src="'+e.canvas.toDataURL()+'"/>')}),e.target=ol.ext.element.create("DIV");var i=this._printCtrl=new ol.control.Print(e);i.on(["print","error","printing"],function(e){this._printing(e)}.bind(this)),this._compass=new ol.control.Compass({src:e.northImage||"compact",visible:!1,className:"olext-print-compass",style:new ol.style.Stroke({color:"#333",width:0})});var s=this._printDialog=new ol.control.Dialog({target:e.targetDialog||document.body,closeBox:!0,className:"ol-ext-print-dialog"}),o=s.getContentElement();this._input={};var r=ol.ext.element.create("DIV",{className:"ol-print-param",parent:o});this._pages=[ol.ext.element.create("DIV",{className:"ol-page"})];var a=ol.ext.element.create("DIV",{className:"ol-map",parent:this._pages[0]});ol.ext.element.create("DIV",{html:this._pages[0],className:"ol-print-map",parent:o}),ol.ext.element.create("H2",{html:this.i18n("title"),parent:r});var n=ol.ext.element.create("UL",{parent:r}),l=ol.ext.element.create("LI",{className:"ol-orientation",parent:n});this._input.orientation={list:l};var h,c=ol.ext.element.create("LABEL",{className:"portrait",parent:l});this._input.orientation.portrait=ol.ext.element.create("INPUT",{type:"radio",name:"ol-print-orientation",value:"portrait",checked:!0,on:{change:function(e){this.setOrientation(e.target.value)}.bind(this)},parent:c}),ol.ext.element.create("SPAN",{html:this.i18n("portrait"),parent:c}),c=ol.ext.element.create("LABEL",{className:"landscape",parent:l}),this._input.orientation.landscape=ol.ext.element.create("INPUT",{type:"radio",name:"ol-print-orientation",value:"landscape",on:{change:function(e){this.setOrientation(e.target.value)}.bind(this)},parent:c}),ol.ext.element.create("SPAN",{html:this.i18n("landscape"),parent:c}),l=ol.ext.element.create("LI",{html:ol.ext.element.create("LABEL",{html:this.i18n("size")}),className:"ol-size",parent:n});var u=this._input.size=ol.ext.element.create("SELECT",{on:{change:function(){this.setSize(u.value||S)}.bind(this)},parent:l});for(h in this.paperSize)ol.ext.element.create("OPTION",{html:h+(this.paperSize[h]?" - "+this.paperSize[h][0]+"x"+this.paperSize[h][1]+" mm":this.i18n("custom")),value:h,parent:u});l=ol.ext.element.create("LI",{html:ol.ext.element.create("LABEL",{html:this.i18n("margin")}),className:"ol-margin",parent:n});var d=this._input.margin=ol.ext.element.create("SELECT",{on:{change:function(){this.setMargin(d.value)}.bind(this)},parent:l});for(h in this.marginSize)ol.ext.element.create("OPTION",{html:this.i18n(h)+" - "+this.marginSize[h]+" mm",value:this.marginSize[h],parent:d});l=ol.ext.element.create("LI",{html:ol.ext.element.create("LABEL",{html:this.i18n("scale")}),className:"ol-scale",parent:n});var p=this._input.scale=ol.ext.element.create("SELECT",{on:{change:function(){this.setScale(parseInt(p.value))}.bind(this)},parent:l});Object.keys(this.scales).forEach(function(e){ol.ext.element.create("OPTION",{html:this.scales[e],value:e,parent:p})}.bind(this)),l=ol.ext.element.create("LI",{className:"ol-legend",parent:n});var g=ol.ext.element.createSwitch({html:this.i18n("legend"),checked:!1,on:{change:function(){E.legend.control.setCanvas(g.checked)}.bind(this)},parent:l});l=ol.ext.element.create("LI",{className:"ol-print-north",parent:n});var m=this._input.north=ol.ext.element.createSwitch({html:this.i18n("north"),checked:"checked",on:{change:function(){m.checked?this._compass.element.classList.add("ol-print-compass"):this._compass.element.classList.remove("ol-print-compass"),this.getMap().render()}.bind(this)},parent:l});l=ol.ext.element.create("LI",{className:"ol-print-title",parent:n});var f=ol.ext.element.createSwitch({html:this.i18n("mapTitle"),checked:!1,on:{change:function(e){E.title.control.setVisible(e.target.checked)}.bind(this)},parent:l}),v=ol.ext.element.create("INPUT",{type:"text",placeholder:this.i18n("mapTitle"),on:{keydown:function(e){13===e.keyCode&&e.preventDefault()},keyup:function(){E.title.control.setTitle(v.value)},change:function(){E.title.control.setTitle(v.value)}.bind(this)},parent:l}),y=ol.ext.element.create("DIV",{className:"ol-user-param",parent:r});l=ol.ext.element.create("LI",{className:"ol-saveas",parent:n}),ol.ext.element.create("DIV",{html:this.i18n("copied"),className:"ol-clipboard-copy",parent:l});var _=ol.ext.element.create("SELECT",{on:{change:function(){var e=_.value;if(_.value="",!this.formats[e].clipboard||!this._copyMap(e)){var t="string"==typeof this.getSize()?this.getSize():null,s=Object.assign({format:t,size:t?this.paperSize[t]:null,orient:this.getOrientation(),margin:this.getMargin()},this.formats[e]);i.print(s)}}.bind(this)},parent:l});ol.ext.element.create("OPTION",{html:this.i18n("saveas"),style:{display:"none"},value:"",parent:_}),this.formats.forEach(function(t,i){if(t.pdf){if(!1===e.pdf)return}else if(t.clipboard){if(!1===e.copy)return}else if(!1===e.save)return;ol.ext.element.create("OPTION",{html:this.i18n(t.title),value:i,parent:_})}.bind(this)),1===_.querySelectorAll("option").length&&(_.style.display="none"),l=ol.ext.element.create("LI",{className:"ol-savelegend",parent:n});var x=ol.ext.element.create("DIV",{html:this.i18n("copied"),className:"ol-clipboard-copy",parent:l}),b=ol.ext.element.create("SELECT",{on:{change:function(){var e=E.legend.control.getLegend().getCanvas(),t=document.createElement("CANVAS");t.width=e.width,t.height=e.height;var i,s=t.getContext("2d");if(s.fillStyle="#fff",s.fillRect(0,0,t.width,t.height),s.drawImage(e,0,0),this.formats[b.value].clipboard)t.toBlob(function(e){try{navigator.clipboard.write([new window.ClipboardItem(Object.defineProperty({},e.type,{value:e,enumerable:!0}))]),x.classList.add("visible"),setTimeout(function(){x.classList.remove("visible")},1e3)}catch(e){}},"image/png");else try{i=t.toDataURL(this.formats[b.value].imageType,this.formats[b.value].quality);var o="string"==typeof this.getSize()?this.getSize():"A4",r=t.width/96*25.4,a=t.height/96*25.4,n=this.paperSize[o];"landscape"===this.getOrientation()&&(n=[n[1],n[0]]);var l=[(n[0]-r)/2,(n[1]-a)/2];this.dispatchEvent({type:"print",print:{legend:!0,format:o,orientation:this.getOrientation(),unit:"mm",size:this.paperSize[o],position:l,imageWidth:r,imageHeight:a},image:i,imageType:this.formats[b.value].imageType,pdf:this.formats[b.value].pdf,quality:this.formats[b.value].quality,canvas:t})}catch(e){}b.value=""}.bind(this)},parent:l});ol.ext.element.create("OPTION",{html:this.i18n("saveLegend"),style:{display:"none"},value:"",parent:b}),this.formats.forEach(function(e,t){ol.ext.element.create("OPTION",{html:this.i18n(e.title),value:t,parent:b})}.bind(this));var w,S,M,C=ol.ext.element.create("DIV",{className:"ol-ext-buttons",parent:r});ol.ext.element.create("BUTTON",{html:this.i18n("printBt"),type:"submit",click:function(e){e.preventDefault(),window.print()},parent:C}),ol.ext.element.create("BUTTON",{html:this.i18n("cancel"),type:"button",click:function(){s.hide()},parent:C}),ol.ext.element.create("DIV",{html:this.i18n("errorMsg"),className:"ol-error",parent:r});var E={};s.on("show",function(){this.dispatchEvent({type:"show",userElement:y,dialog:this._printDialog,page:this.getPage()});var e=this.getMap();e&&(document.body.classList.add("ol-print-document"),w=e.getTargetElement(),S=e.getSize(),"string"==typeof this.getSize()?this.setSize(this.getSize()):this.setSize(S),e.setTarget(a),M&&ol.Observable.unByKey(M),M=e.on("moveend",function(){this.setScale(ol.sphere.getMapScale(e))}.bind(this)),this.setScale(ol.sphere.getMapScale(e)),E={},this.getMap().getControls().forEach(function(e){e instanceof ol.control.Legend&&(E.legend={control:e}),e instanceof ol.control.CanvasTitle&&(E.title={control:e}),e instanceof ol.control.Compass&&(E.compass?e.element.classList.remove("ol-print-compass"):(this._input.north.checked?e.element.classList.add("ol-print-compass"):e.element.classList.remove("ol-print-compass"),this._compass=e,E.compass={control:e}))}.bind(this)),E.title?(f.checked=E.title.isVisible=E.title.control.getVisible(),v.value=E.title.control.getTitle(),f.parentNode.parentNode.classList.remove("hidden")):f.parentNode.parentNode.classList.add("hidden"),E.legend?(E.legend.ison=E.legend.control.onCanvas(),E.legend.collapsed=E.legend.control.isCollapsed(),E.legend.control.collapse(!1),b.parentNode.classList.remove("hidden"),g.parentNode.parentNode.classList.remove("hidden"),g.checked=!E.legend.collapsed,E.legend.control.setCanvas(!E.legend.collapsed)):(b.parentNode.classList.add("hidden"),g.parentNode.parentNode.classList.add("hidden")))}.bind(this)),s.on("hide",function(){document.body.classList.remove("ol-print-document"),w&&(this.getMap().setTarget(w),w=null,M&&ol.Observable.unByKey(M),E.title&&E.title.control.setVisible(E.title.isVisible),E.legend&&(E.legend.control.setCanvas(E.legend.ison),E.legend.control.collapse(E.legend.collapsed)),this.dispatchEvent({type:"hide"}))}.bind(this)),window.addEventListener("resize",function(){this.setSize()}.bind(this)),e.saveAs&&this.on("print",function(t){t.pdf||t.canvas.toBlob(function(i){var s=(t.print.legend?"legend.":"map.")+t.imageType.replace("image/","");e.saveAs(i,s)},t.imageType,t.quality)}),e.jsPDF&&this.on("print",function(t){if(t.pdf){var i=new e.jsPDF({orientation:t.print.orientation,unit:t.print.unit,format:t.print.size});i.addImage(t.image,"JPEG",t.print.position[0],t.print.position[0],t.print.imageWidth,t.print.imageHeight),i.save(t.print.legend?"legend.pdf":"map.pdf")}})}static addLang(e,t){ol.control.PrintDialog.prototype._labels[e]=t}isOpen(){return this._printDialog.isOpen()}i18n(e){var t=this._labels.en[e]||e;return this._labels[this._lang]&&this._labels[this._lang][e]&&(t=this._labels[this._lang][e]),t}getOrientation(){return this._orientation||"portrait"}setOrientation(e){this._orientation="landscape"===e?"landscape":"portrait",this._printDialog.element.dataset.orientation=this._orientation,this._input.orientation[this._orientation].checked=!0,this.setSize()}getMargin(){return this._margin||0}setMargin(e){this._margin=e,this._input.margin.value=e,this.setSize()}getSize(){return this._size}setSize(e){if(this._printDialog.getContentElement().dataset.status="",e?this._size=e:e=this._size,e){if("string"==typeof e){for(var t in this.paperSize)t&&new RegExp(t,"i").test(e)&&(e=t);this.paperSize[e]||(e=this._size="A4"),this._input.size.value=e,e=[Math.trunc(96*this.paperSize[e][0]/25.4),Math.trunc(96*this.paperSize[e][1]/25.4)],"landscape"===this.getOrientation()&&(e=[e[1],e[0]]),this.getPage().classList.remove("margin")}else this._input.size.value="",this.getPage().classList.add("margin");var i=this.getPage(),s=i.parentNode.getBoundingClientRect(),o=(s.width-40)/e[0],r=(s.height-40)/e[1],a=Math.min(o,r,1);i.style.width=e[0]+"px",i.style.height=e[1]+"px",i.style["-webkit-transform"]=i.style.transform="translate(-50%,-50%) scale("+a+")";var n=Math.round(5/a);i.style["-webkit-box-shadow"]=i.style["box-shadow"]=n+"px "+n+"px "+n+"px rgba(0,0,0,.6)",i.style.padding=96*this.getMargin()/25.4+"px",this.getMap()&&this.getMap().updateSize(),this.dispatchEvent({type:"dialog:refresh"})}}_printing(e){this._printDialog.getContentElement().dataset.status=e.type,e.clipboard||this.dispatchEvent(e)}_copyMap(e){var t=this._printDialog.element.querySelector(".ol-clipboard-copy");return this._printCtrl.copyMap(this.formats[e],function(e){e&&(t.classList.add("visible"),setTimeout(function(){t.classList.remove("visible")},1e3))}),!0}getContentElement(){return this._printDialog.getContentElement()}getUserElement(){return this._printDialog.getContentElement().querySelector(".ol-user-param")}getPage(){return this._pages[0]}setMap(e){this.getMap()&&(this.getMap().removeControl(this._compass),this.getMap().removeControl(this._printCtrl),this.getMap().removeControl(this._printDialog)),super.setMap(e),this.getMap()&&(this.getMap().addControl(this._compass),this.getMap().addControl(this._printCtrl),this.getMap().addControl(this._printDialog))}setScale(e){ol.sphere.setMapScale(this.getMap(),e),this._input.scale.value=" "+100*Math.round(e/100)}getScale(){return ol.sphere.getMapScale(this.getMap())}print(e){(e=e||{}).size&&this.setSize(e.size),e.scale&&this.setScale(e.scale),e.orientation&&this.setOrientation(e.orientation),e.margin&&this.setMargin(e.margin),this._printDialog.show()}getPrintControl(){return this._printCtrl}},ol.control.PrintDialog.prototype._labels={en:{title:"Print",orientation:"Orientation",portrait:"Portrait",landscape:"Landscape",size:"Page size",custom:"screen size",margin:"Margin",scale:"Scale",legend:"Legend",north:"North arrow",mapTitle:"Map title",saveas:"Save as...",saveLegend:"Save legend...",copied:"✔ Copied to clipboard",errorMsg:"Can't save map canvas...",printBt:"Print...",clipboardFormat:"copy to clipboard...",jpegFormat:"save as jpeg",pngFormat:"save as png",pdfFormat:"save as pdf",none:"none",small:"small",large:"large",cancel:"cancel"},fr:{title:"Imprimer",orientation:"Orientation",portrait:"Portrait",landscape:"Paysage",size:"Taille du papier",custom:"taille écran",margin:"Marges",scale:"Echelle",legend:"Légende",north:"Flèche du nord",mapTitle:"Titre de la carte",saveas:"Enregistrer sous...",saveLegend:"Enregistrer la légende...",copied:"✔ Carte copiée",errorMsg:"Impossible d'enregistrer la carte",printBt:"Imprimer",clipboardFormat:"copier dans le presse-papier...",jpegFormat:"enregistrer un jpeg",pngFormat:"enregistrer un png",pdfFormat:"enregistrer un pdf",none:"aucune",small:"petites",large:"larges",cancel:"annuler"},de:{title:"Drucken",orientation:"Ausrichtung",portrait:"Hochformat",landscape:"Querformat",size:"Papierformat",custom:"Bildschirmgröße",margin:"Rand",scale:"Maßstab",legend:"Legende",north:"Nordpfeil",mapTitle:"Kartentitel",saveas:"Speichern als...",saveLegend:"Legende speichern...",copied:"✔ In die Zwischenablage kopiert",errorMsg:"Kann Karte nicht speichern...",printBt:"Drucken...",clipboardFormat:"in die Zwischenablage kopieren...",jpegFormat:"speichern als jpeg",pngFormat:"speichern als png",pdfFormat:"speichern als pdf",none:"kein",small:"klein",large:"groß",cancel:"abbrechen"},zh:{title:"打印",orientation:"方向",portrait:"纵向",landscape:"横向",size:"页面大小",custom:"屏幕大小",margin:"外边距",scale:"尺度",legend:"图例",north:"指北针",mapTitle:"地图名字",saveas:"保存为...",saveLegend:"保存图例为...",copied:"✔ 已复制到剪贴板",errorMsg:"无法保存地图...",printBt:"打印...",cancel:"取消"},it:{title:"Stampa",orientation:"Orientamento",portrait:"Verticale",landscape:"Orizzontale",size:"Formato pagina",custom:"Dimensione schermo",margin:"Margini",scale:"Scala",legend:"Legenda",north:"Freccia nord",mapTitle:"Titolo della mappa",saveas:"Salva con nome...",saveLegend:"Salva legenda...",copied:"✔ Copiato negli appunti",errorMsg:"Impossibile salvare la mappa",printBt:"Stampa",clipboardFormat:"Copia negli appunti...",jpegFormat:"salva come jpeg",pngFormat:"salva come png",pdfFormat:"salva come pdf",none:"nessuno",small:"piccolo",large:"grande",cancel:"annulla"}},ol.control.PrintDialog.prototype.paperSize={"":null,A0:[841,1189],A1:[594,841],A2:[420,594],A3:[297,420],A4:[210,297],"US Letter":[215.9,279.4],A5:[148,210],B4:[257,364],B5:[182,257]},ol.control.PrintDialog.prototype.marginSize={none:0,small:5,large:10},ol.control.PrintDialog.prototype.formats=[{title:"clipboardFormat",imageType:"image/png",clipboard:!0},{title:"jpegFormat",imageType:"image/jpeg",quality:.8},{title:"pngFormat",imageType:"image/png",quality:.8},{title:"pdfFormat",imageType:"image/jpeg",pdf:!0}],ol.control.PrintDialog.prototype.scales={" 5000":"1/5.000"," 10000":"1/10.000"," 25000":"1/25.000"," 50000":"1/50.000"," 100000":"1/100.000"," 250000":"1/250.000"," 1000000":"1/1.000.000"},ol.control.PrintDialog2x=class extends ol.control.PrintDialog{constructor(e){super(e=e||{}),this._printDialog.element.classList.add("ol-ext-print-dialog2x");var t,i=ol.ext.element.create("DIV",{className:"ol-map2",parent:this._pages[0]});(this._printCtrl2=new ol.control.Print(e)).on(["print","error","printing"],function(e){if("print"===e.type){var t=document.createElement("canvas"),s=i.querySelector(".ol-layers"),o=s.style.clipPath||s.style.clip;if(o){var r=o.replace(/^(.*)\((.*)\)/,"$2");switch((o={type:o.replace(/^(.*)\(.*/,"$1")}).type){case"circle":r=r.split(" "),o.radius=parseFloat(r[0]),o.x=parseFloat(r[2]),o.y=parseFloat(r[3]);break;case"rect":r=r.split(","),o.top=parseFloat(r[0]),o.right=parseFloat(r[1]),o.bottom=parseFloat(r[2]),o.left=parseFloat(r[3]);break;default:console.warn("no clip ("+o.type+")")}t.width=this._canvas1.width,t.height=this._canvas1.height}else"landscape"===this.getOrientation()?(t.width=this._canvas1.width+e.canvas.width,t.height=this._canvas1.height):(t.width=this._canvas1.width,t.height=this._canvas1.height+e.canvas.height);var a=t.getContext("2d");if(a.drawImage(this._canvas1,0,0),o){switch(a.save(),o.type){case"rect":a.beginPath(),a.rect(o.left,o.top,o.right-o.left,o.bottom-o.top);break;case"circle":a.beginPath(),a.arc(o.x,o.y,o.radius,0,2*Math.PI)}a.clip(),a.drawImage(e.canvas,0,0),a.restore()}else a.drawImage(e.canvas,"landscape"===this.getOrientation()?this._canvas1.width:0,"landscape"!==this.getOrientation()?this._canvas1.height:0);e.canvas=t,e.image=t.toDataURL(e.imageType,e.quality);var n=t.width/96*25.4,l=t.height/96*25.4,h=e.print.size;"landscape"===this.getOrientation()&&(h=[h[1],h[0]]),e.print.position=[(h[0]-n)/2,(h[1]-l)/2],e.print.imageWidth=n,e.print.imageHeight=l}if(this._clipboard)try{e.canvas.toBlob(function(e){try{navigator.clipboard.write([new window.ClipboardItem(Object.defineProperty({},e.type,{value:e,enumerable:!0}))]);var t=this._printDialog.element.querySelector(".ol-clipboard-copy");t.classList.add("visible"),setTimeout(function(){t.classList.remove("visible")},1e3)}catch(e){}}.bind(this))}catch(e){}else this.dispatchEvent(e)}.bind(this)),this._printDialog.on("show",function(){this.getMap2()&&(t=this.getMap2().getTargetElement(),this.getMap2().setTarget(i),t.dataset.swipeOrientation&&(this._printDialog.element.dataset.swipeOrientation=t.dataset.swipeOrientation),t.dataset.clipMap&&(this._printDialog.element.dataset.clipMap=t.dataset.clipMap))}.bind(this)),this._printDialog.on("hide",function(){delete this._printDialog.element.dataset.swipeOrientation,delete this._printDialog.element.dataset.clipMap,t&&(this.getMap2()&&this.getMap2().setTarget(t),t=null)}.bind(this)),e.map2&&this.setMap2(e.map2)}setMap2(e){this.getMap2()&&this.getMap2().removeControl(this._printCtrl2),this._map2=e,e&&this.getMap2().addControl(this._printCtrl2)}getMap2(){return this._map2}_printing(e){this._printDialog.getContentElement().dataset.status=e.type,"print"===e.type?(this._canvas1=e.canvas,this._clipboard=e.clipboard,this._printCtrl2.print({format:e.print.format,imageType:e.imageType,margin:e.margin,pdf:e.pdf,orient:e.print.orientation,quality:e.quality,size:e.print.size,title:e.title})):e.clipboard||this.dispatchEvent(e)}_copyMap(){return!1}},ol.control.Profile=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");super({element:t,target:e.target});var i=this;if(this.info=e.info||ol.control.Profile.prototype.info,e.target)t.classList.add(e.className||"ol-profile");else{t.className=((e.className||"ol-profile")+" ol-unselectable ol-control ol-collapsed").trim(),this.button=document.createElement("button"),this.button.title=e.title||"Profile",this.button.setAttribute("type","button");var s=function(e){i.toggle(),e.preventDefault()};this.button.addEventListener("click",s),this.button.addEventListener("touchstart",s),t.appendChild(this.button),ol.ext.element.create("I",{parent:this.button})}e.style instanceof ol.style.Style?this._style=e.style:this._style=new ol.style.Style({text:new ol.style.Text,stroke:new ol.style.Stroke({width:1.5,color:"#369"})}),this._style.getText()||this._style.setText(new ol.style.Text),e.selectStyle instanceof ol.style.Style?this._selectStyle=e.selectStyle:this._selectStyle=new ol.style.Style({fill:new ol.style.Fill({color:"#369"})});var o=document.createElement("div");o.classList.add("ol-inner"),t.appendChild(o);var r=document.createElement("div");r.style.position="relative",o.appendChild(r);var a=this.ratio=2;this.canvas_=document.createElement("canvas"),this.canvas_.width=(e.width||300)*a,this.canvas_.height=(e.height||150)*a;var n={msTransform:"scale(0.5,0.5)",msTransformOrigin:"0 0",webkitTransform:"scale(0.5,0.5)",webkitTransformOrigin:"0 0",mozTransform:"scale(0.5,0.5)",mozTransformOrigin:"0 0",transform:"scale(0.5,0.5)",transformOrigin:"0 0"};Object.keys(n).forEach(function(e){e in i.canvas_.style&&(i.canvas_.style[e]=n[e])});var l=document.createElement("div");r.appendChild(l),l.style.width=this.canvas_.width/a+"px",l.style.height=this.canvas_.height/a+"px",l.appendChild(this.canvas_),l.addEventListener("pointerdown",this.onMove.bind(this)),document.addEventListener("pointerup",this.onMove.bind(this)),l.addEventListener("mousemove",this.onMove.bind(this)),l.addEventListener("touchmove",this.onMove.bind(this)),this.set("selectable",e.selectable),this.margin_={top:10*a,left:45*a,bottom:30*a,right:10*a},this.info.ytitle||(this.margin_.left-=20*a),this.info.xtitle||(this.margin_.bottom-=20*a),this.bar_=document.createElement("div"),this.bar_.classList.add("ol-profilebar"),this.bar_.style.top=this.margin_.top/a+"px",this.bar_.style.height=(this.canvas_.height-this.margin_.top-this.margin_.bottom)/a+"px",r.appendChild(this.bar_),this.cursor_=document.createElement("div"),this.cursor_.classList.add("ol-profilecursor"),r.appendChild(this.cursor_),this.popup_=document.createElement("div"),this.popup_.classList.add("ol-profilepopup"),this.cursor_.appendChild(this.popup_);var h=document.createElement("table");h.cellPadding="0",h.cellSpacing="0",h.style.clientWidth=this.canvas_.width/a+"px",r.appendChild(h);var c=document.createElement("tr");c.classList.add("track-info"),h.appendChild(c);var u=document.createElement("td");u.innerHTML=(this.info.zmin||"Zmin")+': <span class="zmin">',c.appendChild(u);var d=document.createElement("td");d.innerHTML=(this.info.zmax||"Zmax")+': <span class="zmax">',c.appendChild(d);var p=document.createElement("td");p.innerHTML=(this.info.distance||"Distance")+': <span class="dist">',c.appendChild(p);var g=document.createElement("td");g.innerHTML=(this.info.time||"Time")+': <span class="time">',c.appendChild(g);var m=document.createElement("tr");m.classList.add("point-info"),h.appendChild(m);var f=document.createElement("td");f.innerHTML=(this.info.altitude||"Altitude")+': <span class="z">',m.appendChild(f);var v=document.createElement("td");v.innerHTML=(this.info.distance||"Distance")+': <span class="dist">',m.appendChild(v);var y,_,x=document.createElement("td");(x.innerHTML=(this.info.time||"Time")+': <span class="time">',m.appendChild(x),this.tab_=[],e.feature&&this.setGeometry(e.feature),e.zoomable)&&(this.set("selectable",!0),this.on("change:geometry",function(){_=null}),this.on("dragstart",function(e){y=e.index}),this.on("dragend",function(e){if(Math.abs(y-e.index)>10){if(!_)var i=ol.ext.element.create("BUTTON",{parent:t,className:"ol-zoom-out",click:function(e){e.stopPropagation(),e.preventDefault(),_&&(this.dispatchEvent({type:"zoom"}),this.setGeometry(_,this._geometry[1])),t.removeChild(i)}.bind(this)});var s=_||this._geometry[0],o=new ol.geom.LineString(this.getSelection(y,e.index));this.setGeometry(o,this._geometry[1]),_=s,this.dispatchEvent({type:"zoom",geometry:o,start:y,end:e.index})}}.bind(this)))}popup(e){this.popup_.innerHTML=e}_drawAt(e,t){e?(this.cursor_.style.left=t+"px",this.cursor_.style.top=(this.canvas_.height-this.margin_.bottom+e[1]*this.scale_[1]+this.dy_)/this.ratio+"px",this.cursor_.style.display="block",this.bar_.parentElement.classList.add("over"),this.bar_.style.left=t+"px",this.bar_.style.display="block",this.element.querySelector(".point-info .z").textContent=e[1]+this.info.altitudeUnits,this.element.querySelector(".point-info .dist").textContent=(e[0]/1e3).toFixed(1)+this.info.distanceUnitsKM,this.element.querySelector(".point-info .time").textContent=e[2],t>this.canvas_.width/this.ratio/2?this.popup_.classList.add("ol-left"):this.popup_.classList.remove("ol-left")):(this.cursor_.style.display="none",this.bar_.style.display="none",this.cursor_.style.display="none",this.bar_.parentElement.classList.remove("over"))}showAt(e){var t,i,s,o=1/0;if(void 0===e)this.bar_.parentElement.classList.contains("over")&&this._drawAt();else if(e.length)for(t=1;i=this.tab_[t];t++){var r=ol.coordinate.dist2d(i[3],e);r<o&&(s=i,o=r)}else for(t=0;(i=this.tab_[t])&&(s=i,!(i[0]>=e));t++);if(s){var a=(s[0]*this.scale_[0]+this.margin_.left)/this.ratio;return this._drawAt(s,a),s[3]}return null}showAtTime(e,t){var i,s,o;if(e instanceof Date?e=e.getTime()/1e3:t&&(e+=this.tab_[0][3][3]),void 0===e)this.bar_.parentElement.classList.contains("over")&&this._drawAt();else for(i=0;(s=this.tab_[i])&&(o=s,!(s[3][3]>=e));i++);if(o){var r=(o[0]*this.scale_[0]+this.margin_.left)/this.ratio;return this._drawAt(o,r),o[3]}return null}pointAtTime(e){var t,i;for(t=1;i=this.tab_[t];t++){var s=i[3][3];if(s>=e){var o=this.tab_[t-1][3];return(o[3]+s)/2<e?o:i}}return this.tab_[this.tab_.length-1][3]}onMove(e){if(this.tab_.length){var t=this.canvas_.getBoundingClientRect(),i=t.top+window.pageYOffset-document.documentElement.clientTop,s=t.left+window.pageXOffset-document.documentElement.clientLeft,o=e.pageX||e.touches&&e.touches.length&&e.touches[0].pageX||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageX,r=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY,a=o-s,n=r-i,l=this.ratio;if(a>this.margin_.left/l-20&&a<(this.canvas_.width-this.margin_.right)/l+8&&n>this.margin_.top/l&&n<(this.canvas_.height-this.margin_.bottom)/l){var h,c,u=(a*l-this.margin_.left)/this.scale_[0],d=this.tab_[0];for(h=1;c=this.tab_[h];h++)if(c[0]>=u){u<(c[0]+d[0])/2&&(h=0,c=d);break}switch(c||(c=this.tab_[this.tab_.length-1]),a=Math.max(this.margin_.left/l,Math.min(a,(this.canvas_.width-this.margin_.right)/l)),this._drawAt(c,a),this.dispatchEvent({type:"over",click:"click"===e.type,index:h,coord:c[3],time:c[2],distance:c[0]}),e.type){case"pointerdown":this._dragging={event:{type:"dragstart",index:h,coord:c[3],time:c[2],distance:c[0]},pageX:o,pageY:r};break;case"pointerup":this._dragging&&this._dragging.pageX?Math.abs(this._dragging.pageX-o)<3&&Math.abs(this._dragging.pageY-r)<3&&(this.dispatchEvent({type:"click",index:h,coord:c[3],time:c[2],distance:c[0]}),this.refresh()):this.dispatchEvent({type:"dragend",index:h,coord:c[3],time:c[2],distance:c[0]}),this._dragging=!1;break;default:if(this._dragging)if(this._dragging.pageX)(Math.abs(this._dragging.pageX-o)>3||Math.abs(this._dragging.pageY-r)>3)&&(this._dragging.pageX=this._dragging.pageY=!1,this.dispatchEvent(this._dragging.event));else{this.dispatchEvent({type:"dragging",index:h,coord:c[3],time:c[2],distance:c[0]});var p=Math.min(this._dragging.event.index,h),g=Math.max(this._dragging.event.index,h);this.refresh(),this.get("selectable")&&this._drawGraph(this.tab_.slice(p,g),this._selectStyle)}}}else this.bar_.parentElement.classList.contains("over")&&(this._drawAt(),this.dispatchEvent({type:"out"})),"pointerup"===e.type&&this._dragging&&(this.dispatchEvent({type:"dragcancel"}),this._dragging=!1)}}show(){this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"show",show:!0})}hide(){this.element.classList.add("ol-collapsed"),this.dispatchEvent({type:"show",show:!1})}toggle(){this.element.classList.toggle("ol-collapsed");var e=this.element.classList.contains("ol-collapsed");this.dispatchEvent({type:"show",show:!e})}isShown(){return!this.element.classList.contains("ol-collapsed")}getSelection(e,t){for(var i=[],s=Math.max(Math.min(e,t),0),o=Math.min(Math.max(e,t),this.tab_.length-1),r=s;r<=o;r++)i.push(this.tab_[r][3]);return i}_drawGraph(e,t){if(e.length){var i,s,o=this.canvas_.getContext("2d"),r=this.scale_[0],a=this.scale_[1],n=this.dy_,l=this.ratio;for(o.beginPath(),i=0;s=e[i];i++)0==i?o.moveTo(s[0]*r,s[1]*a+n):o.lineTo(s[0]*r,s[1]*a+n);t.getStroke()&&(o.strokeStyle=t.getStroke().getColor()||"#000",o.lineWidth=t.getStroke().getWidth()*l,o.setLineDash([]),o.stroke()),t.getFill()&&(o.fillStyle=t.getFill().getColor()||"#000",o.Style=t.getFill().getColor()||"#000",o.lineTo(e[e.length-1][0]*r,0),o.lineTo(e[0][0]*r,0),o.fill())}}setGeometry(e,t){if(t||(t={}),e instanceof ol.Feature&&(e=e.getGeometry()),this._geometry=[e,t],/Z/.test(e.getLayout())){/M/.test(e.getLayout())?this.element.querySelector(".time").parentElement.style.display="block":this.element.querySelector(".time").parentElement.style.display="none";var i=e.getCoordinates();switch(e.getType()){case"LineString":break;case"MultiLineString":i=i[0];break;default:return}var s,o,r,a,n,l,h,c=t.projection||this.getMap().getView().getProjection(),u=1/0,d=-1/0,p=this.tab_=[];for(s=0;o=i[s];s++)(a=o[2])<u&&(u=a),a>d&&(d=a),0==s?r=0:r+=(l=i[s-1],h=o,ol.sphere.getDistance(ol.proj.transform(l,c,"EPSG:4326"),ol.proj.transform(h,c,"EPSG:4326"))),n=g(i[0][3],o[3]),p.push([r,a,n,o]);this._z=[u,d],this.set("graduation",t.graduation||100),this.set("zmin",t.zmin),this.set("zmax",t.zmax),this.set("amplitude",t.amplitude),this.set("unit",t.unit),this.set("zunit",t.zunit),this.set("zDigits",t.zDigits),this.set("zMaxChars",t.zMaxChars),this.dispatchEvent({type:"change:geometry",geometry:e}),this.refresh()}function g(e,t){if(!e||!t)return"-";var i=(t-e)/60,s=Math.trunc(i/60),o=Math.trunc(i-60*s);return s+"h"+(o<10?"0":"")+o+"mn"}}refresh(){var e=this.canvas_,t=e.getContext("2d"),i=e.width,s=e.height;t.setTransform(1,0,0,1,0,0),t.clearRect(0,0,i,s);var o,r=this._z[0],a=this._z[1],n=this.tab_,l=n[n.length-1][0],h=n[n.length-1][2];if(l){t.setTransform(1,0,0,1,this.margin_.left,s-this.margin_.bottom);var c=this.ratio;i-=this.margin_.right+this.margin_.left,s-=this.margin_.top+this.margin_.bottom,t.strokeStyle=this._style.getText().getFill().getColor()||"#000",t.lineWidth=.5*c,t.beginPath(),t.moveTo(0,0),t.lineTo(0,-s),t.moveTo(0,0),t.lineTo(i,0),t.stroke(),this.element.querySelector(".track-info .zmin").textContent=r.toFixed(2)+this.info.altitudeUnits,this.element.querySelector(".track-info .zmax").textContent=a.toFixed(2)+this.info.altitudeUnits,this.element.querySelector(".track-info .dist").textContent=l>1e3?(l/1e3).toFixed(1)+this.info.distanceUnitsKM:l.toFixed(1)+this.info.distanceUnitsM,this.element.querySelector(".track-info .time").textContent=h;for(var u=this.get("graduation");;){if(!(s/(((a=Math.ceil(a/u)*u)-(r=Math.floor(r/u)*u))/u)<15*c))break;u*=2}"number"==typeof this.get("zmin")&&r>this.get("zmin")&&(r=this.get("zmin")),"number"==typeof this.get("zmax")&&a<this.get("zmax")&&(a=this.get("zmax"));var d=this.get("amplitude");d&&(a=Math.max(r+d,a));var p=i/l,g=-s/(a-r),m=this.dy_=-r*g;this.scale_=[p,g],this._drawGraph(n,this._style),t.textAlign="right",t.textBaseline="top",t.fillStyle=this._style.getText().getFill().getColor()||"#000",t.beginPath();var f,v=this.get("zDigits")||0,y=null;if("number"==typeof this.get("zMaxChars"))if(f="km"!=this.get("zunit")?Math.max(r.toFixed(v).length,a.toFixed(v).length):Math.max((r/1e3).toFixed(1).length,(a/1e3).toFixed(1).length),this.get("zMaxChars")<f){y=Math.floor(Math.log10(Math.max(Math.abs(r),Math.abs(a),Number.MIN_VALUE))),t.font="bold "+9*c+"px arial",t.fillText(y.toString(),-8*c,8*c);var _=t.measureText(y.toString()),x=_.width,b=_.actualBoundingBoxAscent+_.actualBoundingBoxDescent;t.font="bold "+12*c+"px arial",t.fillText("10",-8*c-x,8*c+.5*b)}for(t.font=10*c+"px arial",t.textBaseline="middle",o=r;o<=a;o+=u){if(null!==y){var w=o/Math.pow(10,y);"km"==this.get("zunit")&&(w/=1e3);var S=this.get("zMaxChars")-Math.floor(Math.log10(Math.max(Math.abs(w),1))+1)-1;w<0&&(S-=1),this.get("zunit"),t.fillText(w.toFixed(Math.max(S,0)),-4*c,o*g+m)}else"km"!=this.get("zunit")?t.fillText(o.toFixed(v),-4*c,o*g+m):t.fillText((o/1e3).toFixed(1),-4*c,o*g+m);t.moveTo(-2*c,o*g+m),0!=o?t.lineTo(l*p,o*g+m):t.lineTo(0,o*g+m)}t.textAlign="center",t.textBaseline="top",t.setLineDash([c,3*c]);var M,C=this.get("unit")||"km";for(l>1e3?(M=100*Math.round(l/1e3))>1e3&&(M=1e3*Math.ceil(M/1e3)):(C="m",M=l>100?10*Math.round(l/100):l>10?Math.round(l/10):l>1?Math.round(l)/10:l),o=0;o<=l;o+=M){var E="m"==C?o:o/1e3;t.fillText(Math.round(10*E)/10,o*p,4*c),t.moveTo(o*p,2*c),t.lineTo(o*p,0)}t.font=12*c+"px arial",t.fillText(this.info.xtitle.replace("(km)","("+C+")"),i/2,18*c),t.save(),t.rotate(-Math.PI/2),t.fillText(this.info.ytitle,s/2,-this.margin_.left),t.restore(),t.stroke()}else console.error("[ol/control/Profile] no data...",n)}getImage(e,t){return"canvas"===e?this.canvas_:this.canvas_.toDataURL(e,t)}},ol.control.Profile.prototype.info={zmin:"Zmin",zmax:"Zmax",ytitle:"Altitude (m)",xtitle:"Distance (km)",time:"Time",altitude:"Altitude",distance:"Distance",altitudeUnits:"m",distanceUnitsM:"m",distanceUnitsKM:"km"},ol.control.Profil=ol.control.Profile,ol.control.Profile=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");super({element:t,target:e.target});var i=this;if(this.info=e.info||ol.control.Profile.prototype.info,e.target)t.classList.add(e.className||"ol-profile");else{t.className=((e.className||"ol-profile")+" ol-unselectable ol-control ol-collapsed").trim(),this.button=document.createElement("button"),this.button.title=e.title||"Profile",this.button.setAttribute("type","button");var s=function(e){i.toggle(),e.preventDefault()};this.button.addEventListener("click",s),this.button.addEventListener("touchstart",s),t.appendChild(this.button),ol.ext.element.create("I",{parent:this.button})}e.style instanceof ol.style.Style?this._style=e.style:this._style=new ol.style.Style({text:new ol.style.Text,stroke:new ol.style.Stroke({width:1.5,color:"#369"})}),this._style.getText()||this._style.setText(new ol.style.Text),e.selectStyle instanceof ol.style.Style?this._selectStyle=e.selectStyle:this._selectStyle=new ol.style.Style({fill:new ol.style.Fill({color:"#369"})});var o=document.createElement("div");o.classList.add("ol-inner"),t.appendChild(o);var r=document.createElement("div");r.style.position="relative",o.appendChild(r);var a=this.ratio=2;this.canvas_=document.createElement("canvas"),this.canvas_.width=(e.width||300)*a,this.canvas_.height=(e.height||150)*a;var n={msTransform:"scale(0.5,0.5)",msTransformOrigin:"0 0",webkitTransform:"scale(0.5,0.5)",webkitTransformOrigin:"0 0",mozTransform:"scale(0.5,0.5)",mozTransformOrigin:"0 0",transform:"scale(0.5,0.5)",transformOrigin:"0 0"};Object.keys(n).forEach(function(e){e in i.canvas_.style&&(i.canvas_.style[e]=n[e])}),this.div_to_canvas_=document.createElement("div"),r.appendChild(this.div_to_canvas_),this.div_to_canvas_.style.width=this.canvas_.width/a+"px",this.div_to_canvas_.style.height=this.canvas_.height/a+"px",this.div_to_canvas_.appendChild(this.canvas_),this.setProperties({units:e.units||"metric",numberFormat:e.numberFormat,selectable:e.selectable}),this._isMetric="metric"===this.get("units"),this.margin_={top:10*a,left:45*a,bottom:30*a,right:10*a},this.info.ytitle||(this.margin_.left-=20*a),this.info.xtitle||(this.margin_.bottom-=20*a),this.bar_=document.createElement("div"),this.bar_.classList.add("ol-profilebar"),this.bar_.style.top=this.margin_.top/a+"px",this.bar_.style.height=(this.canvas_.height-this.margin_.top-this.margin_.bottom)/a+"px",r.appendChild(this.bar_),this.cursor_=document.createElement("div"),this.cursor_.classList.add("ol-profilecursor"),r.appendChild(this.cursor_),this.popup_=document.createElement("div"),this.popup_.classList.add("ol-profilepopup"),this.cursor_.appendChild(this.popup_);var l=document.createElement("table");l.cellPadding="0",l.cellSpacing="0",l.style.clientWidth=this.canvas_.width/a+"px",r.appendChild(l);var h=document.createElement("tr");h.classList.add("track-info"),l.appendChild(h);var c=document.createElement("td");c.innerHTML=(this.info.zmin||"Zmin")+': <span class="zmin">',h.appendChild(c);var u=document.createElement("td");u.innerHTML=(this.info.zmax||"Zmax")+': <span class="zmax">',h.appendChild(u);var d=document.createElement("td");d.innerHTML=(this.info.distance||"Distance")+': <span class="dist">',h.appendChild(d);var p=document.createElement("td");p.innerHTML=(this.info.time||"Time")+': <span class="time">',h.appendChild(p);var g=document.createElement("tr");g.classList.add("point-info"),l.appendChild(g);var m=document.createElement("td");m.innerHTML=(this.info.altitude||"Altitude")+': <span class="z">',g.appendChild(m);var f=document.createElement("td");f.innerHTML=(this.info.distance||"Distance")+': <span class="dist">',g.appendChild(f);var v,y,_=document.createElement("td");(_.innerHTML=(this.info.time||"Time")+': <span class="time">',g.appendChild(_),this.tab_=[],e.feature&&this.setGeometry(e.feature),e.zoomable)&&(this.set("selectable",!0),this.on("change:geometry",function(){y=null}),this.on("dragstart",function(e){v=e.index}),this.on("dragend",function(e){if(Math.abs(v-e.index)>10){if(!y)var i=ol.ext.element.create("BUTTON",{parent:t,className:"ol-zoom-out",click:function(e){e.stopPropagation(),e.preventDefault(),y&&(this.dispatchEvent({type:"zoom"}),this.setGeometry(y,this._geometry[1])),t.removeChild(i)}.bind(this)});var s=y||this._geometry[0],o=new ol.geom.LineString(this.getSelection(v,e.index));this.setGeometry(o,this._geometry[1]),y=s,this.dispatchEvent({type:"zoom",geometry:o,start:v,end:e.index})}}.bind(this)));e.target&&this._addListeners()}_addListeners(){this.onMoveBinded||(this.onMoveBinded=this.onMove.bind(this),this.div_to_canvas_.addEventListener("pointerdown",this.onMoveBinded),this.div_to_canvas_.addEventListener("mousemove",this.onMoveBinded),this.div_to_canvas_.addEventListener("touchmove",this.onMoveBinded),document.addEventListener("pointerup",this.onMoveBinded))}_removeListeners(){this.onMoveBinded&&(this.div_to_canvas_.removeEventListener("pointerdown",this.onMoveBinded),this.div_to_canvas_.removeEventListener("mousemove",this.onMoveBinded),this.div_to_canvas_.removeEventListener("touchmove",this.onMoveBinded),document.removeEventListener("pointerup",this.onMoveBinded),this.onMoveBinded=null)}popup(e){this.popup_.innerHTML=e}_drawAt(e,t){if(e){this.cursor_.style.left=t+"px",this.cursor_.style.top=(this.canvas_.height-this.margin_.bottom+e[1]*this.scale_[1]+this.dy_)/this.ratio+"px",this.cursor_.style.display="block",this.bar_.parentElement.classList.add("over"),this.bar_.style.left=t+"px",this.bar_.style.display="block";var i,s=this._isMetric?ol.control.Profile.prototype.Unit.Meter:ol.control.Profile.prototype.Unit.Foot,o=this._unitsConversion(e[1],s);this.element.querySelector(".point-info .z").textContent="number"==typeof o?this._numberFormat(o,this.get("zDigitsHover"))+s:"-",i=this._isMetric?r>ol.control.Profile.prototype.KILOMETER_VALUE?ol.control.Profile.prototype.Unit.Kilometer:ol.control.Profile.prototype.Unit.Meter:r>ol.control.Profile.prototype.MILE_VALUE?ol.control.Profile.prototype.Unit.Mile:ol.control.Profile.prototype.Unit.Foot;var r=this._unitsConversion(e[0],i);this.element.querySelector(".point-info .dist").textContent="number"==typeof r?this._numberFormat(r,this.get("xDigitsHover"))+i:"-",this.element.querySelector(".point-info .time").textContent=e[2],t>this.canvas_.width/this.ratio/2?this.popup_.classList.add("ol-left"):this.popup_.classList.remove("ol-left")}else this.cursor_.style.display="none",this.bar_.style.display="none",this.cursor_.style.display="none",this.bar_.parentElement.classList.remove("over")}showAt(e){var t,i,s,o=1/0;if(void 0===e)this.bar_.parentElement.classList.contains("over")&&this._drawAt();else if(e.length)for(t=1;i=this.tab_[t];t++){var r=ol.coordinate.dist2d(i[3],e);r<o&&(s=i,o=r)}else for(t=0;(i=this.tab_[t])&&(s=i,!(i[0]>=e));t++);if(s){var a=(s[0]*this.scale_[0]+this.margin_.left)/this.ratio;return this._drawAt(s,a),s[3]}return null}showAtTime(e,t){var i,s,o;if(e instanceof Date?e=e.getTime()/1e3:t&&(e+=this.tab_[0][3][3]),void 0===e)this.bar_.parentElement.classList.contains("over")&&this._drawAt();else for(i=0;(s=this.tab_[i])&&(o=s,!(s[3][3]>=e));i++);if(o){var r=(o[0]*this.scale_[0]+this.margin_.left)/this.ratio;return this._drawAt(o,r),o[3]}return null}pointAtTime(e){var t,i;for(t=1;i=this.tab_[t];t++){var s=i[3][3];if(s>=e){var o=this.tab_[t-1][3];return(o[3]+s)/2<e?o:i}}return this.tab_[this.tab_.length-1][3]}onMove(e){if(this.tab_.length){var t=this.canvas_.getBoundingClientRect(),i=t.top+window.pageYOffset-document.documentElement.clientTop,s=t.left+window.pageXOffset-document.documentElement.clientLeft,o=e.pageX||e.touches&&e.touches.length&&e.touches[0].pageX||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageX,r=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY,a=o-s,n=r-i,l=this.ratio;if(a>this.margin_.left/l-20&&a<(this.canvas_.width-this.margin_.right)/l+8&&n>this.margin_.top/l&&n<(this.canvas_.height-this.margin_.bottom)/l){var h,c,u=(a*l-this.margin_.left)/this.scale_[0],d=this.tab_[0];for(h=1;c=this.tab_[h];h++)if(c[0]>=u){u<(c[0]+d[0])/2&&(h=0,c=d);break}if(c||(c=this.tab_[this.tab_.length-1]),a=Math.max(this.margin_.left/l,Math.min(a,(this.canvas_.width-this.margin_.right)/l)),void 0===c[1])return;switch(this._drawAt(c,a),this.dispatchEvent({type:"over",click:"click"===e.type,index:h,coord:c[3],time:c[2],distance:c[0]}),e.type){case"pointerdown":this._dragging={event:{type:"dragstart",index:h,coord:c[3],time:c[2],distance:c[0]},pageX:o,pageY:r};break;case"pointerup":this._dragging&&this._dragging.pageX?Math.abs(this._dragging.pageX-o)<3&&Math.abs(this._dragging.pageY-r)<3&&(this.dispatchEvent({type:"click",index:h,coord:c[3],time:c[2],distance:c[0]}),this.refresh()):this.dispatchEvent({type:"dragend",index:h,coord:c[3],time:c[2],distance:c[0]}),this._dragging=!1;break;default:if(this._dragging)if(this._dragging.pageX)(Math.abs(this._dragging.pageX-o)>3||Math.abs(this._dragging.pageY-r)>3)&&(this._dragging.pageX=this._dragging.pageY=!1,this.dispatchEvent(this._dragging.event));else{this.dispatchEvent({type:"dragging",index:h,coord:c[3],time:c[2],distance:c[0]});var p=Math.min(this._dragging.event.index,h),g=Math.max(this._dragging.event.index,h);this.refresh(),this.get("selectable")&&this._drawGraph(this.tab_.slice(p,g),this._selectStyle)}}}else this.bar_.parentElement.classList.contains("over")&&(this._drawAt(),this.dispatchEvent({type:"out"})),"pointerup"===e.type&&this._dragging&&(this.dispatchEvent({type:"dragcancel"}),this._dragging=!1)}}show(){this.element.classList.remove("ol-collapsed"),this._addListeners(),this.dispatchEvent({type:"show",show:!0})}hide(){this.element.classList.add("ol-collapsed"),this._removeListeners(),this.dispatchEvent({type:"show",show:!1})}toggle(){this.isShown()?this.hide():this.show()}isShown(){return!this.element.classList.contains("ol-collapsed")}getSelection(e,t){for(var i=[],s=Math.max(Math.min(e,t),0),o=Math.min(Math.max(e,t),this.tab_.length-1),r=s;r<=o;r++)i.push(this.tab_[r][3]);return i}_drawGraph(e,t){if(e.length){var i,s,o,r,a=this.canvas_.getContext("2d"),n=this.scale_[0],l=this.scale_[1],h=this.dy_,c=this.ratio,u=!1;for(a.beginPath(),i=0;s=e[i];i++)0==i?a.moveTo(s[0]*n,s[1]*l+h):s[1]?(u=!0,o||(o=s[0]),r=s[0],a.lineTo(s[0]*n,s[1]*l+h)):(u&&(d(o,r),u=!1,o=null,r=null),e[i+1]&&(a.beginPath(),a.moveTo(e[i+1][0]*n,e[i+1][1]*l+h)));u&&d(o,r)}function d(e,i){if(t.getStroke()){var s=t.getStroke().getColor();a.strokeStyle=s?ol.color.asString(s):"#000",a.lineWidth=t.getStroke().getWidth()*c,a.setLineDash([]),a.stroke()}if(t.getFill()){var o=t.getFill().getColor();a.fillStyle=o?ol.color.asString(o):"#000",a.Style=o?ol.color.asString(o):"#000",a.lineTo(i*n,0),a.lineTo(e*n,0),a.fill()}}}setGeometry(e,t){if(t||(t={}),e instanceof ol.Feature&&(e=e.getGeometry()),this._geometry=[e,t],/Z/.test(e.getLayout())){/M/.test(e.getLayout())?this.element.querySelector(".time").parentElement.style.display="block":this.element.querySelector(".time").parentElement.style.display="none";var i=e.getCoordinates();switch(e.getType()){case"LineString":break;case"MultiLineString":i=i[0];break;default:return}var s,o,r,a,n,l,h,c=t.projection||this.getMap().getView().getProjection(),u=1/0,d=-1/0,p=this.tab_=[];for(s=0;o=i[s];s++)(a=o[2])<u&&(u=a),a>d&&(d=a),0==s?r=0:r+=(l=i[s-1],h=o,ol.sphere.getDistance(ol.proj.transform(l,c,"EPSG:4326"),ol.proj.transform(h,c,"EPSG:4326"))),n=g(i[0][3],o[3]),p.push([r,a,n,o]);this._z=[u,d],this.setProperties({graduation:t.graduation||100,zmin:t.zmin,zmax:t.zmax,amplitude:t.amplitude,unit:t.unit,zunit:t.zunit,zDigits:"number"==typeof t.zDigits?t.zDigits:0,xDigits:"number"==typeof t.xDigits?t.xDigits:1,zDigitsHover:"number"==typeof t.zDigitsHover?t.zDigitsHover:2,xDigitsHover:"number"==typeof t.xDigitsHover?t.xDigitsHover:1,zMaxChars:t.zMaxChars,xSteps:t.xSteps,zSteps:t.zSteps}),this.dispatchEvent({type:"change:geometry",geometry:e}),this.refresh()}function g(e,t){if(!e||!t)return"-";var i=(t-e)/60,s=Math.trunc(i/60),o=Math.trunc(i-60*s);return s+"h"+(o<10?"0":"")+o+"mn"}}refresh(){var e=this.canvas_,t=e.getContext("2d"),i=e.width,s=e.height;t.setTransform(1,0,0,1,0,0),t.clearRect(0,0,i,s);var o,r=this._z[0],a=this._z[1],n=this.tab_,l=n[n.length-1][0],h=n[n.length-1][2];if(l){t.setTransform(1,0,0,1,this.margin_.left,s-this.margin_.bottom);var c=this.ratio;i-=this.margin_.right+this.margin_.left,s-=this.margin_.top+this.margin_.bottom;var u=this._style.getText().getFill().getColor();t.strokeStyle=u?ol.color.asString(u):"#000",t.lineWidth=.5*c,t.beginPath(),t.moveTo(0,0),t.lineTo(0,-s),t.moveTo(0,0),t.lineTo(i,0),t.stroke(),this.element.querySelector(".track-info .zmin").textContent=r.toFixed(2)+this.info.altitudeUnits,this.element.querySelector(".track-info .zmax").textContent=a.toFixed(2)+this.info.altitudeUnits;var d=this._isMetric?ol.control.Profile.prototype.Unit.Meter:ol.control.Profile.prototype.Unit.Foot,p=this._unitsConversion(r,d);this.element.querySelector(".track-info .zmin").textContent=this._numberFormat(p,this.get("zDigitsHover"))+d;var g,m=this._isMetric?ol.control.Profile.prototype.Unit.Meter:ol.control.Profile.prototype.Unit.Foot,f=this._unitsConversion(a,m);this.element.querySelector(".track-info .zmax").textContent=this._numberFormat(f,this.get("zDigitsHover"))+m,g=this._isMetric?l>1e3?ol.control.Profile.prototype.Unit.Kilometer:ol.control.Profile.prototype.Unit.Meter:l>ol.control.Profile.prototype.MILE_VALUE?ol.control.Profile.prototype.Unit.Mile:ol.control.Profile.prototype.Unit.Foot;var v=this._unitsConversion(l,g);this.element.querySelector(".track-info .dist").textContent=this._numberFormat(v,this.get("xDigitsHover"))+g,this.element.querySelector(".track-info .time").textContent=h;var y,_=this.get("zSteps");if(_)a=Math.ceil(a),r=Math.floor(10*r)/10,y=(this.get("amplitude")||a-r)/(_-1);else for(y=this.get("graduation");;){if(!(s/(((a=Math.ceil(a/y)*y)-(r=Math.floor(r/y)*y))/y)<15*c))break;y*=2}"number"==typeof this.get("zmin")&&r>this.get("zmin")&&(r=this.get("zmin")),"number"==typeof this.get("zmax")&&a<this.get("zmax")&&(a=this.get("zmax"));var x=this.get("amplitude");x&&(a=Math.max(r+x,a));var b=i/l,w=-s/(a-r),S=this.dy_=-r*w;this.scale_=[b,w],this._drawGraph(n,this._style),t.textAlign="right",t.textBaseline="top";var M=this._style.getText().getFill().getColor();t.fillStyle=M?ol.color.asString(M):"#000",t.beginPath();var C=this.get("zDigits"),E=this.get("zunit")||this._isMetric?ol.control.Profile.prototype.Unit.Meter:ol.control.Profile.prototype.Unit.Foot,L=null;if("number"==typeof this.get("zMaxChars")){var T,P=this._unitsConversion(r,E),k=this._unitsConversion(a,E);if(T=Math.max(P.toFixed(1).length,k.toFixed(1).length),this.get("zMaxChars")<T){L=Math.floor(Math.log10(Math.max(Math.abs(r),Math.abs(a),Number.MIN_VALUE))),t.font="bold "+9*c+"px arial",t.fillText(L.toString(),-8*c,8*c);var A=t.measureText(L.toString()),F=A.width,I=A.actualBoundingBoxAscent+A.actualBoundingBoxDescent;t.font="bold "+12*c+"px arial",t.fillText("10",-8*c-F,8*c+.5*I)}}for(t.font=10*c+"px arial",t.textBaseline="middle",o=r;o<=a;o+=y){var N=this._unitsConversion(o,E);if(null!==L){var D=N/Math.pow(10,L),O=this.get("zMaxChars")-Math.floor(Math.log10(Math.max(Math.abs(D),1))+1)-1;D<0&&(O-=1),t.fillText(D.toFixed(Math.max(O,0)),-4*c,o*w+S)}else{if("number"==typeof C)N=this._numberFormat(N,C);else{N=this._unitsConversion(a,E)-this._unitsConversion(r,E)>10?this._numberFormat(N,0):this._numberFormat(N,2)}t.fillText(N,-4*c,o*w+S)}t.moveTo(-2*c,o*w+S),0!=o?t.lineTo(l*b,o*w+S):t.lineTo(0,o*w+S)}t.textAlign="center",t.textBaseline="top",t.setLineDash([c,3*c]);var R,G=this.get("unit")||(this._isMetric?ol.control.Profile.prototype.Unit.Kilometer:ol.control.Profile.prototype.Unit.Mile),V=this.get("xSteps"),B=this.get("xDigits"),z=G===ol.control.Profile.prototype.Unit.Mile?ol.control.Profile.prototype.MILE_VALUE:1e3;for(l<z&&(G=this._isMetric?ol.control.Profile.prototype.Unit.Meter:ol.control.Profile.prototype.Unit.Foot),"number"==typeof V?R=l/(V-1):l>z?(R=100*Math.round(l/1e3))>1e3&&(R=1e3*Math.ceil(R/1e3)):R=l>100?10*Math.round(l/100):l>10?Math.round(l/10):l>1?Math.round(l)/10:l,o=0;o<=l;o+=R){var j=Number(this._unitsConversion(o,G).toFixed(B)),H=this._numberFormat(j,B);t.fillText(H,o*b,4*c),t.moveTo(o*b,3*c),t.lineTo(o*b,0)}t.font=12*c+"px arial";var U=-1!==this.info.xtitle.search("(km)")?this.info.xtitle.replace("(km)","("+G+")"):this.info.xtitle+" ("+G+")";t.fillText(U,i/2,18*c),t.save(),t.rotate(-Math.PI/2);var q=-1!==this.info.xtitle.search("(m)")?this.info.ytitle.replace("(m)","("+E+")"):this.info.ytitle+" ("+E+")";t.fillText(q,s/2,-this.margin_.left),t.restore(),t.stroke()}else console.error("[ol/control/Profile] no data...",n)}getImage(e,t){return"canvas"===e?this.canvas_:this.canvas_.toDataURL(e,t)}_unitsConversion(e,t){switch(t=t||ol.control.Profile.prototype.Unit.Meter){case ol.control.Profile.prototype.Unit.Kilometer:return e/ol.control.Profile.prototype.KILOMETER_VALUE;case ol.control.Profile.prototype.Unit.Foot:return e/ol.control.Profile.prototype.FOOT_VALUE;case ol.control.Profile.prototype.Unit.Mile:return e/ol.control.Profile.prototype.MILE_VALUE;case ol.control.Profile.prototype.Unit.Meter:default:return e}}_numberFormat(e,t=2){var i=this.get("numberFormat");return i?Number(e).toLocaleString(i,{minimumFractionDigits:0,maximumFractionDigits:t}):Number(e).toFixed(t)}},ol.control.Profile.prototype.info={zmin:"Zmin",zmax:"Zmax",ytitle:"Altitude",xtitle:"Distance",time:"Time",altitude:"Altitude",distance:"Distance"},ol.control.Profile.prototype.Unit={Meter:"m",Kilometer:"km",Foot:"ft",Mile:"mi"},ol.control.Profile.prototype.FOOT_VALUE=.3048,ol.control.Profile.prototype.MILE_VALUE=1609.344,ol.control.Profile.prototype.KILOMETER_VALUE=1e3,ol.control.Profil=ol.control.Profile,ol.control.ProgressBar=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:((e.className||"")+" ol-progress-bar ol-unselectable ol-control").trim()});super({element:t,target:e.target}),this._waiting=ol.ext.element.create("DIV",{html:e.label||"",className:"ol-waiting",parent:t}),this._bar=ol.ext.element.create("DIV",{className:"ol-bar",parent:t}),this._layerlistener=[],this.setLayers(e.layers)}setPercent(e){this._bar.style.width=100*(Number(e)||0)+"%",void 0===e?ol.ext.element.hide(this.element):ol.ext.element.show(this.element)}setLabel(e){this._waiting.innerHTML=e}setLayers(e){this._layerlistener.forEach(function(e){ol.Observable.unByKey(e)}),this._layerlistener=[],this.setPercent();var t,i=0,s=0;(e instanceof ol.layer.Layer&&(e=[e]),e&&e.forEach)&&e.forEach(function(e){e instanceof ol.layer.Layer&&(this._layerlistener.push(e.getSource().on("tileloadstart",function(){i++,this.setPercent(s/i),clearTimeout(t)}.bind(this))),this._layerlistener.push(e.getSource().on(["tileloadend","tileloaderror"],function(){++s===i?(i=s=0,this.setPercent(1),t=setTimeout(this.setPercent.bind(this),300)):this.setPercent(s/i)}.bind(this))))}.bind(this))}},ol.control.RoutingGeoportail=class extends ol.control.Control{constructor(e){null==(e=e||{}).typing&&(e.typing=300),e.apiKey=e.apiKey||"itineraire",e.search||(e.search={}),e.search.apiKey=e.search.apiKey||"essentiels";var t=document.createElement("DIV");super({element:t,target:e.target});var i=this;this._classname=e.className||"search",this._source=new ol.source.Vector,this.set("lang",e.lang||"en"),this._auth=e.authentication;var s=(e.className||"")+" ol-routing";(e.target||(s+=" ol-unselectable ol-control"),t.setAttribute("class",s),e.target)||ol.ext.element.create("BUTTON",{parent:t}).addEventListener("click",function(){t.classList.toggle("ol-collapsed")});this.set("url","https://data.geopf.fr/navigation/itineraire");var o=ol.ext.element.create("DIV",{className:"content",parent:t}),r=ol.ext.element.create("DIV",{className:"search-input",parent:o});this._search=[],this.addSearch(r,e),this.addSearch(r,e),ol.ext.element.createSwitch({className:"ol-method",html:"fastest",after:"shortest",parent:o}).addEventListener("change",function(e){i.setMethod(e.target.checked?"shortest":"fastest")});var a=ol.ext.element.create("DIV",{className:"ol-constraints",parent:o}),n=e.constraints||{autoroute:"péages",tunnel:"tunnels",pont:"ponts"};Object.keys(n).forEach(function(e){ol.ext.element.createCheck({after:n[e],value:e,checked:!0,parent:a}).addEventListener("change",function(t){i.setConstraint(e,!t.target.checked)})}),ol.ext.element.create("I",{className:"ol-car",title:e.carlabel||"by car",parent:o}).addEventListener("click",function(){i.setMode("car")}),ol.ext.element.create("I",{className:"ol-pedestrian",title:e.pedlabel||"pedestrian",parent:o}).addEventListener("click",function(){i.setMode("pedestrian")}),ol.ext.element.create("I",{className:"ol-ok",title:e.runlabel||"search",html:"OK",parent:o}).addEventListener("click",function(){i.calculate()}),ol.ext.element.create("I",{className:"ol-cancel",html:"cancel",parent:o}).addEventListener("click",function(){this.resultElement.innerHTML=""}.bind(this)),this.resultElement=document.createElement("DIV"),this.resultElement.setAttribute("class","ol-result"),t.appendChild(this.resultElement),this.setMode(e.mode||"car"),this.set("timeout",e.timeout||2e4)}setMode(e,t){this.set("mode",e),this.element.querySelector(".ol-car").classList.remove("selected"),this.element.querySelector(".ol-pedestrian").classList.remove("selected"),this.element.querySelector(".ol-"+e).classList.add("selected"),t||this.calculate()}setMethod(e,t){this.set("method",e),t||this.calculate()}setConstraint(e,t){var i=this.get("constraint")||[];i[e]=t,this.set("constraint",i)}addButton(e,t,i){var s=document.createElement("I");return s.setAttribute("class",e),s.setAttribute("type","button"),s.setAttribute("title",t),s.innerHTML=i||"",this.element.appendChild(s),s}getSource(){return this._source}_resetArray(e){this._search=[];var t=e.parentNode.querySelectorAll(".search-input > div");t.forEach(function(e){e.olsearch&&(e.olsearch.get("feature")&&(e.olsearch.get("feature").set("step",this._search.length),0===this._search.length?e.olsearch.get("feature").set("pos","start"):this._search.length===t.length-1?e.olsearch.get("feature").set("pos","end"):e.olsearch.get("feature").set("pos","")),this._search.push(e.olsearch))}.bind(this))}removeSearch(e,t,i){e.removeChild(i),i.olsearch.get("feature")&&this._source.removeFeature(i.olsearch.get("feature")),this.getMap()&&this.getMap().removeControl(i.olsearch),this._resetArray(e)}addSearch(e,t,i){var s=this,o=ol.ext.element.create("DIV");i?e.insertBefore(o,i.nextSibling):e.appendChild(o),ol.ext.element.create("BUTTON",{title:t.startlabel||"use shift to add / ctrl to remove",parent:o}).addEventListener("click",function(i){i.ctrlKey?this._search.length>2&&this.removeSearch(e,t,o):i.shiftKey&&this.addSearch(e,t,o)}.bind(this));var r=o.olsearch=new ol.control.SearchGeoportail({className:"IGNF ol-collapsed",apiKey:t.search.apiKey,authentication:t.search.authentication,target:o,reverse:!0});r._changeCounter=0,this._resetArray(e),r.on("select",function(e){r.setInput(e.search.fulltext);var t=r.get("feature");t?(r.checkgeom=!1,e.silent||t.getGeometry().setCoordinates(e.coordinate),r.checkgeom=!0):(t=new ol.Feature(new ol.geom.Point(e.coordinate)),r.set("feature",t),this._source.addFeature(t),r.checkgeom=!0,t.getGeometry().on("change",function(){r.checkgeom&&this.onGeometryChange(r,t)}.bind(this))),t.set("name",r.getTitle(e.search)),t.set("step",this._search.indexOf(r)),0===t.get("step")?t.set("pos","start"):t.get("step")===this._search.length-1&&t.set("pos","end"),r.set("selection",e.search)}.bind(this)),r.element.querySelector("input").addEventListener("change",function(){r.set("selection",null),s.resultElement.innerHTML=""}),this.getMap()&&this.getMap().addControl(r)}onGeometryChange(e,t,i){var s=ol.proj.transform(t.getGeometry().getCoordinates(),this.getMap().getView().getProjection(),"EPSG:4326");if(e._handleSelect({x:s[0],y:s[1],fulltext:s[0].toFixed(6)+","+s[1].toFixed(6)},!0,{silent:!0}),i){if(e._changeCounter--,!e._changeCounter)return void e.reverseGeocode(t.getGeometry().getCoordinates(),{silent:!0})}else e._changeCounter++,setTimeout(function(){this.onGeometryChange(e,t,!0)}.bind(this),1e3)}setMap(e){super.setMap(e);for(var t=0;t<this._search.length;t++){this._search[t].setMap(e)}}requestData(e){for(var t=e[0],i=e[e.length-1],s="",o=1;o<e.length-1;o++)s+=(s?"|":"")+e[o].x+","+e[o].y;var r=[];return Object.keys(this.get("constraint")||{}).forEach(function(e){r.push("{%22constraintType%22:%22banned%22,%22key%22:%22wayType%22,%22operator%22:%22=%22,%22value%22:%22"+e+"%22}")}),{resource:"bdtopo-osrm",profile:"pedestrian"===this.get("mode")?"pedestrian":"car",optimization:"pedestrian"===this.get("mode")?"":this.get("method")||"fastest",start:t.x+","+t.y,end:i.x+","+i.y,intermediates:s,constraints:r.join("|"),distanceUnit:"meter",timeUnit:"minute",geometryFormat:"geojson"}}getTimeString(e){return(e/=60)<1?"":e<60?e.toFixed(0)+" min":(e/60).toFixed(0)+" h "+(e%60).toFixed(0)+" min"}getDistanceString(e){return e<1e3?e.toFixed(0)+" m":(e/1e3).toFixed(2)+" km"}listRouting(e){this.resultElement.innerHTML="";var t=this.getTimeString(e.duration);t+=" ("+this.getDistanceString(e.distance)+")";var i=document.createElement("i");i.textContent=t,this.resultElement.appendChild(i);var s=document.createElement("ul");this.resultElement.appendChild(s);var o=ol.control.RoutingGeoportail.prototype.instructions[this.get("lang")||"en"],r={straight:"",left:"L",right:"R","slight left":"FL","slight right":"FR"};e.features.forEach(function(e,i){var a=this.getDistanceString(e.get("distance"));t=this.getTimeString(e.get("durationT"));var n=o[e.get("instruction_type")]||o.none;n+=" "+(o[e.get("instruction_modifier")]||o.straight)+" ",ol.ext.element.create("LI",{className:r[e.get("instruction_modifier")]||"",html:(n||"#")+" "+e.get("name")+"<i>"+a+(t?" - "+t:"")+"</i>",on:{pointerenter:function(){this.dispatchEvent({type:"step:hover",hover:!1,index:i,feature:e})}.bind(this),pointerleave:function(){this.dispatchEvent({type:"step:hover",hover:!1,index:i,feature:e})}.bind(this)},click:function(){this.dispatchEvent({type:"step:select",index:i,feature:e})}.bind(this),parent:s})}.bind(this))}handleResponse(e,t,i){if("ERROR"!==e.status){for(var s,o,r,a={type:"routing",features:[]},n=0,l=0,h=new ol.format.GeoJSON,c=0;r=e.portions[c];c++)for(var u,d=0;u=r.steps[d];d++){u.type="Feature",u.properties=u.attributes.name||u.attributes,u.properties.distance=u.distance,u.properties.duration=Math.round(60*u.duration),u.instruction&&(u.properties.instruction_type=u.instruction.type,u.properties.instruction_modifier=u.instruction.modifier),n+=u.distance,l+=u.duration,u.properties.distanceT=Math.round(100*n)/100,u.properties.durationT=Math.round(60*l),u.properties.name=u.properties.cpx_toponyme_route_nommee||u.properties.cpx_toponyme||u.properties.cpx_numero||u.properties.nom_1_droite||u.properties.nom_1_gauche||"";var p=u.geometry.coordinates[u.geometry.coordinates.length-1];o&&!ol.coordinate.equal(p,u.geometry.coordinates[u.geometry.coordinates.length-1])&&u.geometry.coordinates.unshift(o),o=u.geometry.coordinates[u.geometry.coordinates.length-1],s=h.readFeature(u,{featureProjection:this.getMap().getView().getProjection()}),a.features.push(s)}a.distance=parseFloat(e.distance),a.duration=parseFloat(e.duration)/60;var g=h.readGeometry(e.geometry,{featureProjection:this.getMap().getView().getProjection()});return a.feature=new ol.Feature({geometry:g,start:this._search[0].getTitle(t),end:this._search[0].getTitle(i),distance:a.distance,duration:a.duration}),this.dispatchEvent(a),this.path=a,a}this.dispatchEvent({type:"errror",status:"200",statusText:e.message})}abort(){this._request&&(this._request.abort(),this._request=null,this.dispatchEvent({type:"abort"}))}calculate(e){if(this.resultElement.innerHTML="",e){var t=[];e.forEach(function(e){t.push({x:e[0],y:e[1]})}),e=t}else{e=[];for(var i=0;i<this._search.length;i++)this._search[i].get("selection")&&e.push(this._search[i].get("selection"))}if(e.length<2)return!1;var s=e[0],o=e[e.length-1],r=this.requestData(e),a=encodeURI(this.get("url")),n="";for(var l in r)n+=n?"&":"?",r.hasOwnProperty(l)&&(n+=l+"="+r[l]);var h=this;return this.dispatchEvent({type:"routing:start"}),this.ajax(a+n,function(e){e.status>=200&&e.status<400?h.listRouting(h.handleResponse(JSON.parse(e.response),s,o)):this.dispatchEvent({type:"error",status:e.status,statusText:e.statusText})}.bind(this),function(e){this.dispatchEvent({type:"error",status:e.status,statusText:e.statusText})}.bind(this)),!0}ajax(e,t,i){var s=this;this._request&&this._request.abort();var o=this._request=new XMLHttpRequest;o.open("GET",e,!0),o.timeout=this.get("timeout")||2e4,this._auth&&o.setRequestHeader("Authorization","Basic "+this._auth),this.element.classList.add("ol-searching"),o.onload=function(){s._request=null,s.element.classList.remove("ol-searching"),t.call(s,this)},o.ontimeout=function(){s._request=null,s.element.classList.remove("ol-searching"),i&&i.call(s,this)},o.onerror=function(){s._request=null,s.element.classList.remove("ol-searching"),i&&i.call(s,this)},o.send()}},ol.control.RoutingGeoportail.prototype.instructions={en:{none:"Go ",continue:"Continue ","new name":"Continue ",depart:"Start",arrive:"Arrival",turn:"Turn",fork:"Fork",straight:"on",left:"left on",right:"right on","slight left":"slight left on","slight right":"slight right on"},fr:{none:"Continuer ",continue:"Continuer ","new name":"Continuer ",depart:"Départ",arrive:"Arrivée",turn:"Tourner",fork:"Prendre",straight:"sur",left:"à gauche sur",right:"à droite sur","slight left":"légèrement à gauche sur","slight right":"légèrement à droite sur"}},ol.control.Scale=class extends ol.control.Control{constructor(e){void 0===(e=e||{}).typing&&(e.typing=300);var t=document.createElement("DIV"),i=(e.className||"")+" ol-scale";e.target||(i+=" ol-unselectable ol-control"),super({element:t,target:e.target}),this._input=document.createElement("INPUT"),this._input.value="-",t.setAttribute("class",i),!1===e.editable&&(this._input.readOnly=!0),t.appendChild(this._input),this._input.addEventListener("change",this.setScale.bind(this)),this.set("ppi",e.ppi||96)}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),e&&(this._listener=e.on("moveend",this.getScale.bind(this)))}getScale(){var e=this.getMap();if(e){var t=ol.sphere.getMapScale(e,this.get("ppi"));return this._input.value=this.formatScale(t),t}}formatScale(e){return"1 / "+(e=e>100?100*Math.round(e/100):Math.round(e)).toLocaleString()}setScale(e){var t=this.getMap();t&&e&&(e.target&&(e=e.target.value),ol.sphere.setMapScale(t,e,this.get("ppi"))),this.getScale()}},ol.control.SearchBAN=class extends ol.control.SearchPhoton{constructor(e){(e=e||{}).typing=e.typing||500,e.url=e.url||"https://api-adresse.data.gouv.fr/search/",e.className=e.className||"BAN",e.copy='<a href="https://adresse.data.gouv.fr/" target="new">&copy; BAN-data.gouv.fr</a>',super(e),this.set("postcode",e.postcode),this.set("citycode",e.citycode),this.set("type",e.type)}getTitle(e){return e.properties.label}select(e){var t=e.geometry.coordinates;try{t=ol.proj.transform(e.geometry.coordinates,"EPSG:4326",this.getMap().getView().getProjection())}catch(e){}this.dispatchEvent({type:"select",search:e,coordinate:t})}requestData(e){var t=super.requestData(e);return t.postcode=this.get("postcode"),t.citycode=this.get("citycode"),t.type=this.get("type"),t}},ol.control.SearchCoordinates=class extends ol.control.Search{constructor(e){(e=e||{}).className=(e.className||"")+" ol-searchcoord",e.placeholder=e.placeholder||"x,y",super(e),this.projection_=e.projection||"EPSG:3857",this.set("digit","number"==typeof e.digit?e.digit:3),this.geolocation=new ol.Geolocation({projection:"EPSG:4326",trackingOptions:{maximumAge:1e4,enableHighAccuracy:!0,timeout:6e5}}),ol.ext.element.create("BUTTON",{className:"ol-geoloc",title:e.labelGPS||"Locate with GPS",parent:this.element,click:function(){this.geolocation.setTracking(!0)}.bind(this)}),ol.ext.element.create("BUTTON",{className:"ol-centerloc",title:e.labelCenter||"Map center",parent:this.element,click:function(){this.setInput()}.bind(this)}),this._createForm();var t=this.element.querySelector("ul.autocomplete");this.element.appendChild(t)}setInput(e){if(!e){if(!this.getMap())return;e=this.getMap().getView().getCenter(),e=ol.proj.transform(e,this.getMap().getView().getProjection(),this.getProjection())}var t=Math.pow(10,this.get("digit"));this.inputs_[0].value=Math.round(e[0]*t)/t,this.inputs_[1].value=Math.round(e[1]*t)/t,this._triggerCustomEvent("keyup",this.inputs_[0])}getProjection(){return this.projection_}setProjection(e){this.projection_!==e&&(this.projection_=e,this.clearHistory(),this.element.querySelectorAll('INPUT[type="number"]').forEach(function(e){e.value=""}))}_createForm(){var e=function(){s.value||o.value?this._input.value=s.value+","+o.value:this._input.value="",this.search()}.bind(this);function t(t){return ol.ext.element.create("INPUT",{className:t,type:"number",step:"any",lang:"en",parent:i,on:{"change keyup":e}})}var i=ol.ext.element.create("DIV",{className:"ol-longitude",parent:this.element});ol.ext.element.create("LABEL",{html:"X",parent:i});var s=t("ol-decimal");i=ol.ext.element.create("DIV",{className:"ol-latitude",parent:this.element}),ol.ext.element.create("LABEL",{html:"Y",parent:i});var o=t("ol-decimal");this.button&&this.button.addEventListener("click",function(){s.focus()}),this.inputs_=[s,o],this.on("select",function(e){s.value=e.search.gps[0],o.value=e.search.gps[1]}.bind(this)),this.geolocation.on("change",function(){this.geolocation.setTracking(!1);var e=this.geolocation.getPosition();e=ol.proj.transform(e,"EPSG:4326",this.projection_);var t=Math.pow(10,this.get("digit"));s.value=Math.round(e[0]*t)/t,o.value=Math.round(e[1]*t)/t,this._triggerCustomEvent("keyup",s)}.bind(this))}autocomplete(e){var t=[],i=e.split(",");i[0]=Number(i[0]),i[1]=Number(i[1]);var s=ol.proj.transform([i[0],i[1]],this.projection_,this.getMap().getView().getProjection());return t.push({gps:i,coordinate:s,name:e}),t}},ol.control.SearchDFCI=class extends ol.control.Search{constructor(e){(e=e||{}).className=e.className||"dfci",e.placeholder=e.placeholder||"Code DFCI",super(e)}autocomplete(e){if((e=(e=e.toUpperCase()).replace(/[^0-9,^A-H,^K-N]/g,"")).length<2)return this.setInput(e),[];var t,i=this.getMap().getView().getProjection(),s=[],o=ol.coordinate.fromDFCI(e,i),r=Math.floor(e.length/2)-1,a=ol.coordinate.toDFCI(o,r,i);if(a=a.replace(/[^0-9,^A-H,^K-N]/g,""),!/NaN/.test(a)&&a){if(console.log("ok",a),this.setInput(a+e.substring(a.length,e.length)),s.push({coordinate:ol.coordinate.fromDFCI(a,i),name:a}),5===e.length)for(o=ol.coordinate.fromDFCI(e+0,i),a=ol.coordinate.toDFCI(o,r+1,i).substring(0,5),t=0;t<10;t++)s.push({coordinate:ol.coordinate.fromDFCI(a+t,i),name:a+t});if(2===r)for(t=0;t<6;t++)s.push({coordinate:ol.coordinate.fromDFCI(a+"."+t,i),name:a+"."+t})}return s}},ol.control.SearchFeature=class extends ol.control.Search{constructor(e){(e=e||{}).className=e.className||"feature",super(e),"function"==typeof e.getSearchString&&(this.getSearchString=e.getSearchString),this.set("property",e.property||"name"),this.source_=e.source,this._sort=e.sort}restoreHistory(){this.set("history",[])}saveHistory(){try{localStorage.removeItem("ol@search-"+this._classname)}catch(e){console.warn("Failed to access localStorage...")}}getTitle(e){return e.get(this.get("property")||"name")}getSearchString(e){return this.getTitle(e)}getSource(){return this.source_}setSource(e){this.source_=e}setSortFunction(e){this._sort=e}autocomplete(e){var t=[];if(this.source_){e=e.replace(/^\*/,"");for(var i,s=new RegExp(e,"i"),o=this.source_.getFeatures(),r=this.get("maxItems"),a=0;i=o[a];a++){var n=this.getSearchString(i);if(void 0!==n&&s.test(n)&&(t.push(i),--r<=0))break}}return"function"==typeof this._sort&&(t=t.sort(this._sort)),t}},ol.control.SearchGPS=class extends ol.control.Search{constructor(e){(e=e||{}).className=(e.className||"")+" ol-searchgps",e.placeholder=e.placeholder||"lon,lat",super(e),this.geolocation=new ol.Geolocation({projection:"EPSG:4326",trackingOptions:{maximumAge:1e4,enableHighAccuracy:!0,timeout:6e5}}),ol.ext.element.create("BUTTON",{className:"ol-geoloc",title:e.labelGPS||"Locate with GPS",parent:this.element,click:function(){this.geolocation.setTracking(!0)}.bind(this)}),ol.ext.element.createSwitch({html:"decimal",after:"DMS",change:function(e){e.target.checked?this.element.classList.add("ol-dms"):this.element.classList.remove("ol-dms")}.bind(this),parent:this.element}),this._createForm();var t=this.element.querySelector("ul.autocomplete");this.element.appendChild(t)}setInput(e){if(!e){if(!this.getMap())return;e=this.getMap().getView().getCenter(),e=ol.proj.transform(e,this.getMap().getView().getProjection(),"EPSG:4326")}this.inputs_[0].value=e[0],this.inputs_[1].value=e[1],this._triggerCustomEvent("keyup",this.inputs_[0])}_createForm(){var e=function(e){if(e.target.classList.contains("ol-dms")&&(s.value=(o.value<0?-1:1)*Number(o.value)+Number(r.value)/60+Number(a.value)/3600,s.value=(o.value<0?-1:1)*Math.round(1e7*s.value)/1e7,n.value=(l.value<0?-1:1)*Number(l.value)+Number(h.value)/60+Number(c.value)/3600,n.value=(l.value<0?-1:1)*Math.round(1e7*n.value)/1e7),s.value||n.value?this._input.value=s.value+","+n.value:this._input.value="",!e.target.classList.contains("ol-dms")){var t=ol.coordinate.toStringHDMS([Number(s.value)||0,Number(n.value)||0]),i=t.replace(/(N|S)/g,"-").replace(/(E|W)/g,"").split("-");try{i[1]=i[1].trim().split(" "),o.value=(/W/.test(t)?-1:1)*parseInt(i[1][0]),r.value=parseInt(i[1][1]||0),a.value=parseInt(i[1][2]||0),i[0]=i[0].trim().split(" "),l.value=(/S/.test(t)?-1:1)*parseInt(i[0][0]),h.value=parseInt(i[0][1]||0),c.value=parseInt(i[0][2]||0)}catch(e){}}this.search()}.bind(this);function t(t,s){var o=ol.ext.element.create("INPUT",{className:t,type:"number",step:"any",lang:"en",parent:i,on:{"change keyup":e}});return s&&ol.ext.element.create("SPAN",{className:"ol-dms",html:s,parent:i}),o}var i=ol.ext.element.create("DIV",{className:"ol-longitude",parent:this.element});ol.ext.element.create("LABEL",{html:"Longitude",parent:i});var s=t("ol-decimal"),o=t("ol-dms","°"),r=t("ol-dms","'"),a=t("ol-dms",'"');i=ol.ext.element.create("DIV",{className:"ol-latitude",parent:this.element}),ol.ext.element.create("LABEL",{html:"Latitude",parent:i});var n=t("ol-decimal"),l=t("ol-dms","°"),h=t("ol-dms","'"),c=t("ol-dms",'"');this.inputs_=[s,n],this.button&&this.button.addEventListener("click",function(){s.focus()}),this.on("select",function(e){s.value=e.search.gps[0],n.value=e.search.gps[1]}.bind(this)),this.geolocation.on("change",function(){this.geolocation.setTracking(!1);var e=this.geolocation.getPosition();s.value=e[0],n.value=e[1],this._triggerCustomEvent("keyup",s)}.bind(this))}autocomplete(e){var t=[],i=e.split(",");i[0]=Number(i[0]),i[1]=Number(i[1]),(e=ol.coordinate.toStringHDMS(i))&&(e=e.replace(/(°|′|″) /g,"$1"));var s=ol.proj.transform([i[0],i[1]],"EPSG:4326",this.getMap().getView().getProjection());return t.push({gps:i,coordinate:s,name:e}),t}},ol.control.SearchGeoportailParcelle=class extends ol.control.SearchGeoportail{constructor(e){e.type="Commune",e.className=(e.className?e.className:"")+" IGNF-parcelle ol-collapsed-list ol-collapsed-num",e.inputLabel="Commune",e.noCollapse=!0,e.placeholder=e.placeholder||"Choisissez une commune...",super(e),this.set("copy",null);var t,i=this.element,s=this,o=ol.ext.element.create("DIV",{parent:i});e.arrondLabel=e.arrondLabel||"Arrond.",e.prefixLabel=e.prefixLabel||"Préfixe",e.sectionLabel=e.sectionLabel||"Section",e.numberLabel=e.numberLabel||"Numéro",ol.ext.element.create("LABEL",{text:e.arrondLabel,className:"district",parent:o}),ol.ext.element.create("LABEL",{text:e.prefixLabel,parent:o}),ol.ext.element.create("LABEL",{text:e.sectionLabel,parent:o}),ol.ext.element.create("LABEL",{text:e.numberLabel,parent:o}),ol.ext.element.create("BR",{parent:o}),this._inputParcelle={arrond:ol.ext.element.create("INPUT",{className:"district",disabled:!0}),prefix:document.createElement("INPUT"),section:document.createElement("INPUT"),numero:document.createElement("INPUT")},this._inputParcelle.arrond.setAttribute("maxlength",2),this._inputParcelle.arrond.setAttribute("placeholder",e.arrondLabel),this._inputParcelle.prefix.setAttribute("maxlength",3),this._inputParcelle.prefix.setAttribute("placeholder",e.prefixLabel),this._inputParcelle.section.setAttribute("maxlength",2),this._inputParcelle.section.setAttribute("placeholder",e.sectionLabel),this._inputParcelle.numero.setAttribute("maxlength",4),this._inputParcelle.numero.setAttribute("placeholder",e.numberLabel);var r=function(){t&&clearTimeout(t),t=setTimeout(function(){s.autocompleteParcelle()},e.typing||0)};for(var a in this._inputParcelle)o.appendChild(this._inputParcelle[a]),this._inputParcelle[a].addEventListener("keyup",r),this._inputParcelle[a].addEventListener("blur",function(){t=setTimeout(function(){i.classList.add("ol-collapsed-num")},200)}),this._inputParcelle[a].addEventListener("focus",function(){clearTimeout(t),i.classList.remove("ol-collapsed-num")});this.activateParcelle(!1);var n=document.createElement("DIV");n.className="autocomplete-parcelle",i.appendChild(n);var l=document.createElement("UL");l.classList.add("autocomplete-parcelle"),n.appendChild(l),(l=document.createElement("UL")).classList.add("autocomplete-page"),n.appendChild(l),this._input.addEventListener("blur",function(){setTimeout(function(){i.classList.add("ol-collapsed-list")},200)}),this._input.addEventListener("focus",function(){i.classList.remove("ol-collapsed-list"),s._listParcelle([]),s._commune&&(s._commune=null,s._input.value="",s.drawList_()),s.activateParcelle(!1)}),this.on("select",function(e){this.selectCommune(e),e.type="commune",this.dispatchEvent(e)}.bind(this)),this.set("pageSize",e.pageSize||5)}selectCommune(e){this._commune=e.search.insee||e.sear,this._arrond=e.search.districtcode,"000"!==this._arrond?(this._inputParcelle.arrond.disabled=!1,"1"===this._arrond.charAt(0)&&(this._arrond="100"),"2"===this._arrond.charAt(0)&&(this._arrond="200")):(this._inputParcelle.arrond.disabled=!0,this._inputParcelle.arrond.value=""),this._input.value=e.search.insee+" - "+e.search.fulltext,this.activateParcelle(!0),this._inputParcelle.numero.focus(),this.autocompleteParcelle()}getInputField(e){return this._inputParcelle[e]||this._input}setParcelle(e,t){this._inputParcelle.prefix.value=(e.Commune||"")+(e.CommuneAbsorbee||""),this._inputParcelle.section.value=e.Section||"",this._inputParcelle.numero.value=e.Numero||"",t&&this._triggerCustomEvent("keyup",this._inputParcelle.prefix)}activateParcelle(e){for(var t in this._inputParcelle)this._inputParcelle[t].readOnly=!e;e?this._inputParcelle.section.parentElement.classList.add("ol-active"):this._inputParcelle.section.parentElement.classList.remove("ol-active")}clearParcelList(){this._listParcelle([])}autocompleteParcelle(){function e(e,t,i){if(!e)return e;for(i=i||"0";e.length<t;)e=i+e;return e.replace(/\*/g,"_")}var t=this._commune,i=e(this._inputParcelle.prefix.value,3);"000"===i&&(i="___");var s=this._inputParcelle.arrond.value;if(s){var o=this._arrond.length-s.length;s=this._arrond.substr(0,o)+s}var r=e(this._inputParcelle.section.value,2),a=e(this._inputParcelle.numero.value,4,"0");this.searchParcelle(t,s,i,r,a,function(e){this._listParcelle(e)}.bind(this),function(){console.log("oops")})}searchParcelle(e,t,i,s,o,r){var a=this.get("url").replace("ols/apis/completion","geoportail/ols").replace("completion","search");if(/ols/.test(a)){var n='<?xml version="1.0" encoding="UTF-8"?><XLS xmlns:xls="http://www.opengis.net/xls" xmlns:gml="http://www.opengis.net/gml" xmlns="http://www.opengis.net/xls" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.2" xsi:schemaLocation="http://www.opengis.net/xls http://schemas.opengis.net/ols/1.2/olsAll.xsd"><RequestHeader/><Request requestID="1" version="1.2" methodName="LocationUtilityService"><GeocodeRequest returnFreeForm="false"><Address countryCode="CadastralParcel"><freeFormAddress>'+(e+(i||"___")+(s||"__")+(o||(s?"____":"0001")))+"+</freeFormAddress></Address></GeocodeRequest></Request></XLS>";this.ajax(this.get("url").replace("ols/apis/completion","geoportail/ols"),{xls:n},function(e){for(var t,i=(new DOMParser).parseFromString(e,"text/xml").getElementsByTagName("GeocodedAddress"),s=[],o=0;t=i[o];o++){for(var a,n=(t.getElementsByTagName("gml:pos")[0]||t.getElementsByTagName("pos")[0]).childNodes[0].nodeValue.split(" "),l=t.getElementsByTagName("Place"),h={lon:Number(n[1]),lat:Number(n[0])},c=0;a=l[c];c++)h[a.attributes.type.value]=a.childNodes[0].nodeValue;s.push(h)}console.log(s),r(s)},{dataType:"XML"})}else this.ajax(a+"?index=parcel&q=&departmentcode="+e.substr(0,2)+"&municipalitycode="+e.substr(-3)+(i?"&oldmunicipalitycode="+i.replace(/_/g,"0"):"")+(t?"&districtcode="+t:"")+(s?"&section="+s.toUpperCase():"")+(o?"&number="+o:"")+"&limit=20",{},function(e){var t=[];e.features&&e.features.forEach(function(e){var i=e.properties;t.push({id:i.id,INSEE:i.departmentcode+i.municipalitycode,Commune:i.municipalitycode,Departement:i.departmentcode,CommuneAbsorbee:i.oldmunicipalitycode,Arrondissement:i.districtcode,Section:i.section,Numero:i.number,Municipality:i.city,Feuille:i.sheet,lon:e.geometry.coordinates[0],lat:e.geometry.coordinates[1]})}),r(t)})}_listParcelle(e){var t=this,i=this.element.querySelector("ul.autocomplete-parcelle");i.innerHTML="";var s=this.element.querySelector("ul.autocomplete-page");function o(e){var t,o=i.children,r="ol-list-"+e;for(t=0;t<o.length;t++)o[t].style.display=o[t].className===r?"":"none";for(o=s.children,t=0;t<o.length;t++)o[t].className=o[t].innerText==e?"selected":"";s.style.display=o.length>1?"":"none"}s.innerHTML="",this._listParc=[],e.sort(function(e,t){var i=e.INSEE+e.CommuneAbsorbee+e.Section+e.Numero,s=t.INSEE+t.CommuneAbsorbee+t.Section+t.Numero;return i===s?0:i<s?-1:1});for(var r,a=this.get("pageSize"),n=0;r=e[n];n++){var l=document.createElement("LI");l.setAttribute("data-search",n),a>0&&l.classList.add("ol-list-"+Math.floor(n/a)),this._listParc.push(r),l.addEventListener("click",function(e){t._handleParcelle(t._listParc[e.currentTarget.getAttribute("data-search")])}),l.innerHTML=r.INSEE+"-"+r.CommuneAbsorbee+"-"+r.Arrondissement+"-"+r.Section+r.Numero,i.appendChild(l),a>0&&!(n%a)&&((l=document.createElement("LI")).innerText=Math.floor(n/a),l.addEventListener("click",function(e){o(e.currentTarget.innerText)}),s.appendChild(l))}a>0&&o(0)}_handleParcelle(e){this.dispatchEvent({type:"parcelle",search:e,coordinate:ol.proj.fromLonLat([e.lon,e.lat],this.getMap().getView().getProjection())})}},ol.control.SearchNominatim=class extends ol.control.SearchJSON{constructor(e){(e=e||{}).className=e.className||"nominatim",e.typing=e.typing||-1,e.url=e.url||"https://nominatim.openstreetmap.org/search",e.copy='<a href="http://www.openstreetmap.org/copyright" target="new">&copy; OpenStreetMap contributors</a>',super(e),this.set("polygon",e.polygon),this.set("viewbox",e.viewbox),this.set("bounded",e.bounded)}getTitle(e){var t=[];e.class&&t.push(e.class),e.type&&t.push(e.type);var i=e.display_name+(t.length?"<i>"+t.join(" - ")+"</i>":"");return e.icon&&(i="<img src='"+e.icon+"' />"+i),i}requestData(e){var t={format:"json",addressdetails:1,q:e,polygon_geojson:this.get("polygon")?1:0,bounded:this.get("bounded")?1:0,limit:this.get("maxItems")};return this.get("viewbox")&&(t.viewbox=this.get("viewbox")),t}select(e){var t=[Number(e.lon),Number(e.lat)];try{t=ol.proj.transform(t,"EPSG:4326",this.getMap().getView().getProjection())}catch(e){}this.dispatchEvent({type:"select",search:e,coordinate:t})}reverseGeocode(e,t){var i=ol.proj.transform(e,this.getMap().getView().getProjection(),"EPSG:4326");this.ajax(this.get("url").replace("search","reverse"),{lon:i[0],lat:i[1],format:"json"},function(e){t?t.call(this,[e]):e&&!e.error&&this._handleSelect(e,!0)}.bind(this))}handleResponse(e){return e.results||e}},ol.control.SearchWikipedia=class extends ol.control.SearchJSON{constructor(e){(e=e||{}).lang=e.lang||"en",e.className=e.className||"ol-search-wikipedia",e.url="https://"+e.lang+".wikipedia.org/w/api.php",e.placeholder=e.placeholder||"search string, File:filename",e.copy='<a href="https://'+e.lang+'.wikipedia.org/" target="new">Wikipedia&reg; - CC-By-SA</a>',super(e),this.set("lang",e.lang)}getTitle(e){return ol.ext.element.create("DIV",{html:e.title,title:e.desc})}setLang(e){this.set("lang",e),this.set("url","https://"+e+".wikipedia.org/w/api.php")}requestData(e){return{action:"opensearch",search:e,lang:this.get("lang"),format:"json",origin:"*",limit:this.get("maxItems")}}handleResponse(e){for(var t=[],i=0;i<e[1].length;i++)t.push({title:e[1][i],desc:e[2][i],uri:e[3][i]});return t}select(e){var t=decodeURIComponent(e.uri.split("/").pop()).replace(/'/,"%27");ol.ext.Ajax.get({url:e.uri.split("wiki/")[0]+"w/api.php",data:{action:"query",prop:"pageimages|coordinates|extracts",exintro:1,explaintext:1,piprop:"original",origin:"*",format:"json",redirects:1,titles:t},options:{encode:!1},success:function(t){var i=t.query.pages[Object.keys(t.query.pages).pop()];console.log(i);var s,o={title:e.title,desc:i.extract||e.desc,url:e.uri,img:i.original?i.original.source:void 0,pageid:i.pageid};i.coordinates&&(o.lon=i.coordinates[0].lon,o.lat=i.coordinates[0].lat,s=[o.lon,o.lat],s=ol.proj.transform(s,"EPSG:4326",this.getMap().getView().getProjection())),this.dispatchEvent({type:"select",search:o,coordinate:s})}.bind(this)})}},ol.control.Select=class extends ol.control.SelectBase{constructor(e){var t=(e=e||{}).content=document.createElement("div");super(e);var i=t.querySelector("button");this._ul=ol.ext.element.create("UL",{parent:t}),this._all=ol.ext.element.create("INPUT",{type:"checkbox",checked:!0});var s=ol.ext.element.create("LABEL",{html:this._all,parent:t});ol.ext.element.appendText(s,e.allLabel||"match all"),this._useCase=ol.ext.element.create("INPUT",{type:"checkbox"});var o=ol.ext.element.create("LABEL",{html:this._useCase,parent:t});ol.ext.element.appendText(o,e.caseLabel||"case sensitive"),t.appendChild(i),ol.ext.element.create("BUTTON",{className:"ol-append",html:e.addLabel||"add rule",click:function(){this.addCondition()}.bind(this),parent:t}),this._conditions=[],this.set("attrPlaceHolder",e.attrPlaceHolder||"attribute"),this.set("valuePlaceHolder",e.valuePlaceHolder||"value"),this.addCondition()}addCondition(e){e=e||{},this._conditions.push({attr:e.attr||"",op:e.op||"=",val:e.val||""}),this._drawlist()}getConditions(){return{usecase:this._useCase.checked,all:this._all.checked,conditions:this._conditions}}setConditions(e){this._useCase.checked=e.usecase,this._all.checked=e.all,this._conditions=e.conditions,this._drawlist()}getConditionsString(e){for(var t,i="",s=0;t=e.conditions[s];s++)t.attr&&(i+=(i?e.all?" AND ":" OR ":"")+t.attr+this.operationsList[t.op]+t.val);return i}_drawlist(){this._ul.innerHTML="";for(var e=0;e<this._conditions.length;e++)this._ul.appendChild(this._getLiCondition(e))}_autocomplete(e,t){t.classList.remove("ol-hidden"),t.innerHTML="";for(var i,s={},o=this.get("source"),r=0;i=o[r];r++)for(var a,n=i.getFeatures(),l=0;(a=n[l])&&(Object.assign(s,a.getProperties()),!(l>100));l++);var h=new RegExp(e,"i");for(var c in s)if("geometry"!==c&&h.test(c)){var u=document.createElement("li");u.textContent=c,u.addEventListener("click",function(){t.previousElementSibling.value=this.textContent;var e=document.createEvent("HTMLEvents");e.initEvent("change",!0,!1),t.previousElementSibling.dispatchEvent(e),t.classList.add("ol-hidden")}),t.appendChild(u)}}_getLiCondition(e){var t=this,i=document.createElement("li"),s=document.createElement("div");s.classList.add("ol-autocomplete"),s.addEventListener("mouseleave",function(){this.querySelector("ul").classList.add("ol-hidden")}),i.appendChild(s);var o=document.createElement("input");o.classList.add("ol-attr"),o.setAttribute("type","search"),o.setAttribute("placeholder",this.get("attrPlaceHolder")),o.addEventListener("keyup",function(){t._autocomplete(this.value,this.nextElementSibling)}),o.addEventListener("focusout",function(){setTimeout(function(){s.querySelector("ul").classList.add("ol-hidden")},300)}),o.addEventListener("click",function(){setTimeout(function(){t._autocomplete(this.value,this.nextElementSibling),this.nextElementSibling.classList.remove("ol-hidden")}.bind(this))}),o.addEventListener("change",function(){t._conditions[e].attr=this.value}),o.value=t._conditions[e].attr,s.appendChild(o);var r=document.createElement("ul");r.classList.add("ol-hidden"),s.appendChild(r);var a=document.createElement("select");for(var n in i.appendChild(a),this.operationsList){var l=document.createElement("option");l.value=n,l.textContent=this.operationsList[n],a.appendChild(l)}a.value=t._conditions[e].op,a.addEventListener("change",function(){t._conditions[e].op=this.value});var h=document.createElement("input");if(h.setAttribute("type","text"),h.setAttribute("placeholder",this.get("valuePlaceHolder")),h.addEventListener("change",function(){t._conditions[e].val=this.value}),h.value=t._conditions[e].val,i.appendChild(h),this._conditions.length>1){var c=document.createElement("div");c.classList.add("ol-delete"),c.addEventListener("click",function(){t.removeCondition(e)}),i.appendChild(c)}return i}removeCondition(e){this._conditions.splice(e,1),this._drawlist()}doSelect(e){return(e=e||{}).useCase=e.useCase||this._useCase.checked,e.matchAll=e.matchAll||this._all.checked,e.conditions=e.conditions||this._conditions,super.doSelect(e)}},ol.control.SelectCheck=class extends ol.control.SelectBase{constructor(e){var t=(e=e||{}).content=ol.ext.element.create("DIV");e.label&&ol.ext.element.create("LABEL",{html:e.label,parent:t}),e.className=e.className||"ol-select-check",super(e);var i=t.querySelector("button");this._input=ol.ext.element.create("DIV",{parent:t}),t.appendChild(i),this.set("property",e.property||"name"),this.set("max",e.max||1e4),this.set("defaultLabel",e.defaultLabel),this.set("type",e.type),this._selectAll=e.selectAll,this._onchoice=e.onchoice,e.values?this.setValues({values:e.values,sort:!0}):this.setValues()}setMap(e){super.setMap(e),this.setValues()}doSelect(e){e=e||{};var t=[];return this._checks.forEach(function(e){e.checked&&e.value&&t.push({attr:this.get("property"),op:"=",val:e.value})}.bind(this)),t.length?super.doSelect({features:e.features,conditions:t}):super.doSelect({features:e.features,matchAll:this._selectAll})}setValues(e){var t,i;if((e=e||{}).values)e.values instanceof Array?(i={},e.values.forEach(function(e){i[e]=e})):i=e.values;else{i={};var s=this.get("property");this.getSources().forEach(function(e){for(var t=e.getFeatures(),o=Math.min(t.length,this.get("max")),r=0;r<o;r++){var a=t[r].get(s);a&&(i[a]=a)}}.bind(this))}if(Object.keys(i).length){e.sort?(t={},Object.keys(i).sort().forEach(function(e){t[e]=i[e]})):t=i,ol.ext.element.setHTML(this._input,""),this._checks=[];var o="radio_"+(new Date).getTime(),r=function(e,t){this._checks.push(ol.ext.element.createCheck({after:t,name:o,val:e,type:this.get("type"),change:function(){this._onchoice?this._onchoice():this.doSelect()}.bind(this),parent:this._input}))}.bind(this);for(var a in this.get("defaultLabel")&&"radio"===this.get("type")&&r("",this.get("defaultLabel")),t)r(a,t[a])}}},ol.control.SelectCondition=class extends ol.control.SelectBase{constructor(e){var t=(e=e||{}).content=ol.ext.element.create("DIV");e.className=e.className||"ol-select-condition",super(e);var i=t.querySelector("button");this._check=ol.ext.element.createSwitch({after:e.label||"condition",change:function(){this._onchoice?this._onchoice():this.doSelect()}.bind(this),parent:t}),this._input=ol.ext.element.create("DIV",{parent:t}),t.appendChild(i),this.setCondition(e.condition),this._selectAll=e.selectAll,this._onchoice=e.onchoice}setCondition(e){this._conditions=e?e instanceof Array?e:[e]:[]}addCondition(e){this._conditions.push(e)}doSelect(e){e=e||{};var t=this._conditions;return this._check.checked?super.doSelect({features:e.features,conditions:t}):super.doSelect({features:e.features,matchAll:this._selectAll})}},ol.control.SelectFulltext=class extends ol.control.SelectBase{constructor(e){var t=(e=e||{}).content=ol.ext.element.create("DIV");e.label&&ol.ext.element.create("LABEL",{html:e.label,parent:t}),super(e);var i=t.querySelector("button");this._input=ol.ext.element.create("INPUT",{placeHolder:e.placeHolder||"search...",change:function(){this._onchoice&&this._onchoice()}.bind(this),parent:t}),t.appendChild(i),this._onchoice=e.onchoice,this.set("property",e.property||"name")}doSelect(e){return e=e||{},super.doSelect({features:e.features,useCase:!1,conditions:[{attr:this.get("property"),op:"contain",val:this._input.value}]})}},ol.control.SelectMulti=class extends ol.control.SelectBase{constructor(e){(e=e||{}).content=ol.ext.element.create("DIV");var t=ol.ext.element.create("UL",{parent:e.content});e.className=e.className||"ol-select-multi",super(e),this._container=t,this._controls=[],e.controls.forEach(this.addControl.bind(this))}setMap(e){this.getMap()&&this._controls.forEach(function(e){this.getMap().remveControl(e)}.bind(this)),super.setMap(e),this.getMap()&&this._controls.forEach(function(e){this.getMap().addControl(e)}.bind(this))}addControl(e){e instanceof ol.control.SelectBase&&(this._controls.push(e),e.setTarget(ol.ext.element.create("LI",{parent:this._container})),e._selectAll=!0,e._onchoice=this.doSelect.bind(this),this.getMap()&&this.getMap().addControl(e))}getControls(){return this._controls}doSelect(){var e=[];return this.getSources().forEach(function(t){e=e.concat(t.getFeatures())}),this._controls.forEach(function(t){e=t.doSelect({features:e})}),this.dispatchEvent({type:"select",features:e}),e}},ol.control.SelectPopup=class extends ol.control.SelectBase{constructor(e){(e=e||{}).className=e.className||"ol-select-popup";var t=e.content=ol.ext.element.create("DIV");super(e);var i=t.querySelector("button");e.label&&ol.ext.element.create("LABEL",{html:e.label,parent:t}),this._input=ol.ext.element.create("SELECT",{on:{change:function(){this._onchoice?this._onchoice():this.doSelect()}.bind(this)},parent:t}),t.appendChild(i),this.set("property",e.property||"name"),this.set("max",e.max||1e4),this.set("defaultLabel",e.defaultLabel),this._selectAll=e.selectAll,this._onchoice=e.onchoice,this.setValues()}setMap(e){super.setMap(e),this.setValues()}doSelect(e){return e=e||{},this._input.value?super.doSelect({features:e.features,conditions:[{attr:this.get("property"),op:"=",val:this._input.value}]}):super.doSelect({features:e.features,matchAll:this._selectAll})}setValues(e){var t,i;if((e=e||{}).values)e.values instanceof Array?(i={},e.values.forEach(function(e){i[e]=e})):i=e.values;else{i={};var s=this.get("property");this.getSources().forEach(function(e){for(var t=e.getFeatures(),o=Math.min(t.length,this.get("max")),r=0;r<o;r++){var a=t[r].get(s);a&&(i[a]=a)}}.bind(this))}for(var o in e.sort?(t={},Object.keys(i).sort().forEach(function(e){t[e]=i[e]})):t=i,ol.ext.element.setHTML(this._input,""),ol.ext.element.create("OPTION",{className:"ol-default",html:this.get("defaultLabel")||"",value:"",parent:this._input}),t)ol.ext.element.create("OPTION",{html:t[o],value:o,parent:this._input})}},ol.control.Status=class extends ol.control.Control{constructor(e){e=e||{},super({element:ol.ext.element.create("DIV",{className:(e.className||"")+" ol-status"+(e.target?"":" ol-unselectable ol-control")}),target:e.target}),this.setVisible(!1!==e.visible),e.position&&this.setPosition(e.position),this.status(e.status||"")}setVisible(e){e?this.element.classList.add("ol-visible"):this.element.classList.remove("ol-visible")}status(e){var t=e||"";if(t){if(ol.ext.element.show(this.element),t instanceof Element||"string"==typeof t)ol.ext.element.setHTML(this.element,t);else for(var i in t="",e)t+="<label>"+i+":</label> "+e[i]+"<br/>";ol.ext.element.setHTML(this.element,t)}else ol.ext.element.hide(this.element)}setPosition(e){this.element.classList.remove("ol-left"),this.element.classList.remove("ol-right"),this.element.classList.remove("ol-bottom"),this.element.classList.remove("ol-center"),/^left$|^right$|^bottom$|^center$/.test(e)&&this.element.classList.add("ol-"+e)}show(e){!1===e?ol.ext.element.hide(this.element):ol.ext.element.show(this.element)}hide(){ol.ext.element.hide(this.element)}toggle(){ol.ext.element.toggle(this.element)}isShown(){return"none"===this.element.style.display}},ol.control.Storymap=class extends ol.control.Control{constructor(e){e.target&&(e.html?e.html instanceof Element&&(e.html=e.html.innerHTML):e.html=e.target.innerHTML,e.target.innerHTML="");var t=ol.ext.element.create("DIV",{className:(e.className||"")+" ol-storymap"+(e.target?"":" ol-unselectable ol-control")});super({element:t,target:e.target}),this.content=ol.ext.element.create("DIV",{parent:t}),ol.ext.element.scrollDiv(this.content,{vertical:!0,mousewheel:!0,minibar:e.minibar}),this.setStory(e.html)}setChapter(e){for(var t,i=this.content.querySelectorAll(".chapter"),s=0;t=i[s];s++)t.getAttribute("name")===e&&(this.content.scrollTop=t.offsetTop-30)}setStory(e){e instanceof Element?(this.content.innerHTML="",this.content.appendChild(e)):this.content.innerHTML=e,this.content.querySelectorAll(".chapter").forEach(function(e){e.addEventListener("click",function(t){e.classList.contains("ol-select")?"IMG"===t.target.tagName&&t.target.dataset.title&&this.dispatchEvent({coordinate:this.getMap()?this.getMap().getCoordinateFromPixel([t.layerX,t.layerY]):null,type:"clickimage",img:t.target,title:t.target.dataset.title,element:e,name:e.getAttribute("name"),originalEvent:t}):(this.content.scrollTop=e.offsetTop-30,t.preventDefault())}.bind(this))}.bind(this));var t=this.content.querySelectorAll(".ol-scroll-next");t.forEach(function(e){e.addEventListener("click",function(t){if(e.parentElement.classList.contains("ol-select")){for(var i,s=this.content.querySelectorAll(".chapter"),o=e.offsetTop,r=0;i=s[r];r++)if(i.offsetTop>o){o=i.offsetTop;break}this.content.scrollTop=o-30,t.stopPropagation(),t.preventDefault()}}.bind(this))}.bind(this)),(t=this.content.querySelectorAll(".ol-scroll-top")).forEach(function(e){e.addEventListener("click",function(e){this.content.scrollTop=0,e.stopPropagation(),e.preventDefault()}.bind(this))}.bind(this));var i=function(e){var t=[parseFloat(e.getAttribute("data-lon")),parseFloat(e.getAttribute("data-lat"))],i=ol.proj.fromLonLat(t,this.getMap().getView().getProjection()),s=parseFloat(e.getAttribute("data-zoom"));return{type:"scrollto",element:e,name:e.getAttribute("name"),coordinate:i,lon:t,zoom:s}}.bind(this),s=this.content.querySelectorAll(".chapter")[0];setTimeout(function(){s.classList.add("ol-select"),this.dispatchEvent(i(s))}.bind(this)),this.content.addEventListener("scroll",function(){var e,t=this.content.querySelectorAll(".chapter"),o=ol.ext.element.getStyle(this.content,"height");if(this.content.scrollTop)for(var r,a=0;r=t[a];a++){if(r.offsetTop-this.content.scrollTop>o/3)break;e=r}else e=t[0];if(e&&e!==s){s&&s.classList.remove("ol-select"),(s=e).classList.add("ol-select");var n=i(s),l=this.getMap().getView();switch(l.cancelAnimations(),s.getAttribute("data-animation")){case"flyto":l.flyTo({center:n.coordinate,zoomAt:Math.min(l.getZoom(),n.zoom)-1,zoom:n.zoom})}this.dispatchEvent(n)}}.bind(this))}},ol.control.Swipe=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("div");super({element:t}),t.className=(e.className||"ol-swipe")+" ol-unselectable ol-control";var i=document.createElement("button");t.appendChild(i),t.addEventListener("mousedown",this.move.bind(this)),t.addEventListener("touchstart",this.move.bind(this)),this.precomposeRight_=this.precomposeRight.bind(this),this.precomposeLeft_=this.precomposeLeft.bind(this),this.postcompose_=this.postcompose.bind(this),this.layers=[],e.layers&&this.addLayer(e.layers,!1),e.rightLayers&&this.addLayer(e.rightLayers,!0),this.on("propertychange",function(e){if(this.getMap())try{this.getMap().renderSync()}catch(e){}"horizontal"===this.get("orientation")?(this.element.style.top=100*this.get("position")+"%",this.element.style.left=""):("vertical"!==this.get("orientation")&&this.set("orientation","vertical"),this.element.style.left=100*this.get("position")+"%",this.element.style.top=""),"orientation"===e.key&&(this.element.classList.remove("horizontal","vertical"),this.element.classList.add(this.get("orientation"))),this.isMoving||this.layers.forEach(function(e){e.layer.getImageRatio&&e.layer.changed()})}.bind(this)),this.set("position",e.position||.5),this.set("orientation",e.orientation||"vertical")}setMap(e){var t,i;if(this.getMap()){for(t=0;t<this.layers.length;t++)(i=this.layers[t]).right?i.layer.un(["precompose","prerender"],this.precomposeRight_):i.layer.un(["precompose","prerender"],this.precomposeLeft_),i.layer.un(["postcompose","postrender"],this.postcompose_);try{this.getMap().renderSync()}catch(e){}}if(super.setMap(e),e){for(this._listener=[],t=0;t<this.layers.length;t++)(i=this.layers[t]).right?i.layer.on(["precompose","prerender"],this.precomposeRight_):i.layer.on(["precompose","prerender"],this.precomposeLeft_),i.layer.on(["postcompose","postrender"],this.postcompose_);try{e.renderSync()}catch(e){}}}isLayer_(e){for(var t=0;t<this.layers.length;t++)if(this.layers[t].layer===e)return t;return-1}addLayer(e,t){e instanceof Array||(e=[e]);for(var i=0;i<e.length;i++){var s=e[i];if(this.isLayer_(s)<0&&(this.layers.push({layer:s,right:t}),this.getMap())){t?s.on(["precompose","prerender"],this.precomposeRight_):s.on(["precompose","prerender"],this.precomposeLeft_),s.on(["postcompose","postrender"],this.postcompose_);try{this.getMap().renderSync()}catch(e){}}}}removeLayers(){var e=[];this.layers.forEach(function(t){e.push(t.layer)}),this.removeLayer(e)}removeLayer(e){e instanceof Array||(e=[e]);for(var t=0;t<e.length;t++){var i=this.isLayer_(e[t]);i>=0&&this.getMap()&&(this.layers[i].right?e[t].un(["precompose","prerender"],this.precomposeRight_):e[t].un(["precompose","prerender"],this.precomposeLeft_),e[t].un(["postcompose","postrender"],this.postcompose_),this.layers.splice(i,1))}if(this.getMap())try{this.getMap().renderSync()}catch(e){}}getRectangle(){var e;return"vertical"===this.get("orientation")?[0,0,(e=this.getMap().getSize())[0]*this.get("position"),e[1]]:[0,0,(e=this.getMap().getSize())[0],e[1]*this.get("position")]}move(e){var t,i=this;switch(this._movefn||(this._movefn=this.move.bind(this)),e.type){case"touchcancel":case"touchend":case"mouseup":i.isMoving=!1,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(e){document.removeEventListener(e,i._movefn)}),this.layers.forEach(function(e){e.layer.getImageRatio&&e.layer.changed()});break;case"mousedown":case"touchstart":i.isMoving=!0,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(e){document.addEventListener(e,i._movefn)});case"mousemove":case"touchmove":if(i.isMoving)if("vertical"===i.get("orientation")){var s=e.pageX||e.touches&&e.touches.length&&e.touches[0].pageX||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageX;if(!s)break;s-=i.getMap().getTargetElement().getBoundingClientRect().left+window.pageXOffset-document.documentElement.clientLeft;var o=(t=i.getMap().getSize()[0])-Math.min(Math.max(0,t-s),t);t=o/t,i.set("position",t),i.dispatchEvent({type:"moving",size:[o,i.getMap().getSize()[1]],position:[t,0]})}else{var r=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY;if(!r)break;r-=i.getMap().getTargetElement().getBoundingClientRect().top+window.pageYOffset-document.documentElement.clientTop;var a=(t=i.getMap().getSize()[1])-Math.min(Math.max(0,t-r),t);t=a/t,i.set("position",t),i.dispatchEvent({type:"moving",size:[i.getMap().getSize()[0],a],position:[0,t]})}}}_transformPt(e,t){var i=e.inversePixelTransform,s=t[0],o=t[1];return t[0]=i[0]*s+i[2]*o+i[4],t[1]=i[1]*s+i[3]*o+i[5],t}_drawRect(e,t){var i=e.inversePixelTransform;if(i){var s=[[t[0][0],t[0][1]],[t[0][0],t[1][1]],[t[1][0],t[1][1]],[t[1][0],t[0][1]],[t[0][0],t[0][1]]];if(e.context.save(),e.target.getImageRatio){var o=-Math.atan2(e.frameState.pixelToCoordinateTransform[1],e.frameState.pixelToCoordinateTransform[0]);e.context.translate(e.frameState.size[0]/2,e.frameState.size[1]/2),e.context.rotate(o),e.context.translate(-e.frameState.size[0]/2,-e.frameState.size[1]/2)}s.forEach(function(t,s){t=[t[0]*i[0]-t[1]*i[1]+i[4],-t[0]*i[2]+t[1]*i[3]+i[5]],s?e.context.lineTo(t[0],t[1]):e.context.moveTo(t[0],t[1])}),e.context.restore()}else{var r=e.frameState.pixelRatio;e.context.rect(t[0][0]*r,t[0][1]*r,t[1][0]*r,t[1][1]*r)}}precomposeLeft(e){var t=e.context;if(t instanceof WebGLRenderingContext){if("prerender"===e.type){this._lefttime!=e.frameState.time&&(t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT),this._lefttime=e.frameState.time),t.enable(t.SCISSOR_TEST);var i,s,o=this.getMap().getSize(),r=this._transformPt(e,[0,o[1]]),a=this._transformPt(e,[o[0],0]),n=a[0]-r[0],l=a[1]-r[1];"vertical"===this.get("orientation")?(i=Math.round(n*this.get("position")),s=l):(i=n,s=Math.round(l*this.get("position")),r[1]+=l-s),t.scissor(r[0],r[1],i,s),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT)}}else{var h=e.frameState.size;t.save(),t.beginPath();var c=[[0,0],[h[0],h[1]]];"vertical"===this.get("orientation")?c[1]=[.5*h[0]+this.getMap().getSize()[0]*(this.get("position")-.5),h[1]]:c[1]=[h[0],.5*h[1]+this.getMap().getSize()[1]*(this.get("position")-.5)],this._drawRect(e,c),t.clip()}}precomposeRight(e){var t=e.context;if(t instanceof WebGLRenderingContext){if("prerender"===e.type){this._righttime!=e.frameState.time&&(t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT),this._righttime=e.frameState.time),t.enable(t.SCISSOR_TEST);var i,s,o=this.getMap().getSize(),r=this._transformPt(e,[0,o[1]]),a=this._transformPt(e,[o[0],0]),n=a[0]-r[0],l=a[1]-r[1];"vertical"===this.get("orientation")?(s=l,i=Math.round(n*(1-this.get("position"))),r[0]+=n-i):(i=n,s=Math.round(l*(1-this.get("position")))),t.scissor(r[0],r[1],i,s),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT)}}else{var h=e.frameState.size;t.save(),t.beginPath();var c=[[0,0],[h[0],h[1]]];"vertical"===this.get("orientation")?c[0]=[.5*h[0]+this.getMap().getSize()[0]*(this.get("position")-.5),0]:c[0]=[0,.5*h[1]+this.getMap().getSize()[1]*(this.get("position")-.5)],this._drawRect(e,c),t.clip()}}postcompose(e){if(e.context instanceof WebGLRenderingContext){if("postrender"===e.type){var t=e.context;t.disable(t.SCISSOR_TEST)}}else e.target.getClassName&&"ol-layer"!==e.target.getClassName()&&e.target.get("declutter")?setTimeout(function(){e.context.restore()},0):e.context.restore()}},ol.control.SwipeMap=class extends ol.control.Control{constructor(e){e=e||{};var t=document.createElement("button"),i=document.createElement("div");i.className=(e.className||"ol-swipe")+" ol-unselectable ol-control",super({element:i}),i.appendChild(t),i.addEventListener("mousedown",this.move.bind(this)),i.addEventListener("touchstart",this.move.bind(this)),this.on("propertychange",function(e){"horizontal"===this.get("orientation")?(this.element.style.top=100*this.get("position")+"%",this.element.style.left=""):("vertical"!==this.get("orientation")&&this.set("orientation","vertical"),this.element.style.left=100*this.get("position")+"%",this.element.style.top=""),"orientation"===e.key&&(this.element.classList.remove("horizontal","vertical"),this.element.classList.add(this.get("orientation")),this.getMap()&&(this.getMap().getTargetElement().dataset.swipeOrientation=this.get("orientation"))),this._clip()}.bind(this)),this.on("change:active",this._clip.bind(this)),this.set("position",e.position||.5),this.set("orientation",e.orientation||"vertical"),this.set("right",e.right)}setMap(e){this.getMap()&&(this._listener&&ol.Observable.unByKey(this._listener),this.getMap().getViewport().querySelector(".ol-layers").style.clip="",delete this.getMap().getTargetElement().dataset.swipeOrientation);super.setMap(e),e&&(this._listener=e.on("change:size",this._clip.bind(this)),this._clip())}_clip(){if(this.getMap()){var e=this.getMap().getViewport().querySelector(".ol-layers"),t=this.getRectangle();t&&(e.style.clip="rect("+t[1]+"px,"+t[2]+"px,"+t[3]+"px,"+t[0]+"px)"),this.getMap().getTargetElement().dataset.swipeOrientation=this.get("orientation")}}getRectangle(){var e=this.getMap().getSize();if(e)return"vertical"===this.get("orientation")?this.get("right")?[e[0]*this.get("position"),0,e[0],e[1]]:[0,0,e[0]*this.get("position"),e[1]]:this.get("right")?[0,e[1]*this.get("position"),e[0],e[1]]:[0,0,e[0],e[1]*this.get("position")]}move(e){var t,i=this;switch(this._movefn||(this._movefn=this.move.bind(this)),e.type){case"touchcancel":case"touchend":case"mouseup":i.isMoving=!1,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(e){document.removeEventListener(e,i._movefn)});break;case"mousedown":case"touchstart":i.isMoving=!0,["mouseup","mousemove","touchend","touchcancel","touchmove"].forEach(function(e){document.addEventListener(e,i._movefn)});case"mousemove":case"touchmove":if(i.isMoving)if("vertical"===i.get("orientation")){var s=e.pageX||e.touches&&e.touches.length&&e.touches[0].pageX||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageX;if(!s)break;s-=i.getMap().getTargetElement().getBoundingClientRect().left+window.pageXOffset-document.documentElement.clientLeft;var o=(t=i.getMap().getSize()[0])-Math.min(Math.max(0,t-s),t);t=o/t,i.set("position",t),i.dispatchEvent({type:"moving",size:[o,i.getMap().getSize()[1]],position:[t,0]})}else{var r=e.pageY||e.touches&&e.touches.length&&e.touches[0].pageY||e.changedTouches&&e.changedTouches.length&&e.changedTouches[0].pageY;if(!r)break;r-=i.getMap().getTargetElement().getBoundingClientRect().top+window.pageYOffset-document.documentElement.clientTop;var a=(t=i.getMap().getSize()[1])-Math.min(Math.max(0,t-r),t);t=a/t,i.set("position",t),i.dispatchEvent({type:"moving",size:[i.getMap().getSize()[0],a],position:[0,t]})}}}},ol.control.Target=class extends ol.control.CanvasBase{constructor(e){var t=(e=e||{}).style||[new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:11,radius1:0,radius2:0,snapToPixel:!0,stroke:new ol.style.Stroke({color:"#fff",width:3})})}),new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:11,radius1:0,radius2:0,snapToPixel:!0,stroke:new ol.style.Stroke({color:"#000",width:1})})})];t instanceof Array||(t=[t]);var i=document.createElement("div");i.className="ol-target ol-unselectable ol-control",super({element:i,style:t,target:e.target}),this.composite=e.composite||"",this.setVisible(!1!==e.visible)}setStyle(e){e instanceof Array||(e=[e]),super.setStyle(e)}setVisible(e){if(this.set("visible",e),this.getMap())try{this.getMap().renderSync()}catch(e){}}getVisible(){return this.get("visible")}_draw(e){var t=this.getContext(e);if(t&&this.getMap()&&this.getVisible()){var i=e.frameState.pixelRatio;t.save(),t.scale(i,i);var s=t.canvas.width/2/i,o=t.canvas.height/2/i,r=new ol.geom.Point(this.getMap().getCoordinateFromPixel([s,o]));this.composite&&(t.globalCompositeOperation=this.composite);for(var a=0;a<this._style.length;a++){var n=this._style[a];if(n instanceof ol.style.Style){var l=e.vectorContext;if(!l){var h={inversePixelTransform:[1,0,0,1,0,0],context:t,frameState:{pixelRatio:i,extent:e.frameState.extent,coordinateToPixelTransform:e.frameState.coordinateToPixelTransform,viewState:e.frameState.viewState}};l=ol.render.getVectorContext(h)}l.setStyle(n),l.drawGeometry(r)}}t.restore()}}},ol.control.TextButton=class extends ol.control.Button{constructor(e){(e=e||{}).className=(e.className||"")+" ol-text-button",super(e)}},ol.control.Timeline=class extends ol.control.Control{constructor(e){super({element:ol.ext.element.create("DIV",{className:(e.className||"")+" ol-timeline"+(e.target?"":" ol-unselectable ol-control")+(e.zoomButton?" ol-hasbutton":"")}),target:e.target}),this._scrollDiv=ol.ext.element.create("DIV",{className:"ol-scroll",parent:this.element}),this._buttons=ol.ext.element.create("DIV",{className:"ol-buttons",parent:this.element}),e.zoomButton&&(this.addButton({className:"ol-zoom-in",handleClick:function(){var e=this.get("zoom");e>=1?e++:e=Math.min(1,e+.1),e=Math.round(100*e)/100,this.refresh(e)}.bind(this)}),this.addButton({className:"ol-zoom-out",handleClick:function(){var e=this.get("zoom");e>1?e--:e-=.1,e=Math.round(100*e)/100,this.refresh(e)}.bind(this)})),this._intervalDiv=ol.ext.element.create("DIV",{className:"ol-center-date",parent:this.element}),this.element.addEventListener("mouseover",function(){this._select&&this._select.elt.classList.remove("ol-select")}.bind(this));var t=null;this._scrollDiv.addEventListener("scroll",function(){this._setScrollLeft(),t&&(clearTimeout(t),t=null),t=setTimeout(function(){this.dispatchEvent({type:"scroll",date:this.getDate(),dateStart:this.getDate("start"),dateEnd:this.getDate("end")})}.bind(this),e.scrollTimeout||15)}.bind(this)),ol.ext.element.scrollDiv(this._scrollDiv,{onmove:function(e){this._moving=e}.bind(this)}),this._tline=[],this._scrollLeft=0,this.set("maxWidth",e.maxWidth||2e3),this.set("minDate",e.minDate||1/0),this.set("maxDate",e.maxDate||-1/0),this.set("graduation",e.graduation),this.set("minZoom",e.minZoom||.2),this.set("maxZoom",e.maxZoom||4),this.setInterval(e.interval),e.getHTML&&(this._getHTML=e.getHTML),e.getFeatureDate&&(this._getFeatureDate=e.getFeatureDate),e.endFeatureDate&&(this._endFeatureDate=e.endFeatureDate),this.setFeatures(e.features||e.source,e.zoom)}setMap(e){super.setMap(e),this.refresh(this.get("zoom")||1,!0)}addButton(e){this.element.classList.add("ol-hasbutton"),ol.ext.element.create("BUTTON",{className:e.className||void 0,title:e.title,html:e.html,click:e.handleClick,parent:this._buttons})}setInterval(e){"string"==typeof e&&(e=/s$/.test(e)?1e3*parseFloat(e):/mn$/.test(e)?1e3*parseFloat(e)*60:/h$/.test(e)?1e3*parseFloat(e)*3600:/d$/.test(e)?1e3*parseFloat(e)*3600*24:/y$/.test(e)?1e3*parseFloat(e)*3600*24*365:0),this.set("interval",e||0),e?this.element.classList.add("ol-interval"):this.element.classList.remove("ol-interval"),this.refresh(this.get("zoom"))}_getHTML(e){return e.get("name")||""}_getFeatureDate(e){return e&&e.get?e.get("date"):null}_endFeatureDate(){}isCollapsed(){return this.element.classList.contains("ol-collapsed")}collapse(e){e?this.element.classList.add("ol-collapsed"):this.element.classList.remove("ol-collapsed"),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})}toggle(){this.element.classList.toggle("ol-collapsed"),this.dispatchEvent({type:"collapse",collapsed:this.isCollapsed()})}setFeatures(e,t){this._features=this._source=null,e instanceof ol.source.Vector?this._source=e:e instanceof Array?this._features=e:this._features=[],this.refresh(t)}getFeatures(){return this._features||this._source.getFeatures()}refresh(e,t){if(this.getMap()){e||(e=this.get("zoom")),e=Math.min(this.get("maxZoom"),Math.max(this.get("minZoom"),e||1)),this.set("zoom",e),this._scrollDiv.innerHTML="";var i,s,o=this.getFeatures(),r=this._tline=[];o.forEach(function(e){(i=this._getFeatureDate(e))&&(i instanceof Date||(i=new Date(i)),this._endFeatureDate&&((s=this._endFeatureDate(e))instanceof Date||(s=new Date(s))),isNaN(i)||r.push({date:i,end:isNaN(s)?null:s,feature:e}))}.bind(this)),r.sort(function(e,t){return e.date<t.date?-1:e.date===t.date?0:1});var a=ol.ext.element.create("DIV",{parent:this._scrollDiv}),n=this._minDate=Math.min(this.get("minDate"),r.length?r[0].date:1/0),l=this._maxDate=Math.max(this.get("maxDate"),r.length?r[r.length-1].date:-1/0);isFinite(n)||(this._minDate=n=new Date),isFinite(l)||(this._maxDate=l=new Date);var h=l-n,c=this.get("maxWidth"),u=this._scale=(h>c?c/h:1)*e;h=(l-(n=this._minDate=this._minDate-10/u))*u,ol.ext.element.setStyle(a,{width:h,maxWidth:"unset"}),this._drawTime(a,n,l,u),this.get("interval")?ol.ext.element.setStyle(this._intervalDiv,{width:this.get("interval")*u}):ol.ext.element.setStyle(this._intervalDiv,{width:""});var d=[],p=ol.ext.element.getStyle(this._scrollDiv,"lineHeight"),g=ol.ext.element.create("DIV",{className:"ol-features",parent:a});r.forEach(function(e){for(var t=e.date,i=e.elt=ol.ext.element.create("DIV",{className:"ol-feature",style:{left:Math.round((t-n)*u)},html:this._getHTML(e.feature),parent:g}),s=i.querySelectorAll("img"),o=0;o<s.length;o++)s[o].ondragstart=function(){return!1};e.end&&ol.ext.element.setStyle(i,{minWidth:(e.end-t)*u,width:(e.end-t)*u,maxWidth:"unset"});var r,a,l=ol.ext.element.getStyle(i,"left");for(i.addEventListener("click",function(){this._moving||this.dispatchEvent({type:"select",feature:e.feature})}.bind(this)),r=0;(a=d[r])&&!(l>a);r++);d[r]=l+ol.ext.element.getStyle(i,"width"),ol.ext.element.setStyle(i,{top:r*p})}.bind(this)),this._nbline=d.length,t&&this.setDate(this._minDate,{anim:!1,position:"start"}),this.dispatchEvent({type:"scroll",date:this.getDate(),dateStart:this.getDate("start"),dateEnd:this.getDate("end")})}}_getOffsetFromDate(e){return(e-this._minDate)*this._scale}_getDateFromOffset(e){return e/this._scale+this._minDate}_setScrollLeft(e){this._scrollLeft=e,void 0!==e&&(this._scrollDiv.scrollLeft=e)}_getScrollLeft(){return void 0===this._scrollLeft?this._scrollDiv.scrollLeft:this._scrollLeft}_drawTime(e,t,i,s){var o,r,a,n,l=ol.ext.element.create("DIV",{className:"ol-times",parent:e}),h=ol.ext.element.getStyle(l,"left"),c=ol.ext.element.getStyle(l,"height"),u=new Date(this._minDate).getFullYear();r=(new Date(0).setFullYear(String(u))-new Date(0).setFullYear(String(u-1)))*s;for(var d=Math.round(2*c/r)+1;!((o=new Date(0).setFullYear(u))>this._maxDate);)ol.ext.element.create("DIV",{className:"ol-time ol-year",style:{left:this._getOffsetFromDate(o)-h},html:u,parent:l}),u+=d;if(/day|month/.test(this.get("graduation"))&&(r=(new Date(0,0,1).setFullYear(String(u))-new Date(0,0,1).setFullYear(String(u-1)))*s,(n=Math.max(1,Math.round(12/Math.round(r/c/2))))<12))for(u=new Date(this._minDate).getFullYear(),a=n+1;(o=new Date(0,0,1)).setFullYear(u),o.setMonth(a-1),!(o>this._maxDate);)ol.ext.element.create("DIV",{className:"ol-time ol-month",style:{left:this._getOffsetFromDate(o)-h},html:o.toLocaleDateString(void 0,{month:"short"}),parent:l}),(a+=n)>12&&(u++,a=n+1);if("day"===this.get("graduation")){r=(new Date(0,1,1)-new Date(0,0,1))*s;var p=Math.max(1,Math.round(31/Math.round(r/c/2)));if(p<31){u=new Date(this._minDate).getFullYear(),a=0;for(var g=p;;)if((o=new Date(0,0,1)).setFullYear(u),o.setMonth(a),o.setDate(g),isNaN(o))++a>12&&(a=1,u++),g=p;else{if(o>this._maxDate)break;if(g>1){var m=this._getOffsetFromDate(o);this._getOffsetFromDate(new Date(u,a+1,1))-m>c&&ol.ext.element.create("DIV",{className:"ol-time ol-day",style:{left:m-h},html:g,parent:l})}u=o.getFullYear(),a=o.getMonth(),(g=o.getDate()+p)>new Date(u,a+1,0).getDate()&&(a++,g=p)}}}}setDate(e,t){var i;if(t=t||{},e instanceof Date?i=e:(this.getFeatures().indexOf(e)>=0&&(i=this._getFeatureDate(e)),!i||i instanceof Date||(i=new Date(i)),i&&!isNaN(i)||(i=new Date(String(e)))),!isNaN(i)){!1===t.anim&&this._scrollDiv.classList.add("ol-move");var s=this._getOffsetFromDate(i);if("start"===t.position?s+=ol.ext.element.outerWidth(this._scrollDiv)/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2:"end"===t.position&&(s-=ol.ext.element.outerWidth(this._scrollDiv)/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2),this._setScrollLeft(s),!1===t.anim&&this._scrollDiv.classList.remove("ol-move"),e)for(var o,r=0;o=this._tline[r];r++)o.feature===e?(o.elt.classList.add("ol-select"),this._select=o):o.elt.classList.remove("ol-select")}}roundDate(e,t){switch(t){case"mn":return new Date(this._roundTo(e,6e4));case"hour":return new Date(this._roundTo(e,36e5));case"day":return new Date(this._roundTo(e,864e5));case"month":return(e=new Date(this._roundTo(e,864e5))).getDate()>15&&(e=new Date(e.setMonth(e.getMonth()+1))),e=e.setDate(1),new Date(e);default:return new Date(e)}}getDate(e,t){var i;switch(t||(t=e),e){case"start":i=this.get("interval")?-ol.ext.element.getStyle(this._intervalDiv,"width")/2+ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2:-ol.ext.element.outerWidth(this._scrollDiv)/2+ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2;break;case"end":i=this.get("interval")?ol.ext.element.getStyle(this._intervalDiv,"width")/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2:ol.ext.element.outerWidth(this._scrollDiv)/2-ol.ext.element.getStyle(this._scrollDiv,"marginLeft")/2;break;default:i=0}var s=this._getDateFromOffset(this._getScrollLeft()+i);return s=this.roundDate(s,t),new Date(s)}_roundTo(e,t){return Math.round(e/t)*t}getStartDate(){return new Date(this.get("minDate"))}getEndDate(){return new Date(this.get("maxDate"))}},ol.control.VideoRecorder=class extends ol.control.Control{constructor(e){e=e||{};var t=ol.ext.element.create("DIV",{className:(e.className||"ol-videorec")+" ol-unselectable ol-control"});super({element:t,target:e.target}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-start",title:ol.control.VideoRecorder.prototype.tips.start,click:function(){this.start()}.bind(this),parent:t}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-stop",title:ol.control.VideoRecorder.prototype.tips.stop,click:function(){this.stop()}.bind(this),parent:t}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-pause",title:ol.control.VideoRecorder.prototype.tips.pause,click:function(){this.pause()}.bind(this),parent:t}),ol.ext.element.create("BUTTON",{type:"button",className:"ol-resume",title:ol.control.VideoRecorder.prototype.tips.resume,click:function(){this.resume()}.bind(this),parent:t}),this.set("framerate",30),this.set("videoBitsPerSecond",5e6),"DIALOG"===e.videoTarget?(this._dialog=new ol.control.Dialog({className:"ol-fullscreen-dialog",target:document.body,closeBox:!0}),this._videoTarget=this._dialog.getContentElement()):this._videoTarget=e.videoTarget,this._printCtrl=new ol.control.Print({target:ol.ext.element.create("DIV")})}setTooltip(e,t){var i=this.element.querySelector("button.ol-"+e);i&&(i.title=t)}setMap(e){this.getMap()&&(this.getMap().removeControl(this._printCtrl),this._dialog&&this.getMap().removeControl(this._dialog)),super.setMap(e),this.getMap()&&(this.getMap().addControl(this._printCtrl),this._dialog&&this.getMap().addControl(this._dialog))}start(){var e=this._printCtrl,t=!1;function i(s){t||e.fastPrint({canvas:s},i)}e.fastPrint({},function(e){var s;try{s=e.captureStream(this.get("framerate")||30)}catch(e){return void this.dispatchEvent({type:"error",error:e})}this._mediaRecorder=new MediaRecorder(s,{videoBitsPerSecond:this.get("videoBitsPerSecond")||5e6});var o=[];this._mediaRecorder.ondataavailable=function(e){o.push(e.data)},this._mediaRecorder.onstop=function(){t=!0;var e,i=new Blob(o,{type:"video/mp4"});(o=[],this._videoTarget instanceof Element)?("VIDEO"===this._videoTarget.tagName?e=this._videoTarget:(e=this._videoTarget.querySelector("video"))||(e=ol.ext.element.create("VIDEO",{controls:"",parent:this._videoTarget})),this._dialog&&this._dialog.show(),e.src=URL.createObjectURL(i),this.dispatchEvent({type:"stop",videoURL:e.src})):this.dispatchEvent({type:"stop",videoURL:URL.createObjectURL(i)})}.bind(this),this._mediaRecorder.onpause=function(){t=!0,this.dispatchEvent({type:"pause"})}.bind(this),this._mediaRecorder.onresume=function(){t=!1,i(e),this.dispatchEvent({type:"resume"})}.bind(this),this._mediaRecorder.onerror=function(e){this.dispatchEvent({type:"error",error:e})}.bind(this),t=!1,i(e),this._mediaRecorder.start(),this.dispatchEvent({type:"start",canvas:e}),this.element.setAttribute("data-state","rec")}.bind(this))}stop(){this._mediaRecorder&&(this._mediaRecorder.stop(),this._mediaRecorder=null,this.element.setAttribute("data-state","inactive"))}pause(){this._mediaRecorder&&(this._mediaRecorder.pause(),this.element.setAttribute("data-state","pause"))}resume(){this._mediaRecorder&&(this._mediaRecorder.resume(),this.element.setAttribute("data-state","rec"))}},ol.control.VideoRecorder.prototype.tips={start:"start video",stop:"stop",pause:"pause",resume:"resume"},ol.control.WMSCapabilities=class extends ol.control.Button{constructor(e){e=e||{};var t=Object.assign({},e||{});t.target===document.body&&delete t.target,t.target?(t.className=((t.className||"")+" ol-wmscapabilities ol-hidden").trim(),delete t.target):(t.className=((t.className||"")+" ol-wmscapabilities").trim(),t.handleClick=function(){i.showDialog()}),super(t);var i=this;this._proxy=e.proxy,this.set("srs",e.srs||[]),this.set("cors",e.cors),this.set("trace",e.trace),this.set("title",e.title),this.set("loadLabel",e.loadLabel),this.set("optional",e.optional),this.createDialog(e),this._elements.formVersion.value="1.0.0";var s=this._getParser();this._ajax=new ol.ext.Ajax({dataType:"text",auth:e.authentication}),this._ajax.on("success",function(e){var t;try{t=s.read(e.response)}catch(e){this.showError({type:"load",error:e})}t&&(t.Capability.Layer.Layer?(t.url=e.options.url,this.showCapabilities(t)):this.showError({type:"noLayer"})),this.dispatchEvent({type:"capabilities",capabilities:t}),"function"==typeof e.options.callback&&e.options.callback(t)}.bind(this)),this._ajax.on("error",function(e){this.showError({type:"load",error:e}),this.dispatchEvent({type:"capabilities"}),e.options.callback}.bind(this)),this._ajax.on("loadstart",function(){this._elements.element.classList.add("ol-searching")}.bind(this)),this._ajax.on("loadend",function(){this._elements.element.classList.remove("ol-searching")}.bind(this)),e.onselect&&this.on("load",function(t){e.onselect(t.layer,t.options)})}_getParser(){return new ol.format.WMSCapabilities}createDialog(e){var t=e.target;t&&t!==document.body||(this._dialog=new ol.control.Dialog({className:"ol-wmscapabilities",closeBox:!0,closeOnSubmit:!1,target:e.target}),this._dialog.on("button",function(e){"submit"===e.button&&this.getCapabilities(e.inputs.url.value)}.bind(this)),t=null);var i=ol.ext.element.create("DIV",{className:("ol-wmscapabilities "+(e.className||"")).trim(),parent:t});this._elements={element:t||i};var s=ol.ext.element.create("DIV",{className:"ol-url",parent:i}),o=this._elements.input=ol.ext.element.create("INPUT",{className:"url",type:"text",tabIndex:1,placeholder:e.placeholder||"service url...",autocorrect:"off",autocapitalize:"off",parent:s});if(o.addEventListener("keyup",function(t){13===t.keyCode&&this.getCapabilities(o.value,e)}.bind(this)),e.services){var r=ol.ext.element.create("SELECT",{className:"url",on:{change:function(t){var i=t.target.options[t.target.selectedIndex].value;this.getCapabilities(i,e),t.target.selectedIndex=0}.bind(this)},parent:s});for(var a in ol.ext.element.create("OPTION",{html:" ",parent:r}),e.services)ol.ext.element.create("OPTION",{html:a,value:e.services[a],parent:r})}ol.ext.element.create("BUTTON",{click:function(){this.getCapabilities(o.value,e)}.bind(this),html:e.searchLabel||"search",parent:s}),this._elements.error=ol.ext.element.create("DIV",{className:"ol-error",parent:s});var n=this._elements.result=ol.ext.element.create("DIV",{className:"ol-result",parent:i}),l=ol.ext.element.create("DIV",{className:"ol-preview",html:e.previewLabel||"preview",parent:n});this._elements.preview=ol.ext.element.create("IMG",{parent:l}),this._img=new Image,this._img.crossOrigin="Anonymous",this._img.addEventListener("error",function(){l.className="ol-preview tainted",this._elements.formCrossOrigin.checked=!1}.bind(this)),this._img.addEventListener("load",function(){l.className="ol-preview ok",this._elements.formCrossOrigin.checked=!0}.bind(this)),this._elements.select=ol.ext.element.create("SELECT",{className:"ol-select-list",on:{keydown:function(e){if("Enter"===e.key||" "===e.key){var t=this._elements.select.selectedIndex;t>=0&&this._elements.select.querySelectorAll("OPTION")[t].click()}}.bind(this)},size:100,parent:n}),this._elements.data=ol.ext.element.create("DIV",{className:"ol-data",parent:n}),this._elements.buttons=ol.ext.element.create("DIV",{className:"ol-buttons",parent:n}),this._elements.legend=ol.ext.element.create("IMG",{className:"ol-legend",parent:n});var h=this._elements.form=ol.ext.element.create("UL",{className:"ol-wmsform",parent:i}),c=function(e,t,i){var s=ol.ext.element.create("LI",{parent:h});if(ol.ext.element.create("LABEL",{html:this.labels[e],parent:s}),"boolean"==typeof t)this._elements[e]=ol.ext.element.create("INPUT",{type:"checkbox",checked:t,parent:s});else if(t instanceof Array){var o=this._elements[e]=ol.ext.element.create("SELECT",{parent:s});t.forEach(function(e){ol.ext.element.create("OPTION",{html:e,value:e,parent:o})}.bind(this))}else this._elements[e]=ol.ext.element.create("INPUT",{value:void 0===t?"":t,placeholder:i||"",type:"number"==typeof t?"number":"text",parent:s});return s}.bind(this);c("formTitle"),c("formLayer","","layer1,layer2,...");var u=c("formMap");u.setAttribute("data-param","map"),(u=c("formStyle")).setAttribute("data-param","style"),c("formFormat",["image/png","image/jpeg"]),c("formMinZoom",0),c("formMaxZoom",20),(u=c("formExtent","","xmin,ymin,xmax,ymax")).setAttribute("data-param","extent");var d=u.querySelector("input");return ol.ext.element.create("BUTTON",{title:this.labels.mapExtent,click:function(){d.value=this.getMap().getView().calculateExtent(this.getMap().getSize()).join(",")}.bind(this),parent:u}),(u=c("formProjection","")).setAttribute("data-param","proj"),c("formCrossOrigin",!1),(u=c("formVersion","1.3.0")).setAttribute("data-param","version"),c("formAttribution",""),ol.ext.element.create("BUTTON",{html:this.get("loadLabel")||"Load",click:function(){var e=this._getFormOptions(),t=this.getLayerFromOptions(e);this.dispatchEvent({type:"load",layer:t,options:e}),this._dialog.hide()}.bind(this),parent:h}),i}getLayerFromOptions(e){e.layer.source=new ol.source.TileWMS(e.source);var t=new ol.layer.Tile(e.layer);return delete e.layer.source,t}setMap(e){super.setMap(e),this._dialog&&this._dialog.setMap(e)}getDialog(){return this._dialog}showDialog(e,t){this.showError(),this._elements.formProjection.value||(this._elements.formProjection.value=this.getMap().getView().getProjection().getCode()),this._dialog&&this._dialog.show({title:void 0===this.get("title")?"WMS":this.get("title"),content:this._elements.element}),this.getCapabilities(e,t);var i=this._elements.select.querySelector(".selected");i&&(this._elements.select.scrollTop=i.offsetTop-20)}testUrl(e){return!!new RegExp("^(https?:\\/\\/)((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;&a-z\\d%_.~+=\\/-]*)?(\\#[-a-z\\d_]*)?$","i").test(e)}getRequestParam(e){return{SERVICE:"WMS",REQUEST:"GetCapabilities",VERSION:e.version||"1.3.0"}}getCapabilities(e,t){if(e)if(this.testUrl(e)){t=t||{};var i=(e=e.split("?"))[1];e=e[0],this._elements.formMap.value="",this._elements.formLayer.value="",this._elements.formStyle.value="",this._elements.formTitle.value="",this._elements.formProjection.value=this.getMap().getView().getProjection().getCode(),this._elements.formFormat.selectedIndex=0;var s=t.map||"",o={};i&&(i=i.replace(/^\?/,"").split("&")).forEach(function(e){if((e=e.split("="))[1]=decodeURIComponent(e[1]||""),/^map$/i.test(e[0])&&(s=e[1],this._elements.formMap.value=s),/^layers$/i.test(e[0])&&(this._elements.formLayer.value=e[1],this._elements.formTitle.value=e[1].split(",")[0]),/^style$/i.test(e[0])&&(this._elements.formStyle.value=e[1]),/^crs$/i.test(e[0])&&(this._elements.formProjection.value=e[1]),/^format$/i.test(e[0]))for(var t,i=0;t=this._elements.formFormat.options[i];i++)if(t.value===e[1]){this._elements.formFormat.selectedIndex=i;break}this.get("optional")&&this.get("optional").split(",").forEach(function(t){t===e[0]&&(o[t]=e[1])}.bind(this))}.bind(this)),this._optional=o;var r=this.getRequestParam(t),a=[];for(var n in s&&(r.MAP=s,a.push("map="+s)),o)r[n]=o[n],a.push(n+"="+o[n]);var l=this._elements.input.value=(e||"")+(a?"?"+a.join("&"):"");if(this.clearForm(),this._proxy){var h="";for(var c in r)h+=(h?"&":"")+c+"="+r[c];this._ajax.send(this._proxy,{url:h},{url:l,timeout:t.timeout||1e4,callback:t.onload,abort:!1})}else this._ajax.send(e,r,{url:l,timeout:t.timeout||1e4,callback:t.onload,abort:!1})}else this.showError({type:"badUrl"})}showError(e){this._elements.error.innerHTML=e?this.error[e.type]||"ERROR ("+e.type+")":"",e&&"load"===e.type?this._elements.form.classList.add("visible"):this._elements.form.classList.remove("visible")}clearForm(){this._elements.result.classList.remove("ol-visible"),this.showError(),this._elements.select.innerHTML="",this._elements.data.innerHTML="",this._elements.preview.src="",this._elements.legend.src="",this._elements.legend.classList.remove("visible")}showCapabilities(e){this._elements.result.classList.add("ol-visible");var t=[],i=function(s,o){o=o||0,s.Layer.forEach(function(r){r.Attribution||(r.Attribution=s.Attribution),r.EX_GeographicBoundingBox||(r.EX_GeographicBoundingBox=s.EX_GeographicBoundingBox);var a=ol.ext.element.create("OPTION",{className:(r.Layer?"ol-title ":"")+"level-"+o,html:r.Name||r.Title,title:r.Name||r.Title,click:function(){this._elements.buttons.innerHTML="",this._elements.data.innerHTML="",this._elements.legend.src=this._elements.preview.src="",this._elements.element.classList.remove("ol-form"),this.showError();var i=this.getOptionsFromCap(r,e),s=this.getLayerFromOptions(i);if(this._currentOptions=i,t.forEach(function(e){e.classList.remove("selected")}),a.classList.add("selected"),s){ol.ext.element.create("BUTTON",{html:this.get("loadLabel")||"Load",className:"ol-load",click:function(){this.dispatchEvent({type:"load",layer:s,options:i}),this._dialog&&this._dialog.hide()}.bind(this),parent:this._elements.buttons}),ol.ext.element.create("BUTTON",{className:"ol-wmsform",click:function(){this._elements.element.classList.toggle("ol-form")}.bind(this),parent:this._elements.buttons});var o=this.getMap().getView().getResolution(),n=this.getMap().getView().getCenter();this._elements.preview.src=s.getPreview(n,o,this.getMap().getView().getProjection()),this._img.src=this._elements.preview.src,ol.ext.element.create("p",{className:"ol-title",html:i.data.title,parent:this._elements.data}),ol.ext.element.create("p",{html:i.data.abstract,parent:this._elements.data}),i.data.legend&&i.data.legend.length?(this._elements.legend.src=i.data.legend[0],this._elements.legend.classList.add("visible")):(this._elements.legend.src="",this._elements.legend.classList.remove("visible"))}}.bind(this),parent:this._elements.select});t.push(a),r.Layer&&i(r,o+1)}.bind(this))}.bind(this);this._elements.select.innerHTML="",i(e.Capability.Layer)}getLayerResolution(e,t,i){var s="min"===e?"MinScaleDenominator":"MaxScaleDenominator";if(void 0!==t[s])return t[s]/(72/2.54*100);if(!t.Layer)return"min"===e?0:156543.03392804097;i="min"===e?156543.03392804097:0;for(var o=0;o<t.Layer.length;o++){var r=this.getLayerResolution(e,t.Layer[o],i);void 0!==r&&(i=Math[e](i,r))}return i}getOptionsFromCap(e,t){var i,s,o=t.Capability.Request.GetMap.Format,r=[/png/,/jpeg/,/gif/];for(s=0;s<3;s++){for(var a=0;a<o.length;a++)if(r[s].test(o[a])){i=o[a];break}if(i)break}i||(i=o[0]);var n=this.getMap().getView().getProjection().getCode();this.showError();var l=!1;e.CRS?e.CRS.indexOf(n)>=0?l=!0:e.CRS.indexOf("EPSG:4326")>=0?(n="EPSG:4326",l=!0):this.get("srs").forEach(function(t){e.CRS.indexOf(t)>=0&&(n=t,l=!0)}):l=!1,l||(this.showError({type:"srs"}),this.get("trace")&&console.log("BAD srs: ",e.CRS));var h=e.EX_GeographicBoundingBox;h&&(h=ol.proj.transformExtent(h,"EPSG:4326",this.getMap().getView().getProjection()));var c=[];e.Attribution&&e.Attribution.Title&&c.push('<a href="'+encodeURI(e.Attribution.OnlineResource)+'">&copy; '+e.Attribution.Title.replace(/</g,"&lt;")+"</a>");var u={title:e.Title,extent:h,queryable:e.queryable,abstract:e.Abstract,minResolution:this.getLayerResolution("min",e),maxResolution:this.getLayerResolution("max",e)||156543.03392804097},d={url:(t.Capability.Request.GetMap.DCPType[0].HTTP.Get.OnlineResource||"").replace(/service=wms&?/i,""),projection:n,attributions:c,crossOrigin:this.get("cors")?"anonymous":null,params:{LAYERS:e.Name,FORMAT:i,VERSION:t.version||"1.3.0"}};Object.keys(this._optional).forEach(e=>d.params[e]=this._optional[e]);var p=new ol.View({projection:this.getMap().getView().getProjection()});p.setResolution(u.minResolution);var g=Math.round(p.getZoom());p.setResolution(u.maxResolution);var m=Math.round(p.getZoom());if(this._fillForm({title:u.title,layers:d.params.LAYERS,format:d.params.FORMAT,minZoom:m,maxZoom:g,extent:h?h.join(","):"",projection:d.projection,attribution:d.attributions[0]||"",version:d.params.VERSION}),this.get("trace")){var f=JSON.stringify([d],null,"\t").replace(/\\"/g,'"');u.source="SOURCE";var v="new ol.layer.Tile ("+JSON.stringify(u,null,"\t")+")";v=v.replace(/\\"/g,'"').replace('"SOURCE"',"new ol.source.TileWMS("+f+")").replace(/\\t/g,"\t").replace(/\\n/g,"\n").replace("([\n\t","(").replace("}\n])","})"),console.log(v),delete u.source}var y=[];return e.Style&&e.Style.forEach(function(e){e.LegendURL&&y.push(e.LegendURL[0].OnlineResource)}),{layer:u,source:d,data:{title:e.Title,abstract:e.Abstract,logo:e.Attribution&&e.Attribution.LogoURL?e.Attribution.LogoURL.OnlineResource:void 0,keyword:e.KeywordList,legend:y,opaque:e.opaque,queryable:e.queryable}}}_getFormOptions(){var e=parseInt(this._elements.formMinZoom.value),t=parseInt(this._elements.formMaxZoom.value),i=new ol.View({projection:this.getMap().getView().getProjection()});i.setZoom(e);var s=i.getResolution();i.setZoom(t);var o=i.getResolution(),r=[];this._elements.formExtent.value&&this._elements.formExtent.value.split(",").forEach(function(e){r.push(parseFloat(e))}),4!==r.length&&(r=void 0);var a=[];this._elements.formAttribution.value&&a.push(this._elements.formAttribution.value);var n={layer:{title:this._elements.formTitle.value,extent:r,maxResolution:s,minResolution:o},source:{url:this._elements.input.value,crossOrigin:this._elements.formCrossOrigin.checked?"anonymous":null,projection:this._elements.formProjection.value,attributions:a,params:{FORMAT:this._elements.formFormat.options[this._elements.formFormat.selectedIndex].value,LAYERS:this._elements.formLayer.value,VERSION:this._elements.formVersion.value}},data:{title:this._elements.formTitle.value}};return Object.keys(this._optional).forEach(e=>n.source.params[e]=this._optional[e]),this._elements.formMap.value&&(n.source.params.MAP=this._elements.formMap.value),n}_fillForm(e){var t,i;for(this._elements.formTitle.value=e.title,this._elements.formLayer.value=e.layers,this._elements.formStyle.value=e.style,i=0;t=this._elements.formFormat.options[i];i++)if(t.value===e.format){this._elements.formFormat.selectedIndex=i;break}this._elements.formExtent.value=e.extent||"",this._elements.formMaxZoom.value=e.maxZoom,this._elements.formMinZoom.value=e.minZoom,this._elements.formProjection.value=e.projection,this._elements.formAttribution.value=e.attribution,this._elements.formVersion.value=e.version}loadLayer(e,t,i){this.getCapabilities(e,{onload:function(e){e?e.Capability.Layer.Layer.forEach(function(s){if(s.Name===t||s.Identifier===t){var o=this.getOptionsFromCap(s,e),r=this.getLayerFromOptions(o);this.dispatchEvent({type:"load",layer:r,options:o}),"function"==typeof i&&i({layer:r,options:o})}}.bind(this)):this.dispatchEvent({type:"load",error:!0})}.bind(this)})}},ol.control.WMSCapabilities.prototype.error={load:"Can't retrieve service capabilities, try to add it manually...",badUrl:"The input value is not a valid url...",TileMatrix:"No TileMatrixSet supported...",noLayer:"No layer available for this service...",srs:"The service projection looks different from that of your map, it may not display correctly..."},ol.control.WMSCapabilities.prototype.labels={formTitle:"Title:",formLayer:"Layers:",formMap:"Map:",formStyle:"Style:",formFormat:"Format:",formMinZoom:"Min zoom level:",formMaxZoom:"Max zoom level:",formExtent:"Extent:",mapExtent:"use map extent...",formProjection:"Projection:",formCrossOrigin:"CrossOrigin:",formVersion:"Version:",formAttribution:"Attribution:"},ol.control.WMTSCapabilities=class extends ol.control.WMSCapabilities{constructor(e){(e=e||{}).title=e.title||"WMTS",super(e),this.getDialog().set("className",this.getDialog().get("className")+" ol-wmtscapabilities")}_getParser(){var e=new ol.format.WMTSCapabilities;return{read:function(t){var i=e.read(t);i.Capability={Layer:i.Contents},i.Capability.Layer.Attribution={Title:i.ServiceProvider.ProviderName};var s=[];return i.Contents.Layer.forEach(function(e){e.Format&&/jpeg|png/.test(e.Format[0])&&s.push(e)}),i.Contents.Layer=s,i}.bind(this)}}getRequestParam(e){return{SERVICE:"WMTS",REQUEST:"GetCapabilities",VERSION:e.version||"1.0.0"}}_getTG(e,t,i,s){for(var o=new Array,r=new Array,a=ol.extent.getWidth(ol.proj.get("EPSG:3857").getExtent())/256,n=0;n<=(i||20);n++){var l=s?e+":"+n:n;o[n]=l,r[n]=a/Math.pow(2,n)}return{origin:[-20037508,20037508],resolutions:r,matrixIds:o,minZoom:t||0}}getTileGrid(e,t,i,s){return new ol.tilegrid.WMTS(this._getTG(e,t,i,s))}isSupportedSet(e){return!!/^PM_.*/.test(e.TileMatrixSet)||this.supportedSets.indexOf(e.TileMatrixSet)>=0}getOptionsFromCap(e,t){var i=e.WGS84BoundingBox;i&&(i=ol.proj.transformExtent(i,"EPSG:4326",this.getMap().getView().getProjection()));var s,o=1/0,r=-1/0;if(e.TileMatrixSetLink.forEach(function(t){this.isSupportedSet(t)&&(s=t,e.TileMatrixSet=t.TileMatrixSet)}.bind(this)),s){if(s.TileMatrixSetLimits){var a=s.TileMatrixSetLimits[0].TileMatrix.split(":").length>1;s.TileMatrixSetLimits.forEach(function(e){var t=e.TileMatrix.split(":").pop();o=Math.min(o,parseInt(t)),r=Math.max(r,parseInt(t))})}else o=0,r=20;var n=new ol.View;n.setZoom(o);var l={title:e.Title,extent:i,abstract:e.Abstract,maxResolution:n.getResolution()},h={url:t.url,layer:e.Identifier,matrixSet:e.TileMatrixSet,format:e.Format[0]||"image/jpeg",projection:"EPSG:3857",tilePrefix:a,minZoom:o,maxZoom:r,style:e.Style?e.Style[0].Identifier:"normal",attributions:e.Attribution.Title,crossOrigin:this.get("cors")?"anonymous":null,wrapX:!1!==this.get("wrapX")};if(this._fillForm({title:l.title,layers:h.layer,style:h.style,format:h.format,minZoom:o,maxZoom:r,extent:i?i.join(","):"",projection:h.projection,attribution:h.attributions||"",version:"1.0.0"}),this.get("trace")){h.tileGrid="TILEGRID";var c=JSON.stringify([h],null,"\t").replace(/\\"/g,'"');c=c.replace('"TILEGRID"',"new ol.tilegrid.WMTS("+JSON.stringify(this._getTG(h.matrixSet,h.minZoom,h.maxZoom,h.tilePrefix),null,"\t").replace(/\n/g,"\n\t\t")+")"),delete h.tileGrid,l.source="SOURCE";var u="new ol.layer.Tile ("+JSON.stringify(l,null,"\t")+")";u=u.replace(/\\"/g,'"').replace('"SOURCE"',"new ol.source.WMTS("+c+")").replace(/\\t/g,"\t").replace(/\\n/g,"\n").replace(/"tileGrid": {/g,'"tileGrid": new ol.tilegrid.WMTS({').replace(/},\n(\t*)"style"/g,'}),\n$1"style"').replace("([\n\t","(").replace("}\n])","})"),console.log(u),delete l.source}var d=void 0;return e.Style&&e.Style[0]&&e.Style[0].LegendURL&&e.Style[0].LegendURL[0]&&(d=[e.Style[0].LegendURL[0].href]),{layer:l,source:h,data:{title:e.Title,abstract:e.Abstract,legend:d}}}this.showError({type:"TileMatrix"})}_getFormOptions(){var e=this._currentOptions||{};e.layer||(e.layer={}),e.source||(e.source={}),e.data||(e.data={});var t=parseInt(this._elements.formMinZoom.value)||0,i=parseInt(this._elements.formMaxZoom.value)||20,s=[];this._elements.formExtent.value&&this._elements.formExtent.value.split(",").forEach(function(e){s.push(parseFloat(e))}),4!==s.length&&(s=void 0);var o=[];this._elements.formAttribution.value&&o.push(this._elements.formAttribution.value);var r=new ol.View({projection:this.getMap().getView().getProjection()});return r.setZoom(t),{layer:{title:this._elements.formTitle.value,extent:s,abstract:e.layer.abstract||"",maxResolution:r.getResolution()},source:{url:this._elements.input.value,layer:this._elements.formLayer.value,matrixSet:e.source.matrixSet||"PM",format:this._elements.formFormat.options[this._elements.formFormat.selectedIndex].value,projection:"EPSG:3857",minZoom:t,maxZoom:i,style:this._elements.formStyle.value||"normal",attributions:o,crossOrigin:this._elements.formCrossOrigin.checked?"anonymous":null,wrapX:!1!==this.get("wrapX")},data:{title:this._elements.formTitle.value,abstract:e.data.abstract,legend:e.data.legend}}}getLayerFromOptions(e){if(e){e.source.tileGrid=this.getTileGrid(e.source.matrixSet,e.source.minZoom,e.source.maxZoom,e.source.tilePrefix),e.layer.source=new ol.source.WMTS(e.source);var t=new ol.layer.Tile(e.layer);return delete e.layer.source,delete e.source.tileGrid,t}}},ol.control.WMSCapabilities.prototype.supportedSets=["PM","3857","EPSG:3857","EPSG:900913","webmercator","GoogleMapsCompatible"],ol.featureAnimation=class extends ol.Object{constructor(e){e=e||{},super(),this.duration_="number"==typeof e.duration?e.duration>=0?e.duration:0:1e3,this.fade_="function"==typeof e.fade?e.fade:null,this.repeat_=Number(e.repeat);var t="function"==typeof e.easing?e.easing:ol.easing.linear;e.revers?this.easing_=function(e){return 1-t(e)}:this.easing_=t,this.hiddenStyle=e.hiddenStyle}drawGeom_(e,t,i){var s={type:"drawing",time:e.time,feature:e.feature,start:e.start,stop:e.stop,rotation:e.rotation,style:e.style,extra:e.extra};this.dispatchEvent(s);var o=s.style instanceof Array?s.style:[s.style];this.fade_&&(e.context.globalAlpha=this.fade_(1-e.elapsed));for(var r=0;r<o.length;r++)try{var a=e.vectorContext||ol.render.getVectorContext(e),n=ol.ext.getVectorContextStyle(e,o[r]);a.setStyle(n),n.getZIndex()<0?a.drawGeometry(i||t):a.drawGeometry(t)}catch(e){}}animate(){return!1}},ol.featureAnimation.hiddenStyle=new ol.style.Style({image:new ol.style.Circle({}),stroke:new ol.style.Stroke({color:"transparent"})}),ol.Map.prototype.animateFeature=function(e,t){var i=this._featureAnimationLayer;i||(i=this._featureAnimationLayer=new ol.layer.Vector({source:new ol.source.Vector})).setMap(this),i.getSource().addFeature(e);var s=t.on("animationend",function(t){t.feature===e&&(i.getSource().removeFeature(e),ol.Observable.unByKey(s))});return i.animateFeature(e,t)},ol.layer.Base.prototype.animateFeature=function(e,t,i){var s,o=this,r=e.getStyle(),a=r||(this.getStyleFunction?this.getStyleFunction()(e):null);a||(a=[]),a instanceof Array||(a=[a]);var n={vectorContext:null,frameState:null,start:0,time:0,elapsed:0,extent:!1,feature:e,geom:e.getGeometry(),typeGeom:e.getGeometry().getType(),bbox:e.getGeometry().getExtent(),coord:ol.extent.getCenter(e.getGeometry().getExtent()),style:a};t instanceof Array||(t=[t]);for(var l=t.length-1;l>=0;l--)0===t[l].duration_&&t.splice(l,1);var h=0,c=0,u=i&&this.getFilters?this.getFilters():[];function d(i){ol.Observable.unByKey(s),s=null,e.setStyle(r),n.stop=(new Date).getTime();var a={type:"animationend",feature:e};if(i)for(var l in i)i.hasOwnProperty(l)&&(a[l]=i[l]);t[c].dispatchEvent(a),o.dispatchEvent(a)}function p(i){if(t.length&&!s){if(n.stop&&(n.start=(new Date).getTime()-n.stop+n.start,n.stop=0),s=o.on(["postcompose","postrender"],function(i){n.type=i.type;try{n.vectorContext=i.vectorContext||ol.render.getVectorContext(i)}catch(i){}if(n.frameState=i.frameState,n.inversePixelTransform=i.inversePixelTransform,n.extent||(n.extent=i.frameState.extent,n.start=i.frameState.time,n.context=i.context),n.time=i.frameState.time-n.start,n.elapsed=n.time/t[c].duration_,n.elapsed>1&&(n.elapsed=1),i.context.save(),u.forEach(function(e){e.get("active")&&e.precompose(i)}),this.getOpacity&&(i.context.globalAlpha=this.getOpacity()),t[c].animate(n)){var s={type:"animating",step:c,start:n.start,time:n.time,elapsed:n.elapsed,rotation:n.rotation||0,geom:n.geom,coordinate:n.coord,feature:e,extra:n.extra||{},style:a};t[c].dispatchEvent(s),o.dispatchEvent(s)}else++h<t[c].repeat_?(n.extent=!1,t[c].dispatchEvent({type:"animationrepeat",feature:e})):c<t.length-1?(t[c].dispatchEvent({type:"animationend",feature:e}),c++,h=0,n.extent=!1):d();u.forEach(function(e){e.get("active")&&e.postcompose(i)}),i.context.restore(),i.frameState.animate=!0}.bind(o)),o.renderSync)try{o.renderSync()}catch(e){}else o.changed();e.setStyle(t[c].hiddenStyle||ol.featureAnimation.hiddenStyle);var r={type:"animationstart",feature:e};if(i)for(var l in i)i.hasOwnProperty(l)&&(r[l]=i[l]);t[c].dispatchEvent(r),o.dispatchEvent(r)}}return p(),{start:p,stop:d,isPlaying:function(){return!!s}}},ol.featureAnimation.Blink=class extends ol.featureAnimation{constructor(e){super(e),this.set("nb",e.nb||10)}animate(e){return Math.round(this.easing_(e.elapsed)*this.get("nb"))%2||this.drawGeom_(e,e.geom),e.time<=this.duration_}},ol.featureAnimation.Bounce=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.amplitude_=e.amplitude||40,this.bounce_=-Math.PI*(e.bounce||3)}animate(e){var t=e.geom.clone(),i=Math.abs(Math.sin(this.bounce_*e.elapsed))*this.amplitude_*(1-this.easing_(e.elapsed))*e.frameState.viewState.resolution;return t.translate(0,i),this.drawGeom_(e,t,e.geom),e.time<=this.duration_}},ol.featureAnimation.Drop=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.speed_=e.speed||0,this.side_=e.side||"top"}animate(e){if(!e.time){var t=e.frameState.viewState.rotation,i=e.frameState.size[1]*e.frameState.viewState.resolution;"top"!=this.side_&&(i*=-1),this.dx=-Math.sin(t)*i,this.dy=Math.cos(t)*i,this.speed_&&(this.duration_=i/this.speed_/e.frameState.viewState.resolution)}var s=e.geom.clone();return s.translate(this.dx*(1-this.easing_(e.elapsed)),this.dy*(1-this.easing_(e.elapsed))),this.drawGeom_(e,s,e.geom),e.time<=this.duration_}},ol.featureAnimation.Fade=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.speed_=e.speed||0}animate(e){return e.context.globalAlpha=this.easing_(e.elapsed),this.drawGeom_(e,e.geom),e.time<=this.duration_}},ol.featureAnimation.None=class extends ol.featureAnimation{constructor(e){super(e)}animate(e){return e.time<=this.duration_}},ol.featureAnimation.Null=class extends ol.featureAnimation{constructor(){super({duration:0})}},ol.featureAnimation.Path=class extends ol.featureAnimation{constructor(e){switch(super(e=e||{}),this.speed_=e.speed||0,this.path_=e.path,e.rotate){case!0:case 0:this.rotate_=0;break;default:this.rotate_=e.rotate||!1}this.path_&&this.path_.getGeometry&&(this.path_=this.path_.getGeometry()),this.path_&&this.path_.getLineString&&(this.path_=this.path_.getLineString()),this.path_.getLength?(this.dist_=this.path_.getLength(),this.path_&&this.path_.getCoordinates&&(this.path_=this.path_.getCoordinates())):this.dist_=0,this.speed_>0&&(this.duration_=this.dist_/this.speed_)}animate(e){if(!e.time&&!this.dist_)return!1;var t,i,s,o,r,a,n=this.dist_*this.easing_(e.elapsed),l=0;i=this.path_[0];for(var h=1;h<this.path_.length;h++){if(t=i,o=(i=this.path_[h])[0]-t[0],r=i[1]-t[1],(a=Math.sqrt(o*o+r*r))&&l+a>=n){e.extra={index:h,coordinates:i},s=(n-l)/a,i=[t[0]+(i[0]-t[0])*s,t[1]+(i[1]-t[1])*s];break}l+=a}var c=e.style;if(e.rotation=Math.PI/2+Math.atan2(t[1]-i[1],t[0]-i[0]),!1!==this.rotate_){var u=[],d=this.rotate_-e.rotation+e.frameState.viewState.rotation;e.rotation=Math.PI/2+Math.atan2(t[1]-i[1],t[0]-i[0]);for(var p=0;s=e.style[p];p++)s.getImage()&&s.getImage().setRotation(d),u.push(s);e.style=u}return e.geom.setCoordinates(i),this.drawGeom_(e,e.geom),e.style=c,e.time<=this.duration_}},ol.featureAnimation.Shake=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.amplitude_=e.amplitude||40,this.bounce_=-Math.PI*(e.bounce||6),this.horizontal_=e.horizontal}animate(e){var t=e.geom.clone(),i=e.geom.clone(),s=this.easing_(e.elapsed);return s=Math.sin(this.bounce_*s)*this.amplitude_*(1-s)*e.frameState.viewState.resolution,this.horizontal_?(t.translate(s,0),i.translate(s,0)):t.translate(0,s),this.drawGeom_(e,t,i),e.time<=this.duration_}},ol.featureAnimation.Show=class extends ol.featureAnimation{constructor(e){super(e)}animate(e){return this.drawGeom_(e,e.geom),e.time<=this.duration_}},ol.featureAnimation.Slide=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.speed_=e.speed||0,this.side_=e.side||"left"}animate(e){e.time||("left"==this.side_?this.dx=e.extent[0]-e.bbox[2]:this.dx=e.extent[2]-e.bbox[0],this.speed_&&(this.duration_=Math.abs(this.dx)/this.speed_/e.frameState.viewState.resolution));var t=e.geom.clone();return t.translate(this.dx*(1-this.easing_(e.elapsed)),0),this.drawGeom_(e,t),e.time<=this.duration_}},ol.featureAnimation.Teleport=class extends ol.featureAnimation{constructor(e){super(e)}animate(e){var t=this.easing_(e.elapsed);if(t){e.context.save();var i=e.frameState.pixelRatio;e.context.globalAlpha=t,e.context.scale(t,1/t);var s=e.frameState.coordinateToPixelTransform,o=(1/t-1)*i*(s[0]*e.coord[0]+s[1]*e.coord[1]+s[4]),r=(t-1)*i*(s[2]*e.coord[0]+s[3]*e.coord[1]+s[5]);e.context.translate(o,r),this.drawGeom_(e,e.geom),e.context.restore()}return e.time<=this.duration_}},ol.featureAnimation.Throw=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.speed_=e.speed||0,this.side_=e.side||"left"}animate(e){var t,i;!e.time&&this.speed_&&("left"==this.side_?(t=this.dx=e.extent[0]-e.bbox[2],i=this.dy=e.extent[3]-e.bbox[1]):(t=this.dx=e.extent[2]-e.bbox[0],i=this.dy=e.extent[3]-e.bbox[1]),this.duration_=Math.sqrt(t*t+i*i)/this.speed_/e.frameState.viewState.resolution);var s=e.geom.clone(),o=e.geom.clone();return s.translate(this.dx*(1-this.easing_(e.elapsed)),this.dy*Math.cos(Math.PI/2*this.easing_(e.elapsed))),o.translate(this.dx*(1-this.easing_(e.elapsed)),0),this.drawGeom_(e,s,o),e.time<=this.duration_}},ol.featureAnimation.Zoom=class extends ol.featureAnimation{constructor(e){super(e=e||{}),this.set("zoomout",e.zoomOut)}animate(e){var t=this.easing_(e.elapsed);if(t){this.get("zoomout")&&(t=1/t);var i,s,o=e.style,r=[];for(i=0;i<o.length;i++)(s=o[i].getImage())&&(r[i]=s.getScale(),"postrender"===e.type?s.setScale(r[i]*t/e.frameState.pixelRatio):s.setScale(r[i]*t));for(this.drawGeom_(e,e.geom),i=0;i<o.length;i++)(s=o[i].getImage())&&s.setScale(r[i])}return e.time<=this.duration_}},ol.featureAnimation.ZoomOut=class extends ol.featureAnimation.Zoom{constructor(e){(e=e||{}).zoomOut=!0,super(e)}},ol.filter={},ol.filter.Base=class extends ol.Object{constructor(e){super(e),this._listener=[],e&&!1===e.active?this.set("active",!1):this.set("active",!0)}setActive(e){this.set("active",!0===e)}getActive(){return this.get("active")}},function(){function e(){if(this.renderSync)try{this.renderSync()}catch(e){}else this.changed()}function t(t){this.filters_||(this.filters_=[]),this.filters_.push(t),t.addToLayer&&t.addToLayer(this),t.precompose&&t._listener.push({listener:this.on(["precompose","prerender"],function(e){this.get("active")&&e.context&&this.precompose(e)}.bind(t)),target:this}),t.postcompose&&t._listener.push({listener:this.on(["postcompose","postrender"],function(e){this.get("active")&&e.context&&this.postcompose(e)}.bind(t)),target:this}),t._listener.push({listener:t.on("propertychange",e.bind(this)),target:this}),e.call(this)}function i(t){var i;if(this.filters_||(this.filters_=[]),t){for(i=this.filters_.length-1;i>=0;i--)this.filters_[i]===t&&this.filters_.splice(i,1);for(i=t._listener.length-1;i>=0;i--)t._listener[i].target===this&&(t.removeFromLayer&&t.removeFromLayer(this),ol.Observable.unByKey(t._listener[i].listener),t._listener.splice(i,1));e.call(this)}else this.filters_.forEach(function(e){this.removeFilter(e)}.bind(this))}ol.Map.prototype.addFilter=function(e){console.warn("[OL-EXT] addFilter deprecated on map."),t.call(this,e)},ol.Map.prototype.removeFilter=function(e){i.call(this,e)},ol.Map.prototype.getFilters=function(){return this.filters_||[]},ol.layer.Base.prototype.addFilter=function(e){t.call(this,e)},ol.layer.Base.prototype.removeFilter=function(e){i.call(this,e)},ol.layer.Base.prototype.getFilters=function(){return this.filters_||[]}}(),ol.filter.Mask=class extends ol.filter.Base{constructor(e){if(super(e=e||{}),e.feature)switch(e.feature.getGeometry().getType()){case"Polygon":case"MultiPolygon":this.feature_=e.feature}this.set("inner",e.inner),this._fillColor=e.fill&&ol.color.asString(e.fill.getColor())||"rgba(0,0,0,0.2)",this._shadowColor=e.shadowColor&&ol.color.asString(e.shadowColor)||"rgba(0,0,0,0.5)",this.set("shadowWidth",e.shadowWidth||0),this.set("shadowMapUnits",!0===e.shadowMapUnits)}setFillColor(e){this._fillColor=e&&ol.color.asString(e)||"rgba(0,0,0,0.2)"}setShadowColor(e){this._shadowColor=e&&ol.color.asString(e)||"rgba(0,0,0,0.5)"}drawFeaturePath_(e,t){var i,s=e.context,o=s.canvas,r=e.frameState.pixelRatio;if(e.frameState.coordinateToPixelTransform){var a=e.frameState.coordinateToPixelTransform;if(e.inversePixelTransform){var n=e.inversePixelTransform;i=function(e){return[(e=[e[0]*a[0]+e[1]*a[1]+a[4],e[0]*a[2]+e[1]*a[3]+a[5]])[0]*n[0]-e[1]*n[1]+n[4],-e[0]*n[2]+e[1]*n[3]+n[5]]}}else i=function(e){return[(e[0]*a[0]+e[1]*a[1]+a[4])*r,(e[0]*a[2]+e[1]*a[3]+a[5])*r]}}else a=e.frameState.coordinateToPixelMatrix,i=function(e){return[(e[0]*a[0]+e[1]*a[1]+a[12])*r,(e[0]*a[4]+e[1]*a[5]+a[13])*r]};var l=this.feature_.getGeometry().getCoordinates();function h(e){for(var t=0;t<l.length;t++)for(var o=l[t],r=0;r<o.length;r++){var a=i([o[r][0][0]+e,o[r][0][1]]);s.moveTo(a[0],a[1]);for(var n=1;n<o[r].length;n++)a=i([o[r][n][0]+e,o[r][n][1]]),s.lineTo(a[0],a[1])}}if("Polygon"===this.feature_.getGeometry().getType()&&(l=[l]),s.beginPath(),t&&(s.moveTo(-100,-100),s.lineTo(o.width+100,-100),s.lineTo(o.width+100,o.height+100),s.lineTo(-100,o.height+100),s.lineTo(-100,-100)),this.get("wrapX")){var c=e.frameState.viewState.projection.getExtent(),u=c[2]-c[0],d=e.frameState.extent,p=this.feature_.getGeometry().getExtent(),g=p[2]-p[1],m=Math.floor((d[0]-g-c[0])/u),f=Math.floor((d[2]+g-c[2])/u)+1;m>f&&([m,f]=[f,m]);for(var v=m;v<=f;v++)h(v*u)}else h(0)}postcompose(e){if(this.feature_){var t=e.context;if(t.save(),this.drawFeaturePath_(e,!this.get("inner")),t.fillStyle=this._fillColor,t.fill("evenodd"),this.get("shadowWidth")){var i=this.get("shadowWidth")*e.frameState.pixelRatio;this.get("shadowMapUnits")&&(i/=e.frameState.viewState.resolution),t.clip("evenodd"),t.filter="blur("+i+"px)",t.strokeStyle=this._shadowColor,t.lineCap="round",t.lineJoin="round",t.lineWidth=i,t.stroke()}t.restore()}}},ol.filter.CSS=class extends ol.filter.Base{constructor(e){super(e),this._layers=[]}setBlend(e){this.set("blend",e),this._layers.forEach(function(t){t.once("postrender",function(t){t.context.canvas.parentNode.style["mix-blend-mode"]=e||""}.bind(this)),t.changed()})}setFilter(e){this.set("filter",e),this._layers.forEach(function(t){t.once("postrender",function(t){t.context.canvas.parentNode.style.filter=e||""}.bind(this)),t.changed()})}setDisplay(e){this.set("display",e),this._layers.forEach(function(t){t.once("postrender",function(t){t.context.canvas.parentNode.style.display=e?"":"none"}.bind(this)),t.changed()})}addToLayer(e){e.once("postrender",function(e){e.context.canvas.parentNode.style["mix-blend-mode"]=this.get("blend")||"",e.context.canvas.parentNode.style.filter=this.get("filter")||"",e.context.canvas.parentNode.style.display=!1!==this.get("display")?"":"none"}.bind(this)),e.changed(),this._layers.push(e)}removeFromLayer(e){var t=this._layers.indexOf(e);t>=0&&(e.once("postrender",function(e){e.context.canvas.parentNode.style["mix-blend-mode"]="",e.context.canvas.parentNode.style.filter="",e.context.canvas.parentNode.style.display=""}.bind(this)),e.changed(),this._layers.splice(t,1))}},ol.filter.CanvasFilter=class extends ol.filter.Base{constructor(e){super(e),this._svg={}}addSVGFilter(e){e.getId&&(e="#"+e.getId()),this._svg[e]=1,this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})}removeSVGFilter(e){e.getId&&(e="#"+e.getId()),delete this._svg[e],this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})}precompose(){}postcompose(e){var t=[];for(var i in void 0!==this.get("url")&&t.push("url("+this.get("url")+")"),this._svg)t.push("url("+i+")");void 0!==this.get("blur")&&t.push("blur("+this.get("blur")+"px)"),void 0!==this.get("brightness")&&t.push("brightness("+this.get("brightness")+"%)"),void 0!==this.get("contrast")&&t.push("contrast("+this.get("contrast")+"%)"),void 0!==this.get("shadow")&&t.push("drop-shadow("+this.get("shadow")[0]+"px "+this.get("shadow")[1]+"px "+(this.get("shadowBlur")||0)+"px "+this.get("shadowColor")+")"),void 0!==this.get("grayscale")&&t.push("grayscale("+this.get("grayscale")+"%)"),void 0!==this.get("sepia")&&t.push("sepia("+this.get("sepia")+"%)"),void 0!==this.get("hueRotate")&&t.push("hue-rotate("+this.get("hueRotate")+"deg)"),void 0!==this.get("invert")&&t.push("invert("+this.get("invert")+"%)"),void 0!==this.get("saturate")&&t.push("saturate("+this.get("saturate")+"%)"),(t=t.join(" "))&&(e.context.save(),e.context.filter=t,e.context.drawImage(e.context.canvas,0,0),e.context.restore())}},ol.filter.Clip=class extends ol.filter.Base{constructor(e){if(super(e=e||{}),this.set("coords",e.coords),this.set("units",e.units),this.set("keepAspectRatio",e.keepAspectRatio),this.set("extent",e.extent||[0,0,1,1]),this.set("color",e.color),!e.extent&&"%"!=e.units&&e.coords){for(var t,i=1/0,s=1/0,o=-1/0,r=-1/0,a=0;t=e.coords[a];a++)i>t[0]&&(i=t[0]),o<t[0]&&(o=t[0]),s>t[1]&&(s=t[1]),r<t[1]&&(r=t[1]);e.extent=[i,s,o,r]}}clipPath_(e){var t=e.context,i=e.frameState.size,s=this.get("coords");if(s){var o=this.get("extent"),r=1,a=1;"%"==this.get("units")&&(r=i[0]/(o[2]-o[0]),a=i[1]/(o[3]-o[1])),this.get("keepAspectRatio")&&(r=a=Math.min(r,a));var n=this.get("position"),l=0,h=0;/left/.test(n)?l=-o[0]*r:/center/.test(n)?l=i[0]/2-(o[2]-o[0])*r/2:/right/.test(n)&&(l=i[0]-(o[2]-o[0])*r);var c=function(e){return e*r+l};/top/.test(n)?h=-o[1]*a:/middle/.test(n)?h=i[1]/2-(o[3]-o[1])*a/2:/bottom/.test(n)&&(h=i[1]-(o[3]-o[1])*a);var u=function(e){return e*a+h},d=[c(s[0][0]),u(s[0][1])],p=e.inversePixelTransform;p&&(d=[d[0]*p[0]-d[1]*p[1]+p[4],-d[0]*p[2]+d[1]*p[3]+p[5]]),t.moveTo(d[0],d[1]);for(var g,m=1;g=s[m];m++)d=[c(g[0]),u(g[1])],p&&(d=[d[0]*p[0]-d[1]*p[1]+p[4],-d[0]*p[2]+d[1]*p[3]+p[5]]),t.lineTo(d[0],d[1]);d=[c(s[0][0]),u(s[0][1])],p&&(d=[d[0]*p[0]-d[1]*p[1]+p[4],-d[0]*p[2]+d[1]*p[3]+p[5]]),t.moveTo(d[0],d[1])}}precompose(e){this.get("color")||(e.context.save(),e.context.beginPath(),this.clipPath_(e),e.context.clip())}postcompose(e){if(this.get("color")){var t=e.context,i=e.context.canvas;t.save(),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i.height),t.lineTo(i.width,i.height),t.lineTo(i.width,i.height),t.lineTo(i.width,0),t.lineTo(0,0),this.clipPath_(e),t.fillStyle=this.get("color"),t.fill("evenodd")}e.context.restore()}},ol.filter.Colorize=class extends ol.filter.Base{constructor(e){super(e),this.setFilter(e)}setFilter(e){switch(e=e||{}){case"grayscale":e={operation:"hue",color:[0,0,0],value:1};break;case"invert":e={operation:"difference",color:[255,255,255],value:1};break;case"sepia":e={operation:"color",color:[153,102,51],value:.6}}var t,i=e.color?ol.color.asArray(e.color):[e.red,e.green,e.blue,e.value];switch(this.set("color",ol.color.asString(i)),this.set("value",e.value||1),this.set("preserveAlpha",e.preserveAlpha),e.operation){case"hue":case"difference":case"color-dodge":case"enhance":this.set("operation",e.operation);break;case"saturation":t=255*(e.value||0),this.set("color",ol.color.asString([0,0,t,t||1])),this.set("operation",e.operation);break;case"luminosity":t=255*(e.value||0),this.set("color",ol.color.asString([t,t,t,255])),this.set("operation","hard-light");break;case"contrast":t=255*(e.value||0),this.set("color",ol.color.asString([t,t,t,255])),this.set("operation","soft-light");break;default:this.set("operation","color"),this.setValue(e.value||1)}}setValue(e){this.set("value",e);var t=ol.color.asArray(this.get("color"));t[3]=e,this.set("color",ol.color.asString(t))}setColor(e){(e=ol.color.asArray(e))&&(e[3]=this.get("value"),this.set("color",ol.color.asString(e)))}precompose(){}postcompose(e){var t,i,s=e.context,o=s.canvas;if(s.save(),"enhance"==this.get("operation")){var r=this.get("value");if(r){var a=o.width,n=o.height;this.get("preserveAlpha")?((t=document.createElement("CANVAS")).width=o.width,t.height=o.height,(i=t.getContext("2d")).drawImage(o,0,0,a,n),i.globalCompositeOperation="color-burn",i.globalAlpha=r,i.drawImage(t,0,0,a,n),i.drawImage(t,0,0,a,n),i.drawImage(t,0,0,a,n),s.globalCompositeOperation="source-in",s.drawImage(t,0,0)):(s.globalCompositeOperation="color-burn",s.globalAlpha=r,s.drawImage(o,0,0,a,n),s.drawImage(o,0,0,a,n),s.drawImage(o,0,0,a,n))}}else this.get("preserveAlpha")?((t=document.createElement("CANVAS")).width=o.width,t.height=o.height,(i=t.getContext("2d")).drawImage(o,0,0),i.globalCompositeOperation=this.get("operation"),i.fillStyle=this.get("color"),i.fillRect(0,0,o.width,o.height),s.globalCompositeOperation="source-in",s.drawImage(t,0,0)):(s.globalCompositeOperation=this.get("operation"),s.fillStyle=this.get("color"),s.fillRect(0,0,o.width,o.height));s.restore()}},ol.filter.Composite=class extends ol.filter.Base{constructor(e){super(e),this.set("operation",e.operation||"source-over")}setOperation(e){this.set("operation",e||"source-over")}precompose(e){var t=e.context;t.save(),t.globalCompositeOperation=this.get("operation")}postcompose(e){e.context.restore()}},ol.filter.Crop=class extends ol.filter.Mask{constructor(e){super(e=e||{})}precompose(e){if(this.feature_){var t=e.context;t.save(),this.drawFeaturePath_(e,this.get("inner")),t.clip("evenodd")}}postcompose(e){if(this.feature_){var t=e.context;if(t.restore(),this.get("shadowWidth")){t.save();var i=this.get("shadowWidth")*e.frameState.pixelRatio;this.get("shadowMapUnits")&&(i/=e.frameState.viewState.resolution),this.drawFeaturePath_(e,!this.get("inner")),t.clip("evenodd"),t.filter="blur("+i+"px)",t.strokeStyle=this._shadowColor,t.lineCap="round",t.lineJoin="round",t.lineWidth=i,t.stroke(),t.restore()}}}},ol.filter.Fold=class extends ol.filter.Base{constructor(e){super(e=e||{}),this.set("fold",e.fold||[8,4]),this.set("margin",e.margin||8),this.set("padding",e.padding||8),"number"==typeof e.fsize&&(e.fsize=[e.fsize,e.fsize]),this.set("fsize",e.fsize||[8,10]),this.set("fill",e.fill),this.set("shadow",!1!==e.shadow),this.set("opacity",e.hasOwnProperty("opacity")?e.opacity:.2)}drawLine_(e,t,i){var s,o,r,a=e.canvas,n=this.get("fold"),l=a.width,h=a.height;for(e.beginPath(),e.moveTo(i,i),r=1;r<=n[0];r++)s=r*l/n[0]-(r==n[0]?i:0),o=t[1]*(r%2)+i,e.lineTo(s,o);for(r=1;r<=n[1];r++)s=l-t[0]*(r%2)-i,o=r*h/n[1]-(r==n[1]?t[0]*(n[0]%2)+i:0),e.lineTo(s,o);for(r=n[0];r>0;r--)s=r*l/n[0]-(r==n[0]?t[0]*(n[1]%2)+i:0),o=h-t[1]*(r%2)-i,e.lineTo(s,o);for(r=n[1];r>0;r--)s=t[0]*(r%2)+i,o=r*h/n[1]-(r==n[1]?i:0),e.lineTo(s,o);e.closePath()}precompose(e){var t=e.context;t.save(),t.shadowColor="rgba(0,0,0,0.3)",t.shadowBlur=8,t.shadowOffsetX=2,t.shadowOffsetY=3,this.drawLine_(t,this.get("fsize"),this.get("margin")),t.fillStyle="#fff",this.get("fill")&&t.fill(),t.strokeStyle="rgba(0,0,0,0.1)",t.stroke(),t.restore(),t.save(),this.drawLine_(t,this.get("fsize"),this.get("margin")+this.get("padding")),t.clip()}postcompose(e){var t=e.context,i=t.canvas;if(t.restore(),t.save(),this.drawLine_(t,this.get("fsize"),this.get("margin")),t.clip(),this.get("shadow")){var s=this.get("fold"),o=i.width/s[0],r=i.height/s[1],a=t.createRadialGradient(5*o/8,5*o/8,o/4,o/2,o/2,o);a.addColorStop(0,"transparent"),a.addColorStop(1,"rgba(0,0,0,"+this.get("opacity")+")"),t.fillStyle=a,t.scale(1,r/o);for(var n=0;n<s[0];n++)for(var l=0;l<s[1];l++)t.save(),t.translate(n*o,l*o),t.fillRect(0,0,o,o),t.restore()}t.restore()}},ol.filter.Halftone=class extends ol.filter.Base{constructor(e){super(e=e||{}),this.internal_=document.createElement("canvas"),this.setSize(e.size),this.set("channel",e.channel)}setSize(e){e=Number(e)||30,this.set("size",e)}postcompose(e){var t=e.context,i=t.canvas,s=e.frameState.pixelRatio;"postrender"===e.type&&(s=1),t.save();var o=this.get("size")*s,r=e.frameState.extent,a=e.frameState.viewState.resolution/s,n=[-Math.round(r[0]/a%o),Math.round(r[1]/a%o)],l=this.internal_.getContext("2d"),h=this.internal_.width=i.width,c=this.internal_.height=i.height;l.webkitImageSmoothingEnabled=l.mozImageSmoothingEnabled=l.msImageSmoothingEnabled=l.imageSmoothingEnabled=!1;var u=Math.floor((h-n[0])/o),d=Math.floor((c-n[1])/o);l.drawImage(i,n[0],n[1],u*o,d*o,0,0,u,d);var p=l.getImageData(0,0,u,d).data;t.clearRect(0,0,h,c),t.fillStyle=ol.color.asString(this.get("color")||"#000");for(var g=0;g<u;g++)for(var m=0;m<d;m++)if(p[4*g+3+m*u*4]){var f;switch(this.get("channel")){case"r":f=p[4*g+m*u*4]/2.55;break;case"g":f=p[4*g+1+m*u*4]/2.55;break;case"b":f=p[4*g+2+m*u*4]/2.55;break;default:f=(f=ol.color.toHSL([p[4*g+m*u*4],p[4*g+1+m*u*4],p[4*g+2+m*u*4]]))[2]}var v=(100-f)/140;v&&(t.beginPath(),t.arc(n[0]+o/2+g*o,n[1]+o/2+m*o,o*v,0,2*Math.PI),t.closePath(),t.fill())}t.restore()}},ol.filter.Lego=class extends ol.filter.Base{constructor(e){super(e=e||{});var t=new Image;t.src=this.img[e.img]||this.img.ol3,t.crossOrigin=e.crossOrigin||null,this.pattern={canvas:document.createElement("canvas")},this.setBrick(e.brickSize,t),this.internal_=document.createElement("canvas")}set(e,t){super.set(e,t),"brickSize"==e&&this.pattern&&this.pattern.canvas.width!=t&&this.setBrick(t)}setBrick(e,t,i){if(e=Number(e)||30,"string"==typeof t){var s=new Image;s.src=this.img[t]||this.img.ol3,s.crossOrigin=i||null,t=s}if(t&&(this.pattern.img=t),this.pattern.img.width)this.pattern.canvas.width=this.pattern.canvas.height=e,this.pattern.ctx=this.pattern.canvas.getContext("2d"),this.pattern.ctx.fillStyle=this.pattern.ctx.createPattern(this.pattern.img,"repeat"),this.set("brickSize",e),t&&this.set("img",t.src);else{var o=this;this.pattern.img.onload=function(){o.setBrick(e,t)}}}getPattern(e,t){if(!this.pattern.ctx)return"transparent";var i=this.pattern.canvas,s=this.pattern.ctx,o=i.width/this.pattern.img.width;return s.save(),s.clearRect(0,0,i.width,i.height),s.scale(o,o),e/=o,t/=o,s.translate(e,t),s.beginPath(),s.clearRect(-2*i.width,-2*i.height,4*i.width,4*i.height),s.rect(-e,-t,2*i.width/o,2*i.height/o),s.fill(),s.restore(),s.createPattern(i,"repeat")}postcompose(e){var t=e.context,i=t.canvas,s=e.frameState.pixelRatio;t.save();var o=this.pattern.canvas.width*s,r=e.frameState.extent,a=e.frameState.viewState.resolution/s,n=[-Math.round(r[0]/a%o),Math.round(r[1]/a%o)],l=this.internal_.getContext("2d"),h=this.internal_.width=i.width,c=this.internal_.height=i.height;l.webkitImageSmoothingEnabled=l.mozImageSmoothingEnabled=l.msImageSmoothingEnabled=l.imageSmoothingEnabled=!1;var u=Math.floor((h-n[0])/o),d=Math.floor((c-n[1])/o);l.drawImage(i,n[0],n[1],u*o,d*o,0,0,u,d),t.webkitImageSmoothingEnabled=t.mozImageSmoothingEnabled=t.msImageSmoothingEnabled=t.imageSmoothingEnabled=!1,t.clearRect(0,0,h,c),t.drawImage(this.internal_,0,0,u,d,n[0],n[1],u*o,d*o),t.scale(s,s),t.fillStyle=this.getPattern(n[0]/s,n[1]/s),t.rect(0,0,h,c),t.fill(),t.restore()}},ol.filter.Lego.prototype.img={brick:"data:image/png;base64,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",ol3:"data:image/png;base64,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",lego:"data:image/png;base64,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"},ol.filter.Paper=class extends ol.filter.Base{constructor(e){super(e=e||{}),this._svgfilter=new ol.ext.SVGFilter.Paper(e)}precompose(){}postcompose(e){var t=e.context,i=t.canvas;t.save(),t.filter="url(#"+this._svgfilter.getId()+")",t.globalAlpha=1,t.globalCompositeOperation="multiply",t.fillRect(0,0,i.width,i.height),t.restore()}setLight(e){this._svgfilter.setLight(e)}},ol.filter.PencilSketch=class extends ol.filter.Base{constructor(e){super(e=e||{}),this.set("blur",e.blur||8),this.set("intensity",e.intensity||.8)}precompose(){}postcompose(e){var t=e.context,i=t.canvas,s=i.width,o=i.height,r=document.createElement("canvas");r.width=s,r.height=o;var a=r.getContext("2d");a.filter="grayscale(1) invert(1) blur("+this.get("blur")+"px)",a.drawImage(i,0,0),t.save(),this.get("color")?(t.globalCompositeOperation="darken",t.globalAlpha=.3,t.drawImage(i,0,0)):(t.filter="grayscale(1)",t.drawImage(i,0,0)),t.globalCompositeOperation="color-dodge",t.globalAlpha=this.get("intensity"),t.drawImage(r,0,0),t.restore()}},ol.filter.Pointillism=class extends ol.filter.Base{constructor(e){super(e=e||{}),this.set("saturate",Number(e.saturate)||2),this.pixels=[]}_getPixels(e){if(e>this.pixels.length)for(;this.pixels.length<e;)this.pixels.push([Math.random(),Math.random(),4*Math.random()+2]);return e}precompose(){}postcompose(e){var t=e.context,i=t.canvas,s=i.width,o=i.height,r=document.createElement("canvas");r.width=s,r.height=o;var a=r.getContext("2d");a.filter="saturate("+Math.round(2*this.get("saturate")*100)+"%)",a.drawImage(i,0,0),t.save(),t.filter="blur(3px) saturate("+100*this.get("saturate")+"%)",t.drawImage(i,0,0),t.filter="none",t.opacity=.5;for(var n=this._getPixels(s*o/50),l=0;l<n;l++){var h=Math.floor(this.pixels[l][0]*s),c=Math.floor(this.pixels[l][1]*o);t.fillStyle=ol.color.asString(a.getImageData(h,c,1,1).data),t.beginPath(),t.arc(h,c,this.pixels[l][2],0,2*Math.PI),t.fill()}t.restore()}},ol.filter.SVGFilter=class extends ol.filter.Base{constructor(e){super(),this._svg={},e&&(e instanceof Array||(e=[e]),e.forEach(function(e){this.addSVGFilter(e)}.bind(this)))}addSVGFilter(e){var t="#"+e.getId();this._svg[t]=1,this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})}removeSVGFilter(e){var t="#"+e.getId();delete this._svg[t],this.dispatchEvent({type:"propertychange",key:"svg",oldValue:this._svg})}precompose(){}postcompose(e){var t=[];for(var i in this._svg)t.push("url("+i+")");t=t.join(" ");var s=document.createElement("canvas");s.width=e.context.canvas.width,s.height=e.context.canvas.height,s.getContext("2d").drawImage(e.context.canvas,0,0),t&&(e.context.save(),e.context.clearRect(0,0,s.width,s.height),e.context.filter=t,e.context.drawImage(s,0,0),e.context.restore())}},ol.filter.Texture=class extends ol.filter.Base{constructor(e){super(e),this.setFilter(e)}setFilter(e){var t;(e=e||{}).img?t=e.img:(t=new Image,e.src&&(ol.filter.Texture.Image&&ol.filter.Texture.Image[e.src]?t.src=ol.filter.Texture.Image[e.src]:t.src||(t.src=e.src)),t.crossOrigin=e.crossOrigin||null),this.set("rotateWithView",!1!==e.rotateWithView),this.set("opacity","number"==typeof e.opacity?e.opacity:1),this.set("ready",!1);var i=this;function s(t){i.pattern={},i.pattern.scale=e.scale||1,i.pattern.canvas=document.createElement("canvas"),i.pattern.canvas.width=t.width*i.pattern.scale,i.pattern.canvas.height=t.height*i.pattern.scale,i.pattern.canvas.width=t.width,i.pattern.canvas.height=t.height,i.pattern.ctx=i.pattern.canvas.getContext("2d"),i.pattern.ctx.fillStyle=i.pattern.ctx.createPattern(t,"repeat"),i.set("ready",!0)}t.width?s(t):t.onload=function(){s(t)}}getPattern(e,t){var i=this.pattern.canvas,s=this.pattern.ctx;return s.save(),s.translate(-e,t),s.beginPath(),s.rect(e,-t,i.width,i.height),s.fill(),s.restore(),s.createPattern(i,"repeat")}postcompose(e){if(this.pattern){var t=e.context,i=t.canvas,s=1.5*Math.max(i.width,i.height),o=e.frameState.pixelToCoordinateTransform;o||((o=e.frameState.pixelToCoordinateMatrix)[2]=o[4],o[3]=o[5],o[4]=o[12],o[5]=o[13]);var r=e.frameState.pixelRatio,a=e.frameState.viewState.resolution,n=i.width/2,l=i.height/2;if(t.save(),t.globalCompositeOperation="multiply",t.globalAlpha=this.get("opacity"),t.scale(r*this.pattern.scale,r*this.pattern.scale),this.get("rotateWithView"))a*=this.pattern.scale,t.fillStyle=this.getPattern((n*o[0]+l*o[1]+o[4])/a,(n*o[2]+l*o[3]+o[5])/a),t.translate(n/this.pattern.scale,l/this.pattern.scale),t.rotate(e.frameState.viewState.rotation),t.beginPath(),t.rect(-n-s,-l-s,2*s,2*s),t.fill();else{var h=-(n*o[0]+l*o[1]+o[4])/a,c=(n*o[2]+l*o[3]+o[5])/a,u=Math.cos(e.frameState.viewState.rotation),d=Math.sin(e.frameState.viewState.rotation),p=(h*u-c*d)/this.pattern.scale,g=(h*d+c*u)/this.pattern.scale;t.translate(p,g),t.beginPath(),t.fillStyle=this.pattern.ctx.fillStyle,t.rect(-p-s,-g-s,2*s,2*s),t.fill()}t.restore()}}},ol.format.GeoJSONX=class extends ol.format.GeoJSON{constructor(e){super(e=e||{}),this._hash={},this._count=0,this._extended=e.extended,"function"==typeof e.whiteList?this._whiteList=e.whiteList:e.whiteList&&e.whiteList.indexOf?this._whiteList=function(t){return e.whiteList.indexOf(t)>-1}:this._whiteList=function(){return!0},"function"==typeof e.blackList?this._blackList=e.blackList:e.blackList&&e.blackList.indexOf?this._blackList=function(t){return e.blackList.indexOf(t)>-1}:this._blackList=function(){return!1},this._deleteNull=!1!==e.deleteNullProperties&&[null,void 0,""];var t=2;e.dataProjection&&"EPSG:4326"!==e.dataProjection||(t=7),isNaN(parseInt(e.decimals))||(t=parseInt(e.decimals)),this._decimals=t,this.setLayout(e.layout||"XY")}setLayout(e){switch(e){case"XYZ":case"XYZM":this._layout=e;break;default:this._layout="XY"}}getLayout(){return this._layout}encodeNumber(e,t){!isNaN(Number(e))&&null!==e&&isFinite(e)||(e=0),t||0===t||(t=this._decimals),(e=Math.round(e*Math.pow(10,t)))<0?e=-2*e-1:e*=2;for(var i,s="",o=e;i=o%this._size,s=this._radix.charAt(i)+s,0!=(o=Math.floor(o/this._size)););return s}decodeNumber(e,t){t||0===t||(t=this._decimals);var i=0;e.split("").forEach(function(e){i=i*this._size+this._radix.indexOf(e)}.bind(this));var s=Math.floor(i/2);return s!==i/2&&(s=-1-s),s/Math.pow(10,t)}encodeCoordinates(e,t){var i,s,o;if("number"==typeof e[0])return s=this.encodeNumber(e[0],t)+","+this.encodeNumber(e[1],t),"Z"==this._layout[2]&&e.length>2&&(s+=","+this.encodeNumber(e[2],2)),"M"==this._layout[3]&&e.length>3&&(s+=","+this.encodeNumber(e[3],0)),s;if(e.length&&e[0]){if("number"==typeof e[0][0]){var r=[0,0,0,0],a=[],n="Z"==this._layout[2]&&e[0].length>2,l="M"==this._layout[3]&&e[0].length>3;for(i=0;i<e.length;i++){o=[Math.round(e[i][0]*Math.pow(10,t)),Math.round(e[i][1]*Math.pow(10,t))],n&&(o[2]=e[i][2]),l&&(o[3]=e[i][3]),e[i]=o;var h=e[i][0]-r[0],c=e[i][1]-r[1];0!=i&&0===h&&0===c||(s=this.encodeNumber(h,0)+","+this.encodeNumber(c,0)+(n?","+this.encodeNumber(e[i][2]-r[2],2):"")+(l?","+this.encodeNumber(e[i][3]-r[3],0):""),a.push(s),r=e[i])}return a.length<2&&e.length>1&&(s="A,A"+(n?",A":"")+(l?",A":""),a.push(s)),a.join(";")}for(i=0;i<e.length;i++)e[i]=this.encodeCoordinates(e[i],t);return e}return this.encodeCoordinates([0,0],t)}decodeCoordinates(e,t){var i,s;if("string"==typeof e){if((e=e.split(";")).length>1){var o=Math.pow(10,t),r=[0,0,0,0];return e.forEach(function(i,s){e[s]=i.split(","),e[s][0]=Math.round((this.decodeNumber(e[s][0],t)+r[0])*o)/o,e[s][1]=Math.round((this.decodeNumber(e[s][1],t)+r[1])*o)/o,e[s].length>2&&(e[s][2]=Math.round((this.decodeNumber(e[s][2],2)+r[2])*o)/o),e[s].length>3&&(e[s][3]=Math.round((this.decodeNumber(e[s][3],0)+r[3])*o)/o),r=e[s]}.bind(this)),e}return e=e[0].split(","),s=[this.decodeNumber(e[0],t),this.decodeNumber(e[1],t)],e.length>2&&(s[2]=this.decodeNumber(e[2],2)),e.length>3&&(s[3]=this.decodeNumber(e[3],0)),s}if(e.length){var a=[];for(i=0;i<e.length;i++)a[i]=this.decodeCoordinates(e[i],t);return a}return[0,0]}writeFeaturesObject(e,t){t=t||{},this._count=0,this._hash={};var i=ol.format.GeoJSON.prototype.writeFeaturesObject.call(this,e,t);i.decimals=this._decimals,i.hashProperties=[],Object.keys(this._hash).forEach(function(e){i.hashProperties.push(e)}.bind(this)),this._count=0,this._hash={};var s=i.features;return delete i.features,i.features=s,i}writeFeatureObject(e,t){var i=ol.format.GeoJSON.prototype.writeFeatureObject.call(this,e,t);if("Feature"!==i.type)throw"GeoJSONX doesn't support "+i.type+".";var s,o=[];if("Point"===i.geometry.type)o.push(this.encodeCoordinates(i.geometry.coordinates,this._decimals));else if("MultiPoint"===i.geometry.type){var r=[];i.geometry.coordinates.forEach(function(e){r.push(this.encodeCoordinates(e,this._decimals))}.bind(this)),o.push([this._type[i.geometry.type],r.join(";")])}else{if(!this._type[i.geometry.type])throw"GeoJSONX doesn't support "+i.geometry.type+".";o.push([this._type[i.geometry.type],this.encodeCoordinates(i.geometry.coordinates,this._decimals)])}var a=[];for(s in i.properties)this._whiteList(s)&&!this._blackList(s)&&(this._hash.hasOwnProperty(s)||(this._hash[s]=this._count,this._count++),(!this._deleteNull||this._deleteNull.indexOf(i.properties[s])<0)&&a.push(this._hash[s],i.properties[s]));if((a.length||this._extended)&&o.push(a),this._extended){var n=!1;for(s in a={},i)/^type$|^geometry$|^properties$/.test(s)||(a[s]=i[s],n=!0);n&&o.push(a)}return o}writeGeometryObject(e,t){var i=ol.format.GeoJSON.prototype.writeGeometryObject.call(this,e,t);return"Point"===i.type?this.encodeCoordinates(i.coordinates,this._decimals):[this._type[i.type],this.encodeCoordinates(i.coordinates,this._decimals)]}readFeaturesFromObject(e,t){if(this._hashProperties=e.hashProperties||[],(t=t||{}).decimals=parseInt(e.decimals),!t.decimals&&0!==t.decimals)throw"Bad file format...";return ol.format.GeoJSON.prototype.readFeaturesFromObject.call(this,e,t)}readFeatureFromObject(e,t){var i={type:"Feature"};if("string"==typeof e[0])i.geometry={type:"Point",coordinates:this.decodeCoordinates(e[0],"number"==typeof t.decimals?t.decimals:this.decimals)};else if(i.geometry={type:this._toType[e[0][0]]},"MultiPoint"===i.geometry.type){var s=i.geometry.coordinates=[];e[0][1].split(";").forEach(function(e){e=e.split(","),s.push([this.decodeNumber(e[0],t.decimals),this.decodeNumber(e[1],t.decimals)])}.bind(this))}else i.geometry.coordinates=this.decodeCoordinates(e[0][1],"number"==typeof t.decimals?t.decimals:this.decimals);if(this._hashProperties&&e[1]){i.properties={};for(var o=e[1],r=0;r<o.length;r+=2)i.properties[this._hashProperties[o[r]]]=o[r+1]}else i.properties=e[1];if(e[2])for(var a in e[2])i[a]=e[2][a];return ol.format.GeoJSON.prototype.readFeatureFromObject.call(this,i,t)}},ol.format.GeoJSONX.prototype._radix="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/ !#$%&'()*-.:<=>?@[]^_`{|}~",ol.format.GeoJSONX.prototype._size=ol.format.GeoJSONX.prototype._radix.length,ol.format.GeoJSONX.prototype._type={Point:0,LineString:1,Polygon:2,MultiPoint:3,MultiLineString:4,MultiPolygon:5,GeometryCollection:null},ol.format.GeoJSONX.prototype._toType=["Point","LineString","Polygon","MultiPoint","MultiLineString","MultiPolygon"],ol.format.GeoJSONP=class extends ol.format.GeoJSONX{constructor(e){super(e=e||{}),this._lineFormat=new ol.format.Polyline({factor:Math.pow(10,e.decimals||6)})}encodeCoordinates(e){var t;if("number"==typeof e[0])return t=new ol.geom.Point(e),this._lineFormat.writeGeometry(t);if(e.length&&e[0]){if("number"==typeof e[0][0])return t=new ol.geom.LineString(e),this._lineFormat.writeGeometry(t);for(var i=[],s=0;s<e.length;s++)i[s]=this.encodeCoordinates(e[s]);return i}return this.encodeCoordinates([0,0])}decodeCoordinates(e){var t,i;if("string"==typeof e)return(i=this._lineFormat.readGeometry(e)).getCoordinates()[0];if(e.length){var s=[];if("string"==typeof e[0])for(t=0;t<e.length;t++)i=this._lineFormat.readGeometry(e[t]),s[t]=i.getCoordinates();else for(t=0;t<e.length;t++)s[t]=this.decodeCoordinates(e[t]);return s}return null}},ol.format.GeoRSS=class extends ol.Object{constructor(e){super(e=e||{})}readFeature(e,t){t=t||{};for(var i,s=e.children,o=new ol.Feature,r=0;i=s[r];r++)o.set(i.tagName,i.innerHTML);var a,n,l=[];if(o.get("geo:long"))n=new ol.geom.Point([parseFloat(o.get("geo:long")),parseFloat(o.get("geo:lat"))]),o.unset("geo:long"),o.unset("geo:lat");else if(o.get("georss:point"))l=o.get("georss:point").trim().split(" "),n=new ol.geom.Point([parseFloat(l[1]),parseFloat(l[0])]),o.unset("georss:point");else{if(!o.get("georss:polygon"))return o.get("georss:where")?(console.warn("[GeoRSS] GML format not implemented"),o.unset("georss:where"),null):(console.warn("[GeoRSS] unknown geometry"),null);a=o.get("georss:polygon").trim().split(" ");for(var h=0;h<a.length;h+=2)l.push([parseFloat(a[h+1]),parseFloat(a[h])]);n=new ol.geom.Polygon([l]),o.unset("georss:polygon")}return(t.featureProjection||this.get("featureProjection"))&&n.transform(t.dataProjection||this.get("dataProjection")||"EPSG:4326",t.featureProjection||this.get("featureProjection")),o.setGeometry(n),o}readFeatures(e,t){var i;if("string"==typeof e){var s=(new DOMParser).parseFromString(e,"text/xml");i=s.getElementsByTagName(this.getDocumentItemsTagName(s))}else if(e instanceof Document)i=e.getElementsByTagName(this.getDocumentItemsTagName(e));else{if(!(e instanceof Node))return[];i=e}for(var o,r=[],a=0;o=i[a];a++){var n=this.readFeature(o,t);n&&r.push(n)}return r}getDocumentItemsTagName(e){switch(e.documentElement.tagName){case"feed":return"entry";default:return"item"}}},ol.interaction.Clip=class extends ol.interaction.Pointer{constructor(e){super({handleDownEvent:function(e){return this._setPosition(e)},handleMoveEvent:function(e){return this._setPosition(e)}}),this.layers_=[],this.precomposeBind_=this.precompose_.bind(this),this.postcomposeBind_=this.postcompose_.bind(this),e=e||{},this.pos=!1,this.radius=e.radius||100,e.layers&&this.addLayer(e.layers),this.setActive(!0)}setMap(e){var t;if(this.getMap()){for(t=0;t<this.layers_.length;t++)this.layers_[t].un(["precompose","prerender"],this.precomposeBind_),this.layers_[t].un(["postcompose","postrender"],this.postcomposeBind_);try{this.getMap().renderSync()}catch(e){}}if(super.setMap(e),e){for(t=0;t<this.layers_.length;t++)this.layers_[t].on(["precompose","prerender"],this.precomposeBind_),this.layers_[t].on(["postcompose","postrender"],this.postcomposeBind_);try{e.renderSync()}catch(e){}}}setRadius(e){if(this.radius=e,this.getMap())try{this.getMap().renderSync()}catch(e){}}getRadius(){return this.radius}addLayer(e){e instanceof Array||(e=[e]);for(var t=0;t<e.length;t++){if(this.getMap()){e[t].on(["precompose","prerender"],this.precomposeBind_),e[t].on(["postcompose","postrender"],this.postcomposeBind_);try{this.getMap().renderSync()}catch(e){}}this.layers_.push(e[t])}}removeLayers(){this.removeLayer(this.layers_)}removeLayer(e){e instanceof Array||(e=[e]);for(var t=0;t<e.length;t++){var i;for(i=0;i<this.layers_.length&&this.layers_[i]!==e[t];i++);i!=this.layers_.length&&this.getMap()&&(this.layers_[i].un(["precompose","prerender"],this.precomposeBind_),this.layers_[i].un(["postcompose","postrender"],this.postcomposeBind_),this.layers_.splice(i,1))}if(this.getMap())try{this.getMap().renderSync()}catch(e){}}setPosition(e){if(this.getMap()){this.pos=this.getMap().getPixelFromCoordinate(e);try{this.getMap().renderSync()}catch(e){}}}getPosition(){return this.pos?this.getMap().getCoordinateFromPixel(this.pos):null}setPixelPosition(e){if(this.pos=e,this.getMap())try{this.getMap().renderSync()}catch(e){}}getPixelPosition(){return this.pos}_setPosition(e){if(("pointermove"!==e.type||"onclick"!==this.get("action"))&&(e.pixel&&(this.pos=e.pixel),this.getMap()))try{this.getMap().renderSync()}catch(e){}}precompose_(e){if(this.getActive()){var t=e.context,i=e.frameState.pixelRatio;t.save(),t.beginPath();var s=[this.pos[0],this.pos[1]],o=this.radius,r=e.inversePixelTransform;r?o=(s=[s[0]*r[0]-s[1]*r[1]+r[4],-s[0]*r[2]+s[1]*r[3]+r[5]])[0]-((this.pos[0]-o)*r[0]-this.pos[1]*r[1]+r[4]):(s[0]*=i,s[1]*=i,o*=i),t.arc(s[0],s[1],o,0,2*Math.PI),t.clip()}}postcompose_(e){this.getActive()&&e.context.restore()}setActive(e){if(e!==this.getActive()&&(super.setActive(e),this.layers_)){var t;if(e)for(t=0;t<this.layers_.length;t++)this.layers_[t].on(["precompose","prerender"],this.precomposeBind_),this.layers_[t].on(["postcompose","postrender"],this.postcomposeBind_);else for(t=0;t<this.layers_.length;t++)this.layers_[t].un(["precompose","prerender"],this.precomposeBind_),this.layers_[t].un(["postcompose","postrender"],this.postcomposeBind_);if(this.getMap())try{this.getMap().renderSync()}catch(e){}}}},ol.interaction.CurrentMap=class extends ol.interaction.Interaction{constructor(e){var t=(e=e||{}).condition||function(){return!0};if(super({handleEvent:function(e){return t(e)&&(this.isCurrentMap()||(this.setCurrentMap(this.getMap()),this.dispatchEvent({type:"focus",map:this.getMap()}),this.getMap().dispatchEvent({type:"focus",map:this.getMap()}))),!0}}),this._olinteractionCurrentMap_cleanup=[],e.onKeyDown){var i=function(t){this.isCurrentMap()&&!/INPUT|TEXTAREA|SELECT/.test(document.activeElement.tagName)&&e.onKeyDown({type:t.type,map:this.getMap(),originalEvent:t})}.bind(this);document.addEventListener("keydown",i),this._olinteractionCurrentMap_cleanup.push(()=>document.removeEventListener("keydown",i))}if(e.onKeyPress){i=function(t){this.isCurrentMap()&&!/INPUT|TEXTAREA|SELECT/.test(document.activeElement.tagName)&&e.onKeyPress({type:t.type,map:this.getMap(),originalEvent:t})}.bind(this);document.addEventListener("keypress",i),this._olinteractionCurrentMap_cleanup.push(()=>document.removeEventListener("keypress",i))}if(e.onKeyUp){i=function(t){this.isCurrentMap()&&!/INPUT|TEXTAREA|SELECT/.test(document.activeElement.tagName)&&e.onKeyUp({type:t.type,map:this.getMap(),originalEvent:t})}.bind(this);document.addEventListener("keyup",i),this._olinteractionCurrentMap_cleanup.push(()=>document.removeEventListener("keyup",i))}}isCurrentMap(){return this.getMap()===ol.interaction.CurrentMap.prototype._currentMap}getCurrentMap(){return ol.interaction.CurrentMap.prototype._currentMap}setCurrentMap(e){ol.interaction.CurrentMap.prototype._currentMap=e}disposeInternal(){super.disposeInternal(),this._olinteractionCurrentMap_cleanup.forEach(e=>e())}},ol.interaction.CurrentMap.prototype._currentMap=void 0,ol.interaction.Blob=class extends ol.interaction.Clip{constructor(e){super(e)}precompose_(e){if(this.getActive()){var t=e.context,i=e.frameState.pixelRatio;if(t.save(),!this.pos)return t.beginPath(),t.moveTo(0,0),void t.clip();var s=[this.pos[0],this.pos[1]],o=e.inversePixelTransform;o?s=[s[0]*o[0]-s[1]*o[1]+o[4],-s[0]*o[2]+s[1]*o[3]+o[5]]:(s[0]*=i,s[1]*=i),this.frame||(this.frame=e.frameState.time);var r=e.frameState.time-this.frame;this.frame=e.frameState.time,s=this._getCenter(s,r);var a=this._calculate(r),n=a[0];t.beginPath(),t.moveTo(s[0]+n[0],s[1]+n[1]);for(var l=1;n=a[l];l++)t.lineTo(s[0]+n[0],s[1]+n[1]);t.clip(),e.frameState.animate=!0}}_getCenter(e,t){if(this._center){var i=this.get("stiffness")||20,s=-1*(this.get("damping")||7),o=Math.max(this.get("mass")||1,.1),r=Math.min(t/1e3,1/30),a=[i*(e[0]-this._center[0]),i*(e[1]-this._center[1])],n=[s*this._velocity[0],s*this._velocity[1]],l=[(a[0]+n[0])/o,(a[1]+n[1])/o];this._velocity[0]+=l[0]*r,this._velocity[1]+=l[1]*r,this._center[0]+=this._velocity[0]*r,this._center[1]+=this._velocity[1]*r}else this._center=e,this._velocity=[0,0];return this._center}_calculate(e){var t,i=this.get("points")||10;if(!this._waves||this._waves.length!==i)for(this._waves=[],t=0;t<i;t++)this._waves.push({angle:Math.random()*Math.PI,noise:Math.random()});var s=[],o=(this._velocity[0]*this._velocity[0]+this._velocity[1]*this._velocity[1])/500;for(this._rotation=(this._rotation||0)+(this._velocity[0]>0?1:-1)*Math.min(.015,o/7e4*e),t=0;t<i;t++){var r=2*t*Math.PI/i+this._rotation,a=this.radius+Math.min(this.radius,o),n=Math.cos(this._waves[t].angle)*a/4*this._waves[t].noise*(this.get("amplitude")||1);s.push([(this.radius+n)*Math.cos(r),(this.radius+n)*Math.sin(r)]),this._waves[t].angle+=(Math.PI+Math.random()+o/200)/350*e*(this.get("fuss")||1),this._waves[t].noise=Math.min(1,Math.max(0,this._waves[t].noise+.1*(Math.random()-.5)*(this.get("fuss")||1)))}return s.push(s[0]),ol.coordinate.cspline(s,{tension:this.get("tension")})}},ol.interaction.CenterTouch=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({handleEvent:function(i){return t.test(i.type)&&(this.pos_=i.coordinate),!e.handleEvent||e.handleEvent.call(this,i)}}),this._listener={};var t=/^pointermove$|^pointerup$/;this.ctouch=new ol.interaction.Interaction({handleEvent:function(e){return t.test(e.type)&&this.getMap()&&(e.coordinate=this.getMap().getView().getCenter(),e.pixel=this.getMap().getSize(),e.pixel=[e.pixel[0]/2,e.pixel[1]/2]),!0}}),this._target=new ol.control.Target({style:e.targetStyle,composite:e.composite})}setMap(e){this.getMap()&&(this.getMap().removeInteraction(this.ctouch),this.getMap().removeInteraction(this._target)),super.setMap(e),this.getMap()&&this.getActive()&&(this.getMap().addInteraction(this.ctouch),this.getMap().addControl(this._target))}setActive(e){super.setActive(e),this.pos_=null,this.getMap()&&(this.getActive()?(this.getMap().addInteraction(this.ctouch),this.getMap().addControl(this._target)):(this.getMap().removeInteraction(this.ctouch),this.getMap().removeControl(this._target)))}getPosition(){if(!this.pos_){var e=this.getMap().getSize();e=[e[0]/2,e[1]/2],this.pos_=this.getMap().getCoordinateFromPixel(e)}return this.pos_}},ol.interaction.ClipMap=class extends ol.interaction.Pointer{constructor(e){super({handleDownEvent:function(e){return this._clip(e)},handleMoveEvent:function(e){return this._clip(e)}}),e=e||{},this.layers_=[],this.pos=!1,this.radius=e.radius||100,this.pos=[-1e3,-1e3]}setMap(e){this.getMap()&&(this._listener&&ol.Observable.unByKey(this._listener),this.getMap().getViewport().querySelector(".ol-layers").style.clipPath="",delete this.getMap().getTargetElement().dataset.clipMap);super.setMap(e),e&&(this._listener=e.on("change:size",this._clip.bind(this)))}setRadius(e){this.radius=e,this._clip()}getRadius(){return this.radius}setPosition(e){this.getMap()&&(this.pos=this.getMap().getPixelFromCoordinate(e),this._clip())}getPosition(){return this.pos?this.getMap().getCoordinateFromPixel(this.pos):null}setPixelPosition(e){this.pos=e,this._clip()}getPixelPosition(){return this.pos}_setPosition(e){if(("pointermove"!==e.type||"onclick"!==this.get("action"))&&(e.pixel&&(this.pos=e.pixel),this.getMap()))try{this.getMap().renderSync()}catch(e){}}_clip(e){(!e||!e.pixel||"pointerdown"!==e.type&&this.get("freeze")||(this.pos=e.pixel),this.pos&&this.getMap())&&(this.getMap().getViewport().querySelector(".ol-layers").style.clipPath="circle("+this.getRadius()+"px at "+this.pos[0]+"px "+this.pos[1]+"px)",this.getMap().getTargetElement().dataset.clipMap="1")}},ol.interaction.CopyPaste=class extends ol.interaction.CurrentMap{constructor(e){var t=(e=e||{}).condition;"function"!=typeof t&&(t=function(e){if(e.originalEvent.ctrlKey){if(/^c$/i.test(e.originalEvent.key))return"copy";if(/^x$/i.test(e.originalEvent.key))return"cut";if(/^v$/i.test(e.originalEvent.key))return"paste"}return!1}),super({condition:e.mapCondition,onKeyDown:function(e){switch(t(e)){case"copy":i.copy({silent:!1});break;case"cut":i.copy({cut:!0,silent:!1});break;case"paste":i.paste({silent:!1})}}});var i=this;this.features=[],this._cloneFeature=!0,this._featuresSource=e.features||new ol.Collection,this.setSources(e.sources),this.setDestination(e.destination)}setMap(e){super.setMap(e),this.features=[]}setSources(e){e?(this._source=[],this._source=e instanceof Array?e:[e]):this._source=null}getSources(){return this._source}setDestination(e){this._destination=e}getDestination(){return this._destination}getFeatures(){return this.features}copy(e){var t=(e=e||{}).features||this._featuresSource.getArray();if(e.cut){var i=this._source||[this._destination];t.forEach(function(e){i.forEach(function(t){try{t.removeFeature(e)}catch(e){}})})}this._cloneFeature?(this.features=[],t.forEach(function(e){this.features.push(e.clone())}.bind(this))):this.features=t,!1===e.silent&&this.dispatchEvent({type:e.cut?"cut":"copy",time:(new Date).getTime()})}paste(e){var t=(e=e||{}).features||this.features;if(t){var i=e.destination||this._destination;i&&(i.addFeatures(this.features),this._cloneFeature&&this.copy({features:this.features}))}!1===e.silent&&this.dispatchEvent({type:"paste",features:t,time:(new Date).getTime()})}},ol.interaction.Delete=class extends ol.interaction.Select{constructor(e){super(e),this.on("select",function(e){this.getFeatures().clear(),this.delete(e.selected)}.bind(this))}_getSources(e){if(!this.getMap())return[];e||(e=this.getMap().getLayers());var t=[];return e.forEach(function(e){e.getLayers?t=t.concat(this._getSources(e.getLayers())):e.getSource&&e.getSource()instanceof ol.source.Vector&&t.push(e.getSource())}.bind(this)),t}delete(e){if(e&&(e.length||e.getLength())){this.dispatchEvent({type:"deletestart",features:e});var t=[];this._getSources().forEach(function(i){try{e.forEach(function(e){i.removeFeature(e),t.push(e)})}catch(e){}}),this.dispatchEvent({type:"deleteend",features:t})}}},ol.interaction.DragOverlay=class extends ol.interaction.Pointer{constructor(e){var t=(e=e||{}).offset||[0,0],i=e.centerOnClick||!1;super({handleDownEvent:function(e){var s=e.frameState.viewState.resolution,o=[e.coordinate[0]+t[0]*s,e.coordinate[1]-t[1]*s];if(/^(BUTTON|A)$/.test(e.originalEvent.target.tagName))return this._dragging=!1,!0;if(this._dragging){i&&this._dragging.setPosition(o,!0);var r=this._dragging.getPosition();return this._dragging.offsetClick=[o[0]-r[0],o[1]-r[1]],this.dispatchEvent({type:"dragstart",overlay:this._dragging,originalEvent:e.originalEvent,frameState:e.frameState,coordinate:r}),!0}return!1},handleDragEvent:function(e){var i=e.frameState.viewState.resolution,s=[e.coordinate[0]+t[0]*i,e.coordinate[1]-t[1]*i];this._dragging&&(s=[s[0]-this._dragging.offsetClick[0],s[1]-this._dragging.offsetClick[1]],this._dragging.setPosition(s,!0),this.dispatchEvent({type:"dragging",overlay:this._dragging,originalEvent:e.originalEvent,frameState:e.frameState,coordinate:s}))},handleUpEvent:function(e){var i=e.frameState.viewState.resolution,s=[e.coordinate[0]+t[0]*i,e.coordinate[1]-t[1]*i];return!!this._dragging&&(s=[s[0]-this._dragging.offsetClick[0],s[1]-this._dragging.offsetClick[1]],this.dispatchEvent({type:"dragend",overlay:this._dragging,originalEvent:e.originalEvent,frameState:e.frameState,coordinate:s}),this._dragging=!1,!0)}}),this._overlays=[],e.overlays instanceof Array||(e.overlays=[e.overlays]),e.overlays.forEach(this.addOverlay.bind(this))}addOverlay(e){for(var t,i=0;t=this._overlays[i];i++)if(t===e)return;var s=e.getElement();if(s.parentElement&&s.parentElement.classList.contains("ol-overlaycontainer-stopevent"))console.warn("[DragOverlay.addOverlay] overlay must be created with stopEvent set to false!");else{var o=function(){this.getMap()===e.getMap()&&(this._dragging=e)}.bind(this);this._overlays.push({overlay:e,listener:o}),s.parentNode.addEventListener("pointerdown",o)}}removeOverlay(e){for(var t,i=0;t=this._overlays[i];i++)if(t.overlay===e){var s=this._overlays.splice(i,1)[0];e.getElement().parentNode.removeEventListener("pointerdown",s.listener);break}}},ol.interaction.DrawHole=class extends ol.interaction.Draw{constructor(e){var t=function(e,t){var i=e[0].pop();return this.getPolygon()&&!this.getPolygon().intersectsCoordinate(i)||(this.lastOKCoord=[i[0],i[1]]),e[0].push([this.lastOKCoord[0],this.lastOKCoord[1]]),t?t.setCoordinates([e[0].concat([e[0][0]])]):t=new ol.geom.Polygon(e),t},i=(e=e||{}).geometryFunction;if(e.geometryFunction=i?function(e,s,o){return s=t.bind(this)(e,s),i.bind(this)(e,s,o)}:t,e.type="Polygon",super(e),this._select=new ol.interaction.Select({style:e.style}),this._select.setActive(!1),e.layers&&("function"==typeof e.layers?this.layers_=e.layers:e.layers.indexOf&&(this.layers_=function(t){return e.layers.indexOf(t)>=0})),"function"==typeof e.featureFilter)this._features=e.featureFilter;else if(e.featureFilter){var s=e.featureFilter;this._features=function(e){return s.indexOf?!!s[s.indexOf(e)]:!!s.item(s.getArray().indexOf(e))}}else this._features=function(){return!0};this.on("drawstart",this._startDrawing.bind(this)),this.on("drawend",this._finishDrawing.bind(this))}setMap(e){this.getMap()&&this.getMap().removeInteraction(this._select),e&&e.addInteraction(this._select),super.setMap.call(this,e)}setActive(e){this._select&&this._select.getFeatures().clear(),super.setActive.call(this,e)}removeLastPoint(){this._feature&&this._feature.getGeometry().getCoordinates()[0].length>2&&super.removeLastPoint.call(this)}getPolygon(){return this._polygon}_startDrawing(e){var t=this.getMap();this._feature=e.feature;var i=e.feature.getGeometry().getCoordinates()[0][0];this._current=null,t.forEachFeatureAtPixel(t.getPixelFromCoordinate(i),function(e,t){if(!this._current&&this._features(e,t)){var s=e.getGeometry();if("Polygon"===s.getType()&&s.intersectsCoordinate(i))this._polygonIndex=!1,this._polygon=s,this._current=e;else if("MultiPolygon"===s.getType()&&s.intersectsCoordinate(i))for(var o,r=0;o=s.getPolygon(r);r++)if(o.intersectsCoordinate(i)){this._polygonIndex=r,this._polygon=o,this._current=e;break}}}.bind(this),{layerFilter:this.layers_}),this._select.getFeatures().clear(),this._current?this._select.getFeatures().push(this._current):(this.setActive(!1),this.setActive(!0))}_finishDrawing(e){e.hole=e.feature,e.feature=this._select.getFeatures().item(0),this.dispatchEvent({type:"modifystart",features:[this._current]});var t=e.hole.getGeometry().getCoordinates()[0];if(t.length>3)if(!1!==this._polygonIndex){for(var i,s=e.feature.getGeometry(),o=new ol.geom.MultiPolygon([]),r=0;i=s.getPolygon(r);r++)r===this._polygonIndex?(i.appendLinearRing(new ol.geom.LinearRing(t)),o.appendPolygon(i)):o.appendPolygon(i);e.feature.setGeometry(o)}else this.getPolygon().appendLinearRing(new ol.geom.LinearRing(t));this.dispatchEvent({type:"modifyend",features:[this._current]}),this._feature=null,this._select.getFeatures().clear()}_geometryFn(e,t){var i=e[0].pop();return this.getPolygon()&&!this.getPolygon().intersectsCoordinate(i)||(this.lastOKCoord=[i[0],i[1]]),e[0].push([this.lastOKCoord[0],this.lastOKCoord[1]]),t?t.setCoordinates([e[0].concat([e[0][0]])]):t=new ol.geom.Polygon(e),t}},ol.interaction.DrawRegular=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({handleEvent:function(e){return t.handleEvent_(e)}});var t=this;this.squaredClickTolerance_=e.clickTolerance?e.clickTolerance*e.clickTolerance:36,this.maxCircleCoordinates_=e.maxCircleCoordinates||100,this.features_=e.features,this.source_=e.source,this.conditionFn_=e.condition,this.squareFn_=e.squareCondition,this.centeredFn_=e.centerCondition,this.canRotate_=!1!==e.canRotate,this.geometryName_=e.geometryName||"geometry",this.setSides(e.sides);var i=ol.style.Style.defaultStyle(!0);this.sketch_=new ol.Collection,this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({features:this.sketch_,useSpatialIndex:!1}),name:"DrawRegular overlay",displayInLayerSwitcher:!1,style:e.style||i})}setMap(e){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),super.setMap(e),this.overlayLayer_.setMap(e)}setActive(e){this.reset(),super.setActive(e)}reset(){this.overlayLayer_&&this.overlayLayer_.getSource().clear(),this.started_=!1}setSides(e){e=parseInt(e),this.sides_=e>2?e:0}canRotate(e){return!0!==e&&!1!==e||(this.canRotate_=e),this.canRotate_}getSides(){return this.sides_}getGeom_(){if(this.overlayLayer_.getSource().clear(),!this.center_)return!1;var e;if(this.coord_){var t,i,s,o,r,a=this.center_,n=this.coord_;if(!this.sides_&&this.square_&&!this.centered_)return a=[(n[0]+a[0])/2,(n[1]+a[1])/2],t=[n[0]-a[0],n[1]-a[1]],s=Math.sqrt(t[0]*t[0]+t[1]*t[1]),o=new ol.geom.Circle(a,s,"XY"),r=this.getMap().getPixelFromCoordinate(a),i=Math.max(100,Math.abs(r[0]-this.coordPx_[0]),Math.abs(r[1]-this.coordPx_[1])),i=Math.min(this.maxCircleCoordinates_,Math.round(i/3)),ol.geom.Polygon.fromCircle(o,i,0);var l=this.canRotate_&&this.centered_&&this.square_;if(t=[n[0]-a[0],n[1]-a[1]],this.square_&&!l){var h=Math.max(Math.abs(t[0]),Math.abs(t[1]));n=[a[0]+(t[0]>0?h:-h),a[1]+(t[1]>0?h:-h)]}if((s=Math.sqrt(t[0]*t[0]+t[1]*t[1]))>0){var c;if(o=new ol.geom.Circle(a,s,"XY"),c=l?Math.atan2(t[1],t[0]):this.startAngle[this.sides_]||this.startAngle.default,this.sides_?e=ol.geom.Polygon.fromCircle(o,this.sides_,c):(r=this.getMap().getPixelFromCoordinate(this.center_),i=Math.max(100,Math.abs(r[0]-this.coordPx_[0]),Math.abs(r[1]-this.coordPx_[1])),i=Math.min(this.maxCircleCoordinates_,Math.round(i/(this.centered_?3:5))),e=ol.geom.Polygon.fromCircle(o,i,0)),l)return e;var u=e.getExtent(),d=((a=this.centered_?[2*this.center_[0]-this.coord_[0],2*this.center_[1]-this.coord_[1]]:this.center_)[0]-n[0])/(u[0]-u[2]),p=(a[1]-n[1])/(u[1]-u[3]);if(this.square_){var g=Math.min(Math.abs(d),Math.abs(p));d=Math.sign(d)*g,p=Math.sign(p)*g}var m=[a[0]-u[0]*d,a[1]-u[1]*p];return e.applyTransform(function(e,t,i){for(var s=0;s<e.length;s+=i)t[s]=e[s]*d+m[0],t[s+1]=e[s+1]*p+m[1];return t}),e}}return new ol.geom.Point(this.center_)}drawSketch_(e){if(this.overlayLayer_.getSource().clear(),e){this.square_=this.squareFn_?this.squareFn_(e):e.originalEvent.shiftKey,this.centered_=this.centeredFn_?this.centeredFn_(e):e.originalEvent.metaKey||e.originalEvent.ctrlKey;var t=this.getGeom_();if(t){var i=this.feature_;return"Polygon"===t.getType()&&i.getGeometry().setCoordinates(t.getCoordinates()),this.overlayLayer_.getSource().addFeature(i),this.coord_&&this.square_&&(this.canRotate_&&this.centered_&&this.coord_||!this.sides_&&!this.centered_)&&this.overlayLayer_.getSource().addFeature(new ol.Feature(new ol.geom.LineString([this.center_,this.coord_]))),i}}}drawPoint_(e,t){t||this.overlayLayer_.getSource().clear(),this.overlayLayer_.getSource().addFeature(new ol.Feature(new ol.geom.Point(e)))}handleEvent_(e){var t,i;switch(this._eventTime=new Date,e.type){case"pointerdown":if(this.conditionFn_&&!this.conditionFn_(e))break;this.downPx_=e.pixel,this.start_(e);this._longTouch=!1,setTimeout(function(){this._longTouch=new Date-this._eventTime>450,this._longTouch&&this.handleMoveEvent_(e)}.bind(this),500),this.lastEvent=e.type;break;case"pointerup":this.started_&&this.coord_&&(t=this.downPx_[0]-e.pixel[0])*t+(i=this.downPx_[1]-e.pixel[1])*i<=this.squaredClickTolerance_&&("pointerdown"==this.lastEvent||"pointermove"==this.lastEvent||"keydown"==this.lastEvent?this.end_(e):(t=this.upPx_[0]-e.pixel[0])*t+(i=this.upPx_[1]-e.pixel[1])*i<=this.squaredClickTolerance_?this.end_(e):(this.handleMoveEvent_(e),this.drawPoint_(e.coordinate,!0))),this.upPx_=e.pixel;break;case"pointerdrag":if(this.started_){var s=this.getMap().getPixelFromCoordinate(this.center_);(t=s[0]-e.pixel[0])*t+(i=s[1]-e.pixel[1])*i<=this.squaredClickTolerance_&&this.reset()}return!this._longTouch;case"pointermove":this.started_?(t=this.downPx_[0]-e.pixel[0])*t+(i=this.downPx_[1]-e.pixel[1])*i>this.squaredClickTolerance_&&(this.handleMoveEvent_(e),this.lastEvent=e.type):this.drawPoint_(e.coordinate);break;default:if(this.started_&&("click"===e.type||"singleclick"===e.type||"dblclick"===e.type))return!1;this.lastEvent=e.type}return!0}finishDrawing(){this.started_&&this.coord_&&this.end_({pixel:this.upPx_,coordinate:this.coord_})}handleMoveEvent_(e){if(this.started_){this.coord_=e.coordinate,this.coordPx_=e.pixel;var t=this.drawSketch_(e);this.dispatchEvent({type:"drawing",feature:t,pixel:e.pixel,startCoordinate:this.center_,coordinate:e.coordinate,square:this.square_,centered:this.centered_})}else this.drawPoint_(e.coordinate)}start_(e){if(this.started_)this.coord_=e.coordinate;else{this.started_=!0,this.center_=e.coordinate,this.coord_=null;var t=this.feature_=new ol.Feature({});t.setGeometryName(this.geometryName_||"geometry"),t.setGeometry(new ol.geom.Polygon([[e.coordinate,e.coordinate,e.coordinate]])),this.drawSketch_(e),this.dispatchEvent({type:"drawstart",feature:t,pixel:e.pixel,coordinate:e.coordinate})}}end_(e){if(this.coord_=e.coordinate,this.started_=!1,!this.coord_||this.center_[0]===this.coord_[0]&&this.center_[1]===this.coord_[1])this.dispatchEvent({type:"drawcancel",feature:null,pixel:e.pixel,coordinate:e.coordinate,square:this.square_,centered:this.centered_});else{var t=this.feature_;t.setGeometry(this.getGeom_()),this.source_?this.source_.addFeature(t):this.features_&&this.features_.push(t),this.dispatchEvent({type:"drawend",feature:t,pixel:e.pixel,coordinate:e.coordinate,square:this.square_,centered:this.centered_})}this.center_=this.coord_=null,this.drawSketch_()}},ol.interaction.DrawRegular.prototype.startAngle={default:Math.PI/2,3:-Math.PI/2,4:Math.PI/4},ol.interaction.DrawTouch=class extends ol.interaction.CenterTouch{constructor(e){(e=e||{}).handleEvent=function(e){if(this.get("tap"))switch(this.sketch.setPosition(this.getPosition()),e.type){case"singleclick":this.addPoint();break;case"dblclick":return this.addPoint(),this.finishDrawing(),!1}return!0},super(e),e.sketchStyle||(e.sketchStyle=ol.style.Style.defaultStyle());var t=this.sketch=new ol.layer.SketchOverlay(e);t.on(["drawstart","drawabort"],function(e){this.dispatchEvent(e)}.bind(this)),t.on(["drawend"],function(t){t.feature&&t.valid&&e.source&&e.source.addFeature(t.feature),this.dispatchEvent(t)}.bind(this)),this._source=e.source,this.set("tap",!1!==e.tap),this.setActive(!1!==e.active)}setMap(e){if(this._listener)for(var t in this._listener)ol.Observable.unByKey(t);this._listener={},super.setMap(e),this.sketch.setMap(e),e&&(this._listener.center=e.on("postcompose",function(){ol.coordinate.equal(this.getPosition(),this.sketch.getPosition()||[])||this.sketch.setPosition(this.getPosition())}.bind(this)))}setGeometryType(e){return this.sketch.setGeometryType(e)}getGeometryType(){return this.sketch.getGeometryType()}finishDrawing(){this.sketch.finishDrawing(!0)}addPoint(){this.sketch.addPoint(this.getPosition())}removeLastPoint(){this.sketch.removeLastPoint()}setActive(e){super.setActive(e),this.sketch&&(this.sketch.abortDrawing(),this.sketch.setVisible(e))}},ol.interaction.DropFile=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({});var t=e.zone||document;t.addEventListener("dragenter",this.onstop),t.addEventListener("dragover",this.onstop),t.addEventListener("dragleave",this.onstop),this.formatConstructors_=e.formatConstructors||[ol.format.GPX,ol.format.GeoJSONX,ol.format.GeoJSONP,ol.format.GeoJSON,ol.format.IGC,ol.format.KML,ol.format.TopoJSON],this.projection_=e.projection,this.accept_=e.accept||["gpx","json","geojsonx","geojsonp","geojson","igc","kml","topojson"],t.addEventListener("drop",function(e){return this.ondrop(e)}.bind(this))}setMap(e){super.setMap(e)}onstop(e){return e.preventDefault(),e.stopPropagation(),!1}ondrop(e){if(e.preventDefault(),e.dataTransfer&&e.dataTransfer.files.length){var t=this.projection_||(this.getMap()?this.getMap().getView().getProjection():null),i=e.dataTransfer.files,s=/\.([0-9a-z]+)(?=[?#])|(\.)(?:[\w]+)$/;Array.prototype.forEach.call(i,function(e){var i=e.name.match(s)[0],o=this.accept_.indexOf(i.toLocaleLowerCase())>=0;if(this.dispatchEvent({type:"loadstart",file:e,filesize:e.size,filetype:e.type,fileextension:i,projection:t,isok:o}),this.formatConstructors_.length){var r=new FileReader,a=this.formatConstructors_,n=e;r.onload=function(e){var i,s,o=e.target.result,r=[];for(i=0,s=a.length;i<s;++i){var l=a[i];try{if((r=(new l).readFeatures(o,{featureProjection:t}))&&r.length>0)return this.dispatchEvent({type:"addfeatures",features:r,file:n,projection:t}),void this.dispatchEvent({type:"loadend",features:r,file:n,projection:t})}catch(e){}}this.dispatchEvent({type:"loadend",file:n,result:o})}.bind(this),r.readAsText(e)}}.bind(this))}return!1}},ol.interaction.FillAttribute=class extends ol.interaction.Select{constructor(e,t){if((e=e||{}).condition||(e.condition=ol.events.condition.click),super(e),this.setActive(!1!==e.active),this.set("name",e.name),this._attributes=t,this.on("select",function(e){this.getFeatures().clear(),this.fill(e.selected,this._attributes)}.bind(this)),void 0===e.cursor){var i=document.createElement("CANVAS");i.width=i.height=32;var s=i.getContext("2d");s.beginPath(),s.moveTo(9,3),s.lineTo(2,9),s.lineTo(10,17),s.lineTo(17,11),s.closePath(),s.fillStyle="#fff",s.fill(),s.stroke(),s.beginPath(),s.moveTo(6,4),s.lineTo(0,8),s.lineTo(0,13),s.lineTo(3,17),s.lineTo(3,8),s.closePath(),s.fillStyle="#000",s.fill(),s.stroke(),s.moveTo(8,8),s.lineTo(10,0),s.lineTo(11,0),s.lineTo(13,3),s.lineTo(13,7),s.stroke(),this._cursor="url("+i.toDataURL()+") 0 13, auto"}e.cursor&&(this._cursor=e.cursor)}setCursor(e){this._cursor=e}getCursor(){return this._cursor}setActive(e){e!==this.getActive()&&(super.setActive(e),this.getMap()&&this._cursor&&(e?(this._previousCursor=this.getMap().getTargetElement().style.cursor,ol.ext.element.setCursor(this.getMap(),this._cursor)):(ol.ext.element.setCursor(this.getMap(),this._previousCursor),this._previousCursor=void 0)))}setAttributes(e){this._attributes=e}setAttribute(e,t){this._attributes[e]=t}getAttributes(){return this._attributes}getAttribute(e){return this._attributes[e]}fill(e,t){if(e.length&&t){for(var i,s=!1,o=0;i=e[o];o++){for(var r in t)i.get(r)!==t[r]&&(s=!0);if(s)break}s&&(this.dispatchEvent({type:"setattributestart",features:e,properties:t}),e.forEach(function(e){for(var i in t)e.set(i,t[i])}),this.dispatchEvent({type:"setattributeend",features:e,properties:t}))}}},ol.interaction.Flashlight=class extends ol.interaction.Pointer{constructor(e){super({handleDownEvent:function(e){return this.setPosition(e)},handleMoveEvent:function(e){return this.setPosition(e)}}),e=e||{},this.pos=!1,this.radius=e.radius||100,this.setColor(e)}setMap(e){this.getMap()&&this.getMap().render(),this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),e&&(this._listener=e.on("postcompose",this.postcompose_.bind(this)))}setRadius(e){if(this.radius=e,this.getMap())try{this.getMap().renderSync()}catch(e){}}setColor(e){var t=e.fill?e.fill:[0,0,0,.8],i=ol.color.asArray(t);if(this.startColor=ol.color.asString(i),e.color?(this.endColor=ol.color.asString(ol.color.asArray(e.color)||e.color),i=ol.color.asArray(this.endColor)):(i[3]=0,this.endColor=ol.color.asString(i)),this.midColor=ol.color.asString(i),this.getMap())try{this.getMap().renderSync()}catch(e){}}setPosition(e){if(e.pixel?this.pos=e.pixel:this.pos=e,this.getMap())try{this.getMap().renderSync()}catch(e){}}postcompose_(e){var t=ol.ext.getMapCanvas(this.getMap()).getContext("2d"),i=e.frameState.pixelRatio,s=t.canvas.width,o=t.canvas.height;if(t.save(),t.scale(i,i),this.pos){var r=Math.max(s,o),a=t.createRadialGradient(this.pos[0],this.pos[1],s*this.radius/r,this.pos[0],this.pos[1],o*this.radius/r);a.addColorStop(0,this.startColor),a.addColorStop(.8,this.midColor),a.addColorStop(1,this.endColor),t.fillStyle=a,t.fillRect(this.pos[0]-r,this.pos[1]-r,2*r,2*r)}else t.fillStyle=this.startColor,t.fillRect(0,0,s,o);t.restore()}},ol.interaction.FocusMap=class extends ol.interaction.Interaction{constructor(){super({}),this.focusBt=ol.ext.element.create("BUTTON",{on:{focus:function(){this.dispatchEvent({type:"focus"})}.bind(this)},style:{position:"absolute",zIndex:-1,top:0,opacity:0}})}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,this.getMap()&&this.getMap().getViewport().removeChild(this.focusBt),super.setMap(e),this.getMap()&&(this._listener=this.getMap().on("pointerdown",function(){this.getActive()&&this.focusBt.focus()}.bind(this)),this.getMap().getViewport().appendChild(this.focusBt))}},ol.interaction.GeolocationDraw=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({handleEvent:function(){return!this.get("followTrack")||"auto"==this.get("followTrack")}}),this.geolocation=new ol.Geolocation({projection:"EPSG:4326",trackingOptions:{maximumAge:1e4,enableHighAccuracy:!0,timeout:6e5}}),this.geolocation.on("change",this.draw_.bind(this)),this.path_=[],this.lastPosition_=!1;var t=[255,255,255,1],i=[0,153,255,1],s=new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:i}),stroke:new ol.style.Stroke({color:t,width:1.5})}),o=[new ol.style.Style({stroke:new ol.style.Stroke({color:t,width:5})}),new ol.style.Style({stroke:new ol.style.Stroke({color:i,width:3}),fill:new ol.style.Fill({color:[255,255,255,.5]})})],r=new ol.style.RegularShape({radius:10.5,points:3,rotation:0,fill:new ol.style.Fill({color:i}),stroke:new ol.style.Stroke({color:t,width:1.5})}),a=r.getImage(),n=a.getContext("2d"),l=document.createElement("canvas");l.width=l.height=a.width,l.getContext("2d").drawImage(a,0,0),n.clearRect(0,0,a.width,a.height),n.drawImage(l,0,0,a.width,a.height,3,0,a.width-6,a.height);this.locStyle={error:new ol.style.Style({fill:new ol.style.Fill({color:[255,0,0,.2]})}),warn:new ol.style.Style({fill:new ol.style.Fill({color:[255,192,0,.2]})}),ok:new ol.style.Style({fill:new ol.style.Fill({color:[0,255,0,.2]})})},this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector,name:"GeolocationDraw overlay",style:e.style||function(e){return void 0===e.get("heading")?o[1].setImage(s):(o[1].setImage(r),r.setRotation(e.get("heading")||0)),o}}),this.sketch_=[new ol.Feature,new ol.Feature,new ol.Feature],this.overlayLayer_.getSource().addFeatures(this.sketch_),this.features_=e.features,this.source_=e.source,this.condition_=e.condition||function(e){return e.getAccuracy()<this.get("minAccuracy")},this.set("type",e.type||"LineString"),this.set("attributes",e.attributes||{}),this.set("minAccuracy",e.minAccuracy||20),this.set("tolerance",e.tolerance||5),this.set("zoom",e.zoom),this.set("minZoom",e.minZoom),this.setFollowTrack(void 0===e.followTrack||e.followTrack),this.setActive(!1)}simplify3D(e,t){var i=e.getCoordinates(),s=this.getMap().getView().getProjection();"Polygon"===this.get("type")&&(i=i[0]);for(var o,r=[i[0]],a=ol.proj.transform(i[0],s,"EPSG:4326"),n=1;n<i.length;n++){o=ol.proj.transform(i[n],s,"EPSG:4326"),ol.sphere.getDistance(a,o)>t&&(r.push(i[n]),a=o)}return r[r.length-1]!==i[i.length-1]&&r.push(i[i.length-1]),e="Polygon"===this.get("type")?new ol.geom.Polygon([r],"XYZM"):new ol.geom.LineString(r,"XYZM")}setMap(e){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),super.setMap(e),this.overlayLayer_.setMap(e),e&&this.geolocation.setProjection(e.getView().getProjection())}setActive(e){if(e!==this.getActive()){if(super.setActive(e),this.getMap()){this.geolocation.setTracking(e);try{this.getMap().renderSync()}catch(e){}}if(this.overlayLayer_)if(this.overlayLayer_.setVisible(e),this.pause(!e),e)this.reset(),this.dispatchEvent({type:"drawstart",feature:this.sketch_[1]});else{var t=this.sketch_[1].clone();t.getGeometry()&&(this.features_&&this.features_.push(t),this.source_&&this.source_.addFeature(t)),this.dispatchEvent({type:"drawend",feature:t})}}}simulate(e,t){if(this._track&&clearTimeout(this._track.timeout),e){var i=(t=t||{}).delay||1e3;this._track={track:e,pos:0,timeout:setTimeout(function e(){if(this._track.pos>=this._track.track.length)this._track=!1;else{var s=this._track.track[this._track.pos];s[2]=s[3]||0,s[3]=(new Date).getTime(),this._track.pos++,!1!==t.repeat&&(this._track.pos=this._track.pos%this._track.track.length),this.getActive()&&this.draw_(!0,s,t.accuracy),this._track.timeout=setTimeout(e.bind(this),i)}}.bind(this),0)}}else this._track=!1}simulating(){return!!this._track}reset(){this.sketch_[1].setGeometry(),this.path_=[],this.lastPosition_=!1}start(){this.setActive(!0)}stop(){this.setActive(!1)}pause(e){this.pause_=!1!==e}isPaused(){return this.pause_}setFollowTrack(e){this.set("followTrack",e);var t,i=this.getMap();if(this.getActive()&&i)if("position"!==e&&(t=this.get("minZoom")?Math.max(this.get("minZoom"),i.getView().getZoom()):this.get("zoom")),!1===e||this.lastPosition_)"auto"===e&&this.lastPosition_&&i.getView().animate({center:this.lastPosition_,zoom:t});else{var s=this.path_[this.path_.length-1];s&&i.getView().animate({center:s,zoom:t})}this.lastPosition_=!1,this.dispatchEvent({type:"follow",following:!1!==e})}draw_(e,t,i){var s=this.getMap();if(s){var o,r,a,n,l;if(this._track){if(!0!==e)return;if(r=t,o=i||10,this.path_&&this.path_.length){var h=this.path_[this.path_.length-1];l=Math.atan2(t[0]-h[0],t[1]-h[1])}var c=new ol.geom.Circle(r,s.getView().getResolution()*o);a=ol.geom.Polygon.fromCircle(c)}else o=(n=this.geolocation).getAccuracy(),r=this.getPosition(n),a=n.getAccuracyGeometry(),l=n.getHeading();switch(this.get("followTrack")){case!0:1==this.get("followTrack")&&(this.get("minZoom")?this.get("minZoom")>s.getView().getZoom()&&s.getView().setZoom(this.get("minZoom")):s.getView().setZoom(this.get("zoom")||16),ol.extent.containsExtent(s.getView().calculateExtent(s.getSize()),a.getExtent())||s.getView().fit(a.getExtent())),s.getView().setCenter(r);break;case"position":s.getView().setCenter(r);break;case"auto":if(this.lastPosition_){var u=s.getView().getCenter();u[0]!=this.lastPosition_[0]||u[1]!=this.lastPosition_[1]?this.setFollowTrack(!1):(s.getView().setCenter(r),this.lastPosition_=r)}else s.getView().setCenter(r),this.get("minZoom")?this.get("minZoom")>s.getView().getZoom()&&s.getView().setZoom(this.get("minZoom")):this.get("zoom")&&s.getView().setZoom(this.get("zoom")),this.lastPosition_=r;break;case"visible":ol.extent.containsCoordinate(s.getView().calculateExtent(s.getSize()),r)||s.getView().setCenter(r)}var d,p=this.sketch_[0];if(p.setGeometry(a),o<this.get("minAccuracy")/2?p.setStyle(this.locStyle.ok):o<this.get("minAccuracy")?p.setStyle(this.locStyle.warn):p.setStyle(this.locStyle.error),this.pause_&&(this.lastPosition_=r),!this.pause_&&(!n||this.condition_.call(this,n))){switch(p=this.sketch_[1],this.path_.push(r),this.get("type")){case"Point":this.path_=[r],p.setGeometry(new ol.geom.Point(r,"XYZM"));var g=this.get("attributes");g.heading&&p.set("heading",n.getHeading()),g.accuracy&&p.set("accuracy",n.getAccuracy()),g.altitudeAccuracy&&p.set("altitudeAccuracy",n.getAltitudeAccuracy()),g.speed&&p.set("speed",n.getSpeed());break;case"LineString":this.path_.length>1?(d=new ol.geom.LineString(this.path_,"XYZM"),this.get("tolerance")&&(d=this.simplify3D(d,this.get("tolerance"))),p.setGeometry(d)):p.setGeometry();break;case"Polygon":this.path_.length>2?(d=new ol.geom.Polygon([this.path_],"XYZM"),this.get("tolerance")&&(d=this.simplify3D(d,this.get("tolerance"))),p.setGeometry(d)):p.setGeometry()}this.dispatchEvent({type:"drawing",feature:this.sketch_[1],geolocation:n})}this.sketch_[2].setGeometry(new ol.geom.Point(r)),this.sketch_[2].set("heading",l),this.dispatchEvent({type:"tracking",feature:this.sketch_[1],geolocation:n})}}getPosition(e){var t=e.getPosition();return t.push(Math.round(100*(e.getAltitude()||0))/100),t.push(Math.round((new Date).getTime()/1e3)),t}},ol.interaction.Hover=class extends ol.interaction.Interaction{constructor(e){e||(e=e||{});var t=!1;super({handleEvent:function(s){if(!i.getActive())return!0;switch(s.type){case"pointerdrag":t=!0;break;case"pointerup":t=!1;break;case"pointermove":t||i.handleMove_(s)}return!e.handleEvent||e.handleEvent(s)}});var i=this;this.setLayerFilter(e.layerFilter),e.layers&&e.layers.length&&this.setLayerFilter(function(t){return e.layers.indexOf(t)>=0}),this.setFeatureFilter(e.featureFilter),this.set("hitTolerance",e.hitTolerance),this.setCursor(e.cursor)}setMap(e){void 0!==this.previousCursor_&&this.getMap()&&(ol.ext.element.setCursor(this.getMap(),this.previousCursor_),this.previousCursor_=void 0),super.setMap(e)}setActive(e){super.setActive(e),this.cursor_&&this.getMap()&&this.getMap().getTargetElement()&&void 0!==this.previousCursor_&&(ol.ext.element.setCursor(this.getMap(),this.previousCursor_),this.previousCursor_=void 0)}setCursor(e){!e&&void 0!==this.previousCursor_&&this.getMap()&&(ol.ext.element.setCursor(this.getMap(),this.previousCursor_),this.previousCursor_=void 0),this.cursor_=e}setFeatureFilter(e){this.featureFilter_="function"==typeof e?e:function(){return!0}}setLayerFilter(e){this.layerFilter_="function"==typeof e?e:function(){return!0}}handleMove_(e){var t=this.getMap();if(t){var i,s,o=this,r=t.forEachFeatureAtPixel(e.pixel,function(e,t){return o.featureFilter_.call(null,e,t)?(i=e,s=t,!0):(i=s=null,!1)},{hitTolerance:this.get("hitTolerance"),layerFilter:o.layerFilter_});if(r&&this.dispatchEvent({type:"hover",feature:i,layer:s,coordinate:e.coordinate,pixel:e.pixel,map:e.map,originalEvent:e.originalEvent,dragging:e.dragging}),this.feature_===i&&this.layer_===s||(this.feature_=i,this.layer_=s,i?this.dispatchEvent({type:"enter",feature:i,layer:s,coordinate:e.coordinate,pixel:e.pixel,map:e.map,originalEvent:e.originalEvent,dragging:e.dragging}):this.dispatchEvent({type:"leave",coordinate:e.coordinate,pixel:e.pixel,map:e.map,originalEvent:e.originalEvent,dragging:e.dragging})),this.cursor_){var a=t.getTargetElement().style;r?a.cursor!=this.cursor_&&(this.previousCursor_=a.cursor,ol.ext.element.setCursor(t,this.cursor_)):void 0!==this.previousCursor_&&(ol.ext.element.setCursor(t,this.previousCursor_),this.previousCursor_=void 0)}}}},ol.interaction.LongTouch=class extends ol.interaction.Interaction{constructor(e){var t,i,s=(e=e||{}).handleLongTouchEvent||function(){},o=null,r=e.pixelTolerance||0;super({handleEvent:function(e){if(this.getActive())switch(e.type){case"pointerdown":o&&clearTimeout(o),t=e.pixel,i={type:"longtouch",originalEvent:e.originalEvent,frameState:e.frameState,pixel:e.pixel,coordinate:e.coordinate,map:this.getMap()},o=setTimeout(function(){s(i),i.map.dispatchEvent(i)},this.delay_);break;case"pointerdrag":o&&(Math.abs(e.pixel[0]-t[0])>r||Math.abs(e.pixel[1]-t[1])>r)&&(clearTimeout(o),o=null);break;case"pointerup":o&&(clearTimeout(o),o=null)}else o&&(clearTimeout(o),o=null);return!0}}),this.delay_=e.delay||1e3}},ol.interaction.Modify.prototype.getModifiedFeatures=function(){var e={};this.dragSegments_.forEach(function(t){var i=t[0].feature;window&&window.ol&&window.ol.util?e[ol.util.getUid(i)]=i:e[ol.getUid(i)]=i});var t=[];for(var i in e)t.push(e[i]);return t},ol.interaction.ModifyFeature=class extends ol.interaction.Interaction{constructor(e){var t,i;e=e||{},super({handleEvent:function(e){switch(e.type){case"pointerdown":return t=this.handleDownEvent(e),i=t||this._deleteCondition(e),!t;case"pointerup":return t=!1,this.handleUpEvent(e);case"pointerdrag":return!t||this.handleDragEvent(e);case"pointermove":return!t&&this.handleMoveEvent(e);case"singleclick":case"click":return!i;default:return!0}}}),this.snapDistance_=e.pixelTolerance||10,this.tolerance_=1e-10,this.cursor_=e.cursor,this.sources_=e.sources?e.sources instanceof Array?e.sources:[e.sources]:[],e.source&&this.sources_.push(e.source),e.features&&this.sources_.push(new ol.source.Vector({features:e.features})),this.filterSplit_=e.filter||function(){return!0},this._condition=e.condition||ol.events.condition.primaryAction,this._deleteCondition=e.deleteCondition||ol.events.condition.altKeyOnly,this._insertVertexCondition=e.insertVertexCondition||ol.events.condition.always;var s=function(){return[new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:[0,153,255,1]}),stroke:new ol.style.Stroke({color:"#FFF",width:1.25})})})]};e.style&&(s="function"==typeof e.style?e.style:function(){return e.style}),this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1}),name:"Modify overlay",displayInLayerSwitcher:!1,style:s,wrapX:e.wrapX})}setMap(e){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),super.setMap(e),this.overlayLayer_.setMap(e)}setActive(e){super.setActive(e),this.overlayLayer_&&this.overlayLayer_.getSource().clear()}setFilter(e){"function"==typeof e?this.filterSplit_=e:void 0===e&&(this.filterSplit_=function(){return!0})}getClosestFeature(e){for(var t,i,s=this.snapDistance_+1,o=0;o<this.sources_.length;o++){var r=this.sources_[o];if((t=r.getClosestFeatureToCoordinate(e.coordinate))&&this.filterSplit_(t)){var a=t.getGeometry().getClosestPoint(e.coordinate),n=ol.coordinate.dist2d(e.coordinate,a)/e.frameState.viewState.resolution;n<s&&(s=n,i=a);break}}if(s>this.snapDistance_)return this.currentFeature&&this.dispatchEvent({type:"select",selected:[],deselected:[this.currentFeature]}),this.currentFeature=null,!1;var l=this.getNearestCoord(i,t.getGeometry());if(l){l=l.coord;var h=this.getMap().getPixelFromCoordinate(l);return ol.coordinate.dist2d(e.pixel,h)<this.snapDistance_&&(i=l),this.currentFeature!==t&&this.dispatchEvent({type:"select",selected:[t],deselected:[this.currentFeature]}),this.currentFeature=t,{source:r,feature:t,coord:i}}}getNearestCoord(e,t){var i,s,o,r,a;switch(t.getType()){case"Point":return{coord:t.getCoordinates(),dist:ol.coordinate.dist2d(t.getCoordinates(),e)};case"MultiPoint":return this.getNearestCoord(e,new ol.geom.LineString(t.getCoordinates()));case"LineString":case"LinearRing":var n;a=Number.MAX_VALUE;var l=t.getCoordinates();for(i=0;i<l.length;i++)(n=ol.coordinate.dist2d(e,l[i]))<a&&(a=n,r=l[i]);return{coord:r,dist:a};case"MultiLineString":var h=t.getLineStrings();for(r=!1,a=Number.MAX_VALUE,i=0;s=h[i];i++)(o=this.getNearestCoord(e,s))&&o.dist<a&&(r=o,a=o.dist,r.ring=i);return r;case"Polygon":var c=t.getLinearRings();for(r=!1,a=Number.MAX_VALUE,i=0;s=c[i];i++)(o=this.getNearestCoord(e,s))&&o.dist<a&&(r=o,a=o.dist,r.ring=i);return r;case"MultiPolygon":var u=t.getPolygons();for(r=!1,a=Number.MAX_VALUE,i=0;s=u[i];i++)(o=this.getNearestCoord(e,s))&&o.dist<a&&(r=o,a=o.dist,r.poly=i);return r;case"GeometryCollection":var d=t.getGeometries();for(r=!1,a=Number.MAX_VALUE,i=0;s=d[i];i++)(o=this.getNearestCoord(e,s))&&o.dist<a&&(r=o,a=o.dist,r.geom=i);return r;default:return!1}}getArcs(e,t){var i,s,o,r,a,n=!1;switch(e.getType()){case"Point":ol.coordinate.equal(t,e.getCoordinates())&&(n={geom:e,type:e.getType(),coord1:[],coord2:[],node:!0});break;case"MultiPoint":for(i=e.getCoordinates(),s=0;s<i.length;s++)if(ol.coordinate.equal(t,i[s])){n={geom:e,type:e.getType(),index:s,coord1:[],coord2:[],node:!0};break}break;case"LinearRing":case"LineString":var l=e.getClosestPoint(t);if(ol.coordinate.dist2d(l,t)<1.5*this.tolerance_){var h;if((h="LinearRing"===e.getType()?(a=new ol.geom.LineString(e.getCoordinates())).splitAt(t,this.tolerance_):e.splitAt(t,this.tolerance_)).length>2){for(i=h[1].getCoordinates(),s=2;o=h[s];s++){var c=o.getCoordinates();c.shift(),i=i.concat(c)}h=[h[0],new ol.geom.LineString(i)]}if(2===h.length){var u=h[0].getCoordinates(),d=h[1].getCoordinates(),p=u.length+d.length-1;u.pop(),d.shift(),n={geom:e,type:e.getType(),coord1:u,coord2:d,node:e.getCoordinates().length===p,closed:!1}}else if(1===h.length){o=h[0].getCoordinates();var g=ol.coordinate.equal(o[0],t),m=ol.coordinate.equal(o[o.length-1],t);g?(o.shift(),m&&o.pop(),n={geom:e,type:e.getType(),coord1:[],coord2:o,node:!0,closed:m}):m&&(o.pop(),n={geom:e,type:e.getType(),coord1:o,coord2:[],node:!0,closed:!1})}}break;case"MultiLineString":var f=e.getLineStrings();for(s=0;r=f[s];s++)if(n=this.getArcs(r,t)){n.geom=e,n.type=e.getType(),n.lstring=s;break}break;case"Polygon":var v=e.getLinearRings();for(s=0;r=v[s];s++)if(n=this.getArcs(r,t)){n.geom=e,n.type=e.getType(),n.index=s;break}break;case"MultiPolygon":var y=e.getPolygons();for(s=0;r=y[s];s++)if(n=this.getArcs(r,t)){n.geom=e,n.type=e.getType(),n.poly=s;break}break;case"GeometryCollection":for(a=e.getGeometries(),s=0;r=a[s];s++)if(n=this.getArcs(r,t)){n.geom=e,n.g=s,n.typeg=n.type,n.type=e.getType();break}break;default:console.error("ol/interaction/ModifyFeature "+e.getType()+" not supported!")}return n}handleDownEvent(e){if(!this.getActive())return!1;var t=this.getClosestFeature(e);if(t&&(this._condition(e)||this._deleteCondition(e))){var i=[];return this.arcs=[],this.sources_.forEach(function(e){var s=ol.extent.buffer(ol.extent.boundingExtent([t.coord]),this.tolerance_);i=i.concat(i,e.getFeaturesInExtent(s))}.bind(this)),this._modifiedFeatures=[],i.forEach(function(i){var s=this.getArcs(i.getGeometry(),t.coord);s&&(this._insertVertexCondition(e)||s.node)&&(s.feature=i,this._modifiedFeatures.push(i),this.arcs.push(s))}.bind(this)),!this._modifiedFeatures.length||(this._deleteCondition(e)?!this._removePoint(t,e):(this.dispatchEvent({type:"modifystart",coordinate:t.coord,originalEvent:e.originalEvent,features:this._modifiedFeatures}),this.handleDragEvent({coordinate:t.coord,originalEvent:e.originalEvent}),!0))}return!1}getModifiedFeatures(){return this._modifiedFeatures||[]}removePoint(){this._removePoint({},{})}_getModification(e){var t=e.coord1.concat(e.coord2);switch(e.type){case"LineString":if(e.closed&&t.push(t[0]),t.length>1&&e.geom.getCoordinates().length!=t.length)return e.coords=t,!0;break;case"MultiLineString":if(e.closed&&t.push(t[0]),t.length>1){var i=e.geom.getCoordinates();if(i[e.lstring].length!=t.length)return i[e.lstring]=t,e.coords=i,!0}break;case"Polygon":if(e.closed&&t.push(t[0]),t.length>3&&(i=e.geom.getCoordinates())[e.index].length!=t.length)return i[e.index]=t,e.coords=i,!0;break;case"MultiPolygon":if(e.closed&&t.push(t[0]),t.length>3&&(i=e.geom.getCoordinates())[e.poly][e.index].length!=t.length)return i[e.poly][e.index]=t,e.coords=i,!0;break;case"GeometryCollection":e.type=e.typeg;var s=e.geom,o=s.getGeometries();e.geom=o[e.g];var r=this._getModification(e);return s.setGeometries(o),e.geom=s,e.type="GeometryCollection",r}return!1}_removePoint(e,t){if(!this.arcs)return!1;this.overlayLayer_.getSource().clear();var i=!1;return this.arcs.forEach(function(e){i=i||this._getModification(e)}.bind(this)),i&&(this.dispatchEvent({type:"modifystart",coordinate:e.coord,originalEvent:t.originalEvent,features:this._modifiedFeatures}),this.arcs.forEach(function(e){if("GeometryCollection"===e.geom.getType()){if(e.coords){var t=e.geom.getGeometries();t[e.g].setCoordinates(e.coords),e.geom.setGeometries(t)}}else e.coords&&e.geom.setCoordinates(e.coords)}.bind(this)),this.dispatchEvent({type:"modifyend",coordinate:e.coord,originalEvent:t.originalEvent,features:this._modifiedFeatures})),this.arcs=[],i}handleUpEvent(e){return!!this.getActive()&&(!this.arcs||!this.arcs.length||(this.overlayLayer_.getSource().clear(),this.dispatchEvent({type:"modifyend",coordinate:e.coordinate,originalEvent:e.originalEvent,features:this._modifiedFeatures}),this.arcs=[],!0))}setArcCoordinates(e,t){var i;switch(e.type){case"Point":e.geom.setCoordinates(t[0]);break;case"MultiPoint":(i=e.geom.getCoordinates())[e.index]=t[0],e.geom.setCoordinates(i);break;case"LineString":e.geom.setCoordinates(t);break;case"MultiLineString":(i=e.geom.getCoordinates())[e.lstring]=t,e.geom.setCoordinates(i);break;case"Polygon":(i=e.geom.getCoordinates())[e.index]=t,e.geom.setCoordinates(i);break;case"MultiPolygon":(i=e.geom.getCoordinates())[e.poly][e.index]=t,e.geom.setCoordinates(i);break;case"GeometryCollection":e.type=e.typeg;var s=e.geom,o=s.getGeometries();e.geom=o[e.g],this.setArcCoordinates(e,t),s.setGeometries(o),e.geom=s,e.type="GeometryCollection"}}handleDragEvent(e){if(!this.getActive())return!1;if(!this.arcs)return!0;this.overlayLayer_.getSource().clear();var t=new ol.Feature(new ol.geom.Point(e.coordinate));return this.overlayLayer_.getSource().addFeature(t),!this.arcs.length||(this.arcs.forEach(function(t){var i=t.coord1.concat([e.coordinate],t.coord2);t.closed&&i.push(e.coordinate),this.setArcCoordinates(t,i)}.bind(this)),this.dispatchEvent({type:"modifying",coordinate:e.coordinate,originalEvent:e.originalEvent,features:this._modifiedFeatures}),!0)}handleMoveEvent(e){if(!this.getActive())return!0;this.overlayLayer_.getSource().clear();var t=this.getClosestFeature(e);if(t){var i=new ol.Feature(new ol.geom.Point(t.coord));this.overlayLayer_.getSource().addFeature(i)}var s=e.map.getTargetElement();return this.cursor_&&(t?s.style.cursor!=this.cursor_&&(this.previousCursor_=s.style.cursor,ol.ext.element.setCursor(s,this.cursor_)):void 0!==this.previousCursor_&&(ol.ext.element.setCursor(s,this.previousCursor_),this.previousCursor_=void 0)),!0}getCurrentFeature(){return this.currentFeature}},ol.interaction.ModifyTouch=class extends ol.interaction.Modify{constructor(e){var t=((e=e||{}).pixelTolerance||0)+5;e.condition=function(e){var i,s,o=this.getMap().getFeaturesAtPixel(e.pixel,{hitTolerance:t}),r=!1;if(o){var a=this._features;if(!a){i=[e.pixel[0]-t,e.pixel[1]-t],s=[e.pixel[0]+t,e.pixel[1]+t],i=this.getMap().getCoordinateFromPixel(i),s=this.getMap().getCoordinateFromPixel(s);var n=ol.extent.boundingExtent([i,s]);a=this._source.getFeaturesInExtent(n)}a.getArray&&(a=a.getArray());for(var l,h=0;(l=o[h])&&!(a.indexOf(l)>=0);h++);if(l){i=e.pixel,s=l.getGeometry().getClosestPoint(e.coordinate),s=this.getMap().getPixelFromCoordinate(s);var c=i[0]-s[0],u=i[1]-s[1];r=Math.sqrt(c*c+u*u)<t}}return this.showDeleteBt(r?{type:"show",feature:l,coordinate:e.coordinate}:{type:"hide"}),!0},e.insertVertexCondition=function(){return this.showDeleteBt({type:"hide"}),!0},super(e),this._popup=new ol.Overlay.Popup({popupClass:e.className||"modifytouch",positioning:e.positioning||"bottom-rigth",offsetBox:e.offsetBox||10}),this._source=e.source,this._features=e.features;var i=document.createElement("a");i.appendChild(document.createTextNode(e.title||"remove point")),i.onclick=function(){this.removePoint()}.bind(this),this.setPopupContent(i),this.on(["modifystart","modifyend"],function(){this.showDeleteBt({type:"hide",modifying:!0})}),this.set("usePopup",!1!==e.usePopup)}setMap(e){this.getMap()&&this.getMap().removeOverlay(this._popup),super.setMap(e),this.getMap()&&this.getMap().addOverlay(this._popup)}setActive(e){super.setActive(e),this.showDeleteBt({type:"hide"})}removePoint(){new Date-this._timeout<200||(super.removePoint(),this.showDeleteBt({type:"hide"}))}showDeleteBt(e){this._popup&&(this.get("usePopup")&&"show"===e.type?this._popup.show(e.coordinate,this._menu):this._popup.hide(),e.type+="popup",this.dispatchEvent(e),this._timeout=new Date)}setPopupContent(e){this._menu=e}getPopupContent(){return this._menu}},ol.interaction.Offset=class extends ol.interaction.Pointer{constructor(e){e=e||{},super({handleDownEvent:function(e){return t.handleDownEvent_(e)},handleDragEvent:function(e){return t.handleDragEvent_(e)},handleMoveEvent:function(e){return t.handleMoveEvent_(e)},handleUpEvent:function(e){return t.handleUpEvent_(e)}});var t=this;this._filter=e.filter,this.features_=e.features,this.layers_=e.layers?e.layers instanceof Array?e.layers:[e.layers]:null,this.set("duplicate",e.duplicate),this.source_=e.source,this._style="function"==typeof e.style?e.style:function(){return e.style?e.style:ol.style.Style.defaultStyle(!0)},this.previousCursor_=!1}getFeatureAtPixel_(e){var t=this;return this.getMap().forEachFeatureAtPixel(e.pixel,function(i,s){var o;if(t._filter&&!t._filter(i,s))return!1;if(t.layers_){for(var r=0;r<t.layers_.length;r++)if(t.layers_[r]===s){o=i;break}}else t.features_?t.features_.forEach(function(e){e===i&&(o=i)}):o=i;var a=o.getGeometry().getType();if(o&&/Polygon|LineString/.test(a)){if("Polygon"===a&&o.getGeometry().getCoordinates().length>1)return!1;var n=o.getGeometry().getClosestPoint(e.coordinate),l=n[0]-e.coordinate[0],h=n[1]-e.coordinate[1];return Math.sqrt(l*l+h*h)/e.frameState.viewState.resolution<5&&{feature:o,hit:n,coordinates:o.getGeometry().getCoordinates(),geom:o.getGeometry().clone(),geomType:a}}return!1},{hitTolerance:5})}handleDownEvent_(e){return this.current_=this.getFeatureAtPixel_(e),!!this.current_&&(this.currentStyle_=this.current_.feature.getStyle(),this.source_&&(this.get("duplicate")||e.originalEvent.ctrlKey)?(this.current_.feature=this.current_.feature.clone(),this.current_.feature.setStyle(this._style(this.current_.feature)),this.source_.addFeature(this.current_.feature)):(this.current_.feature.setStyle(this._style(this.current_.feature)),this._modifystart=!0),this.dispatchEvent({type:"offsetstart",feature:this.current_.feature,offset:0}),!0)}handleDragEvent_(e){this._modifystart&&(this.dispatchEvent({type:"modifystart",features:[this.current_.feature]}),this._modifystart=!1);var t,i,s,o,r=this.current_.geom.getClosestPoint(e.coordinate),a=ol.coordinate.dist2d(r,e.coordinate);switch(this.current_.geomType){case"Polygon":if(t=ol.coordinate.findSegment(r,this.current_.coordinates[0]).segment){i=[t[1][0]-t[0][0],t[1][1]-t[0][1]],s=[e.coordinate[0]-r[0],e.coordinate[1]-r[1]],i[0]*s[1]-i[1]*s[0]>0&&(a=-a),o=[];for(var n=0;n<this.current_.coordinates.length;n++)o.push(ol.coordinate.offsetCoords(this.current_.coordinates[n],0==n?a:-a));this.current_.feature.setGeometry(new ol.geom.Polygon(o))}break;case"LineString":(t=ol.coordinate.findSegment(r,this.current_.coordinates).segment)&&(i=[t[1][0]-t[0][0],t[1][1]-t[0][1]],s=[e.coordinate[0]-r[0],e.coordinate[1]-r[1]],i[0]*s[1]-i[1]*s[0]>0&&(a=-a),o=ol.coordinate.offsetCoords(this.current_.coordinates,a),this.current_.feature.setGeometry(new ol.geom.LineString(o)))}this.dispatchEvent({type:"offsetting",feature:this.current_.feature,offset:a,segment:[r,e.coordinate],coordinate:e.coordinate})}handleUpEvent_(e){this._modifystart||this.dispatchEvent({type:"offsetend",feature:this.current_.feature,coordinate:e.coordinate}),this.current_.feature.setStyle(this.currentStyle_),this.current_=!1}handleMoveEvent_(e){this.getFeatureAtPixel_(e)?(!1===this.previousCursor_&&(this.previousCursor_=e.map.getTargetElement().style.cursor),ol.ext.element.setCursor(e.map,"pointer")):(ol.ext.element.setCursor(e.map,this.previousCursor_),this.previousCursor_=!1)}},ol.interaction.Ripple=class extends ol.interaction.Pointer{constructor(e){super({handleDownEvent:function(e){return this.rainDrop(e)},handleMoveEvent:function(e){return this.rainDrop(e)}}),e=e||{},this.riprad=e.radius||3,this.ripplemap=[],this.last_map=[],this.rains(this.interval),e.layer.on(["postcompose","postrender"],this.postcompose_.bind(this))}rains(e){this.onrain&&clearTimeout(this.onrain);var t=this,i=("number"==typeof e?e:1e3)/2,s=3*i/2,o=Math.random;s&&function e(){t.width&&t.rainDrop([o()*t.width,o()*t.height]),t.onrain=setTimeout(e,o()*i+s)}()}rainDrop(e){if(this.width){var t,i;e.pixel?(t=e.pixel[0]*this.ratio,i=e.pixel[1]*this.ratio):(t=e[0]*this.ratio,i=e[1]*this.ratio),t<<=0;for(var s=(i<<=0)-this.riprad*this.ratio;s<i+this.riprad*this.ratio;s++)for(var o=t-this.riprad*this.ratio;o<t+this.riprad*this.ratio;o++)this.ripplemap[this.oldind+s*this.width+o]+=128}}postcompose_(e){var t,i,s,o,r,a=e.context,n=a.canvas;if(this.width!=n.width||this.height!=n.height){this.width=n.width,this.height=n.height,this.ratio=e.frameState.pixelRatio,this.half_width=this.width>>1,this.half_height=this.height>>1,this.size=this.width*(this.height+2)*2,this.oldind=this.width,this.newind=this.width*(this.height+3);for(var l=0;l<this.size;l++)this.last_map[l]=this.ripplemap[l]=0}this.texture=a.getImageData(0,0,this.width,this.height),this.ripple=a.getImageData(0,0,this.width,this.height);var h=this.oldind;this.oldind=this.newind,this.newind=h,l=0;for(var c=this.ripple.data,u=this.texture.data,d=0;d<this.height;d++)for(var p=0;p<this.width;p++){var g=this.newind+l,m=this.oldind+l;s=this.ripplemap[m-this.width]+this.ripplemap[m+this.width]+this.ripplemap[m-1]+this.ripplemap[m+1]>>1,s-=this.ripplemap[g],s-=s>>5,this.ripplemap[g]=s,s=1024-s,this.last_map[l]!=s&&(this.last_map[l]=s,t=((p-this.half_width)*s/1024<<0)+this.half_width,i=((d-this.half_height)*s/1024<<0)+this.half_height,t>=this.width&&(t=this.width-1),t<0&&(t=0),i>=this.height&&(i=this.height-1),i<0&&(i=0),r=4*(t+i*this.width),c[o=4*l]=u[r],c[o+1]=u[r+1],c[o+2]=u[r+2]),++l}a.putImageData(this.ripple,0,0),this.getMap().render()}},ol.interaction.SelectCluster=class extends ol.interaction.Select{constructor(e){e=e||{};var t=new ol.layer.Vector({source:new ol.source.Vector({features:new ol.Collection,wrapX:e.wrapX,useSpatialIndex:!0}),name:"Cluster overlay",updateWhileAnimating:!0,updateWhileInteracting:!0,displayInLayerSwitcher:!1,style:e.featureStyle});if(e.layers)if("function"==typeof e.layers){var i=e.layers;e.layers=function(e){return e===t||i(e)}}else e.layers.push&&e.layers.push(t);if(e.filter){var s=e.filter;e.filter=function(e,t){return!(!t&&e.get("selectclusterlink"))&&s(e,t)}}else e.filter=function(e,t){return!(!t&&e.get("selectclusterlink"))};!1!==e.autoClose||e.toggleCondition||(e.toggleCondition=ol.events.condition.singleClick),super(e),this.overlayLayer_=t,this.filter_=e.filter,this.pointRadius=e.pointRadius||12,this.circleMaxObjects=e.circleMaxObjects||10,this.maxObjects=e.maxObjects||60,this.spiral=!1!==e.spiral,this.animate=e.animate,this.animationDuration=e.animationDuration||500,this.selectCluster_=!1!==e.selectCluster,this._autoClose=!1!==e.autoClose,this.on("select",this.selectCluster.bind(this))}setMap(e){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),this.overlayLayer_.setMap(e),e&&e.getView()&&(this._listener=e.getView().on("change:resolution",this.clear.bind(this)))}clear(){this.getFeatures().clear(),this.overlayLayer_.getSource().clear()}getLayer(){return this.overlayLayer_}selectCluster(e){if(e instanceof ol.Feature&&(e={selected:[e]}),e.selected.length){var t=e.selected[0];if(!t.get("selectclusterfeature")){var i=this.overlayLayer_.getSource();this._autoClose&&i.clear();var s=t.get("features");if(s&&1!=s.length){this.selectCluster_||this.getFeatures().clear();var o,r,a,n,l,h,c,u=t.getGeometry().getCoordinates(),d=this.getMap().getView(),p=ol.proj.getUserProjection(),g=d.getResolution()*(p?d.getProjection().getMetersPerUnit()/p.getMetersPerUnit():1),m=[];if(!this.spiral||s.length<=this.circleMaxObjects)for(n=Math.min(s.length,this.circleMaxObjects),o=g*this.pointRadius*(.5+n/4),a=0;a<n;a++)r=2*Math.PI*a/n,2!=n&&4!=n||(r+=Math.PI/4),l=[u[0]+o*Math.sin(r),u[1]+o*Math.cos(r)],(h=new ol.Feature({selectclusterfeature:!0,features:[s[a]],geometry:new ol.geom.Point(l)})).setStyle(s[a].getStyle()),m.push(h),c=new ol.Feature({selectclusterlink:!0,geometry:new ol.geom.LineString([u,l])}),m.push(c);else{r=0;var f=2*this.pointRadius;for(n=Math.min(this.maxObjects,s.length),a=0;a<n;a++){r+=(f+.1)/(o=f/2+f*r/(2*Math.PI));var v=g*o*Math.sin(r),y=g*o*Math.cos(r);l=[u[0]+v,u[1]+y],(h=new ol.Feature({selectclusterfeature:!0,features:[s[a]],geometry:new ol.geom.Point(l)})).setStyle(s[a].getStyle()),m.push(h),c=new ol.Feature({selectclusterlink:!0,geometry:new ol.geom.LineString([u,l])}),m.push(c)}}t.set("selectcluserfeatures",m),this.animate?this.animateCluster_(u,m):i.addFeatures(m)}}}else{this._autoClose?this.clear():e.deselected.forEach(e=>{var t=e.get("selectcluserfeatures");t&&t.forEach(e=>{this.overlayLayer_.getSource().removeFeature(e)})})}}animateCluster_(e,t){if(this.listenerKey_&&ol.Observable.unByKey(this.listenerKey_),t.length){var i=this.overlayLayer_.getStyle(),s="function"==typeof i?i:i.length?function(){return i}:function(){return[i]},o=this.animationDuration||500,r=(new Date).getTime();this.listenerKey_=this.overlayLayer_.on(["postcompose","postrender"],function(i){for(var a,n=i.vectorContext||ol.render.getVectorContext(i),l=i.frameState.pixelRatio,h=this.getMap().getView(),c=ol.proj.getUserProjection(),u=h.getResolution()+(c?h.getProjection().getMetersPerUnit()/c.getMetersPerUnit():1),d=ol.easing.easeOut((i.frameState.time-r)/o),p=0;a=t[p];p++)if(a.get("features")){var g=a.getGeometry().getCoordinates();g[0]=e[0]+d*(g[0]-e[0]),g[1]=e[1]+d*(g[1]-e[1]);for(var m=new ol.geom.Point(g),f=s(a,u),v=0;v<f.length;v++){var y,_=!ol.Map.prototype.getFeaturesAtPixel&&f[v].getImage();_&&(y=_.getScale(),_.setScale(l)),n.setStyle?(n.setStyle(f[v]),n.drawGeometry(m)):(n.setImageStyle(_),n.drawPointGeometry(m)),_&&_.setScale(y)}}if(d>1)return ol.Observable.unByKey(this.listenerKey_),this.overlayLayer_.getSource().addFeatures(t),void this.overlayLayer_.changed();i.frameState.animate=!0}.bind(this));var a=new ol.Feature(new ol.geom.Point(this.getMap().getView().getCenter()));a.setStyle(new ol.style.Style({image:new ol.style.Circle({})})),this.overlayLayer_.getSource().addFeature(a)}}getClusterExtent(e){if(!e.get("features"))return null;var t=ol.extent.createEmpty();return e.get("features").forEach(function(e){t=ol.extent.extend(t,e.getGeometry().getExtent())}),t[0]===t[2]&&t[1]===t[3]?null:t}},ol.interaction.SnapGuides=class extends ol.interaction.Interaction{constructor(e){function t(e,t){var i=e[1][0]-e[0][0],s=e[1][1]-e[0][1],o=t[1][0]-t[0][0],r=t[1][1]-t[0][1],a=i*r-s*o;if(0!=a){var n=(i*e[0][1]-i*t[0][1]-s*e[0][0]+s*t[0][0])/a;return[t[0][0]+n*o,t[0][1]+n*r]}return!1}function i(e,t){var i=e[0]-t[0],s=e[1]-t[1];return Math.sqrt(i*i+s*s)}e=e||{},super({handleEvent:function(e){if(this.getActive()){for(var s,o=this.overlaySource_.getFeatures(),r=null,a=null,n=e.frameState.viewState.resolution,l=0;s=o[l];l++){var h=s.getGeometry().getClosestPoint(e.coordinate);if(i(h,e.coordinate)/n<this.snapDistance_){if(r){var c=t(r.getGeometry().getCoordinates(),s.getGeometry().getCoordinates());c&&i(c,e.coordinate)/n<this.snapDistance_&&(a=c)}else a=h;r=s}}a&&(e.coordinate=a)}return!0}}),this.snapDistance_=e.pixelTolerance||10,this.enableInitialGuides_=e.enableInitialGuides||!1;var s=[new ol.style.Style({stroke:new ol.style.Stroke({color:"#ffcc33",lineDash:[8,5],width:1.25})})];e.style&&(s=e.style instanceof Array?e.style:[e.style]),this.overlaySource_=new ol.source.Vector({features:new ol.Collection,useSpatialIndex:!1});var o=e.vectorClass||ol.layer.Vector;this.overlayLayer_=new o({renderMode:"image",source:this.overlaySource_,style:function(){return s},name:"Snap overlay",displayInLayerSwitcher:!1}),this.overlayLayer_.setVisible(this.getActive())}setMap(e){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),super.setMap(e),this.overlayLayer_.setMap(e),e&&(this.projExtent_=e.getView().getProjection().getExtent())}setActive(e){this.overlayLayer_&&this.overlayLayer_.setVisible(e),super.setActive(e)}clearGuides(e){if(e)for(var t,i=0;t=e[i];i++)try{this.overlaySource_.removeFeature(t)}catch(e){}else this.overlaySource_.clear()}getGuides(){return this.overlaySource_.getFeaturesCollection()}addGuide(e,t){if(e){var i=this.getMap(),s=i.getView().calculateExtent(i.getSize()),o=Math.max(this.projExtent_[2]-this.projExtent_[0],this.projExtent_[3]-this.projExtent_[1]);(s=ol.extent.buffer(s,1.5*o))[0]<this.projExtent_[0]&&(s[0]=this.projExtent_[0]),s[1]<this.projExtent_[1]&&(s[1]=this.projExtent_[1]),s[2]>this.projExtent_[2]&&(s[2]=this.projExtent_[2]),s[3]>this.projExtent_[3]&&(s[3]=this.projExtent_[3]);var r=e[0][0]-e[1][0],a=e[0][1]-e[1][1],n=1/Math.sqrt(r*r+a*a),l=function(i){for(var l,h=[],c=o*i*2,u=0;(i>0?u<c:u>c)&&(l=t?[e[0][0]+a*n*u,e[0][1]-r*n*u]:[e[0][0]+r*n*u,e[0][1]+a*n*u],ol.extent.containsCoordinate(s,l));u+=o*i/100)h.push(l);return new ol.Feature(new ol.geom.LineString([h[0],h[h.length-1]]))},h=l(1),c=l(-1);return this.overlaySource_.addFeature(h),this.overlaySource_.addFeature(c),[h,c]}}addOrthoGuide(e){return this.addGuide(e,!0)}setDrawInteraction(e){var t=this,i=0,s=[];function o(e){var o=e.target.getCoordinates();switch(e.target.getType()){case"Point":return;case"Polygon":o=o[0].slice(0,-1)}var r=o.length;if(2===r&&t.enableInitialGuides_){var a=o[0][0],n=o[0][1];o=[[a,n],[a,n-1]]}if(r!=i&&(t.enableInitialGuides_?r>=2:r>2)){t.clearGuides(s);try{var l=o[r-2],h=o[r-2-1];r>2&&(l[0]!==h[0]||l[1]!==h[1])&&(s=t.addOrthoGuide([o[r-2],o[r-2-1]])),s=(s=s.concat(t.addGuide([o[0],o[1]]))).concat(t.addOrthoGuide([o[0],o[1]])),i=r}catch(e){}}}e.on("drawstart",function(e){e.feature.getGeometry().on("change",o)}),e.on(["drawend","change:active"],function(e){t.clearGuides(s),e.feature&&e.feature.getGeometry().un("change",o),i=0,s=[]})}setModifyInteraction(e){function t(e,t){return(e%t+t)%t}var i=this,s=[];function o(e){var o=e.coordinate;if(!o){var r=e.target.vertexFeature_;if(!r)return;o=r.getGeometry().getCoordinates()}var a=e.target.getModifiedFeatures()[0].getGeometry(),n=a.getCoordinates();switch(a.getType()){case"Point":return;case"Polygon":n=n[0].slice(0,-1)}var l=n.findIndex(function(e){return e[0]===o[0]&&e[1]===o[1]}),h=n.length;i.clearGuides(s),s=(s=(s=(s=i.addOrthoGuide([n[t(l-1,h)],n[t(l-2,h)]])).concat(i.addGuide([n[t(l-1,h)],n[t(l-2,h)]]))).concat(i.addGuide([n[t(l+1,h)],n[t(l+2,h)]]))).concat(i.addOrthoGuide([n[t(l+1,h)],n[t(l+2,h)]]))}e.on("modifystart",function(e){setTimeout(o,0,e)}),e.on("modifyend",function(){i.clearGuides(s),s=[]})}},ol.interaction.SnapLayerPixel=class extends ol.interaction.Interaction{constructor(e){var t=(e=e||{}).radius||8,i=2*t;super({handleEvent:function(e){if(this._layer.getVisible()&&this._layer.getOpacity()&&ol.events.condition.altKeyOnly(e)&&this.getMap()){var s,o,r,a,n=e.pixel[0]-t,l=e.pixel[1]-t,h=this._ctx.getImageData(n,l,i,i).data,c=-1,u=[];for(s=0;s<i;s++)for(u.push([]),o=0;o<i;o++){var d=h[3+4*(s+o*i)];u[s].push(d>10?d:0)}for(s=1;s<i-1;s++)for(o=1;o<i-1;o++){var p=u[s][o+1]+u[s][o]+u[s][o+1]+u[s-1][o-1]+u[s-1][o]+u[s-1][o+1]+u[s+1][o-1]+u[s+1][o]+u[s+1][o+1];p>c&&(c=p,r=s,a=o)}e.pixel=[n+r,l+a],e.coordinate=this.getMap().getCoordinateFromPixel(e.pixel)}return!0}}),this._layer=e.layer,this._layer.on(["postcompose","postrender"],function(e){this._ctx=e.context}.bind(this))}},ol.interaction.Split=class extends ol.interaction.Interaction{constructor(e){e||(e={}),super({handleEvent:function(e){switch(e.type){case"singleclick":return this.handleDownEvent(e);case"pointermove":return this.handleMoveEvent(e);default:return!0}}}),this.snapDistance_=e.snapDistance||25,this.tolerance_=e.tolerance||1e-10,this.cursor_=e.cursor,this.setSources(e.sources),e.features&&(this.sources_||(this.sources_=[]),this.sources_.push(new ol.source.Vector({features:e.features}))),this.filterSplit_=e.filter||function(){return!0};var t=[255,255,255,1],i=[0,153,255,1],s=new ol.style.Fill({color:"rgba(255,255,255,0.4)"}),o=new ol.style.Stroke({color:"#3399CC",width:1.25}),r=[new ol.style.Style({image:new ol.style.Circle({fill:s,stroke:o,radius:5}),fill:s,stroke:o})],a=[new ol.style.Style({stroke:new ol.style.Stroke({color:t,width:5})}),new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:i}),stroke:new ol.style.Stroke({color:t,width:1.5})}),stroke:new ol.style.Stroke({color:i,width:3})})];e.sketchStyle&&(r=e.sketchStyle instanceof Array?e.sketchStyle:[e.sketchStyle]),e.featureStyle&&(a=e.featureStyle instanceof Array?e.featureStyle:[e.featureStyle]),this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({useSpatialIndex:!1}),name:"Split overlay",displayInLayerSwitcher:!1,style:function(e){return e._sketch_?r:a}})}setMap(e){this.getMap()&&this.getMap().removeLayer(this.overlayLayer_),super.setMap(e),this.overlayLayer_.setMap(e)}getSources(){if(!this.sources_&&this.getMap()){var e=[],t=function(i){i.forEach(function(i){i.getVisible()&&(i.getSource&&i.getSource()instanceof ol.source.Vector?e.unshift(i.getSource()):i.getLayers&&t(i.getLayers()))})};return t(this.getMap().getLayers()),e}return this.sources_||[]}setSources(e){this.sources_=!!e&&(e instanceof Array?e||!1:[e])}getClosestFeature(e){var t,i,s,o,r=this.snapDistance_+1;if(this.getSources().forEach(function(a){var n=a.getClosestFeatureToCoordinate(e.coordinate);if(n&&n.getGeometry().splitAt){var l=n.getGeometry().getClosestPoint(e.coordinate),h=new ol.geom.LineString([e.coordinate,l]),c=h.getLength()/e.frameState.viewState.resolution;c<r&&(t=a,r=c,i=n,o=h,s=l)}}),r>this.snapDistance_)return!1;var a=this.getNearestCoord(s,i.getGeometry().getCoordinates()),n=this.getMap().getPixelFromCoordinate(a);return ol.coordinate.dist2d(e.pixel,n)<this.snapDistance_&&(s=a),{source:t,feature:i,coord:s,link:o}}getNearestCoord(e,t){for(var i,s,o=Number.MAX_VALUE,r=0;r<t.length;r++)(i=ol.coordinate.dist2d(e,t[r]))<o&&(o=i,s=t[r]);return s}handleDownEvent(e){var t=this.getClosestFeature(e);if(t){this.overlayLayer_.getSource().clear();var i,s=t.feature.getGeometry().splitAt(t.coord,this.tolerance_);if(s.length>1){var o=[];for(i=0;i<s.length;i++){var r=t.feature.clone();r.setGeometry(s[i]),o.push(r)}for(this.dispatchEvent({type:"beforesplit",original:t.feature,features:o}),t.source.dispatchEvent({type:"beforesplit",original:t.feature,features:o}),t.source.removeFeature(t.feature),i=0;i<o.length;i++)t.source.addFeature(o[i]);this.dispatchEvent({type:"aftersplit",original:t.feature,features:o}),t.source.dispatchEvent({type:"aftersplit",original:t.feature,features:o})}}return!1}handleMoveEvent(e){var t=e.map;this.overlayLayer_.getSource().clear();var i,s,o=this.getClosestFeature(e);o&&this.filterSplit_(o.feature)?(this.overlayLayer_.getSource().addFeature(o.feature),(i=new ol.Feature(new ol.geom.Point(o.coord)))._sketch_=!0,this.overlayLayer_.getSource().addFeature(i),(s=new ol.Feature(o.link))._sketch_=!0,this.overlayLayer_.getSource().addFeature(s),this.dispatchEvent({type:"pointermove",coordinate:e.coordinate,frameState:e.frameState,originalEvent:e.originalEvent,map:e.map,pixel:e.pixel,feature:o.feature,linkGeometry:o.link})):this.dispatchEvent(e);var r=t.getTargetElement();this.cursor_&&(o?r.style.cursor!=this.cursor_&&(this.previousCursor_=r.style.cursor,ol.ext.element.setCursor(r,this.cursor_)):void 0!==this.previousCursor_&&(ol.ext.element.setCursor(r,this.previousCursor_),this.previousCursor_=void 0))}},ol.interaction.Splitter=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({handleEvent:function(e){return"pointermove"!=e.type&&"pointerdrag"!=e.type?(this.lastEvent_&&(this.splitSource(this.lastEvent_.feature),this.lastEvent_=null),this.moving_=!1):this.moving_=!0,!0}}),this.added_=[],this.removed_=[],e.features?this.source_=new ol.source.Vector({features:e.features}):this.source_=e.source?e.source:new ol.source.Vector({features:new ol.Collection});var t=this.triggerSource;e.triggerFeatures&&(t=new ol.source.Vector({features:e.triggerFeatures})),t?(t.on("addfeature",this.onAddFeature.bind(this)),t.on("changefeature",this.onChangeFeature.bind(this)),t.on("removefeature",this.onRemoveFeature.bind(this))):(this.source_.on("addfeature",this.onAddFeature.bind(this)),this.source_.on("changefeature",this.onChangeFeature.bind(this)),this.source_.on("removefeature",this.onRemoveFeature.bind(this))),this.tolerance_=e.tolerance||.001,this.tolerance2_=e.alignTolerance||e.tolerance||.001,this.filterSplit_=e.filter||function(){return!0}}intersectSegs(e,t){var i=this.tolerance_,s=e[0][0]-e[1][0],o=t[0][0]-t[1][0],r=e[0][1]-e[1][1],a=t[0][1]-t[1][1],n=s*a-r*o;if(Math.abs(n)<i)return!1;var l=((e[0][0]-t[1][0])*a-(e[0][1]-t[1][1])*o)/n;if(Math.abs(l)<i)return e[0];if(Math.abs(1-l)<i)return e[1];if(l<0||l>1)return!1;var h=((e[0][1]-t[1][1])*s-(e[0][0]-t[1][0])*r)/n;if(Math.abs(h)<i)return t[1];if(Math.abs(1-h)<i)return t[0];if(h<0||h>1)return!1;var c=e[0][0]*e[1][1]-e[0][1]*e[1][0],u=t[0][0]*t[1][1]-t[0][1]*t[1][0];return[(c*o-u*s)/n,(c*a-u*r)/n]}splitSource(e,t){this.getActive()&&(this.splitting||(this.source_.dispatchEvent({type:"beforesplit",feaure:e,source:this.source_}),this.dispatchEvent({type:"beforesplit",feaure:e,source:this.source_}),t?this._splitSource(e):setTimeout(function(){this._splitSource(e)}.bind(this))))}_splitSource(e){var t,i,s;this.splitting=!0,this.added_=[],this.removed_=[];var o=e.getGeometry().getCoordinates();switch(e.getGeometry().getType()){case"Point":o=[o];break;case"LineString":break;default:o=[]}var r,a,n=[];function l(t){if(t!==e&&t.getGeometry().splitAt)for(var i=t.getGeometry().getCoordinates(),s=0;s<i.length-1;s++){var o=this.intersectSegs(r,[i[s],i[s+1]]);if(o&&(n.push(o),(h=t.getGeometry().splitAt(o,this.tolerance2_))&&h.length>1))return c=t,!0}return!1}for(1===o.length&&(r=[o[0],o[0]],a=ol.extent.buffer(ol.extent.boundingExtent(r),this.tolerance_),this.source_.forEachFeatureIntersectingExtent(a,function(e){if(e.getGeometry().splitAt){var t=e.getGeometry().splitAt(o[0],this.tolerance2_);if(t.length>1)for(this.source_.removeFeature(e),i=0;i<t.length;i++)(s=e.clone()).setGeometry(t[i]),this.source_.addFeature(s)}}.bind(this))),t=0;t<o.length-1;t++){var h;for(r=[o[t],o[t+1]],a=ol.extent.buffer(ol.extent.boundingExtent(r),this.tolerance_);;){var c=!1;if(this.source_.forEachFeatureIntersectingExtent(a,l.bind(this)),!c)break;var u=c;for(this.source_.removeFeature(u),i=0;i<h.length;i++)(s=u.clone()).setGeometry(h[i]),this.source_.addFeature(s)}}for(t=0;t<o.length-2;t++)for(var d=t+1;d<o.length-1;d++){var p=this.intersectSegs([o[t],o[t+1]],[o[d],o[d+1]]);p&&p!=o[t+1]&&n.push(p)}var g=!1;if(n.length){var m=e.getGeometry().splitAt(n,this.tolerance2_);if(m.length>1){for(i=0;i<m.length;i++)(s=e.clone()).setGeometry(m[i]),this.source_.addFeature(s);g=!0}}setTimeout(function(){g&&this.source_.removeFeature(e),this.source_.dispatchEvent({type:"aftersplit",featureAdded:this.added_,featureRemoved:this.removed_,source:this.source_}),this.dispatchEvent({type:"aftersplit",featureAdded:this.added_,featureRemoved:this.removed_,source:this.source_}),this.splitting=!1}.bind(this))}onAddFeature(e){this.getActive()&&(this.splitSource(e.feature),this.splitting&&this.added_.push(e.feature))}onRemoveFeature(e){if(this.getActive()&&this.splitting){var t=this.added_.indexOf(e.feature);-1==t?this.removed_.push(e.feature):this.added_.splice(t,1)}}onChangeFeature(e){this.getActive()&&(this.moving_?this.lastEvent_=e:this.splitSource(e.feature,!0))}},ol.interaction.Synchronize=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({handleEvent:function(e){return"pointermove"==e.type&&this.handleMove_(e),!0}}),this.maps=e.maps||[],!1===e.active&&this.setActive(!1)}setMap(e){this._listener&&(ol.Observable.unByKey(this._listener.center),ol.Observable.unByKey(this._listener.rotation),ol.Observable.unByKey(this._listener.resolution),this.getMap().getTargetElement().removeEventListener("mouseout",this._listener.mouseout)),this._listener=null,super.setMap(e),e&&(this._listener={},this._listener.center=this.getMap().getView().on("change:center",this.syncMaps.bind(this)),this._listener.rotation=this.getMap().getView().on("change:rotation",this.syncMaps.bind(this)),this._listener.resolution=this.getMap().getView().on("change:resolution",this.syncMaps.bind(this)),this._listener.mouseout=this.handleMouseOut_.bind(this),this.getMap().getTargetElement()&&this.getMap().getTargetElement().addEventListener("mouseout",this._listener.mouseout),this.syncMaps())}setActive(e){super.setActive(e),this.syncMaps()}syncMaps(){if(this.getActive()){var e=this.getMap();if(e){if(e.get("lockView"))return;for(var t=0;t<this.maps.length;t++)this.maps[t].set("lockView",!0),this.maps[t].getView().getRotation()!=e.getView().getRotation()&&this.maps[t].getView().setRotation(e.getView().getRotation()),this.maps[t].getView().getCenter()!=e.getView().getCenter()&&this.maps[t].getView().setCenter(e.getView().getCenter()),this.maps[t].getView().getResolution()!=e.getView().getResolution()&&this.maps[t].getView().setResolution(e.getView().getResolution()),this.maps[t].set("lockView",!1)}}}handleMove_(e){for(var t=0;t<this.maps.length;t++)this.maps[t].showTarget(e.coordinate);this.getMap().showTarget()}handleMouseOut_(){for(var e=0;e<this.maps.length;e++)this.maps[e]._targetOverlay&&this.maps[e]._targetOverlay.setPosition(void 0)}},ol.Map.prototype.showTarget=function(e){if(!this._targetOverlay){var t=document.createElement("div");t.classList.add("ol-target"),this._targetOverlay=new ol.Overlay({element:t}),this._targetOverlay.setPositioning("center-center"),this.addOverlay(this._targetOverlay),t.parentElement.classList.add("ol-target-overlay"),this._targetOverlay.setPosition([0,0])}this._targetOverlay.setPosition(e)},ol.Map.prototype.hideTarget=function(){this.removeOverlay(this._targetOverlay),this._targetOverlay=void 0},ol.interaction.TinkerBell=class extends ol.interaction.Pointer{constructor(e){e=e||{},super({handleDownEvent:function(e){this.onMove(e)},handleMoveEvent:function(e){this.onMove(e)}}),this.set("color",e.color?ol.color.asString(e.color):"#fff"),this.sparkle=[0,0],this.sparkles=[],this.lastSparkle=this.time=new Date;var t=this;this.out_=function(){t.isout_=!0},this.isout_=!0}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,this.getMap()&&(e.getViewport().removeEventListener("mouseout",this.out_,!1),this.getMap().render()),super.setMap(e),e&&(this._listener=e.on("postcompose",this.postcompose_.bind(this)),e.getViewport().addEventListener("mouseout",this.out_,!1))}onMove(e){this.sparkle=e.pixel,this.isout_=!1,this.getMap().render()}postcompose_(e){var t=e.context||ol.ext.getMapCanvas(this.getMap()).getContext("2d"),i=e.frameState.time-this.time;this.time=e.frameState.time,e.frameState.time-this.lastSparkle>30&&!this.isout_&&(this.lastSparkle=e.frameState.time,this.sparkles.push({p:[this.sparkle[0]+15*Math.random()-7.5,this.sparkle[1]+15*Math.random()],o:1})),t.save(),t.scale(e.frameState.pixelRatio,e.frameState.pixelRatio),t.fillStyle=this.get("color");for(var s,o=this.sparkles.length-1;s=this.sparkles[o];o--){if(s.o<.2){this.sparkles.splice(0,o+1);break}t.globalAlpha=s.o,t.beginPath(),t.arc(s.p[0],s.p[1],2.2,0,2*Math.PI,!1),t.fill(),s.o*=.98,s.p[0]+=Math.random()-.5,s.p[1]+=i*(1+Math.random())/30}t.restore(),this.sparkles.length&&this.getMap().render()}},ol.interaction.TouchCompass=class extends ol.interaction.Pointer{constructor(e){e=e||{};var t={handleDownEvent:function(e){var t=this.getCenter_(),i=e.pixel[0]-t[0],s=e.pixel[1]-t[1];return this.start=e,Math.sqrt(i*i+s*s)<this.size/2},handleDragEvent:function(e){if(!this.pos){this.pos=this.start;try{this.getMap().renderSync()}catch(e){}}this.pos=e},handleUpEvent:function(){return this.pos=!1,!0}};if(super(t),this.ondrag_=e.onDrag,this.size=e.size||80,this.alpha=e.alpha||.5,!this.compass){var i=this.compass=document.createElement("canvas"),s=i.getContext("2d"),o=i.width=i.height=this.size,r=o/10,a=o/2,n=.22*a;s.translate(a,a),s.fillStyle="#999",s.strokeStyle="#ccc",s.lineWidth=r,s.beginPath(),s.arc(0,0,.42*o,0,2*Math.PI),s.fill(),s.stroke(),s.fillStyle="#99f",s.beginPath(),s.moveTo(0,0),s.lineTo(a,0),s.lineTo(n,n),s.moveTo(0,0),s.lineTo(-a,0),s.lineTo(-n,-n),s.moveTo(0,0),s.lineTo(0,a),s.lineTo(-n,n),s.moveTo(0,0),s.lineTo(0,-a),s.lineTo(n,-n),s.moveTo(0,0),s.fill(),s.fillStyle="#eee",s.beginPath(),s.moveTo(0,0),s.lineTo(a,0),s.lineTo(n,-n),s.moveTo(0,0),s.lineTo(-a,0),s.lineTo(-n,n),s.moveTo(0,0),s.lineTo(0,a),s.lineTo(n,n),s.moveTo(0,0),s.lineTo(0,-a),s.lineTo(-n,-n),s.moveTo(0,0),s.fill()}}setMap(e){this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),e&&(this._listener=e.on("postcompose",this.drawCompass_.bind(this)),ol.ext.getMapCanvas(e))}setActive(e){if(super.setActive(e),this.getMap())try{this.getMap().renderSync()}catch(e){}}getCenter_(){var e=this.size,t=this.getMap().getSize();return[t[0]/2,t[1]-10-e/2]}drawCompass_(e){if(this.getActive()){var t=e.context||ol.ext.getMapCanvas(this.getMap()).getContext("2d"),i=e.frameState.pixelRatio;t.save(),t.scale(i,i),t.globalAlpha=this.alpha,t.strokeStyle="#fff",t.lineWidth=5;var s=this.size,o=this.getCenter_();if(t.drawImage(this.compass,0,0,this.compass.width,this.compass.height,o[0]-s/2,o[1]-s/2,s,s),this.pos)for(var r=this.pos.pixel[0]-this.start.pixel[0],a=this.pos.pixel[1]-this.start.pixel[1],n=1;n<=4;n++)t.beginPath(),t.arc(o[0]+r/4*n,o[1]+a/4*n,s/2*(.6+.4*n/4),0,2*Math.PI),t.stroke();if(t.restore(),this.pos){if(this.ondrag_){var l=this.getMap().getView().getResolution(),h={dpixel:[this.pos.pixel[0]-this.start.pixel[0],this.pos.pixel[1]-this.start.pixel[1]]};h.traction=[h.dpixel[0]*l,-h.dpixel[1]*l],this.ondrag_(h,this.pos)}e.frameState.animate=!0}}}},ol.interaction.TouchCursor=class extends ol.interaction.DragOverlay{constructor(e){e=e||{};var t=new ol.Overlay.Fixed({className:("ol-touch-cursor "+(e.className||"")).trim(),positioning:"top-left",element:ol.ext.element.create("DIV",{}),stopEvent:!1});super({centerOnClick:!1,overlays:t}),this.overlay=t,this._listeners={};var i=[-35,-35];if(this.ctouch=new ol.interaction.Interaction({handleEvent:function(e){if(!/drag/.test(e.type)&&this.getMap())e.coordinate=this.overlay.getPosition(),e.pixel=this.getMap().getPixelFromCoordinate(e.coordinate),this._lastEvent=e;else{var t=e.frameState.viewState.resolution,s=Math.cos(e.frameState.viewState.rotation),o=Math.sin(e.frameState.viewState.rotation);e.coordinate=[e.coordinate[0]+s*i[0]*t+o*i[1]*t,e.coordinate[1]+o*i[0]*t-s*i[1]*t],e.pixel=this.getMap().getPixelFromCoordinate(e.coordinate)}return!0}.bind(this)}),this.ctouch.set("onTop",!0),this.setPosition(e.coordinate,!0),this.set("maxButtons",e.maxButtons||5),e.buttons){e.buttons.length>this.get("maxButtons")&&this.set("maxButtons",e.buttons.length);var s=this.overlay.element,o=e.buttons.length>4?0:1;e.buttons.forEach(function(e,t){t<5&&ol.ext.element.create("DIV",{className:((e.className||"")+" ol-button ol-button-"+(t+o)).trim(),html:ol.ext.element.create("DIV",{html:e.html}),click:e.click,on:e.on,parent:s})})}var r=!1,a=!1;this.on("dragstart",function(e){return this._pixel=this.getMap().getPixelFromCoordinate(this.overlay.getPosition()),a=e,!e.overlay}),this.on("dragend",function(e){return this._pixel=this.getMap().getPixelFromCoordinate(this.overlay.getPosition()),!e.overlay||(r?(this.dispatchEvent({type:"dragend",dragging:r,originalEvent:e.originalEvent,frameState:e.frameState,pixel:this._pixel,coordinate:this.overlay.getPosition()}),r=!1):e.originalEvent.target===this.overlay.element&&this.dispatchEvent({type:"click",dragging:r,originalEvent:e.originalEvent,frameState:e.frameState,pixel:this._pixel,coordinate:this.overlay.getPosition()}),!1)}.bind(this)),this.on("dragging",function(e){return this._pixel=this.getMap().getPixelFromCoordinate(this.overlay.getPosition()),!e.overlay||(r=!0,a&&(this.dispatchEvent({type:"dragstart",dragging:r,originalEvent:a.originalEvent,frameState:e.frameState,pixel:this._pixel,coordinate:a.coordinate}),a=!1),this.dispatchEvent({type:"dragging",dragging:r,originalEvent:e.originalEvent,frameState:e.frameState,pixel:this._pixel,coordinate:this.overlay.getPosition()}),!1)}.bind(this))}setMap(e){for(var t in this.getMap()&&(this.getMap().removeInteraction(this.ctouch),this.getActive()&&this.getMap().removeOverlay(this.overlay)),this._listeners)ol.Observable.unByKey(this._listeners[t]);this._listeners={},super.setMap(e),e&&(this.getActive()&&(e.addOverlay(this.overlay),setTimeout(function(){this.setPosition(this.getPosition()||e.getView().getCenter())}.bind(this))),e.addInteraction(this.ctouch),this._listeners.addInteraction=e.getInteractions().on("add",function(t){t.element.get("onTop")||(e.removeInteraction(this.ctouch),e.addInteraction(this.ctouch))}.bind(this)))}setActive(e,t){e!==this.getActive()?(this.ctouch&&this.ctouch.setActive(e),e?(this.getMap()&&this.getMap().addOverlay(this.overlay),t?this.setPosition(t):this.getMap()&&this.setPosition(this.getMap().getView().getCenter()),this._activate=setTimeout(function(){this.overlay.element.classList.add("active")}.bind(this),100)):(this.setPosition(),this.overlay.element.classList.remove("active"),this._activate&&clearTimeout(this._activate),this.getMap()&&this.getMap().removeOverlay(this.overlay)),super.setActive(e)):t?this.setPosition(t):this.getMap()&&this.setPosition(this.getMap().getView().getCenter())}setPosition(e){this.overlay.setPosition(e,!0),this.getMap()&&e&&(this._pixel=this.getMap().getPixelFromCoordinate(e))}offsetPosition(e){var t=this.overlay.getPosition();t&&this.overlay.setPosition([t[0]+e[0],t[1]+e[1]])}getPosition(){return this.overlay.getPosition()}getPixel(){if(this.getMap())return this.getMap().getPixelFromCoordinate(this.getPosition())}getOverlay(){return this.overlay}getOverlayElement(){return this.overlay.element}getButtonElement(e){return"number"==typeof e?this.getOverlayElement().getElementsByClassName("ol-button")[e]:this.getOverlayElement().getElementsByClassName(e)[0]}removeButton(e){if(void 0===e)for(var t=this.getOverlayElement().getElementsByClassName("ol-button"),i=t.length-1;i>=0;i--)this.getOverlayElement().removeChild(t[i]);else{var s=this.getButtonElement(e);s&&this.getOverlayElement().removeChild(s)}}addButton(e){var t=this.getOverlayElement().getElementsByClassName("ol-button"),i=this.get("maxButtons")||5;if(t.length>=i)console.error("[ol/interaction/TouchCursor~addButton] too many button on the cursor (max="+i+")...");else{var s=ol.ext.element.create("DIV",{className:((e.className||"")+" ol-button").trim(),html:ol.ext.element.create("DIV",{html:e.html}),click:e.click,on:e.on});e.before&&0!==t.length?this.getOverlayElement().insertBefore(s,t[0]):this.getOverlayElement().appendChild(s);for(var o=t.length>=i?0:1,r=0;r<t.length;r++)t[r].className=t[r].className.replace(/ol-button-\d/g,"").trim()+" ol-button-"+(r+o)}}},ol.interaction.TouchCursorDraw=class extends ol.interaction.TouchCursor{constructor(e){super({className:(e=e||{}).className,coordinate:e.coordinate}),this.getOverlayElement().classList.add("nodrawing");var t=this.sketch=new ol.layer.SketchOverlay({type:e.type});t.on("drawend",function(t){t.valid&&e.source&&e.source.addFeature(t.feature),this.getOverlayElement().classList.add("nodrawing"),this.dispatchEvent(t)}.bind(this)),t.on("drawstart",function(e){this.getOverlayElement().classList.remove("nodrawing"),this.dispatchEvent(e)}.bind(this)),t.on("drawabort",function(e){this.getOverlayElement().classList.add("nodrawing"),this.dispatchEvent(e)}.bind(this)),this.set("types",e.types),this.setType(e.type),this.on("click",function(){this.sketch.addPoint(this.getPosition())}.bind(this)),this.on("dragging",function(){this.sketch.setPosition(this.getPosition())}.bind(this))}setMap(e){super.setMap(e),this.sketch.setMap(e),e&&(this._listeners.movend=e.on("moveend",function(){this.sketch.setPosition(this.getPosition())}.bind(this)))}setActive(e,t){super.setActive(e,t),this.sketch&&(this.sketch.abortDrawing(),this.sketch.setPosition(t),this.sketch.setVisible(e))}setType(e){this.removeButton();var t=this.sketch;this.getOverlayElement().classList.remove(t.getGeometryType());var i=t.setGeometryType();e=t.setGeometryType(e),this.getOverlayElement().classList.add(e),this.dispatchEvent({type:"change:type",oldValue:i});var s=this.get("types");if(s&&s.length){var o=s[(s.indexOf(e)+1)%s.length];this.addButton({className:"ol-button-type "+o,click:function(){this.setType(o)}.bind(this)})}"Point"!==e&&(this.addButton({className:"ol-button-x",click:function(){t.abortDrawing()}}),"Circle"!==e&&(this.addButton({className:"ol-button-check",click:function(){t.finishDrawing(!0)}}),this.addButton({className:"ol-button-remove",click:function(){t.removeLastPoint()}})))}getType(){return this.sketch.getGeometryType()}},ol.interaction.TouchCursorModify=class extends ol.interaction.TouchCursor{constructor(e){var t=!1,i=!1,s=!1;super({className:("disable "+(e=e||{}).className).trim(),coordinate:e.coordinate,buttons:[{className:"ol-button-move",on:{pointerdown:function(){t=!0},pointerup:function(){t=!1}}},{className:"ol-button-add",click:function(){i=!0,r.handleDownEvent(o._lastEvent),r.handleUpEvent(o._lastEvent),i=!1}},{className:"ol-button-remove",click:function(){s=!0,r.handleDownEvent(o._lastEvent),s=!1}}]});var o=this,r=this._modify=new ol.interaction.ModifyFeature({source:e.source,sources:e.sources,features:e.features,pixelTolerance:e.pixelTolerance,filter:e.filter,style:e.style||[new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[255,255,255,.5],width:3})})}),new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[0,153,255,1],width:1.25})})})],wrapX:e.wrapX,condition:function(e){return e.dragging||i},deleteCondition:function(){return s}});r.on("select",function(e){e.selected.length?this.getOverlayElement().classList.remove("disable"):this.getOverlayElement().classList.add("disable")}.bind(this)),this.on("dragstart",function(){t&&r.handleDownEvent(this._lastEvent)}.bind(this)),this.on("dragging",function(e){t&&r.handleDragEvent(e)}),this.on("dragend",function(e){r.handleUpEvent(e),t=!1})}setMap(e){this.getMap()&&this.getMap().removeInteraction(this._modify),e&&e.addInteraction(this._modify),super.setMap(e)}setActive(e,t){super.setActive(e,t),this._modify&&this._modify.setActive(e)}getInteraction(){return this._modify}},ol.interaction.TouchCursorSelect=class extends ol.interaction.TouchCursor{constructor(e){super({className:"ol-select "+((e=e||{}).className||""),coordinate:e.coordinate}),this._selection=null,this._layerFilter=e.layerFilter,this._filter=e.filter,this._style=e.style||ol.style.Style.defaultStyle(!0),this.set("hitTolerance",e.hitTolerance||0),this.on(["change:active","dragging"],function(){this.select()})}setMap(e){super.setMap(e),e&&(this._listeners.movend=e.on("moveend",function(){this.select()}.bind(this)))}getSelection(){return this._selection?this._selection.feature:null}setPosition(e){super.setPosition(e),this.select()}select(e){var t=this._selection;if(this.getActive()&&this.getPosition()){if(!e){var i=this.getMap().getFeaturesAtPixel(this.getPixel(),{layerFilter:this._layerFilter,filter:this._filter,hitTolerance:this.get("hitTolerance")});e=i?i[0]:null}e?t&&e===t.feature?t=null:(this._selection={feature:e,style:e.getStyle()},e.setStyle(this._style),this.dispatchEvent({type:"select",selected:[e],deselected:t?[t.feature]:[]})):(this._selection=null,this.dispatchEvent({type:"select",selected:[],deselected:t?[t.feature]:[]}))}else this._selection=null,this.dispatchEvent({type:"select",selected:[],deselected:t?[t.feature]:[]});t&&t.feature.setStyle(t.style),this._selection?this.getOverlayElement().classList.remove("disable"):this.getOverlayElement().classList.add("disable")}},ol.interaction.Transform=class extends ol.interaction.Pointer{constructor(e){e=e||{},super({handleDownEvent:function(e){return t.handleDownEvent_(e)},handleDragEvent:function(e){return this.handleDragEvent_(e)},handleMoveEvent:function(e){return this.handleMoveEvent_(e)},handleUpEvent:function(e){return this.handleUpEvent_(e)}});var t=this;this.selection_=new ol.Collection,this.handles_=new ol.Collection,this.overlayLayer_=new ol.layer.Vector({source:new ol.source.Vector({features:this.handles_,useSpatialIndex:!1,wrapX:!1}),name:"Transform overlay",displayInLayerSwitcher:!1,style:function(e){return t.style[(e.get("handle")||"default")+(e.get("constraint")||"")+(e.get("option")||"")]},updateWhileAnimating:!0,updateWhileInteracting:!0}),this.features_=e.features,"function"==typeof e.filter&&(this._filter=e.filter),this.layers_=e.layers?e.layers instanceof Array?e.layers:[e.layers]:null,this._handleEvent=e.condition||function(){return!0},this.addFn_=e.addCondition||function(){return!1},this.setPointRadius(e.pointRadius),this.set("translateFeature",!1!==e.translateFeature),this.set("translate",!1!==e.translate),this.set("translateBBox",!0===e.translateBBox),this.set("stretch",!1!==e.stretch),this.set("scale",!1!==e.scale),this.set("rotate",!1!==e.rotate),this.set("keepAspectRatio",e.keepAspectRatio||function(e){return e.originalEvent.shiftKey}),this.set("modifyCenter",e.modifyCenter||function(e){return e.originalEvent.metaKey||e.originalEvent.ctrlKey}),this.set("noFlip",e.noFlip||!1),this.set("selection",!1!==e.selection),this.set("hitTolerance",e.hitTolerance||0),this.set("enableRotatedTransform",e.enableRotatedTransform||!1),this.set("keepRectangle",e.keepRectangle||!1),this.set("buffer",e.buffer||0),this.on("propertychange",function(){this.drawSketch_()}),this.setDefaultStyle()}setMap(e){var t=this.getMap();t&&(t.removeLayer(this.overlayLayer_),this.previousCursor_&&ol.ext.element.setCursor(t,this.previousCursor_),this.previousCursor_=void 0),super.setMap(e),this.overlayLayer_.setMap(e),null===e&&this.select(null),null!==e&&(this.isTouch=/touch/.test(e.getViewport().className),this.setDefaultStyle())}setActive(e){this.select(null),this.overlayLayer_&&this.overlayLayer_.setVisible(e),super.setActive(e)}setDefaultStyle(e){var t=(e=e||{}).pointStroke||new ol.style.Stroke({color:[255,0,0,1],width:1}),i=e.stroke||new ol.style.Stroke({color:[255,0,0,1],width:1,lineDash:[4,4]}),s=e.fill||new ol.style.Fill({color:[255,0,0,.01]}),o=e.pointFill||new ol.style.Fill({color:[255,255,255,.8]}),r=new ol.style.RegularShape({fill:o,stroke:t,radius:this.isTouch?12:6,displacement:this.isTouch?[24,-24]:[12,-12],points:15});r.setDisplacement||(r.getAnchor()[0]=this.isTouch?-10:-5);var a=new ol.style.RegularShape({fill:o,stroke:t,radius:this.isTouch?16:8,points:4,angle:Math.PI/4}),n=new ol.style.RegularShape({fill:o,stroke:t,radius:this.isTouch?12:6,points:4,angle:Math.PI/4});function l(e,t,i){return[new ol.style.Style({image:e,stroke:t,fill:i})]}this.style={default:l(a,i,s),translate:l(a,t,o),rotate:l(r,t,o),rotate0:l(a,t,o),scale:l(a,t,o),scale1:l(a,t,o),scale2:l(a,t,o),scale3:l(a,t,o),scalev:l(n,t,o),scaleh1:l(n,t,o),scalev2:l(n,t,o),scaleh3:l(n,t,o)},this.drawSketch_()}setStyle(e,t){if(t){t instanceof Array?this.style[e]=t:this.style[e]=[t];for(var i=0;i<this.style[e].length;i++){var s=this.style[e][i].getImage();s&&("rotate"==e&&(s.getAnchor()[0]=-5),this.isTouch&&s.setScale(1.8));var o=this.style[e][i].getText();o&&("rotate"==e&&o.setOffsetX(this.isTouch?14:7),this.isTouch&&o.setScale(1.8))}this.drawSketch_()}}getFeatureAtPixel_(e){var t=this;return this.getMap().forEachFeatureAtPixel(e,function(e,i){var s=!1;if(!i){if(e===t.bbox_)return!!t.get("translateBBox")&&{feature:e,handle:"translate",constraint:"",option:""};if(t.handles_.forEach(function(t){t===e&&(s=!0)}),s)return{feature:e,handle:e.get("handle"),constraint:e.get("constraint"),option:e.get("option")}}if(!t.get("selection"))return t.selection_.getArray().some(function(t){return e===t})?{feature:e}:null;if(t._filter)return t._filter(e,i)?{feature:e}:null;if(t.layers_){for(var o=0;o<t.layers_.length;o++)if(t.layers_[o]===i)return{feature:e};return null}return t.features_?(t.features_.forEach(function(t){t===e&&(s=!0)}),s?{feature:e}:null):{feature:e}},{hitTolerance:this.get("hitTolerance")})||{}}getGeometryRotateToZero_(e,t){var i=e.getGeometry(),s=this.getMap().getView().getRotation();if(0===s||!this.get("enableRotatedTransform"))return t?i.clone():i;var o=i.clone();return o.rotate(-1*s,this.getMap().getView().getCenter()),o}_isRectangle(e){return!(!this.get("keepRectangle")||"Polygon"!==e.getType())&&5===e.getCoordinates()[0].length}drawSketch_(e){var t,i,s,o=this.selection_.item(0)&&this._isRectangle(this.selection_.item(0).getGeometry());if(this.overlayLayer_.getSource().clear(),this.selection_.getLength()){var r,a=this.getMap().getView().getRotation(),n=this.getGeometryRotateToZero_(this.selection_.item(0)).getExtent();o&&(r=this.getGeometryRotateToZero_(this.selection_.item(0)).getCoordinates()[0].slice(0,4)).unshift(r[3]),n=ol.extent.buffer(n,this.get("buffer")),this.selection_.forEach(function(e){var t=this.getGeometryRotateToZero_(e).getExtent();ol.extent.extend(n,t)}.bind(this));var l=1===this.selection_.getLength()?this._pointRadius(this.selection_.item(0)):0;if(!l||l instanceof Array||(l=[l,l]),!0===e)this.ispt_||(this.overlayLayer_.getSource().addFeature(new ol.Feature({geometry:new ol.geom.Point(this.center_),handle:"rotate0"})),s=ol.geom.Polygon.fromExtent(n),this.get("enableRotatedTransform")&&0!==a&&s.rotate(a,this.getMap().getView().getCenter()),i=this.bbox_=new ol.Feature(s),this.overlayLayer_.getSource().addFeature(i));else{if(this.ispt_){var h=this.getMap().getPixelFromCoordinate(ol.extent.getCenter(n));if(h){var c=l&&l[0]||10,u=l&&l[1]||10;n=ol.extent.boundingExtent([this.getMap().getCoordinateFromPixel([h[0]-c,h[1]-u]),this.getMap().getCoordinateFromPixel([h[0]+c,h[1]+u])])}}s=o?new ol.geom.Polygon([r]):ol.geom.Polygon.fromExtent(n),this.get("enableRotatedTransform")&&0!==a&&s.rotate(a,this.getMap().getView().getCenter()),i=this.bbox_=new ol.Feature(s);var d=[],p=s.getCoordinates()[0];if(!this.ispt_||l){if(d.push(i),!this.iscircle_&&!this.ispt_&&this.get("stretch")&&this.get("scale"))for(t=0;t<p.length-1;t++)i=new ol.Feature({geometry:new ol.geom.Point([(p[t][0]+p[t+1][0])/2,(p[t][1]+p[t+1][1])/2]),handle:"scale",constraint:t%2?"h":"v",option:t}),d.push(i);if(this.get("scale"))for(t=0;t<p.length-1;t++)i=new ol.Feature({geometry:new ol.geom.Point(p[t]),handle:"scale",option:t}),d.push(i);this.get("translate")&&!this.get("translateFeature")&&(i=new ol.Feature({geometry:new ol.geom.Point([(p[0][0]+p[2][0])/2,(p[0][1]+p[2][1])/2]),handle:"translate"}),d.push(i))}!this.iscircle_&&this.get("rotate")&&(i=new ol.Feature({geometry:new ol.geom.Point(p[3]),handle:"rotate"}),d.push(i)),this.overlayLayer_.getSource().addFeatures(d)}}}select(e,t){if(e){if(e.getGeometry&&e.getGeometry()){if(t)this.selection_.push(e);else{var i=this.selection_.getArray().indexOf(e);this.selection_.removeAt(i)}this.ispt_=1===this.selection_.getLength()&&"Point"==this.selection_.item(0).getGeometry().getType(),this.iscircle_=1===this.selection_.getLength()&&"Circle"==this.selection_.item(0).getGeometry().getType(),this.drawSketch_(),this.watchFeatures_(),this.dispatchEvent({type:"select",feature:e,features:this.selection_})}}else this.selection_&&(this.selection_.clear(),this.drawSketch_())}setSelection(e){this.selection_.clear(),e.forEach(function(e){this.selection_.push(e)}.bind(this)),this.ispt_=1===this.selection_.getLength()&&"Point"==this.selection_.item(0).getGeometry().getType(),this.iscircle_=1===this.selection_.getLength()&&"Circle"==this.selection_.item(0).getGeometry().getType(),this.drawSketch_(),this.watchFeatures_(),this.dispatchEvent({type:"select",features:this.selection_})}watchFeatures_(){this._featureListeners&&this._featureListeners.forEach(function(e){ol.Observable.unByKey(e)}),this._featureListeners=[],this.selection_.forEach(function(e){this._featureListeners.push(e.on("change",function(){this.isUpdating_||this.drawSketch_()}.bind(this)))}.bind(this))}handleDownEvent_(e){if(this._handleEvent(e,this.selection_)){var t=this.getFeatureAtPixel_(e.pixel),i=t.feature;if(this.selection_.getLength()&&this.selection_.getArray().indexOf(i)>=0&&(this.ispt_&&this.get("translate")||this.get("translateFeature"))&&(t.handle="translate"),t.handle){this.mode_=t.handle,this.opt_=t.option,this.constraint_=t.constraint;var s=this.getMap().getView().getRotation();this.coordinate_=i.get("handle")?i.getGeometry().getCoordinates():e.coordinate,this.pixel_=this.getMap().getCoordinateFromPixel(this.coordinate_),this.geoms_=[],this.rotatedGeoms_=[];for(var o,r=ol.extent.createEmpty(),a=ol.extent.createEmpty(),n=0;o=this.selection_.item(n);n++)if(this.geoms_.push(o.getGeometry().clone()),r=ol.extent.extend(r,o.getGeometry().getExtent()),this.get("enableRotatedTransform")&&0!==s){var l=this.getGeometryRotateToZero_(o,!0);this.rotatedGeoms_.push(l),a=ol.extent.extend(a,l.getExtent())}if(this.extent_=ol.geom.Polygon.fromExtent(r).getCoordinates()[0],this.get("enableRotatedTransform")&&0!==s&&(this.rotatedExtent_=ol.geom.Polygon.fromExtent(a).getCoordinates()[0]),"rotate"===this.mode_){this.center_=this.getCenter()||ol.extent.getCenter(r);var h=e.map.getTargetElement();ol.ext.element.setCursor(h,this.Cursors.rotate0),this.previousCursor_=h.style.cursor}else this.center_=ol.extent.getCenter(r);return this.angle_=Math.atan2(this.center_[1]-e.coordinate[1],this.center_[0]-e.coordinate[0]),this.dispatchEvent({type:this.mode_+"start",feature:this.selection_.item(0),features:this.selection_,pixel:e.pixel,coordinate:e.coordinate}),!0}if(this.get("selection")){if(i){this.addFn_(e)||this.selection_.clear();var c=this.selection_.getArray().indexOf(i);c<0?this.selection_.push(i):this.selection_.removeAt(c)}else this.selection_.clear();return this.ispt_=1===this.selection_.getLength()&&"Point"==this.selection_.item(0).getGeometry().getType(),this.iscircle_=1===this.selection_.getLength()&&"Circle"==this.selection_.item(0).getGeometry().getType(),this.drawSketch_(),this.watchFeatures_(),this.dispatchEvent({type:"select",feature:i,features:this.selection_,pixel:e.pixel,coordinate:e.coordinate}),!1}}}getCenter(){return this.get("center")}setCenter(e){return this.set("center",e)}handleDragEvent_(e){if(this._handleEvent(e,this.features_)){var t,i,s,o,r=this.getMap().getView().getRotation(),a=[this.coordinate_[0],this.coordinate_[1]],n=[e.coordinate[0],e.coordinate[1]];switch(this.isUpdating_=!0,this.mode_){case"rotate":var l=Math.atan2(this.center_[1]-n[1],this.center_[0]-n[0]);if(!this.ispt)for(t=0;s=this.selection_.item(t);t++)(o=this.geoms_[t].clone()).rotate(l-this.angle_,this.center_),"Circle"==o.getType()&&o.setCenterAndRadius(o.getCenter(),o.getRadius()),s.setGeometry(o);this.drawSketch_(!0),this.dispatchEvent({type:"rotating",feature:this.selection_.item(0),features:this.selection_,angle:l-this.angle_,pixel:e.pixel,coordinate:e.coordinate});break;case"translate":var h=n[0]-a[0],c=n[1]-a[1];for(t=0;s=this.selection_.item(t);t++)s.getGeometry().translate(h,c);this.handles_.forEach(function(e){e.getGeometry().translate(h,c)}),this.coordinate_=e.coordinate,this.dispatchEvent({type:"translating",feature:this.selection_.item(0),features:this.selection_,delta:[h,c],pixel:e.pixel,coordinate:e.coordinate});break;case"scale":var u=this.center_;if(this.get("modifyCenter")(e)){var d=this.extent_;this.get("enableRotatedTransform")&&0!==r&&(d=this.rotatedExtent_),u=d[(Number(this.opt_)+2)%4]}var p=1==this.geoms_.length&&this._isRectangle(this.geoms_[0]),g=this.constraint_,m=this.opt_,f=this.coordinate_,v=e.coordinate;if(this.get("enableRotatedTransform")&&0!==r){var y=new ol.geom.Point(this.coordinate_);y.rotate(-1*r,u),f=y.getCoordinates();var _=new ol.geom.Point(e.coordinate);_.rotate(-1*r,u),v=_.getCoordinates()}var x=(v[0]-u[0])/(f[0]-u[0]),b=(v[1]-u[1])/(f[1]-u[1]),w=[v[0]-f[0],v[1]-f[1]];if(this.get("enableRotatedTransform")&&0!==r){var S=new ol.geom.Point(u);S.rotate(-1*r,this.getMap().getView().getCenter()),u=S.getCoordinates()}for(this.get("noFlip")&&(x<0&&(x=-x),b<0&&(b=-b)),this.constraint_?"h"==this.constraint_?x=1:b=1:this.get("keepAspectRatio")(e)&&(x=b=Math.min(x,b)),t=0;s=this.selection_.item(t);t++)(o=0!==r&&this.get("enableRotatedTransform")?this.rotatedGeoms_[t].clone():this.geoms_[t].clone()).applyTransform(function(e,t,s){if(s<2)return t;if(p){var r=[[6],[0,8],[2],[4]],a=[e[0],e[1]],n=[e[2],e[3]],l=[e[4],e[5]],h=[e[6],e[7]],c=[e[8],e[9]];if(g){var d=m%2==0?this._countVector(a,n):this._countVector(h,a),f=this._projectVectorOnVector(w,d),y=[...r[m],...r[m+1<r.length?m+1:0]];for(i=0;i<e.length;i+=s)t[i]=y.includes(i)?e[i]+f[0]:e[i],t[i+1]=y.includes(i)?e[i+1]+f[1]:e[i+1]}else{var _,S;switch(m){case 0:w=this._countVector(h,v),_=this._projectVectorOnVector(w,this._countVector(l,h)),S=this._projectVectorOnVector(w,this._countVector(a,h)),[t[0],t[1]]=this._movePoint(a,_),[t[4],t[5]]=this._movePoint(l,S),[t[6],t[7]]=this._movePoint(h,w),[t[8],t[9]]=this._movePoint(c,_);break;case 1:w=this._countVector(a,v),_=this._projectVectorOnVector(w,this._countVector(h,a)),S=this._projectVectorOnVector(w,this._countVector(n,a)),[t[0],t[1]]=this._movePoint(a,w),[t[2],t[3]]=this._movePoint(n,_),[t[6],t[7]]=this._movePoint(h,S),[t[8],t[9]]=this._movePoint(c,w);break;case 2:w=this._countVector(n,v),_=this._projectVectorOnVector(w,this._countVector(a,n)),S=this._projectVectorOnVector(w,this._countVector(l,n)),[t[0],t[1]]=this._movePoint(a,S),[t[2],t[3]]=this._movePoint(n,w),[t[4],t[5]]=this._movePoint(l,_),[t[8],t[9]]=this._movePoint(c,S);break;case 3:w=this._countVector(l,v),_=this._projectVectorOnVector(w,this._countVector(n,l)),S=this._projectVectorOnVector(w,this._countVector(h,l)),[t[2],t[3]]=this._movePoint(n,S),[t[4],t[5]]=this._movePoint(l,w),[t[6],t[7]]=this._movePoint(h,_)}}}else for(i=0;i<e.length;i+=s)1!=x&&(t[i]=u[0]+(e[i]-u[0])*x),1!=b&&(t[i+1]=u[1]+(e[i+1]-u[1])*b);return"Circle"==o.getType()&&o.setCenterAndRadius(o.getCenter(),o.getRadius()),t}.bind(this)),this.get("enableRotatedTransform")&&0!==r&&o.rotate(r,this.getMap().getView().getCenter()),s.setGeometry(o);this.drawSketch_(),this.dispatchEvent({type:"scaling",feature:this.selection_.item(0),features:this.selection_,scale:[x,b],pixel:e.pixel,coordinate:e.coordinate})}this.isUpdating_=!1}}handleMoveEvent_(e){if(this._handleEvent(e,this.features_)&&!this.mode_){var t=this.getFeatureAtPixel_(e.pixel),i=e.map.getTargetElement();if(t.feature){var s=t.handle?this.Cursors[(t.handle||"default")+(t.constraint||"")+(t.option||"")]:this.Cursors.select;void 0===this.previousCursor_&&(this.previousCursor_=i.style.cursor),ol.ext.element.setCursor(i,s)}else void 0!==this.previousCursor_&&ol.ext.element.setCursor(i,this.previousCursor_),this.previousCursor_=void 0}}handleUpEvent_(e){if("rotate"===this.mode_){var t=e.map.getTargetElement();ol.ext.element.setCursor(t,this.Cursors.default),this.previousCursor_=void 0}return this.dispatchEvent({type:this.mode_+"end",feature:this.selection_.item(0),features:this.selection_,oldgeom:this.geoms_[0],oldgeoms:this.geoms_}),this.drawSketch_(),this.mode_=null,!1}setPointRadius(e){this._pointRadius="function"==typeof e?e:function(){return e}}getFeatures(){return this.selection_}_projectVectorOnVector(e,t){var i=(e[0]*t[0]+e[1]*t[1])/(t[0]*t[0]+t[1]*t[1]);return[t[0]*i,t[1]*i]}_countVector(e,t){return[t[0]-e[0],t[1]-e[1]]}_movePoint(e,t){return[e[0]+t[0],e[1]+t[1]]}},ol.interaction.Transform.prototype.Cursors={default:"auto",select:"pointer",translate:"move",rotate:"move",rotate0:"move",scale:"nesw-resize",scale1:"nwse-resize",scale2:"nesw-resize",scale3:"nwse-resize",scalev:"ew-resize",scaleh1:"ns-resize",scalev2:"ew-resize",scaleh3:"ns-resize"},ol.interaction.UndoRedo=class extends ol.interaction.Interaction{constructor(e){e=e||{},super({handleEvent:function(){return!0}}),this._layers=e.layers,this._undoStack=new ol.Collection,this._redoStack=new ol.Collection,this._undo=[],this._redo=[],this._undoStack.on("add",function(e){void 0===e.element.level?(e.element.level=this._level,e.element.level||(e.element.view={center:this.getMap().getView().getCenter(),zoom:this.getMap().getView().getZoom()},this._undo.push(e.element))):e.element.level||this._undo.push(this._redo.shift()),e.element.level||this.dispatchEvent({type:"stack:add",action:e.element}),this._reduce()}.bind(this)),this._undoStack.on("remove",function(e){e.element.level||(this._doShift?this._undo.shift():this._undo.length&&this._redo.push(this._undo.pop()),this._doClear||this.dispatchEvent({type:"stack:remove",action:e.element,shift:this._doShift}))}.bind(this)),this._block=0,this._level=0,this._doShift=!1,this._record=!0,this._defs={}}define(e,t,i){this._defs[e]={undo:t,redo:i}}length(e){return"redo"===e?this._redo.length:this._undo.length}setMaxLength(e){(e=parseInt(e))&&e<0&&(e=0),this.set("maxLength",e),this._reduce()}size(e){return"redo"===e?this._redoStack.getLength():this._undoStack.getLength()}setMaxSize(e){(e=parseInt(e))&&e<0&&(e=0),this.set("maxSize",e),this._reduce()}_reduce(){if(this.get("maxLength"))for(;this.length()>this.get("maxLength");)this.shift();if(this.get("maxSize"))for(;this.length()>1&&this.size()>this.get("maxSize");)this.shift()}getStack(e){return"redo"===e?this._redo:this._undo}push(e,t,i){return this._defs[e]?(this._undoStack.push({type:e,name:i,custom:!0,prop:t}),!0):(console.warn('[UndoRedoInteraction]: "'+e+'" is not defined.'),!1)}shift(){this._doShift=!0;var e=this._undoStack.removeAt(0);if(this._doShift=!1,"blockstart"===e.type)for(e=this._undoStack.item(0);this._undoStack.getLength()&&e.level>0;)this._undoStack.removeAt(0),e=this._undoStack.item(0)}setActive(e){super.setActive(e),this._record=e}setMap(e){this._mapListener&&this._mapListener.forEach(function(e){ol.Observable.unByKey(e)}),this._mapListener=[],super.setMap(e),e&&(this._mapListener.push(e.on("undoblockstart",this.blockStart.bind(this))),this._mapListener.push(e.on("undoblockend",this.blockEnd.bind(this)))),this._watchSources(),this._watchInteractions()}_watchSources(){var e=this.getMap();this._sourceListener&&this._sourceListener.forEach(function(e){ol.Observable.unByKey(e)}),this._sourceListener=[];var t=this;e&&(function e(i,s){return s||(s=[]),i.forEach(function(i){i.getSource&&i.getSource()instanceof ol.source.Vector?(!t._layers||t._layers.indexOf(i)>=0)&&s.push(i):i.getLayers&&e(i.getLayers(),s)}),s}(e.getLayers()).forEach(function(e){var t=e.getSource();this._sourceListener.push(t.on(["addfeature","removefeature"],this._onAddRemove.bind(this))),this._sourceListener.push(t.on("clearstart",function(){this.blockStart("clear")}.bind(this))),this._sourceListener.push(t.on("clearend",this.blockEnd.bind(this)))}.bind(this)),this._sourceListener.push(e.getLayers().on(["add","remove"],this._watchSources.bind(this))))}_watchInteractions(){var e=this.getMap();this._interactionListener&&this._interactionListener.forEach(function(e){ol.Observable.unByKey(e)}),this._interactionListener=[],e&&(e.getInteractions().forEach(function(e){this._interactionListener.push(e.on(["setattributestart","modifystart","rotatestart","translatestart","scalestart","deletestart","deleteend","beforesplit","aftersplit"],this._onInteraction.bind(this)))}.bind(this)),this._interactionListener.push(e.getInteractions().on(["add","remove"],this._watchInteractions.bind(this))))}_onAddRemove(e){this._record&&(this._redoStack.clear(),this._redo.length=0,this._undoStack.push({type:e.type,source:e.target,feature:e.feature}))}_onInteraction(e){var t=this._onInteraction[e.type];t&&t.call(this,e)}blockStart(e){this._redoStack.clear(),this._redo.length=0,this._undoStack.push({type:"blockstart",name:e}),this._level++}blockEnd(){this._undoStack.push({type:"blockend"}),this._level--}_handleDo(e,t){if(this.getActive()){if(this._record=!1,e.custom)this._defs[e.type]?t?this._defs[e.type].undo(e.prop):this._defs[e.type].redo(e.prop):console.warn('[UndoRedoInteraction]: "'+e.type+'" is not defined.');else switch(e.type){case"addfeature":t?e.source.removeFeature(e.feature):e.source.addFeature(e.feature);break;case"removefeature":t?e.source.addFeature(e.feature):e.source.removeFeature(e.feature);break;case"changegeometry":var i=e.feature.getGeometry();e.feature.setGeometry(e.oldGeom),e.oldGeom=i;break;case"changeattribute":var s=e.newProperties,o=e.oldProperties;for(var r in o)void 0===o?e.feature.unset(r):e.feature.set(r,o[r]);e.oldProperties=s,e.newProperties=o;break;case"blockstart":this._block+=t?-1:1;break;case"blockend":this._block+=t?1:-1;break;default:console.warn('[UndoRedoInteraction]: "'+e.type+'" is not defined.')}this._block<0&&(this._block=0),this._block&&(t?this.undo():this.redo()),this._record=!0,this.dispatchEvent({type:t?"undo":"redo",action:e})}}undo(){var e=this._undoStack.item(this._undoStack.getLength()-1);e&&(this._redoStack.push(e),this._undoStack.pop(),this._handleDo(e,!0))}redo(){var e=this._redoStack.item(this._redoStack.getLength()-1);e&&(this._undoStack.push(e),this._redoStack.pop(),this._handleDo(e,!1))}clear(){this._doClear=!0,this._undo.length=this._redo.length=0,this._undoStack.clear(),this._redoStack.clear(),this._doClear=!1,this.dispatchEvent({type:"stack:clear"})}hasUndo(){return this._undoStack.getLength()}hasRedo(){return this._redoStack.getLength()}},ol.interaction.UndoRedo.prototype._onInteraction.setattributestart=function(e){this.blockStart(e.target.get("name")||"setattribute");var t=Object.assign({},e.properties);e.features.forEach(function(e){var i={};for(var s in t)i[s]=e.get(s);this._undoStack.push({type:"changeattribute",feature:e,newProperties:t,oldProperties:i})}.bind(this)),this.blockEnd()},ol.interaction.UndoRedo.prototype._onInteraction.rotatestart=ol.interaction.UndoRedo.prototype._onInteraction.translatestart=ol.interaction.UndoRedo.prototype._onInteraction.scalestart=ol.interaction.UndoRedo.prototype._onInteraction.modifystart=function(e){this.blockStart(e.type.replace(/start$/,"")),e.features.forEach(function(e){this._undoStack.push({type:"changegeometry",feature:e,oldGeom:e.getGeometry().clone()})}.bind(this)),this.blockEnd()},ol.interaction.UndoRedo.prototype._onInteraction.beforesplit=function(){var e=this._undoStack.getLength();e>2&&"blockend"===this._undoStack.item(e-1).type&&"changegeometry"===this._undoStack.item(e-2).type?this._undoStack.pop():this.blockStart("split")},ol.interaction.UndoRedo.prototype._onInteraction.deletestart=function(){this.blockStart("delete")},ol.interaction.UndoRedo.prototype._onInteraction.aftersplit=ol.interaction.UndoRedo.prototype._onInteraction.deleteend=ol.interaction.UndoRedo.prototype.blockEnd,ol.source.BinBase=class extends ol.source.Vector{constructor(e){super(e=e||{}),this._bindModify=this._onModifyFeature.bind(this),this._watch=!0,this._origin=e.source,this._listen=!1!==e.listenChange,this._geomFn=e.geometryFunction||ol.coordinate.getFeatureCenter||function(e){return e.getGeometry().getFirstCoordinate()},this._origin.on("addfeature",this._onAddFeature.bind(this)),this._origin.on("removefeature",this._onRemoveFeature.bind(this)),this._origin.on("clearstart",this._onClearFeature.bind(this)),this._origin.on("clearend",this._onClearFeature.bind(this)),"function"==typeof e.flatAttributes&&(this._flatAttributes=e.flatAttributes)}_onAddFeature(e,t,i){var s=e.feature||e.target;(t=t||this.getBinAt(this._geomFn(s),!0))&&t.get("features").push(s),this._listen&&!1!==i&&s.on("change",this._bindModify)}_onRemoveFeature(e,t,i){if(this._watch){var s=e.feature||e.target;if(t=t||this.getBinAt(this._geomFn(s))){for(var o,r=t.get("features"),a=0;o=r[a];a++)if(o===s){r.splice(a,1);break}r.length||this.removeFeature(t)}this._listen&&!1!==i&&s.un("change",this._bindModify)}}_onClearFeature(e){"clearstart"===e.type?(this._listen&&this._origin.getFeatures().forEach(function(e){e.un("change",this._bindModify)}.bind(this)),this.clear(),this._watch=!1):this._watch=!0}getBin(e){for(var t,i=this.getFeatures(),s=0;t=i[s];s++)for(var o,r=t.get("features"),a=0;o=r[a];a++)if(o===e)return t;return null}getGridGeomAt(e){return new ol.geom.Polygon([e])}getBinAt(e,t){var i={},s=this.getGridGeomAt(e,i);if(!s)return null;var o=s.getInteriorPoint?s.getInteriorPoint().getCoordinates():s.getInteriorPoints().getCoordinates()[0],r=this.getFeaturesAtCoordinate(o)[0];return!r&&t&&(i.geometry=s,i.features=[],i.center=o,r=new ol.Feature(i),this.addFeature(r)),r||null}_onModifyFeature(e){var t=this.getBin(e.target),i=this.getBinAt(this._geomFn(e.target),"create");t!==i&&(t&&this._onRemoveFeature(e,t,!1),i&&this._onAddFeature(e,i,!1)),this.changed()}reset(){this.clear();for(var e,t=this._origin.getFeatures(),i=0;e=t[i];i++)this._onAddFeature({feature:e});this.changed()}getGridFeatures(){var e=[];return this.getFeatures().forEach(function(t){var i=new ol.Feature(t.getGeometry().clone());for(var s in t.getProperties())"features"!==s&&"geometry"!==s&&i.set(s,t.get(s));i.set("nb",t.get("features").length),this._flatAttributes(i,t.get("features")),e.push(i)}.bind(this)),e}_flatAttributes(){}setFlatAttributesFn(e){"function"==typeof e&&(this._flatAttributes=e)}getSource(){return this._origin}},ol.source.DBPedia=class extends ol.source.Vector{constructor(e){var t=e||{};t.attributions||(t.attributions=['&copy; <a href="https://dbpedia.org/"">DBpedia</a> CC-by-SA']),t.strategy||(t.strategy=ol.loadingstrategy.bbox),super(t),this.setLoader(this._loaderFn),this._url=t.url||"https://fr.dbpedia.org/sparql",this._maxResolution=t.maxResolution||100,this._lang=t.lang||"fr",this._limit=t.limit||1e3}readFeature(e,t,i){for(var s in t)"uri"===t[s].type&&(t[s].value=encodeURI(t[s].value)),e.set(s,t[s].value);return!i||i.get("subject")!=t.subject.value||(i.set("type",i.get("type")+"\n"+t.type.value),!1)}querySubject(){return"?subject rdfs:label ?label. OPTIONAL {?subject dbo:thumbnail ?thumbnail}.OPTIONAL {?subject dbo:abstract ?abstract} . OPTIONAL {?subject rdf:type ?type}"}queryFilter(){return"lang(?label) = '"+this._lang+"' && lang(?abstract) = '"+this._lang+"'"}_loaderFn(e,t,i){if(!(t>this._maxResolution)){var s=this,o=ol.proj.transformExtent(e,i,"EPSG:4326"),r="PREFIX geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> SELECT DISTINCT * WHERE { ?subject geo:lat ?lat . ?subject geo:long ?long . "+this.querySubject()+" . FILTER("+this.queryFilter()+") . FILTER(xsd:float(?lat) <= "+o[3]+" && "+o[1]+" <= xsd:float(?lat) && xsd:float(?long) <= "+o[2]+" && "+o[0]+" <= xsd:float(?long) ) . } LIMIT "+this._limit;ol.ext.Ajax.get({url:this._url,data:{query:r,format:"json"},success:function(e){var t,o,r,a=e.results.bindings,n=[],l=null;for(var h in a)t=a[h],o=[Number(a[h].long.value),Number(a[h].lat.value)],r=new ol.Feature(new ol.geom.Point(ol.proj.transform(o,"EPSG:4326",i))),s.readFeature(r,t,l)&&(n.push(r),l=r);s.addFeatures(n)}})}}},ol.style.clearDBPediaStyleCache,ol.style.dbPediaStyleFunction,function(){var e={};ol.style.clearDBPediaStyleCache=function(){e={}},ol.style.dbPediaStyleFunction=function(t){var i;switch(t||(t={}),typeof t.glyph){case"function":i=t.glyph;break;case"string":i=function(){return t.glyph};break;default:i=function(e){var t=e.get("type");if(t){if(t.match("/Museum"))return"fa-camera";if(t.match("/Monument"))return"fa-building";if(t.match("/Sculpture"))return"fa-android";if(t.match("/Religious"))return"fa-institution";if(t.match("/Castle"))return"fa-key";if(t.match("Water"))return"fa-tint";if(t.match("Island"))return"fa-leaf";if(t.match("/Event"))return"fa-heart";if(t.match("/Artwork"))return"fa-asterisk";if(t.match("/Stadium"))return"fa-futbol-o";if(t.match("/Place"))return"fa-street-view"}return"fa-star"}}var s=t.radius||8,o=t.fill||new ol.style.Fill({color:"navy"}),r=t.stroke||new ol.style.Stroke({color:"#fff",width:2}),a=t.prefix?t.prefix+"_":"";return function(t){var n=i(t),l=a+n,h=e[l];return h||(e[l]=h=new ol.style.Style({image:new ol.style.FontSymbol({glyph:n,radius:s,fill:o,stroke:r})})),[h]}}}(),ol.source.DFCI=class extends ol.source.Vector{constructor(e){(e=e||{}).loader=function(e,t,i){return this._calcGrid(e,t,i)},e.strategy=function(e,t){return this.resolution&&this.resolution!=t&&(this.clear(),this.refresh()),[e]},super(e),this._bbox=[[0,16e5],[11e5,26e5]],this.set("resolutions",e.resolutions||[1e3,100,20]),proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)}_calcGrid(e,t,i){var s,o,r=this.get("resolutions");t>(r[0]||1e3)?this.resolution!=t&&(this._features0||(o=[this._bbox[0][0],this._bbox[0][1],this._bbox[1][0],this._bbox[1][1]],this._features0=this._getFeatures(0,o,i)),this.addFeatures(this._features0)):t>(r[1]||100)?(this.clear(),o=ol.proj.transformExtent(e,i,"EPSG:27572"),s=this._getFeatures(1,o,i),this.addFeatures(s)):t>(r[2]||0)?(this.clear(),o=ol.proj.transformExtent(e,i,"EPSG:27572"),s=this._getFeatures(2,o,i),this.addFeatures(s)):(this.clear(),o=ol.proj.transformExtent(e,i,"EPSG:27572"),s=this._getFeatures(3,o,i),this.addFeatures(s)),this.resolution=t}_midPt(e,t){return[(e[0]+t[0])/2,(e[1]+t[1])/2]}_trFeature(e,t,i,s){var o=new ol.geom.Polygon([e]),r=new ol.Feature(o.transform("EPSG:27572",s));return r.set("id",t),r.set("level",i),r}_getFeatures(e,t,i){var s,o=[],r=1e5;e>0&&(r/=5),e>1&&(r/=10);for(var a=[Math.max(this._bbox[0][0],Math.floor(t[0]/r)*r),Math.max(this._bbox[0][1],Math.floor(t[1]/r)*r)],n=[Math.min(this._bbox[1][0]+99999,Math.floor(t[2]/r)*r),Math.min(this._bbox[1][1]+99999,Math.floor(t[3]/r)*r)],l=a[0];l<=n[0];l+=r)for(var h=a[1];h<=n[1];h+=r){var c,u=[[l,h],[l+r,h],[l+r,h+r],[l,h+r],[l,h]];if(e>2){var d=this._midPt(u[0],u[2]),p=[];for(s=0;s<u.length;s++)p.push(this._midPt(u[s],d));for(o.push(this._trFeature(p,ol.coordinate.toDFCI([l,h],2)+".5",e,i)),s=0;s<4;s++)(p=[]).push(u[s]),p.push(this._midPt(u[s],u[(s+1)%4])),p.push(this._midPt(d,p[1])),p.push(this._midPt(d,u[s])),c=this._midPt(u[s],u[(s+3)%4]),p.push(this._midPt(d,c)),p.push(c),p.push(u[s]),o.push(this._trFeature(p,ol.coordinate.toDFCI([l,h],2)+"."+(4-s),e,i))}else o.push(this._trFeature(u,ol.coordinate.toDFCI([l,h],e),e,i))}return o}},ol.source.DayNight=class extends ol.source.Vector{constructor(e){(e=e||{}).strategy=ol.loadingstrategy.all,super(e),this.setLoader(this._loader),this.set("time",e.time||new Date),this.set("step",e.step||1)}static _sunEclipticPosition(e){var t=Math.PI/180,i=e-2451545,s=280.46+.9856474*i,o=357.528+.9856003*i;return o%=360,{lambda:(s%=360)+1.915*Math.sin(o*t)+.02*Math.sin(2*o*t),R:1.00014-.01671*Math.cos(o*t)-.0014*Math.cos(2*o*t)}}static _eclipticObliquity(e){var t=(e-2451545)/36525;return 23.43929111-t*(46.836769/3600-t*(1831e-7/3600+t*(5.565e-7-t*(1.6e-10-4.34e-8*t/3600))))}static _sunEquatorialPosition(e,t){var i=180/Math.PI,s=Math.PI/180,o=Math.atan(Math.cos(t*s)*Math.tan(e*s))*i,r=Math.asin(Math.sin(t*s)*Math.sin(e*s))*i;return{alpha:o+=90*Math.floor(e/90)-90*Math.floor(o/90),delta:r}}static getNightLat(e,t){var i=180/Math.PI,s=Math.PI/180,o=(t?new Date(t):new Date)/864e5+2440587.5,r=(18.697374558+24.06570982441908*(o-2451545))%24,a=ol.source.DayNight._sunEclipticPosition(o),n=ol.source.DayNight._eclipticObliquity(o),l=ol.source.DayNight._sunEquatorialPosition(a.lambda,n),h=15*r+e-l.alpha;return Math.atan(-Math.cos(h*s)/Math.tan(l.delta*s))*i}_loader(e,t,i){var s=this.getCoordinates(this.get("time")),o=new ol.geom.Polygon([s]);o.transform("EPSG:4326",i),this.addFeature(new ol.Feature(o))}setTime(e){this.set("time",e),this.refresh()}getSunPosition(e){var t=(e?new Date(e):new Date)/864e5+2440587.5,i=(18.697374558+24.06570982441908*(t-2451545))%24,s=ol.source.DayNight._sunEclipticPosition(t),o=ol.source.DayNight._eclipticObliquity(t),r=ol.source.DayNight._sunEquatorialPosition(s.lambda,o);return[r.alpha-15*i,r.delta]}getCoordinates(e,t){for(var i=180/Math.PI,s=Math.PI/180,o=(e?new Date(e):new Date)/864e5+2440587.5,r=(18.697374558+24.06570982441908*(o-2451545))%24,a=[],n=ol.source.DayNight._sunEclipticPosition(o),l=ol.source.DayNight._eclipticObliquity(o),h=ol.source.DayNight._sunEquatorialPosition(n.lambda,l),c=this.get("step")||1,u=-180;u<=180;u+=c){var d=u,p=15*r+d-h.alpha,g=Math.atan(-Math.cos(p*s)/Math.tan(h.delta*s))*i;a.push([d,g])}switch(t){case"line":break;case"day":h.delta*=-1;default:g=h.delta<0?90:-90;for(var m=180;m>=-180;m-=c)a.push([m,g]);a.push(a[0])}if("daynight"===t){var f=[];a.forEach(function(e){f.push(e.slice())}),f[0][1]=-f[0][1],f[f.length-1][1]=-f[0][1],f[f.length-1][1]=-f[0][1],a=[a,f]}return a}},ol.source.Delaunay=class extends ol.source.Vector{constructor(e){var t=(e=e||{}).source;delete e.source,super(e),this._nodes=t,this.hull=[],this._nodes.on("addfeature",this._onAddNode.bind(this)),this._nodes.on("removefeature",this._onRemoveNode.bind(this)),this.set("epsilon",e.epsilon||1e-4)}clear(e){super.clear(e),this.getNodeSource().clear(e)}_addTriangle(e){e.push(e[0]);var t=new ol.Feature(new ol.geom.Polygon([e]));return this.addFeature(t),this.flip.push(t),t}getNodes(){return this._nodes.getFeatures()}getNodeSource(){return this._nodes}_onRemoveNode(e){var t=e.feature.getGeometry().getCoordinates();if(t&&!this.getNodesAt(t).length){var i,s=this.getTrianglesAt(t);this.flip=[];for(var o=[];s.length;){var r=s.pop();this.removeFeature(r),r=r.getGeometry().getCoordinates()[0];var a=[];for(i=0;i<3;i++)l=r[i],ol.coordinate.equal(l,t)||a.push(l);o.push(a)}for(a=o.pop(),i=0;;){var n=o[i];if(f(n[0],n[1],0)||f(n[1],n[0],0)||f(n[0],n[1],a.length-1)||f(n[1],n[0],a.length-1)?(o.splice(i,1),i=0):i++,!o.length)break;if(i>=o.length)throw"[DELAUNAY:removePoint] No edge found"}var l,h=ol.coordinate.equal(a[0],a[a.length-1]);for(h&&a.pop();l=this.hull[i];i++)if(ol.coordinate.equal(t,l)){this.hull.splice(i,1);break}this.hull=ol.coordinate.convexHull(this.hull.concat(a));var c,u=function(e){for(var t,i=0,s=0;s<e.length;s++)i+=(e[t=(s+1)%e.length][0]-e[s][0])*(e[t][1]+e[s][1]);return i>=0?1:-1},d=a.slice();for(h?c=u(a):(d.push(t),c=u(d)),i=0;i<=a.length+1&&!(a.length<3);i++){var p=[a[i%a.length],a[(i+1)%a.length],a[(i+2)%a.length]];if(u(p)===c){for(var g=!0,m=i+3;m<i+a.length;m++)if(this.inCircle(a[m%a.length],p)){g=!1;break}g&&(this._addTriangle(p),a.splice((i+1)%a.length,1),i=-1)}}this.flipTriangles()}function f(e,t,i){return!!ol.coordinate.equal(e,a[i])&&(i?a.push(t):a.unshift(t),!0)}}_onAddNode(e){var t,i,s=e.feature;if("Point"===s.getGeometry().getType()){this.flip=[];var o=this.getNodes(),r=s.getGeometry().getCoordinates();if(this.getNodesAt(r).length>1)this._nodes.removeFeature(s);else if(o.length<=3){if(3===o.length){var a=[];for(t=0;t<3;t++)a.push(o[t].getGeometry().getCoordinates());this._addTriangle(a),this.hull=ol.coordinate.convexHull(a)}}else{var n=this.getFeaturesAtCoordinate(r)[0];if(n){this.removeFeature(n),n.set("del",!0);var l=n.getGeometry().getCoordinates()[0];for(t=0;t<3;t++)this._addTriangle([r,l[t],l[(t+1)%3]])}else{var h=this.hull.slice();for(h.push(r),h=ol.coordinate.convexHull(h),t=0;(i=h[t])&&!ol.coordinate.equal(i,r);t++);var c=h[t=0!==t?t-1:h.length-1],u=h[(t+2)%h.length];for(t=0;(i=this.hull[t])&&!ol.coordinate.equal(i,c);t++);for(;;){if(t>1e3){console.error("[DELAUNAY:addPoint] Too many iterations");break}if(t++,i=this.hull[t%this.hull.length],this._addTriangle([r,i,c]),c=i,i[0]===u[0]&&i[1]===u[1])break}this.hull=h}this.flipTriangles()}}else this._nodes.removeFeature(s)}flipTriangles(){for(var e,t=1e3;this.flip.length;){if(t--<0){console.error("[DELAUNAY:flipTriangles] Too many iterations");break}var i=this.flip.pop();if(!i.get("del"))for(var s=i.getGeometry().getCoordinates()[0],o=0;o<3;o++){var r=[(s[(o+1)%3][0]+s[o][0])/2,(s[(o+1)%3][1]+s[o][1])/2],a=this.getTrianglesAt(r),n=null;if(a.length>1){var l=a[0].getGeometry().getCoordinates()[0],h=a[1].getGeometry().getCoordinates()[0];for(e=0;e<h.length;e++)if(!this._ptInTriangle(h[e],l)){n=h[e];break}}if(n&&this.inCircle(n,l)){var c;for(e=0;e<l.length;e++)if(!this._ptInTriangle(l[e],h)){c=l.splice(e,1)[0];break}if(this.intersectSegs([n,c],l)){for(;a.length;){var u=a.pop();u.set("del",!0),this.removeFeature(u)}this._addTriangle([n,c,l[0]]),this._addTriangle([n,c,l[1]])}}}}}intersectSegs(e,t){var i=e[1][0]-e[0][0],s=e[1][1]-e[0][1],o=t[1][0]-t[0][0],r=i*(t[1][1]-t[0][1])-s*o;if(0!=r){var a=(i*e[0][1]-i*t[0][1]-s*e[0][0]+s*t[0][0])/r;return 0<a&&a<1}return!1}_ptInTriangle(e,t){for(var i,s=0;i=t[s];s++)if(ol.coordinate.equal(e,i))return!0;return!1}listpt(e){for(var t,i="",s=0;t=e[s];s++){var o=this._nodes.getClosestFeatureToCoordinate(t);ol.coordinate.equal(o.getGeometry().getCoordinates(),t)||(o=null),i+=(i?", ":"")+(o?o.get("id"):"?")}return i}inCircle(e,t){var i=this.getCircumCircle(t);return ol.coordinate.dist2d(e,i.center)<i.radius}getCircumCircle(e){var t=e[0][0],i=e[0][1],s=e[1][0],o=e[1][1],r=e[2][0],a=e[2][1],n=(t-s)/(o-i),l=(t-r)/(a-i),h=(i+o)/2-n*(t+s)/2,c=((i+a)/2-l*(t+r)/2-h)/(n-l),u=[c,n*c+h];return{center:u,radius:ol.coordinate.dist2d(u,e[0])}}getTrianglesAt(e){var t=ol.extent.buffer(ol.extent.boundingExtent([e]),this.get("epsilon")),i=[];return this.forEachFeatureIntersectingExtent(t,function(e){i.push(e)}),i}getNodesAt(e){var t=ol.extent.buffer(ol.extent.boundingExtent([e]),this.get("epsilon"));return this._nodes.getFeaturesInExtent(t)}calculateVoronoi(e){var t=[];return this.getNodes().forEach(function(i){var s=i.getGeometry().getCoordinates(),o=!1;if(!0!==e)for(var r=0;r<this.hull.length;r++)if(ol.coordinate.equal(s,this.hull[r])){o=!0;break}if(!o){var a=this.getTrianglesAt(s),n=[];a.forEach(function(e){var t=this.getCircumCircle(e.getGeometry().getCoordinates()[0]);n.push({pt:t.center,d:Math.atan2(t.center[1]-s[1],t.center[0]-s[0])})}.bind(this)),n.sort(function(e,t){return e.d-t.d});var l=[];n.forEach(function(e){l.push(e.pt)}),l.push(l[0]);var h=i.getProperties();h.geometry=new ol.geom.Polygon([l]),t.push(new ol.Feature(h))}}.bind(this)),t}},ol.source.FeatureBin=class extends ol.source.BinBase{constructor(e){var t;(super(e=e||{}),e.binSource)?(this._sourceFeature=e.binSource,this._sourceFeature.on(["addfeature","changefeature","removefeature"],function(){t&&clearTimeout(t),t=setTimeout(function(){this.reset()}.bind(this))}.bind(this))):this._sourceFeature=new ol.source.Vector({features:e.features||[]});this.reset()}setFeatures(e){this._sourceFeature.clear(),this._sourceFeature.addFeatures(e||[]),this.reset()}getGridGeomAt(e,t){var i=this._sourceFeature.getFeaturesAtCoordinate(e)[0];if(!i)return null;var s=i.getProperties();for(var o in s)"geometry"!==o&&(t[o]=s[o]);return i.getGeometry()}},ol.source.GeoImage=class extends ol.source.ImageCanvas{constructor(e){var t={attributions:e.attributions,logo:e.logo,projection:e.projection,canvasFunction:function(e,t,i,s){return this.calculateImage(e,t,i,s)}};super(t),this._image=e.image?e.image:new Image,this._image.crossOrigin=e.crossOrigin,this._image.onload=function(){this.setCrop(this.crop),this.changed()}.bind(this),e.image||(this._image.src=e.url),this.center=e.imageCenter,this.setScale(e.imageScale),this.rotate=e.imageRotate?e.imageRotate:0,this.crop=e.imageCrop,this.mask=e.imageMask,this.setCrop(this.crop),this.on("change",function(){this.set("extent",this.calculateExtent())}.bind(this))}calculateImage(e,t,i,s){if(this.center){var o=document.createElement("canvas");o.width=s[0],o.height=s[1];var r=o.getContext("2d");if(!this._imageSize)return o;if(this.mask){r.beginPath();var a=p(this.mask[0]);r.moveTo(a[0],a[1]);for(var n=1;n<this.mask.length;n++)a=p(this.mask[n]),r.lineTo(a[0],a[1]);r.clip()}var l=p(this.center),h=(this._image.naturalWidth/2-this.crop[0])*this.scale[0]/t*i,c=(this._image.naturalHeight/2-this.crop[1])*this.scale[1]/t*i,u=this._imageSize[0]*this.scale[0]/t*i,d=this._imageSize[1]*this.scale[1]/t*i;return r.translate(l[0],l[1]),this.rotate&&r.rotate(this.rotate),r.drawImage(this._image,this.crop[0],this.crop[1],this._imageSize[0],this._imageSize[1],-h,-c,u,d),o}function p(t){return[(t[0]-e[0])/(e[2]-e[0])*s[0],(t[1]-e[3])/(e[1]-e[3])*s[1]]}}getCenter(){return this.center}setCenter(e){this.center=e,this.changed()}getScale(){return this.scale}setScale(e){switch(typeof e){case"number":e=[e,e];break;case"object":if(2!=e.length)return;break;default:return}this.scale=e,this.changed()}getRotation(){return this.rotate}setRotation(e){this.rotate=e,this.changed()}getGeoImage(){return this._image}getCrop(){return this.crop}setMask(e){this.mask=e,this.changed()}getMask(){return this.mask}setCrop(e){if(this._image.naturalWidth){if(e){switch(typeof e){case"number":e=[e,e,this._image.naturalWidth-e,this._image.naturalHeight-e];break;case"object":if(4!=e.length)return;break;default:return}e=ol.extent.boundingExtent([[e[0],e[1]],[e[2],e[3]]]),this.crop=[Math.max(0,e[0]),Math.max(0,e[1]),Math.min(this._image.naturalWidth,e[2]),Math.min(this._image.naturalHeight,e[3])]}else this.crop=[0,0,this._image.naturalWidth,this._image.naturalHeight];this.crop[2]<=this.crop[0]&&(this.crop[2]=this.crop[0]+1),this.crop[3]<=this.crop[1]&&(this.crop[3]=this.crop[1]+1),this._imageSize=[this.crop[2]-this.crop[0],this.crop[3]-this.crop[1]],this.changed()}else this.crop=e}getExtent(e){var t=this.get("extent");if(t||(t=this.calculateExtent()),e)for(var i=0;i<e.length;i++)e[i]=t[i];return t}calculateExtent(e){var t;if(!1!==e&&this.getMask())t=new ol.geom.Polygon([this.getMask()]);else{var i=this.getCenter(),s=this.getScale(),o=this.getGeoImage().width*s[0],r=this.getGeoImage().height*s[1],a=ol.extent.boundingExtent([[i[0]-o/2,i[1]-r/2],[i[0]+o/2,i[1]+r/2]]);(t=ol.geom.Polygon.fromExtent(a)).rotate(-this.getRotation(),i)}return t.getExtent()}},ol.source.GeoRSS=class extends ol.source.Vector{constructor(e){(e=e||{}).loader=function(e,t,i){return this._loaderFn(e,t,i)},super(e)}_loaderFn(e,t,i){ol.ext.Ajax.get({url:this.getUrl(),dataType:"XML",error:function(){console.log("oops")},success:function(e){var t=(new ol.format.GeoRSS).readFeatures(e,{featureProjection:i});this.addFeatures(t)}.bind(this)})}},ol.source.Geoportail=class extends ol.source.WMTS{constructor(e,t){t=t||{},e.layer&&(e=(t=e).layer);for(var i=new Array,s=new Array,o=ol.extent.getWidth(ol.proj.get("EPSG:3857").getExtent())/256,r=0;r<=(t.maxZoom?t.maxZoom:20);r++)i[r]=r,s[r]=o/Math.pow(2,r);var a=new ol.tilegrid.WMTS({origin:[-20037508,20037508],resolutions:s,matrixIds:i});a.minZoom=t.minZoom?t.minZoom:0;var n=[ol.source.Geoportail.defaultAttribution];t.attributions&&(n=t.attributions);var l=t.server||"https://data.geopf.fr/wmts",h=t.gppKey||t.key||"";super({url:ol.source.Geoportail.getServiceURL(l,h),layer:e,matrixSet:"PM",format:t.format?t.format:"image/jpeg",projection:"EPSG:3857",tileGrid:a,style:t.style?t.style:"normal",attributions:n,crossOrigin:void 0===t.crossOrigin?"anonymous":t.crossOrigin,wrapX:!(!1===t.wrapX)}),this._server=l,this._gppKey=h,t.authentication&&this.setTileLoadFunction(ol.source.Geoportail.tileLoadFunctionWithAuthentication(t.authentication,this.getFormat()))}static tileLoadFunctionWithAuthentication(e,t){if(e)return function(i,s){var o=new XMLHttpRequest;o.open("GET",s),o.setRequestHeader("Authorization","Basic "+e),o.responseType="arraybuffer",o.onload=function(){var e=new Uint8Array(this.response),s=new Blob([e],{type:t}),o=(window.URL||window.webkitURL).createObjectURL(s);i.getImage().src=o},o.onerror=function(){i.getImage().src=""},o.send()}}serviceURL(){return ol.source.Geoportail.getServiceURL(this._server,this._gppKey)}getGPPKey(){return this._gppKey}setGPPKey(e,t){this._gppKey=e;var i=this.serviceURL();this.setTileUrlFunction(function(){var e=ol.source.Geoportail.prototype.getTileUrlFunction().apply(this,arguments);if(e){var t=e.split("?");return i+"?"+t[1]}return e}),t&&this.setTileLoadFunction(ol.source.Geoportail.tileLoadFunctionWithAuthentication(t,this.getFormat()))}getFeatureInfoUrl(e,t,i,s){s=s||{},i||(i=this.getProjection());var o=this.tileGrid.getTileCoordForCoordAndResolution(e,t),r=this.getTileUrlFunction()(o,1,i);if(!r)return r;var a=this.tileGrid.getResolution(o[0]),n=this.tileGrid.getTileCoordExtent(o),l=Math.floor((e[0]-n[0])/(a/1)),h=Math.floor((n[3]-e[1])/(a/1));return r.replace(/Request=GetTile/i,"Request=getFeatureInfo")+"&INFOFORMAT="+(s.INFO_FORMAT||"text/plain")+"&I="+l+"&J="+h}getFeatureInfo(e,t,i){var s=this.getFeatureInfoUrl(e,t,null,i);ol.ext.Ajax.get({url:s,dataType:i.format||"text/plain",options:{encode:!1},success:function(e){i.callback&&i.callback(e)},error:i.error||function(){}})}},ol.source.Geoportail.defaultAttribution='<a href="https://geoservices.ign.fr/">Géoservices</a> &copy; <a href="http://www.ign.fr/">IGN-France</a>',ol.source.Geoportail.getServiceURL=function(e,t){return"gpf"===t&&(t=""),e||(e=t?"https://data.geopf.fr/private/wmts":"https://data.geopf.fr/wmts"),/geopf/.test(e)?t?e+"?apikey="+t:e:e.replace(/^(https?:\/\/[^/]*)(.*)$/,"$1/"+t+"$2")},ol.source.GridBin=class extends ol.source.BinBase{constructor(e){super(e=e||{}),this.set("gridProjection",e.gridProjection||"EPSG:4326"),this.setSize(e.size||1),this.setCircle(e.circle||!1),this.reset()}setGridProjection(e){this.set("gridProjection",e),this.reset()}setSize(e){this.set("size",e),this.reset()}setCircle(e){this.set("circle",e),this.reset()}getGridGeomAt(e){e=ol.proj.transform(e,this.getProjection()||"EPSG:3857",this.get("gridProjection"));var t,i=this.get("size"),s=i*Math.floor(e[0]/i),o=i*Math.floor(e[1]/i);return this.get("circle")?(t=new ol.geom.Circle([s+i/2,o+i/2],i/2),t=ol.geom.Polygon.fromCircle(t)):t=new ol.geom.Polygon([[[s,o],[s+i,o],[s+i,o+i],[s,o+i],[s,o]]]),t.transform(this.get("gridProjection"),this.getProjection()||"EPSG:3857")}},ol.source.HexBin=class extends ol.source.BinBase{constructor(e){super(e=e||{}),this._hexgrid=new ol.HexGrid(e),this.reset()}getGridGeomAt(e){var t=this._hexgrid.coord2hex(e);return new ol.geom.Polygon([this._hexgrid.getHexagon(t)])}setSize(e,t){this._hexgrid.setSize(e),t||this.reset()}getSize(){return this._hexgrid.getSize()}setLayout(e,t){this._hexgrid.setLayout(e),t||this.reset()}getLayout(){return this._hexgrid.getLayout()}setOrigin(e,t){this._hexgrid.setOrigin(e),t||this.reset()}getOrigin(){return this._hexgrid.getOrigin()}getHexFeatures(){return super.getGridFeatures()}},ol.source.IDW=class extends ol.source.ImageCanvas{constructor(e){if((e=e||{}).canvasFunction=function(e,t,i,s){return this.calculateImage(e,t,i,s)},super(e),this._source=e.source,this._canvas=document.createElement("CANVAS"),this._source.on(["addfeature","removefeature","clear","removefeature"],function(){this.changed()}.bind(this)),"function"==typeof e.getColor&&(this.getColor=e.getColor),e.useWorker){var t={hue2rgb:this.hue2rgb,getColor:this.getColor};for(var i in e.useWorker)t[i]=e.useWorker[i];this.worker=new ol.ext.Worker(this.computeImage,{onMessage:this.onImageData.bind(this),lib:t})}this._position={extent:[],resolution:0},this.set("scale",parseFloat(e.scale)||4),this.set("maxD",parseFloat(e.maxD)||0),this._weight="function"==typeof e.weight?e.weight:function(t){return t.get(e.weight||"weight")}}setScale(e){this.set("scale",parseFloat(e)||4),this.changed()}setMaxD(e){this.set("maxD",parseFloat(e)||0),this.changed()}getSource(){return this._source}getValue(e){if(!this._canvas)return null;var t=this.transform(e);return this._canvas.getContext("2d").getImageData(Math.round(t[0]),Math.round(t[1]),1,1).data}hue2rgb(e){return(e=(e+6)%6)<1?Math.round(255*e):e<3?255:e<4?Math.round(255*(4-e)):0}getColor(e){var t=4-.04*e;return[this.hue2rgb(t+2),this.hue2rgb(t),this.hue2rgb(t-2),255]}computeImage(e){var t,i,s=e.data.pts,o=e.data.width,r=e.data.height,a=new Uint8ClampedArray(o*r*4),n=e.data.maxD*e.data.maxD;for(i=0;i<r;i++)for(t=0;t<o;t++){for(var l=0,h=0,c=0;c<s.length;++c){var u=t-s[c][0],d=i-s[c][1],p=u*u+d*d;if(!(n&&p>n)){if(0===p){h=1,l=s[c][2];break}var g=1/(p*p);l+=g*s[c][2],h+=g}}if(l>0){var m=this.getColor(l/h),f=4*(i*o+t);a[f]=m[0],a[f+1]=m[1],a[f+2]=m[2],a[f+3]=m[3]}}return{type:"image",data:a,width:o,height:r}}calculateImage(e,t,i,s){if(!this._source)return this._canvas;if(this._updated)return this._updated=!1,this._canvas;var o=Math.round(s[0]/(this.get("scale")*i)),r=Math.round(s[1]/(this.get("scale")*i)),a=[],n=o/(e[2]-e[0]),l=r/(e[1]-e[3]),h=this.transform=function(t,i){return[(t[0]-e[0])*n,(t[1]-e[3])*l,i]};this._source.getFeatures().forEach(function(e){a.push(h(e.getGeometry().getFirstCoordinate(),this._weight(e)))}.bind(this));var c={pts:a,width:o,height:r,maxD:this.get("maxD")?this.get("maxD")/this.get("scale")/t:0,resolution:t};if(this.worker)this.worker.postMessage(c,!0),this.dispatchEvent({type:"drawstart"}),this._canvas.width===Math.round(s[0])&&this._canvas.height===Math.round(s[1])&&this._position.resolution===t&&this._position.extent[0]===e[0]&&this._position.extent[1]===e[1]||(this._canvas.width=Math.round(s[0]),this._canvas.height=Math.round(s[1])),this._position.extent=e,this._position.resolution=t;else{this._canvas.width=Math.round(s[0]),this._canvas.height=Math.round(s[1]);var u=this.computeImage({data:c});this.onImageData(u)}return this._canvas}onImageData(e){var t=this._internal=document.createElement("CANVAS");t.width=e.width,t.height=e.height,t.getContext("2d").putImageData(new ImageData(e.data,e.width,e.height),0,0),this._canvas.getContext("2d").drawImage(t,0,0,this._canvas.width,this._canvas.height),this.worker&&(this.dispatchEvent({type:"drawend"}),this._updated=!0,this.changed())}},ol.source.InseeBin=class extends ol.source.BinBase{constructor(e){super(e=e||{}),this._grid=new ol.InseeGrid({size:e.size}),this.reset()}setSize(e){this.getSize()!==e&&(this._grid.set("size",e),this.reset())}getSize(){return this._grid.get("size")}getGridGeomAt(e){return this._grid.getGridAtCoordinate(e,this.getProjection())}getGridExtent(e){return this._grid.getExtent(e)}},ol.source.Mapillary=class extends ol.source.Vector{constructor(e){var t=e||{};t.loader=function(e,t,i){return this._loaderFn(e,t,i)},t.attributions||(t.attributions=["&copy; <a href='https://www.mapillary.com/'>Mapillary</a>"]),t.strategy||(t.strategy=ol.loadingstrategy.bbox),super(t),this._maxResolution=t.maxResolution||100,this._limit=t.limit||100}readFeature(){return!0}_loaderFn(e,t,i){if(!(t>this._maxResolution)){var s=ol.proj.transformExtent(e,i,"EPSG:4326"),o=Date.now()-15552e6,r="https://a.mapillary.com/v2/search/im?client_id="+this.get("clientId")+"&max_lat="+s[3]+"&max_lon="+s[2]+"&min_lat="+s[1]+"&min_lon="+s[0]+"&limit="+(this._limit-1)+"&start_time="+o;ol.ext.Ajax.get({url:r,dataType:"jsonp",success:function(e){console.log(e)}})}}},ol.source.OilPainting=class extends ol.source.Raster{constructor(e){e.operation=ol.source.OilPainting._operation,e.operationType="image",super(e),this.set("radius",e.radius||4),this.set("intensity",e.intensity||25),this.on("beforeoperations",function(e){var t=Math.round((e.extent[2]-e.extent[0])/e.resolution),i=Math.round((e.extent[3]-e.extent[1])/e.resolution);e.data.image=new ImageData(t,i),e.data.radius=Number(this.get("radius"))||1,e.data.intensity=Number(this.get("intensity"))}.bind(this))}set(e,t){if(t)switch(e){case"intensity":case"radius":(t=Number(t))<1&&(t=1),this.changed()}return super.set(e,t)}},ol.source.OilPainting._operation=function(e,t){for(var i=e[0].width,s=e[0].height,o=e[0].data,r=[],a=t.image,n=a.data,l=[],h=[],c=0;c<s;c++){l[c]=[],h[c]=[];for(var u=0;u<i;u++){var d=4*(c*i+u),p=o[d],g=o[d+1],m=o[d+2],f=(p+g+m)/3;l[c][u]=Math.round(f*t.intensity/255),h[c][u]={r:p,g:g,b:m}}}var v=t.radius;for(c=0;c<s;c++)for(u=0;u<i;u++){r=[];for(var y=-v;y<=v;y++)for(var _=-v;_<=v;_++)if(c+y>0&&c+y<s&&u+_>0&&u+_<i){var x=l[c+y][u+_];r[x]?(r[x].val++,r[x].r+=h[c+y][u+_].r,r[x].g+=h[c+y][u+_].g,r[x].b+=h[c+y][u+_].b):r[x]={val:1,r:h[c+y][u+_].r,g:h[c+y][u+_].g,b:h[c+y][u+_].b}}r.sort(function(e,t){return t.val-e.val});var b=r[0].val,w=4*(c*i+u);n[w]=~~(r[0].r/b),n[w+1]=~~(r[0].g/b),n[w+2]=~~(r[0].b/b),n[w+3]=255}return a},ol.source.Overpass=class extends ol.source.Vector{constructor(e){(e=e||{}).loader=function(e,t,i){return this._loaderFn(e,t,i)},e.attributions||(e.attributions=ol.source.OSM.ATTRIBUTION),e.strategy||(e.strategy=ol.loadingstrategy.bbox),super(e),this._url=e.url||"https://overpass-api.de/api/interpreter",this._maxResolution=e.maxResolution||100,this._types={node:!1!==e.node,way:!1!==e.way,rel:!0===e.rel},this._filter=e.filter}_loaderFn(e,t,i){if(!(t>this._maxResolution)){var s=this,o=ol.proj.transformExtent(e,i,"EPSG:4326"),r="[bbox:"+(o=o[1]+","+o[0]+","+o[3]+","+o[2])+"][out:xml][timeout:25];";for(var a in r+="(",this._types)if(this._types[a]){r+=a;for(var n,l=0;n=this._filter[l];l++)r+="["+n+"]";r+=";"}r+=");out;>;out skel qt;";var h=new XMLHttpRequest;h.open("POST",this._url,!0),h.onload=function(){for(var e,t=(new ol.format.OSMXML).readFeatures(this.responseText,{featureProjection:i}),o=[],r=0;e=t[r];r++)s.hasFeature(e)||o.push(e);s.addFeatures(o)},h.onerror=function(){console.log(arguments)},h.send("data="+r)}}hasFeature(e){for(var t,i=e.getGeometry().getFirstCoordinate(),s=e.getId(),o=this.getFeaturesInExtent([i[0]-.1,i[1]-.1,i[0]+.1,i[1]+.1]),r=0;t=o[r];r++)if(s===t.getId())return!0;return!1}},ol.source.TileWFS=class extends ol.source.Vector{constructor(e){(e=e||{}).featureLimit||(e.featureLimit=1/0);var t=e.tileZoom||14,i={strategy:ol.loadingstrategy.tile(ol.tilegrid.createXYZ({minZoom:t,maxZoom:t,tileSize:512}))},s=new ol.format.GeoJSON,o=new URL(e.url),r=o.search.replace(/^\?/,"").split("&");o=o.origin+o.pathname;var a=/^service$|^request$|^version$|^typename$|^outputFormat$|^maxFeatures$|^bbox$|^srsname$/i;r.forEach(function(e){var t=e.split("=")[0];a.test(t)||(o+=(/\?/.test(o)?"&":"?")+e)}),o=o+(/\?/.test(o)?"&":"?")+"service=WFS&request=GetFeature&version="+(e.version||"1.1.0")+"&typename="+(e.typeName||"")+"&outputFormat="+(e.outputFormat||"application/json"),e.maxFeatures&&(o+="&maxFeatures="+e.maxFeatures+"&count="+e.maxFeatures);var n={loading:0,loaded:0};i.loader=function(t,i,o){n.loading===n.loaded&&(n.loading=n.loaded=0,this.getFeatures().length>e.maxFeatures&&(this.clear(),this.refresh())),n.loading++,this.dispatchEvent({type:"tileloadstart",loading:n.loading,loaded:n.loaded}),this._loadTile(this._url,t,o,s,n)},super(i),this._url=o,this.set("pagination",e.pagination)}_loadTile(e,t,i,s,o){var r=e+"&srsname="+i.getCode()+"&bbox="+t.join(",")+","+i.getCode();this.get("pagination")&&!/&startIndex/.test(e)&&(r+="&startIndex=0"),ol.ext.Ajax.get({url:r,success:function(r){if(o.loaded++,r.error)this.dispatchEvent({type:"tileloaderror",error:r,loading:o.loading,loaded:o.loaded});else{var a=s.readFeatures(r,{featureProjection:i});a.length>0&&this.addFeatures(a);var n=r.numberReturned||0;/&startIndex/.test(e)&&(n+=parseInt(e.replace(/.*&startIndex=(\d*).*/,"$1")),e=e.replace(/&startIndex=(\d*)/,"")),n<r.totalFeatures?this.get("pagination")?(e+="&startIndex="+n,o.loaded--,this._loadTile(e,t,i,s,o)):(this.dispatchEvent({type:"overload",total:r.totalFeatures,returned:r.numberReturned}),this.dispatchEvent({type:"tileloadend",loading:o.loading,loaded:o.loaded})):this.dispatchEvent({type:"tileloadend",loading:o.loading,loaded:o.loaded})}}.bind(this),error:function(e){o.loaded++,this.dispatchEvent({type:"tileloaderror",error:e,loading:o.loading,loaded:o.loaded})}.bind(this)})}},function(){var e=ol.source.Vector.prototype.clear;ol.source.Vector.prototype.clear=function(t){this.dispatchEvent({type:"clearstart"}),e.call(this,t),this.dispatchEvent({type:"clearend"})}}(),ol.layer.Vector3D=class extends ol.layer.Image{constructor(e){e=e||{};var t=document.createElement("canvas");super({source:new ol.source.ImageCanvas({canvasFunction:function(e,i,s,o){return t.width=o[0],t.height=o[1],t}}),center:e.center||[.5,1],defaultHeight:e.defaultHeight||0,maxResolution:e.maxResolution||1/0}),this._source=e.source,this.height_=this.getHfn(e.height),this.setStyle(e.style),this.on(["postcompose","postrender"],this.onPostcompose_.bind(this))}setHeight(e){this.height_=this.getHfn(e),this.changed()}setStyle(e){if(e instanceof ol.style.Style?this._style=e:this._style=new ol.style.Style,this._style.getStroke()||this._style.setStroke(new ol.style.Stroke({width:1,color:"red"})),this._style.getFill()||this._style.setFill(new ol.style.Fill({color:"rgba(0,0,255,0.5)"})),this._style.getText()||this._style.setText(new ol.style.Fill({color:"red"})),e&&e.getGeometry()){var t=e.getGeometry();"function"==typeof t?this.set("geometry",t):this.set("geometry",function(){return t})}else this.set("geometry",function(e){return e.getGeometry()})}getStyle(){return this._style}onPostcompose_(e){var t=e.frameState.viewState.resolution;if(!(t>this.get("maxResolution"))){if(this.res_=400*t,this.animate_){var i=e.frameState.time-this.animate_;i<this.animateDuration_?(this.elapsedRatio_=this.easing_(i/this.animateDuration_),e.frameState.animate=!0):(this.animate_=!1,this.height_=this.toHeight_)}var s=this._ratio=e.frameState.pixelRatio,o=e.context;this.matrix_=e.frameState.coordinateToPixelTransform,this.inversePixelTransform_=e.inversePixelTransform,e.frameState.size&&(this.center_=[e.frameState.size[0]/2,e.frameState.size[1]]);var r=this._source.getFeaturesInExtent(e.frameState.extent);o.save(),o.scale(s,s);var a=this.getStyle();o.lineWidth=a.getStroke().getWidth(),o.lineCap=a.getStroke().getLineCap(),o.strokeStyle=ol.color.asString(a.getStroke().getColor()),o.fillStyle=ol.color.asString(a.getFill().getColor());for(var n=[],l=0;l<r.length;l++)n.push(this.getFeature3D_(r[l],this._getFeatureHeight(r[l])));this.drawFeature3D_(o,n),o.restore()}}getHfn(e){switch(typeof e){case"function":return e;case"string":var t=this.get("defaultHeight");return function(i){return Number(i.get(e))||t};case"number":return function(){return e};default:return function(){return 10}}}animate(e){e=e||{},this.toHeight_=this.getHfn(e.height),this.animate_=(new Date).getTime(),this.animateDuration_=e.duration||1e3,this.easing_=e.easing||ol.easing.easeOut,this.changed()}animating(){return this.animate_&&(new Date).getTime()-this.animate_>this.animateDuration_&&(this.animate_=!1),!!this.animate_}_getFeatureHeight(e){if(this.animate_){var t=this.height_(e),i=this.toHeight_(e);return t*(1-this.elapsedRatio_)+this.elapsedRatio_*i}return this.height_(e)}hvector_(e,t){var i=[e[0]*this.matrix_[0]+e[1]*this.matrix_[1]+this.matrix_[4],e[0]*this.matrix_[2]+e[1]*this.matrix_[3]+this.matrix_[5]],s=[i[0]+t/this.res_*(i[0]-this.center_[0]),i[1]+t/this.res_*(i[1]-this.center_[1])];return parseFloat(ol.util.VERSION)>9?(i=[i[0]*this.inversePixelTransform_[0]-i[1]*this.inversePixelTransform_[1]+this.inversePixelTransform_[4],-i[0]*this.inversePixelTransform_[2]+i[1]*this.inversePixelTransform_[3]+this.inversePixelTransform_[5]],s=[s[0]*this.inversePixelTransform_[0]-s[1]*this.inversePixelTransform_[1]+this.inversePixelTransform_[4],-s[0]*this.inversePixelTransform_[2]+s[1]*this.inversePixelTransform_[3]+this.inversePixelTransform_[5]],{p0:[i[0]/this._ratio,i[1]/this._ratio],p1:[s[0]/this._ratio,s[1]/this._ratio]}):{p0:i,p1:s}}getFeature3D_(e,t){var i=this.get("geometry")(e),s=i.getCoordinates();switch(i.getType()){case"Polygon":s=[s];case"MultiPolygon":for(var o=[],r=0;r<s.length;r++)for(var a=0;a<s[r].length;a++){for(var n=[],l=0;l<s[r][a].length;l++)n.push(this.hvector_(s[r][a][l],t));o.push(n)}return{type:"MultiPolygon",feature:e,geom:o};case"Point":return{type:"Point",feature:e,geom:this.hvector_(s,t)};default:return{}}}drawFeature3D_(e,t){var i,s,o,r;for(i=0;i<t.length;i++)switch(t[i].type){case"MultiPolygon":for(s=0;s<t[i].geom.length;s++)for(o=t[i].geom[s],r=0;r<o.length;r++)e.beginPath(),e.moveTo(o[r].p0[0],o[r].p0[1]),e.lineTo(o[r].p1[0],o[r].p1[1]),e.stroke();break;case"Point":var a=t[i].geom;e.beginPath(),e.moveTo(a.p0[0],a.p0[1]),e.lineTo(a.p1[0],a.p1[1]),e.stroke()}for(i=0;i<t.length;i++)switch(t[i].type){case"MultiPolygon":for(e.beginPath(),s=0;s<t[i].geom.length;s++){if(o=t[i].geom[s],0==s)for(e.moveTo(o[0].p1[0],o[0].p1[1]),r=1;r<o.length;r++)e.lineTo(o[r].p1[0],o[r].p1[1]);else for(e.moveTo(o[0].p1[0],o[0].p1[1]),r=o.length-2;r>=0;r--)e.lineTo(o[r].p1[0],o[r].p1[1]);e.closePath()}e.fill("evenodd"),e.stroke();break;case"Point":var n=(o=t[i]).feature.get("label");if(n){var l=o.geom.p1,h=e.measureText(n),c=Number(e.font.match(/\d+(\.\d+)?/g).join([]));e.fillRect(l[0]-h.width/2-5,l[1]-c-5,h.width+10,c+10),e.strokeRect(l[0]-h.width/2-5,l[1]-c-5,h.width+10,c+10),e.save(),e.fillStyle=ol.color.asString(this._style.getText().getFill().getColor()),e.textAlign="center",e.textBaseline="bottom",e.fillText(n,l[0],l[1]),e.restore()}}}},ol.source.WikiCommons=class extends ol.source.Vector{constructor(e){var t=e||{};t.loader=function(e,t,i){return this._loaderFn(e,t,i)},t.attributions||(t.attributions=['&copy; <a href="https://commons.wikimedia.org/">Wikimedia Commons</a>']),t.strategy||(t.strategy=ol.loadingstrategy.bbox),super(t),this._maxResolution=t.maxResolution||100,this._lang=t.lang||"fr",this._limit=t.limit||100}readFeature(e,t){return e.set("descriptionurl",t.descriptionurl),e.set("url",t.url),e.set("title",t.title.replace(/^file:|.jpg$/gi,"")),e.set("thumbnail",t.url.replace(/^(.+wikipedia\/commons)\/([a-zA-Z0-9]\/[a-zA-Z0-9]{2})\/(.+)$/,"$1/thumb/$2/$3/200px-$3")),e.set("user",t.user),t.extmetadata&&t.extmetadata.LicenseShortName&&e.set("copy",t.extmetadata.LicenseShortName.value),!0}_loaderFn(e,t,i){if(!(t>this._maxResolution)){var s=this,o=ol.proj.transformExtent(e,i,"EPSG:4326"),r="https://commons.wikimedia.org/w/api.php?action=query&format=json&origin=*&prop=coordinates|imageinfo&generator=geosearch&iiprop=timestamp|user|url|extmetadata|metadata|size&iiextmetadatafilter=LicenseShortName&ggsbbox="+o[3]+"|"+o[0]+"|"+o[1]+"|"+o[2]+"&ggslimit="+this._limit+"&iilimit="+(this._limit-1)+"&ggsnamespace=6";ol.ext.Ajax.get({url:r,success:function(e){var t,o,r,a=[];if(e.query&&e.query.pages){for(var n in e.query.pages){if((t=e.query.pages[n]).coordinates&&t.coordinates.length)o=[t.coordinates[0].lon,t.coordinates[0].lat];else{var l=t.imageinfo[0].metadata;if(!l)continue;o=[];for(var h=0,c=0;c<l.length;c++)"GPSLongitude"==l[c].name&&(o[0]=l[c].value,h++),"GPSLatitude"==l[c].name&&(o[1]=l[c].value,h++);if(2!=h)continue}r=new ol.Feature(new ol.geom.Point(ol.proj.transform(o,"EPSG:4326",i))),t.imageinfo[0].title=t.title,s.readFeature(r,t.imageinfo[0])&&a.push(r)}s.addFeatures(a)}}})}}},ol.layer.AnimatedCluster=class extends ol.layer.Vector{constructor(e){var t=e||{};super(t),this.oldcluster=new ol.source.Vector,this.clusters=[],this.animation={start:!1},this.set("animationDuration","number"==typeof t.animationDuration?t.animationDuration:700),this.set("animationMethod",t.animationMethod||ol.easing.easeOut),this.on(["precompose","prerender"],this.animate.bind(this)),this.on(["postcompose","postrender"],this.postanimate.bind(this))}setSource(e){this._saveClusterFn||(this._saveClusterFn=this.saveCluster.bind(this)),this.getSource()&&this.getSource().un("change",this._saveClusterFn),ol.layer.Vector.prototype.setSource.call(this,e),this.getSource()&&this.getSource().on("change",this._saveClusterFn)}saveCluster(){if(this.oldcluster){if(this.oldcluster.clear(),!this.get("animationDuration"))return;var e=this.getSource().getFeatures();e.length&&e[0].get("features")&&(this.oldcluster.addFeatures(this.clusters),this.clusters=e.slice(0),this.sourceChanged=!0)}}getClusterForFeature(e,t){for(var i,s=0;i=t[s];s++){var o=i.get("features");if(o&&o.length)for(var r,a=0;r=o[a];a++)if(e===r)return i}return!1}stopAnimation(){this.animation.start=!1,this.animation.cA=[],this.animation.cB=[]}animate(e){var t=this.get("animationDuration");if(t){var i,s,o=e.frameState.viewState.resolution,r=this.animation,a=e.frameState.time;if(r.resolution!=o&&this.sourceChanged){var n=e.frameState.extent;for(r.resolution<o?(n=ol.extent.buffer(n,100*o),r.cA=this.oldcluster.getFeaturesInExtent(n),r.cB=this.getSource().getFeaturesInExtent(n),r.revers=!1):(n=ol.extent.buffer(n,100*o),r.cA=this.getSource().getFeaturesInExtent(n),r.cB=this.oldcluster.getFeaturesInExtent(n),r.revers=!0),r.clusters=[],i=0;s=r.cA[i];i++){var l=s.get("features");if(l&&l.length){var h=this.getClusterForFeature(l[0],r.cB);h&&r.clusters.push({f:s,pt:h.getGeometry().getCoordinates()})}}if(r.resolution=o,this.sourceChanged=!1,!r.clusters.length||r.clusters.length>1e3)return void this.stopAnimation();a=r.start=(new Date).getTime()}if(r.start){var c=e.vectorContext||ol.render.getVectorContext(e),u=(a-r.start)/t;u>1&&(this.stopAnimation(),u=1),u=this.get("animationMethod")(u);var d=this.getStyle(),p="function"==typeof d?d:d.length?function(){return d}:function(){return[d]};for(e.context.save(),e.context.globalAlpha=this.getOpacity(),i=0;h=r.clusters[i];i++){var g=h.f.getGeometry().getCoordinates(),m=g[0]-h.pt[0],f=g[1]-h.pt[1];r.revers?(g[0]=h.pt[0]+u*m,g[1]=h.pt[1]+u*f):(g[0]=g[0]-u*m,g[1]=g[1]-u*f);var v=p(h.f,o,!0);if(Array.isArray(v)||(v=[v]),1!==h.f.get("features").length||m||f){var y=new ol.geom.Point(g);l=new ol.Feature(y)}else l=h.f.get("features")[0];for(var _,x=0;_=v[x];x++)if(_.getText()&&/\n/.test(_.getText().getText())){var b,w=_.getText().getOffsetX(),S=_.getText().getOffsetY(),M=_.getText().getRotation()||0,C=1.2*Number((_.getText().getFont()||"10px").match(/\d+/)),E=_.getText().getText().split("\n"),L=E.length-1,T=_.clone();E.forEach(function(t,i){switch(1==i&&(T.setImage(),T.setFill(),T.setStroke()),_.getText().getTextBaseline()){case"alphabetic":case"ideographic":case"bottom":b=L;break;case"hanging":case"top":b=0;break;default:b=L/2}T.getText().setOffsetX(w-Math.sin(M)*C*(i-b)),T.getText().setOffsetY(S+Math.cos(M)*C*(i-b)),T.getText().setText(t),c.drawFeature(l,ol.ext.getVectorContextStyle(e,T))})}else c.drawFeature(l,ol.ext.getVectorContextStyle(e,_))}e.context.restore(),e.frameState.animate=!0,e.context.save(),e.context.beginPath(),e.context.rect(0,0,0,0),e.context.clip(),this.clip_=!0}}}postanimate(e){this.clip_&&(e.context.restore(),this.clip_=!1)}},ol.layer.GeoImage=class extends ol.layer.Image{constructor(e){super(e)}getExtent(){return this.getSource().getExtent()}},ol.layer.Geoportail=class extends ol.layer.Tile{constructor(e,t,i){t=t||{},i=i||{},"string"!=typeof e&&(i=t||{},e=(t=e).layer);var s=t.maxZoom;t.source&&(e=t.source.getLayer(),t.gppKey=t.source.getGPPKey());var o=window.geoportailConfig&&(window.geoportailConfig.capabilities[t.gppKey||t.key]||window.geoportailConfig.capabilities.default)||ol.layer.Geoportail.capabilities;for(var r in(o=o[e])||(o=ol.layer.Geoportail.capabilities[e]),o||(o={title:e,originators:[]},console.error('ol.layer.Geoportail: no layer definition for "'+e+'"\nTry to use ol/layer/Geoportail~loadCapabilities() to get it.')),o)void 0===i[r]&&(i[r]=o[r]);(t.gppKey||t.key)&&(i.gppKey=t.gppKey||t.key),t.source||(t.source=new ol.source.Geoportail(e,i)),t.title||(t.title=o.title),t.name||(t.name=e),t.layer=e,t.queryable||(t.queryable=o.queryable),t.desc||(t.desc=o.desc),!t.extent&&o.bbox&&o.bbox[0]>-170&&o.bbox[2]<170&&(t.extent=ol.proj.transformExtent(o.bbox,"EPSG:4326",t.projection||"EPSG:3857")),t.maxZoom=s,!t.maxResolution&&i.minZoom&&(t.source.getTileGrid().minZoom-=i.minZoom>1?2:1,t.maxResolution=t.source.getTileGrid().getResolution(t.source.getTileGrid().minZoom),t.source.getTileGrid().minZoom=i.minZoom),super(t),this._originators=o.originators}static register(e,t){ol.layer.Geoportail.capabilities[e]=t}static isRegistered(e){return ol.layer.Geoportail.capabilities[e]&&ol.layer.Geoportail.capabilities[e].key}static loadCapabilities(e){var t=function(){},i=function(){},s=function(){};this.getCapabilities(e).then(function(e){ol.layer.Geoportail.capabilities=e,t(e)}).catch(function(e){i(e)}).finally(function(e){s(e)});var o={then:function(e){return"function"==typeof e&&(t=e),o},catch:function(e){return"function"==typeof e&&(i=e),o},finally:function(e){return"function"==typeof e&&(s=e),o}};return o}static getCapabilities(e){"gpf"===e&&(e=void 0);var t=function(){},i=function(){},s=function(){};function o(e){for(var t={min:parseFloat(e[0].TileMatrix),max:parseFloat(e[0].TileMatrix)},i=1;i<e.length;i++)t.min=Math.min(t.min,parseFloat(e[i].TileMatrix)),t.max=Math.max(t.max,parseFloat(e[i].TileMatrix));return t}function r(e){for(var t=0;t<ol.layer.Geoportail.themes.length;t++)if(ol.layer.Geoportail.themes[t].rex.test(e))return ol.layer.Geoportail.themes[t].theme;return"autre"}var a=e?"https://data.geopf.fr/private/wmts":"https://data.geopf.fr/wmts",n=a+"?SERVICE=WMTS&VERSION=1.0.0&REQUEST=GetCapabilities";e&&(n+="&apikey="+e),ol.ext.Ajax.get({url:n,dataType:"TEXT",error:function(e){i(e),s({})},success:function(i){var n=(new DOMParser).parseFromString(i,"text/xml");n=n.getElementsByTagName("Layer");for(var l=(i=(new ol.format.WMTSCapabilities).read(i)).Contents.Layer,h={},c={},u=0;u<l.length;u++){var d=l[u],p=o(d.TileMatrixSetLink[0].TileMatrixSetLimits),g=r(d.Identifier);c[g]||(c[g]={});var m=[];d.Style&&d.Style.forEach(function(e){e.LegendURL&&m.push(e.LegendURL[0].href)}),c[g][d.Identifier]=h[d.Identifier]={layer:d.Identifier,key:e,theme:g,desc:d.Abstract,server:a,bbox:d.WGS84BoundingBox,format:d.Format[0],minZoom:p.min,maxZoom:p.max,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:n[u].getElementsByTagName("InfoFormat").length>0,style:d.Style&&d.Style.length?d.Style[0].Identifier:"normal",tilematrix:"PM",title:d.Title,legend:m}}t(h,c),s(h,c)}});var l={then:function(e){return"function"==typeof e&&(t=e),l},catch:function(e){return"function"==typeof e&&(i=e),l},finally:function(e){return"function"==typeof e&&(s=e),l}};return l}},ol.layer.Geoportail.capabilities={"GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2":{layer:"GEOGRAPHICALGRIDSYSTEMS.PLANIGNV2",theme:"cartes",desc:"Cartographie multi-échelles sur le territoire national, issue des bases de données vecteur de l’IGN, mis à jour régulièrement et réalisée selon un processus entièrement automatisé.",server:"https://data.geopf.fr/wmts",bbox:[-175,-85,175,85],format:"image/png",minZoom:0,maxZoom:19,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Plan IGN v2"},"CADASTRALPARCELS.PARCELLAIRE_EXPRESS":{layer:"CADASTRALPARCELS.PARCELLAIRE_EXPRESS",theme:"parcellaire",desc:"Plan cadastral informatisé vecteur de la DGFIP édition Juillet 2023.",server:"https://data.geopf.fr/wmts",bbox:[-63.3725,-21.4756,55.9259,51.3121],format:"image/png",minZoom:0,maxZoom:19,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"PCI vecteur"},"ORTHOIMAGERY.ORTHOPHOTOS":{layer:"ORTHOIMAGERY.ORTHOPHOTOS",theme:"ortho",desc:"Photographies aériennes",server:"https://data.geopf.fr/wmts",bbox:[-180,-89,180,89],format:"image/jpeg",minZoom:0,maxZoom:20,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!0,style:"normal",tilematrix:"PM",title:"Photographies aériennes"},"GEOGRAPHICALGRIDSYSTEMS.MAPS":{layer:"GEOGRAPHICALGRIDSYSTEMS.MAPS",theme:"cartes",desc:"Cartes IGN",server:"https://data.geopf.fr/private/wmts",bbox:[-180,-68.1389,180,80],format:"image/jpeg",minZoom:0,maxZoom:18,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Cartes IGN"},"ADMINEXPRESS-COG-CARTO.LATEST":{layer:"ADMINEXPRESS-COG-CARTO.LATEST",theme:"administratif",desc:"Limites administratives Express COG code officiel géographique 2023",server:"https://data.geopf.fr/wmts",bbox:[-63.3725,-21.4756,55.9259,51.3121],format:"image/png",minZoom:6,maxZoom:16,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!0,style:"normal",tilematrix:"PM",title:"ADMINEXPRESS COG CARTO"},"GEOGRAPHICALGRIDSYSTEMS.SLOPES.MOUNTAIN":{layer:"GEOGRAPHICALGRIDSYSTEMS.SLOPES.MOUNTAIN",theme:"cartes",desc:"Carte des zones ayant une valeur de pente supérieure à 30°-35°-40°-45° d'après la BD ALTI au pas de 5m",server:"https://data.geopf.fr/wmts",bbox:[-63.1614,-21.5446,56.0018,51.0991],format:"image/png",minZoom:0,maxZoom:17,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Carte des pentes"},"ELEVATION.SLOPES":{layer:"ELEVATION.SLOPES",theme:"altimetrie",desc:"La couche altitude se compose d'un MNT (Modèle Numérique de Terrain) affiché en teintes hypsométriques et issu de la BD ALTI®.",server:"https://data.geopf.fr/wmts",bbox:[-179.5,-75,179.5,75],format:"image/jpeg",minZoom:6,maxZoom:14,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Altitude"},"GEOGRAPHICALGRIDSYSTEMS.MAPS.BDUNI.J1":{key:"cartes",server:"https://wxs.ign.fr/geoportail/wmts",layer:"GEOGRAPHICALGRIDSYSTEMS.MAPS.BDUNI.J1",title:"Plan IGN j+1",format:"image/png",style:"normal",queryable:!1,tilematrix:"PM",minZoom:0,maxZoom:18,bbox:[-179.5,-75,179.5,75],desc:"Plan IGN j+1",originators:{IGN:{href:"http://www.ign.fr",attribution:"Institut national de l'information géographique et forestière",logo:"https://wxs.ign.fr/static/logos/IGN/IGN.gif",minZoom:0,maxZoom:18,constraint:[{minZoom:0,maxZoom:18,bbox:[-179,-80,179,80]}]}}},"TRANSPORTNETWORKS.ROADS":{layer:"TRANSPORTNETWORKS.ROADS",theme:"topographie",desc:"Affichage du réseau routier français et européen.",server:"https://data.geopf.fr/wmts",bbox:[-63.9692,-21.4969,55.9644,71.5841],format:"image/png",minZoom:6,maxZoom:18,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Routes"},"GEOGRAPHICALNAMES.NAMES":{layer:"GEOGRAPHICALNAMES.NAMES",theme:"topographie",desc:"Affichage des noms des villes, villages, lieux-dits ...",server:"https://data.geopf.fr/wmts",bbox:[-63.9692,-21.4969,55.9644,71.5841],format:"image/png",minZoom:6,maxZoom:18,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Dénominations géographiques",legend:["https://data.geopf.fr/annexes/ressources/legendes/LEGEND.jpg"]},"CARTES.NATURALEARTH":{layer:"CARTES.NATURALEARTH",theme:"cartes",desc:"Carte générale du monde politique avec les frontières et capitales d'Etat, les entités administratives secondaires, villes principales, fleuves, lacs et océans. Edition : 1.4.0",server:"https://data.geopf.fr/wmts",bbox:[-179.5,-75,179.5,75],format:"image/jpeg",minZoom:1,maxZoom:9,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Monde Natural Earth",legend:["https://data.geopf.fr/annexes/ressources/legendes/LEGEND.jpg"]},"GEOGRAPHICALGRIDSYSTEMS.MAPS.OVERVIEW":{layer:"GEOGRAPHICALGRIDSYSTEMS.MAPS.OVERVIEW",key:"",theme:"cartes",desc:"Carte Mondiale pour la mini-vue",server:"https://data.geopf.fr/wmts",bbox:[-179.5,-75,179.5,75],format:"image/jpeg",minZoom:1,maxZoom:8,originators:{Geoservices:{attribution:"Géoservices",href:"https://geoservices.ign.fr/"}},queryable:!1,style:"normal",tilematrix:"PM",title:"Carte Mondiale pour la mini-vue",legend:["https://data.geopf.fr/annexes/ressources/legendes/LEGEND.jpg"]}},ol.layer.Geoportail.themes=[{theme:"edugeo",rex:/EDUGEO|PVA_IGN_zone-marais|VERDUN|DOUAUMONT/},{theme:"cartes",rex:/GEOGRAPHICALGRIDSYSTEMS|CARTES|SCAN/},{theme:"energie",rex:/CHALEUR|CHAUD|FROID|METHAN|CONSO|ENR|ELECTRIQUE|EOLIEN|SOLAIRE|PRODUCTIBLE|GEOTHERM|PROD\.INSTALLATION|POTENTIEL\.HYDRO/},{theme:"risque",rex:/SISMIC|RISKZONE/},{theme:"agriculture",rex:/AGRICULTURE|PAC/},{theme:"altimetrie",rex:/ELEVATION|SLOPE|ISOHYPSE/},{theme:"parcellaire",rex:/PARCELS|Parcellaire|RPG|PCRS|PCI/},{theme:"administratif",rex:/ADMIN/},{theme:"ocsge",rex:/OCSGE|CoSIA/},{theme:"clc",rex:/\.CLC|\.CHA/},{theme:"environnement",rex:/PROTECTEDAREAS|FORETS|DEBROUSSAILLEMENT|LANDCOVER|PROTECTEDSITES|CHASSE|INPE|OFB/},{theme:"topographie",rex:/BDCARTO|PARKING|RAILWAYS|BUILDINGS|RUNWAYS|UTILITYANDGOVERNMENTALSERVICES|GEOGRAPHICALNAMES\.NAMES|HYDROGRAPHY|TRANSPORTNETWORKS\.ROADS$|hedge.hedge/},{theme:"transport",rex:/TRANSPORT|SECUROUTE|AUTOROUT/},{theme:"economie",rex:/INSEE|AREAMANAGEMENT|PINEL|PRIORITYDISCTRICT/},{theme:"agriculture",rex:/LANDUSE|PRAIRIES/},{theme:"satellite",rex:/ORTHO-SAT|SPOT5|RAPIDEYE/},{theme:"orthohisto",rex:/ORTHOPHOTOS\d|ORTHO-EXPRESS-\d/},{theme:"ortho",rex:/ORTHOIMAGERY/}],ol.source.Source.prototype.getPreview=function(){return"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAk6QAAJOkBUCTn+AAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAANeSURBVHic7ZpPiE1RHMc/780MBhkik79JSUlIUbOxI+wkI2yRhYSUlJLNpJF/xcpiJBmZGBZsNM1CkmhKITGkGbH0/BuPmXnP4rxbb/TOn3fvOffeec6nfqvb/b7f93fveeec37ng8Xg8Ho/nf6Uu4d+fDswFssCvhHOJhaXAMeApMAQUyyIPPAdOAiuTStAVy4EHjDWsix5gdRLJ2mY34ulWYz6IEeA4kIk9awtkgTOEM/5vdAKT4k0/Ou3YMR/ELcbRm9AKFLBbgCJwNE4TYZkJfMG++SIwDCyLz0o4bI17WdyJz0r1TAZ+oDcxCBwAFgIzEIuhvcBbg3sLwOK4DFXLFvQGniCGSSUagS4DjUPOHESkA3XiOWCORqMR6Nfo9DjI3QqPUSd+ylBnv0Zn0GrWFvmIOvGNhjqrNDp/EAutyFgRKUM2tgO+Gur81FxvAKYZaimxXYBvmuuLDHWWaK4X0RfJCNsF6NdcbzXU2a65PohYFKWOc+jn8PUajbWIXaBKp9NB7lZYh34OzwFbFfd/NtDYYSth27urLGIm0M31AL3APWAAmIooymaDnPIl/Vz4NN1yHrd7gcvxWQnHAuA3bsyPop8hUsE13BSgK04TUViBeFo2zedJ8S6wElexW4D2eNOPTjNi6WvD/DtEr8E6tk6GGoAmxFY2iFHE9NZiQf8gogiB9gTEH23izAZuE77vHyU+ANucO1QwD3hD/MbLowAcdm20EmkwXx4n3NodS9rMB2HabYpEWs0HcRqHp0fNwAvJD+eBTZr7p6BvmQVxUaEzEbiruNfJekH15L8jtrEm7JJolEcOmKXRqQOuKDQuY7HZY8s8iNfzkSLxIuI43FTrkkLnOlBfRW4VsWk+oAX5weknxFAxJQNckGgVgZuIRVoomoGXEmGTMa+iQ6K7M4SW7k24QYgiuDQPYinbhugiF4H3RGtzZYCzyIvQXfpNI1ybLyeLpf5+iTbkRbiP2EcocTHm4+YI8iI8RFHwWjAfsA95Q+YZFU6wasl8wB7kReijtNbIILa0vcg/PRlGfPQwHmlCviDqAzaA+OREtzqr1ejOIDorxlNEjTGUBV4nnUWCvAJxGDlA8q9j3DEArAn2zvXAfOwfl6eVAmJrPpJ0Ih6Px+PxeJLjLwPul3vj5d0eAAAAAElFTkSuQmCC"},ol.source.Tile.prototype.getPreview=function(e,t){e||(e=[21020,6355964]),t||(t=150);var i=this.getTileGrid().getTileCoordForCoordAndResolution(e,t);return this.getTileUrlFunction().call(this,i,this.getProjection())},ol.source.TileWMS.prototype.getPreview=function(e,t){e||(e=[21020,6355964]),t||(t=150);var i=this.getTileUrlFunction();if(i){var s=(this.getTileGrid()||this.getTileGridForProjection(this.getProjection())).getTileCoordForCoordAndResolution(e,t);return i.call(this,s,1,this.getProjection())}var o=this.getGetFeatureInfoUrl?this.getGetFeatureInfoUrl(e,t,this.getProjection()||"EPSG:3857",{}):this.getFeatureInfoUrl(e,t,this.getProjection()||"EPSG:3857",{});return o=o.replace(/getfeatureinfo/i,"GetMap")},ol.layer.Base.prototype.getPreview=function(e,t,i){if(this.get("preview"))return[this.get("preview")];if(t||(t=150),t<this.getMinResolution()||t>this.getMaxResolution()){var s=this.getMinResolution(),o=this.getMaxResolution();for(o>1e5&&(o=156543),s<.15&&(s=.15),t=o;o>s;)o/=2,t=s*=2}var r=this.getExtent();if(e||(e=[21020,6355964]),r&&!ol.extent.containsCoordinate(r,e)&&(e=[(r[0]+r[2])/2,(r[1]+r[3])/2]),i&&(e=ol.proj.transform(e,i,this.getSource().getProjection())),this.getSource&&this.getSource())try{return[this.getSource().getPreview(e,t)]}catch(r){}return[]},ol.layer.Group.prototype.getPreview=function(e,t){if(this.get("preview"))return[this.get("preview")];var i=[];if(this.getLayers)for(var s=this.getLayers().getArray(),o=0;o<s.length;o++)i=i.concat(s[o].getPreview(e,t));return i},ol.layer.Maplibre=function(e){ol.layer.Layer||console.error("[ol/layer/MapLibre] bad ol version (need ol@6+)"),(e=e||{}).render=function(t){this._container||this._create(e.style);this._container.style.width=1*t.size[0]+"px",this._container.style.height=1*t.size[1]+"px";var i=this.glMap;if(!i)return null;var s=i.getCanvas();s.style.transform="scale(1)",t.size[0]===s.width&&t.size[1]===s.height||i.resize(),s.style.opacity=this.getOpacity();var o=t.viewState;return i.jumpTo({center:ol.proj.toLonLat(o.center),zoom:o.zoom-1,bearing:180*-o.rotation/Math.PI,animate:!1}),i._frame&&(i._frame.cancel(),i._frame=null),i._render(),this._container},ol.layer.Layer.call(this,e)},ol.layer.Layer||(ol.layer.Layer=function(){}),ol.ext.inherits(ol.layer.Maplibre,ol.layer.Layer),ol.layer.Maplibre.prototype.getMapGL=function(){return this.glMap},ol.layer.Maplibre.prototype.setStyle=function(e){this.set("style",e),this.getMapGL()&&this.getMapGL().setStyle(e),this.changed()},ol.layer.Maplibre.prototype.getStyle=function(){return this.getMapGL().get("style")},ol.layer.Maplibre.prototype._create=function(e){this._container=ol.ext.element.create("DIV",{className:"ol-maplibre-gl",style:{position:"absolute",top:0,left:0},parent:document.body}),this.glMap=new mapboxgl.Map({container:this._container,style:e,center:[3,47],zoom:5,pitch:0,antialias:!0,attributionControl:!1,boxZoom:!1,doubleClickZoom:!1,dragPan:!1,dragRotate:!1,interactive:!1,keyboard:!1,pitchWithRotate:!1,scrollZoom:!1,touchZoomRotate:!1})},ol.layer.Vector.prototype.setRender3D=function(e){e.setLayer(this)},ol.render3D=class extends ol.Object{constructor(e){(e=e||{}).maxResolution=e.maxResolution||100,e.defaultHeight=e.defaultHeight||0,super(e),this.setStyle(e.style),this.set("ghost",e.ghost),this.setActive(e.active||!1!==e.active),this.height_=e.height=this.getHfn(e.height),e.layer&&this.setLayer(e.layer)}setStyle(e){if(e instanceof ol.style.Style?this._style=e:this._style=new ol.style.Style,this._style.getStroke()||this._style.setStroke(new ol.style.Stroke({width:1,color:"red"})),this._style.getFill()||this._style.setFill(new ol.style.Fill({color:"rgba(0,0,255,0.5)"})),e&&e.getGeometry()){var t=e.getGeometry();"function"==typeof t?this.set("geometry",t):this.set("geometry",function(){return t})}else this.set("geometry",function(e){return e.getGeometry()})}getStyle(){return this._style}setActive(e){this._active="function"==typeof e?e:function(){return e},this.layer_&&this.layer_.changed()}getActive(){return this._active()}onPostcompose_(e){if(this.getActive()){var t=e.frameState.viewState.resolution;if(!(t>this.get("maxResolution"))){if(this.res_=400*t,this.animate_){var i=e.frameState.time-this.animate_;i<this.animateDuration_?(this.elapsedRatio_=this.easing_(i/this.animateDuration_),e.frameState.animate=!0):(this.animate_=!1,this.height_=this.toHeight_)}var s=this._ratio=e.frameState.pixelRatio,o=e.context;this.matrix_=e.frameState.coordinateToPixelTransform,this.inversePixelTransform_=e.inversePixelTransform,this.center_=[e.frameState.size[0]/2,e.frameState.size[1]];var r=this.layer_.getSource().getFeaturesInExtent(e.frameState.extent);o.save(),o.scale(s,s);var a=this.getStyle();o.lineWidth=a.getStroke().getWidth(),o.strokeStyle=ol.color.asString(a.getStroke().getColor()),o.fillStyle=ol.color.asString(a.getFill().getColor());for(var n=[],l=0;l<r.length;l++){var h=this.getFeatureHeight(r[l]);h&&n.push(this.getFeature3D_(r[l],h))}this.get("ghost")?this.drawGhost3D_(o,n):this.drawFeature3D_(o,n),o.restore()}}}setLayer(e){this._listener&&this._listener.forEach(function(e){ol.Observable.unByKey(e)}),this.layer_=e,this._listener=e.on(["postcompose","postrender"],this.onPostcompose_.bind(this))}getHfn(e){switch(typeof e){case"function":return e;case"string":var t=this.get("defaultHeight");return function(i){return Number(i.get(e))||t};case"number":return function(){return e};default:return function(){return 10}}}animate(e){e=e||{},this.toHeight_=this.getHfn(e.height),this.animate_=(new Date).getTime(),this.animateDuration_=e.duration||1e3,this.easing_=e.easing||ol.easing.easeOut,this.layer_.changed()}animating(){return this.animate_&&(new Date).getTime()-this.animate_>this.animateDuration_&&(this.animate_=!1),!!this.animate_}getFeatureHeight(e){if(this.animate_){var t=this.height_(e),i=this.toHeight_(e);return t*(1-this.elapsedRatio_)+this.elapsedRatio_*i}return this.height_(e)}hvector_(e,t){var i=[e[0]*this.matrix_[0]+e[1]*this.matrix_[1]+this.matrix_[4],e[0]*this.matrix_[2]+e[1]*this.matrix_[3]+this.matrix_[5]],s=[i[0]+t/this.res_*(i[0]-this.center_[0]),i[1]+t/this.res_*(i[1]-this.center_[1])];return parseFloat(ol.util.VERSION)>9?(i=[i[0]*this.inversePixelTransform_[0]-i[1]*this.inversePixelTransform_[1]+this.inversePixelTransform_[4],-i[0]*this.inversePixelTransform_[2]+i[1]*this.inversePixelTransform_[3]+this.inversePixelTransform_[5]],s=[s[0]*this.inversePixelTransform_[0]-s[1]*this.inversePixelTransform_[1]+this.inversePixelTransform_[4],-s[0]*this.inversePixelTransform_[2]+s[1]*this.inversePixelTransform_[3]+this.inversePixelTransform_[5]],{p0:[i[0]/this._ratio,i[1]/this._ratio],p1:[s[0]/this._ratio,s[1]/this._ratio]}):{p0:i,p1:s}}getFeature3D_(e,t){var i=this.get("geometry")(e),s=i.getCoordinates();switch(i.getType()){case"Polygon":s=[s];case"MultiPolygon":for(var o=[],r=0;r<s.length;r++)for(var a=0;a<s[r].length;a++){for(var n=[],l=0;l<s[r][a].length;l++)n.push(this.hvector_(s[r][a][l],t));o.push(n)}return{type:"MultiPolygon",feature:e,geom:o,height:t};case"Point":return{type:"Point",feature:e,geom:this.hvector_(s,t),height:t};default:return{}}}drawFeature3D_(e,t){var i,s,o,r;for(i=0;i<t.length;i++)switch(t[i].type){case"MultiPolygon":for(s=0;s<t[i].geom.length;s++)for(o=t[i].geom[s],r=0;r<o.length;r++)e.beginPath(),e.moveTo(o[r].p0[0],o[r].p0[1]),e.lineTo(o[r].p1[0],o[r].p1[1]),e.stroke();break;case"Point":var a=t[i].geom;e.beginPath(),e.moveTo(a.p0[0],a.p0[1]),e.lineTo(a.p1[0],a.p1[1]),e.stroke()}for(i=0;i<t.length;i++)switch(t[i].type){case"MultiPolygon":for(e.beginPath(),s=0;s<t[i].geom.length;s++){if(o=t[i].geom[s],0==s)for(e.moveTo(o[0].p1[0],o[0].p1[1]),r=1;r<o.length;r++)e.lineTo(o[r].p1[0],o[r].p1[1]);else for(e.moveTo(o[0].p1[0],o[0].p1[1]),r=o.length-2;r>=0;r--)e.lineTo(o[r].p1[0],o[r].p1[1]);e.closePath()}e.fill("evenodd"),e.stroke();break;case"Point":var n=(o=t[i]).feature.get("label");if(n){var l=o.geom.p1,h=e.fillStyle;e.fillStyle=e.strokeStyle,e.textAlign="center",e.textBaseline="bottom",e.fillText(n,l[0],l[1]);var c=e.measureText(n),u=Number(e.font.match(/\d+(\.\d+)?/g).join([]));e.fillStyle="rgba(255,255,255,0.5)",e.fillRect(l[0]-c.width/2-5,l[1]-u-5,c.width+10,u+10),e.strokeRect(l[0]-c.width/2-5,l[1]-u-5,c.width+10,u+10),e.fillStyle=h}}}drawGhost3D_(e,t){var i,s,o,r;for(i=0;i<t.length;i++)switch(t[i].type){case"MultiPolygon":for(s=0;s<t[i].geom.length;s++)for(o=t[i].geom[s],r=0;r<o.length-1;r++){e.beginPath(),e.moveTo(o[r].p0[0],o[r].p0[1]),e.lineTo(o[r].p1[0],o[r].p1[1]),e.lineTo(o[r+1].p1[0],o[r+1].p1[1]),e.lineTo(o[r+1].p0[0],o[r+1].p0[1]),e.lineTo(o[r].p0[0],o[r].p0[1]);var a=[(o[r].p0[0]+o[r+1].p0[0])/2,(o[r].p0[1]+o[r+1].p0[1])/2],n=[o[r].p0[1]-o[r+1].p0[1],-o[r].p0[0]+o[r+1].p0[0]],l=ol.coordinate.getIntersectionPoint([a,[a[0]+n[0],a[1]+n[1]]],[o[r].p1,o[r+1].p1]),h=e.createLinearGradient(a[0],a[1],l[0],l[1]);h.addColorStop(0,"rgba(255,255,255,.2)"),h.addColorStop(1,"rgba(255,255,255,0)"),e.fillStyle=h,e.fill()}break;case"Point":var c=t[i].geom;e.beginPath(),e.moveTo(c.p0[0],c.p0[1]),e.lineTo(c.p1[0],c.p1[1]),e.stroke()}}},ol.layer.SketchOverlay=class extends ol.layer.Vector{constructor(e){var t=(e=e||{}).style||ol.style.Style.defaultStyle(!0),i=e.sketchStyle;i||(i=ol.style.Style.defaultStyle(),(i=[new ol.style.Style({image:new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[255,255,255,.5],width:3})})}),i[0].clone()])[1].setImage(new ol.style.RegularShape({points:4,radius:10,radius2:0,stroke:new ol.style.Stroke({color:[0,153,255,1],width:1.25})}))),super({name:"sketch",source:new ol.source.Vector({useSpatialIndex:!1}),style:function(e){return e.get("sketch")?i:t},updateWhileAnimating:!0,updateWhileInteracting:!0}),this._geom=[],this.getSource().addFeatures([new ol.Feature({sketch:!0,geometry:new ol.geom.Point([])}),new ol.Feature({sketch:!0,geometry:new ol.geom.LineString([])}),new ol.Feature,new ol.Feature(new ol.geom.Point([]))]),this.setGeometryType(e.type)}setGeometryType(e){var t=/^Point$|^LineString$|^Polygon$|^Circle$/.test(e)?e:"LineString";return t!==this._type&&(this.abortDrawing(),this._type=t),this._type}getGeometryType(){return this._type}addPoint(e){return this._lastCoord!==this._position&&(this._geom.length||this.startDrawing(),this._geom.push(e),this._lastCoord=e,this._position=e,this.drawSketch(),"Point"===this.getGeometryType()&&this.finishDrawing(),"Circle"===this.getGeometryType()&&this._geom.length>=2&&this.finishDrawing(),!0)}removeLastPoint(){this._geom.pop(),this._lastCoord=this._geom[this._geom.length-1],this.drawSketch()}startDrawing(e){e=e||{},this._geom=[],e.type&&this.setGeometryType(e.type),this.drawSketch(),this._drawing||this.dispatchEvent({type:"drawstart",feature:this.getFeature()}),this._drawing=!0}finishDrawing(e){var t=this.getSource().getFeatures()[2].clone(),i=!!t;switch(this.getGeometryType()){case"Circle":case"LineString":i=this._geom.length>1;break;case"Polygon":i=this._geom.length>2}return!(e&&!i)&&(this._geom=[],this._lastCoord=null,this.drawSketch(),this._drawing&&this.dispatchEvent({type:"drawend",valid:i,feature:t}),this._drawing=!1,t)}abortDrawing(){this._drawing&&this.dispatchEvent({type:"drawabort",feature:this.getFeature()}),this._drawing=!1,this._geom=[],this._lastCoord=null,this.drawSketch()}setPosition(e){this._position=e,this.drawLink()}getPosition(){return this._position}drawLink(){var e=this.getSource().getFeatures();this._position?(this._lastCoord&&this._lastCoord===this._position?e[0].getGeometry().setCoordinates([]):e[0].getGeometry().setCoordinates(this._position),this._geom.length?"Circle"===this.getGeometryType()?e[1].setGeometry(new ol.geom.Circle(this._geom[0],ol.coordinate.dist2d(this._geom[0],this._position))):"Polygon"===this.getGeometryType()?e[1].setGeometry(new ol.geom.LineString([this._lastCoord,this._position,this._geom[0]])):e[1].setGeometry(new ol.geom.LineString([this._lastCoord,this._position])):e[1].setGeometry(new ol.geom.LineString([]))):(e[0].getGeometry().setCoordinates([]),e[1].setGeometry(new ol.geom.LineString([])))}getFeature(){return this.getSource().getFeatures()[2]}drawSketch(){this.drawLink();var e=this.getSource().getFeatures();if(this._geom.length)switch(this._lastCoord||(this._lastCoord=this._geom[this._geom.length-1]),e[3].getGeometry().setCoordinates(this._lastCoord),this._type){case"Point":e[2].setGeometry(new ol.geom.Point(this._lastCoord));break;case"Circle":e[2].getGeometry()?e[2].getGeometry().setRadius(ol.coordinate.dist2d(this._geom[0],this._geom[this._geom.length-1])):e[2].setGeometry(new ol.geom.Circle(this._geom[0],ol.coordinate.dist2d(this._geom[0],this._geom[this._geom.length-1])));break;case"LineString":e[2].getGeometry()?e[2].getGeometry().setCoordinates(this._geom):e[2].setGeometry(new ol.geom.LineString(this._geom));break;case"Polygon":this._geom.push(this._geom[0]),e[2].getGeometry()?e[2].getGeometry().setCoordinates([this._geom]):e[2].setGeometry(new ol.geom.Polygon([this._geom])),this._geom.pop();break;default:console.error("[ol/layer/SketchOverlay~drawSketch] geometry type not supported ("+this._type+")")}else e[2].setGeometry(null),e[3].setGeometry(new ol.geom.Point([]))}},ol.PerspectiveMap=class extends ol.Map{constructor(e){var t=e.target instanceof Element?e.target:document.getElementById(e.target);"absolute"!==window.getComputedStyle(t).position&&(t.style.position="relative"),t.style.overflow="hidden";var i=ol.ext.element.create("DIV",{className:"ol-perspective-map",parent:t}),s={};Object.assign(s,e),s.target=i,super(s),this._tiltCondition=e.tiltCondition||ol.events.condition.altKeyOnly}getPixelRatio(){return window.devicePixelRatio}setPerspective(e,t){t=t||{},e>30?e=30:e<0&&(e=0);var i=this._angle||0,s=Math.round(10*e)/10,o=this.getTarget().querySelector(".ol-layers").style;cancelAnimationFrame(this._animatedPerspective),requestAnimationFrame(function(e){this._animatePerpective(e,e,o,i,s,t.duration,t.easing||ol.easing.inAndOut)}.bind(this))}_animatePerpective(e,t,i,s,o,r,a){var n,l,h;0===r?(n=1,l=!0):l=(n=(t-e)/(r||500))>=1,n=a(n);var c=(h=this._angle=l?o:s+(o-s)*n)/30;i.transform="translateY(-"+17*c+"%) perspective(200px) rotateX("+h+"deg) scaleY("+(1-c/2)+")",this.getMatrix3D(!0),this.render(),l||requestAnimationFrame(function(t){this._animatePerpective(e,t,i,s,o,r||500,a||ol.easing.inAndOut)}.bind(this)),this.dispatchEvent({type:"change:perspective",angle:h,animating:!l})}handleMapBrowserEvent(e){if(e.pixel=[e.originalEvent.offsetX/this.getPixelRatio(),e.originalEvent.offsetY/this.getPixelRatio()],e.coordinate=this.getCoordinateFromPixel(e.pixel),ol.Map.prototype.handleMapBrowserEvent.call(this,e),this._tiltCondition(e))switch(e.type){case"pointerdown":this._dragging=e.originalEvent.offsetY;break;case"pointerup":this._dragging=!1;break;case"pointerdrag":if(!1!==this._dragging){var t=e.originalEvent.offsetY>this._dragging?.5:-.5;t&&this.setPerspective((this._angle||0)+t,{duration:0}),this._dragging=e.originalEvent.offsetY}}else this._dragging=!1}getMatrix3D(e){if(e){var t=this.getTarget().querySelector(".ol-layers"),i=ol.matrix3D.getTransform(t),s=ol.matrix3D.getTransformOrigin(t);this._matrixTransform=ol.matrix3D.computeTransformMatrix(i,s)}return this._matrixTransform||(this._matrixTransform=ol.matrix3D.identity()),this._matrixTransform}getPixelScreenFromCoordinate(e){var t=this.getPixelFromCoordinate(e),i=this.getMatrix3D(),s=ol.matrix3D.transformVertex(i,t);return[(s=ol.matrix3D.projectVertex(s))[0],s[1]]}getPixelFromPixelScreen(e){var t=ol.matrix3D.inverse(this.getMatrix3D()),i=ol.matrix3D.transformVertex(t,e);return[(i=ol.matrix3D.projectVertex(i))[0],i[1]]}},function(){var e=ol.Overlay.prototype.updatePixelPosition;ol.Overlay.prototype.updatePixelPosition=function(){var t=this.getMap();if(t&&t instanceof ol.PerspectiveMap){var i=this.getPosition();if(!t||!t.isRendered()||!i)return void this.setVisible(!1);var s=t.getPixelScreenFromCoordinate(i),o=t.getSize();s[0]-=o[0]/4,s[1]-=o[1]/4,this.updateRenderedPosition(s,o)}else e.call(this)}}(),ol.particule.Base=class extends ol.Object{constructor(e){super(e=e||{}),this.setOverlay(e.overlay),this.coordinate=e.coordinate||[0,0]}setOverlay(e){this._overlay=e}getOverlay(){return this._overlay}draw(){}update(){}getRandomCoord(e){return this.getOverlay().randomCoord?this.getOverlay().randomCoord():[e,0]}},ol.particule.Bird=class extends ol.particule.Base{constructor(e){super(e=e||{}),this.bird=new Image,this.bird.addEventListener("load",function(){this.set("size",[this.bird.width||50,this.bird.height||50]),console.log(this.bird.width,this.bird.height)}.bind(this)),this.bird.src=e.src||"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAABDCAQAAAD+S8VaAAAAAnNCSVQICFXsRgQAAAAJcEhZcwAAAvMAAALzAdLpCioAAAAZdEVYdFNvZnR3YXJlAHd3dy5pbmtzY2FwZS5vcmeb7jwaAAAG90lEQVR42uWaaVRTRxTHJ4AUUIoIiqISOArIDiIhBBfccCMoR0vVUpXjTqun4Fr1tO5i3YuodaFqRMECKm4VUHEhUvWgBYuilgpiRVZpCARI3r8fWA4hYY9AXu77+ObNzO/O8u787xDSyeYSTzSICpu+DjV0ogrze84PBneByuJv3JpbBlx6MEBbJfG/8S2RAACFXXtU0gERN1BjCc9UEN/e7I2w1gFPinv3UDkHbFiGOqOwJVjlHMALRT3LLJ7trGIOuHwFUsY7q2IOuJ0u7YB//pswWFn6/vnUcbOCAn7ctfnUrsijl85dv5pw786fd9OTsvg5/JykN3fTb6ZcTDgVvefIkqXmVvKr0NN/IUQDO7C1qwJrOwyftIZ7cmIiN21eZlB+SOUtFKNl9kF0hb9ujmyVM73FMmWv3m+2J4zxw74NDN5/5vT1qzeT7j3n5/Bz7mcmPk24cy32Ai8i9Pj2nwIX+jo4kc8UMMqeXr5bfC6N/2tUHrdsCQ4gAR/QNhNRJ8+6GklXH7xStlxW+ViLxrpjqBswJ/z4rYyCFrQnwJPCxGe/x53i+fO+XOth2xpsvQm+PkfGP3YuYIo1oInTyIJiLDFtoZfUP+AXeaW2rZHXKZ8xJ35NeU+1odVSbIIBbEQeb70Tffd6ckmj0QbDy9/zOufdILE6SN0TBkVafnn0ka/NatrrditDXpmYKw36pREwPyr+Y0V72n0CsxoedTDFrMJJyRMDZJYIx8+yYICQKbDJtcjtL9IGAcEMKN7efIy+snnTYv/tR8Ry3+eWRUYFzavRB9SWL7icXKWAVrPRr96wEqjBTjg5bop03GGi77XF85FdqVZNIQ1konOsEvx35yOCN1xMFimszjNSDqh+ektGfVG3xjyTzaqkX3uDTiaCdh0ZA/qSgWXWWfb7CYMQQsiUUANK1j8hoJf1lSFUg0u+z1xCiFuMUYWsAy7QCj9ZzhIgIDCkpi4nhBCGsafNGx2peXCQRvhlcGrEAQSOhYQQQtyTG74YCglN8CswrVF8goEVhBBCrMzdozi33OOHJmvUvQqghQtKMEUu+GDB0Cj2Q/vsUdJn0JH8+oXG4rWS46djSD0ePcr2lUuafbZlIbN0UAnngpyA0I3FumeZxxQYVlZ/ooWleKm0+FHQbTDuWnAp5F6cbNfskcDtcg9J9aMGNUxDIiglgy+CPxhypj4Ddu/cfFpxOrIqrv7QAsH4V2nwYxoEvwQEOpRlAeeG07hWnopH7FMHgTr6VmhAA1xEQNjF4bMxQwpcj2I9duVZLiVtTb7YT7T2I30JccyqrrA7ZuESRF0SvhQ/QKfByDu/VZAs5O6rXS9U6onZ+A2CLgQvwWn0l5n4TAFnjOKksR5En6i73q6/q3IRhvwugB8LBylwi6IhixxX9Wd/CoWQwTrJTuaEOSwzENcKDR7Yj4xOg4+Hq3SEXzX8fIfcObAZPizV+bGxqLZhMyxBWgdP+xi4ScGbCNnhhrodqxnrso65pLidNxMQENihqoPgS3AY5rU7krh35eCPbon2c4hap2nnxob2GQQE+zpAM4qFb53EoUWxE3t93jXyBwyXcG1KD+8/IXwBAmFYg26Vx37oHjnIlnQlGzbJvMCX+lQrPgT6dat9yAcT/S6aSOIs2rjjxLaQ9SsX83gv8uShiNuAn4mR9fZ5dizpphRpREvj1YvOhiU84OdmoghFyKH47y/GHohtLf45ITvVuLyfyKLI5RlntyJSXx2+P+gaejt5O7FNCSEkcFHTuAmPom6/qqxJqFRee33wHGc6rVLjXtym8C8nTTcnDNMh/n5BfnN8mFY18jWdbPlceeBViEsPi16xxFSL7ncjukVelTvxUzsxjOlAUzsULv8/GfdEJa7G7D7YWLCcUzbNkfb42zaXNaG2h4XTHH/n9x+bjIHKqeAdNMZf55fbrKBYLNq+lqb433lkFrUk5hNKdu6mIf5XA1KetzibR+09TLcfonrMtVYlNKk9h2gV//FCW3tCFmMXT0nOe83bxpklbdDJqrD+BC1mwUzTtOw2Sl/UFjpsh8ci2pHirFgxV8nxV/oJxO2RwR6+HNFbmfkZ15PaqwQe/VmJ+R18Aql37XTAsQ9EefUBW6NeEk34IaWN8HkIQk+Jva0SzwGXP6p1XDeEoqB1qx/L0B3dKY+VSr0JDurDFNaK2ZoYg5142sx1m3LEYxUsq+Vv8ejVSv8bdJ/UXySds9eDB4JwEnFIRS6KUIi/8RJxCEEARte74GBR6DycFpGgtZNFPkHrHgOx61miSaPDEOtEn8qWwvepZMc5Mel3ItZmHbbM12wSXV/snMHZQ6eRlzEzI9d9rnftskwERhXVNxF7ik1Krd87pbLCbWYR9Y7v0f/htaJHbsoDhwAAAABJRU5ErkJggg==",this.set("size",[this.bird.width||50,this.bird.height||50])}draw(e){var t=this.getOverlay().get("angle");e.save(),e.translate(this.coordinate[0],this.coordinate[1]),e.rotate(t+Math.PI/2),e.scale(.5,.5),e.drawImage(this.bird,-this.bird.width/2,-this.bird.height/2),e.restore()}update(e){var t=this.getOverlay().get("speed")*e/this.getOverlay()._fps,i=this.getOverlay().get("angle");this.coordinate[0]+=t*Math.cos(i),this.coordinate[1]+=t*Math.sin(i)}},ol.particule.Cloud=class extends ol.particule.Base{constructor(e){super(e=e||{}),this.set("size",[100,100]);var t=document.createElement("CANVAS");t.width=200,t.height=200;var i=t.getContext("2d"),s=this.gradient=i.createRadialGradient(50,50,0,50,50,50);s.addColorStop(0,"rgba(255,255,255,.2"),s.addColorStop(1,"rgba(255,255,255,0"),this.image=t;for(var o=0;o<7;o++){i.save();var r=100*Math.random(),a=100*Math.random();i.translate(r,a),i.fillStyle=s,i.fillRect(0,0,t.width,t.height),i.restore()}}draw(e){e.save(),e.translate(this.coordinate[0],this.coordinate[1]),e.drawImage(this.image,-this.image.width/2,-this.image.width/2),e.restore()}update(e){var t=this.getOverlay().get("speed")*e/this.getOverlay()._fps,i=this.getOverlay().get("angle");this.coordinate[0]+=t*Math.cos(i),this.coordinate[1]+=t*Math.sin(i)}},ol.particule.Rain=class extends ol.particule.Base{constructor(e){super(e=e||{}),this.z=Math.floor(5*Math.random())+1;var t=document.createElement("CANVAS");t.width=50,t.height=50;var i=t.getContext("2d");this.gradient=i.createRadialGradient(0,0,0,0,0,25),this.gradient.addColorStop(0,"rgba(0,0,80,0)"),this.gradient.addColorStop(1,"rgba(0,0,80,.3)")}draw(e){e.save();var t=this.getOverlay().get("angle");e.beginPath();var i=10*Math.cos(t)*(1+this.z/2),s=10*Math.sin(t)*(1+this.z/2);e.lineWidth=Math.round(this.z/2),e.strokeStyle=this.gradient,e.translate(this.coordinate[0],this.coordinate[1]),e.moveTo(0,0),e.lineTo(i,s),e.stroke(),e.restore()}update(e){var t=this.getOverlay().get("speed")*e/this.getOverlay()._fps*this.z,i=this.getOverlay().get("angle");this.coordinate[0]+=t*Math.cos(i),this.coordinate[1]+=t*Math.sin(i)}},ol.particule.RainDrop=class extends ol.particule.Base{constructor(e){super(e=e||{}),this.size=0;var t=document.createElement("CANVAS");t.width=100,t.height=100;var i=t.getContext("2d"),s=i.createRadialGradient(50,50,0,50,50,50);s.addColorStop(0,"rgba(128,128,192,.8"),s.addColorStop(1,"rgba(128,128,192,0"),this.image=t,i.fillStyle=s,i.fillRect(0,0,t.width,t.height)}draw(e){this.size>0&&(e.save(),e.translate(this.coordinate[0],this.coordinate[1]),e.globalAlpha=this.size/50,e.scale(1-this.size/50,1-this.size/50),e.drawImage(this.image,-50,-50),e.restore())}update(e){(this.size>0||Math.random()<.01)&&(this.size<=0&&(this.size=50,this.coordinates=this.getRandomCoord()),this.size=this.size-Math.round(e/20))}},ol.particule.Snow=class extends ol.particule.Base{constructor(e){super(e=e||{}),this.z=(Math.floor(5*Math.random())+1)/5,this.angle=Math.random()*Math.PI;var t=document.createElement("CANVAS");t.width=20,t.height=20;var i=t.getContext("2d"),s=i.createRadialGradient(10,10,0,10,10,10);s.addColorStop(0,"rgba(255, 255, 255,1)"),s.addColorStop(.8,"rgba(210, 236, 242,.8)"),s.addColorStop(1,"rgba(237, 247, 249,0)"),this.image=t,i.fillStyle=s,i.fillRect(0,0,t.width,t.height)}draw(e){e.save(),e.translate(this.coordinate[0],this.coordinate[1]),e.globalAlpha=.4+this.z/2,e.scale(this.z,this.z),e.drawImage(this.image,-10,-10),e.restore()}update(e){var t=this.getOverlay().get("speed")*e/this.getOverlay()._fps*this.z*5,i=this.getOverlay().get("angle");this.angle=this.angle+e/this.getOverlay()._fps/100,this.coordinate[0]+=2*Math.sin(this.angle+this.z)+t*Math.cos(i),this.coordinate[1]+=Math.cos(this.angle)+t*Math.sin(i)}},ol.Overlay.Popup=class extends ol.Overlay{constructor(e){e=e||{};var t=document.createElement("div");e.element=t,super(e),"number"==typeof e.offsetBox?this.offsetBox=[e.offsetBox,e.offsetBox,e.offsetBox,e.offsetBox]:this.offsetBox=e.offsetBox,this.closeBox=e.closeBox,this.onclose=e.onclose,this.onshow=e.onshow,ol.ext.element.create("BUTTON",{className:"closeBox"+(e.closeBox?" hasclosebox":""),type:"button",click:function(){this.hide()}.bind(this),parent:t}),!1!==e.anchor&&ol.ext.element.create("DIV",{className:"anchor",parent:t}),this.content=ol.ext.element.create("DIV",{html:e.html||"",className:"ol-popup-content",parent:t}),e.minibar&&ol.ext.element.scrollDiv(this.content,{vertical:!0,mousewheel:!0,minibar:!0}),e.stopEvent&&(t.addEventListener("mousedown",function(e){e.stopPropagation()}),t.addEventListener("touchstart",function(e){e.stopPropagation()})),this._elt=t,this.setPositioning(e.positioning||"auto"),this.setPopupClass(e.popupClass||e.className||"default"),e.anim&&this.addPopupClass("anim"),e.position&&setTimeout(function(){this.show(e.position)}.bind(this))}getClassPositioning(){var e="",t=this.getPositioning();return/bottom/.test(t)&&(e+="ol-popup-bottom "),/top/.test(t)&&(e+="ol-popup-top "),/left/.test(t)&&(e+="ol-popup-left "),/right/.test(t)&&(e+="ol-popup-right "),/^center/.test(t)&&(e+="ol-popup-middle "),/center$/.test(t)&&(e+="ol-popup-center "),e}setClosebox(e){this.closeBox=e,e?this.element.classList.add("hasclosebox"):this.element.classList.remove("hasclosebox")}setPopupClass(e){var t=["ol-popup"];this.getVisible()&&t.push("visible"),this.element.className="";var i=this.getClassPositioning().split(" ").filter(function(e){return e.length>0});e?e.split(" ").filter(function(e){return e.length>0}).forEach(function(e){t.push(e)}):t.push("default"),i.forEach(function(e){t.push(e)}),this.closeBox&&t.push("hasclosebox"),this.element.classList.add.apply(this.element.classList,t)}addPopupClass(e){this.element.classList.add(e)}removePopupClass(e){this.element.classList.remove(e)}setPositioning(e){void 0!==e&&(/auto/.test(e)?(this.autoPositioning=e.split("-"),1==this.autoPositioning.length&&(this.autoPositioning[1]="auto")):this.autoPositioning=!1,"center"==(e=e.replace(/auto/g,"center"))&&(e="bottom-center"),this.setPositioning_(e))}setPositioning_(e){if(this.element){super.setPositioning(e),this.element.classList.remove("ol-popup-top","ol-popup-bottom","ol-popup-left","ol-popup-right","ol-popup-center","ol-popup-middle");var t=this.getClassPositioning().split(" ").filter(function(e){return e.length>0});this.element.classList.add.apply(this.element.classList,t)}}getVisible(){return this.element.classList.contains("visible")}show(e,t){t||"string"!=typeof e||(t=e,e=null),!0===e&&(e=this.getPosition());var i=this,s=this.getMap();if(s&&(t&&t!==this.prevHTML&&(this.prevHTML=t,this.content.innerHTML="",t instanceof Element?this.content.appendChild(t):ol.ext.element.create("DIV",{html:t,parent:this.content}),Array.prototype.slice.call(this.content.querySelectorAll("img")).forEach(function(e){e.addEventListener("load",function(){try{s.renderSync()}catch(e){}i.content.dispatchEvent(new Event("scroll"))})})),e)){if(this.autoPositioning){var o=s.getPixelFromCoordinate(e),r=s.getSize(),a=[];"auto"==this.autoPositioning[0]?a[0]=o[1]<r[1]/3?"top":"bottom":a[0]=this.autoPositioning[0],a[1]=o[0]<2*r[0]/3?"left":"right",this.setPositioning_(a[0]+"-"+a[1]),this.offsetBox&&this.setOffset([this.offsetBox["left"==a[1]?2:0],this.offsetBox["top"==a[0]?3:1]])}else this.offsetBox&&this.setOffset(this.offsetBox);this.setPosition(e),this.element.parentElement.style.display="","function"==typeof this.onshow&&this.onshow(),this.dispatchEvent({type:"show"}),this._tout=setTimeout(function(){i.element.classList.add("visible")},0)}}hide(){null!=this.getPosition()&&("function"==typeof this.onclose&&this.onclose(),this.setPosition(void 0),this._tout&&clearTimeout(this._tout),this.element.classList.remove("visible"),this.dispatchEvent({type:"hide"}))}},ol.Overlay.AnimatedCanvas=class extends ol.Overlay{constructor(e){e=e||{};var t=ol.ext.element.create("CANVAS",{className:((e.className||"")+" ol-animated-overlay").trim()});super({element:t,stopEvent:!1}),this._canvas=t,this._ctx=this._canvas.getContext("2d"),this._listener=[],this._time=0,this._particuleClass=e.particule||ol.particule.Base,e.createParticule&&(this._createParticule=e.createParticule),this._fps=1e3/(e.fps||25);var i=this._createParticule();this._psize=i.get("size")||[50,50],this.set("density",e.density||.5),this.set("speed",e.speed||4),this.set("angle","number"==typeof e.angle?e.angle:Math.PI/4),!1!==e.animate&&this.setAnimation(!0),document.addEventListener("visibilitychange",function(){this._pause=!0}.bind(this))}setVisible(e){this.element.style.display=e?"block":"none",e&&this.setAnimation(this.get("animation"))}getVisible(){return"none"!=this.element.style.display}updatePixelPosition(){}setMap(e){if(this._listener.forEach(function(e){ol.Observable.unByKey(e)}),this._listener=[],super.setMap(e),e){var t=e.getSize();this._canvas.width=t[0],this._canvas.height=t[1],this.draw(),this._listener.push(e.on("change:size",function(){var t=e.getSize();this._canvas.width===t[0]&&this._canvas.height===t[1]||(this._canvas.width=t[0],this._canvas.height=t[1],this.draw())}.bind(this)))}this.setAnimation(!!e)}getParticules(){var e=this._psize[0],t=this._psize[1],i=this.get("density")*this._canvas.width*this._canvas.height/e/t<<0;if(this._particules||(this._particules=[]),i>this._particules.length)for(var s=this._particules.length;s<i;s++)this._particules.push(this._createParticule(this,this.randomCoord()));else this._particules.length=i;return this._particules}_createParticule(e,t){return new this._particuleClass({overlay:e,coordinate:t})}randomCoord(){return[Math.random()*(this._canvas.width+this._psize[0])-this._psize[0]/2,Math.random()*(this._canvas.height+this._psize[1])-this._psize[1]/2]}draw(e){var t=this._ctx;this.clear(),t.beginPath(),this.getParticules().forEach(function(t){e&&(t.update(e),this.testExit(t)),t.draw(this._ctx)}.bind(this))}testExit(e){var t=this._psize;e.coordinate[0]<-t[0]?(e.coordinate[0]=this._canvas.width+t[0],e.coordinate[1]=Math.random()*(this._canvas.height+t[1])-t[1]/2):e.coordinate[0]>this._canvas.width+t[0]?(e.coordinate[0]=-t[0],e.coordinate[1]=Math.random()*(this._canvas.height+t[1])-t[1]/2):e.coordinate[1]<-t[1]?(e.coordinate[0]=Math.random()*(this._canvas.width+t[0])-t[0]/2,e.coordinate[1]=this._canvas.height+t[1]):e.coordinate[1]>this._canvas.height+t[1]&&(e.coordinate[0]=Math.random()*(this._canvas.width+t[0])-t[0]/2,e.coordinate[1]=-t[1])}clear(){this._ctx.clearRect(0,0,this._canvas.width,this._canvas.height)}getCanvas(){return this._canvas}setAnimation(e){e=!1!==e,this.set("animation",e),e?(this._pause=!0,requestAnimationFrame(this._animate.bind(this))):this.dispatchEvent({type:"animation:stop",time:this._time})}_animate(e){this.getVisible()&&this.get("animation")&&(this._pause?requestAnimationFrame(function(e){this._time=e,requestAnimationFrame(this._animate.bind(this))}.bind(this)):(e-this._time>this._fps&&(this.draw(e-this._time),this._time=e),requestAnimationFrame(this._animate.bind(this)))),this._pause=!1}},ol.Overlay.Fixed=class extends ol.Overlay{constructor(e){super(e)}setPosition(e,t){this.getMap()&&e&&(this._pixel=this.getMap().getPixelFromCoordinate(e)),super.setPosition(e),t&&super.updatePixelPosition()}updatePixelPosition(){if(this.getMap()&&this._pixel&&this.getPosition()){var e=this.getMap().getPixelFromCoordinate(this.getPosition());Math.round(1e3*e[0])===Math.round(1e3*this._pixel[0])&&Math.round(1e3*e[0])===Math.round(1e3*this._pixel[0])||this.setPosition(this.getMap().getCoordinateFromPixel(this._pixel))}}},ol.Overlay.FixedPopup=class extends ol.Overlay.Popup{constructor(e){e.anchor=!1,e.positioning=e.positioning||"center-center",e.className=(e.className||"")+" ol-fixPopup",super(e),this.set("minScale",e.minScale||.5),this.set("maxScale",e.maxScale||2),this.set("hook",e.hook||"viewport");var t=document.createElement("canvas");this._coord=void 0,this._overlay=new ol.layer.Image({source:new ol.source.ImageCanvas({canvasFunction:function(e,i,s,o){return t.width=o[0],t.height=o[1],t}})}),this._style=e.style||new ol.style.Style({fill:new ol.style.Fill({color:[102,153,255]})}),this._overlay.on(["postcompose","postrender"],function(e){if(this.getVisible()&&this._pixel){var t=this.getMap(),i=this.getPosition(),s=t.getPixelFromCoordinate(i),o=this.element.getBoundingClientRect(),r=this.getMap().getTargetElement().getBoundingClientRect(),a=[o.left-r.left+o.width/2,o.top-r.top+o.height/2];e.context.save();var n=e.inversePixelTransform;n?e.context.transform(n[0],n[1],n[2],n[3],n[4],n[5]):e.context.scale(e.frameState.pixelRatio,e.frameState.pixelRatio),e.context.beginPath(),e.context.moveTo(s[0],s[1]),Math.abs(a[0]-s[0])>Math.abs(a[1]-s[1])?(e.context.lineTo(a[0],a[1]-8),e.context.lineTo(a[0],a[1]+8)):(e.context.lineTo(a[0]-8,a[1]),e.context.lineTo(a[0]+8,a[1])),e.context.moveTo(s[0],s[1]),this._style.getFill()&&(e.context.fillStyle=ol.color.asString(this._style.getFill().getColor()),e.context.fill()),this._style.getStroke()&&(e.context.strokeStyle=ol.color.asString(this._style.getStroke().getColor()),e.context.lineWidth=this._style.getStroke().getWidth(),e.context.stroke()),e.context.restore()}}.bind(this));var i=function(){this.setPixelPosition()}.bind(this);function s(e){var t=0,i=0,s=0;for(var o in e)t+=e[o].clientX,i+=e[o].clientY,s++;return[t/s,i/s]}function o(e){var t=Object.keys(e);return!(t.length<2)&&ol.coordinate.dist2d([e[t[0]].clientX,e[t[0]].clientY],[e[t[1]].clientX,e[t[1]].clientY])}this.on(["hide","show"],function(){setTimeout(i)}.bind(this));var r,a,n,l,h={},c={},u=[];this.element.addEventListener("pointerdown",function(e){for(var t in e.preventDefault(),e.stopPropagation(),h)c[t]&&(h[t]=c[t]);h[e.pointerId]=e,u=this._pixel||this.getMap().getPixelFromCoordinate(this.getPosition()),a=this.get("rotation")||0,n=this.get("scale")||1,r=o(h),l=!1}.bind(this)),this.element.addEventListener("click",function(e){l&&(e.preventDefault(),e.stopPropagation())},!0);var d=function(e){h[e.pointerId]&&(delete h[e.pointerId],e.preventDefault()),c[e.pointerId]&&delete c[e.pointerId]}.bind(this);document.addEventListener("pointerup",d),document.addEventListener("pointercancel",d),document.addEventListener("pointermove",function(e){if(h[e.pointerId]){e.preventDefault(),c[e.pointerId]=e;var t=s(h),i=s(c),d=i[0]-t[0],p=i[1]-t[1];l=l||Math.abs(d)>3||Math.abs(p)>3;var g=function(){var e,t,i=Object.keys(h);if(i.length<2)return!1;e=h[i[0]];var s=[(t=h[i[1]]).clientX-e.clientX,t.clientY-e.clientY];e=c[i[0]];var o=[(t=c[i[1]]).clientX-e.clientX,t.clientY-e.clientY],r=Math.sqrt(s[0]*s[0]+s[1]*s[1]),a=Math.sqrt(o[0]*o[0]+o[1]*o[1]),n=360*Math.acos((s[0]*o[0]+s[1]*o[1])/(r*a))/Math.PI;return s[0]*o[1]-s[1]*o[0]<0?-n:n}();g&&this.setRotation(a+1.5*g,!1);var m=o(c);!1!==m&&r&&(this.setScale(n*m/r,!1),r=n*m/this.get("scale")),this.setPixelPosition([u[0]+d,u[1]+p])}}.bind(this))}setMap(e){super.setMap(e),this._overlay.setMap(this.getMap()),this._listener&&ol.Observable.unByKey(this._listener),e&&(this._listener=e.on("change:size",function(){this.setPixelPosition()}.bind(this)))}updatePixelPosition(){var e=this.getMap(),t=this.getPosition();if(e&&e.isRendered()&&t){var i,s=e.getSize();this._pixel||(i=e.getPixelFromCoordinate(this.getPosition()),this.updateRenderedPosition(i,s),this._coord=e.getCoordinateFromPixel(i),this._pixel=i),this._pixel&&"map"===this.get("hook")&&(i=e.getPixelFromCoordinate(this._coord),super.updateRenderedPosition(i,s),this._pixel=i)}else this.setVisible(!1)}updateRenderedPosition(e,t){super.updateRenderedPosition(e,t),this.setRotation(),this.setScale()}setPixelPosition(e,t){var i,s=this.getMap(),o=s?s.getSize():[0,0];if(t&&(this.setPositioning(t),(i=ol.ext.element.offsetRect(this.element)).width=i.height=0,/top/.test(t)?e[1]+=i.height/2:/bottom/.test(t)?e[1]=o[1]-i.height/2-e[1]:e[1]=o[1]/2+e[1],/left/.test(t)?e[0]+=i.width/2:/right/.test(t)?e[0]=o[0]-i.width/2-e[0]:e[0]=o[0]/2+e[0]),e&&(this._pixel=e,this._coord=s.getCoordinateFromPixel(e)),s&&s.getTargetElement()&&this._pixel){this.updateRenderedPosition(this._pixel,o);var r=!1;i=ol.ext.element.offsetRect(this.element);var a=ol.ext.element.offsetRect(s.getTargetElement());i.left<a.left?(this._pixel[0]=this._pixel[0]+a.left-i.left,r=!0):i.left+i.width>a.left+a.width&&(this._pixel[0]=this._pixel[0]+a.left-i.left+a.width-i.width,r=!0),i.top<a.top?(this._pixel[1]=this._pixel[1]+a.top-i.top,r=!0):i.top+i.height>a.top+a.height&&(this._pixel[1]=this._pixel[1]+a.top-i.top+a.height-i.height,r=!0),r&&"map"!==this.get("hook")&&this.updateRenderedPosition(this._pixel,o),this._overlay.changed()}}getPixelPosition(){return this._pixel}getCoordinate(){return this._coord}setCoordinate(e){this._coord=e,this.setPixelPosition()}setHook(e){this.set("hook",e||"viewport"),this._coord="map"===this.get("hook")?this.getMap().getCoordinateFromPixel(this._pixel):null,this.setPixelPosition()}setPopupClass(e){super.setPopupClass(e),this.addPopupClass("ol-fixPopup")}setRotation(e,t){"number"==typeof e&&this.set("rotation",e),!1!==t&&(/rotate/.test(this.element.style.transform)?this.element.style.transform=this.element.style.transform.replace(/rotate\((-?[\d,.]+)deg\)/,"rotate("+(this.get("rotation")||0)+"deg)"):this.element.style.transform=this.element.style.transform+" rotate("+(this.get("rotation")||0)+"deg)")}setScale(e,t){"number"==typeof e&&this.set("scale",e),e=Math.min(Math.max(this.get("minScale")||0,this.get("scale")||1),this.get("maxScale")||2),this.set("scale",e),!1!==t&&(/scale/.test(this.element.style.transform)?this.element.style.transform=this.element.style.transform.replace(/scale\(([\d,.]+)\)/,"scale("+e+")"):this.element.style.transform=this.element.style.transform+" scale("+e+")")}setLinkStyle(e){this._style=e,this._overlay.changed()}getLinkStyle(){return this._style}},ol.Overlay.Magnify=class extends ol.Overlay{constructor(e){var t=document.createElement("div");t.className="ol-magnify",super({positioning:e.positioning||"center-center",element:t,stopEvent:!1}),this._elt=t,this.mgmap_=new ol.Map({controls:new ol.Collection,interactions:new ol.Collection,target:e.target||this._elt,view:new ol.View({projection:e.projection}),layers:e.layers}),this.mgview_=this.mgmap_.getView(),this.external_=!!e.target,this.set("zoomOffset",e.zoomOffset||1),this.set("active",!0),this.on("propertychange",this.setView_.bind(this))}setMap(e){this.getMap()&&this.getMap().getViewport().removeEventListener("mousemove",this.onMouseMove_),this._listener&&ol.Observable.unByKey(this._listener),this._listener=null,super.setMap(e),e.getViewport().addEventListener("mousemove",this.onMouseMove_.bind(this)),this._listener=e.getView().on("propertychange",this.setView_.bind(this)),this.refresh()}getMagMap(){return this.mgmap_}getActive(){return this.get("active")}setActive(e){return this.set("active",e),this.refresh(),this.getActive()}onMouseMove_(e){if(this.get("active")){var t=this.getPosition(),i=this.getMap().getEventCoordinate(e);this.external_||this.setPosition(i),this.mgview_.setCenter(i),this.external_||t||this.refresh()}else this.setPosition()}refresh(){this.mgmap_.updateSize(),this.setView_()}setView_(e){if(this.getMap())if(this.get("active")){if(!e)return this.setView_({key:"rotation"}),void this.setView_({key:"resolution"});switch(e.key){case"rotation":this.mgview_.setRotation(this.getMap().getView().getRotation());break;case"zoomOffset":case"resolution":var t=Math.max(0,this.getMap().getView().getZoom()+Number(this.get("zoomOffset")));this.mgview_.setZoom(t)}}else this.setPosition()}},ol.Overlay.Placemark=class extends ol.Overlay.Popup{constructor(e){(e=e||{}).popupClass=(e.popupClass||"")+" placemark anim",e.positioning="bottom-center",super(e),this.setPositioning=function(){},e.color&&(this.element.style.color=e.color),e.backgroundColor&&(this.element.style.backgroundColor=e.backgroundColor),e.contentColor&&this.setContentColor(e.contentColor),e.size&&this.setRadius(e.size)}show(e,t){!0===e&&(e=this.getPosition()),this.hide(),super.show(e,t)}setColor(e){this.element.style.color=e}setBackgroundColor(e){this._elt.style.backgroundColor=e}setContentColor(e){var t=this.element.getElementsByClassName("ol-popup-content")[0];t&&(t.style.color=e)}setClassName(e){var t=this.element.className;this.element.className="ol-popup placemark ol-popup-bottom ol-popup-center "+(/visible/.test(t)?"visible ":"")+(/anim/.test(t)?"anim ":"")+e}setRadius(e){this.element.style.fontSize=e+"px"}},ol.Overlay.PopupFeature=class extends ol.Overlay.Popup{constructor(e){super(e=e||{}),this.setTemplate(e.template),this.set("canFix",e.canFix),this.set("showImage",e.showImage),this.set("maxChar",e.maxChar||200),this.set("keepSelection",e.keepSelection),e.select&&"function"==typeof e.select.on&&(this._select=e.select,e.select.on("select",function(t){this._noselect||(t.selected[0]?this.show(t.mapBrowserEvent.coordinate,e.select.getFeatures().getArray(),t.selected[0]):this.hide())}.bind(this)))}setTemplate(e){e||(e=function(e){var t=e.getProperties();return delete t[e.getGeometryName()],{attributes:Object.keys(t)}}),this._template=e,this._attributeObject(this._template)}_attributeObject(e){if(e&&e.attributes instanceof Array){var t={};e.attributes.forEach(function(e){t[e]=!0}),e.attributes=t}return e.attributes}show(e,t,i){(e instanceof ol.Feature||e instanceof Array&&e[0]instanceof ol.Feature)&&(t=e,e=null),t instanceof Array||(t=[t]),this._features=t.slice(),this._count||(this._count=1),this._count=1;var s=this.get("keepSelection")&&i||t[0],o=this._getHtml(s);o?(this.element.classList.contains("ol-fixed")||this.hide(),e&&"Point"!==t[0].getGeometry().getType()||(e=t[0].getGeometry().getFirstCoordinate()),super.show(e,o)):this.hide()}_getHtml(e){if(!e)return"";var t=ol.ext.element.create("DIV",{className:"ol-popupfeature"});this.get("canFix")&&ol.ext.element.create("I",{className:"ol-fix",parent:t}).addEventListener("click",function(){this.element.classList.toggle("ol-fixed")}.bind(this));var i,s=this._template;if("function"==typeof s)s=s(e,this._count,this._features.length);else if(!s||!s.attributes)for(var o in(s=s||{}).attributes={},e.getProperties())"geometry"!=o&&(s.attributes[o]=o);s.title&&(i="function"==typeof s.title?s.title(e):e.get(s.title),ol.ext.element.create("H1",{html:i,parent:t}));if(s.attributes){var r,a=ol.ext.element.create("TABLE",{parent:t}),n=this._attributeObject(s),l=e.getProperties();Object.keys(n).forEach(function(t){if(l.hasOwnProperty(t)){var i,s=n[t],o=l[t];s&&"function"==typeof s.format&&(o=s.format(o,e));var h=!0;if(s&&"boolean"==typeof s.visible?h=s.visible:s&&"function"==typeof s.visible&&(h=s.visible(e,o)),h){if(r=ol.ext.element.create("TR",{click:function(i){this.dispatchEvent({type:"attribute",feature:e,attribute:t,originalEvent:i})}.bind(this),parent:a}),ol.ext.element.create("TD",{className:"ol-label",html:s&&s.title||t,parent:r}),this.get("showImage")&&/(http(s?):)([/|.|\w|\s|-])*\.(?:jpg|gif|png)/.test(o))i=ol.ext.element.create("IMG",{src:o});else{i=s?(s.before||"")+o+(s.after||""):"";var c=this.get("maxChar")||200;"string"==typeof i&&i.length>c&&(i=i.substr(0,c)+"[...]")}ol.ext.element.create("TD",{className:"ol-value",html:i,parent:r})}}}.bind(this))}if(ol.ext.element.create("BUTTON",{className:"ol-zoombt",parent:t}).addEventListener("click",function(){if("Point"===e.getGeometry().getType())this.getMap().getView().animate({center:e.getGeometry().getFirstCoordinate(),zoom:Math.max(this.getMap().getView().getZoom(),18)});else{var t=e.getGeometry().getExtent();this.getMap().getView().fit(t,{duration:1e3})}}.bind(this)),!this.get("keepSelection")&&this._features.length>1){var h=ol.ext.element.create("DIV",{className:"ol-count",parent:t});ol.ext.element.create("DIV",{className:"ol-prev",parent:h,click:function(){this._count--,this._count<1&&(this._count=this._features.length),t=this._getHtml(this._features[this._count-1]),setTimeout(function(){ol.Overlay.Popup.prototype.show.call(this,this.getPosition(),t)}.bind(this),350)}.bind(this)}),ol.ext.element.create("TEXT",{html:this._count+"/"+this._features.length,parent:h}),ol.ext.element.create("DIV",{className:"ol-next",parent:h,click:function(){this._count++,this._count>this._features.length&&(this._count=1),t=this._getHtml(this._features[this._count-1]),setTimeout(function(){ol.Overlay.Popup.prototype.show.call(this,this.getPosition(),t)}.bind(this),350)}.bind(this)})}return this._select&&!this.get("keepSelection")&&(this._noselect=!0,this._select.getFeatures().clear(),this._select.getFeatures().push(e),this._noselect=!1),this.dispatchEvent({type:"select",feature:e,index:this._count}),t}setFix(e){e?this.element.classList.add("ol-fixed"):this.element.classList.remove("ol-fixed")}getFix(){return this.element.classList.contains("ol-fixed")}},ol.Overlay.PopupFeature.localString=function(e,t){return function(i){if(i&&i.toLocaleString)return i.toLocaleString(e,t);var s=new Date(i);return isNaN(s)?i:s.toLocaleString(e,t)}},ol.Overlay.Tooltip=class extends ol.Overlay.Popup{constructor(e){(e=e||{}).popupClass=e.popupClass||e.className||"tooltips black",e.positioning=e.positioning||"center-left",e.stopEvent=!!e.stopEvent,super(e),this.set("maximumFractionDigits",e.maximumFractionDigits||2),"function"==typeof e.formatLength&&(this.formatLength=e.formatLength),"function"==typeof e.formatArea&&(this.formatArea=e.formatArea),"function"==typeof e.getHTML&&(this.getHTML=e.getHTML),this._interaction=new ol.interaction.Interaction({handleEvent:function(e){if("pointermove"===e.type||"click"===e.type){var t=this.getHTML(this._feature,this.get("info"));t?this.show(e.coordinate,t):this.hide(),this._coord=e.coordinate}return!0}.bind(this)})}setMap(e){this.getMap()&&this.getMap().removeInteraction(this._interaction),super.setMap(e),this.getMap()&&this.getMap().addInteraction(this._interaction)}getHTML(e,t){return this.get("measure")?this.get("measure")+(t?"<br/>"+t:""):t||""}setInfo(e){e?setTimeout(function(){this.set("info",e),this.show(this._coord,this.get("info"))}.bind(this)):(this.set("info",""),this.hide())}removeFeature(){this.setFeature()}formatArea(e){return e>Math.pow(10,-1*this.get("maximumFractionDigits"))?e>1e4?(e/1e6).toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits)")})+" km²":e.toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits")})+" m²":""}formatLength(e){return e>Math.pow(10,-1*this.get("maximumFractionDigits"))?e>100?(e/1e3).toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits")})+" km":e.toLocaleString(void 0,{maximumFractionDigits:this.get("maximumFractionDigits")})+" m":""}setFeature(e){e&&e.feature&&(e=e.feature),this._feature=e,this._listener&&this._listener.forEach(function(e){ol.Observable.unByKey(e)}),this._listener=[],this.set("measure",""),e&&this._listener.push(e.getGeometry().on("change",function(e){var t,i=e.target;i.getArea?t=this.formatArea(ol.sphere.getArea(i,{projection:this.getMap().getView().getProjection()})):i.getLength&&(t=this.formatLength(ol.sphere.getLength(i,{projection:this.getMap().getView().getProjection()}))),this.set("measure",t)}.bind(this)))}},ol.coordinate.convexHull,function(){var e=function(e,t,i){return(e[0]-i[0])*(t[1]-i[1])-(e[1]-i[1])*(t[0]-i[0])<=0};ol.coordinate.convexHull=function(t){var i;t.sort(function(e,t){return e[0]==t[0]?e[1]-t[1]:e[0]-t[0]});var s=[];for(i=0;i<t.length;i++){for(;s.length>=2&&e(s[s.length-2],s[s.length-1],t[i]);)s.pop();s.push(t[i])}var o=[];for(i=t.length-1;i>=0;i--){for(;o.length>=2&&e(o[o.length-2],o[o.length-1],t[i]);)o.pop();o.push(t[i])}return o.pop(),s.pop(),s.concat(o)};var t=function(e){var i,s,o=[];switch(e.getType()){case"Point":o.push(e.getCoordinates());break;case"LineString":case"LinearRing":case"MultiPoint":o=e.getCoordinates();break;case"MultiLineString":for(s=e.getLineStrings(),i=0;i<s.length;i++)o.concat(t(s[i]));break;case"Polygon":o=t(e.getLinearRing(0));break;case"MultiPolygon":for(s=e.getPolygons(),i=0;i<s.length;i++)o.concat(t(s[i]));break;case"GeometryCollection":for(s=e.getGeometries(),i=0;i<s.length;i++)o.concat(t(s[i]))}return o};ol.geom.Geometry.prototype.convexHull=function(){return ol.coordinate.convexHull(t(this))}}(),ol.coordinate.toDFCI=function(e,t,i){t||0===t||(t=3),i&&(ol.proj.get("EPSG:27572")||(proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)),e=ol.proj.transform(e,i,"EPSG:27572"));var s=e[0],o=e[1],r="";if(r+=String.fromCharCode(65+Math.floor((s<8e5?s:s+2e5)/1e5))+String.fromCharCode(65+Math.floor((o<23e5?o:o+2e5)/1e5)-15),0===t)return r;if(r+=2*Math.floor(s%1e5/2e4),r+=2*Math.floor(o%1e5/2e4),1===t)return r;var a=Math.floor(s%2e4/2e3);if(r+=String.fromCharCode(65+(a<8?a:a+2)),r+=Math.floor(o%2e4/2e3),2===t)return r;var n=Math.floor(s%2e3/500),l=Math.floor(o%2e3/500);return r+=n<1?l>1?".1":".4":n>2?l>1?".2":".3":l>2?n<2?".1":".2":l<1?n<2?".4":".3":".5"},ol.coordinate.fromDFCI=function(e,t){var i,s=1e5,o=e.charCodeAt(0)-65;o=(o<8?o:o-2)*s;var r=e.charCodeAt(1)-65;if(r=(r<8?r:r-2)*s+15e5,2===e.length)i=[o+s/2,r+s/2];else if(s/=5,o+=Number(e.charAt(2))/2*s,r+=Number(e.charAt(3))/2*s,4===e.length)i=[o+s/2,r+s/2];else{s/=10;var a=e.charCodeAt(4)-65;if(o+=(a<8?a:a-2)*s,r+=Number(e.charAt(5))*s,6===e.length)i=[o+s/2,r+s/2];else switch(e.charAt(7)){case"1":i=[o+s/4,r+3*s/4];break;case"2":i=[o+3*s/4,r+3*s/4];break;case"3":i=[o+3*s/4,r+s/4];break;case"4":i=[o+s/4,r+s/4];break;default:i=[o+s/2,r+s/2]}}return t&&(ol.proj.get("EPSG:27572")||(proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)),i=ol.proj.transform(i,"EPSG:27572",t)),i},ol.coordinate.validDFCI=function(e){if(e.length<2||e.length>8)return!1;if(/[^A-H|^K-N]/.test(e.substr(0,1)))return!1;if(/[^B-H|^K-N]/.test(e.substr(1,1)))return!1;if(e.length>2){if(e.length<4)return!1;if(/[^0,^2,^4,^6,^8]/.test(e.substr(2,1)))return!1;if(/[^0,^2,^4,^6,^8]/.test(e.substr(3,1)))return!1}if(e.length>4){if(e.length<6)return!1;if(/[^A-H|^K-L]/.test(e.substr(4,1)))return!1;if(/[^0-9]/.test(e.substr(5,1)))return!1}if(e.length>6){if(e.length<8)return!1;if("."!==e.substr(6,1))return!1;if(/[^1-5]/.test(e.substr(7,1)))return!1}return!0},ol.coordinate.validDFCICoord=function(e,t){return t&&(ol.proj.get("EPSG:27572")||(proj4.defs["EPSG:27572"]||proj4.defs("EPSG:27572","+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs"),ol.proj.proj4.register(proj4)),e=ol.proj.transform(e,t,"EPSG:27572")),!(0>e[0]||e[0]>12e5)&&!(16e5>e[1]||e[1]>27e5)},ol.graph={},ol.graph.Dijkstra=class extends ol.Object{constructor(e){e=e||{},super(),this.source=e.source,this.nodes=new ol.source.Vector,this.maxIteration=e.maxIteration||2e4,this.stepIteration=e.stepIteration||2e3,this.astar=!0,this.candidat=[],this.set("epsilon",e.epsilon||1e-6)}weight(){return 1}direction(){return 2}getLength(e){return e.getGeometry&&(e=e.getGeometry()),e.getLength()}getNodeSource(){return this.nodes}getEdges(e){var t=ol.extent.buffer(ol.extent.boundingExtent([e]),this.get("epsilon")),i=[];return this.source.forEachFeatureIntersectingExtent(t,function(e){i.push(e)}),i}getNode(e){var t=ol.extent.buffer(ol.extent.boundingExtent([e]),this.get("epsilon")),i=[];return this.nodes.forEachFeatureIntersectingExtent(t,function(e){i.push(e)}),i[0]}addNode(e,t,i,s,o){if(this.wdist&&t>this.wdist)return!1;var r=this.getNode(e),a=t+this.getLength(new ol.geom.LineString([this.end,e]))*this.weight();if(this.astar&&this.wdist&&a>this.wdist)return!1;if(r){if(r!==this.arrival&&r.get("wdist")<=t)return r;r.set("dist",i),r.set("wdist",t),r.set("dtotal",a),r.set("from",s),r.set("prev",o),r===this.arrival&&(this.wdist=t),this.candidat.push(r)}else r=new ol.Feature({geometry:new ol.geom.Point(e),from:s,prev:o,dist:i||0,wdist:t,dtotal:a}),t<0?r.set("wdist",!1):this.candidat.push(r),this.nodes.addFeature(r);return r}closestCoordinate(e){var t=this.source.getClosestFeatureToCoordinate(e),i=t.getGeometry().getFirstCoordinate(),s=t.getGeometry().getLastCoordinate();return ol.coordinate.dist2d(e,i)<ol.coordinate.dist2d(e,s)?i:s}path(e,t){if(this.running)return!1;if(e=this.closestCoordinate(e),this.end=this.closestCoordinate(t),e[0]===this.end[0]&&e[1]===this.end[1])return this.dispatchEvent({type:"finish",route:[],wDistance:-1,distance:this.wdist}),!1;var i=this;return this.nodes.clear(),this.candidat=[],this.wdist=0,this.running=!0,this.addNode(e,0),this.arrival=this.addNode(this.end,-1),this.nb=0,this.dispatchEvent({type:"start"}),setTimeout(function(){i._resume()}),[e,this.end]}resume(){this.running||this.candidat.length&&(this.running=!0,this.nb=0,this._resume())}pause(){this.running&&(this.nb=-1)}getBestWay(){for(var e,t,i=-1,s=0;t=this.candidat[s];s++)t.get("wdist")>i&&(e=t,i=t.get("wdist"));return this.getRoute(e)}_resume(){if(this.running){for(;this.candidat.length;){this.candidat.sort(function(e,t){return e.get("dtotal")<t.get("dtotal")?1:e.get("dtotal")===t.get("dtotal")?0:-1});for(var e,t=this.candidat.pop(),i=t.getGeometry().getCoordinates(),s=this.getEdges(i),o=0;e=s[o];o++){if(t.get("from")!==e){var r=this.getLength(e);r<0&&console.log("distance < 0!");var a=t.get("wdist")+r*this.weight(e);r=t.get("dist")+r;var n=e.getGeometry().getFirstCoordinate(),l=e.getGeometry().getLastCoordinate(),h=this.direction(e);0!==h&&(i[0]===n[0]&&i[1]===n[1]&&-1!==h&&this.addNode(l,a,r,e,t),i[0]===l[0]&&i[0]===l[0]&&1!==h&&this.addNode(n,a,r,e,t))}if(-1===this.nb||this.nb++>this.maxIteration)return this.running=!1,void this.dispatchEvent({type:"pause",overflow:-1!==this.nb});if(!(this.nb%this.stepIteration)){var c=this;return window.setTimeout(function(){c._resume()},5),void this.dispatchEvent({type:"calculating"})}}}this.nodes.clear(),this.running=!1,this.dispatchEvent({type:"finish",route:this.getRoute(this.arrival),wDistance:this.wdist,distance:this.arrival.get("dist")})}}getRoute(e){for(var t=[];e;)t.unshift(e.get("from")),e=e.get("prev");return t.shift(),t}},ol.graph.Dijskra=ol.graph.Dijkstra,ol.geom.GPAltiCode=function(e,t){t=t||{};var i=e.getType();if("Point"===i||"LineString"===i){var s=t.projection||"EPSG:3857",o=void 0===t.minZ?-99:t.minZ,r=t.sampling||0;if(t.samplingDist){var a=e.getLength();r=Math.max(r,Math.round(a/t.samplingDist))}r>5e3&&(r=5e3),r<2&&(r=0),e=e.clone().transform(s,"EPSG:4326");var n,l=[],h=[];switch(i){case"Point":n=[e.getCoordinates()];break;case"LineString":n=e.getCoordinates();break;default:return}r<=n.length&&(r=0),n.forEach(function(e){l.push(Math.round(1e6*e[0])/1e6),h.push(Math.round(1e6*e[1])/1e6)});var c="lon="+l.join("|")+"&lat="+h.join("|");c+="&resource=ign_rge_alti_wld",r&&(c+="&sampling="+r),ol.ext.Ajax.get({url:"https://data.geopf.fr/altimetrie/1.0/calcul/alti/rest/"+(l.length>1?"elevationLine":"elevation")+".json?"+c,success:function(e){var a=[];e.elevations.forEach(function(e,t){r?a.push([e.lon,e.lat,Math.max(o,e.z)]):a.push([n[t][0],n[t][1],Math.max(o,e.z)])}),"Point"===i&&(a=a[0]);var l=ol.geom.createFromType(i,a);l.transform("EPSG:4326",s),"function"==typeof t.success&&t.success(l)},error:function(e){"function"==typeof t.error&&t.error(e)}})}else console.warn("[GPAltiCode] "+i+" not supported...")},ol.coordinate.GPAltiCode=function(e,t){t=t||{};var i=!e[0].length?new ol.geom.Point(e):new ol.geom.LineString(e);ol.geom.GPAltiCode(i,{projection:t.projection,sampling:t.sampling,samplingDist:t.samplingDist,success:function(e){"function"==typeof t.success&&t.success(e.getCoordinates())},error:t.error})},ol.coordinate.dist2d=function(e,t){var i=e[0]-t[0],s=e[1]-t[1];return Math.sqrt(i*i+s*s)},ol.coordinate.equal=function(e,t){return e[0]==t[0]&&e[1]==t[1]},ol.coordinate.getFeatureCenter=function(e){return ol.coordinate.getGeomCenter(e.getGeometry())},ol.coordinate.getGeomCenter=function(e){switch(e.getType()){case"Point":return e.getCoordinates();case"MultiPolygon":e=e.getPolygon(0);case"Polygon":return e.getInteriorPoint().getCoordinates();default:return e.getClosestPoint(ol.extent.getCenter(e.getExtent()))}},ol.coordinate.offsetCoords=function(e,t){var i,s,o,r,a,n,l,h,c,u,d,p,g,m=[],f=e.length-1,v=f,y=ol.coordinate.equal(e[0],e[f]);y||(d=e[0],p=e[1],g=[d[0]+(p[1]-d[1])/ol.coordinate.dist2d(d,p)*t,d[1]-(p[0]-d[0])/ol.coordinate.dist2d(d,p)*t],m.push(g),e.push(e[f]),f++,v--);for(var _=0;_<v;_++)d=e[_],p=e[(_+1)%f],g=e[(_+2)%f],i=(p[1]-d[1])/(p[0]-d[0]),s=(g[1]-p[1])/(g[0]-p[0]),Math.abs(i-s)>1e-10&&(o=Math.sqrt((p[0]-d[0])*(p[0]-d[0])+(p[1]-d[1])*(p[1]-d[1])),r=Math.sqrt((g[0]-p[0])*(g[0]-p[0])+(g[1]-p[1])*(g[1]-p[1])),a=d[0]+t*(p[1]-d[1])/o,c=(s*(n=p[0]+t*(g[1]-p[1])/r)-i*a+(l=d[1]-t*(p[0]-d[0])/o)-(h=p[1]-t*(g[0]-p[0])/r))/(s-i),u=(i*s*(n-a)+s*l-i*h)/(s-i),p[0]-d[0]==0&&(u=s*(c=p[0]+t*(p[1]-d[1])/Math.abs(p[1]-d[1]))-s*n+h),g[0]-p[0]==0&&(u=i*(c=g[0]+t*(g[1]-p[1])/Math.abs(g[1]-p[1]))-i*a+l),m.push([c,u]));return y?m.push(m[0]):(e.pop(),d=e[e.length-1],p=e[e.length-2],g=[d[0]-(p[1]-d[1])/ol.coordinate.dist2d(d,p)*t,d[1]+(p[0]-d[0])/ol.coordinate.dist2d(d,p)*t],m.push(g)),m},ol.coordinate.findSegment=function(e,t){for(var i=0;i<t.length-1;i++){var s=t[i],o=t[i+1];if(ol.coordinate.equal(e,s)||ol.coordinate.equal(e,o))return{index:1,segment:[s,o]};var r=ol.coordinate.dist2d(s,o),a=[(o[0]-s[0])/r,(o[1]-s[1])/r],n=ol.coordinate.dist2d(s,e),l=[(e[0]-s[0])/n,(e[1]-s[1])/n];if(Math.abs(a[0]*l[1]-a[1]*l[0])<1e-10)return{index:1,segment:[s,o]}}return{index:-1}},ol.coordinate.splitH=function(e,t,i){for(var s,o,r=[],a=0;a<e.length-1;a++)e[a].length&&e[a+1].length&&(e[a][1]<=t&&e[a+1][1]>t||e[a][1]>=t&&e[a+1][1]<t)&&(s=(o=(t-e[a][1])/(e[a+1][1]-e[a][1]))*(e[a+1][0]-e[a][0])+e[a][0],r.push({contour:i,index:a,pt:[s,t],abs:o}));r.sort(function(e,t){return e.pt[0]-t.pt[0]});for(var n=[],l=0;l<r.length-1;l+=2)n.push([r[l],r[l+1]]);return n},ol.geom.createFromType=function(e,t){switch(e){case"LineString":return new ol.geom.LineString(t);case"LinearRing":return new ol.geom.LinearRing(t);case"MultiLineString":return new ol.geom.MultiLineString(t);case"MultiPoint":return new ol.geom.MultiPoint(t);case"MultiPolygon":return new ol.geom.MultiPolygon(t);case"Point":return new ol.geom.Point(t);case"Polygon":return new ol.geom.Polygon(t);default:return console.error("[createFromType] Unsupported type: "+e),null}},ol.coordinate.getIntersectionPoint=function(e,t){var i=e[1][0]-e[0][0],s=e[1][1]-e[0][1],o=t[1][0]-t[0][0],r=t[1][1]-t[0][1],a=i*r-s*o;if(0!=a){var n=(i*e[0][1]-i*t[0][1]-s*e[0][0]+s*t[0][0])/a;return[t[0][0]+n*o,t[0][1]+n*r]}return!1},ol.extent.intersection,function(){function e(e,t){for(var i,s=e.length-1;s>0;s--)(e[s][0]>t&&e[s-1][0]<t||e[s][0]<t&&e[s-1][0]>t)&&(i=[t,(t-e[s][0])/(e[s-1][0]-e[s][0])*(e[s-1][1]-e[s][1])+e[s][1]],e.splice(s,0,i))}function t(e,t){for(var i,s=e.length-1;s>0;s--)(e[s][1]>t&&e[s-1][1]<t||e[s][1]<t&&e[s-1][1]>t)&&(i=[(t-e[s][1])/(e[s-1][1]-e[s][1])*(e[s-1][0]-e[s][0])+e[s][0],t],e.splice(s,0,i))}ol.extent.intersection=function(i,s){var o="Polygon"===s.getType();if(!o&&"MultiPolygon"!==s.getType())return null;var r=s.getCoordinates();return o&&(r=[r]),r.forEach(function(s){s.forEach(function(s){e(s,i[0]),e(s,i[2]),t(s,i[1]),t(s,i[3])})}),r.forEach(function(e){e.forEach(function(e){e.forEach(function(e){e[0]<i[0]?e[0]=i[0]:e[0]>i[2]&&(e[0]=i[2]),e[1]<i[1]?e[1]=i[1]:e[1]>i[3]&&(e[1]=i[3])})})}),o?new ol.geom.Polygon(r[0]):new ol.geom.MultiPolygon(r)}}(),ol.coordinate.sampleAt=function(e,t,i,s){var o=[];!1!==s&&o.push(e);var r=ol.coordinate.dist2d(e,t);if(r){var a=Math.round(r/i);if(a>1)for(var n=(t[0]-e[0])/a,l=(t[1]-e[1])/a,h=1;h<a;h++)o.push([e[0]+n*h,e[1]+l*h])}return o.push(t),o},ol.geom.LineString.prototype.sampleAt=function(e){for(var t=this.getCoordinates(),i=[],s=1;s<t.length;s++)i=i.concat(ol.coordinate.sampleAt(t[s-1],t[s],e,1===s));return new ol.geom.LineString(i)},ol.geom.MultiLineString.prototype.sampleAt=function(e){var t=this.getCoordinates(),i=[];return t.forEach(function(t){for(var s=[],o=1;o<t.length;o++)s=s.concat(ol.coordinate.sampleAt(t[o-1],t[o],e,1===o));i.push(s)}),new ol.geom.MultiLineString(i)},ol.geom.Polygon.prototype.sampleAt=function(e){var t=this.getCoordinates(),i=[];return t.forEach(function(t){for(var s=[],o=1;o<t.length;o++)s=s.concat(ol.coordinate.sampleAt(t[o-1],t[o],e,1===o));i.push(s)}),new ol.geom.Polygon(i)},ol.geom.MultiPolygon.prototype.sampleAt=function(e){var t=this.getCoordinates(),i=[];return t.forEach(function(t){var s=[];i.push(s),t.forEach(function(t){for(var i=[],o=1;o<t.length;o++)i=i.concat(ol.coordinate.sampleAt(t[o-1],t[o],e,1===o));s.push(i)})}),new ol.geom.MultiPolygon(i)},ol.geom.Circle.prototype.intersection=function(e,t){if(e.sampleAt){var i=ol.extent.buffer(this.getCenter().concat(this.getCenter()),this.getRadius());e=(e=ol.extent.intersection(i,e)).simplify(t);var s=this.getCenter(),o=this.getRadius(),r=e.sampleAt(t).getCoordinates();switch(e.getType()){case"Polygon":r=[r];case"MultiPolygon":var a=!1,n=[];return r.forEach(function(e){var t=[];n.push(t),e.forEach(function(e){var i=[];t.push(i),e.forEach(function(e){var t=ol.coordinate.dist2d(s,e);t>o?(a=!0,i.push([s[0]+o/t*(e[0]-s[0]),s[1]+o/t*(e[1]-s[1])])):i.push(e)})})}),a?"Polygon"===e.getType()?new ol.geom.Polygon(n[0]):new ol.geom.MultiPolygon(n):e}}else console.warn("[ol/geom/Circle~intersection] Unsupported geometry type: "+e.getType());return e},ol.geom.LineString.prototype.splitAt=function(e,t){var i;if(!e)return[this];if(t||(t=1e-10),e.length&&e[0].length){var s=[this];for(i=0;i<e.length;i++){for(var o=[],r=0;r<s.length;r++){var a=s[r].splitAt(e[i],t);o=o.concat(a)}s=o}return s}if(ol.coordinate.equal(e,this.getFirstCoordinate())||ol.coordinate.equal(e,this.getLastCoordinate()))return[this];var n=this.getCoordinates(),l=[n[0]],h=[];for(i=0;i<n.length-1;i++)if(!ol.coordinate.equal(n[i],n[i+1])){if(ol.coordinate.equal(e,n[i+1]))l.push(n[i+1]),h.push(new ol.geom.LineString(l)),l=[];else if(!ol.coordinate.equal(e,n[i])){var c,u,d=!1;n[i][0]==n[i+1][0]?(c=(n[i][1]-e[1])/(n[i][1]-n[i+1][1]),d=n[i][0]==e[0]&&0<c&&c<=1):n[i][1]==n[i+1][1]?(c=(n[i][0]-e[0])/(n[i][0]-n[i+1][0]),d=n[i][1]==e[1]&&0<c&&c<=1):(c=(n[i][0]-e[0])/(n[i][0]-n[i+1][0]),u=(n[i][1]-e[1])/(n[i][1]-n[i+1][1]),d=Math.abs(c-u)<=t&&0<c&&c<=1),d&&(l.push(e),h.push(new ol.geom.LineString(l)),l=[e])}l.push(n[i+1])}return l.length>1&&h.push(new ol.geom.LineString(l)),h.length?h:[this]},ol.geom.MultiPolygon.prototype.scribbleFill=function(e){var t,i,s,o=[],r=this.getPolygons();for(t=0;i=r[t];t++){var a=i.scribbleFill(e);a&&o.push(a)}if(!o.length)return null;var n,l=o[0];for(t=0;s=o[t];t++){n=s.getLineStrings();for(var h=0;h<n.length;h++)l.appendLineString(n[h])}return l},ol.geom.Polygon.prototype.scribbleFill=function(e){var t,i,s,o=e.interval,r=e.angle||Math.PI/2,a=this.clone();a.rotate(r,[0,0]);var n=a.getCoordinates(),l=n[0];for(t=1;t<n.length;t++)l.push([]),l=l.concat(n[t]);for(var h=a.getExtent(),c=[],u=(Math.floor(h[1]/o)+1)*o;u<h[3];u+=o)s=ol.coordinate.splitH(l,u,t),c=c.concat(s);if(!c.length)return null;var d=l.length-1,p=c[0][0].index;for(i=0;s=c[i];i++)c[i][0].index=(c[i][0].index-p+d)%d,c[i][1].index=(c[i][1].index-p+d)%d;for(var g=[];;){for(i=0;(s=c[i])&&s[0].done;i++);if(!s)break;for(var m=[];s;){s[0].done=!0,m.push(s[0].pt),m.push(s[1].pt);for(var f=s[0].pt[1]+o,v=1/0,y=null;c[i]&&!(c[i][0].pt[1]>f);){if(c[i][0].pt[1]===f){var _=Math.min((c[i][0].index-s[0].index+d)%d,(s[0].index-c[i][0].index+d)%d),x=Math.min((s[1].index-s[0].index+d)%d,(s[0].index-s[1].index+d)%d);_<v&&_<x&&(v=_,y=c[i][0].done?null:c[i])}i++}s=y}m.length&&g.push(m)}if(!g.length)return null;var b=new ol.geom.MultiLineString(g);return b.rotate(-r,[0,0]),b.cspline({pointsPerSeg:8,tension:.9})},ol.geom.scribbleFill=function(e,t){switch(e.getType()){case"Polygon":return ol.geom.Polygon.prototype.scribbleFill.call(e,t);case"MultiPolygon":return ol.geom.MultiPolygon.prototype.scribbleFill.call(e,t);default:return e}},ol.geom.Simplificator=class extends ol.Object{constructor(e){super(e),this._edges=[]}getEdges(){return this._edges}setFeatures(e,t){console.time("arcs"),t&&(t=Math.pow(10,t));var i=this._calcEdges(e,t);return console.timeLog("arcs"),console.time("chain"),this._edges=this._chainEdges(i),console.timeLog("chain"),this._edges}getFeatures(){var e=[];return this._edges.forEach(function(t){t.get("edge").forEach(function(i){var s=e.find(function(e){return i.feature===e.feature});s||(s={feature:i.feature,contour:{}},e.push(s)),s.contour[i.contour]||(s.contour[i.contour]=[]),s.contour[i.contour].push({edge:t,index:i.index})})}),e.forEach(function(e){e.typeGeom=e.feature.getGeometry().getType(),e.nom=e.feature.get("nom");var t=[];for(var i in e.contour){var s=i.split("-");s.shift();for(var o=t;s.length;){var r=parseInt(s.shift());o[r]||(o[r]=[]),o=o[r]}e.contour[i].sort(function(e,t){return e.index-t.index}),e.contour[i].forEach(function(e){var t=e.edge.getGeometry().getCoordinates();if(!o.length||ol.coordinate.equal(o[o.length-1],t[0]))for(var i=o.length?1:0;i<t.length;i++)o.push(t[i]);else if(ol.coordinate.equal(o[0],t[0]))for(i=1;i<t.length;i++)o.unshift(t[i]);else if(ol.coordinate.equal(o[0],t[t.length-1]))for(i=t.length-2;i>=0;i--)o.unshift(t[i]);else for(i=t.length-2;i>=0;i--)o.push(t[i])})}e.geom=t,e.feature.getGeometry().setCoordinates(t)}),e}simplifyVisvalingam(e){this._edges.forEach(function(t){var i=t.get("edge")[0].feature.getGeometry().getType();t.setGeometry(t.get("geom").simplifyVisvalingam({area:e.area,dist:e.dist,ratio:e.ratio,minPoints:e.minPoints,keepEnds:!!/Polygon/.test(i)||e.keepEnds}))})}simplify(e){this._edges.forEach(function(t){t.setGeometry(t.get("geom").simplify(e))})}_calcEdges(e,t){var i,s,o={};e.forEach(function(e){if(!/Point/.test(e.getGeometry().getType())){var r=this._getArcs(e.getGeometry().getCoordinates(),[],"0",t);i="",r.forEach(function(t,r){!function(e,t,r){var a=t.seg[0]+"-"+t.seg[1],n=o[a];if(n||(a=t.seg[1]+"-"+t.seg[0],n=o[a]),n)n.edge.push({feature:e,contour:t.contour,index:r}),i="";else{var l={geometry:t.seg,edge:[{feature:e,contour:t.contour,index:r}],prev:i===t.contour&&s};i=t.contour,s=l,o[a]=l}}(e,t,r)})}}.bind(this));var r=[];for(var a in o)r.push(o[a]);return r}_getArcs(e,t,i,s){return e[0][0][0].length?e.forEach(function(e,o){this._getArcs(e,t,i+"-"+o,s)}.bind(this)):e.forEach(function(e,s){for(var o,r=e[0],a=i+"-"+s,n=1;n<e.length;n++)o=e[n],ol.coordinate.equal(r,o)||t.push({seg:[r,o],contour:a}),r=o}),t}_chainEdges(e){e.forEach(function e(t){if(!t.del){var i=t.prev;if(i&&function(e,t){if(e.length===t.length){for(var i,s,o,r=0;r<e.length;r++){s=e[r],i=!1;for(var a=0;a<t.length;a++)if(o=t[a],s.feature===o.feature&&s.contour===o.contour){i=!0;break}if(!i)return!1}return!0}return!1}(t.edge,i.edge)){i.del=!0;var s=i.geometry,o=t.geometry;o.shift(),t.geometry=s.concat(o),t.prev=i.prev,e(t)}}});var t=[];return e.forEach(function(e){e.del||t.push(new ol.Feature({geometry:new ol.geom.LineString(e.geometry),geom:new ol.geom.LineString(e.geometry),edge:e.edge,prev:e.prev}))}),t}},ol.geohash={base32:"0123456789bcdefghjkmnpqrstuvwxyz"},ol.geohash.fromLonLat=function(e,t){var i=e[0],s=e[1];if(!t){for(var o=1;o<=12;o++){var r=ol.geohash.fromLonLat([i,s],o),a=ol.geohash.toLonLat(r);if(a.lat==s&&a.lon==i)return r}t=12}(t<1||t>12)&&(t=12);for(var n=0,l=0,h=!0,c="",u=-90,d=90,p=-180,g=180;c.length<t;){if(h){var m=(p+g)/2;i>=m?(n=2*n+1,p=m):(n*=2,g=m)}else{var f=(u+d)/2;s>=f?(n=2*n+1,u=f):(n*=2,d=f)}h=!h,5==++l&&(c+=ol.geohash.base32.charAt(n),l=0,n=0)}return c},ol.geohash.toLonLat=function(e){var t=ol.geohash.getExtent(e),i=t[1],s=t[0],o=t[3],r=t[2],a=(i+o)/2,n=(s+r)/2;return a=a.toFixed(Math.floor(2-Math.log(o-i)/Math.LN10)),n=n.toFixed(Math.floor(2-Math.log(r-s)/Math.LN10)),[Number(n),Number(a)]},ol.geohash.getExtent=function(e){if(!e)return!1;e=e.toLowerCase();for(var t=!0,i=-90,s=90,o=-180,r=180,a=0;a<e.length;a++){var n=e.charAt(a),l=ol.geohash.base32.indexOf(n);if(-1==l)return!1;for(var h=4;h>=0;h--){var c=l>>h&1;if(t){var u=(o+r)/2;1==c?o=u:r=u}else{var d=(i+s)/2;1==c?i=d:s=d}t=!t}}return[o,i,r,s]},ol.geohash.getAdjacent=function(e,t){if(e=e.toLowerCase(),t=t.toLowerCase(),!e)return!1;if(-1=="nsew".indexOf(t))return!1;var i=e.slice(-1),s=e.slice(0,-1),o=e.length%2;return-1!={n:["prxz","bcfguvyz"],s:["028b","0145hjnp"],e:["bcfguvyz","prxz"],w:["0145hjnp","028b"]}[t][o].indexOf(i)&&""!=s&&(s=ol.geohash.getAdjacent(s,t)),s+ol.geohash.base32.charAt({n:["p0r21436x8zb9dcf5h7kjnmqesgutwvy","bc01fg45238967deuvhjyznpkmstqrwx"],s:["14365h7k9dcfesgujnmqp0r2twvyx8zb","238967debc01fg45kmstqrwxuvhjyznp"],e:["bc01fg45238967deuvhjyznpkmstqrwx","p0r21436x8zb9dcf5h7kjnmqesgutwvy"],w:["238967debc01fg45kmstqrwxuvhjyznp","14365h7k9dcfesgujnmqp0r2twvyx8zb"]}[t][o].indexOf(i))},ol.geohash.getNeighbours=function(e){return{n:ol.geohash.getAdjacent(e,"n"),ne:ol.geohash.getAdjacent(ol.geohash.getAdjacent(e,"n"),"e"),e:ol.geohash.getAdjacent(e,"e"),se:ol.geohash.getAdjacent(ol.geohash.getAdjacent(e,"s"),"e"),s:ol.geohash.getAdjacent(e,"s"),sw:ol.geohash.getAdjacent(ol.geohash.getAdjacent(e,"s"),"w"),w:ol.geohash.getAdjacent(e,"w"),nw:ol.geohash.getAdjacent(ol.geohash.getAdjacent(e,"n"),"w")}},ol.sphere.greatCircleBearing=function(e,t){var i=Math.PI/180,s=[e[0]*i,e[1]*i],o=[t[0]*i,t[1]*i];return Math.atan2(Math.sin(o[0]-s[0])*Math.cos(o[1]),Math.cos(s[1])*Math.sin(o[1])-Math.sin(s[1])*Math.cos(o[1])*Math.cos(o[0]-s[0]))},ol.sphere.computeDestinationPoint=function(e,t,i,s){s=s||{};var o=Math.PI/180,r=s.radius||6371008.8,a=e[1]*o,n=e[0]*o,l=t/r,h=Math.asin(Math.sin(a)*Math.cos(l)+Math.cos(a)*Math.sin(l)*Math.cos(i)),c=(n+Math.atan2(Math.sin(i)*Math.sin(l)*Math.cos(a),Math.cos(l)-Math.sin(a)*Math.sin(h)))/o;return!1!==s.normalize&&(c<-180||c>180)&&(c=540*c%360-180),[c,h/o]},ol.sphere.greatCircleTrack=function(e,t,i){i=i||{};for(var s=ol.sphere.greatCircleBearing(e,t),o=ol.sphere.getDistance(e,t,i.radius),r=i.distance||1e3,a=r,n=[e];a<o;)n.push(ol.sphere.computeDestinationPoint(e,a,s,{radius:i.radius,normalize:!1})),a+=r;var l=ol.sphere.computeDestinationPoint(e,o,s,{radius:i.radius,normalize:!1});return Math.abs(l[0]-t[0])>1&&(l[0]>t[0]?t[0]+=360:t[0]-=360),n.push(t),n},ol.sphere.getMapScale=function(e,t){var i=e.getView(),s=i.getProjection(),o=i.getCenter(),r=e.getPixelFromCoordinate(o);r[1]+=1;var a=e.getCoordinateFromPixel(r),n=ol.sphere.getDistance(ol.proj.transform(o,s,"EPSG:4326"),ol.proj.transform(a,s,"EPSG:4326"));return n*=(t||96)/.0254},ol.sphere.setMapScale=function(e,t,i){if(e&&t){var s=t;if("string"==typeof t&&((s=(t=t.replace(":","/").split("/"))[1])||(s=t[0]||""),s=s.replace(/[^\d]/g,""),s=parseInt(s),t[1])){var o=parseInt(t[0]);o&&(s/=o)}if(!s)return;var r=e.getView(),a=r.getProjection(),n=r.getCenter(),l=e.getPixelFromCoordinate(n);l[1]+=1;var h=e.getCoordinateFromPixel(l),c=ol.sphere.getDistance(ol.proj.transform(n,a,"EPSG:4326"),ol.proj.transform(h,a,"EPSG:4326"));return c*=(i||96)/.0254,r.setResolution(r.getResolution()*s/c),s}},function(){function e(e,t){return e[1][2]-t[1][2]}function t(e){return Math.abs((e[0][0]-e[2][0])*(e[1][1]-e[0][1])-(e[0][0]-e[1][0])*(e[2][1]-e[0][1]))}ol.geom.LineString.prototype.simplifyVisvalingam=function(i){var s=this.getCoordinates();if(i.minPoints&&i.minPoints>=s.length)return new ol.geom.LineString(s);for(var o,r=function(){var t={},i=[];function s(t){for(var s=i[t];t>0;){var o=(t+1>>1)-1,r=i[o];if(e(s,r)>=0)break;i[r.index=t]=r,i[s.index=t=o]=s}}function o(t){for(var s=i[t];;){var o=2*(t+1),r=o-1,a=t,n=i[a];if(r<i.length&&e(i[r],n)<0&&(n=i[a=r]),o<i.length&&e(i[o],n)<0&&(n=i[a=o]),a===t)break;i[n.index=t]=n,i[s.index=t=a]=s}}return t.push=function(){for(var e=0,t=arguments.length;e<t;++e){var o=arguments[e];s(o.index=i.push(o)-1)}return i.length},t.pop=function(){var e=i[0],t=i.pop();return i.length&&(i[t.index=0]=t,o(0)),e},t.size=function(){return i.length},t.remove=function(t){var r=t.index,a=i.pop();return r!==i.length&&(i[a.index=r]=a,(e(a,t)<0?s:o)(r)),r},t}(),a=0,n=[],l=1,h=(s=s.map(function(e){return e.slice(0,2)})).length-1;l<h;++l)((o=s.slice(l-1,l+2))[1][2]=t(o))&&(n.push(o),r.push(o));for(l=0,h=n.length;l<h;++l)(o=n[l]).previous=n[l-1],o.next=n[l+1];for(;o=r.pop();)o[1][2]<a?o[1][2]=a:a=o[1][2],o.previous?(o.previous.next=o.next,o.previous[2]=o[2],c(o.previous)):o[0][2]=o[1][2],o.next?(o.next.previous=o.previous,o.next[0]=o[0],c(o.next)):o[2][2]=o[1][2];function c(e){r.remove(e),e[1][2]=t(e),r.push(e)}var u=i.area;if(i.dist&&(u=i.dist*i.dist/2),void 0===u||i.minPoints){var d=s.map(function(e){return e.length<3?1/0:e[2]+=Math.random()});if(d.sort(function(e,t){return t-e}),u)d[i.minPoints]<u&&(u=d[i.minPoints]);else{var p=i.minPoints;if(!p){var g=i.ratio||.8;p=Math.round(s.length*g)}p=Math.min(p,d.length-1),u=d[p]}}var m=s.filter(function(e){return e[2]>u});return i.keepEnds&&(ol.coordinate.equal(m[0],s[0])||m.unshift(s[0]),ol.coordinate.equal(m[m.length-1],s[s.length-1])||m.push(s[s.length-1])),new ol.geom.LineString(m)}}(),ol.Map.prototype.animExtent=function(e,t){var i;(t=t||{}).projection&&(e=ol.proj.transformExtent(e,t.projection,this.getView().getProjection()));var s=(new Date).getTime(),o=t.duration||1e3,r=t.easing||ol.easing.upAndDown,a=t.style&&t.style.getWidth()||2,n=t.style&&t.style.getColr()||"red";i=this.on("postcompose",function(t){var l=t.frameState,h=l.pixelRatio,c=l.time-s;if(c>o)ol.Observable.unByKey(i);else{var u=c/o,d=this.getPixelFromCoordinate([e[0],e[1]]),p=this.getPixelFromCoordinate([e[2],e[3]]),g=t.context;g.save(),g.scale(h,h),g.beginPath(),g.globalAlpha=r(1-u),g.lineWidth=a,g.strokeStyle=n,g.rect(d[0],d[1],p[0]-d[0],p[1]-d[1]),g.stroke(),g.restore(),l.animate=!0}}.bind(this));try{this.renderSync()}catch(e){}},ol.geom.Geometry.prototype.cspline=function(e){return this.calcCSpline_?(this.csplineGeometryRevision==this.getRevision()&&this.csplineOption==JSON.stringify(e)||(this.csplineGeometry_=this.calcCSpline_(e),this.csplineGeometryRevision=this.getRevision(),this.csplineOption=JSON.stringify(e)),this.csplineGeometry_):this},ol.geom.GeometryCollection.prototype.calcCSpline_=function(e){for(var t=[],i=this.getGeometries(),s=0;s<i.length;s++)t.push(i[s].cspline(e));return new ol.geom.GeometryCollection(t)},ol.geom.MultiLineString.prototype.calcCSpline_=function(e){for(var t=[],i=this.getLineStrings(),s=0;s<i.length;s++)t.push(i[s].cspline(e).getCoordinates());return new ol.geom.MultiLineString(t)},ol.geom.Polygon.prototype.calcCSpline_=function(e){for(var t=[],i=this.getCoordinates(),s=0;s<i.length;s++)t.push(new ol.geom.LineString(i[s]).cspline(e).getCoordinates());return new ol.geom.Polygon(t)},ol.geom.MultiPolygon.prototype.calcCSpline_=function(e){for(var t=[],i=this.getPolygons(),s=0;s<i.length;s++)t.push(i[s].cspline(e).getCoordinates());return new ol.geom.MultiPolygon(t)},ol.coordinate.cspline=function(e,t){t||(t={});var i="number"==typeof t.tension?t.tension:.5,s=0,o=e[0];e.forEach(function(e){s+=ol.coordinate.dist2d(o,e),o=e});var r,a,n,l,h,c,u,d,p,g,m,f,v,y,_=t.resolution||s/e.length/(t.pointsPerSeg||10),x=[];function b(e,t,i,s){var o=i-e,r=s-t;return Math.sqrt(o*o+r*r)}for(r=e.slice(0),e.length>2&&e[0][0]==e[e.length-1][0]&&e[0][1]==e[e.length-1][1]?(r.unshift(e[e.length-2]),r.push(e[1])):(r.unshift(e[0]),r.push(e[e.length-1])),y=1;y<r.length-2;y++){var w=b(r[y][0],r[y][1],r[y+1][0],r[y+1][1]),S=Math.round(w/_),M=1;if(t.normalize){w=b(r[y+1][0],r[y+1][1],r[y-1][0],r[y-1][1]);var C=b(r[y+2][0],r[y+2][1],r[y][0],r[y][1]);M=w<C?w/C:C/w}for(l=(r[y+1][0]-r[y-1][0])*i*M,h=(r[y+2][0]-r[y][0])*i*M,c=(r[y+1][1]-r[y-1][1])*i*M,u=(r[y+2][1]-r[y][1])*i*M,v=0;v<=S;v++)f=v/S,d=2*Math.pow(f,3)-3*Math.pow(f,2)+1,p=-2*Math.pow(f,3)+3*Math.pow(f,2),g=Math.pow(f,3)-2*Math.pow(f,2)+f,m=Math.pow(f,3)-Math.pow(f,2),a=d*r[y][0]+p*r[y+1][0]+g*l+m*h,n=d*r[y][1]+p*r[y+1][1]+g*c+m*u,a&&n&&x.push([a,n])}return x},ol.geom.LineString.prototype.calcCSpline_=function(e){var t=this.getCoordinates(),i=ol.coordinate.cspline(t,e);return new ol.geom.LineString(i)},ol.HexGrid=class extends ol.Object{constructor(e){super(e=e||{}),this.size_=e.size||8e4,this.origin_=e.origin||[0,0],this.layout_=this.layout[e.layout]||this.layout.pointy}setLayout(e){this.layout_=this.layout[e]||this.layout.pointy,this.changed()}getLayout(){return 0!=this.layout_[9]?"pointy":"flat"}setOrigin(e){this.origin_=e,this.changed()}getOrigin(){return this.origin_}setSize(e){this.size_=e||8e4,this.changed()}getSize(){return this.size_}cube2hex(e){return[e[0],e[2]]}hex2cube(e){return[e[0],-e[0]-e[1],e[1]]}hex2offset(e){return this.layout_[9]?[e[0]+(e[1]-(1&e[1]))/2,e[1]]:[e[0],e[1]+(e[0]+(1&e[0]))/2]}offset2hex(e){return this.layout_[9]?[e[0]-(e[1]-(1&e[1]))/2,e[1]]:[e[0],e[1]-(e[0]+(1&e[0]))/2]}cube2offset(e){return this.hex2offset(this.cube2hex(e))}offset2cube(e){return this.hex2cube(this.offset2Hex(e))}cube_round(e){var t=Math.round(e[0]),i=Math.round(e[1]),s=Math.round(e[2]),o=Math.abs(t-e[0]),r=Math.abs(i-e[1]),a=Math.abs(s-e[2]);return o>r&&o>a?t=-i-s:r>a?i=-t-s:s=-t-i,[t,i,s]}hex_round(e){return this.cube2hex(this.cube_round(this.hex2cube(e)))}hex_corner(e,t,i){return[e[0]+t*this.layout_[8+i%6*2],e[1]+t*this.layout_[9+i%6*2]]}getHexagonAtCoord(e){return this.getHexagon(this.coord2hex(e))}getHexagon(e){for(var t=[],i=this.hex2coord(e),s=0;s<=7;s++)t.push(this.hex_corner(i,this.size_,s,this.layout_[8]));return t}hex2coord(e){return[this.origin_[0]+this.size_*(this.layout_[0]*e[0]+this.layout_[1]*e[1]),this.origin_[1]+this.size_*(this.layout_[2]*e[0]+this.layout_[3]*e[1])]}coord2hex(e){var t=[(e[0]-this.origin_[0])/this.size_,(e[1]-this.origin_[1])/this.size_],i=this.layout_[4]*t[0]+this.layout_[5]*t[1],s=this.layout_[6]*t[0]+this.layout_[7]*t[1];return this.hex_round([i,s])}cube_distance(e,t){return Math.max(Math.abs(e[0]-t[0]),Math.abs(e[1]-t[1]),Math.abs(e[2]-t[2]))}lerp(e,t,i){return e+(t-e)*i}cube_lerp(e,t,i){return[this.lerp(e[0]+1e-6,t[0],i),this.lerp(e[1]+1e-6,t[1],i),this.lerp(e[2]+1e-6,t[2],i)]}cube_line(e,t){var i=this.cube_distance(e,t);if(!i)return[e];for(var s=[],o=0;o<=i;o++)s.push(this.cube_round(this.cube_lerp(e,t,o/i)));return s}hex_neighbors(e,t){if(void 0!==t)return[e[0]+this.neighbors.hex[t%6][0],e[1]+this.neighbors.hex[t%6][1]];var i=[];for(t=0;t<6;t++)i.push([e[0]+this.neighbors.hex[t][0],e[1]+this.neighbors.hex[t][1]]);return i}cube_neighbors(e,t){if(void 0!==t)return[e[0]+this.neighbors.cube[t%6][0],e[1]+this.neighbors.cube[t%6][1],e[2]+this.neighbors.cube[t%6][2]];var i=[];for(t=0;t<6;t++)i.push([e[0]+this.neighbors.cube[t][0],e[1]+this.neighbors.cube[t][1],e[2]+this.neighbors.cube[t][2]]);for(t=0;t<6;t++)i[t]=this.cube2hex(i[t]);return i}},ol.HexGrid.prototype.layout={pointy:[Math.sqrt(3),Math.sqrt(3)/2,0,1.5,Math.sqrt(3)/3,-1/3,0,2/3,Math.cos(Math.PI/180*30),Math.sin(Math.PI/180*30),Math.cos(Math.PI/180*90),Math.sin(Math.PI/180*90),Math.cos(Math.PI/180*150),Math.sin(Math.PI/180*150),Math.cos(Math.PI/180*210),Math.sin(Math.PI/180*210),Math.cos(Math.PI/180*270),Math.sin(Math.PI/180*270),Math.cos(Math.PI/180*330),Math.sin(Math.PI/180*330)],flat:[1.5,0,Math.sqrt(3)/2,Math.sqrt(3),2/3,0,-1/3,Math.sqrt(3)/3,Math.cos(Math.PI/180*0),Math.sin(Math.PI/180*0),Math.cos(Math.PI/180*60),Math.sin(Math.PI/180*60),Math.cos(Math.PI/180*120),Math.sin(Math.PI/180*120),Math.cos(Math.PI/180*180),Math.sin(Math.PI/180*180),Math.cos(Math.PI/180*240),Math.sin(Math.PI/180*240),Math.cos(Math.PI/180*300),Math.sin(Math.PI/180*300)]},ol.HexGrid.prototype.neighbors={cube:[[1,-1,0],[1,0,-1],[0,1,-1],[-1,1,0],[-1,0,1],[0,-1,1]],hex:[[1,0],[1,-1],[0,-1],[-1,0],[-1,1],[0,1]]},ol.InseeGrid=class extends ol.Object{constructor(e){e=e||{},proj4.defs["EPSG:3035"]||(proj4.defs("EPSG:3035","+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +units=m +no_defs"),ol.proj.proj4.register(proj4)),super(e);var t=Math.max(200,200*Math.round((e.size||0)/200));this.set("size",t)}getExtent(e){return ol.proj.transformExtent(ol.InseeGrid.extent,e||"EPSG:3035","EPSG:3857")}getGridAtCoordinate(e,t){var i=ol.proj.transform(e,t||"EPSG:3857","EPSG:3035"),s=this.get("size"),o=Math.floor(i[0]/s)*s,r=Math.floor(i[1]/s)*s,a=new ol.geom.Polygon([[[o,r],[o+s,r],[o+s,r+s],[o,r+s],[o,r]]]);return a.transform("EPSG:3035",t||"EPSG:3857"),a}},ol.InseeGrid.extent=[32e5,2e6,43e5,314e4],ol.Map.prototype.markup=function(e,t){var i,s=this;(t=t||{}).projection&&(e=ol.proj.transform(e,t.projection,this.getView().getProjection()));var o=(new Date).getTime(),r=t.delay||3e3,a=1e3,n=t.maxZoom||100,l=ol.easing.easeOut,h=t.style;h||(h=new ol.style.Circle({radius:10,stroke:new ol.style.Stroke({color:"red",width:2})})),h instanceof ol.style.Image&&(h=new ol.style.Style({image:h})),h instanceof Array||(h=[h]),setTimeout(function(){if(i)try{s.renderSync()}catch(e){}},r),i=this.on("postcompose",function(t){var s=t.frameState,c=s.time-o;if(c>r+a)ol.Observable.unByKey(i),i=null;else{r>c&&this.getView().getZoom()>n&&(r=c);var u=s.pixelRatio,d=0;c>r&&(d=(c-r)/a);var p=t.context;p.save(),p.beginPath(),p.globalAlpha=l(1-d);for(var g=0;g<h.length;g++){var m=h[g].getImage(),f=m.getScale();m.setScale(f*u),t.vectorContext.setStyle(h[g]),t.vectorContext.drawGeometry(new ol.geom.Point(e)),m.setScale(f)}p.restore(),c>=r&&(s.animate=!0)}}.bind(this));try{this.renderSync()}catch(e){}return i.stop=function(){r=a=0;try{this.target.renderSync()}catch(e){}},i},ol.ordering={},ol.ordering.yOrdering=function(){return function(e,t){return t.getGeometry().getExtent()[1]-e.getGeometry().getExtent()[1]}},ol.ordering.zIndex=function(e){e||(e={});var t=e.attribute||"zIndex";return e.equalFn?function(i,s){return i.get(t)==s.get(t)?e.equalFn(i,s):i.get(t)<s.get(t)?1:-1}:function(e,i){return e.get(t)==i.get(t)?0:e.get(t)<i.get(t)?1:-1}},ol.Map.prototype.pulse=function(e,t){var i;(t=t||{}).projection&&(e=ol.proj.transform(e,t.projection,this.getView().getProjection()));var s=(new Date).getTime(),o=t.duration||3e3,r=t.easing||ol.easing.easeOut,a=t.style;a||(a=new ol.style.Circle({radius:30,stroke:new ol.style.Stroke({color:"red",width:2})})),a instanceof ol.style.Image&&(a=new ol.style.Style({image:a})),a instanceof Array||(a=[a]);var n=t.amplitude||1;n<0&&(n=0);var l=t.radius||15;l<0&&(l=5),i=this.on("postcompose",function(t){var l=t.frameState,h=l.pixelRatio,c=l.time-s;if(c>o)ol.Observable.unByKey(i);else{var u=c/o,d=t.context;d.save(),d.beginPath();var p=r(u);d.globalAlpha=r(1-u);for(var g=0;g<a.length;g++){var m=a[g].getImage(),f=m.getScale();m.setScale(h*f*(1+n*(p-1))),t.vectorContext.setStyle(a[g]),t.vectorContext.drawGeometry(new ol.geom.Point(e)),m.setScale(f)}d.restore(),l.animate=!0}}.bind(this));try{this.renderSync()}catch(e){}},ol.style.Chart=class extends ol.style.RegularShape{constructor(e){var t=e||{},i=0;e.stroke&&(i=e.stroke.getWidth()),super({radius:t.radius+i,fill:new ol.style.Fill({color:[0,0,0]}),rotation:t.rotation,displacement:t.displacement,snapToPixel:t.snapToPixel,declutterMode:t.declutterMode}),this.setScale(t.scale||1),this._stroke=t.stroke,this._radius=t.radius||20,this._donutratio=t.donutRatio||.5,this._type=t.type,this._offset=[t.offsetX?t.offsetX:0,t.offsetY?t.offsetY:0],this._animation="number"==typeof t.animation?{animate:!0,step:t.animation}:this._animation={animate:!1,step:1},this._max=t.max,this._done=!1,this._data=t.data,t.colors instanceof Array?this._colors=t.colors:(this._colors=ol.style.Chart.colors[t.colors],this._colors||(this._colors=ol.style.Chart.colors.classic)),this.render()}clone(){var e=new ol.style.Chart({type:this._type,radius:this._radius,rotation:this.getRotation(),scale:this.getScale(),data:this.getData(),snapToPixel:!!this.getSnapToPixel&&this.getSnapToPixel(),stroke:this._stroke,colors:this._colors,offsetX:this._offset[0],offsetY:this._offset[1],animation:this._animation,declutterMode:this.getDeclutterMode?this.getDeclutterMode():null});return e.setScale(this.getScale()),e.setOpacity(this.getOpacity()),e}getData(){return this._data}setData(e){this._data=e,this._done=!1}getRadius(){return this._radius}setRadius(e,t){this._radius=e,this.donuratio_=t||this.donuratio_,this._done=!1}setAnimation(e){if(!1===e){if(0==this._animation.animate)return;this._animation.animate=!1}else{if(this._animation.step==e)return;this._animation.animate=!0,this._animation.step=e}this._done=!1}createRenderOptions(){var e=super.createRenderOptions();return e.chartOptions=["chart",Object.values(this._animation||{}).join(","),this._type,(this._data||[]).join(","),(this._colors||[]).join(","),this._donutratio,this._max].join("-"),e}getImage(e){e=e||1;var t,i=super.getImage(e);if(this._done===e)return i;this._done=e;var s=0;this._stroke&&(t=ol.color.asString(this._stroke.getColor()),s=this._stroke.getWidth());var o=i.getContext("2d");o.save(),o.setTransform(e,0,0,e,0,0),o.clearRect(0,0,i.width,i.height),o.lineJoin="round";var r,a,n=0;for(r=0;r<this._data.length;r++)n+=this._data[r];o.translate(0,0);var l=this._animation.animate?this._animation.step:1;switch(this._type){case"donut":case"pie3D":case"pie":var h,c=Math.PI*(l-1.5);for(a=i.width/2/e,o.strokeStyle=t,o.lineWidth=s,o.save(),"pie3D"==this._type&&(o.translate(0,.3*a),o.scale(1,.7),o.beginPath(),o.fillStyle="#369",o.arc(a,1.4*a,this._radius*l,0,2*Math.PI),o.fill(),o.stroke()),"donut"==this._type&&(o.save(),o.beginPath(),o.rect(0,0,2*a,2*a),o.arc(a,a,this._radius*l*this._donutratio,0,2*Math.PI),o.clip("evenodd")),r=0;r<this._data.length;r++)o.beginPath(),o.moveTo(a,a),o.fillStyle=this._colors[r%this._colors.length],h=c+2*Math.PI*this._data[r]/n*l,o.arc(a,a,this._radius*l,c,h),o.closePath(),o.fill(),o.stroke(),c=h;"donut"==this._type&&(o.restore(),o.beginPath(),o.strokeStyle=t,o.lineWidth=s,o.arc(a,a,this._radius*l*this._donutratio,Math.PI*(l-1.5),c),o.stroke()),o.restore();break;case"bar":default:var u=0;if(this._max)u=this._max;else for(r=0;r<this._data.length;r++)u<this._data[r]&&(u=this._data[r]);var d=Math.min(5,2*this._radius/this._data.length);a=i.width/2/e;var p,g=i.width/e-s,m=a-this._data.length*d/2;for(o.strokeStyle=t,o.lineWidth=s,r=0;r<this._data.length;r++){o.beginPath(),o.fillStyle=this._colors[r%this._colors.length],p=m+d;var f=this._data[r]/u*2*this._radius*l;o.rect(m,g-f,d,f),o.closePath(),o.fill(),o.stroke(),m=p}}if(o.restore(),!this.setDisplacement){var v=this.getAnchor();v[0]=a-this._offset[0],v[1]=a-this._offset[1]}return i}},ol.style.Chart.colors={classic:["#ffa500","blue","red","green","cyan","magenta","yellow","#0f0"],dark:["#960","#003","#900","#060","#099","#909","#990","#090"],pale:["#fd0","#369","#f64","#3b7","#880","#b5d","#666"],pastel:["#fb4","#79c","#f66","#7d7","#acc","#fdd","#ff9","#b9b"],neon:["#ff0","#0ff","#0f0","#f0f","#f00","#00f"]},ol.style.FillPattern=class extends ol.style.Fill{constructor(e){var t;super(),e=e||{};var i=this.canvas_=document.createElement("canvas"),s=(Number(e.scale)>0?Number(e.scale):1)*ol.has.DEVICE_PIXEL_RATIO||ol.has.DEVICE_PIXEL_RATIO,o=i.getContext("2d");if(e.image){var r;e.image.load();var a=e.image.getImage();if(a.width)i.width=Math.round(a.width*s),i.height=Math.round(a.height*s),o.globalAlpha="number"==typeof e.opacity?e.opacity:1,o.drawImage(a,0,0,a.width,a.height,0,0,i.width,i.height),t=o.createPattern(i,"repeat");else{var n=this;t=[0,0,0,0],a.onload=function(){i.width=Math.round(a.width*s),i.height=Math.round(a.height*s),o.globalAlpha="number"==typeof e.opacity?e.opacity:1,o.drawImage(a,0,0,a.width,a.height,0,0,i.width,i.height),t=o.createPattern(i,"repeat"),n.setColor(t)}}}else{var l=this.getPattern_(e);if(i.width=Math.round(l.width*s),i.height=Math.round(l.height*s),o.beginPath(),e.fill&&(o.fillStyle=ol.color.asString(e.fill.getColor()),o.fillRect(0,0,i.width,i.height)),o.scale(s,s),o.lineCap="round",o.lineWidth=l.stroke||1,o.fillStyle=ol.color.asString(e.color||"#000"),o.strokeStyle=ol.color.asString(e.color||"#000"),l.circles)for(r=0;r<l.circles.length;r++){var h=l.circles[r];o.beginPath(),o.arc(h[0],h[1],h[2],0,2*Math.PI),l.fill&&o.fill(),l.stroke&&o.stroke()}if(l.repeat||(l.repeat=[[0,0]]),l.char&&(o.font=l.font||l.width+"px Arial",o.textAlign="center",o.textBaseline="middle",l.angle?(o.fillText(l.char,l.width/4,l.height/4),o.fillText(l.char,5*l.width/4,5*l.height/4),o.fillText(l.char,l.width/4,5*l.height/4),o.fillText(l.char,5*l.width/4,l.height/4),o.fillText(l.char,3*l.width/4,3*l.height/4),o.fillText(l.char,-l.width/4,-l.height/4),o.fillText(l.char,3*l.width/4,-l.height/4),o.fillText(l.char,-l.width/4,3*l.height/4)):o.fillText(l.char,l.width/2,l.height/2)),l.lines)for(r=0;r<l.lines.length;r++)for(var c=0;c<l.repeat.length;c++){var u=l.lines[r];o.beginPath(),o.moveTo(u[0]+l.repeat[c][0],u[1]+l.repeat[c][1]);for(var d=2;d<u.length;d+=2)o.lineTo(u[d]+l.repeat[c][0],u[d+1]+l.repeat[c][1]);l.fill&&o.fill(),l.stroke&&o.stroke(),o.save(),o.strokeStyle="red",o.strokeWidth=.1,o.restore()}if(t=o.createPattern(i,"repeat"),e.offset){var p=e.offset;if("number"==typeof p&&(p=[p,p]),p instanceof Array){var g=Math.round(p[0]*s),m=Math.round(p[1]*s);o.scale(1/s,1/s),o.clearRect(0,0,i.width,i.height),o.translate(g,m),o.fillStyle=t,o.fillRect(-g,-m,i.width,i.height),t=o.createPattern(i,"repeat")}}}this.setColor(t)}static addPattern(e,t){t||(t={}),ol.style.FillPattern.patterns[e||t.char]={width:t.width||t.size||10,height:t.height||t.size||10,font:t.font,char:t.char,circles:t.circles,lines:t.lines,repeat:t.repeat,stroke:t.stroke,angle:t.angle,fill:t.fill}}clone(){var e=super.clone();return e.canvas_=this.canvas_,e}getImage(){return this.canvas_}getPattern_(e){var t,i=ol.style.FillPattern.patterns[e.pattern]||ol.style.FillPattern.patterns.dot,s=Math.round(e.spacing)||10;switch(e.pattern){case"dot":case"circle":t=0===e.size?0:e.size/2||2,e.angle?(s=i.width=i.height=Math.round(1.4*s),i.circles=[[s/4,s/4,t],[3*s/4,3*s/4,t]],"circle"==e.pattern&&(i.circles=i.circles.concat([[s/4+s,s/4,t],[s/4,s/4+s,t],[3*s/4-s,3*s/4,t],[3*s/4,3*s/4-s,t],[s/4+s,s/4+s,t],[3*s/4-s,3*s/4-s,t]]))):(i.width=i.height=s,i.circles=[[s/2,s/2,t]],"circle"==e.pattern&&(i.circles=i.circles.concat([[s/2+s,s/2,t],[s/2-s,s/2,t],[s/2,s/2+s,t],[s/2,s/2-s,t],[s/2+s,s/2+s,t],[s/2+s,s/2-s,t],[s/2-s,s/2+s,t],[s/2-s,s/2-s,t]])));break;case"tile":case"square":t=0===e.size?0:e.size/2||2,e.angle?(i.width=i.height=s,i.lines=[[s/2-t,s/2,s/2,s/2-t,s/2+t,s/2,s/2,s/2+t,s/2-t,s/2]]):(i.width=i.height=s,i.lines=[[s/2-t,s/2-t,s/2+t,s/2-t,s/2+t,s/2+t,s/2-t,s/2+t,s/2-t,s/2-t]]),"square"==e.pattern&&(i.repeat=[[0,0],[0,s],[s,0],[0,-s],[-s,0],[-s,-s],[s,s],[-s,s],[s,-s]]);break;case"cross":e.angle&&(e.angle=45);case"hatch":var o=Math.round(((e.angle||0)-90)%360);o>180&&(o-=360),o*=Math.PI/180;var r=Math.cos(o),a=Math.sin(o);if(Math.abs(a)<1e-4)i.width=i.height=s,i.lines=[[0,.5,s,.5]],i.repeat=[[0,0],[0,s]];else if(Math.abs(r)<1e-4)i.width=i.height=s,i.lines=[[.5,0,.5,s]],i.repeat=[[0,0],[s,0]],"cross"==e.pattern&&(i.lines.push([0,.5,s,.5]),i.repeat.push([0,s]));else{var n=i.width=Math.round(Math.abs(s/a))||1,l=i.height=Math.round(Math.abs(s/r))||1;"cross"==e.pattern?(i.lines=[[-n,-l,2*n,2*l],[2*n,-l,-n,2*l]],i.repeat=[[0,0]]):r*a>0?(i.lines=[[-n,-l,2*n,2*l]],i.repeat=[[0,0],[n,0],[0,l]]):(i.lines=[[2*n,-l,-n,2*l]],i.repeat=[[0,0],[-n,0],[0,l]])}i.stroke=0===e.size?0:e.size||4}return i}},ol.style.FillPattern.patterns={hatch:{width:5,height:5,lines:[[0,2.5,5,2.5]],stroke:1},cross:{width:7,height:7,lines:[[0,3,10,3],[3,0,3,10]],stroke:1},dot:{width:8,height:8,circles:[[5,5,2]],stroke:!1,fill:!0},circle:{width:10,height:10,circles:[[5,5,2]],stroke:1,fill:!1},square:{width:10,height:10,lines:[[3,3,3,8,8,8,8,3,3,3]],stroke:1,fill:!1},tile:{width:10,height:10,lines:[[3,3,3,8,8,8,8,3,3,3]],fill:!0},woven:{width:12,height:12,lines:[[3,3,9,9],[0,12,3,9],[9,3,12,0],[-1,1,1,-1],[13,11,11,13]],stroke:1},crosses:{width:8,height:8,lines:[[2,2,6,6],[2,6,6,2]],stroke:1},caps:{width:8,height:8,lines:[[2,6,4,2,6,6]],stroke:1},nylon:{width:20,height:20,lines:[[1,6,1,1,6,1],[6,11,11,11,11,6],[11,16,11,21,16,21],[16,11,21,11,21,16]],repeat:[[0,0],[-20,0],[0,-20]],stroke:1},hexagon:{width:20,height:12,lines:[[0,10,4,4,10,4,14,10,10,16,4,16,0,10]],stroke:1,repeat:[[0,0],[10,6],[10,-6],[-10,-6]]},cemetry:{width:15,height:19,lines:[[0,3.5,7,3.5],[3.5,0,3.5,10]],stroke:1,repeat:[[0,0],[7,9]]},sand:{width:20,height:20,circles:[[1,2,1],[9,3,1],[2,16,1],[7,8,1],[6,14,1],[4,19,1],[14,2,1],[12,10,1],[14,18,1],[18,8,1],[18,14,1]],fill:1},conglomerate:{width:60,height:40,circles:[[2,4,1],[17,3,1],[26,18,1],[12,17,1],[5,17,2],[28,11,2]],lines:[[7,5,6,7,9,9,11,8,11,6,9,5,7,5],[16,10,15,13,16,14,19,15,21,13,22,9,20,8,19,8,16,10],[24,6,26,7,27,5,26,4,24,4,24,6]],repeat:[[30,0],[-15,20],[15,20],[45,20]],stroke:1},conglomerate2:{width:60,height:40,circles:[[2,4,1],[17,3,1],[26,18,1],[12,17,1],[5,17,2],[28,11,2]],lines:[[7,5,6,7,9,9,11,8,11,6,9,5,7,5],[16,10,15,13,16,14,19,15,21,13,22,9,20,8,19,8,16,10],[24,6,26,7,27,5,26,4,24,4,24,6]],repeat:[[30,0],[-15,20],[15,20],[45,20]],fill:1},gravel:{width:15,height:10,circles:[[4,2,1],[5,9,1],[1,7,1]],lines:[[7,5,6,6,7,7,8,7,9,7,10,5,9,4,7,5],[11,2,14,4,14,1,12,1,11,2]],stroke:1},brick:{width:18,height:16,lines:[[0,1,18,1],[0,10,18,10],[6,1,6,10],[12,10,12,18],[12,0,12,1]],stroke:1},dolomite:{width:20,height:16,lines:[[0,1,20,1],[0,9,20,9],[1,9,6,1],[11,9,14,16],[14,0,14.4,1]],stroke:1},coal:{width:20,height:16,lines:[[1,5,7,1,7,7],[11,10,12,5,18,9],[5,10,2,15,9,15],[15,16,15,13,20,16],[15,0,15,2,20,0]],fill:1},breccia:{width:20,height:16,lines:[[1,5,7,1,7,7,1,5],[11,10,12,5,18,9,11,10],[5,10,2,15,9,15,5,10],[15,16,15,13,22,18],[15,0,15,2,20,0]],stroke:1},clay:{width:20,height:20,lines:[[0,0,3,11,0,20],[11,0,10,3,13,13,11,20],[0,0,10,3,20,0],[0,12,3,11,13,13,20,12]],stroke:1},flooded:{width:15,height:10,lines:[[0,1,10,1],[0,6,5,6],[10,6,15,6]],stroke:1},chaos:{width:40,height:40,lines:[[40,2,40,0,38,0,40,2],[4,0,3,2,2,5,0,0,0,3,2,7,5,6,7,7,8,10,9,12,9,13,9,14,8,14,6,15,2,15,0,20,0,22,2,20,5,19,8,15,10,14,11,12.25,10,12,10,10,12,9,13,7,12,6,13,4,16,7,17,4,20,0,18,0,15,3,14,2,14,0,12,1,11,0,10,1,11,4,10,7,9,8,8,5,6,4,5,3,5,1,5,0,4,0],[7,1,7,3,8,3,8,2,7,1],[4,3,5,5,4,5,4,3],[34,5,33,7,38,10,38,8,36,5,34,5],[27,0,23,2,21,8,30,0,27,0],[25,8,26,12,26,16,22.71875,15.375,20,13,18,15,17,18,13,22,17,21,19,22,21,20,19,18,22,17,30,25,26,26,24,28,21.75,33.34375,20,36,18,40,20,40,24,37,25,32,27,31,26,38,27,37,30,32,32,35,36,37,38,40,38,39,40,40,37,36,34,32,37,31,36,29,33,27,34,24,39,21,40,21,40,16,37,20,31,22,32,25,27,20,29,15,30,20,32,20,34,18,33,12,31,11,29,14,26,9,25,8],[39,24,37,26,40,28,39,24],[13,15,9,19,14,18,13,15],[18,23,14,27,16,27,17,25,20,26,18,23],[6,24,2,26,1,28,2,30,5,28,12,30,16,32,18,30,15,30,12,28,9,25,7,27,6,24],[29,27,32,28,33,31,30,29,27,28,29,27],[5,35,1,33,3,36,13,38,15,35,10,36,5,35]],fill:1},grass:{width:27,height:22,lines:[[0,10.5,13,10.5],[2.5,10,1.5,7],[4.5,10,4.5,5,3.5,4],[7,10,7.5,6,8.5,3],[10,10,11,6]],repeat:[[0,0],[14,10]],stroke:1},swamp:{width:24,height:23,lines:[[0,10.5,9.5,10.5],[2.5,10,2.5,7],[4.5,10,4.5,4],[6.5,10,6.5,6],[3,12.5,7,12.5]],repeat:[[0,0],[14,10]],stroke:1},reed:{width:26,height:23,lines:[[2.5,10,2,7],[4.5,10,4.2,4],[6.5,10,6.8,4],[8.5,10,9,6],[3.7,4,3.7,2.5],[4.7,4,4.7,2.5],[6.3,4,6.3,2.5],[7.3,4,7.3,2.5]],circles:[[4.2,2.5,.5],[18.2,12.5,.5],[6.8,2.5,.5],[20.8,12.5,.5],[9,6,.5],[23,16,.5]],repeat:[[0,0],[14,10]],stroke:1},wave:{width:10,height:8,lines:[[0,0,5,4,10,0]],stroke:1},vine:{width:13,height:13,lines:[[3,0,3,6],[9,7,9,13]],stroke:1},forest:{width:55,height:30,circles:[[7,7,3.5],[20,20,1.5],[42,22,3.5],[35,5,1.5]],stroke:1},forest2:{width:55,height:30,circles:[[7,7,3.5],[20,20,1.5],[42,22,3.5],[35,5,1.5]],fill:1,stroke:1},scrub:{width:26,height:20,lines:[[1,4,4,8,6,4]],circles:[[20,13,1.5]],stroke:1},tree:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78]],repeat:[[3,1],[18,16]],stroke:1},tree2:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78,4.95,10.61,7.78,10.61]],repeat:[[3,1],[18,16]],fill:1,stroke:1},pine:{width:30,height:30,lines:[[5.66,11.31,2.83,11.31,2.83,8.49,0,8.49,2.83,0,5.66,8.49,2.83,8.49]],repeat:[[3,1],[18,16]],stroke:1},pine2:{width:30,height:30,lines:[[5.66,11.31,2.83,11.31,2.83,8.49,0,8.49,2.83,0,5.66,8.49,2.83,8.49,2.83,11.31,5.66,11.31]],repeat:[[3,1],[18,16]],fill:1,stroke:1},mixtree:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78,4.95,10.61,7.78,10.61],[23.66,27.31,20.83,27.31,20.83,24.49,18,24.49,20.83,16,23.66,24.49,20.83,24.49,20.83,27.31,23.66,27.31]],repeat:[[3,1]],stroke:1},mixtree2:{width:30,height:30,lines:[[7.78,10.61,4.95,10.61,4.95,7.78,3.54,7.78,2.12,6.36,.71,6.36,0,4.24,.71,2.12,4.24,0,7.78,.71,9.19,3.54,7.78,4.95,7.07,7.07,4.95,7.78,4.95,10.61,7.78,10.61],[23.66,27.31,20.83,27.31,20.83,24.49,18,24.49,20.83,16,23.66,24.49,20.83,24.49,20.83,27.31,23.66,27.31]],repeat:[[3,1]],fill:1,stroke:1},pines:{width:22,height:20,lines:[[1,4,3.5,1,6,4],[1,8,3.5,5,6,8],[3.5,1,3.5,11],[12,14.5,14.5,14,17,14.5],[12,18,17,18],[14.5,12,14.5,18]],repeat:[[2,1]],stroke:1},rock:{width:20,height:20,lines:[[1,0,1,9],[4,0,4,9],[7,0,7,9],[10,1,19,1],[10,4,19,4],[10,7,19,7],[0,11,9,11],[0,14,9,14],[0,17,9,17],[12,10,12,19],[15,10,15,19],[18,10,18,19]],repeat:[[.5,.5]],stroke:1},rocks:{width:20,height:20,lines:[[5,0,3,0,5,4,4,6,0,3,0,5,3,6,5,9,3.75,10,2.5,10,0,9,0,10,4,11,5,14,4,15,0,13,0,13,0,13,0,14,0,14,5,16,5,18,3,19,0,19,-.25,19.9375,5,20,10,19,10,20,11,20,12,19,14,20,15,20,17,19,20,20,20,19,19,16,20,15,20,11,20,10,19,8,20,5,20,0,19,0,20,2,19,4,17,4,16,3,15,0,14,0,15,4,11,5,10,4,11,0,10,0,9,4,6,5,5,0],[18,5,19,6,18,10,16,10,14,9,16,5,18,5],[5,6,9,5,10,6,10,9,6,10,5,6],[14,5,14,8,13,9,12,9,11,7,12,5,14,5],[5,11,8,10,9,11,10,14,6,15,6,15,5,11],[13,10,14,11,15,14,15,14,15,14,11,15,10,11,11,10,13,10],[15,12,16,11,19,11,19,15,16,14,16,14,15,12],[6,16,9,15,10,18,5,19,6,16],[10,16,14,16,14,18,13,19,11,18,10,16],[15,15,18,16,18,18,16,19,15,18,15,15]],stroke:1}},ol.style.FlowLine=class extends ol.style.Style{constructor(e){super({stroke:(e=e||{}).stroke,text:e.text,zIndex:e.zIndex,geometry:e.geometry}),this.setRenderer(this._render.bind(this)),this._visible=!1!==e.visible,"function"==typeof e.width?this._widthFn=e.width:this.setWidth(e.width),this.setWidth2(e.width2),"function"==typeof e.color?this._colorFn=e.color:this.setColor(e.color),this.setColor2(e.color2),this.setLineCap(e.lineCap),this.setArrow(e.arrow),this.setArrowSize(e.arrowSize),this.setArrowColor(e.arrowColor),this._offset=[0,0],this.setOffset(e.offset0,0),this.setOffset(e.offset1,1),this._noOverlap=e.noOverlap}setWidth(e){this._width=e||0}setWidth2(e){this._width2=e}getOffset(e){return this._offset[e]}setOffset(e,t){switch(e=Math.max(0,parseFloat(e)),t){case 0:this._offset[0]=e;break;case 1:this._offset[1]=e}}setLineCap(e){this._lineCap="round"===e?"round":"butt"}getWidth(e,t){if(this._widthFn)return this._widthFn(e,t);var i="number"==typeof this._width2?this._width2:this._width;return this._width+(i-this._width)*t}setColor(e){try{this._color=ol.color.asArray(e)}catch(e){this._color=[0,0,0,1]}}setColor2(e){try{this._color2=ol.color.asArray(e)}catch(e){this._color2=null}}setArrowColor(e){try{this._acolor=ol.color.asString(e)}catch(e){this._acolor=null}}getColor(e,t){if(this._colorFn)return ol.color.asString(this._colorFn(e,t));var i=this._color,s=this._color2||this._color;return"rgba("+ +Math.round(i[0]+(s[0]-i[0])*t)+","+Math.round(i[1]+(s[1]-i[1])*t)+","+Math.round(i[2]+(s[2]-i[2])*t)+","+(i[3]+(s[3]-i[3])*t)+")"}getArrow(){return this._arrow}setArrow(e){this._arrow=parseInt(e),(this._arrow<-1||this._arrow>2)&&(this._arrow=0)}getArrowSize(){return this._arrowSize||[16,16]}setArrowSize(e){Array.isArray(e)?this._arrowSize=e:"number"==typeof e&&(this._arrowSize=[e,e])}drawArrow(e,t,i,s,o){var r=this.getArrowSize()[0]*o,a=ol.coordinate.dist2d(t,i),n=(t[0]-i[0])/a,l=(t[1]-i[1])/a;s=Math.max(this.getArrowSize()[1]/2,s/2)*o,e.beginPath(),e.moveTo(t[0],t[1]),e.lineTo(t[0]-r*n+s*l,t[1]-r*l-s*n),e.lineTo(t[0]-r*n-s*l,t[1]-r*l+s*n),e.lineTo(t[0],t[1]),e.fill()}_render(e,t){if("LineString"===t.geometry.getType()){var i,s,o,r=t.context;if(!this._visible){var a=t.pixelRatio/t.resolution,n=Math.cos(t.rotation),l=Math.sin(t.rotation);s=t.geometry.getCoordinates();var h=e[0][0]-s[0][0]*a*n-s[0][1]*a*l,c=e[0][1]-s[0][0]*a*l+s[0][1]*a*n;for(e=[],i=0;o=s[i];i++)e[i]=[h+o[0]*a*n+o[1]*a*l,c+o[0]*a*l-o[1]*a*n,o[2]]}var u=this.getArrowSize()[0]*t.pixelRatio;r.save(),this.getOffset(0)&&this._splitAsize(e,this.getOffset(0)*t.pixelRatio),this.getOffset(1)&&this._splitAsize(e,this.getOffset(1)*t.pixelRatio,!0),e.length>1&&(-1===this.getArrow()||2===this.getArrow())&&(o=this._splitAsize(e,u),this._acolor?r.fillStyle=this._acolor:r.fillStyle=this.getColor(t.feature,0),this.drawArrow(r,o[0],o[1],this.getWidth(t.feature,0),t.pixelRatio)),e.length>1&&this.getArrow()>0&&(o=this._splitAsize(e,u,!0),this._acolor?r.fillStyle=this._acolor:r.fillStyle=this.getColor(t.feature,1),this.drawArrow(r,o[0],o[1],this.getWidth(t.feature,1),t.pixelRatio));var d=this._splitInto(e,255,2),p=0,g=d.length;if(r.lineJoin="round",r.lineCap=this._lineCap||"butt",d.length>1)for(p=0;p<d.length;p++){var m=p/g;for(s=d[p],r.lineWidth=this.getWidth(t.feature,m)*t.pixelRatio,r.strokeStyle=this.getColor(t.feature,m),r.beginPath(),r.moveTo(s[0][0],s[0][1]),i=1;o=s[i];i++)r.lineTo(o[0],o[1]);r.stroke()}r.restore()}}_splitAsize(e,t,i){var s,o,r,a,n=0;for(s=r=i?e.pop():e.shift();e.length;){if(o=i?e.pop():e.shift(),n+(a=ol.coordinate.dist2d(s,o))>t){s=[s[0]+(o[0]-s[0])*(t-n)/a,s[1]+(o[1]-s[1])*(t-n)/a],a=ol.coordinate.dist2d(s,r),i?(e.push(o),e.push(s),e.push([s[0]+(r[0]-s[0])/a,s[1]+(r[1]-s[1])/a])):(e.unshift(o),e.unshift(s),e.unshift([s[0]+(r[0]-s[0])/a,s[1]+(r[1]-s[1])/a]));break}n+=a,s=o}return[r,s]}_splitInto(e,t,i){var s,o,r,a=this._noOverlap?1:.9,n=[],l=0;for(s=1;o=e[s];s++)l+=ol.coordinate.dist2d(e[s-1],o);var h=Math.max(i||2,l/(t||255)),c=e[0];l=0;var u=[c];for(s=1,o=e[1];s<e.length;){var d=o[0]-c[0],p=o[1]-c[1];if(l+(r=Math.sqrt(d*d+p*p))>h){var g=(h-l)/r;u.push([c[0]+d*g,c[1]+p*g]),n.push(u),u=[c=[c[0]+d*g*a,c[1]+p*g*a]],l=0}else l+=r,c=o,u.push(c),o=e[++s]}return n.push(u),n}},ol.style.FontSymbol=class extends ol.style.RegularShape{constructor(e){var t=0;(e=e||{}).stroke&&(t=e.stroke.getWidth()),e.displacement||(e.displacement=[e.offsetX||0,-e.offsetY||0]),super({radius:e.radius,fill:e.fill,scale:e.scale,rotation:e.rotation,displacement:e.displacement,rotateWithView:e.rotateWithView,declutterMode:e.declutterMode}),"number"==typeof e.opacity&&this.setOpacity(e.opacity),this._color=e.color,this._fontSize=e.fontSize||1,this._fontStyle=e.fontStyle||"",this._stroke=e.stroke,this._fill=e.fill,this._radius=e.radius-t,this._form=e.form||"none",this._gradient=e.gradient,this._offset=[e.offsetX?e.offsetX:0,e.offsetY?e.offsetY:0],e.glyph?this._glyph=this.getGlyph(e.glyph):this._glyph=this.getTextGlyph(e.text||"",e.font),this.getDisplacement||this.getImage(),this.render()}static addDefs(e,t){var i=e;if("string"==typeof e&&(i={font:e,name:e,copyright:""}),i.font&&"string"==typeof i.font){var s=i.font;for(var o in ol.style.FontSymbol.defs.fonts[s]=i,t){var r=t[o];"string"!=typeof r||1!=r.length&&2!=r.length||(r={char:r}),ol.style.FontSymbol.defs.glyphs[o]={font:i.font,char:r.char||""+String.fromCodePoint(r.code)||"",theme:r.theme||i.name,name:r.name||o,search:r.search||""}}}else console.log("bad font def")}clone(){var e=new ol.style.FontSymbol({text:this._glyph.char,font:this._glyph.font,color:this._color,fontSize:this._fontSize,fontStyle:this._fontStyle,stroke:this._stroke,fill:this._fill,radius:this._radius+(this._stroke?this._stroke.getWidth():0),form:this._form,gradient:this._gradient,offsetX:this._offset[0],offsetY:this._offset[1],opacity:this.getOpacity(),rotation:this.getRotation(),rotateWithView:this.getRotateWithView(),declutterMode:this.getDeclutterMode?this.getDeclutterMode():null});return e.setScale(this.getScale()),e}getFill(){return this._fill}getStroke(){return this._stroke}getGlyph(e){return e?ol.style.FontSymbol.defs.glyphs[e]||{font:"sans-serif",char:e.charAt(0),theme:"none",name:"none",search:""}:this._glyph}getTextGlyph(e,t){return{font:t||"sans-serif",char:String(e),theme:"none",name:"none",search:""}}getGlyphName(){for(var e in ol.style.FontSymbol.defs.glyphs)if(ol.style.FontSymbol.defs.glyphs[e]===this._glyph)return e;return""}getFontInfo(e){return ol.style.FontSymbol.defs.fonts[e.font]}createRenderOptions(){var e=super.createRenderOptions(),t="none";return this._stroke&&(t=[ol.color.asString(this._stroke.getColor()||"#000"),this._stroke.getWidth()||0,this._stroke.getLineDash(),this._stroke.getLineDashOffset()||0,this._stroke.getLineJoin(),this._stroke.getLineCap(),this._stroke.getMiterLimit()].join("-")),e.fontsymbolOptions=["font-symbol",this._color,this._fontSize,this._fontStyle,t,this._fill?ol.color.asString(this._fill.getColor()||""):"",this._radius,this._form,this._gradient,(this._offset||[]).join(","),Object.values(this._glyph||[]).join(",")].join("-"),e}getImage(e){e=e||1;var t,i=super.getImage(e),s=0;this._stroke&&(t=ol.color.asString(this._stroke.getColor()),s=this._stroke.getWidth());var o={strokeStyle:t,strokeWidth:s,size:i.width/e},r=i.getContext("2d");if(r.clearRect(0,0,i.width,i.height),this.drawMarker_(o,r,0,0,e),!this.getDisplacement){var a=this.getAnchor();a[0]=i.width/2-this._offset[0],a[1]=i.width/2-this._offset[1]}return i}drawPath_(e,t){var i=2*this._radius+e.strokeWidth,s=e.strokeWidth/2,o=e.size/2,r={fac:1,posX:e.size/2,posY:e.size/2};switch(t.lineJoin="round",t.lineCap="round",t.beginPath(),this._form){case"none":r.fac=1;break;case"circle":case"ban":t.arc(o,o,i/2,0,2*Math.PI,!0);break;case"poi":t.arc(o,o-.4*this._radius,.6*this._radius,.15*Math.PI,.85*Math.PI,!0),t.lineTo(o-.89*.05*i,(.95+.45*.05)*i+s),t.arc(o,.95*i+s,.05*i,.85*Math.PI,.15*Math.PI,!0),r={fac:.45,posX:o,posY:o-.35*this._radius};break;case"bubble":t.arc(o,o-.2*this._radius,.8*this._radius,.4*Math.PI,.6*Math.PI,!0),t.lineTo(.5*i+s,i+s),r={fac:.7,posX:o,posY:o-.2*this._radius};break;case"marker":t.arc(o,o-.2*this._radius,.8*this._radius,.25*Math.PI,.75*Math.PI,!0),t.lineTo(.5*i+s,i+s),r={fac:.7,posX:o,posY:o-.2*this._radius};break;case"coma":t.moveTo(o+.8*this._radius,o-.2*this._radius),t.quadraticCurveTo(.95*i+s,.75*i+s,.5*i+s,i+s),t.arc(o,o-.2*this._radius,.8*this._radius,.45*Math.PI,0,!1),r={fac:.7,posX:o,posY:o-.2*this._radius};break;default:var a;switch(this._form){case"shield":a=[.05,0,.95,0,.95,.8,.5,1,.05,.8,.05,0],r.posY=.45*i+s;break;case"blazon":a=[.1,0,.9,0,.9,.8,.6,.8,.5,1,.4,.8,.1,.8,.1,0],r.fac=.8,r.posY=.4*i+s;break;case"bookmark":a=[.05,0,.95,0,.95,1,.5,.8,.05,1,.05,0],r.fac=.9,r.posY=.4*i+s;break;case"hexagon":a=[.05,.2,.5,0,.95,.2,.95,.8,.5,1,.05,.8,.05,.2],r.fac=.9,r.posY=.5*i+s;break;case"diamond":a=[.25,0,.75,0,1,.2,1,.4,.5,1,0,.4,0,.2,.25,0],r.fac=.75,r.posY=.35*i+s;break;case"triangle":a=[0,0,1,0,.5,1,0,0],r.fac=.6,r.posY=.3*i+s;break;case"sign":a=[.5,.05,1,.95,0,.95,.5,.05],r.fac=.7,r.posY=.65*i+s;break;case"lozenge":a=[.5,0,1,.5,.5,1,0,.5,.5,0],r.fac=.7;break;case"square":default:a=[0,0,1,0,1,1,0,1,0,0]}for(var n=0;n<a.length;n+=2)t.lineTo(a[n]*i+s,a[n+1]*i+s)}return t.closePath(),r}drawMarker_(e,t,i,s,o){var r=this._fill?this._fill.getColor():"#000",a=this._stroke?this._stroke.getColor():"#000";"none"==this._form&&this._stroke&&this._fill&&(a=this._fill.getColor(),r=this._stroke.getColor()),t.setTransform(o,0,0,o,0,0),t.translate(i,s);var n=this.drawPath_(e,t,o);if(this._fill){if(this._gradient&&"none"!=this._form){var l=t.createLinearGradient(0,0,e.size/2,e.size);l.addColorStop(1,ol.color.asString(r)),l.addColorStop(0,ol.color.asString(a)),t.fillStyle=l}else t.fillStyle=ol.color.asString(r);t.fill()}if(this._stroke&&e.strokeWidth&&(t.strokeStyle=e.strokeStyle,t.lineWidth=e.strokeWidth,t.stroke()),this._glyph.char){t.font=this._fontStyle+" "+2*n.fac*this._radius*this._fontSize+"px "+this._glyph.font,t.strokeStyle=t.fillStyle,t.lineWidth=e.strokeWidth*("none"==this._form?2:1),t.fillStyle=ol.color.asString(this._color||a),t.textAlign="center",t.textBaseline="middle";var h=this._glyph.char;e.strokeWidth&&"transparent"!=a&&t.strokeText(h,n.posX,n.posY),t.fillText(h,n.posX,n.posY)}if("ban"==this._form&&this._stroke&&e.strokeWidth){t.strokeStyle=e.strokeStyle,t.lineWidth=e.strokeWidth;var c=this._radius+e.strokeWidth,u=this._radius*Math.cos(Math.PI/4);t.moveTo(c+u,c-u),t.lineTo(c-u,c+u),t.stroke()}}getChecksum(){var e=null!==this._stroke?this._stroke.getChecksum():"-",t=null!==this._fill?this._fill.getChecksum():"-";if(null===this.checksums_||e!=this.checksums_[1]||t!=this.checksums_[2]||this._radius!=this.checksums_[3]||this._form+"-"+this.glyphs_!=this.checksums_[4]){var i="c"+e+t+(void 0!==this._radius?this._radius.toString():"-")+this._form+"-"+this.glyphs_;this.checksums_=[i,e,t,this._radius,this._form+"-"+this.glyphs_]}return this.checksums_[0]}},ol.style.FontSymbol.defs={fonts:{},glyphs:{}},ol.style.Photo=class extends ol.style.RegularShape{constructor(e){(e=e||{}).displacement||(e.displacement=[e.offsetX||0,-e.offsetY||0]);var t="anchored"===e.kind?8:0,i=Number(e.shadow)||0;e.stroke||(e.stroke=new ol.style.Stroke({width:0,color:"#000"}));var s=e.stroke.getWidth();if(s<0&&(s=0),"folio"==e.kind&&(s+=6),e.stroke.setWidth(s),super({radius:e.radius+s+t/2+i/2,points:0,displacement:[e.displacement[0]||0,(e.displacement[1]||0)+t],fill:ol.style.RegularShape.prototype.render?new ol.style.Fill({color:[0,0,0,0]}):null,declutterMode:e.declutterMode}),this.sanchor_=t,this._shadow=i,!this.getHitDetectionImage){var o=super.getImage.call(this);if(!this.hitDetectionCanvas_)for(var r in this)if(this[r]&&this[r].getContext&&this[r]!==o){this.hitDetectionCanvas_=this[r];break}this.hitDetectionCanvas_=document.createElement("canvas"),this.hitDetectionCanvas_.width=o.width,this.hitDetectionCanvas_.height=o.height;var a=this.hitDetectionCanvas_;this.getHitDetectionImage=function(){return a}}this._stroke=e.stroke,this._fill=e.fill,this._crop=e.crop,this._crossOrigin=e.crossOrigin,this._kind=e.kind||"default",this._radius=e.radius,this._src=e.src,this._offset=[e.offsetX?e.offsetX:0,e.offsetY?e.offsetY:0],this._onload=e.onload,this._onerror=e.onerror,"number"==typeof e.opacity&&this.setOpacity(e.opacity),"number"==typeof e.rotation&&this.setRotation(e.rotation),this.render(),this.getImage()}setOffset(e){this._offset=[e[0]||0,e[1]||0],this.render(),this.getImage()}clone(){var e=new ol.style.Photo({stroke:this._stroke,fill:this._fill,shadow:this._shadow,crop:this._crop,crossOrigin:this._crossOrigin,kind:this._kind,radius:this._radius,src:this._src,offsetX:this._offset[0],offsetY:this._offset[1],opacity:this.getOpacity(),rotation:this.getRotation(),declutterMode:this.getDeclutterMode?this.getDeclutterMode():null});return e.render(),e.getImage(),e}drawBack_(e,t,i,s){var o=this._shadow,r=e.canvas;e.beginPath(),e.fillStyle=t,e.clearRect(0,0,r.width,r.height);var a=r.width/s,n=r.height/s;switch(this._kind){case"square":e.rect(0,0,a-o,n-o);break;case"circle":e.arc(this._radius+i,this._radius+i,this._radius+i,0,2*Math.PI,!1);break;case"folio":i-=6,e.strokeStyle="rgba(0,0,0,0.5)",e.lineWidth=1;var l=a-o-12,h=Math.atan(6/l);e.save(),e.rotate(-h),e.translate(-6,2),e.beginPath(),e.rect(6,6,l,l),e.stroke(),e.fill(),e.restore(),e.save(),e.translate(6,-1),e.rotate(h),e.beginPath(),e.rect(6,6,l,l),e.stroke(),e.fill(),e.restore(),e.beginPath(),e.rect(6,6,l,l),e.stroke();break;case"anchored":e.roundRect(this.sanchor_/2,0,a-this.sanchor_-o,n-this.sanchor_-o,i),e.moveTo(a/2-this.sanchor_-o/2,n-this.sanchor_-o),e.lineTo(a/2+this.sanchor_-o/2,n-this.sanchor_-o),e.lineTo(a/2-o/2,n-o);break;default:e.roundRect(0,0,a-o,n-o,i)}e.closePath()}createRenderOptions(){var e=super.createRenderOptions();return e.photoOptions=["photo",this._crossOrigin,this._crop,this._src,this._shadow,this._kind].join("-"),e}getImage(e){e=e||window.devicePixelRatio;var t,i=super.getImage(e);if((this._gethit||this.img_)&&this._currentRatio===e)return i;this._currentRatio=e;var s=0;this._stroke&&(t=ol.color.asString(this._stroke.getColor()),s=this._stroke.getWidth()),this._gethit=!0;var o=this.getHitDetectionImage().getContext("2d");o.save(),o.setTransform(1,0,0,1,0,0),this.drawBack_(o,"#000",s,1),o.fill(),o.restore(),this._gethit=!1,(o=i.getContext("2d")).save(),o.setTransform(e,0,0,e,0,0),this.drawBack_(o,t,s,e),this._shadow&&(o.shadowColor="rgba(0,0,0,0.5)",o.shadowBlur=e*this._shadow/2,o.shadowOffsetX=e*this._shadow/2,o.shadowOffsetY=e*this._shadow/2),o.fill(),o.restore();var r=this,a=this.img_=new Image;if(this._crossOrigin&&(a.crossOrigin=this._crossOrigin),a.src=this._src,a.width?r.drawImage_(i,a,e):(a.onload=function(){r.drawImage_(i,a,e),r._onload&&r._onload()},r._onerror&&(a.onerror=function(){r._onerror()})),!this.getDisplacement){var n=this.getAnchor();n[0]=(i.width/e-this._shadow)/2-this._offset[0],this.sanchor_?n[1]=i.height/e-this._shadow-this._offset[1]:n[1]=(i.height/e-this._shadow)/2-this._offset[1]}return i}getPhoto(){return this.img_}drawImage_(e,t,i){var s=e.getContext("2d"),o=0;this._stroke&&(o=this._stroke.getWidth());var r,a,n,l,h,c,u,d,p,g=2*this._radius;s.save(),ol.style.RegularShape.prototype.render&&s.setTransform(i,0,0,i,0,0),"circle"==this._kind&&(s.beginPath(),s.arc(this._radius+o,this._radius+o,this._radius,0,2*Math.PI,!1),s.clip()),this._crop?(d=p=(r=Math.min(t.width/g,t.height/g))*g,c=(t.width-d)/2,u=(t.height-p)/2,a=n=0,l=h=g+1):(c=u=0,a=(g-(l=(r=Math.min(g/t.width,g/t.height))*(d=t.width)))/2,n=(g-(h=r*(p=t.height)))/2),a+=o+this.sanchor_/2,n+=o,s.drawImage(t,c,u,d,p,a,n,l,h),"circle"==this._kind&&o&&(s.beginPath(),s.strokeStyle=ol.color.asString(this._stroke.getColor()),s.lineWidth=o/4,s.arc(this._radius+o,this._radius+o,this._radius,0,2*Math.PI,!1),s.stroke()),s.restore()}},CanvasRenderingContext2D.prototype.roundRect=function(e,t,i,s,o){return o?(i<2*o&&(o=i/2),s<2*o&&(o=s/2),this.beginPath(),this.moveTo(e+o,t),this.arcTo(e+i,t,e+i,t+s,o),this.arcTo(e+i,t+s,e,t+s,o),this.arcTo(e,t+s,e,t,o),this.arcTo(e,t,e+i,t,o),this.closePath()):this.rect(e,t,i,s),this},ol.style.Profile=class extends ol.style.Style{constructor(e){super({zIndex:(e=e||{}).zIndex,geometry:e.geometry}),this.setRenderer(this._render.bind(this)),this.setStroke(e.stroke),this.setFill(e.fill),this.setScale(e.scale)}setStroke(e){this._stroke=e||new ol.style.Stroke({color:"#fff",width:1})}getStroke(){return this._stroke}setFill(e){this._fill=e||new ol.style.Fill({color:"rgba(255,255,255,.3"})}getFill(){return this._fill}setScale(e){this._scale=e||.2}getScale(){return this._scale}_render(e,t){if(/Z/.test(t.feature.getGeometry().getLayout())){var i=t.geometry.getCoordinates();switch(t.geometry.getType()){case"LineString":this._renderLine(e,i,t.feature.getGeometry(),t);break;case"MultiLineString":t.feature.getGeometry().getLineStrings().forEach(function(s,o){this._renderLine(e[o],i[o],s,t)}.bind(this))}}}_renderLine(e,t,i,s){var o,r,a=s.context,n=parseFloat(ol.util.VERSION)>9.1?1:Math.cos(s.rotation),l=parseFloat(ol.util.VERSION)>9.1?0:Math.sin(s.rotation),h=ol.coordinate.dist2d(e[0],e[1])/ol.coordinate.dist2d(t[0],t[1]),c=e[0][0]-t[0][0]*h*n-t[0][1]*h*l,u=e[0][1]-t[0][0]*h*l+t[0][1]*h*n;e=i.getCoordinates();var d=1/0;for(o=0;r=e[o];o++){var p=c+r[0]*h*n+r[1]*h*l,g=u+r[0]*h*l-r[1]*h*n;d=Math.min(d,r[2]),e[o]=[p,g,r[2]]}a.save(),a.fillStyle=ol.color.asString(this.getFill().getColor()),a.strokeStyle=ol.color.asString(this.getStroke().getColor()),a.lineWidth=this.getStroke().getWidth();var m=e[0],f=this.getScale()*s.pixelRatio;for(o=1;r=e[o];o++)a.beginPath(),a.moveTo(m[0],m[1]),a.lineTo(r[0],r[1]),a.lineTo(r[0],r[1]-(r[2]-d)*f),a.lineTo(m[0],m[1]-(m[2]-d)*f),a.lineTo(m[0],m[1]),a.fill(),m=r;for(m=e[0],a.beginPath(),a.moveTo(m[0],m[1]-(m[2]-d)*f),o=1;r=e[o];o++)a.lineTo(r[0],r[1]-(r[2]-d)*f);a.stroke(),a.restore()}},function(){ol.layer.Vector.prototype.setTextPathStyle=function(e,t){if(null===e)return this.textPath_&&this.unByKey(this.textPath_),this.textPath_=null,void this.changed();this.textPath_||(this.textPath_=this.on(["postcompose","postrender"],function(e){if(!(e.frameState.viewState.resolution>this.textPathMaxResolution_)){var t,i=e.frameState.extent,s=e.frameState.coordinateToPixelTransform,o=e.context;o.save(),o.scale(e.frameState.pixelRatio,e.frameState.pixelRatio);for(var r,a=this.getSource().getFeaturesInExtent(i),n=0;r=a[n];n++)for(var l,h=this.textPathStyle_(r,e.frameState.viewState.resolution),c=0;l=h[c];c++){var u,d=l.getGeometry()||r.getGeometry();switch(d.getType()){case"LineString":u=d.getCoordinates();break;case"MultiLineString":u=d.getLineString(0).getCoordinates();break;default:continue}var p=l.getText(),g=m(u,p.getRotateWithView());o.font=p.getFont(),o.textBaseline=p.getTextBaseline(),o.textAlign=p.getTextAlign(),o.lineWidth=p.getStroke()&&p.getStroke().getWidth()||0,o.strokeStyle=p.getStroke()&&p.getStroke().getColor()||"#fff",o.fillStyle=p.getFill()&&p.getFill().getColor()||"#000",o.textJustify="justify"==p.getTextAlign(),o.textOverflow=p.getTextOverflow?p.getTextOverflow():"",o.minWidth=p.getMinWidth?p.getMinWidth():0,o.textPath(p.getText()||r.get("name"),g)}o.restore()}function m(e,i){var o=[];for(t=0;t<e.length;t++)o.push(s[0]*e[t][0]+s[1]*e[t][1]+s[4]),o.push(s[2]*e[t][0]+s[3]*e[t][1]+s[5]);if(i&&o[0]>o[o.length-2]){var r=[];for(t=o.length-2;t>=0;t-=2)r.push(o[t]),r.push(o[t+1]);return r}return o}}.bind(this))),void 0===e&&(e=[new ol.style.Style({text:new ol.style.Text})]),this.textPathStyle_="function"==typeof e?e:function(){return e},this.textPathMaxResolution_=Number(t)||Number.MAX_VALUE,this.changed()},ol.style.TextPath=function(e){e||(e={}),ol.style.Text.call(this,e),this.textOverflow_=void 0!==e.textOverflow?e.textOverflow:"visible",this.minWidth_=e.minWidth||0},ol.ext.inherits(ol.style.TextPath,ol.style.Text),ol.style.TextPath.prototype.getTextOverflow=function(){return this.textOverflow_},ol.style.TextPath.prototype.getMinWidth=function(){return this.minWidth_}}(),CanvasRenderingContext2D.prototype.textPath=function(e,t){var i=this;function s(e,t,i,s){var o=i-e,r=s-t;return Math.sqrt(o*o+r*r)}var o,r=0,a=2;function n(e,t){if(!o||r+o<t)for(;a<e.length&&(o=s(e[a-2],e[a-1],e[a],e[a+1]),!(r+o>t))&&!((a+=2)>=e.length);)r+=o;var i,n,l,h=t-r;return a>=e.length&&(a=e.length-2),h?(i=e[a-2]+(e[a]-e[a-2])*h/o,n=e[a-1]+(e[a+1]-e[a-1])*h/o,l=Math.atan2(e[a+1]-e[a-1],e[a]-e[a-2])):(i=e[a-2],n=e[a-1],l=Math.atan2(e[a+1]-e[a-1],e[a]-e[a-2])),[i,n,l]}for(var l=.25*i.measureText(" ").width,h=0,c=0,u=2;u<t.length;u+=2)c+=s(t[u-2],t[u-1],t[u],t[u+1]);if(!(c<i.minWidth)){var d=e.split(" ").length-1;if("visible"!=i.textOverflow&&c<i.measureText(e).width+(e.length-1+d)*l){var p="ellipsis"==i.textOverflow?"…":i.textOverflow;do{d=e.split(" ").length-1,e=e.slice(0,e.length-1)}while(e&&c<i.measureText(e+p).width+(e.length+p.length-1+d)*l);e+=p}switch(i.textJustify||i.textAlign){case!0:case"center":case"end":case"right":i.textJustify?(h=0,l=(c-i.measureText(e).width)/(e.length-1+d)):(h=c-i.measureText(e).width-(e.length+d)*l,"center"==i.textAlign&&(h/=2))}for(var g=0;g<e.length;g++){var m=e[g],f=i.measureText(m).width,v=n(t,h+f/2);i.save(),i.textAlign="center",i.translate(v[0],v[1]),i.rotate(v[2]),i.lineWidth&&i.strokeText(m,0,0),i.fillText(m,0,0),i.restore(),h+=f+l*(" "==m?2:1)}}},ol.style.Shadow=class extends ol.style.RegularShape{constructor(e){super({radius:(e=e||{}).radius,fill:e.fill,displacement:e.displacement,declutterMode:e.declutterMode}),this._fill=e.fill||new ol.style.Fill({color:"rgba(0,0,0,0.5)"}),this._radius=e.radius,this._blur=0===e.blur?0:e.blur||e.radius/3,this._offset=[e.offsetX?e.offsetX:0,e.offsetY?e.offsetY:0],e.displacement||(e.displacement=[e.offsetX||0,-e.offsetY||0]),this.setDisplacement||this.getImage(),this.render()}clone(){var e=new ol.style.Shadow({fill:this._fill,radius:this._radius,blur:this._blur,offsetX:this._offset[0],offsetY:this._offset[1],declutterMode:this.getDeclutterMode?this.getDeclutterMode():null});return e.setScale(this.getScale()),e.setOpacity(this.getOpacity()),e}createRenderOptions(){var e=super.createRenderOptions();return e.shadowOptions=["shadow",this._radius,this._fill,this._blur].join("-"),e}getImage(e){e=e||1;var t=this._radius,i=super.getImage(e),s=i.getContext("2d");if(s.save(),s.resetTransform(),s.clearRect(0,0,i.width,i.height),s.beginPath(),s.setTransform(e,0,0,e,0,0),s.scale(1,.5),s.arc(t,-t,t-this._blur,0,2*Math.PI,!1),s.fillStyle="#000",s.shadowColor=this._fill.getColor(),s.shadowBlur=.7*this._blur*e,s.shadowOffsetX=0,s.shadowOffsetY=1.5*t*e,s.closePath(),s.fill(),s.shadowColor="transparent",s.restore(),!this.getDisplacement){var o=this.getAnchor();o[0]=i.width/2-this._offset[0],o[1]=i.height/2-this._offset[1]}return i}},ol.style.StrokePattern=class extends ol.style.Stroke{constructor(e){var t,i;super(e),e=e||{};var s=this.canvas_=document.createElement("canvas"),o=(Number(e.scale)>0?Number(e.scale):1)*ol.has.DEVICE_PIXEL_RATIO||ol.has.DEVICE_PIXEL_RATIO,r=s.getContext("2d");if(e.image){e.image.load();var a=e.image.getImage();if(a.width)s.width=Math.round(a.width*o),s.height=Math.round(a.height*o),r.globalAlpha="number"==typeof e.opacity?e.opacity:1,r.drawImage(a,0,0,a.width,a.height,0,0,s.width,s.height),t=r.createPattern(s,"repeat");else{var n=this;t=[0,0,0,0],a.onload=function(){s.width=Math.round(a.width*o),s.height=Math.round(a.height*o),r.globalAlpha="number"==typeof e.opacity?e.opacity:1,r.drawImage(a,0,0,a.width,a.height,0,0,s.width,s.height),t=r.createPattern(s,"repeat"),n.setColor(t)}}}else{var l=this.getPattern_(e);if(s.width=Math.round(l.width*o),s.height=Math.round(l.height*o),r.beginPath(),e.fill&&(r.fillStyle=ol.color.asString(e.fill.getColor()),r.fillRect(0,0,s.width,s.height)),r.scale(o,o),r.lineCap="round",r.lineWidth=l.stroke||1,r.fillStyle=ol.color.asString(e.color||"#000"),r.strokeStyle=ol.color.asString(e.color||"#000"),l.circles)for(i=0;i<l.circles.length;i++){var h=l.circles[i];r.beginPath(),r.arc(h[0],h[1],h[2],0,2*Math.PI),l.fill&&r.fill(),l.stroke&&r.stroke()}if(l.repeat||(l.repeat=[[0,0]]),l.char&&(r.font=l.font||l.width+"px Arial",r.textAlign="center",r.textBaseline="middle",l.angle?(r.fillText(l.char,l.width/4,l.height/4),r.fillText(l.char,5*l.width/4,5*l.height/4),r.fillText(l.char,l.width/4,5*l.height/4),r.fillText(l.char,5*l.width/4,l.height/4),r.fillText(l.char,3*l.width/4,3*l.height/4),r.fillText(l.char,-l.width/4,-l.height/4),r.fillText(l.char,3*l.width/4,-l.height/4),r.fillText(l.char,-l.width/4,3*l.height/4)):r.fillText(l.char,l.width/2,l.height/2)),l.lines)for(i=0;i<l.lines.length;i++)for(var c=0;c<l.repeat.length;c++){var u=l.lines[i];r.beginPath(),r.moveTo(u[0]+l.repeat[c][0],u[1]+l.repeat[c][1]);for(var d=2;d<u.length;d+=2)r.lineTo(u[d]+l.repeat[c][0],u[d+1]+l.repeat[c][1]);l.fill&&r.fill(),l.stroke&&r.stroke(),r.save(),r.strokeStyle="red",r.strokeWidth=.1,r.restore()}if(t=r.createPattern(s,"repeat"),e.offset){var p=e.offset;if("number"==typeof p&&(p=[p,p]),p instanceof Array){var g=Math.round(p[0]*o),m=Math.round(p[1]*o);r.scale(1/o,1/o),r.clearRect(0,0,s.width,s.height),r.translate(g,m),r.fillStyle=t,r.fillRect(-g,-m,s.width,s.height),t=r.createPattern(s,"repeat")}}}this.setColor(t)}clone(){var e=super.clone();return e.canvas_=this.canvas_,e}getImage(){return this.canvas_}getPattern_(e){var t,i=ol.style.FillPattern.patterns[e.pattern]||ol.style.FillPattern.patterns.dot,s=Math.round(e.spacing)||10;switch(e.pattern){case"dot":case"circle":t=0===e.size?0:e.size/2||2,e.angle?(s=i.width=i.height=Math.round(1.4*s),i.circles=[[s/4,s/4,t],[3*s/4,3*s/4,t]],"circle"==e.pattern&&(i.circles=i.circles.concat([[s/4+s,s/4,t],[s/4,s/4+s,t],[3*s/4-s,3*s/4,t],[3*s/4,3*s/4-s,t],[s/4+s,s/4+s,t],[3*s/4-s,3*s/4-s,t]]))):(i.width=i.height=s,i.circles=[[s/2,s/2,t]],"circle"==e.pattern&&(i.circles=i.circles.concat([[s/2+s,s/2,t],[s/2-s,s/2,t],[s/2,s/2+s,t],[s/2,s/2-s,t],[s/2+s,s/2+s,t],[s/2+s,s/2-s,t],[s/2-s,s/2+s,t],[s/2-s,s/2-s,t]])));break;case"tile":case"square":t=0===e.size?0:e.size/2||2,e.angle?(i.width=i.height=s,i.lines=[[s/2-t,s/2,s/2,s/2-t,s/2+t,s/2,s/2,s/2+t,s/2-t,s/2]]):(i.width=i.height=s,i.lines=[[s/2-t,s/2-t,s/2+t,s/2-t,s/2+t,s/2+t,s/2-t,s/2+t,s/2-t,s/2-t]]),"square"==e.pattern&&(i.repeat=[[0,0],[0,s],[s,0],[0,-s],[-s,0],[-s,-s],[s,s],[-s,s],[s,-s]]);break;case"cross":e.angle&&(e.angle=45);case"hatch":var o=Math.round(((e.angle||0)-90)%360);o>180&&(o-=360),o*=Math.PI/180;var r=Math.cos(o),a=Math.sin(o);if(Math.abs(a)<1e-4)i.width=i.height=s,i.lines=[[0,.5,s,.5]],i.repeat=[[0,0],[0,s]];else if(Math.abs(r)<1e-4)i.width=i.height=s,i.lines=[[.5,0,.5,s]],i.repeat=[[0,0],[s,0]],"cross"==e.pattern&&(i.lines.push([0,.5,s,.5]),i.repeat.push([0,s]));else{var n=i.width=Math.round(Math.abs(s/a))||1,l=i.height=Math.round(Math.abs(s/r))||1;"cross"==e.pattern?(i.lines=[[-n,-l,2*n,2*l],[2*n,-l,-n,2*l]],i.repeat=[[0,0]]):r*a>0?(i.lines=[[-n,-l,2*n,2*l]],i.repeat=[[0,0],[n,0],[0,l]]):(i.lines=[[2*n,-l,-n,2*l]],i.repeat=[[0,0],[-n,0],[0,l]])}i.stroke=0===e.size?0:e.size||4}return i}},ol.style.Style.defaultStyle,function(){var e=[255,255,255,1],t=[0,153,255,1],i=[new ol.style.Style({stroke:new ol.style.Stroke({color:e,width:5})}),new ol.style.Style({image:new ol.style.Circle({radius:6,fill:new ol.style.Fill({color:t}),stroke:new ol.style.Stroke({color:e,width:1.5})}),stroke:new ol.style.Stroke({color:t,width:3}),fill:new ol.style.Fill({color:[255,255,255,.5]})})];ol.style.Style.defaultStyle=function(e){if(!0===e)return i;e=e||{};var t=new ol.style.Fill({color:e.fillColor||"rgba(255,255,255,0.4)"}),s=new ol.style.Stroke({color:e.color||"#3399CC",width:1.25});return[new ol.style.Style({image:new ol.style.Circle({fill:t,stroke:s,radius:5}),fill:t,stroke:s})]}}(),ol.style.geoportailStyle,function(){var e={},t=0;function i(i){var s="ROUT-"+t+++"-";return function(t,o){var r=!0===i.sens||o<i.sens,a=s+t.get("nature")+"-"+t.get("position_par_rapport_au_sol")+"-"+(r?t.get("sens_de_circulation"):"Sans objet")+"-"+t.get("position_par_rapport_au_sol")+"-"+t.get("importance")+"-"+t.get("largeur_de_chaussee")+"-"+t.get("itineraire_vert"),n=e[a];return n||(n=e[a]=[new ol.style.Style({text:r?function(e){return i.sens&&!/double|sans/i.test(e.get("sens_de_circulation"))?new ol.style.Text({text:"Sens direct"==e.get("sens_de_circulation")?"→":"←",font:"bold 12px sans-serif",placement:"point",textAlign:"center",fill:new ol.style.Fill({color:[0,0,0,.3]}),stroke:new ol.style.Stroke({color:[0,0,0,.3],width:1.5}),rotateWithView:!0}):null}(t):null,stroke:new ol.style.Stroke({color:function(e){if(i.vert&&e.get("itineraire_vert"))return e.get("position_par_rapport_au_sol")<0?[0,128,0,.7]:e.get("position_par_rapport_au_sol")>0?[0,100,0,1]:[0,128,0,1];if(!e.get("importance"))return"magenta";if("Piste cyclable"===e.get("nature"))return[27,177,27,.5];if("0"!=e.get("position_par_rapport_au_sol")){var t;switch(e.get("importance")){case"1":t=[177,27,177,1];break;case"2":t=[177,27,27,1];break;case"3":t=[217,119,0,1];break;case"4":t=[255,225,0,1];break;case"5":t=[204,204,204,1];break;default:t=[211,211,211,1]}return e.get("position_par_rapport_au_sol")<0&&(t[3]=.7),t}switch(e.get("importance")){case"1":return[255,0,255,1];case"2":return[255,0,0,1];case"3":return[255,165,0,1];case"4":return[255,255,0,1];case"5":return[255,255,255,1];default:return[211,211,211,1]}}(t),width:function(e){return Math.max(e.get("largeur_de_chaussee")||2,2)}(t),lineDash:function(e){switch(e.get("nature")){case"Escalier":return[1,4];case"Sentier":return[8,10]}}(t)}),zIndex:function(e){if(!e.get("position_par_rapport_au_sol"))return 100;var t=Number(e.get("position_par_rapport_au_sol"));return t>0?10+10*t-(Number(e.get("importance"))||10):t<0?Math.max(4+t,0):10-(Number(e.get("importance"))||10)}(t)-100})]),n[0].getText()&&n[0].getText().setRotation(function(e){for(var t,i,s=e.getCoordinates(),o=0,r=e.getLength(),a=0;a<s.length-1&&(t=s[a+1][0]-s[a][0],i=s[a+1][1]-s[a][1],!((o+=Math.sqrt(t*t+i*i))>=r/2));a++);return-Math.atan2(i,t)}(t.getGeometry())),n}}var s={111:{color:[230,0,77,255],title:"Continuous urban fabric"},112:{color:[255,0,0,255],title:"Discontinuous urban fabric"},121:{color:[204,77,242,255],title:"Industrial or commercial units"},122:{color:[204,0,0,255],title:"Road and rail networks and associated land"},123:{color:[230,204,204,255],title:"Port areas"},124:{color:[230,204,230,255],title:"Airports"},131:{color:[166,0,204,255],title:"Mineral extraction sites"},132:{color:[166,77,0,255],title:"Dump sites"},133:{color:[255,77,255,255],title:"Construction sites"},141:{color:[255,166,255,255],title:"Green urban areas"},142:{color:[255,230,255,255],title:"Sport and leisure facilities"},211:{color:[255,255,168,255],title:"Non-irrigated arable land"},212:{color:[255,255,0,255],title:"Permanently irrigated land"},213:{color:[230,230,0,255],title:"Rice fields"},221:{color:[230,128,0,255],title:"Vineyards"},222:{color:[242,166,77,255],title:"Fruit trees and berry plantations"},223:{color:[230,166,0,255],title:"Olive groves"},231:{color:[230,230,77,255],title:"Pastures"},241:{color:[255,230,166,255],title:"Annual crops associated with permanent crops"},242:{color:[255,230,77,255],title:"Complex cultivation patterns"},243:{color:[230,204,77,255],title:"Land principally occupied by agriculture with significant areas of natural vegetation"},244:{color:[242,204,166,255],title:"Agro-forestry areas"},311:{color:[128,255,0,255],title:"Broad-leaved forest"},312:{color:[0,166,0,255],title:"Coniferous forest"},313:{color:[77,255,0,255],title:"Mixed forest"},321:{color:[204,242,77,255],title:"Natural grasslands"},322:{color:[166,255,128,255],title:"Moors and heathland"},323:{color:[166,230,77,255],title:"Sclerophyllous vegetation"},324:{color:[166,242,0,255],title:"Transitional woodland-shrub"},331:{color:[230,230,230,255],title:"Beaches dunes sands"},332:{color:[204,204,204,255],title:"Bare rocks"},333:{color:[204,255,204,255],title:"Sparsely vegetated areas"},334:{color:[0,0,0,255],title:"Burnt areas"},335:{color:[166,230,204,255],title:"Glaciers and perpetual snow"},411:{color:[166,166,255,255],title:"Inland marshes"},412:{color:[77,77,255,255],title:"Peat bogs"},421:{color:[204,204,255,255],title:"Salt marshes"},422:{color:[230,230,255,255],title:"Salines"},423:{color:[166,166,230,255],title:"Intertidal flats"},511:{color:[0,204,242,255],title:"Water courses"},512:{color:[128,242,230,255],title:"Water bodies"},521:{color:[0,255,166,255],title:"Coastal lagoons"},522:{color:[166,255,230,255],title:"Estuaries"},523:{color:[230,242,255,255],title:"Sea and ocean"}};ol.style.geoportailStyle=function(o,r){switch(r=r||{},o){case"BDTOPO_V3:troncon_de_route":return i(r);case"BDTOPO_V3:batiment":return function(i){var s="BATI-"+t+++"-";return function(t){if(t.get("detruit"))return[];var o=s+t.get("usage_1")+"-"+t.get("nature")+"-"+t.get("etat_de_l_objet"),r=e[o];if(!r){var a=function(e){switch(e.get("nature")){case"Industriel, agricole ou commercial":return[51,102,153,1];case"Remarquable":return[0,192,0,1];default:switch(e.get("usage_1")){case"Résidentiel":case"Indifférencié":return[128,128,128,1];case"Industriel":case"Commercial et services":return[51,102,153,1];case"Sportif":return[51,153,102,1];case"Religieux":return[153,102,51,1];default:return[153,51,51,1]}}}(t),n=[a[0],a[1],a[1],.5],l=!/en service/i.test(t.get("etat_de_l_objet"));l&&(n[3]=.1);var h=i.symbol?function(e){switch(e.get("usage_1")){case"Commercial et services":return"";case"Sportif":return"";default:return null}}(t):null;return[new ol.style.Style({text:h?new ol.style.Text({text:h,font:"12px FontAwesome",fill:new ol.style.Fill({color:[0,0,0,.6]})}):null,fill:new ol.style.Fill({color:n}),stroke:new ol.style.Stroke({color:a,width:1.5,lineDash:l?[5,5]:null})})]}return r}}(r);case"CADASTRALPARCELS.PARCELLAIRE_EXPRESS:parcelle":return function(e){var t=new ol.style.Style({text:new ol.style.Text({text:"0000",font:"bold 12px sans-serif",fill:new ol.style.Fill({color:[100,0,255,1]}),stroke:new ol.style.Stroke({color:[255,255,255,.8],width:3})}),stroke:new ol.style.Stroke({color:[255,165,0,1],width:1.5}),fill:new ol.style.Fill({color:[100,0,255,.1]})});return function(i,s){return s<.8?t.getText().setFont("bold 12px sans-serif"):t.getText().setFont("bold 10px sans-serif"),e.section?t.getText().setText(i.get("section")+"-"+(i.get("numero")||"").replace(/^0*/,"")):t.getText().setText((i.get("numero")||"").replace(/^0*/,"")),t}}(r);default:return/LANDCOVER/.test(o)?(r.date=o.replace(/[^\d]*(\d*).*/,"$1"),function(t){return function(i){var o=i.get("code_"+t.date),r=e["CLC-"+o];if(!r){var a=s[o].color.slice();a[3]=t.opacity||1,r=e["CLC-"+o]=new ol.style.Style({fill:new ol.style.Fill({color:a||[255,255,255,.5]})})}return r}}(r)):(console.warn("[ol/style/geoportailStyle] no style defined for type: "+o),ol.style.Style.defaultStyle())}},ol.style.geoportailStyle.clcColors=JSON.parse(JSON.stringify(s))}();